#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAMRConnectivity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRDualClip_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRDualContour_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRDualGridHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRFragmentIntegration_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRFragmentsFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVAMRDualClip_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVAMRDualContour_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVAMRFragmentIntegration_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkPVVTKExtensionsAMRCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAMRConnectivity_Init(csi);
  vtkAMRDualClip_Init(csi);
  vtkAMRDualContour_Init(csi);
  vtkAMRDualGridHelper_Init(csi);
  vtkAMRFragmentIntegration_Init(csi);
  vtkAMRFragmentsFilter_Init(csi);
  vtkPVAMRDualClip_Init(csi);
  vtkPVAMRDualContour_Init(csi);
  vtkPVAMRFragmentIntegration_Init(csi);
}
