#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkGenericClip_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericContourFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericCutter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericDataSetTessellator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericGlyph3DFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericOutlineFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericProbeFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericStreamTracer_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersGenericCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkGenericClip_Init(csi);
  vtkGenericContourFilter_Init(csi);
  vtkGenericCutter_Init(csi);
  vtkGenericDataSetTessellator_Init(csi);
  vtkGenericGeometryFilter_Init(csi);
  vtkGenericGlyph3DFilter_Init(csi);
  vtkGenericOutlineFilter_Init(csi);
  vtkGenericProbeFilter_Init(csi);
  vtkGenericStreamTracer_Init(csi);
}
