/* MessageListItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MessageListItem.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <camel/camel.h>
#include <webkit2/webkit2.h>
#include <gio/gio.h>
#include <handy.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define MAIL_MAIN_WINDOW_ACTION_REPLY "reply"
#define MAIL_MAIN_WINDOW_ACTION_REPLY_ALL "reply-all"
#define MAIL_MAIN_WINDOW_ACTION_FORWARD "forward"
#define MAIL_MAIN_WINDOW_ACTION_PRINT "print"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_MESSAGE_LIST_ITEM (mail_message_list_item_get_type ())
#define MAIL_MESSAGE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem))
#define MAIL_MESSAGE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItemClass))
#define MAIL_IS_MESSAGE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MESSAGE_LIST_ITEM))
#define MAIL_IS_MESSAGE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MESSAGE_LIST_ITEM))
#define MAIL_MESSAGE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItemClass))

typedef struct _MailMessageListItem MailMessageListItem;
typedef struct _MailMessageListItemClass MailMessageListItemClass;
typedef struct _MailMessageListItemPrivate MailMessageListItemPrivate;

#define MAIL_TYPE_WEB_VIEW (mail_web_view_get_type ())
#define MAIL_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_WEB_VIEW, MailWebView))
#define MAIL_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_WEB_VIEW, MailWebViewClass))
#define MAIL_IS_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_WEB_VIEW))
#define MAIL_IS_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_WEB_VIEW))
#define MAIL_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_WEB_VIEW, MailWebViewClass))

typedef struct _MailWebView MailWebView;
typedef struct _MailWebViewClass MailWebViewClass;
enum  {
	MAIL_MESSAGE_LIST_ITEM_0_PROPERTY,
	MAIL_MESSAGE_LIST_ITEM_LOADED_PROPERTY,
	MAIL_MESSAGE_LIST_ITEM_MESSAGE_INFO_PROPERTY,
	MAIL_MESSAGE_LIST_ITEM_MIME_MESSAGE_PROPERTY,
	MAIL_MESSAGE_LIST_ITEM_EXPANDED_PROPERTY,
	MAIL_MESSAGE_LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block48Data Block48Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MAIL_TYPE_MESSAGE_LIST (mail_message_list_get_type ())
#define MAIL_MESSAGE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MESSAGE_LIST, MailMessageList))
#define MAIL_MESSAGE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MESSAGE_LIST, MailMessageListClass))
#define MAIL_IS_MESSAGE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MESSAGE_LIST))
#define MAIL_IS_MESSAGE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MESSAGE_LIST))
#define MAIL_MESSAGE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MESSAGE_LIST, MailMessageListClass))

typedef struct _MailMessageList MailMessageList;
typedef struct _MailMessageListClass MailMessageListClass;
typedef struct _MailMessageListItemGetGravatarData MailMessageListItemGetGravatarData;
typedef struct _Block49Data Block49Data;
typedef struct _MailMessageListItemGetMessageData MailMessageListItemGetMessageData;
typedef struct _MailMessageListItemOpenMessageData MailMessageListItemOpenMessageData;
typedef struct _Block50Data Block50Data;

#define TYPE_ATTACHMENT_BUTTON (attachment_button_get_type ())
#define ATTACHMENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ATTACHMENT_BUTTON, AttachmentButton))
#define ATTACHMENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ATTACHMENT_BUTTON, AttachmentButtonClass))
#define IS_ATTACHMENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ATTACHMENT_BUTTON))
#define IS_ATTACHMENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ATTACHMENT_BUTTON))
#define ATTACHMENT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ATTACHMENT_BUTTON, AttachmentButtonClass))

typedef struct _AttachmentButton AttachmentButton;
typedef struct _AttachmentButtonClass AttachmentButtonClass;
typedef struct _Block51Data Block51Data;
#define _camel_content_type_unref0(var) ((var == NULL) ? NULL : (var = (camel_content_type_unref (var), NULL)))
typedef struct _MailMessageListItemParseMimeContentData MailMessageListItemParseMimeContentData;
typedef struct _MailMessageListItemHandleTextMimeData MailMessageListItemHandleTextMimeData;
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _MailMessageListItemHandleInlineMimeData MailMessageListItemHandleInlineMimeData;
typedef struct _MailMessageListItemGetMessageBodyHtmlData MailMessageListItemGetMessageBodyHtmlData;
typedef struct _Block52Data Block52Data;
typedef struct _MailMessageListItemShowFileAnywayData MailMessageListItemShowFileAnywayData;
typedef struct _Block53Data Block53Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _MailMessageListItem {
	GtkListBoxRow parent_instance;
	MailMessageListItemPrivate * priv;
};

struct _MailMessageListItemClass {
	GtkListBoxRowClass parent_class;
};

struct _MailMessageListItemPrivate {
	gboolean _loaded;
	CamelMessageInfo* _message_info;
	CamelMimeMessage* _mime_message;
	MailWebView* web_view;
	GCancellable* loading_cancellable;
	GtkInfoBar* calendar_info_bar;
	GtkInfoBar* blocked_images_infobar;
	GtkRevealer* secondary_revealer;
	GtkStack* header_stack;
	GtkStyleContext* style_context;
	HdyAvatar* avatar;
	GtkFlowBox* attachment_bar;
	GFile* temp_dir;
	gchar* message_content;
	gboolean message_is_html;
	gboolean message_loaded;
	GSettings* settings;
};

struct _Block48Data {
	int _ref_count_;
	MailMessageListItem* self;
	GraniteMessageDialog* print_error_dialog;
};

struct _MailMessageListItemGetGravatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	gchar* address;
	GFileIcon* result;
	gchar* uri;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	HdyAvatar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkStyleContext* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* server_file;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* path;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GFile* local_file;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GCancellable* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GCancellable* _tmp26_;
	GError* e;
	GError* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	GFileIcon* _tmp31_;
	GError* _inner_error0_;
};

struct _Block49Data {
	int _ref_count_;
	MailMessageListItem* self;
	gchar** whitelist;
	gint whitelist_length1;
	gint _whitelist_size_;
	const gchar* sender;
};

struct _MailMessageListItemGetMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	CamelFolder* folder;
	CamelMessageInfo* _tmp0_;
	CamelFolderSummary* _tmp1_;
	CamelFolderSummary* _tmp2_;
	CamelFolderSummary* _tmp3_;
	CamelFolder* _tmp4_;
	CamelFolder* _tmp5_;
	CamelFolder* _tmp6_;
	CamelFolder* _tmp7_;
	CamelMimeMessage* message;
	CamelMimeMessage* _tmp8_;
	CamelFolder* _tmp9_;
	CamelMessageInfo* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GCancellable* _tmp13_;
	CamelMimeMessage* _tmp14_;
	CamelMimeMessage* _tmp15_;
	GError* e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	CamelFolderFlags flags;
	CamelFolder* _tmp18_;
	gboolean _tmp19_;
	GSettings* _tmp20_;
	MailWebView* _tmp21_;
	CamelMimeMessage* _tmp22_;
	Block49Data* _data49_;
	GSettings* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	CamelInternetAddress* from;
	CamelMimeMessage* _tmp26_;
	CamelInternetAddress* _tmp27_;
	CamelInternetAddress* _tmp28_;
	CamelInternetAddress* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	MailWebView* _tmp33_;
	GtkInfoBar* _tmp34_;
	CamelMimeMessage* _tmp35_;
	CamelMimeMessage* _tmp36_;
	CamelMimeMessage* _tmp37_;
	GError* _inner_error0_;
};

struct _MailMessageListItemOpenMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	CamelMimeMessage* message;
	CamelDataWrapper* _tmp0_;
	CamelDataWrapper* _tmp1_;
	const gchar* _tmp2_;
	MailWebView* _tmp3_;
	const gchar* _tmp4_;
	CamelMimeFilterToHTMLFlags flags;
	gchar* html;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	MailWebView* _tmp7_;
	const gchar* _tmp8_;
};

struct _Block50Data {
	int _ref_count_;
	MailMessageListItem* self;
	CamelMimePart* part;
};

struct _Block51Data {
	int _ref_count_;
	Block50Data * _data50_;
	AttachmentButton* button;
};

struct _MailMessageListItemParseMimeContentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	CamelDataWrapper* mime_content;
	CamelMultipart* content;
	CamelMultipart* _tmp0_;
	guint i;
	gboolean _tmp1_;
	Block50Data* _data50_;
	guint _tmp2_;
	CamelMultipart* _tmp3_;
	CamelMultipart* _tmp4_;
	CamelMimePart* _tmp5_;
	CamelMimePart* _tmp6_;
	CamelContentType* field;
	CamelMimePart* _tmp7_;
	CamelContentType* _tmp8_;
	CamelContentType* _tmp9_;
	CamelMimePart* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	CamelMimePart* _tmp13_;
	CamelMimePart* _tmp14_;
	CamelContentDisposition* _tmp15_;
	CamelMimePart* _tmp16_;
	CamelContentType* _tmp17_;
	Block51Data* _data51_;
	CamelMimePart* _tmp18_;
	GCancellable* _tmp19_;
	AttachmentButton* _tmp20_;
	AttachmentButton* _tmp21_;
	GtkFlowBox* _tmp22_;
	AttachmentButton* _tmp23_;
	gboolean _tmp24_;
	CamelMimePart* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_;
	GtkInfoBar* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GtkInfoBar* _tmp32_;
	GtkInfoBar* _tmp33_;
	CamelContentType* _tmp34_;
	const gchar* _tmp35_;
	CamelMimePart* _tmp36_;
	CamelDataWrapper* _tmp37_;
	CamelDataWrapper* _tmp38_;
	CamelContentType* _tmp39_;
	const gchar* _tmp40_;
	CamelMimePart* _tmp41_;
	CamelDataWrapper* _tmp42_;
	CamelDataWrapper* _tmp43_;
};

struct _MailMessageListItemHandleTextMimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	CamelDataWrapper* part;
	CamelContentType* field;
	CamelContentType* _tmp0_;
	CamelContentType* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	CamelContentType* _tmp5_;
	const gchar* _tmp6_;
	GMemoryOutputStream* os;
	GMemoryOutputStream* _tmp7_;
	GMemoryOutputStream* _tmp8_;
	GCancellable* _tmp9_;
	GMemoryOutputStream* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GMemoryOutputStream* _tmp13_;
	CamelContentType* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	CamelContentType* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _MailMessageListItemHandleInlineMimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	CamelMimePart* part;
	const gchar* _tmp0_;
	GByteArray* byte_array;
	GByteArray* _tmp1_;
	CamelStreamMem* os;
	CamelStreamMem* _tmp2_;
	CamelStreamMem* _tmp3_;
	GByteArray* _tmp4_;
	GByteArray* _tmp5_;
	CamelDataWrapper* _tmp6_;
	CamelDataWrapper* _tmp7_;
	CamelStreamMem* _tmp8_;
	GCancellable* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GBytes* bytes;
	GByteArray* _tmp12_;
	GByteArray* _tmp13_;
	GBytes* _tmp14_;
	GMemoryInputStream* inline_stream;
	GBytes* _tmp15_;
	GMemoryInputStream* _tmp16_;
	MailWebView* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GMemoryInputStream* _tmp21_;
	GError* _inner_error0_;
};

struct _MailMessageListItemGetMessageBodyHtmlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	gchar* result;
	MailWebView* _tmp0_;
	gchar* _tmp1_;
};

struct _Block52Data {
	int _ref_count_;
	MailMessageListItem* self;
	GraniteMessageDialog* dialog;
	CamelMimePart* mime_part;
};

struct _MailMessageListItemShowFileAnywayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMessageListItem* self;
	CamelMimePart* mime_part;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* file;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileOutputStream* output_stream;
	GFile* _tmp8_;
	GFileOutputStream* _tmp9_;
	CamelDataWrapper* _tmp10_;
	CamelDataWrapper* _tmp11_;
	GFileOutputStream* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* e;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _Block53Data {
	int _ref_count_;
	MailMessageListItem* self;
	GtkImage* starred_icon;
	GtkMenuButton* actions_menu_button;
	GtkEventBox* header_event_box;
};

static gint MailMessageListItem_private_offset;
static gpointer mail_message_list_item_parent_class = NULL;
static GeeHashMap* mail_message_list_item_avatars;
static GeeHashMap* mail_message_list_item_avatars = NULL;
static GSettings* mail_message_list_item_desktop_settings;
static GSettings* mail_message_list_item_desktop_settings = NULL;

VALA_EXTERN GType mail_message_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMessageListItem, g_object_unref)
VALA_EXTERN GType mail_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailWebView, g_object_unref)
VALA_EXTERN MailMessageListItem* mail_message_list_item_new (CamelMessageInfo* message_info);
VALA_EXTERN MailMessageListItem* mail_message_list_item_construct (GType object_type,
                                                       CamelMessageInfo* message_info);
VALA_EXTERN void mail_message_list_item_print (MailMessageListItem* self);
VALA_EXTERN CamelMessageInfo* mail_message_list_item_get_message_info (MailMessageListItem* self);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void ___lambda65_ (Block48Data* _data48_);
static void ____lambda65__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void mail_message_list_item_on_mouse_target_changed (MailMessageListItem* self,
                                                     WebKitWebView* web_view,
                                                     WebKitHitTestResult* hit_test,
                                                     guint mods);
VALA_EXTERN GType mail_message_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMessageList, g_object_unref)
static gboolean mail_message_list_item_on_webview_context_menu (MailMessageListItem* self,
                                                         WebKitContextMenu* menu,
                                                         GdkEvent* event,
                                                         WebKitHitTestResult* hit_test);
static void mail_message_list_item_get_gravatar_data_free (gpointer _data);
static void mail_message_list_item_get_gravatar (MailMessageListItem* self,
                                          const gchar* address,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static GFileIcon* mail_message_list_item_get_gravatar_finish (MailMessageListItem* self,
                                                       GAsyncResult* _res_);
static gboolean mail_message_list_item_get_gravatar_co (MailMessageListItemGetGravatarData* _data_);
static void mail_message_list_item_get_gravatar_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void mail_message_list_item_get_message_data_free (gpointer _data);
static void mail_message_list_item_get_message (MailMessageListItem* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void mail_message_list_item_get_message_finish (MailMessageListItem* self,
                                                GAsyncResult* _res_);
static gboolean mail_message_list_item_get_message_co (MailMessageListItemGetMessageData* _data_);
static void mail_message_list_item_get_message_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN void mail_web_view_load_images (MailWebView* self);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void ____lambda66_ (Block49Data* _data49_,
                    gint id);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _____lambda66__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self);
static void mail_message_list_item_set_mime_message (MailMessageListItem* self,
                                              CamelMimeMessage* value);
static void mail_message_list_item_open_message (MailMessageListItem* self,
                                          CamelMimeMessage* message,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void mail_message_list_item_open_message_finish (MailMessageListItem* self,
                                                 GAsyncResult* _res_);
static void mail_message_list_item_open_message_data_free (gpointer _data);
static gboolean mail_message_list_item_open_message_co (MailMessageListItemOpenMessageData* _data_);
static void mail_message_list_item_parse_mime_content (MailMessageListItem* self,
                                                CamelDataWrapper* mime_content,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void mail_message_list_item_parse_mime_content_finish (MailMessageListItem* self,
                                                       GAsyncResult* _res_);
static void mail_message_list_item_open_message_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN void mail_web_view_load_html (MailWebView* self,
                              const gchar* body);
static void mail_message_list_item_parse_mime_content_data_free (gpointer _data);
static gboolean mail_message_list_item_parse_mime_content_co (MailMessageListItemParseMimeContentData* _data_);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static void mail_message_list_item_handle_inline_mime (MailMessageListItem* self,
                                                CamelMimePart* part,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void mail_message_list_item_handle_inline_mime_finish (MailMessageListItem* self,
                                                       GAsyncResult* _res_);
static void mail_message_list_item_parse_mime_content_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
VALA_EXTERN GType attachment_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AttachmentButton, g_object_unref)
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
VALA_EXTERN AttachmentButton* attachment_button_new (CamelMimePart* mime_part,
                                         GCancellable* loading_cancellable);
VALA_EXTERN AttachmentButton* attachment_button_construct (GType object_type,
                                               CamelMimePart* mime_part,
                                               GCancellable* loading_cancellable);
static void ________lambda71_ (Block51Data* _data51_);
static void mail_message_list_item_show_attachment (MailMessageListItem* self,
                                             CamelMimePart* mime_part);
VALA_EXTERN CamelMimePart* attachment_button_get_mime_part (AttachmentButton* self);
static void _________lambda71__gtk_flow_box_child_activate (GtkFlowBoxChild* _sender,
                                                     gpointer self);
static void _________lambda73_ (Block51Data* _data51_);
static void __________lambda73__gtk_info_bar_response (GtkInfoBar* _sender,
                                                gint response_id,
                                                gpointer self);
static void mail_message_list_item_handle_text_mime (MailMessageListItem* self,
                                              CamelDataWrapper* part,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void mail_message_list_item_handle_text_mime_finish (MailMessageListItem* self,
                                                     GAsyncResult* _res_);
static void mail_message_list_item_handle_text_mime_data_free (gpointer _data);
static gboolean mail_message_list_item_handle_text_mime_co (MailMessageListItemHandleTextMimeData* _data_);
static void mail_message_list_item_handle_text_mime_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static gchar* mail_message_list_item_convert_to_utf8 (GMemoryOutputStream* os,
                                               const gchar* encoding);
static void mail_message_list_item_handle_inline_mime_data_free (gpointer _data);
static gboolean mail_message_list_item_handle_inline_mime_co (MailMessageListItemHandleInlineMimeData* _data_);
static void mail_message_list_item_handle_inline_mime_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
VALA_EXTERN void mail_web_view_add_internal_resource (MailWebView* self,
                                          const gchar* uri,
                                          GInputStream* data);
static void mail_message_list_item_get_message_body_html_data_free (gpointer _data);
VALA_EXTERN void mail_message_list_item_get_message_body_html (MailMessageListItem* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar* mail_message_list_item_get_message_body_html_finish (MailMessageListItem* self,
                                                            GAsyncResult* _res_);
static gboolean mail_message_list_item_get_message_body_html_co (MailMessageListItemGetMessageBodyHtmlData* _data_);
VALA_EXTERN void mail_web_view_get_body_html (MailWebView* self,
                                  gboolean clean_for_sending,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN gchar* mail_web_view_get_body_html_finish (MailWebView* self,
                                           GAsyncResult* _res_);
static void mail_message_list_item_get_message_body_html_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void __lambda72_ (Block52Data* _data52_,
                  gint response_id);
static void mail_message_list_item_show_file_anyway (MailMessageListItem* self,
                                              CamelMimePart* mime_part,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void mail_message_list_item_show_file_anyway_finish (MailMessageListItem* self,
                                                     GAsyncResult* _res_);
static void ___lambda72__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void mail_message_list_item_show_file_anyway_data_free (gpointer _data);
static gboolean mail_message_list_item_show_file_anyway_co (MailMessageListItemShowFileAnywayData* _data_);
static void mail_message_list_item_show_file_anyway_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
VALA_EXTERN gboolean mail_message_list_item_get_loaded (MailMessageListItem* self);
static void mail_message_list_item_set_loaded (MailMessageListItem* self,
                                        gboolean value);
static void mail_message_list_item_set_message_info (MailMessageListItem* self,
                                              CamelMessageInfo* value);
VALA_EXTERN CamelMimeMessage* mail_message_list_item_get_mime_message (MailMessageListItem* self);
VALA_EXTERN gboolean mail_message_list_item_get_expanded (MailMessageListItem* self);
VALA_EXTERN void mail_message_list_item_set_expanded (MailMessageListItem* self,
                                          gboolean value);
static GObject * mail_message_list_item_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
static GVariant* _variant_new24 (const gchar* value);
static GVariant* _variant_new25 (const gchar* value);
static GVariant* _variant_new26 (const gchar* value);
static GVariant* _variant_new27 (const gchar* value);
VALA_EXTERN MailWebView* mail_web_view_new (void);
VALA_EXTERN MailWebView* mail_web_view_construct (GType object_type);
VALA_EXTERN void mail_web_view_set_bind_height_to_page_height (MailWebView* self,
                                                   gboolean value);
static void _mail_message_list_item_on_mouse_target_changed_webkit_web_view_mouse_target_changed (WebKitWebView* _sender,
                                                                                           WebKitHitTestResult* hit_test_result,
                                                                                           guint modifiers,
                                                                                           gpointer self);
static gboolean _mail_message_list_item_on_webview_context_menu_webkit_web_view_context_menu (WebKitWebView* _sender,
                                                                                       WebKitContextMenu* context_menu,
                                                                                       GdkEvent* event,
                                                                                       WebKitHitTestResult* hit_test_result,
                                                                                       gpointer self);
static void _mail_message_list_item___lambda74_ (MailMessageListItem* self);
static void __mail_message_list_item___lambda74__mail_web_view_load_finished (MailWebView* _sender,
                                                                       gpointer self);
static void _mail_message_list_item____lambda75_ (MailMessageListItem* self,
                                           GObject* obj,
                                           GAsyncResult* res);
static void __mail_message_list_item____lambda75__gasync_ready_callback (GObject* source_object,
                                                                  GAsyncResult* res,
                                                                  gpointer self);
static gboolean _mail_message_list_item___lambda76_ (Block53Data* _data53_,
                                              GdkEventButton* event);
static gboolean __mail_message_list_item___lambda76__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                               GdkEventButton* event,
                                                                               gpointer self);
static gboolean _mail_message_list_item___lambda77_ (Block53Data* _data53_,
                                              GdkEventCrossing* event);
static gboolean __mail_message_list_item___lambda77__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self);
static gboolean _mail_message_list_item___lambda78_ (Block53Data* _data53_,
                                              GdkEventCrossing* event);
static gboolean __mail_message_list_item___lambda78__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self);
static gboolean _mail_message_list_item___lambda79_ (MailMessageListItem* self,
                                              GdkEventButton* event);
static gboolean __mail_message_list_item___lambda79__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                               GdkEventButton* event,
                                                                               gpointer self);
static void _mail_message_list_item___lambda80_ (MailMessageListItem* self);
static void __mail_message_list_item___lambda80__gtk_widget_destroy (GtkWidget* _sender,
                                                              gpointer self);
static gboolean _mail_message_list_item___lambda81_ (Block53Data* _data53_);
static gboolean __mail_message_list_item___lambda81__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                               GdkEventButton* event,
                                                                               gpointer self);
static void _mail_message_list_item___lambda82_ (MailMessageListItem* self);
static void __mail_message_list_item___lambda82__mail_web_view_image_load_blocked (MailWebView* _sender,
                                                                            gpointer self);
static void _mail_message_list_item___lambda83_ (MailMessageListItem* self,
                                          const gchar* uri);
static void __mail_message_list_item___lambda83__mail_web_view_link_activated (MailWebView* _sender,
                                                                        const gchar* url,
                                                                        gpointer self);
static void mail_message_list_item_finalize (GObject * obj);
static GType mail_message_list_item_get_type_once (void);
static void _vala_mail_message_list_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_mail_message_list_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mail_message_list_item_get_instance_private (MailMessageListItem* self)
{
	return G_STRUCT_MEMBER_P (self, MailMessageListItem_private_offset);
}

MailMessageListItem*
mail_message_list_item_construct (GType object_type,
                                  CamelMessageInfo* message_info)
{
	MailMessageListItem * self = NULL;
	g_return_val_if_fail (message_info != NULL, NULL);
	self = (MailMessageListItem*) g_object_new (object_type, "margin-top", 12, "margin-bottom", 12, "margin-start", 12, "margin-end", 12, "message-info", message_info, NULL);
	return self;
}

MailMessageListItem*
mail_message_list_item_new (CamelMessageInfo* message_info)
{
	return mail_message_list_item_construct (MAIL_TYPE_MESSAGE_LIST_ITEM, message_info);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		MailMessageListItem* self;
		self = _data48_->self;
		_g_object_unref0 (_data48_->print_error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda65_ (Block48Data* _data48_)
{
	MailMessageListItem* self;
	GraniteMessageDialog* _tmp0_;
	self = _data48_->self;
	_tmp0_ = _data48_->print_error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda65__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda65_ (self);
}

void
mail_message_list_item_print (MailMessageListItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkPrintSettings* settings = NULL;
		GtkPrintSettings* _tmp0_;
		gchar* filename = NULL;
		gchar* _tmp1_;
		const gchar* subject = NULL;
		CamelMessageInfo* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		GtkPrintSettings* _tmp24_;
		const gchar* _tmp25_;
		WebKitPrintOperation* print_operation = NULL;
		MailWebView* _tmp26_;
		WebKitPrintOperation* _tmp27_;
		WebKitPrintOperation* _tmp28_;
		GtkPrintSettings* _tmp29_;
		WebKitPrintOperation* _tmp30_;
		GtkWidget* _tmp31_;
		_tmp0_ = gtk_print_settings_new ();
		settings = _tmp0_;
		_tmp1_ = g_strdup (_ ("Email Message"));
		filename = _tmp1_;
		_tmp2_ = self->priv->_message_info;
		_tmp3_ = camel_message_info_get_subject (_tmp2_);
		_tmp4_ = _tmp3_;
		subject = _tmp4_;
		_tmp6_ = subject;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = subject;
			_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GRegex* _tmp8_ = NULL;
			GRegex* _tmp9_;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* sanitized_subject = NULL;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp9_ = g_regex_new ("[[:space:][:cntrl:]/]+", 0, 0, &_inner_error0_);
			_tmp8_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (filename);
				_g_object_unref0 (settings);
				goto __catch0_g_error;
			}
			_tmp11_ = subject;
			_tmp12_ = g_regex_replace (_tmp8_, _tmp11_, (gssize) -1, 0, " ", 0, &_inner_error0_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (_tmp8_);
				_g_free0 (filename);
				_g_object_unref0 (settings);
				goto __catch0_g_error;
			}
			_tmp13_ = string_strip (_tmp10_);
			sanitized_subject = _tmp13_;
			_tmp14_ = sanitized_subject;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ <= 64) {
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = sanitized_subject;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (filename);
				filename = _tmp18_;
			} else {
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp19_ = sanitized_subject;
				_tmp20_ = sanitized_subject;
				_tmp21_ = string_substring (_tmp19_, (glong) 0, (glong) g_utf8_strlen (_tmp20_, (gssize) (64 - 1)));
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf ("%s…", _tmp22_);
				_g_free0 (filename);
				filename = _tmp23_;
				_g_free0 (_tmp22_);
			}
			_g_free0 (sanitized_subject);
			_g_free0 (_tmp10_);
			_g_regex_unref0 (_tmp8_);
		}
		_tmp24_ = settings;
		_tmp25_ = filename;
		gtk_print_settings_set (_tmp24_, GTK_PRINT_SETTINGS_OUTPUT_BASENAME, _tmp25_);
		_tmp26_ = self->priv->web_view;
		_tmp27_ = webkit_print_operation_new ((WebKitWebView*) _tmp26_);
		print_operation = _tmp27_;
		_tmp28_ = print_operation;
		_tmp29_ = settings;
		webkit_print_operation_set_print_settings (_tmp28_, _tmp29_);
		_tmp30_ = print_operation;
		_tmp31_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		webkit_print_operation_run_dialog (_tmp30_, (GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_application_window_get_type (), GtkApplicationWindow));
		_g_object_unref0 (print_operation);
		_g_free0 (filename);
		_g_object_unref0 (settings);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block48Data* _data48_;
		GThemedIcon* _tmp32_;
		GtkWidget* _tmp33_;
		GtkWindow* _tmp34_;
		GraniteMessageDialog* _tmp35_ = NULL;
		GraniteMessageDialog* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		GraniteMessageDialog* _tmp39_;
		GraniteMessageDialog* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data48_ = g_slice_new0 (Block48Data);
		_data48_->_ref_count_ = 1;
		_data48_->self = g_object_ref (self);
		_tmp32_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp33_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_window_get_type (), GtkWindow));
		_tmp35_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable to print email"), "", "printer", GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp35_, (GIcon*) _tmp32_);
		_g_object_unref0 (_tmp32_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp35_, _tmp34_);
		_g_object_unref0 (_tmp34_);
		g_object_ref_sink (_tmp35_);
		_data48_->print_error_dialog = _tmp35_;
		_tmp36_ = _data48_->print_error_dialog;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		granite_message_dialog_show_error_details (_tmp36_, _tmp38_);
		_tmp39_ = _data48_->print_error_dialog;
		gtk_window_present ((GtkWindow*) _tmp39_);
		_tmp40_ = _data48_->print_error_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp40_, "response", (GCallback) ____lambda65__gtk_dialog_response, block48_data_ref (_data48_), (GClosureNotify) block48_data_unref, 0);
		_g_error_free0 (e);
		block48_data_unref (_data48_);
		_data48_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
mail_message_list_item_on_mouse_target_changed (MailMessageListItem* self,
                                                WebKitWebView* web_view,
                                                WebKitHitTestResult* hit_test,
                                                guint mods)
{
	MailMessageList* message_list = NULL;
	GtkWidget* _tmp0_;
	MailMessageList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (web_view != NULL);
	g_return_if_fail (hit_test != NULL);
	_tmp0_ = gtk_widget_get_ancestor ((GtkWidget*) self, MAIL_TYPE_MESSAGE_LIST);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, MAIL_TYPE_MESSAGE_LIST, MailMessageList));
	message_list = _tmp1_;
	if (webkit_hit_test_result_context_is_link (hit_test)) {
		MailMessageList* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = message_list;
		_tmp3_ = webkit_hit_test_result_get_link_label (hit_test);
		_tmp4_ = webkit_hit_test_result_get_link_uri (hit_test);
		g_signal_emit_by_name (_tmp2_, "hovering-over-link", _tmp3_, _tmp4_);
	} else {
		MailMessageList* _tmp5_;
		_tmp5_ = message_list;
		g_signal_emit_by_name (_tmp5_, "hovering-over-link", NULL, NULL);
	}
	_g_object_unref0 (message_list);
}

static gboolean
mail_message_list_item_on_webview_context_menu (MailMessageListItem* self,
                                                WebKitContextMenu* menu,
                                                GdkEvent* event,
                                                WebKitHitTestResult* hit_test)
{
	WebKitContextMenu* new_context_menu = NULL;
	WebKitContextMenu* _tmp0_;
	WebKitContextMenu* _tmp8_;
	GList* _tmp9_;
	WebKitContextMenuItem* _tmp12_;
	WebKitContextMenuItem* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (menu != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (hit_test != NULL, FALSE);
	_tmp0_ = webkit_context_menu_new ();
	new_context_menu = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				WebKitContextMenuItem* item = NULL;
				WebKitContextMenuItem* _tmp3_;
				WebKitContextMenuItem* _tmp4_;
				WebKitContextMenuItem* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < webkit_context_menu_get_n_items (menu))) {
					break;
				}
				_tmp3_ = webkit_context_menu_get_item_at_position (menu, (guint) i);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				item = _tmp4_;
				_tmp5_ = item;
				switch (webkit_context_menu_item_get_stock_action (_tmp5_)) {
					case WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD:
					case WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD:
					case WEBKIT_CONTEXT_MENU_ACTION_COPY:
					{
						WebKitContextMenu* _tmp6_;
						WebKitContextMenuItem* _tmp7_;
						_tmp6_ = new_context_menu;
						_tmp7_ = item;
						webkit_context_menu_append (_tmp6_, _tmp7_);
						break;
					}
					default:
					{
						break;
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	webkit_context_menu_remove_all (menu);
	_tmp8_ = new_context_menu;
	_tmp9_ = webkit_context_menu_get_items (_tmp8_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp9_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			WebKitContextMenuItem* _tmp10_;
			WebKitContextMenuItem* item = NULL;
			_tmp10_ = _g_object_ref0 ((WebKitContextMenuItem*) item_it->data);
			item = _tmp10_;
			{
				WebKitContextMenuItem* _tmp11_;
				_tmp11_ = item;
				webkit_context_menu_append (menu, _tmp11_);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp12_ = webkit_context_menu_item_new_from_stock_action (WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	webkit_context_menu_append (menu, _tmp13_);
	_g_object_unref0 (_tmp13_);
	result = FALSE;
	_g_object_unref0 (new_context_menu);
	return result;
}

static void
mail_message_list_item_get_gravatar_data_free (gpointer _data)
{
	MailMessageListItemGetGravatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->address);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemGetGravatarData, _data_);
}

static void
mail_message_list_item_get_gravatar (MailMessageListItem* self,
                                     const gchar* address,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	MailMessageListItemGetGravatarData* _data_;
	MailMessageListItem* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_data_ = g_slice_new0 (MailMessageListItemGetGravatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_get_gravatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (address);
	_g_free0 (_data_->address);
	_data_->address = _tmp1_;
	mail_message_list_item_get_gravatar_co (_data_);
}

static GFileIcon*
mail_message_list_item_get_gravatar_finish (MailMessageListItem* self,
                                            GAsyncResult* _res_)
{
	GFileIcon* result;
	MailMessageListItemGetGravatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
mail_message_list_item_get_gravatar_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	MailMessageListItemGetGravatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_get_gravatar_co (_data_);
}

static gboolean
mail_message_list_item_get_gravatar_co (MailMessageListItemGetGravatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = string_strip (_data_->address);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_utf8_strdown (_data_->_tmp1_, (gssize) -1);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _data_->_tmp3_, (gsize) -1);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->avatar;
	_data_->_tmp7_ = hdy_avatar_get_size (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _data_->self);
	_data_->_tmp10_ = g_strdup_printf ("http://www.gravatar.com/avatar/%s?d=404&s=%d", _data_->_tmp5_, _data_->_tmp8_ * gtk_style_context_get_scale (_data_->_tmp9_));
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp3_);
	_g_free0 (_data_->_tmp1_);
	_data_->uri = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->uri;
	_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
	_data_->server_file = _data_->_tmp13_;
	_data_->_tmp14_ = g_get_tmp_dir ();
	_data_->_tmp15_ = _data_->server_file;
	_data_->_tmp16_ = g_file_get_basename (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = g_build_filename (_data_->_tmp14_, _data_->_tmp17_, NULL);
	_data_->_tmp19_ = _data_->_tmp18_;
	_g_free0 (_data_->_tmp17_);
	_data_->path = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->path;
	_data_->_tmp21_ = g_file_new_for_path (_data_->_tmp20_);
	_data_->local_file = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->local_file;
	_data_->_tmp23_ = _data_->self->priv->loading_cancellable;
	if (!g_file_query_exists (_data_->_tmp22_, _data_->_tmp23_)) {
		{
			_data_->_tmp24_ = _data_->server_file;
			_data_->_tmp25_ = _data_->local_file;
			_data_->_tmp26_ = _data_->self->priv->loading_cancellable;
			_data_->_state_ = 1;
			g_file_copy_async (_data_->_tmp24_, _data_->_tmp25_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, _data_->_tmp26_, NULL, NULL, mail_message_list_item_get_gravatar_ready, _data_);
			return FALSE;
			_state_1:
			g_file_copy_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp27_ = _data_->e;
			if (!g_error_matches (_data_->_tmp27_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp28_ = _data_->e;
				_data_->_tmp29_ = _data_->_tmp28_->message;
				g_warning ("MessageListItem.vala:509: %s", _data_->_tmp29_);
			}
			_data_->result = NULL;
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->local_file);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->server_file);
			_g_free0 (_data_->uri);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->local_file);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->server_file);
			_g_free0 (_data_->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp30_ = _data_->local_file;
	_data_->_tmp31_ = (GFileIcon*) g_file_icon_new (_data_->_tmp30_);
	_data_->result = _data_->_tmp31_;
	_g_object_unref0 (_data_->local_file);
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->server_file);
	_g_free0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_message_list_item_get_message_data_free (gpointer _data)
{
	MailMessageListItemGetMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemGetMessageData, _data_);
}

static void
mail_message_list_item_get_message (MailMessageListItem* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	MailMessageListItemGetMessageData* _data_;
	MailMessageListItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailMessageListItemGetMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_get_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_message_list_item_get_message_co (_data_);
}

static void
mail_message_list_item_get_message_finish (MailMessageListItem* self,
                                           GAsyncResult* _res_)
{
	MailMessageListItemGetMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_message_list_item_get_message_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	MailMessageListItemGetMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_get_message_co (_data_);
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		MailMessageListItem* self;
		self = _data49_->self;
		_data49_->whitelist = (_vala_array_free (_data49_->whitelist, _data49_->whitelist_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
____lambda66_ (Block49Data* _data49_,
               gint id)
{
	MailMessageListItem* self;
	MailWebView* _tmp6_;
	GtkInfoBar* _tmp7_;
	self = _data49_->self;
	if (id == 2) {
		const gchar* _tmp0_;
		gchar** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = _data49_->sender;
		_tmp1_ = _data49_->whitelist;
		_tmp1__length1 = _data49_->whitelist_length1;
		if (!_vala_string_array_contains (_tmp1_, _tmp1__length1, _tmp0_)) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			GSettings* _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			_tmp2_ = _data49_->sender;
			_tmp3_ = g_strdup (_tmp2_);
			_vala_array_add9 (&_data49_->whitelist, &_data49_->whitelist_length1, &_data49_->_whitelist_size_, _tmp3_);
			_tmp4_ = self->priv->settings;
			_tmp5_ = _data49_->whitelist;
			_tmp5__length1 = _data49_->whitelist_length1;
			g_settings_set_strv (_tmp4_, "remote-images-whitelist", _tmp5_);
		}
	}
	_tmp6_ = self->priv->web_view;
	mail_web_view_load_images (_tmp6_);
	_tmp7_ = self->priv->blocked_images_infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
}

static void
_____lambda66__gtk_info_bar_response (GtkInfoBar* _sender,
                                      gint response_id,
                                      gpointer self)
{
	____lambda66_ (self, response_id);
}

static gboolean
mail_message_list_item_get_message_co (MailMessageListItemGetMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_message_info;
	g_object_get (_data_->_tmp0_, "summary", &_data_->_tmp1_, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = camel_folder_summary_get_folder (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->folder = _data_->_tmp7_;
	_data_->message = NULL;
	{
		_data_->_tmp9_ = _data_->folder;
		_data_->_tmp10_ = _data_->self->priv->_message_info;
		_data_->_tmp11_ = camel_message_info_get_uid (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = _data_->self->priv->loading_cancellable;
		_data_->_state_ = 1;
		camel_folder_get_message (_data_->_tmp9_, _data_->_tmp12_, G_PRIORITY_DEFAULT, _data_->_tmp13_, mail_message_list_item_get_message_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp14_ = camel_folder_get_message_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp8_);
		_g_object_unref0 (_data_->message);
		_data_->message = _data_->_tmp15_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("MessageListItem.vala:524: Could not get message. %s", _data_->_tmp17_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->folder;
	_data_->flags = (CamelFolderFlags) camel_folder_get_flags (_data_->_tmp18_);
	if (!((_data_->flags & CAMEL_FOLDER_IS_JUNK) == CAMEL_FOLDER_IS_JUNK)) {
		_data_->_tmp20_ = _data_->self->priv->settings;
		_data_->_tmp19_ = g_settings_get_boolean (_data_->_tmp20_, "always-load-remote-images");
	} else {
		_data_->_tmp19_ = FALSE;
	}
	if (_data_->_tmp19_) {
		_data_->_tmp21_ = _data_->self->priv->web_view;
		mail_web_view_load_images (_data_->_tmp21_);
	} else {
		_data_->_tmp22_ = _data_->message;
		if (_data_->_tmp22_ != NULL) {
			_data_->_data49_ = g_slice_new0 (Block49Data);
			_data_->_data49_->_ref_count_ = 1;
			_data_->_data49_->self = g_object_ref (_data_->self);
			_data_->_tmp23_ = _data_->self->priv->settings;
			_data_->_tmp25_ = _data_->_tmp24_ = g_settings_get_strv (_data_->_tmp23_, "remote-images-whitelist");
			_data_->_data49_->whitelist = _data_->_tmp25_;
			_data_->_data49_->whitelist_length1 = _vala_array_length (_data_->_tmp24_);
			_data_->_data49_->_whitelist_size_ = _data_->_data49_->whitelist_length1;
			_data_->_tmp26_ = _data_->message;
			_data_->_tmp27_ = camel_mime_message_get_from (_data_->_tmp26_);
			_data_->from = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->from;
			if (_data_->_tmp28_ == NULL) {
				block49_data_unref (_data_->_data49_);
				_data_->_data49_ = NULL;
				_g_object_unref0 (_data_->message);
				_g_object_unref0 (_data_->folder);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp29_ = _data_->from;
			_data_->_tmp30_ = NULL;
			camel_internet_address_get (_data_->_tmp29_, 0, NULL, &_data_->_tmp30_);
			_data_->_data49_->sender = _data_->_tmp30_;
			_data_->_tmp31_ = _data_->_data49_->sender;
			_data_->_tmp32_ = _data_->_data49_->whitelist;
			_data_->_tmp32__length1 = _data_->_data49_->whitelist_length1;
			if (_vala_string_array_contains (_data_->_tmp32_, _data_->_tmp32__length1, _data_->_tmp31_)) {
				_data_->_tmp33_ = _data_->self->priv->web_view;
				mail_web_view_load_images (_data_->_tmp33_);
			}
			_data_->_tmp34_ = _data_->self->priv->blocked_images_infobar;
			g_signal_connect_data (_data_->_tmp34_, "response", (GCallback) _____lambda66__gtk_info_bar_response, block49_data_ref (_data_->_data49_), (GClosureNotify) block49_data_unref, 0);
			block49_data_unref (_data_->_data49_);
			_data_->_data49_ = NULL;
		}
	}
	_data_->_tmp35_ = _data_->message;
	if (_data_->_tmp35_ != NULL) {
		_data_->_tmp36_ = _data_->message;
		mail_message_list_item_set_mime_message (_data_->self, _data_->_tmp36_);
		_data_->_tmp37_ = _data_->message;
		_data_->_state_ = 2;
		mail_message_list_item_open_message (_data_->self, _data_->_tmp37_, mail_message_list_item_get_message_ready, _data_);
		return FALSE;
		_state_2:
		mail_message_list_item_open_message_finish (_data_->self, _data_->_res_);
	}
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->folder);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_message_list_item_open_message_data_free (gpointer _data)
{
	MailMessageListItemOpenMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemOpenMessageData, _data_);
}

static void
mail_message_list_item_open_message (MailMessageListItem* self,
                                     CamelMimeMessage* message,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	MailMessageListItemOpenMessageData* _data_;
	MailMessageListItem* _tmp0_;
	CamelMimeMessage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (MailMessageListItemOpenMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_open_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	mail_message_list_item_open_message_co (_data_);
}

static void
mail_message_list_item_open_message_finish (MailMessageListItem* self,
                                            GAsyncResult* _res_)
{
	MailMessageListItemOpenMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_message_list_item_open_message_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	MailMessageListItemOpenMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_open_message_co (_data_);
}

static gboolean
mail_message_list_item_open_message_co (MailMessageListItemOpenMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = camel_medium_get_content ((CamelMedium*) _data_->message);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	mail_message_list_item_parse_mime_content (_data_->self, _data_->_tmp1_, mail_message_list_item_open_message_ready, _data_);
	return FALSE;
	_state_1:
	mail_message_list_item_parse_mime_content_finish (_data_->self, _data_->_res_);
	_data_->_tmp2_ = _data_->self->priv->message_content;
	if (_data_->_tmp2_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->message_is_html) {
		_data_->_tmp3_ = _data_->self->priv->web_view;
		_data_->_tmp4_ = _data_->self->priv->message_content;
		mail_web_view_load_html (_data_->_tmp3_, _data_->_tmp4_);
	} else {
		_data_->flags = ((CAMEL_MIME_FILTER_TOHTML_CONVERT_NL | CAMEL_MIME_FILTER_TOHTML_CONVERT_SPACES) | CAMEL_MIME_FILTER_TOHTML_CONVERT_URLS) | CAMEL_MIME_FILTER_TOHTML_CONVERT_ADDRESSES;
		_data_->_tmp5_ = _data_->self->priv->message_content;
		_data_->_tmp6_ = camel_text_to_html (_data_->_tmp5_, _data_->flags, (guint32) 0);
		_data_->html = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->self->priv->web_view;
		_data_->_tmp8_ = _data_->html;
		mail_web_view_load_html (_data_->_tmp7_, _data_->_tmp8_);
		_g_free0 (_data_->html);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_message_list_item_parse_mime_content_data_free (gpointer _data)
{
	MailMessageListItemParseMimeContentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mime_content);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemParseMimeContentData, _data_);
}

static void
mail_message_list_item_parse_mime_content (MailMessageListItem* self,
                                           CamelDataWrapper* mime_content,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	MailMessageListItemParseMimeContentData* _data_;
	MailMessageListItem* _tmp0_;
	CamelDataWrapper* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_content != NULL);
	_data_ = g_slice_new0 (MailMessageListItemParseMimeContentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_parse_mime_content_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mime_content);
	_g_object_unref0 (_data_->mime_content);
	_data_->mime_content = _tmp1_;
	mail_message_list_item_parse_mime_content_co (_data_);
}

static void
mail_message_list_item_parse_mime_content_finish (MailMessageListItem* self,
                                                  GAsyncResult* _res_)
{
	MailMessageListItemParseMimeContentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		MailMessageListItem* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->part);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static gpointer
_camel_content_type_ref0 (gpointer self)
{
	return self ? camel_content_type_ref (self) : NULL;
}

static void
mail_message_list_item_parse_mime_content_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	MailMessageListItemParseMimeContentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_parse_mime_content_co (_data_);
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		MailMessageListItem* self;
		self = _data51_->_data50_->self;
		_g_object_unref0 (_data51_->button);
		block50_data_unref (_data51_->_data50_);
		_data51_->_data50_ = NULL;
		g_slice_free (Block51Data, _data51_);
	}
}

static void
________lambda71_ (Block51Data* _data51_)
{
	Block50Data* _data50_;
	MailMessageListItem* self;
	AttachmentButton* _tmp0_;
	CamelMimePart* _tmp1_;
	CamelMimePart* _tmp2_;
	_data50_ = _data51_->_data50_;
	self = _data50_->self;
	_tmp0_ = _data51_->button;
	_tmp1_ = attachment_button_get_mime_part (_tmp0_);
	_tmp2_ = _tmp1_;
	mail_message_list_item_show_attachment (self, _tmp2_);
}

static void
_________lambda71__gtk_flow_box_child_activate (GtkFlowBoxChild* _sender,
                                                gpointer self)
{
	________lambda71_ (self);
}

static void
_________lambda73_ (Block51Data* _data51_)
{
	Block50Data* _data50_;
	MailMessageListItem* self;
	CamelMimePart* _tmp0_;
	_data50_ = _data51_->_data50_;
	self = _data50_->self;
	_tmp0_ = _data50_->part;
	mail_message_list_item_show_attachment (self, _tmp0_);
}

static void
__________lambda73__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self)
{
	_________lambda73_ (self);
}

static gboolean
mail_message_list_item_parse_mime_content_co (MailMessageListItemParseMimeContentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->mime_content, camel_multipart_get_type ())) {
		_data_->_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->mime_content, camel_multipart_get_type ()) ? ((CamelMultipart*) _data_->mime_content) : NULL);
		_data_->content = _data_->_tmp0_;
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp1_ = TRUE;
				while (TRUE) {
					_data_->_data50_ = g_slice_new0 (Block50Data);
					_data_->_data50_->_ref_count_ = 1;
					_data_->_data50_->self = g_object_ref (_data_->self);
					if (!_data_->_tmp1_) {
						_data_->_tmp2_ = _data_->i;
						_data_->i = _data_->_tmp2_ + 1;
					}
					_data_->_tmp1_ = FALSE;
					_data_->_tmp3_ = _data_->content;
					if (!(_data_->i < camel_multipart_get_number (_data_->_tmp3_))) {
						block50_data_unref (_data_->_data50_);
						_data_->_data50_ = NULL;
						break;
					}
					_data_->_tmp4_ = _data_->content;
					_data_->_tmp5_ = camel_multipart_get_part (_data_->_tmp4_, _data_->i);
					_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
					_data_->_data50_->part = _data_->_tmp6_;
					_data_->_tmp7_ = _data_->_data50_->part;
					_data_->_tmp8_ = camel_data_wrapper_get_mime_type_field ((CamelDataWrapper*) _data_->_tmp7_);
					_data_->_tmp9_ = _camel_content_type_ref0 (_data_->_tmp8_);
					_data_->field = _data_->_tmp9_;
					_data_->_tmp10_ = _data_->_data50_->part;
					_data_->_tmp11_ = camel_mime_part_get_disposition (_data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					if (g_strcmp0 (_data_->_tmp12_, "inline") == 0) {
						_data_->_tmp13_ = _data_->_data50_->part;
						_data_->_state_ = 1;
						mail_message_list_item_handle_inline_mime (_data_->self, _data_->_tmp13_, mail_message_list_item_parse_mime_content_ready, _data_);
						return FALSE;
						_state_1:
						mail_message_list_item_handle_inline_mime_finish (_data_->self, _data_->_res_);
					} else {
						_data_->_tmp14_ = _data_->_data50_->part;
						_data_->_tmp15_ = camel_mime_part_get_content_disposition (_data_->_tmp14_);
						_data_->_tmp16_ = _data_->_data50_->part;
						_data_->_tmp17_ = camel_mime_part_get_content_type (_data_->_tmp16_);
						if (camel_content_disposition_is_attachment (_data_->_tmp15_, _data_->_tmp17_)) {
							_data_->_data51_ = g_slice_new0 (Block51Data);
							_data_->_data51_->_ref_count_ = 1;
							_data_->_data51_->_data50_ = block50_data_ref (_data_->_data50_);
							_data_->_tmp18_ = _data_->_data50_->part;
							_data_->_tmp19_ = _data_->self->priv->loading_cancellable;
							_data_->_tmp20_ = attachment_button_new (_data_->_tmp18_, _data_->_tmp19_);
							g_object_ref_sink (_data_->_tmp20_);
							_data_->_data51_->button = _data_->_tmp20_;
							_data_->_tmp21_ = _data_->_data51_->button;
							g_signal_connect_data ((GtkFlowBoxChild*) _data_->_tmp21_, "activate", (GCallback) _________lambda71__gtk_flow_box_child_activate, block51_data_ref (_data_->_data51_), (GClosureNotify) block51_data_unref, 0);
							_data_->_tmp22_ = _data_->self->priv->attachment_bar;
							_data_->_tmp23_ = _data_->_data51_->button;
							gtk_container_add ((GtkContainer*) _data_->_tmp22_, (GtkWidget*) _data_->_tmp23_);
							_data_->_tmp25_ = _data_->_data50_->part;
							_data_->_tmp26_ = camel_data_wrapper_get_mime_type ((CamelDataWrapper*) _data_->_tmp25_);
							_data_->_tmp27_ = _data_->_tmp26_;
							_data_->_tmp28_ = g_strcmp0 (_data_->_tmp27_, "text/calendar") == 0;
							_g_free0 (_data_->_tmp27_);
							if (_data_->_tmp28_) {
								_data_->_tmp29_ = _data_->self->priv->calendar_info_bar;
								_data_->_tmp30_ = gtk_widget_get_visible ((GtkWidget*) _data_->_tmp29_);
								_data_->_tmp31_ = _data_->_tmp30_;
								_data_->_tmp24_ = !_data_->_tmp31_;
							} else {
								_data_->_tmp24_ = FALSE;
							}
							if (_data_->_tmp24_) {
								_data_->_tmp32_ = _data_->self->priv->calendar_info_bar;
								g_signal_connect_data (_data_->_tmp32_, "response", (GCallback) __________lambda73__gtk_info_bar_response, block51_data_ref (_data_->_data51_), (GClosureNotify) block51_data_unref, 0);
								_data_->_tmp33_ = _data_->self->priv->calendar_info_bar;
								gtk_widget_show ((GtkWidget*) _data_->_tmp33_);
							}
							block51_data_unref (_data_->_data51_);
							_data_->_data51_ = NULL;
						}
					}
					_data_->_tmp34_ = _data_->field;
					_data_->_tmp35_ = _data_->_tmp34_->type;
					if (g_strcmp0 (_data_->_tmp35_, "text") == 0) {
						_data_->_tmp36_ = _data_->_data50_->part;
						_data_->_tmp37_ = camel_medium_get_content ((CamelMedium*) _data_->_tmp36_);
						_data_->_tmp38_ = _data_->_tmp37_;
						_data_->_state_ = 2;
						mail_message_list_item_handle_text_mime (_data_->self, _data_->_tmp38_, mail_message_list_item_parse_mime_content_ready, _data_);
						return FALSE;
						_state_2:
						mail_message_list_item_handle_text_mime_finish (_data_->self, _data_->_res_);
					} else {
						_data_->_tmp39_ = _data_->field;
						_data_->_tmp40_ = _data_->_tmp39_->type;
						if (g_strcmp0 (_data_->_tmp40_, "multipart") == 0) {
							_data_->_tmp41_ = _data_->_data50_->part;
							_data_->_tmp42_ = camel_medium_get_content ((CamelMedium*) _data_->_tmp41_);
							_data_->_tmp43_ = _data_->_tmp42_;
							_data_->_state_ = 3;
							mail_message_list_item_parse_mime_content (_data_->self, _data_->_tmp43_, mail_message_list_item_parse_mime_content_ready, _data_);
							return FALSE;
							_state_3:
							mail_message_list_item_parse_mime_content_finish (_data_->self, _data_->_res_);
						}
					}
					_camel_content_type_unref0 (_data_->field);
					block50_data_unref (_data_->_data50_);
					_data_->_data50_ = NULL;
				}
			}
		}
		_g_object_unref0 (_data_->content);
	} else {
		_data_->_state_ = 4;
		mail_message_list_item_handle_text_mime (_data_->self, _data_->mime_content, mail_message_list_item_parse_mime_content_ready, _data_);
		return FALSE;
		_state_4:
		mail_message_list_item_handle_text_mime_finish (_data_->self, _data_->_res_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_message_list_item_handle_text_mime_data_free (gpointer _data)
{
	MailMessageListItemHandleTextMimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->part);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemHandleTextMimeData, _data_);
}

static void
mail_message_list_item_handle_text_mime (MailMessageListItem* self,
                                         CamelDataWrapper* part,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	MailMessageListItemHandleTextMimeData* _data_;
	MailMessageListItem* _tmp0_;
	CamelDataWrapper* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (part != NULL);
	_data_ = g_slice_new0 (MailMessageListItemHandleTextMimeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_handle_text_mime_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (part);
	_g_object_unref0 (_data_->part);
	_data_->part = _tmp1_;
	mail_message_list_item_handle_text_mime_co (_data_);
}

static void
mail_message_list_item_handle_text_mime_finish (MailMessageListItem* self,
                                                GAsyncResult* _res_)
{
	MailMessageListItemHandleTextMimeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_message_list_item_handle_text_mime_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	MailMessageListItemHandleTextMimeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_handle_text_mime_co (_data_);
}

static gboolean
mail_message_list_item_handle_text_mime_co (MailMessageListItemHandleTextMimeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = camel_data_wrapper_get_mime_type_field (_data_->part);
	_data_->_tmp1_ = _camel_content_type_ref0 (_data_->_tmp0_);
	_data_->field = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->message_content;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		if (!_data_->self->priv->message_is_html) {
			_data_->_tmp5_ = _data_->field;
			_data_->_tmp6_ = _data_->_tmp5_->subtype;
			_data_->_tmp4_ = g_strcmp0 (_data_->_tmp6_, "html") == 0;
		} else {
			_data_->_tmp4_ = FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp7_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
		_data_->os = _data_->_tmp7_;
		{
			_data_->_tmp8_ = _data_->os;
			_data_->_tmp9_ = _data_->self->priv->loading_cancellable;
			_data_->_state_ = 1;
			camel_data_wrapper_decode_to_output_stream (_data_->part, (GOutputStream*) _data_->_tmp8_, G_PRIORITY_DEFAULT, _data_->_tmp9_, mail_message_list_item_handle_text_mime_ready, _data_);
			return FALSE;
			_state_1:
			camel_data_wrapper_decode_to_output_stream_finish (_data_->part, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp10_ = _data_->os;
			g_output_stream_close ((GOutputStream*) _data_->_tmp10_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp11_ = _data_->e;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			g_warning ("MessageListItem.vala:626: Possible error decoding email message: %s", _data_->_tmp12_);
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->os);
			_camel_content_type_unref0 (_data_->field);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->os);
			_camel_content_type_unref0 (_data_->field);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = _data_->os;
		_data_->_tmp14_ = _data_->field;
		_data_->_tmp15_ = camel_content_type_param (_data_->_tmp14_, "charset");
		_data_->_tmp16_ = mail_message_list_item_convert_to_utf8 (_data_->_tmp13_, _data_->_tmp15_);
		_g_free0 (_data_->self->priv->message_content);
		_data_->self->priv->message_content = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->field;
		_data_->_tmp18_ = _data_->_tmp17_->subtype;
		if (g_strcmp0 (_data_->_tmp18_, "html") == 0) {
			_data_->self->priv->message_is_html = TRUE;
		}
		_g_object_unref0 (_data_->os);
	}
	_camel_content_type_unref0 (_data_->field);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
mail_message_list_item_convert_to_utf8 (GMemoryOutputStream* os,
                                        const gchar* encoding)
{
	gint num_bytes = 0;
	gchar* bytes = NULL;
	guint8* _tmp0_;
	gchar* utf8 = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (os != NULL, NULL);
	num_bytes = (gint) g_memory_output_stream_get_data_size (os);
	_tmp0_ = g_memory_output_stream_steal_data (os);
	bytes = (gchar*) _tmp0_;
	utf8 = NULL;
	if (encoding != NULL) {
		gchar* iconv_encoding = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = camel_iconv_charset_name (encoding);
		_tmp2_ = g_strdup (_tmp1_);
		iconv_encoding = _tmp2_;
		_tmp3_ = iconv_encoding;
		if (_tmp3_ != NULL) {
			{
				gchar* _tmp4_ = NULL;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp5_ = bytes;
				_tmp6_ = iconv_encoding;
				_tmp7_ = g_convert (_tmp5_, (gssize) num_bytes, "UTF-8", _tmp6_, NULL, NULL, &_inner_error0_);
				_tmp4_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_CONVERT_ERROR) {
						goto __catch0_g_convert_error;
					}
					_g_free0 (iconv_encoding);
					_g_free0 (utf8);
					_g_free0 (bytes);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp8_ = _tmp4_;
				_tmp4_ = NULL;
				_g_free0 (utf8);
				utf8 = _tmp8_;
				_g_free0 (_tmp4_);
			}
			goto __finally0;
			__catch0_g_convert_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (iconv_encoding);
				_g_free0 (utf8);
				_g_free0 (bytes);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_g_free0 (iconv_encoding);
	}
	_tmp10_ = utf8;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = utf8;
		_tmp9_ = !g_utf8_validate (_tmp11_, (gssize) -1, NULL);
	}
	if (_tmp9_) {
		{
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp13_ = bytes;
			_tmp14_ = g_convert (_tmp13_, (gssize) num_bytes, "UTF-8", "ISO-8859-1", NULL, NULL, &_inner_error0_);
			_tmp12_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch1_g_convert_error;
				}
				_g_free0 (utf8);
				_g_free0 (bytes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp15_ = _tmp12_;
			_tmp12_ = NULL;
			_g_free0 (utf8);
			utf8 = _tmp15_;
			_g_free0 (_tmp12_);
		}
		goto __finally1;
		__catch1_g_convert_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_critical ("MessageListItem.vala:664: Every string should be valid ISO-8859-1. Con" \
"vertError: %s", _tmp17_);
			_tmp18_ = g_strdup ("");
			_g_free0 (utf8);
			utf8 = _tmp18_;
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (utf8);
			_g_free0 (bytes);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = utf8;
	_g_free0 (bytes);
	return result;
}

static void
mail_message_list_item_handle_inline_mime_data_free (gpointer _data)
{
	MailMessageListItemHandleInlineMimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->part);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemHandleInlineMimeData, _data_);
}

static void
mail_message_list_item_handle_inline_mime (MailMessageListItem* self,
                                           CamelMimePart* part,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	MailMessageListItemHandleInlineMimeData* _data_;
	MailMessageListItem* _tmp0_;
	CamelMimePart* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (part != NULL);
	_data_ = g_slice_new0 (MailMessageListItemHandleInlineMimeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_handle_inline_mime_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (part);
	_g_object_unref0 (_data_->part);
	_data_->part = _tmp1_;
	mail_message_list_item_handle_inline_mime_co (_data_);
}

static void
mail_message_list_item_handle_inline_mime_finish (MailMessageListItem* self,
                                                  GAsyncResult* _res_)
{
	MailMessageListItemHandleInlineMimeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

static void
mail_message_list_item_handle_inline_mime_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	MailMessageListItemHandleInlineMimeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_handle_inline_mime_co (_data_);
}

static gboolean
mail_message_list_item_handle_inline_mime_co (MailMessageListItemHandleInlineMimeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = camel_mime_part_get_content_id (_data_->part);
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_byte_array_new ();
	_data_->byte_array = _data_->_tmp1_;
	_data_->_tmp2_ = (CamelStreamMem*) camel_stream_mem_new ();
	_data_->os = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->os;
	_data_->_tmp4_ = _data_->byte_array;
	_data_->_tmp5_ = _g_byte_array_ref0 (_data_->_tmp4_);
	camel_stream_mem_set_byte_array (_data_->_tmp3_, _data_->_tmp5_);
	{
		_data_->_tmp6_ = camel_medium_get_content ((CamelMedium*) _data_->part);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->os;
		_data_->_tmp9_ = _data_->self->priv->loading_cancellable;
		_data_->_state_ = 1;
		camel_data_wrapper_decode_to_stream (_data_->_tmp7_, (CamelStream*) _data_->_tmp8_, G_PRIORITY_DEFAULT, _data_->_tmp9_, mail_message_list_item_handle_inline_mime_ready, _data_);
		return FALSE;
		_state_1:
		camel_data_wrapper_decode_to_stream_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("MessageListItem.vala:683: Error decoding inline attachment: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->os);
		_g_byte_array_unref0 (_data_->byte_array);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->os);
		_g_byte_array_unref0 (_data_->byte_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->byte_array;
	_data_->_tmp13_ = _g_byte_array_ref0 (_data_->_tmp12_);
	_data_->_tmp14_ = g_byte_array_free_to_bytes (_data_->_tmp13_);
	_data_->bytes = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->bytes;
	_data_->_tmp16_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_data_->_tmp15_);
	_data_->inline_stream = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->self->priv->web_view;
	_data_->_tmp18_ = camel_mime_part_get_content_id (_data_->part);
	_data_->_tmp19_ = g_strdup_printf ("cid:%s", _data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->inline_stream;
	mail_web_view_add_internal_resource (_data_->_tmp17_, _data_->_tmp20_, (GInputStream*) _data_->_tmp21_);
	_g_free0 (_data_->_tmp20_);
	_g_object_unref0 (_data_->inline_stream);
	_g_bytes_unref0 (_data_->bytes);
	_g_object_unref0 (_data_->os);
	_g_byte_array_unref0 (_data_->byte_array);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_message_list_item_get_message_body_html_data_free (gpointer _data)
{
	MailMessageListItemGetMessageBodyHtmlData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemGetMessageBodyHtmlData, _data_);
}

void
mail_message_list_item_get_message_body_html (MailMessageListItem* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	MailMessageListItemGetMessageBodyHtmlData* _data_;
	MailMessageListItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailMessageListItemGetMessageBodyHtmlData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_get_message_body_html_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_message_list_item_get_message_body_html_co (_data_);
}

gchar*
mail_message_list_item_get_message_body_html_finish (MailMessageListItem* self,
                                                     GAsyncResult* _res_)
{
	gchar* result;
	MailMessageListItemGetMessageBodyHtmlData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
mail_message_list_item_get_message_body_html_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	MailMessageListItemGetMessageBodyHtmlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_get_message_body_html_co (_data_);
}

static gboolean
mail_message_list_item_get_message_body_html_co (MailMessageListItemGetMessageBodyHtmlData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->web_view;
	_data_->_state_ = 1;
	mail_web_view_get_body_html (_data_->_tmp0_, FALSE, mail_message_list_item_get_message_body_html_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = mail_web_view_get_body_html_finish (_data_->_tmp0_, _data_->_res_);
	_data_->result = _data_->_tmp1_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		MailMessageListItem* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->dialog);
		_g_object_unref0 (_data52_->mime_part);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static void
__lambda72_ (Block52Data* _data52_,
             gint response_id)
{
	MailMessageListItem* self;
	self = _data52_->self;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		mail_message_list_item_show_file_anyway (self, _data52_->mime_part, NULL, NULL);
	}
	gtk_widget_destroy ((GtkWidget*) _data52_->dialog);
}

static void
___lambda72__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda72_ (self, response_id);
}

static void
mail_message_list_item_show_attachment (MailMessageListItem* self,
                                        CamelMimePart* mime_part)
{
	Block52Data* _data52_;
	CamelMimePart* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GThemedIcon* _tmp4_;
	GThemedIcon* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWindow* _tmp7_;
	GraniteMessageDialog* _tmp8_ = NULL;
	GraniteMessageDialog* _tmp9_;
	GtkWidget* open_button = NULL;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkStyleContext* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_part != NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (mime_part);
	_g_object_unref0 (_data52_->mime_part);
	_data52_->mime_part = _tmp0_;
	_tmp1_ = camel_mime_part_get_filename (_data52_->mime_part);
	_tmp2_ = g_strdup_printf (_ ("Trust and open “%s”?"), _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
	_tmp8_ = granite_message_dialog_new (_tmp3_, _ ("Attachments may cause damage to your system if opened. Only open files" \
" from trusted sources."), (GIcon*) _tmp5_, GTK_BUTTONS_CANCEL);
	gtk_window_set_transient_for ((GtkWindow*) _tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_data52_->dialog = _tmp9_;
	_tmp10_ = gtk_dialog_add_button ((GtkDialog*) _data52_->dialog, _ ("Open Anyway"), (gint) GTK_RESPONSE_OK);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	open_button = _tmp11_;
	_tmp12_ = gtk_widget_get_style_context (open_button);
	gtk_style_context_add_class (_tmp12_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	gtk_window_present ((GtkWindow*) _data52_->dialog);
	g_signal_connect_data ((GtkDialog*) _data52_->dialog, "response", (GCallback) ___lambda72__gtk_dialog_response, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_g_object_unref0 (open_button);
	block52_data_unref (_data52_);
	_data52_ = NULL;
}

static void
mail_message_list_item_show_file_anyway_data_free (gpointer _data)
{
	MailMessageListItemShowFileAnywayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mime_part);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMessageListItemShowFileAnywayData, _data_);
}

static void
mail_message_list_item_show_file_anyway (MailMessageListItem* self,
                                         CamelMimePart* mime_part,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	MailMessageListItemShowFileAnywayData* _data_;
	MailMessageListItem* _tmp0_;
	CamelMimePart* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_part != NULL);
	_data_ = g_slice_new0 (MailMessageListItemShowFileAnywayData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_message_list_item_show_file_anyway_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mime_part);
	_g_object_unref0 (_data_->mime_part);
	_data_->mime_part = _tmp1_;
	mail_message_list_item_show_file_anyway_co (_data_);
}

static void
mail_message_list_item_show_file_anyway_finish (MailMessageListItem* self,
                                                GAsyncResult* _res_)
{
	MailMessageListItemShowFileAnywayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_message_list_item_show_file_anyway_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	MailMessageListItemShowFileAnywayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_message_list_item_show_file_anyway_co (_data_);
}

static gboolean
mail_message_list_item_show_file_anyway_co (MailMessageListItemShowFileAnywayData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->temp_dir;
		if (_data_->_tmp0_ == NULL) {
			_data_->_tmp2_ = g_dir_make_tmp (".XXXXXX", &_data_->_inner_error0_);
			_data_->_tmp1_ = _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp1_);
			_g_object_unref0 (_data_->self->priv->temp_dir);
			_data_->self->priv->temp_dir = _data_->_tmp3_;
			_g_free0 (_data_->_tmp1_);
		}
		_data_->_tmp4_ = _data_->self->priv->temp_dir;
		_data_->_tmp5_ = camel_mime_part_get_filename (_data_->mime_part);
		_data_->_tmp6_ = g_file_get_child (_data_->_tmp4_, _data_->_tmp5_);
		_data_->file = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->file;
		if (!g_file_query_exists (_data_->_tmp7_, NULL)) {
			_data_->_tmp8_ = _data_->file;
			_data_->_state_ = 1;
			g_file_create_async (_data_->_tmp8_, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, NULL, mail_message_list_item_show_file_anyway_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp9_ = g_file_create_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			_data_->output_stream = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->file);
				goto __catch0_g_error;
			}
			_data_->_tmp10_ = camel_medium_get_content ((CamelMedium*) _data_->mime_part);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->output_stream;
			_data_->_state_ = 2;
			camel_data_wrapper_decode_to_output_stream (_data_->_tmp11_, (GOutputStream*) _data_->_tmp12_, G_PRIORITY_DEFAULT, NULL, mail_message_list_item_show_file_anyway_ready, _data_);
			return FALSE;
			_state_2:
			camel_data_wrapper_decode_to_output_stream_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->output_stream);
				_g_object_unref0 (_data_->file);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->output_stream);
		}
		_data_->_tmp13_ = _data_->file;
		_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_state_ = 3;
		g_app_info_launch_default_for_uri_async (_data_->_tmp15_, NULL, NULL, mail_message_list_item_show_file_anyway_ready, _data_);
		return FALSE;
		_state_3:
		g_app_info_launch_default_for_uri_finish (_data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp15_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = camel_mime_part_get_filename (_data_->mime_part);
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_warning ("MessageListItem.vala:734: Failed to show file '%s': %s", _data_->_tmp16_, _data_->_tmp18_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
mail_message_list_item_get_loaded (MailMessageListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loaded;
	return result;
}

static void
mail_message_list_item_set_loaded (MailMessageListItem* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_message_list_item_get_loaded (self);
	if (old_value != value) {
		self->priv->_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_LOADED_PROPERTY]);
	}
}

CamelMessageInfo*
mail_message_list_item_get_message_info (MailMessageListItem* self)
{
	CamelMessageInfo* result;
	CamelMessageInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_message_info;
	result = _tmp0_;
	return result;
}

static void
mail_message_list_item_set_message_info (MailMessageListItem* self,
                                         CamelMessageInfo* value)
{
	CamelMessageInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_message_list_item_get_message_info (self);
	if (old_value != value) {
		CamelMessageInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_message_info);
		self->priv->_message_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_MESSAGE_INFO_PROPERTY]);
	}
}

CamelMimeMessage*
mail_message_list_item_get_mime_message (MailMessageListItem* self)
{
	CamelMimeMessage* result;
	CamelMimeMessage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_message;
	result = _tmp0_;
	return result;
}

static void
mail_message_list_item_set_mime_message (MailMessageListItem* self,
                                         CamelMimeMessage* value)
{
	CamelMimeMessage* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_message_list_item_get_mime_message (self);
	if (old_value != value) {
		CamelMimeMessage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mime_message);
		self->priv->_mime_message = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_MIME_MESSAGE_PROPERTY]);
	}
}

gboolean
mail_message_list_item_get_expanded (MailMessageListItem* self)
{
	gboolean result;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->secondary_revealer;
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
mail_message_list_item_set_expanded (MailMessageListItem* self,
                                     gboolean value)
{
	GtkRevealer* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->secondary_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, value);
	if (value) {
		_tmp1_ = "large";
	} else {
		_tmp1_ = "small";
	}
	_tmp2_ = self->priv->header_stack;
	gtk_stack_set_visible_child_name (_tmp2_, _tmp1_);
	if (value) {
		GtkStyleContext* _tmp3_;
		if (!self->priv->message_loaded) {
			mail_message_list_item_get_message (self, NULL, NULL);
			self->priv->message_loaded = TRUE;
		}
		_tmp3_ = self->priv->style_context;
		gtk_style_context_remove_class (_tmp3_, "collapsed");
	} else {
		GtkStyleContext* _tmp4_;
		_tmp4_ = self->priv->style_context;
		gtk_style_context_add_class (_tmp4_, "collapsed");
	}
	g_object_notify_by_pspec ((GObject *) self, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_EXPANDED_PROPERTY]);
}

static Block53Data*
block53_data_ref (Block53Data* _data53_)
{
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}

static void
block53_data_unref (void * _userdata_)
{
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		MailMessageListItem* self;
		self = _data53_->self;
		_g_object_unref0 (_data53_->header_event_box);
		_g_object_unref0 (_data53_->actions_menu_button);
		_g_object_unref0 (_data53_->starred_icon);
		_g_object_unref0 (self);
		g_slice_free (Block53Data, _data53_);
	}
}

static GVariant*
_variant_new24 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new25 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new26 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new27 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_mail_message_list_item_on_mouse_target_changed_webkit_web_view_mouse_target_changed (WebKitWebView* _sender,
                                                                                      WebKitHitTestResult* hit_test_result,
                                                                                      guint modifiers,
                                                                                      gpointer self)
{
	mail_message_list_item_on_mouse_target_changed ((MailMessageListItem*) self, _sender, hit_test_result, modifiers);
}

static gboolean
_mail_message_list_item_on_webview_context_menu_webkit_web_view_context_menu (WebKitWebView* _sender,
                                                                              WebKitContextMenu* context_menu,
                                                                              GdkEvent* event,
                                                                              WebKitHitTestResult* hit_test_result,
                                                                              gpointer self)
{
	gboolean result;
	result = mail_message_list_item_on_webview_context_menu ((MailMessageListItem*) self, context_menu, event, hit_test_result);
	return result;
}

static void
_mail_message_list_item___lambda74_ (MailMessageListItem* self)
{
	mail_message_list_item_set_loaded (self, TRUE);
}

static void
__mail_message_list_item___lambda74__mail_web_view_load_finished (MailWebView* _sender,
                                                                  gpointer self)
{
	_mail_message_list_item___lambda74_ ((MailMessageListItem*) self);
}

static void
_mail_message_list_item____lambda75_ (MailMessageListItem* self,
                                      GObject* obj,
                                      GAsyncResult* res)
{
	GFileIcon* file_icon = NULL;
	GFileIcon* _tmp0_;
	HdyAvatar* _tmp1_;
	GFileIcon* _tmp2_;
	g_return_if_fail (res != NULL);
	_tmp0_ = mail_message_list_item_get_gravatar_finish (self, res);
	file_icon = _tmp0_;
	_tmp1_ = self->priv->avatar;
	_tmp2_ = file_icon;
	hdy_avatar_set_loadable_icon (_tmp1_, (GLoadableIcon*) _tmp2_);
	_g_object_unref0 (file_icon);
}

static void
__mail_message_list_item____lambda75__gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self)
{
	_mail_message_list_item____lambda75_ ((MailMessageListItem*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
_mail_message_list_item___lambda76_ (Block53Data* _data53_,
                                     GdkEventButton* event)
{
	MailMessageListItem* self;
	GtkMenuButton* _tmp0_;
	gboolean result;
	self = _data53_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data53_->actions_menu_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__mail_message_list_item___lambda76__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self)
{
	gboolean result;
	result = _mail_message_list_item___lambda76_ (self, event);
	return result;
}

static gboolean
_mail_message_list_item___lambda77_ (Block53Data* _data53_,
                                     GdkEventCrossing* event)
{
	MailMessageListItem* self;
	self = _data53_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail != GDK_NOTIFY_INFERIOR) {
		GdkWindow* window = NULL;
		GtkEventBox* _tmp0_;
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		GdkCursor* cursor = NULL;
		GdkWindow* _tmp3_;
		GdkDisplay* _tmp4_;
		GdkCursor* _tmp5_;
		GdkWindow* _tmp6_;
		GdkCursor* _tmp7_;
		_tmp0_ = _data53_->header_event_box;
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = window;
		_tmp4_ = gdk_window_get_display (_tmp3_);
		_tmp5_ = gdk_cursor_new_from_name (_tmp4_, "pointer");
		cursor = _tmp5_;
		_tmp6_ = window;
		_tmp7_ = cursor;
		gdk_window_set_cursor (_tmp6_, _tmp7_);
		_g_object_unref0 (cursor);
		_g_object_unref0 (window);
	}
}

static gboolean
__mail_message_list_item___lambda77__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                    GdkEventCrossing* event,
                                                                    gpointer self)
{
	gboolean result;
	result = _mail_message_list_item___lambda77_ (self, event);
	return result;
}

static gboolean
_mail_message_list_item___lambda78_ (Block53Data* _data53_,
                                     GdkEventCrossing* event)
{
	MailMessageListItem* self;
	self = _data53_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail != GDK_NOTIFY_INFERIOR) {
		GtkEventBox* _tmp0_;
		GdkWindow* _tmp1_;
		_tmp0_ = _data53_->header_event_box;
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
		gdk_window_set_cursor (_tmp1_, NULL);
	}
}

static gboolean
__mail_message_list_item___lambda78__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                    GdkEventCrossing* event,
                                                                    gpointer self)
{
	gboolean result;
	result = _mail_message_list_item___lambda78_ (self, event);
	return result;
}

static gboolean
_mail_message_list_item___lambda79_ (MailMessageListItem* self,
                                     GdkEventButton* event)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = mail_message_list_item_get_expanded (self);
	_tmp1_ = _tmp0_;
	mail_message_list_item_set_expanded (self, !_tmp1_);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__mail_message_list_item___lambda79__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self)
{
	gboolean result;
	result = _mail_message_list_item___lambda79_ ((MailMessageListItem*) self, event);
	return result;
}

static void
_mail_message_list_item___lambda80_ (MailMessageListItem* self)
{
	GCancellable* _tmp0_;
	_tmp0_ = self->priv->loading_cancellable;
	g_cancellable_cancel (_tmp0_);
}

static void
__mail_message_list_item___lambda80__gtk_widget_destroy (GtkWidget* _sender,
                                                         gpointer self)
{
	_mail_message_list_item___lambda80_ ((MailMessageListItem*) self);
}

static gboolean
_mail_message_list_item___lambda81_ (Block53Data* _data53_)
{
	MailMessageListItem* self;
	CamelMessageInfo* _tmp0_;
	CamelMessageFlags _tmp1_;
	CamelMessageFlags _tmp2_;
	gboolean result;
	self = _data53_->self;
	_tmp0_ = self->priv->_message_info;
	g_object_get (_tmp0_, "flags", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if ((((gint) _tmp2_) & CAMEL_MESSAGE_FLAGGED) == CAMEL_MESSAGE_FLAGGED) {
		CamelMessageInfo* _tmp3_;
		GtkImage* _tmp4_;
		GtkImage* _tmp5_;
		_tmp3_ = self->priv->_message_info;
		camel_message_info_set_flags (_tmp3_, (guint32) CAMEL_MESSAGE_FLAGGED, (guint32) 0);
		_tmp4_ = _data53_->starred_icon;
		g_object_set (_tmp4_, "icon-name", "non-starred-symbolic", NULL);
		_tmp5_ = _data53_->starred_icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Star message"));
	} else {
		CamelMessageInfo* _tmp6_;
		GtkImage* _tmp7_;
		GtkImage* _tmp8_;
		_tmp6_ = self->priv->_message_info;
		camel_message_info_set_flags (_tmp6_, (guint32) CAMEL_MESSAGE_FLAGGED, (guint32) (~0));
		_tmp7_ = _data53_->starred_icon;
		g_object_set (_tmp7_, "icon-name", "starred-symbolic", NULL);
		_tmp8_ = _data53_->starred_icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("Unstar message"));
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__mail_message_list_item___lambda81__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self)
{
	gboolean result;
	result = _mail_message_list_item___lambda81_ (self);
	return result;
}

static void
_mail_message_list_item___lambda82_ (MailMessageListItem* self)
{
	GtkInfoBar* _tmp0_;
	_tmp0_ = self->priv->blocked_images_infobar;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

static void
__mail_message_list_item___lambda82__mail_web_view_image_load_blocked (MailWebView* _sender,
                                                                       gpointer self)
{
	_mail_message_list_item___lambda82_ ((MailMessageListItem*) self);
}

static void
_mail_message_list_item___lambda83_ (MailMessageListItem* self,
                                     const gchar* uri)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	{
		g_app_info_launch_default_for_uri (uri, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("MessageListItem.vala:415: Failed to open link: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__mail_message_list_item___lambda83__mail_web_view_link_activated (MailWebView* _sender,
                                                                   const gchar* url,
                                                                   gpointer self)
{
	_mail_message_list_item___lambda83_ ((MailMessageListItem*) self, url);
}

static GObject *
mail_message_list_item_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailMessageListItem * self;
	Block53Data* _data53_;
	GCancellable* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	const gchar* parsed_address = NULL;
	const gchar* parsed_name = NULL;
	CamelInternetAddress* camel_address = NULL;
	CamelInternetAddress* _tmp4_;
	CamelInternetAddress* _tmp5_;
	CamelMessageInfo* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	CamelInternetAddress* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp14_;
	HdyAvatar* _tmp15_ = NULL;
	GtkLabel* from_label = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkLabel* to_label = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkLabel* subject_label = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkLabel* from_val_label = NULL;
	CamelMessageInfo* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GtkLabel* _tmp28_ = NULL;
	GtkLabel* to_val_label = NULL;
	CamelMessageInfo* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GtkLabel* _tmp32_ = NULL;
	GtkLabel* subject_val_label = NULL;
	CamelMessageInfo* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GtkLabel* _tmp36_ = NULL;
	GtkGrid* fields_grid = NULL;
	GtkGrid* _tmp37_ = NULL;
	GtkGrid* _tmp38_;
	GtkLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkLabel* _tmp43_;
	GtkGrid* _tmp44_;
	GtkLabel* _tmp45_;
	GtkGrid* _tmp46_;
	GtkLabel* _tmp47_;
	GtkGrid* _tmp48_;
	GtkLabel* _tmp49_;
	gchar* cc_info = NULL;
	CamelMessageInfo* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	const gchar* _tmp54_;
	GtkLabel* small_from_label = NULL;
	CamelMessageInfo* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	GtkLabel* _tmp67_ = NULL;
	GtkGrid* small_fields_grid = NULL;
	GtkGrid* _tmp68_;
	GtkGrid* _tmp69_;
	GtkLabel* _tmp70_;
	GtkStack* _tmp71_ = NULL;
	GtkStack* _tmp72_;
	GtkGrid* _tmp73_;
	GtkStack* _tmp74_;
	GtkGrid* _tmp75_;
	GtkStack* _tmp76_;
	gint64 relevant_timestamp = 0LL;
	CamelMessageInfo* _tmp77_;
	gint64 _tmp78_;
	gint64 _tmp79_;
	gchar* date_format = NULL;
	gchar* _tmp83_;
	gchar* time_format = NULL;
	GSettings* _tmp84_;
	gchar* _tmp85_;
	GtkLabel* datetime_label = NULL;
	GDateTime* _tmp86_;
	GDateTime* _tmp87_;
	GDateTime* _tmp88_;
	GDateTime* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	GtkLabel* _tmp96_;
	GtkLabel* _tmp97_;
	GtkLabel* _tmp98_;
	GtkStyleContext* _tmp99_;
	GtkImage* _tmp100_;
	GtkImage* _tmp101_;
	CamelMessageInfo* _tmp102_;
	CamelMessageFlags _tmp103_;
	CamelMessageFlags _tmp104_;
	GtkButton* starred_button = NULL;
	GtkImage* _tmp109_;
	GtkWidget* _tmp110_;
	GtkButton* _tmp111_ = NULL;
	GtkButton* _tmp112_;
	GtkStyleContext* _tmp113_;
	GMenu* upper_section = NULL;
	GMenu* _tmp114_;
	GMenu* _tmp115_;
	CamelMessageInfo* _tmp116_;
	const gchar* _tmp117_;
	const gchar* _tmp118_;
	GVariant* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	GMenu* _tmp122_;
	CamelMessageInfo* _tmp123_;
	const gchar* _tmp124_;
	const gchar* _tmp125_;
	GVariant* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	GMenu* _tmp129_;
	CamelMessageInfo* _tmp130_;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	GVariant* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	GMenu* lower_section = NULL;
	GMenu* _tmp136_;
	GMenu* _tmp137_;
	CamelMessageInfo* _tmp138_;
	const gchar* _tmp139_;
	const gchar* _tmp140_;
	GVariant* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	GMenu* actions_menu = NULL;
	GMenu* _tmp144_;
	GMenu* _tmp145_;
	GMenu* _tmp146_;
	GMenu* _tmp147_;
	GMenu* _tmp148_;
	GtkImage* _tmp149_;
	gchar* _tmp150_;
	GMenu* _tmp151_;
	GMenuModel* _tmp152_;
	GtkMenuButton* _tmp153_ = NULL;
	GtkMenuButton* _tmp154_;
	GtkStyleContext* _tmp155_;
	GtkGrid* action_grid = NULL;
	GtkGrid* _tmp156_ = NULL;
	GtkGrid* _tmp157_;
	GtkLabel* _tmp158_;
	GtkGrid* _tmp159_;
	GtkButton* _tmp160_;
	GtkGrid* _tmp161_;
	GtkMenuButton* _tmp162_;
	GtkGrid* header = NULL;
	GtkGrid* _tmp163_ = NULL;
	GtkGrid* _tmp164_;
	HdyAvatar* _tmp165_;
	GtkGrid* _tmp166_;
	GtkStack* _tmp167_;
	GtkGrid* _tmp168_;
	GtkGrid* _tmp169_;
	GtkEventBox* _tmp170_;
	GtkEventBox* _tmp171_;
	GtkEventBox* _tmp172_;
	GdkEventMask _tmp173_;
	GdkEventMask _tmp174_;
	GtkEventBox* _tmp175_;
	GtkEventBox* _tmp176_;
	GdkEventMask _tmp177_;
	GdkEventMask _tmp178_;
	GtkEventBox* _tmp179_;
	GtkEventBox* _tmp180_;
	GdkEventMask _tmp181_;
	GdkEventMask _tmp182_;
	GtkEventBox* _tmp183_;
	GtkGrid* _tmp184_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp185_ = NULL;
	GSettings* _tmp186_;
	GtkInfoBar* _tmp187_ = NULL;
	GtkInfoBar* _tmp188_;
	GtkInfoBar* _tmp189_;
	GtkStyleContext* _tmp190_;
	GtkInfoBar* _tmp191_;
	GtkContainer* calendar_info_bar_content = NULL;
	GtkInfoBar* _tmp192_;
	GtkContainer* _tmp193_;
	GtkContainer* _tmp194_;
	GtkContainer* _tmp195_;
	GtkImage* _tmp196_;
	GtkImage* _tmp197_;
	GtkContainer* _tmp198_;
	GtkLabel* _tmp199_;
	GtkLabel* _tmp200_;
	GtkContainer* _tmp201_;
	GtkInfoBar* _tmp202_ = NULL;
	GtkInfoBar* _tmp203_;
	GtkInfoBar* _tmp204_;
	GtkInfoBar* _tmp205_;
	GtkStyleContext* _tmp206_;
	GtkInfoBar* _tmp207_;
	GtkContainer* infobar_content = NULL;
	GtkInfoBar* _tmp208_;
	GtkContainer* _tmp209_;
	GtkContainer* _tmp210_;
	GtkContainer* _tmp211_;
	GtkLabel* _tmp212_;
	GtkLabel* _tmp213_;
	GtkContainer* _tmp214_;
	GtkInfoBar* _tmp215_;
	GtkBox* _tmp216_;
	MailWebView* _tmp217_ = NULL;
	MailWebView* _tmp218_;
	MailWebView* _tmp219_;
	MailWebView* _tmp220_;
	GtkBox* secondary_box = NULL;
	GtkBox* _tmp221_;
	GtkBox* _tmp222_;
	GtkSeparator* _tmp223_;
	GtkBox* _tmp224_;
	GtkInfoBar* _tmp225_;
	GtkBox* _tmp226_;
	GtkInfoBar* _tmp227_;
	GtkBox* _tmp228_;
	MailWebView* _tmp229_;
	GtkRevealer* _tmp230_ = NULL;
	GtkRevealer* _tmp231_;
	GtkBox* _tmp232_;
	GtkBox* base_box = NULL;
	GtkBox* _tmp233_ = NULL;
	GtkBox* _tmp234_;
	GtkEventBox* _tmp235_;
	GtkBox* _tmp236_;
	GtkRevealer* _tmp237_;
	CamelMessageInfo* _tmp238_;
	CamelMessageFlags _tmp239_;
	CamelMessageFlags _tmp240_;
	GtkBox* _tmp253_;
	GNetworkMonitor* _tmp254_;
	gboolean _tmp255_;
	gboolean _tmp256_;
	GtkMenuButton* _tmp258_;
	GtkEventBox* _tmp259_;
	GtkEventBox* _tmp260_;
	GtkEventBox* _tmp261_;
	GtkButton* _tmp262_;
	MailWebView* _tmp263_;
	MailWebView* _tmp264_;
	parent_class = G_OBJECT_CLASS (mail_message_list_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem);
	_data53_ = g_slice_new0 (Block53Data);
	_data53_->_ref_count_ = 1;
	_data53_->self = g_object_ref (self);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->loading_cancellable);
	self->priv->loading_cancellable = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->style_context);
	self->priv->style_context = _tmp2_;
	_tmp3_ = self->priv->style_context;
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_CARD);
	_tmp4_ = camel_internet_address_new ();
	camel_address = _tmp4_;
	_tmp5_ = camel_address;
	_tmp6_ = self->priv->_message_info;
	_tmp7_ = camel_message_info_get_from (_tmp6_);
	_tmp8_ = _tmp7_;
	camel_address_unformat ((CamelAddress*) _tmp5_, _tmp8_);
	_tmp9_ = camel_address;
	camel_internet_address_get (_tmp9_, 0, &_tmp10_, &_tmp11_);
	parsed_name = _tmp10_;
	parsed_address = _tmp11_;
	_tmp12_ = parsed_name;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		_tmp13_ = parsed_address;
		parsed_name = _tmp13_;
	}
	_tmp14_ = parsed_name;
	_tmp15_ = (HdyAvatar*) hdy_avatar_new (48, _tmp14_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->avatar);
	self->priv->avatar = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("From:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp16_);
	from_label = _tmp16_;
	_tmp17_ = from_label;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp19_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp19_);
	to_label = _tmp19_;
	_tmp20_ = to_label;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_add_class (_tmp21_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp22_ = (GtkLabel*) gtk_label_new (_ ("Subject:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp22_);
	subject_label = _tmp22_;
	_tmp23_ = subject_label;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp25_ = self->priv->_message_info;
	_tmp26_ = camel_message_info_get_from (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = (GtkLabel*) gtk_label_new (_tmp27_);
	g_object_set (_tmp28_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp28_, (gfloat) 0);
	g_object_ref_sink (_tmp28_);
	from_val_label = _tmp28_;
	_tmp29_ = self->priv->_message_info;
	_tmp30_ = camel_message_info_get_to (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = (GtkLabel*) gtk_label_new (_tmp31_);
	g_object_set (_tmp32_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp32_, (gfloat) 0);
	g_object_ref_sink (_tmp32_);
	to_val_label = _tmp32_;
	_tmp33_ = self->priv->_message_info;
	_tmp34_ = camel_message_info_get_subject (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = (GtkLabel*) gtk_label_new (_tmp35_);
	g_object_set (_tmp36_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp36_, (gfloat) 0);
	g_object_ref_sink (_tmp36_);
	subject_val_label = _tmp36_;
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp37_, 6);
	gtk_grid_set_row_spacing (_tmp37_, 6);
	g_object_ref_sink (_tmp37_);
	fields_grid = _tmp37_;
	_tmp38_ = fields_grid;
	_tmp39_ = from_label;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 0, 0, 1, 1);
	_tmp40_ = fields_grid;
	_tmp41_ = to_label;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 1, 1, 1);
	_tmp42_ = fields_grid;
	_tmp43_ = subject_label;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 0, 3, 1, 1);
	_tmp44_ = fields_grid;
	_tmp45_ = from_val_label;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 1, 0, 1, 1);
	_tmp46_ = fields_grid;
	_tmp47_ = to_val_label;
	gtk_grid_attach (_tmp46_, (GtkWidget*) _tmp47_, 1, 1, 1, 1);
	_tmp48_ = fields_grid;
	_tmp49_ = subject_val_label;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 1, 3, 1, 1);
	_tmp50_ = self->priv->_message_info;
	_tmp51_ = camel_message_info_get_cc (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strdup (_tmp52_);
	cc_info = _tmp53_;
	_tmp54_ = cc_info;
	if (_tmp54_ != NULL) {
		GtkLabel* cc_label = NULL;
		GtkLabel* _tmp55_ = NULL;
		GtkLabel* _tmp56_;
		GtkStyleContext* _tmp57_;
		GtkLabel* cc_val_label = NULL;
		const gchar* _tmp58_;
		GtkLabel* _tmp59_ = NULL;
		GtkGrid* _tmp60_;
		GtkLabel* _tmp61_;
		GtkGrid* _tmp62_;
		GtkLabel* _tmp63_;
		_tmp55_ = (GtkLabel*) gtk_label_new (_ ("Cc:"));
		gtk_widget_set_halign ((GtkWidget*) _tmp55_, GTK_ALIGN_END);
		gtk_widget_set_valign ((GtkWidget*) _tmp55_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp55_);
		cc_label = _tmp55_;
		_tmp56_ = cc_label;
		_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) _tmp56_);
		gtk_style_context_add_class (_tmp57_, GTK_STYLE_CLASS_DIM_LABEL);
		_tmp58_ = cc_info;
		_tmp59_ = (GtkLabel*) gtk_label_new (_tmp58_);
		g_object_set (_tmp59_, "wrap", TRUE, NULL);
		gtk_label_set_xalign (_tmp59_, (gfloat) 0);
		g_object_ref_sink (_tmp59_);
		cc_val_label = _tmp59_;
		_tmp60_ = fields_grid;
		_tmp61_ = cc_label;
		gtk_grid_attach (_tmp60_, (GtkWidget*) _tmp61_, 0, 2, 1, 1);
		_tmp62_ = fields_grid;
		_tmp63_ = cc_val_label;
		gtk_grid_attach (_tmp62_, (GtkWidget*) _tmp63_, 1, 2, 1, 1);
		_g_object_unref0 (cc_val_label);
		_g_object_unref0 (cc_label);
	}
	_tmp64_ = self->priv->_message_info;
	_tmp65_ = camel_message_info_get_from (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = (GtkLabel*) gtk_label_new (_tmp66_);
	gtk_label_set_ellipsize (_tmp67_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp67_, (gfloat) 0);
	g_object_ref_sink (_tmp67_);
	small_from_label = _tmp67_;
	_tmp68_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp68_);
	small_fields_grid = _tmp68_;
	_tmp69_ = small_fields_grid;
	_tmp70_ = small_from_label;
	gtk_grid_attach (_tmp69_, (GtkWidget*) _tmp70_, 0, 0, 1, 1);
	_tmp71_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_homogeneous (_tmp71_, FALSE);
	gtk_stack_set_transition_type (_tmp71_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->header_stack);
	self->priv->header_stack = _tmp71_;
	_tmp72_ = self->priv->header_stack;
	_tmp73_ = fields_grid;
	gtk_stack_add_named (_tmp72_, (GtkWidget*) _tmp73_, "large");
	_tmp74_ = self->priv->header_stack;
	_tmp75_ = small_fields_grid;
	gtk_stack_add_named (_tmp74_, (GtkWidget*) _tmp75_, "small");
	_tmp76_ = self->priv->header_stack;
	gtk_widget_show_all ((GtkWidget*) _tmp76_);
	_tmp77_ = self->priv->_message_info;
	_tmp78_ = camel_message_info_get_date_received (_tmp77_);
	_tmp79_ = _tmp78_;
	relevant_timestamp = _tmp79_;
	if (relevant_timestamp == ((gint64) 0)) {
		CamelMessageInfo* _tmp80_;
		gint64 _tmp81_;
		gint64 _tmp82_;
		_tmp80_ = self->priv->_message_info;
		_tmp81_ = camel_message_info_get_date_sent (_tmp80_);
		_tmp82_ = _tmp81_;
		relevant_timestamp = _tmp82_;
	}
	_tmp83_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
	date_format = _tmp83_;
	_tmp84_ = mail_message_list_item_desktop_settings;
	_tmp85_ = granite_date_time_get_default_time_format (g_settings_get_enum (_tmp84_, "clock-format") == 1, FALSE);
	time_format = _tmp85_;
	_tmp86_ = g_date_time_new_from_unix_utc (relevant_timestamp);
	_tmp87_ = _tmp86_;
	_tmp88_ = g_date_time_to_local (_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = date_format;
	_tmp91_ = time_format;
	_tmp92_ = g_strdup_printf (_ ("%s at %s"), _tmp90_, _tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = g_date_time_format (_tmp89_, _tmp93_);
	_tmp95_ = _tmp94_;
	_tmp96_ = (GtkLabel*) gtk_label_new (_tmp95_);
	g_object_ref_sink (_tmp96_);
	_tmp97_ = _tmp96_;
	_g_free0 (_tmp95_);
	_g_free0 (_tmp93_);
	_g_date_time_unref0 (_tmp89_);
	_g_date_time_unref0 (_tmp87_);
	datetime_label = _tmp97_;
	_tmp98_ = datetime_label;
	_tmp99_ = gtk_widget_get_style_context ((GtkWidget*) _tmp98_);
	gtk_style_context_add_class (_tmp99_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp100_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp100_);
	_data53_->starred_icon = _tmp100_;
	_tmp101_ = _data53_->starred_icon;
	g_object_set (_tmp101_, "icon-size", (gint) GTK_ICON_SIZE_MENU, NULL);
	_tmp102_ = self->priv->_message_info;
	g_object_get (_tmp102_, "flags", &_tmp103_, NULL);
	_tmp104_ = _tmp103_;
	if ((((gint) _tmp104_) & CAMEL_MESSAGE_FLAGGED) == CAMEL_MESSAGE_FLAGGED) {
		GtkImage* _tmp105_;
		GtkImage* _tmp106_;
		_tmp105_ = _data53_->starred_icon;
		g_object_set (_tmp105_, "icon-name", "starred-symbolic", NULL);
		_tmp106_ = _data53_->starred_icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp106_, _ ("Unstar message"));
	} else {
		GtkImage* _tmp107_;
		GtkImage* _tmp108_;
		_tmp107_ = _data53_->starred_icon;
		g_object_set (_tmp107_, "icon-name", "non-starred-symbolic", NULL);
		_tmp108_ = _data53_->starred_icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp108_, _ ("Star message"));
	}
	_tmp109_ = _data53_->starred_icon;
	_tmp110_ = _g_object_ref0 ((GtkWidget*) _tmp109_);
	_tmp111_ = (GtkButton*) gtk_button_new ();
	g_object_set ((GtkContainer*) _tmp111_, "child", _tmp110_, NULL);
	_g_object_unref0 (_tmp110_);
	g_object_ref_sink (_tmp111_);
	starred_button = _tmp111_;
	_tmp112_ = starred_button;
	_tmp113_ = gtk_widget_get_style_context ((GtkWidget*) _tmp112_);
	gtk_style_context_add_class (_tmp113_, GTK_STYLE_CLASS_FLAT);
	_tmp114_ = g_menu_new ();
	upper_section = _tmp114_;
	_tmp115_ = upper_section;
	_tmp116_ = self->priv->_message_info;
	_tmp117_ = camel_message_info_get_uid (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _variant_new24 (_tmp118_);
	_tmp120_ = g_action_print_detailed_name (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_REPLY, _tmp119_);
	_tmp121_ = _tmp120_;
	g_menu_append (_tmp115_, _ ("Reply"), _tmp121_);
	_g_free0 (_tmp121_);
	_g_variant_unref0 (_tmp119_);
	_tmp122_ = upper_section;
	_tmp123_ = self->priv->_message_info;
	_tmp124_ = camel_message_info_get_uid (_tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = _variant_new25 (_tmp125_);
	_tmp127_ = g_action_print_detailed_name (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_REPLY_ALL, _tmp126_);
	_tmp128_ = _tmp127_;
	g_menu_append (_tmp122_, _ ("Reply All"), _tmp128_);
	_g_free0 (_tmp128_);
	_g_variant_unref0 (_tmp126_);
	_tmp129_ = upper_section;
	_tmp130_ = self->priv->_message_info;
	_tmp131_ = camel_message_info_get_uid (_tmp130_);
	_tmp132_ = _tmp131_;
	_tmp133_ = _variant_new26 (_tmp132_);
	_tmp134_ = g_action_print_detailed_name (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_FORWARD, _tmp133_);
	_tmp135_ = _tmp134_;
	g_menu_append (_tmp129_, _ ("Forward"), _tmp135_);
	_g_free0 (_tmp135_);
	_g_variant_unref0 (_tmp133_);
	_tmp136_ = g_menu_new ();
	lower_section = _tmp136_;
	_tmp137_ = lower_section;
	_tmp138_ = self->priv->_message_info;
	_tmp139_ = camel_message_info_get_uid (_tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = _variant_new27 (_tmp140_);
	_tmp142_ = g_action_print_detailed_name (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_PRINT, _tmp141_);
	_tmp143_ = _tmp142_;
	g_menu_append (_tmp137_, _ ("Print…"), _tmp143_);
	_g_free0 (_tmp143_);
	_g_variant_unref0 (_tmp141_);
	_tmp144_ = g_menu_new ();
	actions_menu = _tmp144_;
	_tmp145_ = actions_menu;
	_tmp146_ = upper_section;
	g_menu_append_section (_tmp145_, NULL, (GMenuModel*) _tmp146_);
	_tmp147_ = actions_menu;
	_tmp148_ = lower_section;
	g_menu_append_section (_tmp147_, NULL, (GMenuModel*) _tmp148_);
	_tmp149_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp149_);
	_tmp150_ = g_strdup (_ ("More"));
	_tmp151_ = actions_menu;
	_tmp152_ = _g_object_ref0 ((GMenuModel*) _tmp151_);
	_tmp153_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp153_, (GtkWidget*) _tmp149_);
	_g_object_unref0 (_tmp149_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp153_, _tmp150_);
	_g_free0 (_tmp150_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp153_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp153_, GTK_ALIGN_START);
	gtk_widget_set_halign ((GtkWidget*) _tmp153_, GTK_ALIGN_END);
	gtk_menu_button_set_menu_model (_tmp153_, _tmp152_);
	_g_object_unref0 (_tmp152_);
	gtk_menu_button_set_use_popover (_tmp153_, FALSE);
	g_object_ref_sink (_tmp153_);
	_data53_->actions_menu_button = _tmp153_;
	_tmp154_ = _data53_->actions_menu_button;
	_tmp155_ = gtk_widget_get_style_context ((GtkWidget*) _tmp154_);
	gtk_style_context_add_class (_tmp155_, GTK_STYLE_CLASS_FLAT);
	_tmp156_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp156_, 3);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp156_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp156_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp156_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp156_);
	action_grid = _tmp156_;
	_tmp157_ = action_grid;
	_tmp158_ = datetime_label;
	gtk_grid_attach (_tmp157_, (GtkWidget*) _tmp158_, 0, 0, 1, 1);
	_tmp159_ = action_grid;
	_tmp160_ = starred_button;
	gtk_grid_attach (_tmp159_, (GtkWidget*) _tmp160_, 2, 0, 1, 1);
	_tmp161_ = action_grid;
	_tmp162_ = _data53_->actions_menu_button;
	gtk_grid_attach (_tmp161_, (GtkWidget*) _tmp162_, 2, 1, 1, 1);
	_tmp163_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp163_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp163_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp163_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp163_, 12);
	gtk_grid_set_column_spacing (_tmp163_, 12);
	g_object_ref_sink (_tmp163_);
	header = _tmp163_;
	_tmp164_ = header;
	_tmp165_ = self->priv->avatar;
	gtk_grid_attach (_tmp164_, (GtkWidget*) _tmp165_, 0, 0, 1, 3);
	_tmp166_ = header;
	_tmp167_ = self->priv->header_stack;
	gtk_grid_attach (_tmp166_, (GtkWidget*) _tmp167_, 1, 0, 1, 3);
	_tmp168_ = header;
	_tmp169_ = action_grid;
	gtk_grid_attach (_tmp168_, (GtkWidget*) _tmp169_, 2, 0, 1, 1);
	_tmp170_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp170_);
	_data53_->header_event_box = _tmp170_;
	_tmp171_ = _data53_->header_event_box;
	_tmp172_ = _data53_->header_event_box;
	_tmp173_ = gtk_widget_get_events ((GtkWidget*) _tmp172_);
	_tmp174_ = _tmp173_;
	gtk_widget_set_events ((GtkWidget*) _tmp172_, _tmp174_ | GDK_ENTER_NOTIFY_MASK);
	_tmp175_ = _data53_->header_event_box;
	_tmp176_ = _data53_->header_event_box;
	_tmp177_ = gtk_widget_get_events ((GtkWidget*) _tmp176_);
	_tmp178_ = _tmp177_;
	gtk_widget_set_events ((GtkWidget*) _tmp176_, _tmp178_ | GDK_LEAVE_NOTIFY_MASK);
	_tmp179_ = _data53_->header_event_box;
	_tmp180_ = _data53_->header_event_box;
	_tmp181_ = gtk_widget_get_events ((GtkWidget*) _tmp180_);
	_tmp182_ = _tmp181_;
	gtk_widget_set_events ((GtkWidget*) _tmp180_, _tmp182_ | GDK_BUTTON_RELEASE_MASK);
	_tmp183_ = _data53_->header_event_box;
	_tmp184_ = header;
	gtk_container_add ((GtkContainer*) _tmp183_, (GtkWidget*) _tmp184_);
	_tmp185_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp185_, TRUE);
	g_object_ref_sink (_tmp185_);
	separator = _tmp185_;
	_tmp186_ = g_settings_new ("io.elementary.mail");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp186_;
	_tmp187_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp187_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp187_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp187_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp187_, 12);
	gtk_info_bar_set_message_type (_tmp187_, GTK_MESSAGE_INFO);
	g_object_ref_sink (_tmp187_);
	_g_object_unref0 (self->priv->calendar_info_bar);
	self->priv->calendar_info_bar = _tmp187_;
	_tmp188_ = self->priv->calendar_info_bar;
	gtk_info_bar_add_button (_tmp188_, _ ("Open in Calendar"), 1);
	_tmp189_ = self->priv->calendar_info_bar;
	_tmp190_ = gtk_widget_get_style_context ((GtkWidget*) _tmp189_);
	gtk_style_context_add_class (_tmp190_, GTK_STYLE_CLASS_FRAME);
	_tmp191_ = self->priv->calendar_info_bar;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp191_, TRUE);
	_tmp192_ = self->priv->calendar_info_bar;
	_tmp193_ = gtk_info_bar_get_content_area (_tmp192_);
	_tmp194_ = _g_object_ref0 (_tmp193_);
	calendar_info_bar_content = _tmp194_;
	_tmp195_ = calendar_info_bar_content;
	_tmp196_ = (GtkImage*) gtk_image_new_from_icon_name ("x-office-calendar", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp196_);
	_tmp197_ = _tmp196_;
	gtk_container_add (_tmp195_, (GtkWidget*) _tmp197_);
	_g_object_unref0 (_tmp197_);
	_tmp198_ = calendar_info_bar_content;
	_tmp199_ = (GtkLabel*) gtk_label_new (_ ("This message contains a Calendar Event."));
	g_object_ref_sink (_tmp199_);
	_tmp200_ = _tmp199_;
	gtk_container_add (_tmp198_, (GtkWidget*) _tmp200_);
	_g_object_unref0 (_tmp200_);
	_tmp201_ = calendar_info_bar_content;
	gtk_widget_show_all ((GtkWidget*) _tmp201_);
	_tmp202_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp202_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp202_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp202_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp202_, 12);
	gtk_info_bar_set_message_type (_tmp202_, GTK_MESSAGE_WARNING);
	g_object_ref_sink (_tmp202_);
	_g_object_unref0 (self->priv->blocked_images_infobar);
	self->priv->blocked_images_infobar = _tmp202_;
	_tmp203_ = self->priv->blocked_images_infobar;
	gtk_info_bar_add_button (_tmp203_, _ ("Show Images"), 1);
	_tmp204_ = self->priv->blocked_images_infobar;
	gtk_info_bar_add_button (_tmp204_, _ ("Always Show from Sender"), 2);
	_tmp205_ = self->priv->blocked_images_infobar;
	_tmp206_ = gtk_widget_get_style_context ((GtkWidget*) _tmp205_);
	gtk_style_context_add_class (_tmp206_, GTK_STYLE_CLASS_FRAME);
	_tmp207_ = self->priv->blocked_images_infobar;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp207_, TRUE);
	_tmp208_ = self->priv->blocked_images_infobar;
	_tmp209_ = gtk_info_bar_get_content_area (_tmp208_);
	_tmp210_ = _g_object_ref0 (_tmp209_);
	infobar_content = _tmp210_;
	_tmp211_ = infobar_content;
	_tmp212_ = (GtkLabel*) gtk_label_new (_ ("This message contains remote images."));
	g_object_ref_sink (_tmp212_);
	_tmp213_ = _tmp212_;
	gtk_container_add (_tmp211_, (GtkWidget*) _tmp213_);
	_g_object_unref0 (_tmp213_);
	_tmp214_ = infobar_content;
	gtk_widget_show_all ((GtkWidget*) _tmp214_);
	_tmp215_ = self->priv->blocked_images_infobar;
	_tmp216_ = gtk_info_bar_get_action_area (_tmp215_);
	gtk_orientable_set_orientation ((GtkOrientable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp216_, gtk_box_get_type (), GtkBox), GTK_ORIENTATION_VERTICAL);
	_tmp217_ = mail_web_view_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp217_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp217_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp217_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp217_, 12);
	mail_web_view_set_bind_height_to_page_height (_tmp217_, TRUE);
	g_object_ref_sink (_tmp217_);
	_g_object_unref0 (self->priv->web_view);
	self->priv->web_view = _tmp217_;
	_tmp218_ = self->priv->web_view;
	g_signal_connect_object ((WebKitWebView*) _tmp218_, "mouse-target-changed", (GCallback) _mail_message_list_item_on_mouse_target_changed_webkit_web_view_mouse_target_changed, self, 0);
	_tmp219_ = self->priv->web_view;
	g_signal_connect_object ((WebKitWebView*) _tmp219_, "context-menu", (GCallback) _mail_message_list_item_on_webview_context_menu_webkit_web_view_context_menu, self, 0);
	_tmp220_ = self->priv->web_view;
	g_signal_connect_object (_tmp220_, "load-finished", (GCallback) __mail_message_list_item___lambda74__mail_web_view_load_finished, self, 0);
	_tmp221_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp221_);
	secondary_box = _tmp221_;
	_tmp222_ = secondary_box;
	_tmp223_ = separator;
	gtk_container_add ((GtkContainer*) _tmp222_, (GtkWidget*) _tmp223_);
	_tmp224_ = secondary_box;
	_tmp225_ = self->priv->calendar_info_bar;
	gtk_container_add ((GtkContainer*) _tmp224_, (GtkWidget*) _tmp225_);
	_tmp226_ = secondary_box;
	_tmp227_ = self->priv->blocked_images_infobar;
	gtk_container_add ((GtkContainer*) _tmp226_, (GtkWidget*) _tmp227_);
	_tmp228_ = secondary_box;
	_tmp229_ = self->priv->web_view;
	gtk_container_add ((GtkContainer*) _tmp228_, (GtkWidget*) _tmp229_);
	_tmp230_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp230_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
	g_object_ref_sink (_tmp230_);
	_g_object_unref0 (self->priv->secondary_revealer);
	self->priv->secondary_revealer = _tmp230_;
	_tmp231_ = self->priv->secondary_revealer;
	_tmp232_ = secondary_box;
	gtk_container_add ((GtkContainer*) _tmp231_, (GtkWidget*) _tmp232_);
	_tmp233_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp233_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp233_, TRUE);
	g_object_ref_sink (_tmp233_);
	base_box = _tmp233_;
	_tmp234_ = base_box;
	_tmp235_ = _data53_->header_event_box;
	gtk_container_add ((GtkContainer*) _tmp234_, (GtkWidget*) _tmp235_);
	_tmp236_ = base_box;
	_tmp237_ = self->priv->secondary_revealer;
	gtk_container_add ((GtkContainer*) _tmp236_, (GtkWidget*) _tmp237_);
	_tmp238_ = self->priv->_message_info;
	g_object_get (_tmp238_, "flags", &_tmp239_, NULL);
	_tmp240_ = _tmp239_;
	if ((((gint) _tmp240_) & CAMEL_MESSAGE_ATTACHMENTS) == CAMEL_MESSAGE_ATTACHMENTS) {
		GtkImage* attachment_icon = NULL;
		GtkImage* _tmp241_;
		GtkImage* _tmp242_;
		GtkImage* _tmp243_;
		GtkGrid* _tmp244_;
		GtkImage* _tmp245_;
		GtkFlowBox* _tmp246_ = NULL;
		GtkFlowBox* _tmp247_;
		GtkStyleContext* _tmp248_;
		GtkFlowBox* _tmp249_;
		GtkStyleContext* _tmp250_;
		GtkBox* _tmp251_;
		GtkFlowBox* _tmp252_;
		_tmp241_ = (GtkImage*) gtk_image_new_from_icon_name ("mail-attachment-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp241_);
		attachment_icon = _tmp241_;
		_tmp242_ = attachment_icon;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp242_, 6);
		_tmp243_ = attachment_icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp243_, _ ("This message contains one or more attachments"));
		_tmp244_ = action_grid;
		_tmp245_ = attachment_icon;
		gtk_grid_attach (_tmp244_, (GtkWidget*) _tmp245_, 1, 0, 1, 1);
		_tmp246_ = (GtkFlowBox*) gtk_flow_box_new ();
		gtk_widget_set_hexpand ((GtkWidget*) _tmp246_, TRUE);
		gtk_flow_box_set_homogeneous (_tmp246_, TRUE);
		g_object_ref_sink (_tmp246_);
		_g_object_unref0 (self->priv->attachment_bar);
		self->priv->attachment_bar = _tmp246_;
		_tmp247_ = self->priv->attachment_bar;
		_tmp248_ = gtk_widget_get_style_context ((GtkWidget*) _tmp247_);
		gtk_style_context_add_class (_tmp248_, GTK_STYLE_CLASS_FLAT);
		_tmp249_ = self->priv->attachment_bar;
		_tmp250_ = gtk_widget_get_style_context ((GtkWidget*) _tmp249_);
		gtk_style_context_add_class (_tmp250_, "bottom-toolbar");
		_tmp251_ = secondary_box;
		_tmp252_ = self->priv->attachment_bar;
		gtk_container_add ((GtkContainer*) _tmp251_, (GtkWidget*) _tmp252_);
		_g_object_unref0 (attachment_icon);
	}
	_tmp253_ = base_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp253_);
	mail_message_list_item_set_expanded (self, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp254_ = g_network_monitor_get_default ();
	_tmp255_ = g_network_monitor_get_network_available (_tmp254_);
	_tmp256_ = _tmp255_;
	if (_tmp256_) {
		const gchar* _tmp257_;
		_tmp257_ = parsed_address;
		mail_message_list_item_get_gravatar (self, _tmp257_, __mail_message_list_item____lambda75__gasync_ready_callback, g_object_ref (self));
	}
	_tmp258_ = _data53_->actions_menu_button;
	g_signal_connect_data ((GtkWidget*) _tmp258_, "button-release-event", (GCallback) __mail_message_list_item___lambda76__gtk_widget_button_release_event, block53_data_ref (_data53_), (GClosureNotify) block53_data_unref, 0);
	_tmp259_ = _data53_->header_event_box;
	g_signal_connect_data ((GtkWidget*) _tmp259_, "enter-notify-event", (GCallback) __mail_message_list_item___lambda77__gtk_widget_enter_notify_event, block53_data_ref (_data53_), (GClosureNotify) block53_data_unref, 0);
	_tmp260_ = _data53_->header_event_box;
	g_signal_connect_data ((GtkWidget*) _tmp260_, "leave-notify-event", (GCallback) __mail_message_list_item___lambda78__gtk_widget_leave_notify_event, block53_data_ref (_data53_), (GClosureNotify) block53_data_unref, 0);
	_tmp261_ = _data53_->header_event_box;
	g_signal_connect_object ((GtkWidget*) _tmp261_, "button-release-event", (GCallback) __mail_message_list_item___lambda79__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) __mail_message_list_item___lambda80__gtk_widget_destroy, self, 0);
	_tmp262_ = starred_button;
	g_signal_connect_data ((GtkWidget*) _tmp262_, "button-release-event", (GCallback) __mail_message_list_item___lambda81__gtk_widget_button_release_event, block53_data_ref (_data53_), (GClosureNotify) block53_data_unref, 0);
	_tmp263_ = self->priv->web_view;
	g_signal_connect_object (_tmp263_, "image-load-blocked", (GCallback) __mail_message_list_item___lambda82__mail_web_view_image_load_blocked, self, 0);
	_tmp264_ = self->priv->web_view;
	g_signal_connect_object (_tmp264_, "link-activated", (GCallback) __mail_message_list_item___lambda83__mail_web_view_link_activated, self, 0);
	_g_object_unref0 (base_box);
	_g_object_unref0 (secondary_box);
	_g_object_unref0 (infobar_content);
	_g_object_unref0 (calendar_info_bar_content);
	_g_object_unref0 (separator);
	_g_object_unref0 (header);
	_g_object_unref0 (action_grid);
	_g_object_unref0 (actions_menu);
	_g_object_unref0 (lower_section);
	_g_object_unref0 (upper_section);
	_g_object_unref0 (starred_button);
	_g_object_unref0 (datetime_label);
	_g_free0 (time_format);
	_g_free0 (date_format);
	_g_object_unref0 (small_fields_grid);
	_g_object_unref0 (small_from_label);
	_g_free0 (cc_info);
	_g_object_unref0 (fields_grid);
	_g_object_unref0 (subject_val_label);
	_g_object_unref0 (to_val_label);
	_g_object_unref0 (from_val_label);
	_g_object_unref0 (subject_label);
	_g_object_unref0 (to_label);
	_g_object_unref0 (from_label);
	_g_object_unref0 (camel_address);
	block53_data_unref (_data53_);
	_data53_ = NULL;
	return obj;
}

static void
mail_message_list_item_class_init (MailMessageListItemClass * klass,
                                   gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	GSettings* _tmp1_;
	mail_message_list_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailMessageListItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_message_list_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_message_list_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_message_list_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_message_list_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MESSAGE_LIST_ITEM_LOADED_PROPERTY, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MESSAGE_LIST_ITEM_MESSAGE_INFO_PROPERTY, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_MESSAGE_INFO_PROPERTY] = g_param_spec_object ("message-info", "message-info", "message-info", camel_message_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MESSAGE_LIST_ITEM_MIME_MESSAGE_PROPERTY, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_MIME_MESSAGE_PROPERTY] = g_param_spec_object ("mime-message", "mime-message", "mime-message", camel_mime_message_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MESSAGE_LIST_ITEM_EXPANDED_PROPERTY, mail_message_list_item_properties[MAIL_MESSAGE_LIST_ITEM_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (mail_message_list_item_avatars);
	mail_message_list_item_avatars = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (mail_message_list_item_desktop_settings);
	mail_message_list_item_desktop_settings = _tmp1_;
}

static void
mail_message_list_item_instance_init (MailMessageListItem * self,
                                      gpointer klass)
{
	self->priv = mail_message_list_item_get_instance_private (self);
	self->priv->_mime_message = NULL;
	self->priv->attachment_bar = NULL;
	self->priv->temp_dir = NULL;
	self->priv->message_is_html = FALSE;
	self->priv->message_loaded = FALSE;
}

static void
mail_message_list_item_finalize (GObject * obj)
{
	MailMessageListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem);
	_g_object_unref0 (self->priv->_message_info);
	_g_object_unref0 (self->priv->_mime_message);
	_g_object_unref0 (self->priv->web_view);
	_g_object_unref0 (self->priv->loading_cancellable);
	_g_object_unref0 (self->priv->calendar_info_bar);
	_g_object_unref0 (self->priv->blocked_images_infobar);
	_g_object_unref0 (self->priv->secondary_revealer);
	_g_object_unref0 (self->priv->header_stack);
	_g_object_unref0 (self->priv->style_context);
	_g_object_unref0 (self->priv->avatar);
	_g_object_unref0 (self->priv->attachment_bar);
	_g_object_unref0 (self->priv->temp_dir);
	_g_free0 (self->priv->message_content);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (mail_message_list_item_parent_class)->finalize (obj);
}

static GType
mail_message_list_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailMessageListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_message_list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailMessageListItem), 0, (GInstanceInitFunc) mail_message_list_item_instance_init, NULL };
	GType mail_message_list_item_type_id;
	mail_message_list_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "MailMessageListItem", &g_define_type_info, 0);
	MailMessageListItem_private_offset = g_type_add_instance_private (mail_message_list_item_type_id, sizeof (MailMessageListItemPrivate));
	return mail_message_list_item_type_id;
}

GType
mail_message_list_item_get_type (void)
{
	static volatile gsize mail_message_list_item_type_id__once = 0;
	if (g_once_init_enter (&mail_message_list_item_type_id__once)) {
		GType mail_message_list_item_type_id;
		mail_message_list_item_type_id = mail_message_list_item_get_type_once ();
		g_once_init_leave (&mail_message_list_item_type_id__once, mail_message_list_item_type_id);
	}
	return mail_message_list_item_type_id__once;
}

static void
_vala_mail_message_list_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MailMessageListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem);
	switch (property_id) {
		case MAIL_MESSAGE_LIST_ITEM_LOADED_PROPERTY:
		g_value_set_boolean (value, mail_message_list_item_get_loaded (self));
		break;
		case MAIL_MESSAGE_LIST_ITEM_MESSAGE_INFO_PROPERTY:
		g_value_set_object (value, mail_message_list_item_get_message_info (self));
		break;
		case MAIL_MESSAGE_LIST_ITEM_MIME_MESSAGE_PROPERTY:
		g_value_set_object (value, mail_message_list_item_get_mime_message (self));
		break;
		case MAIL_MESSAGE_LIST_ITEM_EXPANDED_PROPERTY:
		g_value_set_boolean (value, mail_message_list_item_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_message_list_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MailMessageListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_MESSAGE_LIST_ITEM, MailMessageListItem);
	switch (property_id) {
		case MAIL_MESSAGE_LIST_ITEM_LOADED_PROPERTY:
		mail_message_list_item_set_loaded (self, g_value_get_boolean (value));
		break;
		case MAIL_MESSAGE_LIST_ITEM_MESSAGE_INFO_PROPERTY:
		mail_message_list_item_set_message_info (self, g_value_get_object (value));
		break;
		case MAIL_MESSAGE_LIST_ITEM_MIME_MESSAGE_PROPERTY:
		mail_message_list_item_set_mime_message (self, g_value_get_object (value));
		break;
		case MAIL_MESSAGE_LIST_ITEM_EXPANDED_PROPERTY:
		mail_message_list_item_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

