/* NetworkRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NetworkRow.vala, do not modify */

/* NetworkRow.vala
 *
 * Copyright 2020-21 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _SidebarBookmarkRowPrivate SidebarBookmarkRowPrivate;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
typedef struct _SidebarAbstractMountableRowPrivate SidebarAbstractMountableRowPrivate;

#define SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW (sidebar_volumeless_mount_row_get_type ())
#define SIDEBAR_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRow))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))

typedef struct _SidebarVolumelessMountRow SidebarVolumelessMountRow;
typedef struct _SidebarVolumelessMountRowClass SidebarVolumelessMountRowClass;
typedef struct _SidebarVolumelessMountRowPrivate SidebarVolumelessMountRowPrivate;

#define SIDEBAR_TYPE_NETWORK_ROW (sidebar_network_row_get_type ())
#define SIDEBAR_NETWORK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_NETWORK_ROW, SidebarNetworkRow))
#define SIDEBAR_NETWORK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_NETWORK_ROW, SidebarNetworkRowClass))
#define SIDEBAR_IS_NETWORK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_NETWORK_ROW))
#define SIDEBAR_IS_NETWORK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_NETWORK_ROW))
#define SIDEBAR_NETWORK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_NETWORK_ROW, SidebarNetworkRowClass))

typedef struct _SidebarNetworkRow SidebarNetworkRow;
typedef struct _SidebarNetworkRowClass SidebarNetworkRowClass;
typedef struct _SidebarNetworkRowPrivate SidebarNetworkRowPrivate;
enum  {
	SIDEBAR_NETWORK_ROW_0_PROPERTY,
	SIDEBAR_NETWORK_ROW_NUM_PROPERTIES
};
static GParamSpec* sidebar_network_row_properties[SIDEBAR_NETWORK_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SidebarNetworkRowGetFilesystemSpaceData SidebarNetworkRowGetFilesystemSpaceData;

struct _SidebarBookmarkRow {
	GtkListBoxRow parent_instance;
	SidebarBookmarkRowPrivate * priv;
	GtkGrid* content_grid;
	GtkGrid* icon_label_grid;
	GtkStack* label_stack;
	GtkEntry* editable;
	GtkLabel* label;
	GtkRevealer* drop_revealer;
	FilesFile* target_file;
};

struct _SidebarBookmarkRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*on_key_press_event) (SidebarBookmarkRow* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_release_event) (SidebarBookmarkRow* self, gint n_press, gdouble x, gdouble y);
	void (*popup_context_menu) (SidebarBookmarkRow* self);
};

struct _SidebarAbstractMountableRow {
	SidebarBookmarkRow parent_instance;
	SidebarAbstractMountableRowPrivate * priv;
	gboolean valid;
};

struct _SidebarAbstractMountableRowClass {
	SidebarBookmarkRowClass parent_class;
	void (*update_free_space) (SidebarAbstractMountableRow* self);
	void (*add_mountable_tooltip) (SidebarAbstractMountableRow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_mountable_tooltip_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	void (*on_mount_removed) (SidebarAbstractMountableRow* self, GMount* removed_mount);
	void (*on_mount_added) (SidebarAbstractMountableRow* self, GMount* added_mount);
	void (*show_mount_info) (SidebarAbstractMountableRow* self);
	void (*get_filesystem_space) (SidebarAbstractMountableRow* self, GCancellable* update_cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_filesystem_space_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	gboolean (*get_is_mounted) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_unmount) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_eject) (SidebarAbstractMountableRow* self);
};

struct _SidebarVolumelessMountRow {
	SidebarAbstractMountableRow parent_instance;
	SidebarVolumelessMountRowPrivate * priv;
};

struct _SidebarVolumelessMountRowClass {
	SidebarAbstractMountableRowClass parent_class;
};

struct _SidebarNetworkRow {
	SidebarVolumelessMountRow parent_instance;
	SidebarNetworkRowPrivate * priv;
};

struct _SidebarNetworkRowClass {
	SidebarVolumelessMountRowClass parent_class;
};

struct _SidebarNetworkRowGetFilesystemSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarNetworkRow* self;
	GCancellable* update_cancellable;
	gboolean result;
	GFile* root;
	GMount* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	GMount* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
};

static gpointer sidebar_network_row_parent_class = NULL;

VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN GType sidebar_volumeless_mount_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarVolumelessMountRow, g_object_unref)
VALA_EXTERN GType sidebar_network_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarNetworkRow, g_object_unref)
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                          GCancellable* update_cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_finish (SidebarAbstractMountableRow* self,
                                                                     GAsyncResult* _res_);
VALA_EXTERN SidebarNetworkRow* sidebar_network_row_new (const gchar* name,
                                            const gchar* uri,
                                            GIcon* gicon,
                                            SidebarSidebarListInterface* list,
                                            gboolean pinned,
                                            gboolean permanent,
                                            const gchar* _uuid,
                                            GMount* _mount);
VALA_EXTERN SidebarNetworkRow* sidebar_network_row_construct (GType object_type,
                                                  const gchar* name,
                                                  const gchar* uri,
                                                  GIcon* gicon,
                                                  SidebarSidebarListInterface* list,
                                                  gboolean pinned,
                                                  gboolean permanent,
                                                  const gchar* _uuid,
                                                  GMount* _mount);
VALA_EXTERN GMount* sidebar_abstract_mountable_row_get_mount (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_set_sort_key (SidebarAbstractMountableRow* self,
                                                  const gchar* value);
static void sidebar_network_row_real_get_filesystem_space_data_free (gpointer _data);
static void sidebar_network_row_real_get_filesystem_space (SidebarAbstractMountableRow* base,
                                                    GCancellable* update_cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean sidebar_network_row_real_get_filesystem_space_co (SidebarNetworkRowGetFilesystemSpaceData* _data_);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space_for_root (SidebarAbstractMountableRow* self,
                                                                   GFile* root,
                                                                   GCancellable* update_cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish (SidebarAbstractMountableRow* self,
                                                                              GAsyncResult* _res_);
static void sidebar_network_row_get_filesystem_space_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static GType sidebar_network_row_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

SidebarNetworkRow*
sidebar_network_row_construct (GType object_type,
                               const gchar* name,
                               const gchar* uri,
                               GIcon* gicon,
                               SidebarSidebarListInterface* list,
                               gboolean pinned,
                               gboolean permanent,
                               const gchar* _uuid,
                               GMount* _mount)
{
	SidebarNetworkRow * self = NULL;
	GMount* _tmp0_;
	GMount* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	self = (SidebarNetworkRow*) g_object_new (object_type, "custom-name", name, "uri", uri, "gicon", gicon, "list", list, "pinned", pinned, "permanent", permanent, "uuid", _uuid, "mount", _mount, NULL);
	_tmp0_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gchar* scheme = NULL;
		gchar* hostname = NULL;
		const gchar* _tmp16_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		{
			GNetworkAddress* connectable = NULL;
			GNetworkAddress* _tmp2_;
			GNetworkAddress* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			GNetworkAddress* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp2_ = g_network_address_parse_uri (uri, (guint16) 0, &_inner_error0_);
			connectable = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = connectable;
			_tmp4_ = g_network_address_get_scheme (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (scheme);
			scheme = _tmp6_;
			_tmp7_ = connectable;
			_tmp8_ = g_network_address_get_hostname (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (hostname);
			hostname = _tmp10_;
			_g_object_unref0 (connectable);
		}
		goto __finally0;
		__catch0_g_error:
		{
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			g_clear_error (&_inner_error0_);
			_tmp12_ = g_uri_parse_scheme (uri);
			_tmp11_ = _tmp12_;
			if (_tmp11_ == NULL) {
				gchar* _tmp13_;
				_tmp13_ = g_strdup ("");
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp13_;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_free0 (scheme);
			scheme = _tmp14_;
			_tmp15_ = g_strdup ("");
			_g_free0 (hostname);
			hostname = _tmp15_;
			_g_free0 (_tmp11_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (hostname);
			_g_free0 (scheme);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp16_ = scheme;
		if (g_strcmp0 (_tmp16_, "") != 0) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = scheme;
			_tmp20_ = g_strdup_printf (_ ("%s (%s)"), _tmp18_, _tmp19_);
			_tmp21_ = _tmp20_;
			sidebar_sidebar_item_interface_set_custom_name ((SidebarSidebarItemInterface*) self, _tmp21_);
			_g_free0 (_tmp21_);
		}
		_tmp22_ = hostname;
		_tmp23_ = scheme;
		_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, name, NULL);
		_tmp27_ = _tmp26_;
		sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (hostname);
		_g_free0 (scheme);
	} else {
		sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, "");
	}
	return self;
}

SidebarNetworkRow*
sidebar_network_row_new (const gchar* name,
                         const gchar* uri,
                         GIcon* gicon,
                         SidebarSidebarListInterface* list,
                         gboolean pinned,
                         gboolean permanent,
                         const gchar* _uuid,
                         GMount* _mount)
{
	return sidebar_network_row_construct (SIDEBAR_TYPE_NETWORK_ROW, name, uri, gicon, list, pinned, permanent, _uuid, _mount);
}

static void
sidebar_network_row_real_get_filesystem_space_data_free (gpointer _data)
{
	SidebarNetworkRowGetFilesystemSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->update_cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarNetworkRowGetFilesystemSpaceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sidebar_network_row_real_get_filesystem_space (SidebarAbstractMountableRow* base,
                                               GCancellable* update_cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SidebarNetworkRow * self;
	SidebarNetworkRowGetFilesystemSpaceData* _data_;
	SidebarNetworkRow* _tmp0_;
	GCancellable* _tmp1_;
	self = (SidebarNetworkRow*) base;
	_data_ = g_slice_new0 (SidebarNetworkRowGetFilesystemSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), update_cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_network_row_real_get_filesystem_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (update_cancellable);
	_g_object_unref0 (_data_->update_cancellable);
	_data_->update_cancellable = _tmp1_;
	sidebar_network_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_network_row_get_filesystem_space_finish (SidebarAbstractMountableRow* base,
                                                 GAsyncResult* _res_)
{
	gboolean result;
	SidebarNetworkRowGetFilesystemSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
sidebar_network_row_get_filesystem_space_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SidebarNetworkRowGetFilesystemSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_network_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_network_row_real_get_filesystem_space_co (SidebarNetworkRowGetFilesystemSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) _data_->self);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_mount_get_root (_data_->_tmp3_);
		_g_object_unref0 (_data_->root);
		_data_->root = _data_->_tmp4_;
	} else {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->root);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->root;
	_data_->_state_ = 1;
	sidebar_abstract_mountable_row_get_filesystem_space_for_root ((SidebarAbstractMountableRow*) _data_->self, _data_->_tmp5_, _data_->update_cancellable, sidebar_network_row_get_filesystem_space_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result = sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish ((SidebarAbstractMountableRow*) _data_->self, _data_->_res_);
	_g_object_unref0 (_data_->root);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sidebar_network_row_class_init (SidebarNetworkRowClass * klass,
                                gpointer klass_data)
{
	sidebar_network_row_parent_class = g_type_class_peek_parent (klass);
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space = (void (*) (SidebarAbstractMountableRow*, GCancellable*, GAsyncReadyCallback, gpointer)) sidebar_network_row_real_get_filesystem_space;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space_finish = (gboolean (*) (SidebarAbstractMountableRow*, GAsyncResult*)) sidebar_network_row_get_filesystem_space_finish;
}

static void
sidebar_network_row_instance_init (SidebarNetworkRow * self,
                                   gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
sidebar_network_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarNetworkRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_network_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarNetworkRow), 0, (GInstanceInitFunc) sidebar_network_row_instance_init, NULL };
	GType sidebar_network_row_type_id;
	sidebar_network_row_type_id = g_type_register_static (SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, "SidebarNetworkRow", &g_define_type_info, 0);
	return sidebar_network_row_type_id;
}

GType
sidebar_network_row_get_type (void)
{
	static volatile gsize sidebar_network_row_type_id__once = 0;
	if (g_once_init_enter (&sidebar_network_row_type_id__once)) {
		GType sidebar_network_row_type_id;
		sidebar_network_row_type_id = sidebar_network_row_get_type_once ();
		g_once_init_leave (&sidebar_network_row_type_id__once, sidebar_network_row_type_id);
	}
	return sidebar_network_row_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

