/* DriveRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DriveRow.vala, do not modify */

/* DeviceRow.vala
 *
 * Copyright 2021 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */
/* For a Drive that has no volumes (otherwise display volumes as VolumeRows)*/
/* This covers:*/
/* unformatted drives,*/
/* drives without partitions,*/
/* drives with removeable media that have no media inserted,*/
/* USB sticks that have been ejected but not unplugged.*/
/* For now these drives are not shown.*/
/*TODO Add functionality to format/partition such drives.*/

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _SidebarBookmarkRowPrivate SidebarBookmarkRowPrivate;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
typedef struct _SidebarAbstractMountableRowPrivate SidebarAbstractMountableRowPrivate;

#define SIDEBAR_TYPE_DRIVE_ROW (sidebar_drive_row_get_type ())
#define SIDEBAR_DRIVE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRow))
#define SIDEBAR_DRIVE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRowClass))
#define SIDEBAR_IS_DRIVE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_DRIVE_ROW))
#define SIDEBAR_IS_DRIVE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_DRIVE_ROW))
#define SIDEBAR_DRIVE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRowClass))

typedef struct _SidebarDriveRow SidebarDriveRow;
typedef struct _SidebarDriveRowClass SidebarDriveRowClass;
typedef struct _SidebarDriveRowPrivate SidebarDriveRowPrivate;
enum  {
	SIDEBAR_DRIVE_ROW_0_PROPERTY,
	SIDEBAR_DRIVE_ROW_IS_MOUNTED_PROPERTY,
	SIDEBAR_DRIVE_ROW_NUM_PROPERTIES
};
static GParamSpec* sidebar_drive_row_properties[SIDEBAR_DRIVE_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SidebarDriveRowAddMountableTooltipData SidebarDriveRowAddMountableTooltipData;
typedef enum  {
	MOUNTABLE_TYPE_VOLUMELESS_MOUNT,
	MOUNTABLE_TYPE_VOLUME,
	MOUNTABLE_TYPE_EMPTY_DRIVE
} MountableType;

#define TYPE_MOUNTABLE_TYPE (mountable_type_get_type ())

struct _SidebarBookmarkRow {
	GtkListBoxRow parent_instance;
	SidebarBookmarkRowPrivate * priv;
	GtkGrid* content_grid;
	GtkGrid* icon_label_grid;
	GtkStack* label_stack;
	GtkEntry* editable;
	GtkLabel* label;
	GtkRevealer* drop_revealer;
	FilesFile* target_file;
};

struct _SidebarBookmarkRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*on_key_press_event) (SidebarBookmarkRow* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_release_event) (SidebarBookmarkRow* self, gint n_press, gdouble x, gdouble y);
	void (*popup_context_menu) (SidebarBookmarkRow* self);
};

struct _SidebarAbstractMountableRow {
	SidebarBookmarkRow parent_instance;
	SidebarAbstractMountableRowPrivate * priv;
	gboolean valid;
};

struct _SidebarAbstractMountableRowClass {
	SidebarBookmarkRowClass parent_class;
	void (*update_free_space) (SidebarAbstractMountableRow* self);
	void (*add_mountable_tooltip) (SidebarAbstractMountableRow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_mountable_tooltip_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	void (*on_mount_removed) (SidebarAbstractMountableRow* self, GMount* removed_mount);
	void (*on_mount_added) (SidebarAbstractMountableRow* self, GMount* added_mount);
	void (*show_mount_info) (SidebarAbstractMountableRow* self);
	void (*get_filesystem_space) (SidebarAbstractMountableRow* self, GCancellable* update_cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_filesystem_space_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	gboolean (*get_is_mounted) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_unmount) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_eject) (SidebarAbstractMountableRow* self);
};

struct _SidebarDriveRow {
	SidebarAbstractMountableRow parent_instance;
	SidebarDriveRowPrivate * priv;
};

struct _SidebarDriveRowClass {
	SidebarAbstractMountableRowClass parent_class;
};

struct _SidebarDriveRowAddMountableTooltipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarDriveRow* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
};

static gpointer sidebar_drive_row_parent_class = NULL;
VALA_EXTERN GVolumeMonitor* sidebar_abstract_mountable_row_volume_monitor;
static SidebarSidebarItemInterfaceIface * sidebar_drive_row_sidebar_sidebar_item_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN GType sidebar_drive_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarDriveRow, g_object_unref)
VALA_EXTERN void sidebar_abstract_mountable_row_add_mountable_tooltip (SidebarAbstractMountableRow* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN void sidebar_abstract_mountable_row_add_mountable_tooltip_finish (SidebarAbstractMountableRow* self,
                                                                  GAsyncResult* _res_);
VALA_EXTERN void sidebar_bookmark_row_popup_context_menu (SidebarBookmarkRow* self);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_is_mounted (SidebarAbstractMountableRow* self);
VALA_EXTERN SidebarDriveRow* sidebar_drive_row_new (const gchar* name,
                                        const gchar* uri,
                                        GIcon* gicon,
                                        SidebarSidebarListInterface* list,
                                        gboolean pinned,
                                        gboolean permanent,
                                        const gchar* _uuid,
                                        GDrive* _drive);
VALA_EXTERN SidebarDriveRow* sidebar_drive_row_construct (GType object_type,
                                              const gchar* name,
                                              const gchar* uri,
                                              GIcon* gicon,
                                              SidebarSidebarListInterface* list,
                                              gboolean pinned,
                                              gboolean permanent,
                                              const gchar* _uuid,
                                              GDrive* _drive);
static void sidebar_drive_row_real_activated (SidebarSidebarItemInterface* base,
                                       FilesOpenFlag flag);
VALA_EXTERN GDrive* sidebar_abstract_mountable_row_get_drive (SidebarAbstractMountableRow* self);
static void sidebar_drive_row_drive_removed (SidebarDriveRow* self,
                                      GDrive* removed_drive);
static void sidebar_drive_row_volume_added (SidebarDriveRow* self,
                                     GVolume* added_volume);
static void sidebar_drive_row_set_visibility (SidebarDriveRow* self);
static void sidebar_drive_row_volume_removed (SidebarDriveRow* self);
static void sidebar_drive_row_real_add_mountable_tooltip_data_free (gpointer _data);
static void sidebar_drive_row_real_add_mountable_tooltip (SidebarAbstractMountableRow* base,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean sidebar_drive_row_real_add_mountable_tooltip_co (SidebarDriveRowAddMountableTooltipData* _data_);
static void sidebar_drive_row_real_popup_context_menu (SidebarBookmarkRow* base);
static GObject * sidebar_drive_row_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN void sidebar_abstract_mountable_row_set_sort_key (SidebarAbstractMountableRow* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_sort_key (SidebarAbstractMountableRow* self);
VALA_EXTERN GType mountable_type_get_type (void) G_GNUC_CONST ;
static void _sidebar_drive_row_drive_removed_g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender,
                                                                           GDrive* drive,
                                                                           gpointer self);
static void _sidebar_drive_row_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self);
static void _sidebar_drive_row_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                        GVolume* volume,
                                                                        gpointer self);
static GType sidebar_drive_row_get_type_once (void);
static void _vala_sidebar_drive_row_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

SidebarDriveRow*
sidebar_drive_row_construct (GType object_type,
                             const gchar* name,
                             const gchar* uri,
                             GIcon* gicon,
                             SidebarSidebarListInterface* list,
                             gboolean pinned,
                             gboolean permanent,
                             const gchar* _uuid,
                             GDrive* _drive)
{
	SidebarDriveRow * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (_drive != NULL, NULL);
	self = (SidebarDriveRow*) g_object_new (object_type, "custom-name", name, "uri", uri, "gicon", gicon, "list", list, "pinned", pinned, "permanent", permanent, "uuid", _uuid, "drive", _drive, NULL);
	return self;
}

SidebarDriveRow*
sidebar_drive_row_new (const gchar* name,
                       const gchar* uri,
                       GIcon* gicon,
                       SidebarSidebarListInterface* list,
                       gboolean pinned,
                       gboolean permanent,
                       const gchar* _uuid,
                       GDrive* _drive)
{
	return sidebar_drive_row_construct (SIDEBAR_TYPE_DRIVE_ROW, name, uri, gicon, list, pinned, permanent, _uuid, _drive);
}

static void
sidebar_drive_row_real_activated (SidebarSidebarItemInterface* base,
                                  FilesOpenFlag flag)
{
	SidebarDriveRow * self;
	GDrive* _tmp0_;
	GDrive* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GraniteMessageDialog* _tmp6_;
	GraniteMessageDialog* _tmp7_;
	self = (SidebarDriveRow*) base;
	_tmp0_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_drive_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_ ("%s contains no accessible data."), _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = pf_dialogs_show_warning_dialog (_tmp5_, _ ("To use this drive you may need to replug it, or insert media or format" \
" it."), NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

static void
sidebar_drive_row_drive_removed (SidebarDriveRow* self,
                                 GDrive* removed_drive)
{
	GDrive* _tmp0_;
	GDrive* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed_drive != NULL);
	if (!((SidebarAbstractMountableRow*) self)->valid) {
		return;
	}
	_tmp0_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == removed_drive) {
		SidebarSidebarListInterface* _tmp2_;
		SidebarSidebarListInterface* _tmp3_;
		guint32 _tmp4_;
		guint32 _tmp5_;
		((SidebarAbstractMountableRow*) self)->valid = FALSE;
		_tmp2_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
		_tmp5_ = _tmp4_;
		sidebar_sidebar_list_interface_remove_item_by_id (_tmp3_, _tmp5_);
	}
}

static void
sidebar_drive_row_volume_added (SidebarDriveRow* self,
                                GVolume* added_volume)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (added_volume != NULL);
	sidebar_drive_row_set_visibility (self);
}

static void
sidebar_drive_row_volume_removed (SidebarDriveRow* self)
{
	g_return_if_fail (self != NULL);
	sidebar_drive_row_set_visibility (self);
}

static void
sidebar_drive_row_set_visibility (SidebarDriveRow* self)
{
	g_return_if_fail (self != NULL);
	return;
}

static void
sidebar_drive_row_real_add_mountable_tooltip_data_free (gpointer _data)
{
	SidebarDriveRowAddMountableTooltipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarDriveRowAddMountableTooltipData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sidebar_drive_row_real_add_mountable_tooltip (SidebarAbstractMountableRow* base,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SidebarDriveRow * self;
	SidebarDriveRowAddMountableTooltipData* _data_;
	SidebarDriveRow* _tmp0_;
	self = (SidebarDriveRow*) base;
	_data_ = g_slice_new0 (SidebarDriveRowAddMountableTooltipData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_drive_row_real_add_mountable_tooltip_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sidebar_drive_row_real_add_mountable_tooltip_co (_data_);
}

static void
sidebar_drive_row_add_mountable_tooltip_finish (SidebarAbstractMountableRow* base,
                                                GAsyncResult* _res_)
{
	SidebarDriveRowAddMountableTooltipData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
sidebar_drive_row_real_add_mountable_tooltip_co (SidebarDriveRowAddMountableTooltipData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _data_->self, _data_->_tmp1_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
sidebar_drive_row_real_popup_context_menu (SidebarBookmarkRow* base)
{
	SidebarDriveRow * self;
	gchar* sort_key = NULL;
	GDrive* _tmp0_;
	GDrive* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	self = (SidebarDriveRow*) base;
	_tmp0_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_drive_get_sort_key (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	sort_key = _tmp3_;
	_tmp5_ = sort_key;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = sort_key;
		_tmp4_ = string_contains (_tmp6_, "hotplug");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GMenu* menu = NULL;
		GMenu* _tmp7_;
		GMenu* _tmp8_;
		GtkMenu* gtk_menu = NULL;
		GMenu* _tmp9_;
		GtkWidget* _tmp10_;
		GtkMenu* _tmp11_ = NULL;
		GtkMenu* _tmp12_;
		_tmp7_ = g_menu_new ();
		menu = _tmp7_;
		_tmp8_ = menu;
		g_menu_append (_tmp8_, _ ("Safely Remove"), "mountable.safely-remove");
		_tmp9_ = menu;
		_tmp10_ = _g_object_ref0 ((GtkWidget*) self);
		_tmp11_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp9_);
		g_object_set (_tmp11_, "attach-widget", _tmp10_, NULL);
		_g_object_unref0 (_tmp10_);
		g_object_ref_sink (_tmp11_);
		gtk_menu = _tmp11_;
		_tmp12_ = gtk_menu;
		gtk_menu_popup_at_pointer (_tmp12_, NULL);
		_g_object_unref0 (gtk_menu);
		_g_object_unref0 (menu);
	}
	_g_free0 (sort_key);
}

static gboolean
sidebar_drive_row_real_get_is_mounted (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarDriveRow* self;
	self = (SidebarDriveRow*) base;
	result = FALSE;
	return result;
}

static void
_sidebar_drive_row_drive_removed_g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender,
                                                                      GDrive* drive,
                                                                      gpointer self)
{
	sidebar_drive_row_drive_removed ((SidebarDriveRow*) self, drive);
}

static void
_sidebar_drive_row_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                               GVolume* volume,
                                                               gpointer self)
{
	sidebar_drive_row_volume_added ((SidebarDriveRow*) self, volume);
}

static void
_sidebar_drive_row_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                   GVolume* volume,
                                                                   gpointer self)
{
	sidebar_drive_row_volume_removed ((SidebarDriveRow*) self);
}

static GObject *
sidebar_drive_row_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarDriveRow * self;
	GDrive* _tmp0_;
	GDrive* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GVolumeMonitor* _tmp10_;
	GVolumeMonitor* _tmp11_;
	GVolumeMonitor* _tmp12_;
	parent_class = G_OBJECT_CLASS (sidebar_drive_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRow);
	gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
	gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	sidebar_drive_row_set_visibility (self);
	_tmp0_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_drive_get_sort_key (_tmp1_);
	sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp2_);
	_tmp3_ = sidebar_abstract_mountable_row_get_sort_key ((SidebarAbstractMountableRow*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = g_enum_to_string (TYPE_MOUNTABLE_TYPE, MOUNTABLE_TYPE_EMPTY_DRIVE);
		_tmp6_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
	}
	_tmp10_ = sidebar_abstract_mountable_row_volume_monitor;
	g_signal_connect_object (_tmp10_, "drive-disconnected", (GCallback) _sidebar_drive_row_drive_removed_g_volume_monitor_drive_disconnected, self, 0);
	_tmp11_ = sidebar_abstract_mountable_row_volume_monitor;
	g_signal_connect_object (_tmp11_, "volume-added", (GCallback) _sidebar_drive_row_volume_added_g_volume_monitor_volume_added, self, 0);
	_tmp12_ = sidebar_abstract_mountable_row_volume_monitor;
	g_signal_connect_object (_tmp12_, "volume-removed", (GCallback) _sidebar_drive_row_volume_removed_g_volume_monitor_volume_removed, self, 0);
	return obj;
}

static void
sidebar_drive_row_class_init (SidebarDriveRowClass * klass,
                              gpointer klass_data)
{
	sidebar_drive_row_parent_class = g_type_class_peek_parent (klass);
	((SidebarAbstractMountableRowClass *) klass)->add_mountable_tooltip = (void (*) (SidebarAbstractMountableRow*, GAsyncReadyCallback, gpointer)) sidebar_drive_row_real_add_mountable_tooltip;
	((SidebarAbstractMountableRowClass *) klass)->add_mountable_tooltip_finish = (void (*) (SidebarAbstractMountableRow*, GAsyncResult*)) sidebar_drive_row_add_mountable_tooltip_finish;
	((SidebarBookmarkRowClass *) klass)->popup_context_menu = (void (*) (SidebarBookmarkRow*)) sidebar_drive_row_real_popup_context_menu;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_is_mounted = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_drive_row_real_get_is_mounted;
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_drive_row_get_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_drive_row_constructor;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_DRIVE_ROW_IS_MOUNTED_PROPERTY, sidebar_drive_row_properties[SIDEBAR_DRIVE_ROW_IS_MOUNTED_PROPERTY] = g_param_spec_boolean ("is-mounted", "is-mounted", "is-mounted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
sidebar_drive_row_sidebar_sidebar_item_interface_interface_init (SidebarSidebarItemInterfaceIface * iface,
                                                                 gpointer iface_data)
{
	sidebar_drive_row_sidebar_sidebar_item_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->activated = (void (*) (SidebarSidebarItemInterface*, FilesOpenFlag)) sidebar_drive_row_real_activated;
}

static void
sidebar_drive_row_instance_init (SidebarDriveRow * self,
                                 gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
sidebar_drive_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarDriveRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_drive_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarDriveRow), 0, (GInstanceInitFunc) sidebar_drive_row_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_item_interface_info = { (GInterfaceInitFunc) sidebar_drive_row_sidebar_sidebar_item_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_drive_row_type_id;
	sidebar_drive_row_type_id = g_type_register_static (SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, "SidebarDriveRow", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_drive_row_type_id, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, &sidebar_sidebar_item_interface_info);
	return sidebar_drive_row_type_id;
}

GType
sidebar_drive_row_get_type (void)
{
	static volatile gsize sidebar_drive_row_type_id__once = 0;
	if (g_once_init_enter (&sidebar_drive_row_type_id__once)) {
		GType sidebar_drive_row_type_id;
		sidebar_drive_row_type_id = sidebar_drive_row_get_type_once ();
		g_once_init_leave (&sidebar_drive_row_type_id__once, sidebar_drive_row_type_id);
	}
	return sidebar_drive_row_type_id__once;
}

static void
_vala_sidebar_drive_row_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SidebarDriveRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_DRIVE_ROW, SidebarDriveRow);
	switch (property_id) {
		case SIDEBAR_DRIVE_ROW_IS_MOUNTED_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

