/* FileChanges.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileChanges.vala, do not modify */

/* Copyright 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include "pantheon-files-core.h"
#include <gio/gio.h>

#define FILES_FILE_CHANGES_CONSUME_CHANGES_MAX_CHUNK 20
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _files_file_changes_change_free0(var) ((var == NULL) ? NULL : (var = (files_file_changes_change_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

VALA_EXTERN GQueue* files_file_changes_queue;
GQueue* files_file_changes_queue = NULL;
VALA_EXTERN GMutex files_file_changes_queue_mutex;
GMutex files_file_changes_queue_mutex = {0};

static void files_file_changes_change_instance_init (FilesFileChangesChange * self);
VALA_EXTERN GQueue* files_file_changes_get_queue (void);
static void _files_file_changes_change_free0_ (gpointer var);
static inline void _g_queue_free__files_file_changes_change_free0_ (GQueue* self);
VALA_EXTERN void files_file_changes_queue_add_common (FilesFileChangesChange* new_item);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_array_unref0_ (gpointer var);
static inline void _g_list_free__g_array_unref0_ (GList* self);
static inline void _g_list_free__files_file_changes_change_free0_ (GList* self);
static void _vala_GFile_free_function_content_of (gpointer data);

 G_GNUC_NO_INLINE static GType
files_file_changes_kind_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_FILE_CHANGES_KIND_INITIAL, "FILES_FILE_CHANGES_KIND_INITIAL", "initial"}, {FILES_FILE_CHANGES_KIND_ADDED, "FILES_FILE_CHANGES_KIND_ADDED", "added"}, {FILES_FILE_CHANGES_KIND_CHANGED, "FILES_FILE_CHANGES_KIND_CHANGED", "changed"}, {FILES_FILE_CHANGES_KIND_FILE_REMOVED, "FILES_FILE_CHANGES_KIND_FILE_REMOVED", "file-removed"}, {FILES_FILE_CHANGES_KIND_FOLDER_REMOVED, "FILES_FILE_CHANGES_KIND_FOLDER_REMOVED", "folder-removed"}, {FILES_FILE_CHANGES_KIND_MOVED, "FILES_FILE_CHANGES_KIND_MOVED", "moved"}, {0, NULL, NULL}};
	GType files_file_changes_kind_type_id;
	files_file_changes_kind_type_id = g_enum_register_static ("FilesFileChangesKind", values);
	return files_file_changes_kind_type_id;
}

GType
files_file_changes_kind_get_type (void)
{
	static volatile gsize files_file_changes_kind_type_id__once = 0;
	if (g_once_init_enter (&files_file_changes_kind_type_id__once)) {
		GType files_file_changes_kind_type_id;
		files_file_changes_kind_type_id = files_file_changes_kind_get_type_once ();
		g_once_init_leave (&files_file_changes_kind_type_id__once, files_file_changes_kind_type_id);
	}
	return files_file_changes_kind_type_id__once;
}

FilesFileChangesChange*
files_file_changes_change_new (void)
{
	FilesFileChangesChange* self;
	self = g_slice_new0 (FilesFileChangesChange);
	files_file_changes_change_instance_init (self);
	return self;
}

static void
files_file_changes_change_instance_init (FilesFileChangesChange * self)
{
}

void
files_file_changes_change_free (FilesFileChangesChange * self)
{
	_g_object_unref0 (self->from);
	_g_object_unref0 (self->to);
	g_slice_free (FilesFileChangesChange, self);
}

static void
_files_file_changes_change_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_file_changes_change_free (var), NULL));
}

static inline void
_g_queue_free__files_file_changes_change_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _files_file_changes_change_free0_);
}

GQueue*
files_file_changes_get_queue (void)
{
	GQueue* _tmp0_;
	GQueue* _tmp2_;
	GQueue* result;
	g_mutex_lock (&files_file_changes_queue_mutex);
	_tmp0_ = files_file_changes_queue;
	if (_tmp0_ == NULL) {
		GQueue* _tmp1_;
		_tmp1_ = g_queue_new ();
		(files_file_changes_queue == NULL) ? NULL : (files_file_changes_queue = (_g_queue_free__files_file_changes_change_free0_ (files_file_changes_queue), NULL));
		files_file_changes_queue = _tmp1_;
	}
	g_mutex_unlock (&files_file_changes_queue_mutex);
	_tmp2_ = files_file_changes_queue;
	result = _tmp2_;
	return result;
}

void
files_file_changes_queue_add_common (FilesFileChangesChange* new_item)
{
	GQueue* queue = NULL;
	GQueue* _tmp0_;
	FilesFileChangesChange* last_item = NULL;
	GQueue* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	FilesFileChangesChange* _tmp5_;
	g_return_if_fail (new_item != NULL);
	_tmp0_ = files_file_changes_get_queue ();
	queue = _tmp0_;
	g_mutex_lock (&files_file_changes_queue_mutex);
	_tmp1_ = queue;
	_tmp2_ = g_queue_peek_head (_tmp1_);
	last_item = (FilesFileChangesChange*) _tmp2_;
	_tmp5_ = last_item;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		FilesFileChangesChange* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp6_ = last_item;
		_tmp7_ = _tmp6_->from;
		_tmp8_ = new_item->from;
		_tmp4_ = !g_file_equal (_tmp7_, _tmp8_);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		FilesFileChangesChange* _tmp9_;
		_tmp9_ = last_item;
		_tmp3_ = _tmp9_->kind != new_item->kind;
	}
	if (_tmp3_) {
		GQueue* _tmp10_;
		FilesFileChangesChange* _tmp11_;
		_tmp10_ = queue;
		_tmp11_ = new_item;
		new_item = NULL;
		g_queue_push_head (_tmp10_, _tmp11_);
	}
	g_mutex_unlock (&files_file_changes_queue_mutex);
	_files_file_changes_change_free0 (new_item);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
files_file_changes_queue_file_added (GFile* location,
                                     gboolean internal_origin)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_ADDED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = internal_origin;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_file_changed (GFile* location)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_CHANGED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = TRUE;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_file_removed (GFile* location)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_FILE_REMOVED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = TRUE;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_folder_removed (GFile* location)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_FOLDER_REMOVED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = TRUE;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_file_moved (GFile* from,
                                     GFile* to)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	FilesFileChangesChange* _tmp2_ = NULL;
	FilesFileChangesChange* _tmp3_;
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = _g_object_ref0 (from);
	_tmp1_ = _g_object_ref0 (to);
	_tmp2_ = files_file_changes_change_new ();
	_tmp2_->kind = FILES_FILE_CHANGES_KIND_MOVED;
	_g_object_unref0 (_tmp2_->from);
	_tmp2_->from = _tmp0_;
	_g_object_unref0 (_tmp2_->to);
	_tmp2_->to = _tmp1_;
	_tmp2_->is_internal = TRUE;
	new_item = _tmp2_;
	_tmp3_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp3_);
	_files_file_changes_change_free0 (new_item);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_g_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_array_unref (var), NULL));
}

static inline void
_g_list_free__g_array_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_array_unref0_);
}

static inline void
_g_list_free__files_file_changes_change_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _files_file_changes_change_free0_);
}

static void
_vala_GFile_free_function_content_of (gpointer data)
{
	GFile* self;
	self = *((GFile**) data);
	_g_object_unref0_ (self);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

void
files_file_changes_consume_changes (gboolean consume_all)
{
	GQueue* queue = NULL;
	GQueue* _tmp0_;
	guint chunk_count = 0U;
	gboolean flush_needed = FALSE;
	GList* changes = NULL;
	GList* file_deletions = NULL;
	GList* folder_deletions = NULL;
	GList* moves = NULL;
	GList* additions = NULL;
	_tmp0_ = files_file_changes_get_queue ();
	queue = _tmp0_;
	changes = NULL;
	file_deletions = NULL;
	folder_deletions = NULL;
	moves = NULL;
	additions = NULL;
	{
		gboolean _tmp1_ = FALSE;
		chunk_count = (guint) 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			FilesFileChangesChange* change = NULL;
			GQueue* _tmp3_;
			gpointer _tmp4_;
			FilesFileChangesChange* _tmp5_;
			FilesFileChangesChange* _tmp32_;
			FilesFileChangesChange* _tmp33_;
			if (!_tmp1_) {
				guint _tmp2_;
				_tmp2_ = chunk_count;
				chunk_count = _tmp2_ + 1;
			}
			_tmp1_ = FALSE;
			g_mutex_lock (&files_file_changes_queue_mutex);
			_tmp3_ = queue;
			_tmp4_ = g_queue_pop_tail (_tmp3_);
			change = (FilesFileChangesChange*) _tmp4_;
			g_mutex_unlock (&files_file_changes_queue_mutex);
			_tmp5_ = change;
			if (_tmp5_ == NULL) {
				flush_needed = TRUE;
			} else {
				gboolean _tmp6_ = FALSE;
				GList* _tmp7_;
				gboolean _tmp9_ = FALSE;
				GList* _tmp10_;
				gboolean _tmp12_ = FALSE;
				GList* _tmp13_;
				gboolean _tmp15_ = FALSE;
				GList* _tmp16_;
				gboolean _tmp18_ = FALSE;
				GList* _tmp19_;
				gboolean _tmp21_ = FALSE;
				_tmp7_ = additions;
				if (_tmp7_ != NULL) {
					FilesFileChangesChange* _tmp8_;
					_tmp8_ = change;
					_tmp6_ = _tmp8_->kind != FILES_FILE_CHANGES_KIND_ADDED;
				} else {
					_tmp6_ = FALSE;
				}
				flush_needed = _tmp6_;
				_tmp10_ = changes;
				if (_tmp10_ != NULL) {
					FilesFileChangesChange* _tmp11_;
					_tmp11_ = change;
					_tmp9_ = _tmp11_->kind != FILES_FILE_CHANGES_KIND_CHANGED;
				} else {
					_tmp9_ = FALSE;
				}
				flush_needed |= _tmp9_;
				_tmp13_ = moves;
				if (_tmp13_ != NULL) {
					FilesFileChangesChange* _tmp14_;
					_tmp14_ = change;
					_tmp12_ = _tmp14_->kind != FILES_FILE_CHANGES_KIND_MOVED;
				} else {
					_tmp12_ = FALSE;
				}
				flush_needed |= _tmp12_;
				_tmp16_ = file_deletions;
				if (_tmp16_ != NULL) {
					FilesFileChangesChange* _tmp17_;
					_tmp17_ = change;
					_tmp15_ = _tmp17_->kind != FILES_FILE_CHANGES_KIND_FILE_REMOVED;
				} else {
					_tmp15_ = FALSE;
				}
				flush_needed |= _tmp15_;
				_tmp19_ = folder_deletions;
				if (_tmp19_ != NULL) {
					FilesFileChangesChange* _tmp20_;
					_tmp20_ = change;
					_tmp18_ = _tmp20_->kind != FILES_FILE_CHANGES_KIND_FOLDER_REMOVED;
				} else {
					_tmp18_ = FALSE;
				}
				flush_needed |= _tmp18_;
				if (!consume_all) {
					_tmp21_ = chunk_count >= ((guint) FILES_FILE_CHANGES_CONSUME_CHANGES_MAX_CHUNK);
				} else {
					_tmp21_ = FALSE;
				}
				flush_needed |= _tmp21_;
			}
			if (flush_needed) {
				GList* _tmp22_;
				GList* _tmp24_;
				GList* _tmp26_;
				GList* _tmp28_;
				GList* _tmp30_;
				_tmp22_ = file_deletions;
				if (_tmp22_ != NULL) {
					GList* _tmp23_;
					file_deletions = g_list_reverse (file_deletions);
					_tmp23_ = file_deletions;
					files_directory_notify_files_removed (_tmp23_);
					(file_deletions == NULL) ? NULL : (file_deletions = (_g_list_free__g_object_unref0_ (file_deletions), NULL));
					file_deletions = NULL;
				}
				_tmp24_ = folder_deletions;
				if (_tmp24_ != NULL) {
					GList* _tmp25_;
					folder_deletions = g_list_reverse (folder_deletions);
					_tmp25_ = folder_deletions;
					files_directory_notify_files_removed (_tmp25_);
					(folder_deletions == NULL) ? NULL : (folder_deletions = (_g_list_free__g_object_unref0_ (folder_deletions), NULL));
					folder_deletions = NULL;
				}
				_tmp26_ = moves;
				if (_tmp26_ != NULL) {
					GList* _tmp27_;
					moves = g_list_reverse (moves);
					_tmp27_ = moves;
					files_directory_notify_files_moved (_tmp27_);
					(moves == NULL) ? NULL : (moves = (_g_list_free__g_array_unref0_ (moves), NULL));
					moves = NULL;
				}
				_tmp28_ = additions;
				if (_tmp28_ != NULL) {
					GList* _tmp29_;
					additions = g_list_reverse (additions);
					_tmp29_ = additions;
					files_directory_notify_changes_added (_tmp29_);
					(additions == NULL) ? NULL : (additions = (_g_list_free__files_file_changes_change_free0_ (additions), NULL));
					additions = NULL;
				}
				_tmp30_ = changes;
				if (_tmp30_ != NULL) {
					GList* _tmp31_;
					changes = g_list_reverse (changes);
					_tmp31_ = changes;
					files_directory_notify_files_changed (_tmp31_);
					(changes == NULL) ? NULL : (changes = (_g_list_free__g_object_unref0_ (changes), NULL));
					changes = NULL;
				}
			}
			_tmp32_ = change;
			if (_tmp32_ == NULL) {
				_files_file_changes_change_free0 (change);
				(additions == NULL) ? NULL : (additions = (_g_list_free__files_file_changes_change_free0_ (additions), NULL));
				(moves == NULL) ? NULL : (moves = (_g_list_free__g_array_unref0_ (moves), NULL));
				(folder_deletions == NULL) ? NULL : (folder_deletions = (_g_list_free__g_object_unref0_ (folder_deletions), NULL));
				(file_deletions == NULL) ? NULL : (file_deletions = (_g_list_free__g_object_unref0_ (file_deletions), NULL));
				(changes == NULL) ? NULL : (changes = (_g_list_free__g_object_unref0_ (changes), NULL));
				return;
			}
			_tmp33_ = change;
			switch (_tmp33_->kind) {
				case FILES_FILE_CHANGES_KIND_ADDED:
				{
					GList* _tmp34_;
					FilesFileChangesChange* _tmp35_;
					_tmp34_ = additions;
					if (_tmp34_ == NULL) {
						(additions == NULL) ? NULL : (additions = (_g_list_free__files_file_changes_change_free0_ (additions), NULL));
						additions = NULL;
					}
					_tmp35_ = change;
					change = NULL;
					additions = g_list_prepend (additions, _tmp35_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_CHANGED:
				{
					GList* _tmp36_;
					FilesFileChangesChange* _tmp37_;
					GFile* _tmp38_;
					GFile* _tmp39_;
					_tmp36_ = changes;
					if (_tmp36_ == NULL) {
						(changes == NULL) ? NULL : (changes = (_g_list_free__g_object_unref0_ (changes), NULL));
						changes = NULL;
					}
					_tmp37_ = change;
					_tmp38_ = _tmp37_->from;
					_tmp39_ = _g_object_ref0 (_tmp38_);
					changes = g_list_prepend (changes, _tmp39_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_FILE_REMOVED:
				{
					GList* _tmp40_;
					FilesFileChangesChange* _tmp41_;
					GFile* _tmp42_;
					GFile* _tmp43_;
					_tmp40_ = file_deletions;
					if (_tmp40_ == NULL) {
						(file_deletions == NULL) ? NULL : (file_deletions = (_g_list_free__g_object_unref0_ (file_deletions), NULL));
						file_deletions = NULL;
					}
					_tmp41_ = change;
					_tmp42_ = _tmp41_->from;
					_tmp43_ = _g_object_ref0 (_tmp42_);
					file_deletions = g_list_prepend (file_deletions, _tmp43_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_FOLDER_REMOVED:
				{
					GList* _tmp44_;
					FilesFileChangesChange* _tmp45_;
					GFile* _tmp46_;
					GFile* _tmp47_;
					_tmp44_ = folder_deletions;
					if (_tmp44_ == NULL) {
						(folder_deletions == NULL) ? NULL : (folder_deletions = (_g_list_free__g_object_unref0_ (folder_deletions), NULL));
						folder_deletions = NULL;
					}
					_tmp45_ = change;
					_tmp46_ = _tmp45_->from;
					_tmp47_ = _g_object_ref0 (_tmp46_);
					folder_deletions = g_list_prepend (folder_deletions, _tmp47_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_MOVED:
				{
					GList* _tmp48_;
					GArray* pair = NULL;
					GArray* _tmp49_;
					GArray* _tmp50_;
					FilesFileChangesChange* _tmp51_;
					GFile* _tmp52_;
					GFile* _tmp53_;
					GArray* _tmp54_;
					FilesFileChangesChange* _tmp55_;
					GFile* _tmp56_;
					GFile* _tmp57_;
					GArray* _tmp58_;
					GArray* _tmp59_;
					_tmp48_ = moves;
					if (_tmp48_ == NULL) {
						(moves == NULL) ? NULL : (moves = (_g_list_free__g_array_unref0_ (moves), NULL));
						moves = NULL;
					}
					_tmp49_ = g_array_sized_new (FALSE, FALSE, sizeof (GFile*), (guint) 2);
					g_array_set_clear_func (_tmp49_, (GDestroyNotify) _vala_GFile_free_function_content_of);
					pair = _tmp49_;
					_tmp50_ = pair;
					_tmp51_ = change;
					_tmp52_ = _tmp51_->from;
					_tmp53_ = _g_object_ref0 (_tmp52_);
					g_array_append_val (_tmp50_, _tmp53_);
					_tmp54_ = pair;
					_tmp55_ = change;
					_tmp56_ = _tmp55_->to;
					_tmp57_ = _g_object_ref0 (_tmp56_);
					g_array_append_val (_tmp54_, _tmp57_);
					_tmp58_ = pair;
					_tmp59_ = _g_array_ref0 (_tmp58_);
					moves = g_list_prepend (moves, _tmp59_);
					_g_array_unref0 (pair);
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			_files_file_changes_change_free0 (change);
		}
	}
}

