/* EventButton.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EventButton.vala, do not modify */

/*
 * Copyright 2011-2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libecal/libecal.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libedataserver/libedataserver.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <handy.h>
#include "elementary-calendar.h"
#include <libical-glib/libical-glib.h>

#define EVENT_CSS "\n    @define-color accent_color %s;\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_EVENT_BUTTON (maya_view_event_button_get_type ())
#define MAYA_VIEW_EVENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton))
#define MAYA_VIEW_EVENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButtonClass))
#define MAYA_VIEW_IS_EVENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON))
#define MAYA_VIEW_IS_EVENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_BUTTON))
#define MAYA_VIEW_EVENT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButtonClass))

typedef struct _MayaViewEventButton MayaViewEventButton;
typedef struct _MayaViewEventButtonClass MayaViewEventButtonClass;
typedef struct _MayaViewEventButtonPrivate MayaViewEventButtonPrivate;
enum  {
	MAYA_VIEW_EVENT_BUTTON_0_PROPERTY,
	MAYA_VIEW_EVENT_BUTTON_COMP_PROPERTY,
	MAYA_VIEW_EVENT_BUTTON_NUM_PROPERTIES
};
static GParamSpec* maya_view_event_button_properties[MAYA_VIEW_EVENT_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))
#define __vala_ECalComponentText_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentText_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block26Data Block26Data;

#define MAYA_TYPE_APPLICATION (maya_application_get_type ())
#define MAYA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_APPLICATION, MayaApplication))
#define MAYA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_APPLICATION, MayaApplicationClass))
#define MAYA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_APPLICATION))
#define MAYA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_APPLICATION))
#define MAYA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_APPLICATION, MayaApplicationClass))

typedef struct _MayaApplication MayaApplication;
typedef struct _MayaApplicationClass MayaApplicationClass;
typedef struct _MayaApplicationPrivate MayaApplicationPrivate;

#define MAYA_TYPE_MAIN_WINDOW (maya_main_window_get_type ())
#define MAYA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindow))
#define MAYA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))
#define MAYA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))

typedef struct _MayaMainWindow MayaMainWindow;
typedef struct _MayaMainWindowClass MayaMainWindowClass;

#define MAYA_TYPE_EVENT_MENU (maya_event_menu_get_type ())
#define MAYA_EVENT_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_EVENT_MENU, MayaEventMenu))
#define MAYA_EVENT_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_EVENT_MENU, MayaEventMenuClass))
#define MAYA_IS_EVENT_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_EVENT_MENU))
#define MAYA_IS_EVENT_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_EVENT_MENU))
#define MAYA_EVENT_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_EVENT_MENU, MayaEventMenuClass))

typedef struct _MayaEventMenu MayaEventMenu;
typedef struct _MayaEventMenuClass MayaEventMenuClass;

struct _MayaViewEventButton {
	GtkRevealer parent_instance;
	MayaViewEventButtonPrivate * priv;
};

struct _MayaViewEventButtonClass {
	GtkRevealerClass parent_class;
};

struct _MayaViewEventButtonPrivate {
	ECalComponent* _comp;
	GtkLabel* label;
	GtkStyleContext* grid_style_context;
};

struct _Block26Data {
	int _ref_count_;
	MayaViewEventButton* self;
	ESourceCalendar* cal;
};

struct _MayaApplication {
	GtkApplication parent_instance;
	MayaApplicationPrivate * priv;
	MayaMainWindow* window;
};

struct _MayaApplicationClass {
	GtkApplicationClass parent_class;
};

static gint MayaViewEventButton_private_offset;
static gpointer maya_view_event_button_parent_class = NULL;
static GtkCssProvider* maya_view_event_button_css_provider;
static GtkCssProvider* maya_view_event_button_css_provider = NULL;

VALA_EXTERN GType maya_view_event_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventButton, g_object_unref)
VALA_EXTERN MayaViewEventButton* maya_view_event_button_new (ECalComponent* comp);
VALA_EXTERN MayaViewEventButton* maya_view_event_button_construct (GType object_type,
                                                       ECalComponent* comp);
VALA_EXTERN gchar* maya_view_event_button_get_uid (MayaViewEventButton* self);
VALA_EXTERN ECalComponent* maya_view_event_button_get_comp (MayaViewEventButton* self);
static void _vala_ECalComponentId_free (ECalComponentId* self);
VALA_EXTERN void maya_view_event_button_update (MayaViewEventButton* self,
                                    ECalComponent* modified);
VALA_EXTERN void maya_view_event_button_set_comp (MayaViewEventButton* self,
                                      ECalComponent* value);
static void _vala_ECalComponentText_free (ECalComponentText* self);
static void maya_view_event_button_reload_css (MayaViewEventButton* self,
                                        const gchar* background_color);
VALA_EXTERN void maya_view_event_button_destroy_button (MayaViewEventButton* self);
static gboolean __lambda12_ (MayaViewEventButton* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static GObject * maya_view_event_button_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gboolean _maya_view_event_button___lambda13_ (MayaViewEventButton* self,
                                              GdkEventButton* event);
VALA_EXTERN GType maya_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaApplication, g_object_unref)
VALA_EXTERN GType maya_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaMainWindow, g_object_unref)
VALA_EXTERN void maya_main_window_on_modified (MayaMainWindow* self,
                                   ECalComponent* comp);
VALA_EXTERN GType maya_event_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaEventMenu, g_object_unref)
VALA_EXTERN MayaEventMenu* maya_event_menu_new (ECalComponent* comp);
VALA_EXTERN MayaEventMenu* maya_event_menu_construct (GType object_type,
                                          ECalComponent* comp);
static gboolean __maya_view_event_button___lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self);
static void _maya_view_event_button___lambda122_ (MayaViewEventButton* self,
                                           GdkDragContext* ctx,
                                           GtkSelectionData* sel,
                                           guint info,
                                           guint time);
static void __maya_view_event_button___lambda122__gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                     GdkDragContext* context,
                                                                     GtkSelectionData* selection_data,
                                                                     guint info,
                                                                     guint time_,
                                                                     gpointer self);
static void _maya_view_event_button___lambda123_ (Block26Data* _data26_);
static void __maya_view_event_button___lambda123__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void maya_view_event_button_finalize (GObject * obj);
static GType maya_view_event_button_get_type_once (void);
static void _vala_maya_view_event_button_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_maya_view_event_button_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
maya_view_event_button_get_instance_private (MayaViewEventButton* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewEventButton_private_offset);
}

MayaViewEventButton*
maya_view_event_button_construct (GType object_type,
                                  ECalComponent* comp)
{
	MayaViewEventButton * self = NULL;
	g_return_val_if_fail (comp != NULL, NULL);
	self = (MayaViewEventButton*) g_object_new (object_type, "comp", comp, NULL);
	return self;
}

MayaViewEventButton*
maya_view_event_button_new (ECalComponent* comp)
{
	return maya_view_event_button_construct (MAYA_VIEW_TYPE_EVENT_BUTTON, comp);
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

gchar*
maya_view_event_button_get_uid (MayaViewEventButton* self)
{
	ECalComponent* _tmp0_;
	ECalComponentId* _tmp1_;
	ECalComponentId* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comp;
	_tmp1_ = e_cal_component_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = e_cal_component_id_get_uid (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	__vala_ECalComponentId_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

static void
_vala_ECalComponentText_free (ECalComponentText* self)
{
	g_boxed_free (e_cal_component_text_get_type (), self);
}

void
maya_view_event_button_update (MayaViewEventButton* self,
                               ECalComponent* modified)
{
	GtkLabel* _tmp0_;
	ECalComponent* _tmp1_;
	ECalComponentText* _tmp2_;
	ECalComponentText* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modified != NULL);
	maya_view_event_button_set_comp (self, modified);
	_tmp0_ = self->priv->label;
	_tmp1_ = self->priv->_comp;
	_tmp2_ = e_cal_component_get_summary (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_text_get_value (_tmp3_);
	gtk_label_set_label (_tmp0_, _tmp4_);
	__vala_ECalComponentText_free0 (_tmp3_);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
maya_view_event_button_reload_css (MayaViewEventButton* self,
                                   const gchar* background_color)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background_color != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		gchar* colored_css = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GtkStyleContext* _tmp7_;
		_tmp1_ = string_slice (background_color, (glong) 0, (glong) 7);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf (EVENT_CSS, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		colored_css = _tmp4_;
		_tmp5_ = strlen (colored_css);
		_tmp6_ = _tmp5_;
		gtk_css_provider_load_from_data (provider, colored_css, (gssize) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (colored_css);
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->grid_style_context;
		gtk_style_context_add_provider (_tmp7_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_free0 (colored_css);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("EventButton.vala:131: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (provider);
}

static gboolean
__lambda12_ (MayaViewEventButton* self)
{
	gboolean result;
	gtk_widget_destroy ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((MayaViewEventButton*) self);
	return result;
}

void
maya_view_event_button_destroy_button (MayaViewEventButton* self)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
	_tmp0_ = gtk_revealer_get_transition_duration ((GtkRevealer*) self);
	_tmp1_ = _tmp0_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp1_, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

ECalComponent*
maya_view_event_button_get_comp (MayaViewEventButton* self)
{
	ECalComponent* result;
	ECalComponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comp;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
maya_view_event_button_set_comp (MayaViewEventButton* self,
                                 ECalComponent* value)
{
	ECalComponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_event_button_get_comp (self);
	if (old_value != value) {
		ECalComponent* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_comp);
		self->priv->_comp = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_event_button_properties[MAYA_VIEW_EVENT_BUTTON_COMP_PROPERTY]);
	}
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		MayaViewEventButton* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->cal);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static gboolean
_maya_view_event_button___lambda13_ (MayaViewEventButton* self,
                                     GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type == GDK_2BUTTON_PRESS) {
		_tmp0_ = event->button == ((guint) GDK_BUTTON_PRIMARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GApplication* _tmp1_;
		MayaMainWindow* _tmp2_;
		ECalComponent* _tmp3_;
		_tmp1_ = g_application_get_default ();
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MAYA_TYPE_APPLICATION, MayaApplication)->window;
		_tmp3_ = self->priv->_comp;
		maya_main_window_on_modified (_tmp2_, _tmp3_);
	} else {
		gboolean _tmp4_ = FALSE;
		if (event->type == GDK_BUTTON_PRESS) {
			_tmp4_ = event->button == ((guint) GDK_BUTTON_SECONDARY);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ESource* src = NULL;
			ECalComponent* _tmp5_;
			gconstpointer _tmp6_;
			ESource* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ESource* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			gboolean sensitive = FALSE;
			MayaEventMenu* menu = NULL;
			ECalComponent* _tmp15_;
			MayaEventMenu* _tmp16_;
			MayaEventMenu* _tmp17_;
			MayaEventMenu* _tmp18_;
			MayaEventMenu* _tmp19_;
			_tmp5_ = self->priv->_comp;
			_tmp6_ = g_object_get_data ((GObject*) _tmp5_, "source");
			_tmp7_ = _g_object_ref0 ((ESource*) _tmp6_);
			src = _tmp7_;
			_tmp9_ = src;
			_tmp10_ = e_source_get_writable (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == TRUE) {
				CalendarEventStore* _tmp12_;
				CalendarEventStore* _tmp13_;
				ESource* _tmp14_;
				_tmp12_ = calendar_event_store_get_default ();
				_tmp13_ = _tmp12_;
				_tmp14_ = src;
				_tmp8_ = calendar_event_store_calclient_is_readonly (_tmp13_, _tmp14_) == FALSE;
				_g_object_unref0 (_tmp13_);
			} else {
				_tmp8_ = FALSE;
			}
			sensitive = _tmp8_;
			_tmp15_ = self->priv->_comp;
			_tmp16_ = maya_event_menu_new (_tmp15_);
			g_object_ref_sink (_tmp16_);
			menu = _tmp16_;
			_tmp17_ = menu;
			gtk_menu_attach_to_widget ((GtkMenu*) _tmp17_, (GtkWidget*) self, NULL);
			_tmp18_ = menu;
			gtk_menu_popup_at_pointer ((GtkMenu*) _tmp18_, (GdkEvent*) event);
			_tmp19_ = menu;
			gtk_widget_show_all ((GtkWidget*) _tmp19_);
			_g_object_unref0 (menu);
			_g_object_unref0 (src);
		} else {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
__maya_view_event_button___lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self)
{
	gboolean result;
	result = _maya_view_event_button___lambda13_ ((MayaViewEventButton*) self, event);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_maya_view_event_button___lambda122_ (MayaViewEventButton* self,
                                      GdkDragContext* ctx,
                                      GtkSelectionData* sel,
                                      guint info,
                                      guint time)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	ECalComponent* _tmp2_;
	ICalComponent* icalcomp = NULL;
	ECalComponent* _tmp3_;
	ICalComponent* _tmp4_;
	gchar* ical_str = NULL;
	ICalComponent* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_comp;
	calendar_event_store_set_drag_component (_tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->_comp;
	_tmp4_ = e_cal_component_get_icalcomponent (_tmp3_);
	icalcomp = _tmp4_;
	_tmp5_ = icalcomp;
	_tmp6_ = i_cal_component_as_ical_string (_tmp5_);
	ical_str = _tmp6_;
	_tmp7_ = ical_str;
	_tmp8_ = ical_str;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_selection_data_set_text (sel, _tmp7_, _tmp10_);
	{
		gchar* path = NULL;
		const gchar* _tmp11_;
		ICalComponent* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GFile* file = NULL;
		const gchar* _tmp18_;
		GFile* _tmp19_;
		gboolean _tmp20_ = FALSE;
		GFile* _tmp21_;
		const gchar* _tmp22_;
		guint8* _tmp23_;
		gint _tmp23__length1;
		gint _tmp24_ = 0;
		guint8* _tmp25_;
		gint _tmp25__length1;
		_tmp11_ = g_get_tmp_dir ();
		_tmp12_ = icalcomp;
		_tmp13_ = i_cal_component_get_summary (_tmp12_);
		_tmp14_ = g_strconcat (_tmp13_, ".ics", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_build_filename (_tmp11_, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		path = _tmp17_;
		_tmp18_ = path;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		file = _tmp19_;
		_tmp21_ = file;
		_tmp22_ = ical_str;
		_tmp23_ = string_get_data (_tmp22_, &_tmp24_);
		_tmp23__length1 = _tmp24_;
		_tmp25_ = _tmp23_;
		_tmp25__length1 = _tmp23__length1;
		_tmp20_ = g_file_replace_contents (_tmp21_, (const char*) _tmp25_, (gsize) _tmp25__length1, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (path);
			goto __catch0_g_error;
		}
		if (_tmp20_) {
			GFile* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			_tmp26_ = file;
			_tmp27_ = g_file_get_uri (_tmp26_);
			_tmp28_ = g_new0 (gchar*, 1 + 1);
			_tmp28_[0] = _tmp27_;
			_tmp29_ = _tmp28_;
			_tmp29__length1 = 1;
			gtk_selection_data_set_uris (sel, _tmp29_);
			_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (file);
		_g_free0 (path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_critical ("EventButton.vala:99: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (ical_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (ical_str);
}

static void
__maya_view_event_button___lambda122__gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                GdkDragContext* context,
                                                                GtkSelectionData* selection_data,
                                                                guint info,
                                                                guint time_,
                                                                gpointer self)
{
	_maya_view_event_button___lambda122_ ((MayaViewEventButton*) self, context, selection_data, info, time_);
}

static void
_maya_view_event_button___lambda123_ (Block26Data* _data26_)
{
	MayaViewEventButton* self;
	ESourceCalendar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data26_->self;
	_tmp0_ = _data26_->cal;
	_tmp1_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp0_);
	_tmp2_ = _tmp1_;
	maya_view_event_button_reload_css (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__maya_view_event_button___lambda123__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_maya_view_event_button___lambda123_ (self);
}

static GObject *
maya_view_event_button_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewEventButton * self;
	Block26Data* _data26_;
	ECalComponent* _tmp0_;
	ECalComponentText* _tmp1_;
	ECalComponentText* _tmp2_;
	const gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkGrid* internal_grid = NULL;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkLabel* _tmp11_;
	GtkGrid* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkCssProvider* _tmp17_;
	GtkEventBox* event_box = NULL;
	GtkEventBox* _tmp18_;
	GtkEventBox* _tmp19_;
	GtkEventBox* _tmp20_;
	GdkEventMask _tmp21_;
	GdkEventMask _tmp22_;
	GtkEventBox* _tmp23_;
	GtkEventBox* _tmp24_;
	GdkEventMask _tmp25_;
	GdkEventMask _tmp26_;
	GtkEventBox* _tmp27_;
	GtkEventBox* _tmp28_;
	GdkEventMask _tmp29_;
	GdkEventMask _tmp30_;
	GtkEventBox* _tmp31_;
	GtkGrid* _tmp32_;
	GtkEventBox* _tmp33_;
	GtkEventBox* _tmp34_;
	GtkTargetEntry dnd = {0};
	GtkTargetEntry _tmp35_ = {0};
	GtkTargetEntry dnd2 = {0};
	GtkTargetEntry _tmp36_ = {0};
	GtkEventBox* _tmp37_;
	GtkTargetEntry _tmp38_;
	GtkTargetEntry _tmp39_;
	GtkTargetEntry* _tmp40_;
	GtkTargetEntry* _tmp41_;
	gint _tmp41__length1;
	GtkEventBox* _tmp42_;
	ESource* source = NULL;
	ECalComponent* _tmp43_;
	gconstpointer _tmp44_;
	ESource* _tmp45_;
	ESource* _tmp46_;
	ESourceExtension* _tmp47_;
	ESourceCalendar* _tmp48_;
	ESourceCalendar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	ESourceCalendar* _tmp52_;
	parent_class = G_OBJECT_CLASS (maya_view_event_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	gtk_revealer_set_transition_type ((GtkRevealer*) self, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp0_ = self->priv->_comp;
	_tmp1_ = e_cal_component_get_summary (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = e_cal_component_text_get_value (_tmp2_);
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp4_;
	__vala_ECalComponentText_free0 (_tmp2_);
	_tmp5_ = self->priv->label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->label;
	gtk_label_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_END);
	_tmp7_ = self->priv->label;
	gtk_label_set_xalign (_tmp7_, (gfloat) 0);
	_tmp8_ = self->priv->label;
	gtk_widget_show ((GtkWidget*) _tmp8_);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	internal_grid = _tmp9_;
	_tmp10_ = internal_grid;
	_tmp11_ = self->priv->label;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = internal_grid;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->grid_style_context);
	self->priv->grid_style_context = _tmp14_;
	_tmp15_ = self->priv->grid_style_context;
	gtk_style_context_add_class (_tmp15_, "event");
	_tmp16_ = self->priv->grid_style_context;
	_tmp17_ = maya_view_event_button_css_provider;
	gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp18_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp18_);
	event_box = _tmp18_;
	_tmp19_ = event_box;
	_tmp20_ = event_box;
	_tmp21_ = gtk_widget_get_events ((GtkWidget*) _tmp20_);
	_tmp22_ = _tmp21_;
	gtk_widget_set_events ((GtkWidget*) _tmp20_, _tmp22_ | GDK_BUTTON_PRESS_MASK);
	_tmp23_ = event_box;
	_tmp24_ = event_box;
	_tmp25_ = gtk_widget_get_events ((GtkWidget*) _tmp24_);
	_tmp26_ = _tmp25_;
	gtk_widget_set_events ((GtkWidget*) _tmp24_, _tmp26_ | GDK_SCROLL_MASK);
	_tmp27_ = event_box;
	_tmp28_ = event_box;
	_tmp29_ = gtk_widget_get_events ((GtkWidget*) _tmp28_);
	_tmp30_ = _tmp29_;
	gtk_widget_set_events ((GtkWidget*) _tmp28_, _tmp30_ | GDK_SMOOTH_SCROLL_MASK);
	_tmp31_ = event_box;
	_tmp32_ = internal_grid;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_tmp34_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp34_, "button-press-event", (GCallback) __maya_view_event_button___lambda13__gtk_widget_button_press_event, self, 0);
	_tmp35_.target = "binary/calendar";
	_tmp35_.flags = (guint) 0;
	_tmp35_.info = (guint) 0;
	dnd = _tmp35_;
	_tmp36_.target = "text/uri-list";
	_tmp36_.flags = (guint) 0;
	_tmp36_.info = (guint) 0;
	dnd2 = _tmp36_;
	_tmp37_ = event_box;
	_tmp38_ = dnd;
	_tmp39_ = dnd2;
	_tmp40_ = g_new0 (GtkTargetEntry, 2);
	_tmp40_[0] = _tmp38_;
	_tmp40_[1] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 2;
	gtk_drag_source_set ((GtkWidget*) _tmp37_, GDK_BUTTON1_MASK, _tmp41_, (gint) 2, GDK_ACTION_MOVE);
	_tmp41_ = (g_free (_tmp41_), NULL);
	_tmp42_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp42_, "drag-data-get", (GCallback) __maya_view_event_button___lambda122__gtk_widget_drag_data_get, self, 0);
	_tmp43_ = self->priv->_comp;
	_tmp44_ = g_object_get_data ((GObject*) _tmp43_, "source");
	_tmp45_ = _g_object_ref0 ((ESource*) _tmp44_);
	source = _tmp45_;
	_tmp46_ = source;
	_tmp47_ = e_source_get_extension (_tmp46_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, e_source_calendar_get_type (), ESourceCalendar));
	_data26_->cal = _tmp48_;
	_tmp49_ = _data26_->cal;
	_tmp50_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp49_);
	_tmp51_ = _tmp50_;
	maya_view_event_button_reload_css (self, _tmp51_);
	_g_free0 (_tmp51_);
	_tmp52_ = _data26_->cal;
	g_signal_connect_data ((GObject*) _tmp52_, "notify::color", (GCallback) __maya_view_event_button___lambda123__g_object_notify, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_g_object_unref0 (source);
	_g_object_unref0 (event_box);
	_g_object_unref0 (internal_grid);
	block26_data_unref (_data26_);
	_data26_ = NULL;
	return obj;
}

static void
maya_view_event_button_class_init (MayaViewEventButtonClass * klass,
                                   gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	maya_view_event_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewEventButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_event_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_event_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_event_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_event_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_EVENT_BUTTON_COMP_PROPERTY, maya_view_event_button_properties[MAYA_VIEW_EVENT_BUTTON_COMP_PROPERTY] = g_param_spec_object ("comp", "comp", "comp", e_cal_component_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (maya_view_event_button_css_provider);
	maya_view_event_button_css_provider = _tmp0_;
	_tmp1_ = maya_view_event_button_css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/AgendaEventRow.css");
}

static void
maya_view_event_button_instance_init (MayaViewEventButton * self,
                                      gpointer klass)
{
	self->priv = maya_view_event_button_get_instance_private (self);
}

static void
maya_view_event_button_finalize (GObject * obj)
{
	MayaViewEventButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton);
	_g_object_unref0 (self->priv->_comp);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->grid_style_context);
	G_OBJECT_CLASS (maya_view_event_button_parent_class)->finalize (obj);
}

static GType
maya_view_event_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewEventButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_event_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewEventButton), 0, (GInstanceInitFunc) maya_view_event_button_instance_init, NULL };
	GType maya_view_event_button_type_id;
	maya_view_event_button_type_id = g_type_register_static (gtk_revealer_get_type (), "MayaViewEventButton", &g_define_type_info, 0);
	MayaViewEventButton_private_offset = g_type_add_instance_private (maya_view_event_button_type_id, sizeof (MayaViewEventButtonPrivate));
	return maya_view_event_button_type_id;
}

GType
maya_view_event_button_get_type (void)
{
	static volatile gsize maya_view_event_button_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_button_type_id__once)) {
		GType maya_view_event_button_type_id;
		maya_view_event_button_type_id = maya_view_event_button_get_type_once ();
		g_once_init_leave (&maya_view_event_button_type_id__once, maya_view_event_button_type_id);
	}
	return maya_view_event_button_type_id__once;
}

static void
_vala_maya_view_event_button_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MayaViewEventButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton);
	switch (property_id) {
		case MAYA_VIEW_EVENT_BUTTON_COMP_PROPERTY:
		g_value_set_object (value, maya_view_event_button_get_comp (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_event_button_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MayaViewEventButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton);
	switch (property_id) {
		case MAYA_VIEW_EVENT_BUTTON_COMP_PROPERTY:
		maya_view_event_button_set_comp (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

