/* ICalTime.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ICalTime.vala, do not modify */

/*
 * Copyright 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "elementary-calendar.h"
#include <libical-glib/libical-glib.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

/**
     * Gets the timezone of the given TimeType as a GLib.TimeZone.
     *
     * For floating times, returns the local timezone.
     * Dates (with no time component) are considered floating.
     */
static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

GTimeZone*
calendar_util_icaltime_get_timezone (ICalTime* date)
{
	const gchar* tzid = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	static const char LIBICAL_TZ_PREFIX[] = "/freeassociation.sourceforge.net/";
	const gchar* _tmp5_;
	GTimeZone* result;
	g_return_val_if_fail (date != NULL, NULL);
	if (i_cal_time_is_date (date)) {
		GTimeZone* _tmp0_;
		_tmp0_ = g_time_zone_new_local ();
		result = _tmp0_;
		return result;
	}
	_tmp1_ = i_cal_time_get_tzid (date);
	tzid = _tmp1_;
	_tmp2_ = tzid;
	if (_tmp2_ == NULL) {
		ICalTimezone* _tmp3_;
		GTimeZone* _tmp4_;
		_tmp3_ = i_cal_time_get_timezone (date);
		_vala_assert (_tmp3_ == NULL, "date.get_timezone () == null");
		_tmp4_ = g_time_zone_new_local ();
		result = _tmp4_;
		return result;
	}
	_tmp5_ = tzid;
	if (g_str_has_prefix (_tmp5_, LIBICAL_TZ_PREFIX)) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		GTimeZone* _tmp10_;
		_tmp6_ = tzid;
		_tmp7_ = strlen (LIBICAL_TZ_PREFIX);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_offset (_tmp6_, (glong) _tmp8_);
		_tmp10_ = g_time_zone_new (_tmp9_);
		result = _tmp10_;
		return result;
	} else {
		const gchar* _tmp11_;
		GTimeZone* _tmp12_;
		_tmp11_ = tzid;
		_tmp12_ = g_time_zone_new (_tmp11_);
		result = _tmp12_;
		return result;
	}
}

/**
     * Converts the given ICal.Time to a GLib.DateTime.
     *
     * XXX : Track next versions of evolution in order to convert ICal.Timezone
     * to GLib.TimeZone with a dedicated function…
     *
     * **Note:** All timezone information in the original @date is lost.
     * While this function attempts to convert the timezone data contained in
     * @date to GLib, this process does not always work. You should never
     * assume that the {@link GLib.TimeZone} contained in the resulting
     * DateTime is correct. The wall-clock date and time are correct for the
     * original timezone, however.
     *
     * For example, a timezone like `Western European Standard Time` is not
     * easily representable in GLib. The resulting {@link GLib.TimeZone} is
     * likely to be the system's local timezone, which is (probably) incorrect.
     * However, if the event occurs at 8:15 AM on January 1, 2020, the time
     * contained in the returned DateTime will be 8:15 AM on January 1, 2020
     * in the local timezone. The wall clock time is correct, but the time
     * zone is not.
     */
GDateTime*
calendar_util_icaltime_to_datetime (ICalTime* date)
{
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gint second = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	i_cal_time_get_date (date, &_tmp0_, &_tmp1_, &_tmp2_);
	year = _tmp0_;
	month = _tmp1_;
	day = _tmp2_;
	i_cal_time_get_time (date, &_tmp3_, &_tmp4_, &_tmp5_);
	hour = _tmp3_;
	minute = _tmp4_;
	second = _tmp5_;
	_tmp6_ = calendar_util_icaltime_get_timezone (date);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_new (_tmp7_, year, month, day, hour, minute, (gdouble) second);
	_tmp9_ = _tmp8_;
	_g_time_zone_unref0 (_tmp7_);
	result = _tmp9_;
	return result;
}

/**
     * Converts the given ICal.Time to a GLib.DateTime, represented in the
     * system timezone.
     *
     * All timezone information in the original @date is lost. However, the
     * {@link GLib.TimeZone} contained in the resulting DateTime is correct,
     * since there is a well-defined local timezone between both libical and
     * GLib.
     */
GDateTime*
calendar_util_icaltime_to_local_datetime (ICalTime* date)
{
	ICalTime* converted = NULL;
	ICalTime* _tmp0_;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gint second = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GDateTime* _tmp7_;
	GDateTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	_vala_assert (!i_cal_time_is_null_time (date), "!date.is_null_time ()");
	_tmp0_ = calendar_util_icaltime_convert_to_local (date);
	converted = _tmp0_;
	i_cal_time_get_date (converted, &_tmp1_, &_tmp2_, &_tmp3_);
	year = _tmp1_;
	month = _tmp2_;
	day = _tmp3_;
	i_cal_time_get_time (converted, &_tmp4_, &_tmp5_, &_tmp6_);
	hour = _tmp4_;
	minute = _tmp5_;
	second = _tmp6_;
	_tmp7_ = g_date_time_new_local (year, month, day, hour, minute, (gdouble) second);
	result = _tmp7_;
	_g_object_unref0 (converted);
	return result;
}

/** Converts the given ICal.Time to the local (or system) timezone
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ICalTime*
calendar_util_icaltime_convert_to_local (ICalTime* time)
{
	ICalTimezone* system_tz = NULL;
	CalendarTimeManager* _tmp0_;
	ICalTimezone* _tmp1_;
	ICalTimezone* _tmp2_;
	ICalTimezone* _tmp3_;
	ICalTime* _tmp4_;
	ICalTime* result;
	g_return_val_if_fail (time != NULL, NULL);
	_tmp0_ = calendar_time_manager_get_default ();
	_tmp1_ = calendar_time_manager_get_system_timezone (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	system_tz = _tmp3_;
	_tmp4_ = i_cal_time_convert_to_zone (time, system_tz);
	result = _tmp4_;
	_g_object_unref0 (system_tz);
	return result;
}

