/* DateTime.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DateTime.vala, do not modify */

/*
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "elementary-calendar.h"
#include <glib.h>
#include <libical-glib/libical-glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

gboolean
calendar_util_datetime_equal_func (GDateTime* a,
                                   GDateTime* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = g_date_time_equal (a, b);
	return result;
}

/**
     * Say if an event lasts all day.
     *
     * An all-day event is represented as both starting and ending at midnight
     * local time, so its duration is exactly a multiple of 24 hours.
     */
gboolean
calendar_util_datetime_is_all_day (GDateTime* dtstart,
                                   GDateTime* dtend)
{
	GTimeSpan timespan = 0LL;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (dtstart != NULL, FALSE);
	g_return_val_if_fail (dtend != NULL, FALSE);
	timespan = g_date_time_difference (dtend, dtstart);
	if ((timespan % G_TIME_SPAN_DAY) == ((GTimeSpan) 0)) {
		_tmp0_ = g_date_time_get_hour (dtstart) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

/**
     * Converts two DateTimes representing a date and a time to one TimeType.
     *
     * The first contains the date; its time settings are ignored. The second
     * one contains the time itself; its date settings are ignored. If the time
     * is `null`, the resulting TimeType is of `DATE` type; if it is given, the
     * TimeType is of `DATE-TIME` type.
     *
     * This also accepts an optional `timezone` argument. If it is given a
     * timezone, the resulting TimeType will be relative to the given timezone.
     * If it is `null`, the resulting TimeType will be "floating" with no
     * timezone. If the argument is not given, it will default to the system
     * timezone.
     */
ICalTime*
calendar_util_datetimes_to_icaltime (GDateTime* date,
                                     GDateTime* time_local,
                                     ICalTimezone* timezone)
{
	ICalTime* _result_ = NULL;
	ICalTime* _tmp0_;
	ICalTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = i_cal_time_new_from_day_of_year (g_date_time_get_day_of_year (date), g_date_time_get_year (date));
	_result_ = _tmp0_;
	if (time_local == NULL) {
		ICalTime* _tmp1_;
		ICalTime* _tmp2_;
		_tmp1_ = _result_;
		i_cal_time_set_is_date (_tmp1_, TRUE);
		_tmp2_ = _result_;
		i_cal_time_set_time (_tmp2_, 0, 0, 0);
	} else {
		ICalTime* _tmp3_;
		ICalTime* _tmp4_;
		ICalTime* _tmp5_;
		_tmp3_ = _result_;
		i_cal_time_set_is_date (_tmp3_, FALSE);
		_tmp4_ = _result_;
		i_cal_time_set_timezone (_tmp4_, timezone);
		_tmp5_ = _result_;
		i_cal_time_set_time (_tmp5_, g_date_time_get_hour (time_local), g_date_time_get_minute (time_local), g_date_time_get_second (time_local));
	}
	result = _result_;
	return result;
}

/** Gets the start of the month that contains the given date
     *
     * Returns midnight (00:00) on that date.
     */
GDateTime*
calendar_util_datetime_get_start_of_month (GDateTime* date)
{
	GDateTime* _tmp1_;
	GDateTime* result;
	if (date == NULL) {
		GDateTime* _tmp0_;
		_tmp0_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (date);
		date = _tmp0_;
	}
	_tmp1_ = g_date_time_new_local (g_date_time_get_year (date), g_date_time_get_month (date), 1, 0, 0, (gdouble) 0);
	result = _tmp1_;
	_g_date_time_unref0 (date);
	return result;
}

GDateTime*
calendar_util_datetime_strip_time (GDateTime* datetime)
{
	GDateTime* _tmp0_;
	GDateTime* result;
	g_return_val_if_fail (datetime != NULL, NULL);
	_tmp0_ = g_date_time_add_full (datetime, 0, 0, 0, -g_date_time_get_hour (datetime), -g_date_time_get_minute (datetime), (gdouble) (-g_date_time_get_second (datetime)));
	result = _tmp0_;
	return result;
}

