/* CategoryView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CategoryView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2019-2025 elementary, Inc. (https://elementary.io)
 *                         2011-2012 Giulio Collura
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_WIDGETS_CATEGORY_VIEW_0_PROPERTY,
	SLINGSHOT_WIDGETS_CATEGORY_VIEW_VIEW_PROPERTY,
	SLINGSHOT_WIDGETS_CATEGORY_VIEW_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_category_view_properties[SLINGSHOT_WIDGETS_CATEGORY_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW (slingshot_widgets_category_view_category_row_get_type ())
#define SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow))
#define SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRowClass))
#define SLINGSHOT_WIDGETS_CATEGORY_VIEW_IS_CATEGORY_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW))
#define SLINGSHOT_WIDGETS_CATEGORY_VIEW_IS_CATEGORY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW))
#define SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRowClass))

typedef struct _SlingshotWidgetsCategoryViewCategoryRow SlingshotWidgetsCategoryViewCategoryRow;
typedef struct _SlingshotWidgetsCategoryViewCategoryRowClass SlingshotWidgetsCategoryViewCategoryRowClass;
typedef struct _SlingshotWidgetsCategoryViewCategoryRowPrivate SlingshotWidgetsCategoryViewCategoryRowPrivate;
enum  {
	SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_0_PROPERTY,
	SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CAT_NAME_PROPERTY,
	SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_category_view_category_row_properties[SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_NUM_PROPERTIES];
typedef struct _Block13Data Block13Data;
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))

struct _SlingshotWidgetsCategoryViewPrivate {
	SlingshotSlingshotView* _view;
	gchar* drag_uri;
	GtkListBox* category_switcher;
	GtkListBox* listbox;
	GtkGestureMultiPress* click_controller;
	GtkEventControllerKey* listbox_key_controller;
	GtkEventControllerKey* category_switcher_key_controller;
};

struct _SlingshotWidgetsCategoryViewCategoryRow {
	GtkListBoxRow parent_instance;
	SlingshotWidgetsCategoryViewCategoryRowPrivate * priv;
};

struct _SlingshotWidgetsCategoryViewCategoryRowClass {
	GtkListBoxRowClass parent_class;
};

struct _SlingshotWidgetsCategoryViewCategoryRowPrivate {
	gchar* _cat_name;
};

struct _Block13Data {
	int _ref_count_;
	SlingshotWidgetsCategoryView* self;
	GtkListBoxRow* row;
};

static gint SlingshotWidgetsCategoryView_private_offset;
static gpointer slingshot_widgets_category_view_parent_class = NULL;
static gint SlingshotWidgetsCategoryViewCategoryRow_private_offset;
static gpointer slingshot_widgets_category_view_category_row_parent_class = NULL;

static GType slingshot_widgets_category_view_category_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint slingshot_widgets_category_view_category_sort_func (SlingshotWidgetsCategoryViewCategoryRow* row1,
                                                         SlingshotWidgetsCategoryViewCategoryRow* row2);
static const gchar* slingshot_widgets_category_view_category_row_get_cat_name (SlingshotWidgetsCategoryViewCategoryRow* self);
static GtkMenu* slingshot_widgets_category_view_create_context_menu (SlingshotWidgetsCategoryView* self);
static void slingshot_widgets_category_view_focus_select_first_row (SlingshotWidgetsCategoryView* self);
static void __lambda60_ (SlingshotWidgetsCategoryView* self,
                  GtkWidget* app_list_row);
static void ___lambda60__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static SlingshotWidgetsCategoryViewCategoryRow* slingshot_widgets_category_view_category_row_new (const gchar* cat_name);
static SlingshotWidgetsCategoryViewCategoryRow* slingshot_widgets_category_view_category_row_construct (GType object_type,
                                                                                                 const gchar* cat_name);
static gboolean slingshot_widgets_category_view_filter_function (SlingshotAppListRow* row,
                                                          SlingshotWidgetsCategoryView* self);
static gboolean slingshot_widgets_category_view_on_key_press (SlingshotWidgetsCategoryView* self,
                                                       guint keyval,
                                                       guint keycode,
                                                       GdkModifierType state);
static void slingshot_widgets_category_view_move_cursor (SlingshotWidgetsCategoryView* self,
                                                  GtkListBox* list_box,
                                                  GtkMovementStep step,
                                                  gint count);
static void slingshot_widgets_category_view_category_row_set_cat_name (SlingshotWidgetsCategoryViewCategoryRow* self,
                                                                const gchar* value);
static GObject * slingshot_widgets_category_view_category_row_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void slingshot_widgets_category_view_category_row_finalize (GObject * obj);
static GType slingshot_widgets_category_view_category_row_get_type_once (void);
static void _vala_slingshot_widgets_category_view_category_row_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_slingshot_widgets_category_view_category_row_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GObject * slingshot_widgets_category_view_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _slingshot_widgets_category_view_move_cursor_gtk_list_box_move_cursor (GtkListBox* _sender,
                                                                            GtkMovementStep step,
                                                                            gint count,
                                                                            gpointer self);
static void _slingshot_widgets_category_view___lambda61_ (SlingshotWidgetsCategoryView* self);
static void __slingshot_widgets_category_view___lambda61__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                              GtkListBoxRow* row,
                                                                              gpointer self);
static void _slingshot_widgets_category_view___lambda62_ (SlingshotWidgetsCategoryView* self,
                                                   GtkListBoxRow* row);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean __lambda63_ (Block13Data* _data13_);
static gboolean ___lambda63__gsource_func (gpointer self);
static void __slingshot_widgets_category_view___lambda62__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                               GtkListBoxRow* row,
                                                                               gpointer self);
static void _slingshot_widgets_category_view___lambda64_ (SlingshotWidgetsCategoryView* self,
                                                   gint n_press,
                                                   gdouble x,
                                                   gdouble y);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
static void __slingshot_widgets_category_view___lambda64__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                    gint n_press,
                                                                                    gdouble x,
                                                                                    gdouble y,
                                                                                    gpointer self);
static gboolean _slingshot_widgets_category_view_on_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                             guint keyval,
                                                                                             guint keycode,
                                                                                             GdkModifierType state,
                                                                                             gpointer self);
static void _slingshot_widgets_category_view___lambda65_ (SlingshotWidgetsCategoryView* self,
                                                   guint keyval,
                                                   guint keycode,
                                                   GdkModifierType state);
static void __slingshot_widgets_category_view___lambda65__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                          guint keyval,
                                                                                          guint keycode,
                                                                                          GdkModifierType state,
                                                                                          gpointer self);
static void _slingshot_widgets_category_view___lambda66_ (SlingshotWidgetsCategoryView* self,
                                                   GdkDragContext* ctx);
static void __slingshot_widgets_category_view___lambda66__gtk_widget_drag_begin (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          gpointer self);
static void _slingshot_widgets_category_view___lambda67_ (SlingshotWidgetsCategoryView* self);
static void __slingshot_widgets_category_view___lambda67__gtk_widget_drag_end (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        gpointer self);
static void _slingshot_widgets_category_view___lambda68_ (SlingshotWidgetsCategoryView* self,
                                                   GdkDragContext* ctx,
                                                   GtkSelectionData* sel,
                                                   guint info,
                                                   guint time);
static void __slingshot_widgets_category_view___lambda68__gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                             GdkDragContext* context,
                                                                             GtkSelectionData* selection_data,
                                                                             guint info,
                                                                             guint time_,
                                                                             gpointer self);
static void slingshot_widgets_category_view_finalize (GObject * obj);
static GType slingshot_widgets_category_view_get_type_once (void);
static void _vala_slingshot_widgets_category_view_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_slingshot_widgets_category_view_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GtkTargetEntry SLINGSHOT_WIDGETS_CATEGORY_VIEW_DND = {"text/uri-list", (guint) 0, (guint) 0};

static inline gpointer
slingshot_widgets_category_view_get_instance_private (SlingshotWidgetsCategoryView* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsCategoryView_private_offset);
}

SlingshotWidgetsCategoryView*
slingshot_widgets_category_view_construct (GType object_type,
                                           SlingshotSlingshotView* view)
{
	SlingshotWidgetsCategoryView * self = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (SlingshotWidgetsCategoryView*) g_object_new (object_type, "view", view, NULL);
	return self;
}

SlingshotWidgetsCategoryView*
slingshot_widgets_category_view_new (SlingshotSlingshotView* view)
{
	return slingshot_widgets_category_view_construct (SLINGSHOT_WIDGETS_TYPE_CATEGORY_VIEW, view);
}

static gint
slingshot_widgets_category_view_category_sort_func (SlingshotWidgetsCategoryViewCategoryRow* row1,
                                                    SlingshotWidgetsCategoryViewCategoryRow* row2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = slingshot_widgets_category_view_category_row_get_cat_name (row1);
	_tmp1_ = _tmp0_;
	_tmp2_ = slingshot_widgets_category_view_category_row_get_cat_name (row2);
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkMenu*
slingshot_widgets_category_view_create_context_menu (SlingshotWidgetsCategoryView* self)
{
	SlingshotAppListRow* selected_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	SlingshotAppListRow* _tmp2_;
	GtkMenu* context_menu = NULL;
	SlingshotBackendApp* _tmp3_;
	SlingshotBackendApp* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	GtkMenu* _tmp7_;
	GtkMenu* _tmp8_;
	SlingshotBackendApp* _tmp9_;
	SlingshotBackendApp* _tmp10_;
	GSimpleActionGroup* _tmp11_;
	GSimpleActionGroup* _tmp12_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow));
	selected_row = _tmp2_;
	_tmp3_ = slingshot_app_list_row_get_app (selected_row);
	_tmp4_ = _tmp3_;
	_tmp5_ = slingshot_backend_app_get_menu_model (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp6_);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	context_menu = _tmp8_;
	_tmp9_ = slingshot_app_list_row_get_app (selected_row);
	_tmp10_ = _tmp9_;
	_tmp11_ = slingshot_backend_app_get_action_group (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_widget_insert_action_group ((GtkWidget*) context_menu, SLINGSHOT_BACKEND_APP_ACTION_GROUP_PREFIX, (GActionGroup*) _tmp12_);
	result = context_menu;
	_g_object_unref0 (selected_row);
	return result;
}

void
slingshot_widgets_category_view_page_down (SlingshotWidgetsCategoryView* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_switcher;
	g_signal_emit_by_name (_tmp0_, "move-cursor", GTK_MOVEMENT_DISPLAY_LINES, 1);
	slingshot_widgets_category_view_focus_select_first_row (self);
}

void
slingshot_widgets_category_view_page_up (SlingshotWidgetsCategoryView* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_switcher;
	g_signal_emit_by_name (_tmp0_, "move-cursor", GTK_MOVEMENT_DISPLAY_LINES, -1);
	slingshot_widgets_category_view_focus_select_first_row (self);
}

static void
slingshot_widgets_category_view_focus_select_first_row (SlingshotWidgetsCategoryView* self)
{
	GtkListBoxRow* first_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
	first_row = _tmp1_;
	_tmp2_ = first_row;
	if (_tmp2_ != NULL) {
		GtkListBoxRow* _tmp3_;
		GtkListBox* _tmp4_;
		GtkListBoxRow* _tmp5_;
		_tmp3_ = first_row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->listbox;
		_tmp5_ = first_row;
		gtk_list_box_select_row (_tmp4_, _tmp5_);
	}
}

static void
__lambda60_ (SlingshotWidgetsCategoryView* self,
             GtkWidget* app_list_row)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (app_list_row != NULL);
	_tmp0_ = self->priv->listbox;
	gtk_container_remove ((GtkContainer*) _tmp0_, app_list_row);
}

static void
___lambda60__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda60_ ((SlingshotWidgetsCategoryView*) self, widget);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
slingshot_widgets_category_view_setup_sidebar (SlingshotWidgetsCategoryView* self)
{
	SlingshotWidgetsCategoryViewCategoryRow* old_selected = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	SlingshotWidgetsCategoryViewCategoryRow* _tmp2_;
	GtkListBox* _tmp3_;
	GList* _tmp4_;
	GtkListBox* _tmp6_;
	SlingshotSlingshotView* _tmp7_;
	SlingshotBackendAppSystem* _tmp8_;
	GSList* _tmp9_;
	GtkListBox* _tmp14_;
	GtkListBoxRow* new_selected = NULL;
	GtkListBox* _tmp39_;
	GtkListBoxRow* _tmp40_ = NULL;
	GtkListBoxRow* _tmp41_;
	GtkListBox* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_switcher;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow));
	old_selected = _tmp2_;
	_tmp3_ = self->priv->category_switcher;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp4_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp5_;
				_tmp5_ = child;
				gtk_widget_destroy (_tmp5_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp6_ = self->priv->listbox;
	gtk_container_foreach ((GtkContainer*) _tmp6_, ___lambda60__gtk_callback, self);
	_tmp7_ = self->priv->_view;
	_tmp8_ = _tmp7_->app_system;
	_tmp9_ = slingshot_backend_app_system_get_apps_by_name (_tmp8_);
	{
		GSList* app_collection = NULL;
		GSList* app_it = NULL;
		app_collection = _tmp9_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			SlingshotBackendApp* app = NULL;
			app = (SlingshotBackendApp*) app_it->data;
			{
				GtkListBox* _tmp10_;
				SlingshotBackendApp* _tmp11_;
				SlingshotAppListRow* _tmp12_;
				SlingshotAppListRow* _tmp13_;
				_tmp10_ = self->priv->listbox;
				_tmp11_ = app;
				_tmp12_ = slingshot_app_list_row_new (_tmp11_);
				g_object_ref_sink (_tmp12_);
				_tmp13_ = _tmp12_;
				gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp13_);
				_g_object_unref0 (_tmp13_);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_slist_free__g_object_unref0_ (app_collection), NULL));
	}
	_tmp14_ = self->priv->listbox;
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
	new_selected = NULL;
	{
		GeeIterator* _cat_name_it = NULL;
		SlingshotSlingshotView* _tmp15_;
		SlingshotBackendAppSystem* _tmp16_;
		GeeHashMap* _tmp17_;
		GeeHashMap* _tmp18_;
		GeeSet* _tmp19_;
		GeeSet* _tmp20_;
		GeeSet* _tmp21_;
		GeeIterator* _tmp22_;
		GeeIterator* _tmp23_;
		_tmp15_ = self->priv->_view;
		_tmp16_ = _tmp15_->app_system;
		_tmp17_ = slingshot_backend_app_system_get_apps (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_cat_name_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			gchar* cat_name = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			const gchar* _tmp27_;
			SlingshotWidgetsCategoryViewCategoryRow* row = NULL;
			const gchar* _tmp28_;
			SlingshotWidgetsCategoryViewCategoryRow* _tmp29_;
			GtkListBox* _tmp30_;
			SlingshotWidgetsCategoryViewCategoryRow* _tmp31_;
			gboolean _tmp32_ = FALSE;
			SlingshotWidgetsCategoryViewCategoryRow* _tmp33_;
			_tmp24_ = _cat_name_it;
			if (!gee_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _cat_name_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			cat_name = (gchar*) _tmp26_;
			_tmp27_ = cat_name;
			if (g_strcmp0 (_tmp27_, "switchboard") == 0) {
				_g_free0 (cat_name);
				continue;
			}
			_tmp28_ = cat_name;
			_tmp29_ = slingshot_widgets_category_view_category_row_new (_tmp28_);
			g_object_ref_sink (_tmp29_);
			row = _tmp29_;
			_tmp30_ = self->priv->category_switcher;
			_tmp31_ = row;
			gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
			_tmp33_ = old_selected;
			if (_tmp33_ != NULL) {
				SlingshotWidgetsCategoryViewCategoryRow* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_tmp34_ = old_selected;
				_tmp35_ = slingshot_widgets_category_view_category_row_get_cat_name (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = cat_name;
				_tmp32_ = g_strcmp0 (_tmp36_, _tmp37_) == 0;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				SlingshotWidgetsCategoryViewCategoryRow* _tmp38_;
				_tmp38_ = row;
				new_selected = (GtkListBoxRow*) _tmp38_;
			}
			_g_object_unref0 (row);
			_g_free0 (cat_name);
		}
		_g_object_unref0 (_cat_name_it);
	}
	_tmp39_ = self->priv->category_switcher;
	gtk_widget_show_all ((GtkWidget*) _tmp39_);
	_tmp41_ = new_selected;
	_tmp40_ = _tmp41_;
	if (_tmp40_ == NULL) {
		GtkListBox* _tmp42_;
		GtkListBoxRow* _tmp43_;
		_tmp42_ = self->priv->category_switcher;
		_tmp43_ = gtk_list_box_get_row_at_index (_tmp42_, 0);
		_tmp40_ = _tmp43_;
	}
	_tmp44_ = self->priv->category_switcher;
	gtk_list_box_select_row (_tmp44_, _tmp40_);
	_g_object_unref0 (old_selected);
}

static gboolean
slingshot_widgets_category_view_filter_function (SlingshotAppListRow* row,
                                                 SlingshotWidgetsCategoryView* self)
{
	SlingshotWidgetsCategoryViewCategoryRow* category_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	SlingshotWidgetsCategoryViewCategoryRow* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = self->priv->category_switcher;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	category_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow);
	_tmp2_ = category_row;
	if (_tmp2_ != NULL) {
		{
			GeeArrayList* _app_list = NULL;
			SlingshotSlingshotView* _tmp3_;
			SlingshotBackendAppSystem* _tmp4_;
			GeeHashMap* _tmp5_;
			GeeHashMap* _tmp6_;
			SlingshotWidgetsCategoryViewCategoryRow* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gpointer _tmp10_;
			gint _app_size = 0;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _app_index = 0;
			_tmp3_ = self->priv->_view;
			_tmp4_ = _tmp3_->app_system;
			_tmp5_ = slingshot_backend_app_system_get_apps (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = category_row;
			_tmp8_ = slingshot_widgets_category_view_category_row_get_cat_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp9_);
			_app_list = (GeeArrayList*) _tmp10_;
			_tmp11_ = _app_list;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_app_size = _tmp13_;
			_app_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				SlingshotBackendApp* app = NULL;
				GeeArrayList* _tmp16_;
				gpointer _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				SlingshotBackendApp* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_app_index = _app_index + 1;
				_tmp14_ = _app_index;
				_tmp15_ = _app_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _app_list;
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _app_index);
				app = (SlingshotBackendApp*) _tmp17_;
				_tmp18_ = slingshot_app_list_row_get_app_id (row);
				_tmp19_ = _tmp18_;
				_tmp20_ = app;
				_tmp21_ = slingshot_backend_app_get_desktop_id (_tmp20_);
				_tmp22_ = _tmp21_;
				if (g_strcmp0 (_tmp19_, _tmp22_) == 0) {
					result = TRUE;
					_g_object_unref0 (app);
					_g_object_unref0 (_app_list);
					return result;
				}
				_g_object_unref0 (app);
			}
			_g_object_unref0 (_app_list);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
slingshot_widgets_category_view_on_key_press (SlingshotWidgetsCategoryView* self,
                                              guint keyval,
                                              guint keycode,
                                              GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (keyval) {
		case GDK_KEY_Page_Up:
		case GDK_KEY_KP_Page_Up:
		{
			slingshot_widgets_category_view_page_up (self);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Page_Down:
		case GDK_KEY_KP_Page_Down:
		{
			slingshot_widgets_category_view_page_down (self);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Home:
		{
			GtkListBox* _tmp0_;
			_tmp0_ = self->priv->category_switcher;
			g_signal_emit_by_name (_tmp0_, "move-cursor", GTK_MOVEMENT_PAGES, -1);
			slingshot_widgets_category_view_focus_select_first_row (self);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_End:
		{
			GtkListBox* _tmp1_;
			_tmp1_ = self->priv->category_switcher;
			g_signal_emit_by_name (_tmp1_, "move-cursor", GTK_MOVEMENT_PAGES, 1);
			slingshot_widgets_category_view_focus_select_first_row (self);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_KP_Up:
		case GDK_KEY_Up:
		{
			if (state == GDK_SHIFT_MASK) {
				slingshot_widgets_category_view_page_up (self);
				result = GDK_EVENT_STOP;
				return result;
			}
			break;
		}
		case GDK_KEY_KP_Down:
		case GDK_KEY_Down:
		{
			if (state == GDK_SHIFT_MASK) {
				slingshot_widgets_category_view_page_down (self);
				result = GDK_EVENT_STOP;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
slingshot_widgets_category_view_move_cursor (SlingshotWidgetsCategoryView* self,
                                             GtkListBox* list_box,
                                             GtkMovementStep step,
                                             gint count)
{
	GtkListBoxRow* selected = NULL;
	GtkListBoxRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list_box != NULL);
	_tmp0_ = gtk_list_box_get_selected_row (list_box);
	selected = _tmp0_;
	if (step != GTK_MOVEMENT_DISPLAY_LINES) {
		_tmp1_ = TRUE;
	} else {
		GtkListBoxRow* _tmp2_;
		_tmp2_ = selected;
		_tmp1_ = _tmp2_ == NULL;
	}
	if (_tmp1_) {
		return;
	}
	_tmp4_ = selected;
	_tmp5_ = gtk_list_box_get_row_at_index (list_box, 0);
	if (_tmp4_ == _tmp5_) {
		_tmp3_ = count == -1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		g_signal_emit_by_name ((GtkWidget*) self, "move-focus", GTK_DIR_TAB_BACKWARD);
		return;
	}
}

SlingshotSlingshotView*
slingshot_widgets_category_view_get_view (SlingshotWidgetsCategoryView* self)
{
	SlingshotSlingshotView* result;
	SlingshotSlingshotView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_category_view_set_view (SlingshotWidgetsCategoryView* self,
                                          SlingshotSlingshotView* value)
{
	SlingshotSlingshotView* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_category_view_get_view (self);
	if (old_value != value) {
		SlingshotSlingshotView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_category_view_properties[SLINGSHOT_WIDGETS_CATEGORY_VIEW_VIEW_PROPERTY]);
	}
}

static inline gpointer
slingshot_widgets_category_view_category_row_get_instance_private (SlingshotWidgetsCategoryViewCategoryRow* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsCategoryViewCategoryRow_private_offset);
}

static SlingshotWidgetsCategoryViewCategoryRow*
slingshot_widgets_category_view_category_row_construct (GType object_type,
                                                        const gchar* cat_name)
{
	SlingshotWidgetsCategoryViewCategoryRow * self = NULL;
	g_return_val_if_fail (cat_name != NULL, NULL);
	self = (SlingshotWidgetsCategoryViewCategoryRow*) g_object_new (object_type, "cat-name", cat_name, NULL);
	return self;
}

static SlingshotWidgetsCategoryViewCategoryRow*
slingshot_widgets_category_view_category_row_new (const gchar* cat_name)
{
	return slingshot_widgets_category_view_category_row_construct (SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, cat_name);
}

static const gchar*
slingshot_widgets_category_view_category_row_get_cat_name (SlingshotWidgetsCategoryViewCategoryRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cat_name;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_category_view_category_row_set_cat_name (SlingshotWidgetsCategoryViewCategoryRow* self,
                                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_category_view_category_row_get_cat_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_cat_name);
		self->priv->_cat_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_category_view_category_row_properties[SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CAT_NAME_PROPERTY]);
	}
}

static GObject *
slingshot_widgets_category_view_category_row_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsCategoryViewCategoryRow * self;
	GtkLabel* label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_category_view_category_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow);
	_tmp0_ = self->priv->_cat_name;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 3);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp2_, NULL);
	_g_object_unref0 (label);
	return obj;
}

static void
slingshot_widgets_category_view_category_row_class_init (SlingshotWidgetsCategoryViewCategoryRowClass * klass,
                                                         gpointer klass_data)
{
	slingshot_widgets_category_view_category_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsCategoryViewCategoryRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_category_view_category_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_category_view_category_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_category_view_category_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_category_view_category_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CAT_NAME_PROPERTY, slingshot_widgets_category_view_category_row_properties[SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CAT_NAME_PROPERTY] = g_param_spec_string ("cat-name", "cat-name", "cat-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
slingshot_widgets_category_view_category_row_instance_init (SlingshotWidgetsCategoryViewCategoryRow * self,
                                                            gpointer klass)
{
	self->priv = slingshot_widgets_category_view_category_row_get_instance_private (self);
}

static void
slingshot_widgets_category_view_category_row_finalize (GObject * obj)
{
	SlingshotWidgetsCategoryViewCategoryRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow);
	_g_free0 (self->priv->_cat_name);
	G_OBJECT_CLASS (slingshot_widgets_category_view_category_row_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_category_view_category_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsCategoryViewCategoryRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_category_view_category_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsCategoryViewCategoryRow), 0, (GInstanceInitFunc) slingshot_widgets_category_view_category_row_instance_init, NULL };
	GType slingshot_widgets_category_view_category_row_type_id;
	slingshot_widgets_category_view_category_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SlingshotWidgetsCategoryViewCategoryRow", &g_define_type_info, 0);
	SlingshotWidgetsCategoryViewCategoryRow_private_offset = g_type_add_instance_private (slingshot_widgets_category_view_category_row_type_id, sizeof (SlingshotWidgetsCategoryViewCategoryRowPrivate));
	return slingshot_widgets_category_view_category_row_type_id;
}

static GType
slingshot_widgets_category_view_category_row_get_type (void)
{
	static volatile gsize slingshot_widgets_category_view_category_row_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_category_view_category_row_type_id__once)) {
		GType slingshot_widgets_category_view_category_row_type_id;
		slingshot_widgets_category_view_category_row_type_id = slingshot_widgets_category_view_category_row_get_type_once ();
		g_once_init_leave (&slingshot_widgets_category_view_category_row_type_id__once, slingshot_widgets_category_view_category_row_type_id);
	}
	return slingshot_widgets_category_view_category_row_type_id__once;
}

static void
_vala_slingshot_widgets_category_view_category_row_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SlingshotWidgetsCategoryViewCategoryRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CAT_NAME_PROPERTY:
		g_value_set_string (value, slingshot_widgets_category_view_category_row_get_cat_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_category_view_category_row_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SlingshotWidgetsCategoryViewCategoryRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_CATEGORY_VIEW_TYPE_CATEGORY_ROW, SlingshotWidgetsCategoryViewCategoryRow);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_CATEGORY_VIEW_CATEGORY_ROW_CAT_NAME_PROPERTY:
		slingshot_widgets_category_view_category_row_set_cat_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_slingshot_widgets_category_view_move_cursor_gtk_list_box_move_cursor (GtkListBox* _sender,
                                                                       GtkMovementStep step,
                                                                       gint count,
                                                                       gpointer self)
{
	slingshot_widgets_category_view_move_cursor ((SlingshotWidgetsCategoryView*) self, _sender, step, count);
}

static void
_slingshot_widgets_category_view___lambda61_ (SlingshotWidgetsCategoryView* self)
{
	GtkListBox* _tmp0_;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_filter (_tmp0_);
}

static void
__slingshot_widgets_category_view___lambda61__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self)
{
	_slingshot_widgets_category_view___lambda61_ ((SlingshotWidgetsCategoryView*) self);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		SlingshotWidgetsCategoryView* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->row);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
__lambda63_ (Block13Data* _data13_)
{
	SlingshotWidgetsCategoryView* self;
	SlingshotSlingshotView* _tmp0_;
	gboolean result;
	self = _data13_->self;
	slingshot_app_list_row_launch (G_TYPE_CHECK_INSTANCE_CAST (_data13_->row, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow));
	_tmp0_ = self->priv->_view;
	g_signal_emit_by_name (_tmp0_, "close-indicator");
	result = FALSE;
	return result;
}

static gboolean
___lambda63__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda63_ (self);
	return result;
}

static void
_slingshot_widgets_category_view___lambda62_ (SlingshotWidgetsCategoryView* self,
                                              GtkListBoxRow* row)
{
	Block13Data* _data13_;
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (row != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (_data13_->row);
	_data13_->row = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda63__gsource_func, block13_data_ref (_data13_), block13_data_unref);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
__slingshot_widgets_category_view___lambda62__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self)
{
	_slingshot_widgets_category_view___lambda62_ ((SlingshotWidgetsCategoryView*) self, row);
}

static GdkEvent*
_vala_GdkEvent_copy (GdkEvent* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEvent_copy0 (gpointer self)
{
	return self ? _vala_GdkEvent_copy (self) : NULL;
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static void
_vala_GdkEventSequence_free (GdkEventSequence* self)
{
	g_boxed_free (gdk_event_sequence_get_type (), self);
}

static void
_slingshot_widgets_category_view___lambda64_ (SlingshotWidgetsCategoryView* self,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y)
{
	GdkEventSequence* sequence = NULL;
	GtkGestureMultiPress* _tmp0_;
	GdkEventSequence* _tmp1_;
	GdkEvent* event = NULL;
	GtkGestureMultiPress* _tmp2_;
	GdkEventSequence* _tmp3_;
	GdkEvent* _tmp4_;
	GdkEvent* _tmp5_;
	GdkEvent* _tmp6_;
	_tmp0_ = self->priv->click_controller;
	_tmp1_ = gtk_gesture_single_get_current_sequence ((GtkGestureSingle*) _tmp0_);
	sequence = _tmp1_;
	_tmp2_ = self->priv->click_controller;
	_tmp3_ = sequence;
	_tmp4_ = gtk_gesture_get_last_event ((GtkGesture*) _tmp2_, _tmp3_);
	_tmp5_ = __vala_GdkEvent_copy0 (_tmp4_);
	event = _tmp5_;
	_tmp6_ = event;
	if (gdk_event_triggers_context_menu (_tmp6_)) {
		GtkMenu* _tmp7_;
		GtkMenu* _tmp8_;
		GtkGestureMultiPress* _tmp9_;
		GtkGestureMultiPress* _tmp10_;
		_tmp7_ = slingshot_widgets_category_view_create_context_menu (self);
		_tmp8_ = _tmp7_;
		gtk_menu_popup_at_pointer (_tmp8_, NULL);
		_g_object_unref0 (_tmp8_);
		_tmp9_ = self->priv->click_controller;
		gtk_gesture_set_state ((GtkGesture*) _tmp9_, GTK_EVENT_SEQUENCE_CLAIMED);
		_tmp10_ = self->priv->click_controller;
		gtk_event_controller_reset ((GtkEventController*) _tmp10_);
	}
	__vala_GdkEvent_free0 (event);
	__vala_GdkEventSequence_free0 (sequence);
}

static void
__slingshot_widgets_category_view___lambda64__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                               gint n_press,
                                                                               gdouble x,
                                                                               gdouble y,
                                                                               gpointer self)
{
	_slingshot_widgets_category_view___lambda64_ ((SlingshotWidgetsCategoryView*) self, n_press, x, y);
}

static gboolean
_slingshot_widgets_category_view_on_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                    guint keyval,
                                                                                    guint keycode,
                                                                                    GdkModifierType state,
                                                                                    gpointer self)
{
	gboolean result;
	result = slingshot_widgets_category_view_on_key_press ((SlingshotWidgetsCategoryView*) self, keyval, keycode, state);
	return result;
}

static void
_slingshot_widgets_category_view___lambda65_ (SlingshotWidgetsCategoryView* self,
                                              guint keyval,
                                              guint keycode,
                                              GdkModifierType state)
{
	GdkModifierType mods = 0U;
	mods = state & gtk_accelerator_get_default_mod_mask ();
	switch (keyval) {
		case GDK_KEY_F10:
		{
			if (mods == GDK_SHIFT_MASK) {
				SlingshotAppListRow* selected_row = NULL;
				GtkListBox* _tmp0_;
				GtkListBoxRow* _tmp1_;
				SlingshotAppListRow* _tmp2_;
				GtkMenu* _tmp3_;
				GtkMenu* _tmp4_;
				SlingshotAppListRow* _tmp5_;
				_tmp0_ = self->priv->listbox;
				_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow));
				selected_row = _tmp2_;
				_tmp3_ = slingshot_widgets_category_view_create_context_menu (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = selected_row;
				gtk_menu_popup_at_widget (_tmp4_, (GtkWidget*) _tmp5_, GDK_GRAVITY_EAST, GDK_GRAVITY_CENTER, NULL);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (selected_row);
			}
			break;
		}
		case GDK_KEY_Menu:
		case GDK_KEY_MenuKB:
		{
			SlingshotAppListRow* selected_row = NULL;
			GtkListBox* _tmp6_;
			GtkListBoxRow* _tmp7_;
			SlingshotAppListRow* _tmp8_;
			GtkMenu* _tmp9_;
			GtkMenu* _tmp10_;
			SlingshotAppListRow* _tmp11_;
			_tmp6_ = self->priv->listbox;
			_tmp7_ = gtk_list_box_get_selected_row (_tmp6_);
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow));
			selected_row = _tmp8_;
			_tmp9_ = slingshot_widgets_category_view_create_context_menu (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = selected_row;
			gtk_menu_popup_at_widget (_tmp10_, (GtkWidget*) _tmp11_, GDK_GRAVITY_EAST, GDK_GRAVITY_CENTER, NULL);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (selected_row);
			break;
		}
		default:
		{
			return;
		}
	}
}

static void
__slingshot_widgets_category_view___lambda65__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                     guint keyval,
                                                                                     guint keycode,
                                                                                     GdkModifierType state,
                                                                                     gpointer self)
{
	_slingshot_widgets_category_view___lambda65_ ((SlingshotWidgetsCategoryView*) self, keyval, keycode, state);
}

static void
_slingshot_widgets_category_view___lambda66_ (SlingshotWidgetsCategoryView* self,
                                              GdkDragContext* ctx)
{
	GtkListBoxRow* selected_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ != NULL) {
		SlingshotAppListRow* drag_item = NULL;
		GtkListBoxRow* _tmp3_;
		SlingshotAppListRow* _tmp4_;
		SlingshotAppListRow* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		SlingshotSlingshotView* _tmp14_;
		_tmp3_ = selected_row;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow));
		drag_item = _tmp4_;
		_tmp5_ = drag_item;
		_tmp6_ = slingshot_app_list_row_get_desktop_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("file://", _tmp7_, NULL);
		_g_free0 (self->priv->drag_uri);
		self->priv->drag_uri = _tmp8_;
		_tmp9_ = self->priv->drag_uri;
		if (_tmp9_ != NULL) {
			SlingshotAppListRow* _tmp10_;
			GDesktopAppInfo* _tmp11_;
			GDesktopAppInfo* _tmp12_;
			GIcon* _tmp13_;
			_tmp10_ = drag_item;
			_tmp11_ = slingshot_app_list_row_get_app_info (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_app_info_get_icon ((GAppInfo*) _tmp12_);
			gtk_drag_set_icon_gicon (ctx, _tmp13_, 32, 32);
		}
		_tmp14_ = self->priv->_view;
		g_signal_emit_by_name (_tmp14_, "close-indicator");
		_g_object_unref0 (drag_item);
	}
}

static void
__slingshot_widgets_category_view___lambda66__gtk_widget_drag_begin (GtkWidget* _sender,
                                                                     GdkDragContext* context,
                                                                     gpointer self)
{
	_slingshot_widgets_category_view___lambda66_ ((SlingshotWidgetsCategoryView*) self, context);
}

static void
_slingshot_widgets_category_view___lambda67_ (SlingshotWidgetsCategoryView* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->drag_uri;
	if (_tmp0_ != NULL) {
		SlingshotSlingshotView* _tmp1_;
		_tmp1_ = self->priv->_view;
		g_signal_emit_by_name (_tmp1_, "close-indicator");
	}
	_g_free0 (self->priv->drag_uri);
	self->priv->drag_uri = NULL;
}

static void
__slingshot_widgets_category_view___lambda67__gtk_widget_drag_end (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   gpointer self)
{
	_slingshot_widgets_category_view___lambda67_ ((SlingshotWidgetsCategoryView*) self);
}

static void
_slingshot_widgets_category_view___lambda68_ (SlingshotWidgetsCategoryView* self,
                                              GdkDragContext* ctx,
                                              GtkSelectionData* sel,
                                              guint info,
                                              guint time)
{
	const gchar* _tmp0_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel != NULL);
	_tmp0_ = self->priv->drag_uri;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = self->priv->drag_uri;
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = g_new0 (gchar*, 1 + 1);
		_tmp3_[0] = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 1;
		gtk_selection_data_set_uris (sel, _tmp4_);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
__slingshot_widgets_category_view___lambda68__gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        GtkSelectionData* selection_data,
                                                                        guint info,
                                                                        guint time_,
                                                                        gpointer self)
{
	_slingshot_widgets_category_view___lambda68_ ((SlingshotWidgetsCategoryView*) self, context, selection_data, info, time_);
}

static GObject *
slingshot_widgets_category_view_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsCategoryView * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkScrolledWindow* scrolled_category = NULL;
	GtkListBox* _tmp2_;
	GtkWidget* _tmp3_;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkScrolledWindow* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp7_;
	GtkListBox* _tmp8_ = NULL;
	GtkListBox* _tmp9_;
	GtkScrolledWindow* listbox_scrolled = NULL;
	GtkListBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkScrolledWindow* _tmp12_ = NULL;
	GtkBox* container = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_;
	GtkScrolledWindow* _tmp15_;
	GtkBox* _tmp16_;
	GtkSeparator* _tmp17_;
	GtkBox* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	GtkBox* _tmp20_;
	GtkListBox* _tmp21_;
	GtkListBox* _tmp22_;
	GtkListBox* _tmp23_;
	GtkListBox* _tmp24_;
	GtkListBox* _tmp25_;
	GtkGestureMultiPress* _tmp26_ = NULL;
	GtkGestureMultiPress* _tmp27_;
	GtkListBox* _tmp28_;
	GtkEventControllerKey* _tmp29_;
	GtkEventControllerKey* _tmp30_;
	GtkEventControllerKey* _tmp31_;
	GtkListBox* _tmp32_;
	GtkEventControllerKey* _tmp33_;
	GtkEventControllerKey* _tmp34_;
	GtkListBox* _tmp35_;
	GtkTargetEntry* _tmp36_;
	GtkTargetEntry* _tmp37_;
	gint _tmp37__length1;
	GtkListBox* _tmp38_;
	GtkListBox* _tmp39_;
	GtkListBox* _tmp40_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_category_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_CATEGORY_VIEW, SlingshotWidgetsCategoryView);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_BROWSE);
	g_object_set ((GtkWidget*) _tmp0_, "width-request", 120, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->category_switcher);
	self->priv->category_switcher = _tmp0_;
	_tmp1_ = self->priv->category_switcher;
	gtk_list_box_set_sort_func (_tmp1_, (GtkListBoxSortFunc) slingshot_widgets_category_view_category_sort_func, NULL, NULL);
	_tmp2_ = self->priv->category_switcher;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp4_, "child", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	g_object_set (_tmp4_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp4_);
	scrolled_category = _tmp4_;
	_tmp5_ = scrolled_category;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp7_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp7_);
	separator = _tmp7_;
	_tmp8_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp8_, TRUE);
	gtk_list_box_set_selection_mode (_tmp8_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp8_;
	_tmp9_ = self->priv->listbox;
	gtk_list_box_set_filter_func (_tmp9_, (GtkListBoxFilterFunc) slingshot_widgets_category_view_filter_function, g_object_ref (self), g_object_unref);
	_tmp10_ = self->priv->listbox;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp12_, "child", _tmp11_, NULL);
	_g_object_unref0 (_tmp11_);
	g_object_set (_tmp12_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp12_);
	listbox_scrolled = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	g_object_ref_sink (_tmp13_);
	container = _tmp13_;
	_tmp14_ = container;
	_tmp15_ = scrolled_category;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = container;
	_tmp17_ = separator;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = container;
	_tmp19_ = listbox_scrolled;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = container;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp20_, NULL);
	_tmp21_ = self->priv->category_switcher;
	g_signal_connect_object (_tmp21_, "move-cursor", (GCallback) _slingshot_widgets_category_view_move_cursor_gtk_list_box_move_cursor, self, 0);
	_tmp22_ = self->priv->category_switcher;
	g_signal_connect_object (_tmp22_, "row-selected", (GCallback) __slingshot_widgets_category_view___lambda61__gtk_list_box_row_selected, self, 0);
	_tmp23_ = self->priv->listbox;
	g_signal_connect_object (_tmp23_, "move-cursor", (GCallback) _slingshot_widgets_category_view_move_cursor_gtk_list_box_move_cursor, self, 0);
	_tmp24_ = self->priv->listbox;
	g_signal_connect_object (_tmp24_, "row-activated", (GCallback) __slingshot_widgets_category_view___lambda62__gtk_list_box_row_activated, self, 0);
	_tmp25_ = self->priv->listbox;
	_tmp26_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) _tmp25_);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp26_, (guint) 0);
	gtk_gesture_single_set_exclusive ((GtkGestureSingle*) _tmp26_, TRUE);
	_g_object_unref0 (self->priv->click_controller);
	self->priv->click_controller = _tmp26_;
	_tmp27_ = self->priv->click_controller;
	g_signal_connect_object (_tmp27_, "pressed", (GCallback) __slingshot_widgets_category_view___lambda64__gtk_gesture_multi_press_pressed, self, 0);
	_tmp28_ = self->priv->listbox;
	_tmp29_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp28_);
	_g_object_unref0 (self->priv->listbox_key_controller);
	self->priv->listbox_key_controller = _tmp29_;
	_tmp30_ = self->priv->listbox_key_controller;
	g_signal_connect_object (_tmp30_, "key-pressed", (GCallback) _slingshot_widgets_category_view_on_key_press_gtk_event_controller_key_key_pressed, self, 0);
	_tmp31_ = self->priv->listbox_key_controller;
	g_signal_connect_object (_tmp31_, "key-released", (GCallback) __slingshot_widgets_category_view___lambda65__gtk_event_controller_key_key_released, self, 0);
	_tmp32_ = self->priv->category_switcher;
	_tmp33_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp32_);
	_g_object_unref0 (self->priv->category_switcher_key_controller);
	self->priv->category_switcher_key_controller = _tmp33_;
	_tmp34_ = self->priv->category_switcher_key_controller;
	g_signal_connect_object (_tmp34_, "key-pressed", (GCallback) _slingshot_widgets_category_view_on_key_press_gtk_event_controller_key_key_pressed, self, 0);
	_tmp35_ = self->priv->listbox;
	_tmp36_ = g_new0 (GtkTargetEntry, 1);
	_tmp36_[0] = SLINGSHOT_WIDGETS_CATEGORY_VIEW_DND;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_drag_source_set ((GtkWidget*) _tmp35_, GDK_BUTTON1_MASK, _tmp37_, (gint) 1, GDK_ACTION_COPY);
	_tmp37_ = (g_free (_tmp37_), NULL);
	_tmp38_ = self->priv->listbox;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "drag-begin", (GCallback) __slingshot_widgets_category_view___lambda66__gtk_widget_drag_begin, self, 0);
	_tmp39_ = self->priv->listbox;
	g_signal_connect_object ((GtkWidget*) _tmp39_, "drag-end", (GCallback) __slingshot_widgets_category_view___lambda67__gtk_widget_drag_end, self, 0);
	_tmp40_ = self->priv->listbox;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "drag-data-get", (GCallback) __slingshot_widgets_category_view___lambda68__gtk_widget_drag_data_get, self, 0);
	slingshot_widgets_category_view_setup_sidebar (self);
	_g_object_unref0 (container);
	_g_object_unref0 (listbox_scrolled);
	_g_object_unref0 (separator);
	_g_object_unref0 (scrolled_category);
	return obj;
}

static void
slingshot_widgets_category_view_class_init (SlingshotWidgetsCategoryViewClass * klass,
                                            gpointer klass_data)
{
	slingshot_widgets_category_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsCategoryView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_category_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_category_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_category_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_category_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_CATEGORY_VIEW_VIEW_PROPERTY, slingshot_widgets_category_view_properties[SLINGSHOT_WIDGETS_CATEGORY_VIEW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", SLINGSHOT_TYPE_SLINGSHOT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
slingshot_widgets_category_view_instance_init (SlingshotWidgetsCategoryView * self,
                                               gpointer klass)
{
	self->priv = slingshot_widgets_category_view_get_instance_private (self);
	self->priv->drag_uri = NULL;
}

static void
slingshot_widgets_category_view_finalize (GObject * obj)
{
	SlingshotWidgetsCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_CATEGORY_VIEW, SlingshotWidgetsCategoryView);
	_g_object_unref0 (self->priv->_view);
	_g_free0 (self->priv->drag_uri);
	_g_object_unref0 (self->priv->category_switcher);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->click_controller);
	_g_object_unref0 (self->priv->listbox_key_controller);
	_g_object_unref0 (self->priv->category_switcher_key_controller);
	G_OBJECT_CLASS (slingshot_widgets_category_view_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_category_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsCategoryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_category_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsCategoryView), 0, (GInstanceInitFunc) slingshot_widgets_category_view_instance_init, NULL };
	GType slingshot_widgets_category_view_type_id;
	slingshot_widgets_category_view_type_id = g_type_register_static (gtk_event_box_get_type (), "SlingshotWidgetsCategoryView", &g_define_type_info, 0);
	SlingshotWidgetsCategoryView_private_offset = g_type_add_instance_private (slingshot_widgets_category_view_type_id, sizeof (SlingshotWidgetsCategoryViewPrivate));
	return slingshot_widgets_category_view_type_id;
}

GType
slingshot_widgets_category_view_get_type (void)
{
	static volatile gsize slingshot_widgets_category_view_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_category_view_type_id__once)) {
		GType slingshot_widgets_category_view_type_id;
		slingshot_widgets_category_view_type_id = slingshot_widgets_category_view_get_type_once ();
		g_once_init_leave (&slingshot_widgets_category_view_type_id__once, slingshot_widgets_category_view_type_id);
	}
	return slingshot_widgets_category_view_type_id__once;
}

static void
_vala_slingshot_widgets_category_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	SlingshotWidgetsCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_CATEGORY_VIEW, SlingshotWidgetsCategoryView);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_CATEGORY_VIEW_VIEW_PROPERTY:
		g_value_set_object (value, slingshot_widgets_category_view_get_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_category_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	SlingshotWidgetsCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_CATEGORY_VIEW, SlingshotWidgetsCategoryView);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_CATEGORY_VIEW_VIEW_PROPERTY:
		slingshot_widgets_category_view_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

