// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v6.32.0
// source: ui.proto

package protocol

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Action is the list of actions sent or received via the Notifications channel.
type Action int32

const (
	Action_NONE                 Action = 0
	Action_ENABLE_INTERCEPTION  Action = 1
	Action_DISABLE_INTERCEPTION Action = 2
	Action_ENABLE_FIREWALL      Action = 3
	Action_DISABLE_FIREWALL     Action = 4
	Action_RELOAD_FW_RULES      Action = 5
	Action_CHANGE_CONFIG        Action = 6
	Action_ENABLE_RULE          Action = 7
	Action_DISABLE_RULE         Action = 8
	Action_DELETE_RULE          Action = 9
	Action_CHANGE_RULE          Action = 10
	Action_LOG_LEVEL            Action = 11
	Action_STOP                 Action = 12
	// Notifications of type TASK_START or TASK_STOP expect a JSON in the
	// Notification.data field.
	// It's parsed to a struct with format
	// TaskNotification { Name string, Data interface{} }
	// where Data is translated to a map of values (map[string]string), with
	// the configuration for each task:
	// PidMonitor: {"interval": "5s", "pid": "1234"}
	// SocketsMonitor: {"interval": "5s", "states": "1,10"}
	Action_TASK_START Action = 13
	Action_TASK_STOP  Action = 14
)

// Enum value maps for Action.
var (
	Action_name = map[int32]string{
		0:  "NONE",
		1:  "ENABLE_INTERCEPTION",
		2:  "DISABLE_INTERCEPTION",
		3:  "ENABLE_FIREWALL",
		4:  "DISABLE_FIREWALL",
		5:  "RELOAD_FW_RULES",
		6:  "CHANGE_CONFIG",
		7:  "ENABLE_RULE",
		8:  "DISABLE_RULE",
		9:  "DELETE_RULE",
		10: "CHANGE_RULE",
		11: "LOG_LEVEL",
		12: "STOP",
		13: "TASK_START",
		14: "TASK_STOP",
	}
	Action_value = map[string]int32{
		"NONE":                 0,
		"ENABLE_INTERCEPTION":  1,
		"DISABLE_INTERCEPTION": 2,
		"ENABLE_FIREWALL":      3,
		"DISABLE_FIREWALL":     4,
		"RELOAD_FW_RULES":      5,
		"CHANGE_CONFIG":        6,
		"ENABLE_RULE":          7,
		"DISABLE_RULE":         8,
		"DELETE_RULE":          9,
		"CHANGE_RULE":          10,
		"LOG_LEVEL":            11,
		"STOP":                 12,
		"TASK_START":           13,
		"TASK_STOP":            14,
	}
)

func (x Action) Enum() *Action {
	p := new(Action)
	*p = x
	return p
}

func (x Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action) Descriptor() protoreflect.EnumDescriptor {
	return file_ui_proto_enumTypes[0].Descriptor()
}

func (Action) Type() protoreflect.EnumType {
	return &file_ui_proto_enumTypes[0]
}

func (x Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action.Descriptor instead.
func (Action) EnumDescriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{0}
}

type NotificationReplyCode int32

const (
	NotificationReplyCode_OK    NotificationReplyCode = 0
	NotificationReplyCode_ERROR NotificationReplyCode = 1
)

// Enum value maps for NotificationReplyCode.
var (
	NotificationReplyCode_name = map[int32]string{
		0: "OK",
		1: "ERROR",
	}
	NotificationReplyCode_value = map[string]int32{
		"OK":    0,
		"ERROR": 1,
	}
)

func (x NotificationReplyCode) Enum() *NotificationReplyCode {
	p := new(NotificationReplyCode)
	*p = x
	return p
}

func (x NotificationReplyCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationReplyCode) Descriptor() protoreflect.EnumDescriptor {
	return file_ui_proto_enumTypes[1].Descriptor()
}

func (NotificationReplyCode) Type() protoreflect.EnumType {
	return &file_ui_proto_enumTypes[1]
}

func (x NotificationReplyCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationReplyCode.Descriptor instead.
func (NotificationReplyCode) EnumDescriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{1}
}

type Alert_Priority int32

const (
	Alert_LOW    Alert_Priority = 0
	Alert_MEDIUM Alert_Priority = 1
	Alert_HIGH   Alert_Priority = 2
)

// Enum value maps for Alert_Priority.
var (
	Alert_Priority_name = map[int32]string{
		0: "LOW",
		1: "MEDIUM",
		2: "HIGH",
	}
	Alert_Priority_value = map[string]int32{
		"LOW":    0,
		"MEDIUM": 1,
		"HIGH":   2,
	}
)

func (x Alert_Priority) Enum() *Alert_Priority {
	p := new(Alert_Priority)
	*p = x
	return p
}

func (x Alert_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Alert_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_ui_proto_enumTypes[2].Descriptor()
}

func (Alert_Priority) Type() protoreflect.EnumType {
	return &file_ui_proto_enumTypes[2]
}

func (x Alert_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Alert_Priority.Descriptor instead.
func (Alert_Priority) EnumDescriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{0, 0}
}

type Alert_Type int32

const (
	Alert_ERROR   Alert_Type = 0
	Alert_WARNING Alert_Type = 1
	Alert_INFO    Alert_Type = 2
)

// Enum value maps for Alert_Type.
var (
	Alert_Type_name = map[int32]string{
		0: "ERROR",
		1: "WARNING",
		2: "INFO",
	}
	Alert_Type_value = map[string]int32{
		"ERROR":   0,
		"WARNING": 1,
		"INFO":    2,
	}
)

func (x Alert_Type) Enum() *Alert_Type {
	p := new(Alert_Type)
	*p = x
	return p
}

func (x Alert_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Alert_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_ui_proto_enumTypes[3].Descriptor()
}

func (Alert_Type) Type() protoreflect.EnumType {
	return &file_ui_proto_enumTypes[3]
}

func (x Alert_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Alert_Type.Descriptor instead.
func (Alert_Type) EnumDescriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{0, 1}
}

type Alert_Action int32

const (
	Alert_NONE       Alert_Action = 0
	Alert_SHOW_ALERT Alert_Action = 1
	Alert_SAVE_TO_DB Alert_Action = 2
)

// Enum value maps for Alert_Action.
var (
	Alert_Action_name = map[int32]string{
		0: "NONE",
		1: "SHOW_ALERT",
		2: "SAVE_TO_DB",
	}
	Alert_Action_value = map[string]int32{
		"NONE":       0,
		"SHOW_ALERT": 1,
		"SAVE_TO_DB": 2,
	}
)

func (x Alert_Action) Enum() *Alert_Action {
	p := new(Alert_Action)
	*p = x
	return p
}

func (x Alert_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Alert_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_ui_proto_enumTypes[4].Descriptor()
}

func (Alert_Action) Type() protoreflect.EnumType {
	return &file_ui_proto_enumTypes[4]
}

func (x Alert_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Alert_Action.Descriptor instead.
func (Alert_Action) EnumDescriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{0, 2}
}

// What caused the alert
type Alert_What int32

const (
	Alert_GENERIC      Alert_What = 0
	Alert_PROC_MONITOR Alert_What = 1
	Alert_FIREWALL     Alert_What = 2
	Alert_CONNECTION   Alert_What = 3
	Alert_RULE         Alert_What = 4
	Alert_NETLINK      Alert_What = 5
	// bind, exec, etc
	Alert_KERNEL_EVENT Alert_What = 6
)

// Enum value maps for Alert_What.
var (
	Alert_What_name = map[int32]string{
		0: "GENERIC",
		1: "PROC_MONITOR",
		2: "FIREWALL",
		3: "CONNECTION",
		4: "RULE",
		5: "NETLINK",
		6: "KERNEL_EVENT",
	}
	Alert_What_value = map[string]int32{
		"GENERIC":      0,
		"PROC_MONITOR": 1,
		"FIREWALL":     2,
		"CONNECTION":   3,
		"RULE":         4,
		"NETLINK":      5,
		"KERNEL_EVENT": 6,
	}
)

func (x Alert_What) Enum() *Alert_What {
	p := new(Alert_What)
	*p = x
	return p
}

func (x Alert_What) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Alert_What) Descriptor() protoreflect.EnumDescriptor {
	return file_ui_proto_enumTypes[5].Descriptor()
}

func (Alert_What) Type() protoreflect.EnumType {
	return &file_ui_proto_enumTypes[5]
}

func (x Alert_What) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Alert_What.Descriptor instead.
func (Alert_What) EnumDescriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{0, 3}
}

// *
// - Send error messages (kernel not compatible, etc)
// - Send warnings (eBPF modules failed loading, etc)
// - Send kernel events: new execs, bytes recv/sent, ...
// - Alert of events defined by the user: alert when a rule matches
type Alert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id   uint64     `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Type Alert_Type `protobuf:"varint,2,opt,name=type,proto3,enum=protocol.Alert_Type" json:"type,omitempty"`
	// TODO: group of actions: SHOW_ALERT | SAVE_TO_DB
	Action   Alert_Action   `protobuf:"varint,3,opt,name=action,proto3,enum=protocol.Alert_Action" json:"action,omitempty"`
	Priority Alert_Priority `protobuf:"varint,4,opt,name=priority,proto3,enum=protocol.Alert_Priority" json:"priority,omitempty"`
	What     Alert_What     `protobuf:"varint,5,opt,name=what,proto3,enum=protocol.Alert_What" json:"what,omitempty"`
	// https://developers.google.com/protocol-buffers/docs/reference/go-generated#oneof
	//
	// Types that are assignable to Data:
	//
	//	*Alert_Text
	//	*Alert_Proc
	//	*Alert_Conn
	//	*Alert_Rule
	//	*Alert_Fwrule
	Data isAlert_Data `protobuf_oneof:"data"`
}

func (x *Alert) Reset() {
	*x = Alert{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Alert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Alert) ProtoMessage() {}

func (x *Alert) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Alert.ProtoReflect.Descriptor instead.
func (*Alert) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{0}
}

func (x *Alert) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Alert) GetType() Alert_Type {
	if x != nil {
		return x.Type
	}
	return Alert_ERROR
}

func (x *Alert) GetAction() Alert_Action {
	if x != nil {
		return x.Action
	}
	return Alert_NONE
}

func (x *Alert) GetPriority() Alert_Priority {
	if x != nil {
		return x.Priority
	}
	return Alert_LOW
}

func (x *Alert) GetWhat() Alert_What {
	if x != nil {
		return x.What
	}
	return Alert_GENERIC
}

func (m *Alert) GetData() isAlert_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *Alert) GetText() string {
	if x, ok := x.GetData().(*Alert_Text); ok {
		return x.Text
	}
	return ""
}

func (x *Alert) GetProc() *Process {
	if x, ok := x.GetData().(*Alert_Proc); ok {
		return x.Proc
	}
	return nil
}

func (x *Alert) GetConn() *Connection {
	if x, ok := x.GetData().(*Alert_Conn); ok {
		return x.Conn
	}
	return nil
}

func (x *Alert) GetRule() *Rule {
	if x, ok := x.GetData().(*Alert_Rule); ok {
		return x.Rule
	}
	return nil
}

func (x *Alert) GetFwrule() *FwRule {
	if x, ok := x.GetData().(*Alert_Fwrule); ok {
		return x.Fwrule
	}
	return nil
}

type isAlert_Data interface {
	isAlert_Data()
}

type Alert_Text struct {
	// errors, messages, etc
	Text string `protobuf:"bytes,6,opt,name=text,proto3,oneof"`
}

type Alert_Proc struct {
	// proc events: send/recv bytes, etc
	Proc *Process `protobuf:"bytes,8,opt,name=proc,proto3,oneof"`
}

type Alert_Conn struct {
	// conn events: bind, listen, etc
	Conn *Connection `protobuf:"bytes,9,opt,name=conn,proto3,oneof"`
}

type Alert_Rule struct {
	Rule *Rule `protobuf:"bytes,10,opt,name=rule,proto3,oneof"`
}

type Alert_Fwrule struct {
	Fwrule *FwRule `protobuf:"bytes,11,opt,name=fwrule,proto3,oneof"`
}

func (*Alert_Text) isAlert_Data() {}

func (*Alert_Proc) isAlert_Data() {}

func (*Alert_Conn) isAlert_Data() {}

func (*Alert_Rule) isAlert_Data() {}

func (*Alert_Fwrule) isAlert_Data() {}

type MsgResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *MsgResponse) Reset() {
	*x = MsgResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MsgResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MsgResponse) ProtoMessage() {}

func (x *MsgResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MsgResponse.ProtoReflect.Descriptor instead.
func (*MsgResponse) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{1}
}

func (x *MsgResponse) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Time       string      `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	Connection *Connection `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	Rule       *Rule       `protobuf:"bytes,3,opt,name=rule,proto3" json:"rule,omitempty"`
	Unixnano   int64       `protobuf:"varint,4,opt,name=unixnano,proto3" json:"unixnano,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{2}
}

func (x *Event) GetTime() string {
	if x != nil {
		return x.Time
	}
	return ""
}

func (x *Event) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *Event) GetRule() *Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *Event) GetUnixnano() int64 {
	if x != nil {
		return x.Unixnano
	}
	return 0
}

type Statistics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DaemonVersion string            `protobuf:"bytes,1,opt,name=daemon_version,json=daemonVersion,proto3" json:"daemon_version,omitempty"`
	Rules         uint64            `protobuf:"varint,2,opt,name=rules,proto3" json:"rules,omitempty"`
	Uptime        uint64            `protobuf:"varint,3,opt,name=uptime,proto3" json:"uptime,omitempty"`
	DnsResponses  uint64            `protobuf:"varint,4,opt,name=dns_responses,json=dnsResponses,proto3" json:"dns_responses,omitempty"`
	Connections   uint64            `protobuf:"varint,5,opt,name=connections,proto3" json:"connections,omitempty"`
	Ignored       uint64            `protobuf:"varint,6,opt,name=ignored,proto3" json:"ignored,omitempty"`
	Accepted      uint64            `protobuf:"varint,7,opt,name=accepted,proto3" json:"accepted,omitempty"`
	Dropped       uint64            `protobuf:"varint,8,opt,name=dropped,proto3" json:"dropped,omitempty"`
	RuleHits      uint64            `protobuf:"varint,9,opt,name=rule_hits,json=ruleHits,proto3" json:"rule_hits,omitempty"`
	RuleMisses    uint64            `protobuf:"varint,10,opt,name=rule_misses,json=ruleMisses,proto3" json:"rule_misses,omitempty"`
	ByProto       map[string]uint64 `protobuf:"bytes,11,rep,name=by_proto,json=byProto,proto3" json:"by_proto,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ByAddress     map[string]uint64 `protobuf:"bytes,12,rep,name=by_address,json=byAddress,proto3" json:"by_address,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ByHost        map[string]uint64 `protobuf:"bytes,13,rep,name=by_host,json=byHost,proto3" json:"by_host,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ByPort        map[string]uint64 `protobuf:"bytes,14,rep,name=by_port,json=byPort,proto3" json:"by_port,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ByUid         map[string]uint64 `protobuf:"bytes,15,rep,name=by_uid,json=byUid,proto3" json:"by_uid,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ByExecutable  map[string]uint64 `protobuf:"bytes,16,rep,name=by_executable,json=byExecutable,proto3" json:"by_executable,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	Events        []*Event          `protobuf:"bytes,17,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *Statistics) Reset() {
	*x = Statistics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Statistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Statistics) ProtoMessage() {}

func (x *Statistics) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Statistics.ProtoReflect.Descriptor instead.
func (*Statistics) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{3}
}

func (x *Statistics) GetDaemonVersion() string {
	if x != nil {
		return x.DaemonVersion
	}
	return ""
}

func (x *Statistics) GetRules() uint64 {
	if x != nil {
		return x.Rules
	}
	return 0
}

func (x *Statistics) GetUptime() uint64 {
	if x != nil {
		return x.Uptime
	}
	return 0
}

func (x *Statistics) GetDnsResponses() uint64 {
	if x != nil {
		return x.DnsResponses
	}
	return 0
}

func (x *Statistics) GetConnections() uint64 {
	if x != nil {
		return x.Connections
	}
	return 0
}

func (x *Statistics) GetIgnored() uint64 {
	if x != nil {
		return x.Ignored
	}
	return 0
}

func (x *Statistics) GetAccepted() uint64 {
	if x != nil {
		return x.Accepted
	}
	return 0
}

func (x *Statistics) GetDropped() uint64 {
	if x != nil {
		return x.Dropped
	}
	return 0
}

func (x *Statistics) GetRuleHits() uint64 {
	if x != nil {
		return x.RuleHits
	}
	return 0
}

func (x *Statistics) GetRuleMisses() uint64 {
	if x != nil {
		return x.RuleMisses
	}
	return 0
}

func (x *Statistics) GetByProto() map[string]uint64 {
	if x != nil {
		return x.ByProto
	}
	return nil
}

func (x *Statistics) GetByAddress() map[string]uint64 {
	if x != nil {
		return x.ByAddress
	}
	return nil
}

func (x *Statistics) GetByHost() map[string]uint64 {
	if x != nil {
		return x.ByHost
	}
	return nil
}

func (x *Statistics) GetByPort() map[string]uint64 {
	if x != nil {
		return x.ByPort
	}
	return nil
}

func (x *Statistics) GetByUid() map[string]uint64 {
	if x != nil {
		return x.ByUid
	}
	return nil
}

func (x *Statistics) GetByExecutable() map[string]uint64 {
	if x != nil {
		return x.ByExecutable
	}
	return nil
}

func (x *Statistics) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

type PingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id    uint64      `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Stats *Statistics `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *PingRequest) Reset() {
	*x = PingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PingRequest) ProtoMessage() {}

func (x *PingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PingRequest.ProtoReflect.Descriptor instead.
func (*PingRequest) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{4}
}

func (x *PingRequest) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *PingRequest) GetStats() *Statistics {
	if x != nil {
		return x.Stats
	}
	return nil
}

type PingReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *PingReply) Reset() {
	*x = PingReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PingReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PingReply) ProtoMessage() {}

func (x *PingReply) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PingReply.ProtoReflect.Descriptor instead.
func (*PingReply) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{5}
}

func (x *PingReply) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

type StringInt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value uint32 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StringInt) Reset() {
	*x = StringInt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StringInt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringInt) ProtoMessage() {}

func (x *StringInt) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringInt.ProtoReflect.Descriptor instead.
func (*StringInt) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{6}
}

func (x *StringInt) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *StringInt) GetValue() uint32 {
	if x != nil {
		return x.Value
	}
	return 0
}

type Process struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pid         uint64            `protobuf:"varint,1,opt,name=pid,proto3" json:"pid,omitempty"`
	Ppid        uint64            `protobuf:"varint,2,opt,name=ppid,proto3" json:"ppid,omitempty"`
	Uid         uint64            `protobuf:"varint,3,opt,name=uid,proto3" json:"uid,omitempty"`
	Comm        string            `protobuf:"bytes,4,opt,name=comm,proto3" json:"comm,omitempty"`
	Path        string            `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	Args        []string          `protobuf:"bytes,6,rep,name=args,proto3" json:"args,omitempty"`
	Env         map[string]string `protobuf:"bytes,7,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Cwd         string            `protobuf:"bytes,8,opt,name=cwd,proto3" json:"cwd,omitempty"`
	Checksums   map[string]string `protobuf:"bytes,9,rep,name=checksums,proto3" json:"checksums,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	IoReads     uint64            `protobuf:"varint,10,opt,name=io_reads,json=ioReads,proto3" json:"io_reads,omitempty"`
	IoWrites    uint64            `protobuf:"varint,11,opt,name=io_writes,json=ioWrites,proto3" json:"io_writes,omitempty"`
	NetReads    uint64            `protobuf:"varint,12,opt,name=net_reads,json=netReads,proto3" json:"net_reads,omitempty"`
	NetWrites   uint64            `protobuf:"varint,13,opt,name=net_writes,json=netWrites,proto3" json:"net_writes,omitempty"`
	ProcessTree []*StringInt      `protobuf:"bytes,14,rep,name=process_tree,json=processTree,proto3" json:"process_tree,omitempty"`
}

func (x *Process) Reset() {
	*x = Process{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Process) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Process) ProtoMessage() {}

func (x *Process) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Process.ProtoReflect.Descriptor instead.
func (*Process) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{7}
}

func (x *Process) GetPid() uint64 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *Process) GetPpid() uint64 {
	if x != nil {
		return x.Ppid
	}
	return 0
}

func (x *Process) GetUid() uint64 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *Process) GetComm() string {
	if x != nil {
		return x.Comm
	}
	return ""
}

func (x *Process) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Process) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *Process) GetEnv() map[string]string {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *Process) GetCwd() string {
	if x != nil {
		return x.Cwd
	}
	return ""
}

func (x *Process) GetChecksums() map[string]string {
	if x != nil {
		return x.Checksums
	}
	return nil
}

func (x *Process) GetIoReads() uint64 {
	if x != nil {
		return x.IoReads
	}
	return 0
}

func (x *Process) GetIoWrites() uint64 {
	if x != nil {
		return x.IoWrites
	}
	return 0
}

func (x *Process) GetNetReads() uint64 {
	if x != nil {
		return x.NetReads
	}
	return 0
}

func (x *Process) GetNetWrites() uint64 {
	if x != nil {
		return x.NetWrites
	}
	return 0
}

func (x *Process) GetProcessTree() []*StringInt {
	if x != nil {
		return x.ProcessTree
	}
	return nil
}

type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Protocol         string            `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	SrcIp            string            `protobuf:"bytes,2,opt,name=src_ip,json=srcIp,proto3" json:"src_ip,omitempty"`
	SrcPort          uint32            `protobuf:"varint,3,opt,name=src_port,json=srcPort,proto3" json:"src_port,omitempty"`
	DstIp            string            `protobuf:"bytes,4,opt,name=dst_ip,json=dstIp,proto3" json:"dst_ip,omitempty"`
	DstHost          string            `protobuf:"bytes,5,opt,name=dst_host,json=dstHost,proto3" json:"dst_host,omitempty"`
	DstPort          uint32            `protobuf:"varint,6,opt,name=dst_port,json=dstPort,proto3" json:"dst_port,omitempty"`
	UserId           uint32            `protobuf:"varint,7,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	ProcessId        uint32            `protobuf:"varint,8,opt,name=process_id,json=processId,proto3" json:"process_id,omitempty"`
	ProcessPath      string            `protobuf:"bytes,9,opt,name=process_path,json=processPath,proto3" json:"process_path,omitempty"`
	ProcessCwd       string            `protobuf:"bytes,10,opt,name=process_cwd,json=processCwd,proto3" json:"process_cwd,omitempty"`
	ProcessArgs      []string          `protobuf:"bytes,11,rep,name=process_args,json=processArgs,proto3" json:"process_args,omitempty"`
	ProcessEnv       map[string]string `protobuf:"bytes,12,rep,name=process_env,json=processEnv,proto3" json:"process_env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ProcessChecksums map[string]string `protobuf:"bytes,13,rep,name=process_checksums,json=processChecksums,proto3" json:"process_checksums,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ProcessTree      []*StringInt      `protobuf:"bytes,14,rep,name=process_tree,json=processTree,proto3" json:"process_tree,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{8}
}

func (x *Connection) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *Connection) GetSrcIp() string {
	if x != nil {
		return x.SrcIp
	}
	return ""
}

func (x *Connection) GetSrcPort() uint32 {
	if x != nil {
		return x.SrcPort
	}
	return 0
}

func (x *Connection) GetDstIp() string {
	if x != nil {
		return x.DstIp
	}
	return ""
}

func (x *Connection) GetDstHost() string {
	if x != nil {
		return x.DstHost
	}
	return ""
}

func (x *Connection) GetDstPort() uint32 {
	if x != nil {
		return x.DstPort
	}
	return 0
}

func (x *Connection) GetUserId() uint32 {
	if x != nil {
		return x.UserId
	}
	return 0
}

func (x *Connection) GetProcessId() uint32 {
	if x != nil {
		return x.ProcessId
	}
	return 0
}

func (x *Connection) GetProcessPath() string {
	if x != nil {
		return x.ProcessPath
	}
	return ""
}

func (x *Connection) GetProcessCwd() string {
	if x != nil {
		return x.ProcessCwd
	}
	return ""
}

func (x *Connection) GetProcessArgs() []string {
	if x != nil {
		return x.ProcessArgs
	}
	return nil
}

func (x *Connection) GetProcessEnv() map[string]string {
	if x != nil {
		return x.ProcessEnv
	}
	return nil
}

func (x *Connection) GetProcessChecksums() map[string]string {
	if x != nil {
		return x.ProcessChecksums
	}
	return nil
}

func (x *Connection) GetProcessTree() []*StringInt {
	if x != nil {
		return x.ProcessTree
	}
	return nil
}

type Operator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type      string      `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Operand   string      `protobuf:"bytes,2,opt,name=operand,proto3" json:"operand,omitempty"`
	Data      string      `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	Sensitive bool        `protobuf:"varint,4,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	List      []*Operator `protobuf:"bytes,5,rep,name=list,proto3" json:"list,omitempty"`
}

func (x *Operator) Reset() {
	*x = Operator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operator) ProtoMessage() {}

func (x *Operator) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operator.ProtoReflect.Descriptor instead.
func (*Operator) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{9}
}

func (x *Operator) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Operator) GetOperand() string {
	if x != nil {
		return x.Operand
	}
	return ""
}

func (x *Operator) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

func (x *Operator) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *Operator) GetList() []*Operator {
	if x != nil {
		return x.List
	}
	return nil
}

type Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Created     int64     `protobuf:"varint,1,opt,name=created,proto3" json:"created,omitempty"`
	Name        string    `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Description string    `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Enabled     bool      `protobuf:"varint,4,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Precedence  bool      `protobuf:"varint,5,opt,name=precedence,proto3" json:"precedence,omitempty"`
	Nolog       bool      `protobuf:"varint,6,opt,name=nolog,proto3" json:"nolog,omitempty"`
	Action      string    `protobuf:"bytes,7,opt,name=action,proto3" json:"action,omitempty"`
	Duration    string    `protobuf:"bytes,8,opt,name=duration,proto3" json:"duration,omitempty"`
	Operator    *Operator `protobuf:"bytes,9,opt,name=operator,proto3" json:"operator,omitempty"`
}

func (x *Rule) Reset() {
	*x = Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{10}
}

func (x *Rule) GetCreated() int64 {
	if x != nil {
		return x.Created
	}
	return 0
}

func (x *Rule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Rule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Rule) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Rule) GetPrecedence() bool {
	if x != nil {
		return x.Precedence
	}
	return false
}

func (x *Rule) GetNolog() bool {
	if x != nil {
		return x.Nolog
	}
	return false
}

func (x *Rule) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *Rule) GetDuration() string {
	if x != nil {
		return x.Duration
	}
	return ""
}

func (x *Rule) GetOperator() *Operator {
	if x != nil {
		return x.Operator
	}
	return nil
}

type StatementValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=Key,proto3" json:"Key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *StatementValues) Reset() {
	*x = StatementValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatementValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatementValues) ProtoMessage() {}

func (x *StatementValues) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatementValues.ProtoReflect.Descriptor instead.
func (*StatementValues) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{11}
}

func (x *StatementValues) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *StatementValues) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type Statement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Op     string             `protobuf:"bytes,1,opt,name=Op,proto3" json:"Op,omitempty"`
	Name   string             `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	Values []*StatementValues `protobuf:"bytes,3,rep,name=Values,proto3" json:"Values,omitempty"`
}

func (x *Statement) Reset() {
	*x = Statement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Statement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Statement) ProtoMessage() {}

func (x *Statement) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Statement.ProtoReflect.Descriptor instead.
func (*Statement) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{12}
}

func (x *Statement) GetOp() string {
	if x != nil {
		return x.Op
	}
	return ""
}

func (x *Statement) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Statement) GetValues() []*StatementValues {
	if x != nil {
		return x.Values
	}
	return nil
}

type Expressions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Statement *Statement `protobuf:"bytes,1,opt,name=Statement,proto3" json:"Statement,omitempty"`
}

func (x *Expressions) Reset() {
	*x = Expressions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expressions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expressions) ProtoMessage() {}

func (x *Expressions) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expressions.ProtoReflect.Descriptor instead.
func (*Expressions) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{13}
}

func (x *Expressions) GetStatement() *Statement {
	if x != nil {
		return x.Statement
	}
	return nil
}

type FwRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DEPRECATED: for backward compatibility with iptables
	Table            string         `protobuf:"bytes,1,opt,name=Table,proto3" json:"Table,omitempty"`
	Chain            string         `protobuf:"bytes,2,opt,name=Chain,proto3" json:"Chain,omitempty"`
	UUID             string         `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	Enabled          bool           `protobuf:"varint,4,opt,name=Enabled,proto3" json:"Enabled,omitempty"`
	Position         uint64         `protobuf:"varint,5,opt,name=Position,proto3" json:"Position,omitempty"`
	Description      string         `protobuf:"bytes,6,opt,name=Description,proto3" json:"Description,omitempty"`
	Parameters       string         `protobuf:"bytes,7,opt,name=Parameters,proto3" json:"Parameters,omitempty"`
	Expressions      []*Expressions `protobuf:"bytes,8,rep,name=Expressions,proto3" json:"Expressions,omitempty"`
	Target           string         `protobuf:"bytes,9,opt,name=Target,proto3" json:"Target,omitempty"`
	TargetParameters string         `protobuf:"bytes,10,opt,name=TargetParameters,proto3" json:"TargetParameters,omitempty"`
}

func (x *FwRule) Reset() {
	*x = FwRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FwRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FwRule) ProtoMessage() {}

func (x *FwRule) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FwRule.ProtoReflect.Descriptor instead.
func (*FwRule) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{14}
}

func (x *FwRule) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *FwRule) GetChain() string {
	if x != nil {
		return x.Chain
	}
	return ""
}

func (x *FwRule) GetUUID() string {
	if x != nil {
		return x.UUID
	}
	return ""
}

func (x *FwRule) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *FwRule) GetPosition() uint64 {
	if x != nil {
		return x.Position
	}
	return 0
}

func (x *FwRule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FwRule) GetParameters() string {
	if x != nil {
		return x.Parameters
	}
	return ""
}

func (x *FwRule) GetExpressions() []*Expressions {
	if x != nil {
		return x.Expressions
	}
	return nil
}

func (x *FwRule) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *FwRule) GetTargetParameters() string {
	if x != nil {
		return x.TargetParameters
	}
	return ""
}

type FwChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string    `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Table    string    `protobuf:"bytes,2,opt,name=Table,proto3" json:"Table,omitempty"`
	Family   string    `protobuf:"bytes,3,opt,name=Family,proto3" json:"Family,omitempty"`
	Priority string    `protobuf:"bytes,4,opt,name=Priority,proto3" json:"Priority,omitempty"`
	Type     string    `protobuf:"bytes,5,opt,name=Type,proto3" json:"Type,omitempty"`
	Hook     string    `protobuf:"bytes,6,opt,name=Hook,proto3" json:"Hook,omitempty"`
	Policy   string    `protobuf:"bytes,7,opt,name=Policy,proto3" json:"Policy,omitempty"`
	Rules    []*FwRule `protobuf:"bytes,8,rep,name=Rules,proto3" json:"Rules,omitempty"`
}

func (x *FwChain) Reset() {
	*x = FwChain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FwChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FwChain) ProtoMessage() {}

func (x *FwChain) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FwChain.ProtoReflect.Descriptor instead.
func (*FwChain) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{15}
}

func (x *FwChain) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FwChain) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *FwChain) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

func (x *FwChain) GetPriority() string {
	if x != nil {
		return x.Priority
	}
	return ""
}

func (x *FwChain) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *FwChain) GetHook() string {
	if x != nil {
		return x.Hook
	}
	return ""
}

func (x *FwChain) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *FwChain) GetRules() []*FwRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type FwChains struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DEPRECATED: backward compatibility with iptables
	Rule   *FwRule    `protobuf:"bytes,1,opt,name=Rule,proto3" json:"Rule,omitempty"`
	Chains []*FwChain `protobuf:"bytes,2,rep,name=Chains,proto3" json:"Chains,omitempty"`
}

func (x *FwChains) Reset() {
	*x = FwChains{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FwChains) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FwChains) ProtoMessage() {}

func (x *FwChains) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FwChains.ProtoReflect.Descriptor instead.
func (*FwChains) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{16}
}

func (x *FwChains) GetRule() *FwRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *FwChains) GetChains() []*FwChain {
	if x != nil {
		return x.Chains
	}
	return nil
}

type SysFirewall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled     bool        `protobuf:"varint,1,opt,name=Enabled,proto3" json:"Enabled,omitempty"`
	Version     uint32      `protobuf:"varint,2,opt,name=Version,proto3" json:"Version,omitempty"`
	SystemRules []*FwChains `protobuf:"bytes,3,rep,name=SystemRules,proto3" json:"SystemRules,omitempty"`
}

func (x *SysFirewall) Reset() {
	*x = SysFirewall{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SysFirewall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SysFirewall) ProtoMessage() {}

func (x *SysFirewall) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SysFirewall.ProtoReflect.Descriptor instead.
func (*SysFirewall) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{17}
}

func (x *SysFirewall) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SysFirewall) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *SysFirewall) GetSystemRules() []*FwChains {
	if x != nil {
		return x.SystemRules
	}
	return nil
}

// client configuration sent on Subscribe()
type ClientConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name              string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Version           string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	IsFirewallRunning bool   `protobuf:"varint,4,opt,name=isFirewallRunning,proto3" json:"isFirewallRunning,omitempty"`
	// daemon configuration as json string
	Config         string       `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
	LogLevel       uint32       `protobuf:"varint,6,opt,name=logLevel,proto3" json:"logLevel,omitempty"`
	Rules          []*Rule      `protobuf:"bytes,7,rep,name=rules,proto3" json:"rules,omitempty"`
	SystemFirewall *SysFirewall `protobuf:"bytes,8,opt,name=systemFirewall,proto3" json:"systemFirewall,omitempty"`
}

func (x *ClientConfig) Reset() {
	*x = ClientConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConfig) ProtoMessage() {}

func (x *ClientConfig) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConfig.ProtoReflect.Descriptor instead.
func (*ClientConfig) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{18}
}

func (x *ClientConfig) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ClientConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClientConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClientConfig) GetIsFirewallRunning() bool {
	if x != nil {
		return x.IsFirewallRunning
	}
	return false
}

func (x *ClientConfig) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *ClientConfig) GetLogLevel() uint32 {
	if x != nil {
		return x.LogLevel
	}
	return 0
}

func (x *ClientConfig) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *ClientConfig) GetSystemFirewall() *SysFirewall {
	if x != nil {
		return x.SystemFirewall
	}
	return nil
}

// Notification message is sent to the clients (daemons) from the GUI (server)
// for several purposes:
//   - Start tasks.
//   - Change configurations (rules, firewall, configuration)
//   - Start / Stop interception or firewall.
//   - Sent back the status of each task (errors, ok)
//
// Notifications are sent via an always open streaming channel.
// It's also used indirectly to maintain the connection status with the GUI (server).
type Notification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id         uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	ClientName string `protobuf:"bytes,2,opt,name=clientName,proto3" json:"clientName,omitempty"`
	ServerName string `protobuf:"bytes,3,opt,name=serverName,proto3" json:"serverName,omitempty"`
	// CHANGE_CONFIG: 2, data: {"default_timeout": 1, ...}
	Type        Action       `protobuf:"varint,4,opt,name=type,proto3,enum=protocol.Action" json:"type,omitempty"`
	Data        string       `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	Rules       []*Rule      `protobuf:"bytes,6,rep,name=rules,proto3" json:"rules,omitempty"`
	SysFirewall *SysFirewall `protobuf:"bytes,7,opt,name=sysFirewall,proto3" json:"sysFirewall,omitempty"`
}

func (x *Notification) Reset() {
	*x = Notification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Notification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Notification) ProtoMessage() {}

func (x *Notification) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Notification.ProtoReflect.Descriptor instead.
func (*Notification) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{19}
}

func (x *Notification) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Notification) GetClientName() string {
	if x != nil {
		return x.ClientName
	}
	return ""
}

func (x *Notification) GetServerName() string {
	if x != nil {
		return x.ServerName
	}
	return ""
}

func (x *Notification) GetType() Action {
	if x != nil {
		return x.Type
	}
	return Action_NONE
}

func (x *Notification) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

func (x *Notification) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *Notification) GetSysFirewall() *SysFirewall {
	if x != nil {
		return x.SysFirewall
	}
	return nil
}

// notification reply sent to the server (GUI)
type NotificationReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id   uint64                `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Code NotificationReplyCode `protobuf:"varint,2,opt,name=code,proto3,enum=protocol.NotificationReplyCode" json:"code,omitempty"`
	Data string                `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *NotificationReply) Reset() {
	*x = NotificationReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ui_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationReply) ProtoMessage() {}

func (x *NotificationReply) ProtoReflect() protoreflect.Message {
	mi := &file_ui_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationReply.ProtoReflect.Descriptor instead.
func (*NotificationReply) Descriptor() ([]byte, []int) {
	return file_ui_proto_rawDescGZIP(), []int{20}
}

func (x *NotificationReply) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *NotificationReply) GetCode() NotificationReplyCode {
	if x != nil {
		return x.Code
	}
	return NotificationReplyCode_OK
}

func (x *NotificationReply) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

var File_ui_proto protoreflect.FileDescriptor

var file_ui_proto_rawDesc = []byte{
	0x0a, 0x08, 0x75, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x22, 0x8d, 0x05, 0x0a, 0x05, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x28,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x28,
	0x0a, 0x04, 0x77, 0x68, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x57, 0x68,
	0x61, 0x74, 0x52, 0x04, 0x77, 0x68, 0x61, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x27,
	0x0a, 0x04, 0x70, 0x72, 0x6f, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x48,
	0x00, 0x52, 0x04, 0x70, 0x72, 0x6f, 0x63, 0x12, 0x2a, 0x0a, 0x04, 0x63, 0x6f, 0x6e, 0x6e, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04, 0x63,
	0x6f, 0x6e, 0x6e, 0x12, 0x24, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x52, 0x75, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x66, 0x77, 0x72,
	0x75, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x46, 0x77, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x06, 0x66,
	0x77, 0x72, 0x75, 0x6c, 0x65, 0x22, 0x29, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45,
	0x44, 0x49, 0x55, 0x4d, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x02,
	0x22, 0x28, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x02, 0x22, 0x32, 0x0a, 0x06, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x53, 0x48, 0x4f, 0x57, 0x5f, 0x41, 0x4c, 0x45, 0x52, 0x54, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x53, 0x41, 0x56, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x44, 0x42, 0x10, 0x02, 0x22, 0x6c,
	0x0a, 0x04, 0x57, 0x68, 0x61, 0x74, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49,
	0x43, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x43, 0x5f, 0x4d, 0x4f, 0x4e, 0x49,
	0x54, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c,
	0x4c, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x04, 0x12, 0x0b, 0x0a,
	0x07, 0x4e, 0x45, 0x54, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x4b, 0x45,
	0x52, 0x4e, 0x45, 0x4c, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x06, 0x42, 0x06, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x1d, 0x0a, 0x0b, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x02, 0x69, 0x64, 0x22, 0x91, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x34, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x75,
	0x6e, 0x69, 0x78, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x75,
	0x6e, 0x69, 0x78, 0x6e, 0x61, 0x6e, 0x6f, 0x22, 0xc7, 0x08, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x74,
	0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x61, 0x65, 0x6d, 0x6f, 0x6e,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x64, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a,
	0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x64,
	0x6e, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0c, 0x64, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73,
	0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x07, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x72, 0x6f, 0x70,
	0x70, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x64, 0x72, 0x6f, 0x70, 0x70,
	0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x68, 0x69, 0x74, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x48, 0x69, 0x74, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x72, 0x75, 0x6c, 0x65, 0x4d, 0x69, 0x73, 0x73, 0x65, 0x73,
	0x12, 0x3c, 0x0a, 0x08, 0x62, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x18, 0x0b, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x62, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x42,
	0x0a, 0x0a, 0x62, 0x79, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x62, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x39, 0x0a, 0x07, 0x62, 0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x79, 0x48, 0x6f, 0x73, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x62, 0x79, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x07, 0x62, 0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x62, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x36, 0x0a, 0x06, 0x62, 0x79, 0x5f, 0x75,
	0x69, 0x64, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x42,
	0x79, 0x55, 0x69, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x62, 0x79, 0x55, 0x69, 0x64,
	0x12, 0x4b, 0x0a, 0x0d, 0x62, 0x79, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x79,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0c, 0x62, 0x79, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x27, 0x0a,
	0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x42, 0x79, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3c, 0x0a, 0x0e, 0x42, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x39, 0x0a, 0x0b, 0x42, 0x79, 0x48, 0x6f, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x42,
	0x79, 0x50, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x38, 0x0a, 0x0a, 0x42, 0x79, 0x55, 0x69, 0x64, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x3f, 0x0a, 0x11, 0x42, 0x79, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x49, 0x0a, 0x0b, 0x50, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x1b, 0x0a, 0x09,
	0x50, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x22, 0x33, 0x0a, 0x09, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x9f,
	0x04, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x70, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x70, 0x70, 0x69, 0x64,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x6d, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x63, 0x6f, 0x6d, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72,
	0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x2c,
	0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x45,
	0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12, 0x10, 0x0a, 0x03,
	0x63, 0x77, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x77, 0x64, 0x12, 0x3e,
	0x0a, 0x09, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x09, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x19,
	0x0a, 0x08, 0x69, 0x6f, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x07, 0x69, 0x6f, 0x52, 0x65, 0x61, 0x64, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6f, 0x5f,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x69, 0x6f,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x65, 0x74, 0x5f, 0x72, 0x65,
	0x61, 0x64, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6e, 0x65, 0x74, 0x52, 0x65,
	0x61, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x6e, 0x65, 0x74, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x73, 0x12, 0x36, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x72,
	0x65, 0x65, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x52, 0x0b, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x54, 0x72, 0x65, 0x65, 0x1a, 0x36, 0x0a, 0x08, 0x45, 0x6e,
	0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3c, 0x0a, 0x0e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xa2, 0x05, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x15, 0x0a, 0x06, 0x73,
	0x72, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x72, 0x63,
	0x49, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x72, 0x63, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x73, 0x72, 0x63, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x15, 0x0a,
	0x06, 0x64, 0x73, 0x74, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x64,
	0x73, 0x74, 0x49, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x73, 0x74, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x73, 0x74, 0x48, 0x6f, 0x73, 0x74, 0x12,
	0x19, 0x0a, 0x08, 0x64, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x64, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69,
	0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x63, 0x77, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x77, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x41, 0x72, 0x67, 0x73, 0x12, 0x45, 0x0a, 0x0b, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x6e, 0x76, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x76, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x76,
	0x12, 0x57, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x36, 0x0a, 0x0c, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x54, 0x72, 0x65,
	0x65, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x76, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x43, 0x0a, 0x15, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x92, 0x01, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x12, 0x26, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x22, 0x8a, 0x02, 0x0a, 0x04, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1e, 0x0a,
	0x0a, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6e, 0x6f,
	0x6c, 0x6f, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x39, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x4b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x62, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x4f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x4f, 0x70, 0x12,
	0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x06, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x06,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x40, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xbd, 0x02, 0x0a, 0x06, 0x46, 0x77, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x43, 0x68, 0x61,
	0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x55, 0x55, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x55,
	0x55, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x08, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x10,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xcf, 0x01, 0x0a, 0x07, 0x46, 0x77, 0x43,
	0x68, 0x61, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x6f, 0x6f, 0x6b, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x48, 0x6f, 0x6f, 0x6b, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x26, 0x0a, 0x05, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x46, 0x77, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x05, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x5b, 0x0a, 0x08, 0x46, 0x77,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x46, 0x77, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x06,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x46, 0x77, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52,
	0x06, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x22, 0x77, 0x0a, 0x0b, 0x53, 0x79, 0x73, 0x46, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x18, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x0b, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x46, 0x77, 0x43, 0x68, 0x61,
	0x69, 0x6e, 0x73, 0x52, 0x0b, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x22, 0x93, 0x02, 0x0a, 0x0c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x2c, 0x0a, 0x11, 0x69, 0x73, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x69, 0x73, 0x46, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x16, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x24, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0e, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x79, 0x73, 0x46, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x0e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x46, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x22, 0xf7, 0x01, 0x0a, 0x0c, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x24, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x73, 0x79, 0x73, 0x46, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x53, 0x79, 0x73, 0x46, 0x69, 0x72, 0x65, 0x77,
	0x61, 0x6c, 0x6c, 0x52, 0x0b, 0x73, 0x79, 0x73, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c,
	0x22, 0x6c, 0x0a, 0x11, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x33, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x2a, 0x95,
	0x02, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e,
	0x45, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x43, 0x45, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x45, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x44,
	0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x10,
	0x04, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x46, 0x57, 0x5f, 0x52,
	0x55, 0x4c, 0x45, 0x53, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x0f, 0x0a, 0x0b,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x09, 0x12, 0x0f, 0x0a,
	0x0b, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x0a, 0x12, 0x0d,
	0x0a, 0x09, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x0b, 0x12, 0x08, 0x0a,
	0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x0c, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x41, 0x53, 0x4b, 0x5f,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x0d, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x41, 0x53, 0x4b, 0x5f,
	0x53, 0x54, 0x4f, 0x50, 0x10, 0x0e, 0x2a, 0x2a, 0x0a, 0x15, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x32, 0xaf, 0x02, 0x0a, 0x02, 0x55, 0x49, 0x12, 0x34, 0x0a, 0x04, 0x50, 0x69, 0x6e,
	0x67, 0x12, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x50, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2e, 0x50, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x22, 0x00, 0x12,
	0x31, 0x0a, 0x07, 0x41, 0x73, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x14, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x0e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x52, 0x75, 0x6c, 0x65,
	0x22, 0x00, 0x12, 0x3d, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12,
	0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x00, 0x12, 0x4a, 0x0a, 0x0d, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x1a,
	0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x35, 0x0a,
	0x09, 0x50, 0x6f, 0x73, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x12, 0x0f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x1a, 0x15, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x42, 0x35, 0x5a, 0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x65, 0x76, 0x69, 0x6c, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x2f, 0x6f, 0x70,
	0x65, 0x6e, 0x73, 0x6e, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x64, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x2f,
	0x75, 0x69, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_ui_proto_rawDescOnce sync.Once
	file_ui_proto_rawDescData = file_ui_proto_rawDesc
)

func file_ui_proto_rawDescGZIP() []byte {
	file_ui_proto_rawDescOnce.Do(func() {
		file_ui_proto_rawDescData = protoimpl.X.CompressGZIP(file_ui_proto_rawDescData)
	})
	return file_ui_proto_rawDescData
}

var file_ui_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_ui_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_ui_proto_goTypes = []interface{}{
	(Action)(0),                // 0: protocol.Action
	(NotificationReplyCode)(0), // 1: protocol.NotificationReplyCode
	(Alert_Priority)(0),        // 2: protocol.Alert.Priority
	(Alert_Type)(0),            // 3: protocol.Alert.Type
	(Alert_Action)(0),          // 4: protocol.Alert.Action
	(Alert_What)(0),            // 5: protocol.Alert.What
	(*Alert)(nil),              // 6: protocol.Alert
	(*MsgResponse)(nil),        // 7: protocol.MsgResponse
	(*Event)(nil),              // 8: protocol.Event
	(*Statistics)(nil),         // 9: protocol.Statistics
	(*PingRequest)(nil),        // 10: protocol.PingRequest
	(*PingReply)(nil),          // 11: protocol.PingReply
	(*StringInt)(nil),          // 12: protocol.StringInt
	(*Process)(nil),            // 13: protocol.Process
	(*Connection)(nil),         // 14: protocol.Connection
	(*Operator)(nil),           // 15: protocol.Operator
	(*Rule)(nil),               // 16: protocol.Rule
	(*StatementValues)(nil),    // 17: protocol.StatementValues
	(*Statement)(nil),          // 18: protocol.Statement
	(*Expressions)(nil),        // 19: protocol.Expressions
	(*FwRule)(nil),             // 20: protocol.FwRule
	(*FwChain)(nil),            // 21: protocol.FwChain
	(*FwChains)(nil),           // 22: protocol.FwChains
	(*SysFirewall)(nil),        // 23: protocol.SysFirewall
	(*ClientConfig)(nil),       // 24: protocol.ClientConfig
	(*Notification)(nil),       // 25: protocol.Notification
	(*NotificationReply)(nil),  // 26: protocol.NotificationReply
	nil,                        // 27: protocol.Statistics.ByProtoEntry
	nil,                        // 28: protocol.Statistics.ByAddressEntry
	nil,                        // 29: protocol.Statistics.ByHostEntry
	nil,                        // 30: protocol.Statistics.ByPortEntry
	nil,                        // 31: protocol.Statistics.ByUidEntry
	nil,                        // 32: protocol.Statistics.ByExecutableEntry
	nil,                        // 33: protocol.Process.EnvEntry
	nil,                        // 34: protocol.Process.ChecksumsEntry
	nil,                        // 35: protocol.Connection.ProcessEnvEntry
	nil,                        // 36: protocol.Connection.ProcessChecksumsEntry
}
var file_ui_proto_depIdxs = []int32{
	3,  // 0: protocol.Alert.type:type_name -> protocol.Alert.Type
	4,  // 1: protocol.Alert.action:type_name -> protocol.Alert.Action
	2,  // 2: protocol.Alert.priority:type_name -> protocol.Alert.Priority
	5,  // 3: protocol.Alert.what:type_name -> protocol.Alert.What
	13, // 4: protocol.Alert.proc:type_name -> protocol.Process
	14, // 5: protocol.Alert.conn:type_name -> protocol.Connection
	16, // 6: protocol.Alert.rule:type_name -> protocol.Rule
	20, // 7: protocol.Alert.fwrule:type_name -> protocol.FwRule
	14, // 8: protocol.Event.connection:type_name -> protocol.Connection
	16, // 9: protocol.Event.rule:type_name -> protocol.Rule
	27, // 10: protocol.Statistics.by_proto:type_name -> protocol.Statistics.ByProtoEntry
	28, // 11: protocol.Statistics.by_address:type_name -> protocol.Statistics.ByAddressEntry
	29, // 12: protocol.Statistics.by_host:type_name -> protocol.Statistics.ByHostEntry
	30, // 13: protocol.Statistics.by_port:type_name -> protocol.Statistics.ByPortEntry
	31, // 14: protocol.Statistics.by_uid:type_name -> protocol.Statistics.ByUidEntry
	32, // 15: protocol.Statistics.by_executable:type_name -> protocol.Statistics.ByExecutableEntry
	8,  // 16: protocol.Statistics.events:type_name -> protocol.Event
	9,  // 17: protocol.PingRequest.stats:type_name -> protocol.Statistics
	33, // 18: protocol.Process.env:type_name -> protocol.Process.EnvEntry
	34, // 19: protocol.Process.checksums:type_name -> protocol.Process.ChecksumsEntry
	12, // 20: protocol.Process.process_tree:type_name -> protocol.StringInt
	35, // 21: protocol.Connection.process_env:type_name -> protocol.Connection.ProcessEnvEntry
	36, // 22: protocol.Connection.process_checksums:type_name -> protocol.Connection.ProcessChecksumsEntry
	12, // 23: protocol.Connection.process_tree:type_name -> protocol.StringInt
	15, // 24: protocol.Operator.list:type_name -> protocol.Operator
	15, // 25: protocol.Rule.operator:type_name -> protocol.Operator
	17, // 26: protocol.Statement.Values:type_name -> protocol.StatementValues
	18, // 27: protocol.Expressions.Statement:type_name -> protocol.Statement
	19, // 28: protocol.FwRule.Expressions:type_name -> protocol.Expressions
	20, // 29: protocol.FwChain.Rules:type_name -> protocol.FwRule
	20, // 30: protocol.FwChains.Rule:type_name -> protocol.FwRule
	21, // 31: protocol.FwChains.Chains:type_name -> protocol.FwChain
	22, // 32: protocol.SysFirewall.SystemRules:type_name -> protocol.FwChains
	16, // 33: protocol.ClientConfig.rules:type_name -> protocol.Rule
	23, // 34: protocol.ClientConfig.systemFirewall:type_name -> protocol.SysFirewall
	0,  // 35: protocol.Notification.type:type_name -> protocol.Action
	16, // 36: protocol.Notification.rules:type_name -> protocol.Rule
	23, // 37: protocol.Notification.sysFirewall:type_name -> protocol.SysFirewall
	1,  // 38: protocol.NotificationReply.code:type_name -> protocol.NotificationReplyCode
	10, // 39: protocol.UI.Ping:input_type -> protocol.PingRequest
	14, // 40: protocol.UI.AskRule:input_type -> protocol.Connection
	24, // 41: protocol.UI.Subscribe:input_type -> protocol.ClientConfig
	26, // 42: protocol.UI.Notifications:input_type -> protocol.NotificationReply
	6,  // 43: protocol.UI.PostAlert:input_type -> protocol.Alert
	11, // 44: protocol.UI.Ping:output_type -> protocol.PingReply
	16, // 45: protocol.UI.AskRule:output_type -> protocol.Rule
	24, // 46: protocol.UI.Subscribe:output_type -> protocol.ClientConfig
	25, // 47: protocol.UI.Notifications:output_type -> protocol.Notification
	7,  // 48: protocol.UI.PostAlert:output_type -> protocol.MsgResponse
	44, // [44:49] is the sub-list for method output_type
	39, // [39:44] is the sub-list for method input_type
	39, // [39:39] is the sub-list for extension type_name
	39, // [39:39] is the sub-list for extension extendee
	0,  // [0:39] is the sub-list for field type_name
}

func init() { file_ui_proto_init() }
func file_ui_proto_init() {
	if File_ui_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_ui_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Alert); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MsgResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Statistics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PingReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StringInt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Process); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatementValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Statement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expressions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FwRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FwChain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FwChains); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SysFirewall); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Notification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ui_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ui_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Alert_Text)(nil),
		(*Alert_Proc)(nil),
		(*Alert_Conn)(nil),
		(*Alert_Rule)(nil),
		(*Alert_Fwrule)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ui_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ui_proto_goTypes,
		DependencyIndexes: file_ui_proto_depIdxs,
		EnumInfos:         file_ui_proto_enumTypes,
		MessageInfos:      file_ui_proto_msgTypes,
	}.Build()
	File_ui_proto = out.File
	file_ui_proto_rawDesc = nil
	file_ui_proto_goTypes = nil
	file_ui_proto_depIdxs = nil
}
