// prebuilt/core/error.mycpp.h: GENERATED by mycpp

#ifndef CORE_ERROR_MYCPP_H
#define CORE_ERROR_MYCPP_H

#include "_gen/asdl/hnode.asdl.h"
#include "_gen/display/pretty.asdl.h"
#include "cpp/data_lang.h"
#include "mycpp/runtime.h"

#include "_gen/core/runtime.asdl.h"
#include "_gen/core/value.asdl.h"
#include "_gen/frontend/syntax.asdl.h"

using value_asdl::value;  // This is a bit ad hoc

namespace error {  // forward declare
  class _ErrorWithLocation;
  class Usage;
  class Parse;
  class WordFailure;
  class FailGlob;
  class VarSubFailure;
  class RedirectEval;
  class FatalRuntime;
  class Strict;
  class ErrExit;
  class Expr;
  class Structured;
  class AssertionErr;
  class TypeErrVerbose;
  class TypeErr;
  class Runtime;
  class Decode;
  class Encode;
}

namespace error {  // declare

BigStr* _ValType(value_asdl::value_t* val);
class _ErrorWithLocation {
 public:
  _ErrorWithLocation(BigStr* msg, syntax_asdl::loc_t* location);
  bool HasLocation();
  BigStr* UserErrorString();
  syntax_asdl::loc_t* location{};
  BigStr* msg{};
  
  static constexpr uint32_t field_mask() {
    return maskbit(offsetof(_ErrorWithLocation, location))
         | maskbit(offsetof(_ErrorWithLocation, msg));
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(_ErrorWithLocation));
  }

  DISALLOW_COPY_AND_ASSIGN(_ErrorWithLocation)
};

class Usage : public ::error::_ErrorWithLocation {
 public:
  Usage(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::_ErrorWithLocation::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(Usage));
  }

  DISALLOW_COPY_AND_ASSIGN(Usage)
};

class Parse : public ::error::_ErrorWithLocation {
 public:
  Parse(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::_ErrorWithLocation::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(Parse));
  }

  DISALLOW_COPY_AND_ASSIGN(Parse)
};

class WordFailure : public ::error::_ErrorWithLocation {
 public:
  WordFailure(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::_ErrorWithLocation::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(WordFailure));
  }

  DISALLOW_COPY_AND_ASSIGN(WordFailure)
};

class FailGlob : public ::error::WordFailure {
 public:
  FailGlob(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::WordFailure::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(FailGlob));
  }

  DISALLOW_COPY_AND_ASSIGN(FailGlob)
};

class VarSubFailure : public ::error::WordFailure {
 public:
  VarSubFailure(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::WordFailure::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(VarSubFailure));
  }

  DISALLOW_COPY_AND_ASSIGN(VarSubFailure)
};

class RedirectEval : public ::error::_ErrorWithLocation {
 public:
  RedirectEval(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::_ErrorWithLocation::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(RedirectEval));
  }

  DISALLOW_COPY_AND_ASSIGN(RedirectEval)
};

class FatalRuntime : public ::error::_ErrorWithLocation {
 public:
  FatalRuntime(int exit_status, BigStr* msg, syntax_asdl::loc_t* location);
  int ExitStatus();

  int exit_status{};
  
  static constexpr uint32_t field_mask() {
    return ::error::_ErrorWithLocation::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(FatalRuntime));
  }

  DISALLOW_COPY_AND_ASSIGN(FatalRuntime)
};

class Strict : public ::error::FatalRuntime {
 public:
  Strict(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::FatalRuntime::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(Strict));
  }

  DISALLOW_COPY_AND_ASSIGN(Strict)
};

class ErrExit : public ::error::FatalRuntime {
 public:
  ErrExit(int exit_status, BigStr* msg, syntax_asdl::loc_t* location, bool show_code = false);

  bool show_code{};
  
  static constexpr uint32_t field_mask() {
    return ::error::FatalRuntime::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(ErrExit));
  }

  DISALLOW_COPY_AND_ASSIGN(ErrExit)
};

class Expr : public ::error::FatalRuntime {
 public:
  Expr(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::FatalRuntime::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(Expr));
  }

  DISALLOW_COPY_AND_ASSIGN(Expr)
};

class Structured : public ::error::FatalRuntime {
 public:
  Structured(int status, BigStr* msg, syntax_asdl::loc_t* location, Dict<BigStr*, value_asdl::value_t*>* properties = nullptr);
  value::Dict* ToDict();

  Dict<BigStr*, value_asdl::value_t*>* properties{};
  
  static constexpr uint32_t field_mask() {
    return ::error::FatalRuntime::field_mask()
         | maskbit(offsetof(Structured, properties));
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(Structured));
  }

  DISALLOW_COPY_AND_ASSIGN(Structured)
};

class AssertionErr : public ::error::Expr {
 public:
  AssertionErr(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::Expr::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(AssertionErr));
  }

  DISALLOW_COPY_AND_ASSIGN(AssertionErr)
};

class TypeErrVerbose : public ::error::Expr {
 public:
  TypeErrVerbose(BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::Expr::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(TypeErrVerbose));
  }

  DISALLOW_COPY_AND_ASSIGN(TypeErrVerbose)
};

class TypeErr : public ::error::TypeErrVerbose {
 public:
  TypeErr(value_asdl::value_t* actual_val, BigStr* msg, syntax_asdl::loc_t* location);
  
  static constexpr uint32_t field_mask() {
    return ::error::TypeErrVerbose::field_mask();
  }

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassFixed(field_mask(), sizeof(TypeErr));
  }

  DISALLOW_COPY_AND_ASSIGN(TypeErr)
};

class Runtime {
 public:
  Runtime(BigStr* msg);
  BigStr* UserErrorString();
  BigStr* msg{};

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassScanned(1, sizeof(Runtime));
  }

  DISALLOW_COPY_AND_ASSIGN(Runtime)
};

class Decode {
 public:
  Decode(BigStr* msg, BigStr* s, int start_pos, int end_pos, int line_num);
  BigStr* Message();
  BigStr* __str__();
  BigStr* msg{};
  BigStr* s{};
  int start_pos{};
  int end_pos{};
  int line_num{};

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassScanned(2, sizeof(Decode));
  }

  DISALLOW_COPY_AND_ASSIGN(Decode)
};

class Encode {
 public:
  Encode(BigStr* msg);
  BigStr* Message();
  BigStr* msg{};

  static constexpr ObjHeader obj_header() {
    return ObjHeader::ClassScanned(1, sizeof(Encode));
  }

  DISALLOW_COPY_AND_ASSIGN(Encode)
};

[[noreturn]] void e_usage(BigStr* msg, syntax_asdl::loc_t* location);
[[noreturn]] void e_strict(BigStr* msg, syntax_asdl::loc_t* location);
[[noreturn]] void p_die(BigStr* msg, syntax_asdl::loc_t* location);
[[noreturn]] void e_die(BigStr* msg, syntax_asdl::loc_t* location = nullptr);
[[noreturn]] void e_die_status(int status, BigStr* msg, syntax_asdl::loc_t* location = nullptr);

}  // declare namespace error

#endif  // CORE_ERROR_MYCPP_H
