/* Editor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Editor.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gtkspell/gtkspell.h>
#include <glib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_EDITOR (enotes_editor_get_type ())
#define ENOTES_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_EDITOR, ENotesEditor))
#define ENOTES_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_EDITOR, ENotesEditorClass))
#define ENOTES_IS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_EDITOR))
#define ENOTES_IS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_EDITOR))
#define ENOTES_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_EDITOR, ENotesEditorClass))

typedef struct _ENotesEditor ENotesEditor;
typedef struct _ENotesEditorClass ENotesEditorClass;
typedef struct _ENotesEditorPrivate ENotesEditorPrivate;

#define ENOTES_TYPE_TOOLBAR_BUTTON (enotes_toolbar_button_get_type ())
#define ENOTES_TOOLBAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButton))
#define ENOTES_TOOLBAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButtonClass))
#define ENOTES_IS_TOOLBAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TOOLBAR_BUTTON))
#define ENOTES_IS_TOOLBAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TOOLBAR_BUTTON))
#define ENOTES_TOOLBAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButtonClass))

typedef struct _ENotesToolbarButton ENotesToolbarButton;
typedef struct _ENotesToolbarButtonClass ENotesToolbarButtonClass;

#define ENOTES_TYPE_HELP_BOX (enotes_help_box_get_type ())
#define ENOTES_HELP_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_HELP_BOX, ENotesHelpBox))
#define ENOTES_HELP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_HELP_BOX, ENotesHelpBoxClass))
#define ENOTES_IS_HELP_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_HELP_BOX))
#define ENOTES_IS_HELP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_HELP_BOX))
#define ENOTES_HELP_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_HELP_BOX, ENotesHelpBoxClass))

typedef struct _ENotesHelpBox ENotesHelpBox;
typedef struct _ENotesHelpBoxClass ENotesHelpBoxClass;
enum  {
	ENOTES_EDITOR_0_PROPERTY,
	ENOTES_EDITOR_SPELLCHECK_PROPERTY,
	ENOTES_EDITOR_NUM_PROPERTIES
};
static GParamSpec* enotes_editor_properties[ENOTES_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WORD_WRAPPER (word_wrapper_get_type ())
#define WORD_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORD_WRAPPER, WordWrapper))
#define WORD_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORD_WRAPPER, WordWrapperClass))
#define IS_WORD_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORD_WRAPPER))
#define IS_WORD_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORD_WRAPPER))
#define WORD_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORD_WRAPPER, WordWrapperClass))

typedef struct _WordWrapper WordWrapper;
typedef struct _WordWrapperClass WordWrapperClass;

#define ENOTES_SERVICES_TYPE_SETTINGS (enotes_services_settings_get_type ())
#define ENOTES_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_SERVICES_TYPE_SETTINGS, ENotesServicesSettings))
#define ENOTES_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_SERVICES_TYPE_SETTINGS, ENotesServicesSettingsClass))
#define ENOTES_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_SERVICES_TYPE_SETTINGS))
#define ENOTES_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_SERVICES_TYPE_SETTINGS))
#define ENOTES_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_SERVICES_TYPE_SETTINGS, ENotesServicesSettingsClass))

typedef struct _ENotesServicesSettings ENotesServicesSettings;
typedef struct _ENotesServicesSettingsClass ENotesServicesSettingsClass;

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ENOTES_TYPE_PLUGIN_MANAGER (enotes_plugin_manager_get_type ())
#define ENOTES_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManager))
#define ENOTES_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManagerClass))
#define ENOTES_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN_MANAGER))
#define ENOTES_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN_MANAGER))
#define ENOTES_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManagerClass))

typedef struct _ENotesPluginManager ENotesPluginManager;
typedef struct _ENotesPluginManagerClass ENotesPluginManagerClass;

#define ENOTES_TYPE_PLUGIN (enotes_plugin_get_type ())
#define ENOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN, ENotesPlugin))
#define ENOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN, ENotesPluginClass))
#define ENOTES_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN))
#define ENOTES_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN))
#define ENOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN, ENotesPluginClass))

typedef struct _ENotesPlugin ENotesPlugin;
typedef struct _ENotesPluginClass ENotesPluginClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define ENOTES_TYPE_TRASH (enotes_trash_get_type ())
#define ENOTES_TRASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TRASH, ENotesTrash))
#define ENOTES_TRASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TRASH, ENotesTrashClass))
#define ENOTES_IS_TRASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TRASH))
#define ENOTES_IS_TRASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TRASH))
#define ENOTES_TRASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TRASH, ENotesTrashClass))

typedef struct _ENotesTrash ENotesTrash;
typedef struct _ENotesTrashClass ENotesTrashClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ENotesEditor {
	GtkBox parent_instance;
	ENotesEditorPrivate * priv;
	ENotesToolbarButton* bold_button;
	ENotesToolbarButton* italics_button;
	ENotesToolbarButton* strike_button;
};

struct _ENotesEditorClass {
	GtkBoxClass parent_class;
};

struct _ENotesEditorPrivate {
	GtkSourceView* code_view;
	GtkSourceBuffer* code_buffer;
	GtkBox* editor_and_help;
	ENotesHelpBox* help;
	GtkSpellChecker* spell;
	gboolean edited;
	GtkSourceSearchContext* search_context;
	GtkSourceSearchSettings* search_settings;
	guint text_change_timeout;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	ENotesEditor* self;
	GtkToggleButton* help_button;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

static gint ENotesEditor_private_offset;
static gpointer enotes_editor_parent_class = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesEditor, g_object_unref)
VALA_EXTERN GType enotes_toolbar_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesToolbarButton, g_object_unref)
VALA_EXTERN GType enotes_help_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesHelpBox, g_object_unref)
VALA_EXTERN ENotesEditor* enotes_editor_new (void);
VALA_EXTERN ENotesEditor* enotes_editor_construct (GType object_type);
static void enotes_editor_build_ui (ENotesEditor* self);
VALA_EXTERN void enotes_editor_reset (ENotesEditor* self,
                          gboolean disable_save);
static gboolean __lambda51_ (ENotesEditor* self);
VALA_EXTERN void enotes_editor_save_file (ENotesEditor* self);
static gboolean ___lambda51__gsource_func (gpointer self);
VALA_EXTERN WordWrapper* word_wrapper_new (void);
VALA_EXTERN WordWrapper* word_wrapper_construct (GType object_type);
VALA_EXTERN GType word_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WordWrapper, g_object_unref)
static void enotes_editor_trigger_changed (ENotesEditor* self);
static void _enotes_editor_trigger_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                             gpointer self);
static void enotes_editor_show_line_numbers (ENotesEditor* self,
                                      gboolean show);
VALA_EXTERN GType enotes_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesServicesSettings, g_object_unref)
VALA_EXTERN ENotesServicesSettings* enotes_services_settings_get_instance (void);
VALA_EXTERN gboolean enotes_services_settings_get_spellcheck (ENotesServicesSettings* self);
VALA_EXTERN void enotes_editor_set_spellcheck (ENotesEditor* self,
                                   gboolean value);
static void __lambda41_ (ENotesEditor* self);
VALA_EXTERN void enotes_services_settings_set_spellcheck_language (ENotesServicesSettings* self,
                                                       const gchar* value);
static void ___lambda41__gtk_spell_checker_language_changed (GtkSpellChecker* _sender,
                                                      const gchar* new_lang,
                                                      gpointer self);
static GtkBox* enotes_editor_build_toolbar (ENotesEditor* self);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
static void __lambda44_ (ENotesEditor* self);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
static void enotes_editor_set_current_page (ENotesEditor* self,
                                     ENotesPage* value);
static void ___lambda44__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda45_ (ENotesEditor* self);
static void ___lambda45__enotes_application_state_request_saving_page_info (ENotesApplicationState* _sender,
                                                                     gpointer self);
static void __lambda46_ (ENotesEditor* self);
static void enotes_editor_set_font (ENotesEditor* self,
                             const gchar* name);
VALA_EXTERN const gchar* enotes_application_state_get_editor_font (ENotesApplicationState* self);
static void ___lambda46__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda47_ (ENotesEditor* self);
static void enotes_editor_set_scheme (ENotesEditor* self,
                               const gchar* id);
VALA_EXTERN const gchar* enotes_application_state_get_editor_scheme (ENotesApplicationState* self);
static void ___lambda47__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda48_ (ENotesEditor* self);
VALA_EXTERN gboolean enotes_application_state_get_editor_show_line_numbers (ENotesApplicationState* self);
static void ___lambda48__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda49_ (ENotesEditor* self);
VALA_EXTERN gboolean enotes_application_state_get_editor_auto_indent (ENotesApplicationState* self);
static void ___lambda49__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda50_ (ENotesEditor* self);
VALA_EXTERN const gchar* enotes_application_state_get_search_field (ENotesApplicationState* self);
static void ___lambda50__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_new (const gchar* icon,
                                                const gchar* first_half,
                                                const gchar* second_half,
                                                const gchar* description,
                                                GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_construct (GType object_type,
                                                      const gchar* icon,
                                                      const gchar* first_half,
                                                      const gchar* second_half,
                                                      const gchar* description,
                                                      GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_new_is_image_button (const gchar* icon,
                                                                const gchar* first_half,
                                                                const gchar* second_half,
                                                                const gchar* description,
                                                                GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_construct_is_image_button (GType object_type,
                                                                      const gchar* icon,
                                                                      const gchar* first_half,
                                                                      const gchar* second_half,
                                                                      const gchar* description,
                                                                      GtkSourceBuffer* code_buffer);
VALA_EXTERN GType enotes_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPluginManager, g_object_unref)
VALA_EXTERN ENotesPluginManager* enotes_plugin_manager_get_instance (void);
VALA_EXTERN GType enotes_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPlugin, g_object_unref)
VALA_EXTERN ENotesPlugin** enotes_plugin_manager_get_plugs (ENotesPluginManager* self,
                                                gint* result_length1);
VALA_EXTERN GtkWidget* enotes_plugin_editor_button (ENotesPlugin* self);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_new_from_plugin (ENotesPlugin* plugin,
                                                            GtkWidget* widget,
                                                            GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_construct_from_plugin (GType object_type,
                                                                  ENotesPlugin* plugin,
                                                                  GtkWidget* widget,
                                                                  GtkSourceBuffer* code_buffer);
static void __lambda42_ (Block2Data* _data2_);
VALA_EXTERN ENotesHelpBox* enotes_help_box_new (void);
VALA_EXTERN ENotesHelpBox* enotes_help_box_construct (GType object_type);
static void ___lambda43_ (ENotesEditor* self,
                   const gchar* text);
static void ____lambda43__enotes_help_box_insert_requested (ENotesHelpBox* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void ___lambda42__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
VALA_EXTERN gchar* enotes_editor_get_text (ENotesEditor* self);
VALA_EXTERN void enotes_application_state_save_opened_page (ENotesApplicationState* self);
VALA_EXTERN void enotes_editor_give_focus (ENotesEditor* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gboolean __lambda40_ (ENotesEditor* self);
static gboolean ___lambda40__gsource_func (gpointer self);
VALA_EXTERN GType enotes_trash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTrash, g_object_unref)
VALA_EXTERN ENotesTrash* enotes_trash_get_instance (void);
VALA_EXTERN gboolean enotes_trash_is_page_trashed (ENotesTrash* self,
                                       ENotesPage* to_check);
VALA_EXTERN const gchar* enotes_services_settings_get_spellcheck_language (ENotesServicesSettings* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void enotes_editor_finalize (GObject * obj);
static GType enotes_editor_get_type_once (void);
static void _vala_enotes_editor_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
enotes_editor_get_instance_private (ENotesEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesEditor_private_offset);
}

static gboolean
__lambda51_ (ENotesEditor* self)
{
	gboolean result;
#line 104 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_save_file (self);
#line 105 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	result = TRUE;
#line 105 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return result;
#line 420 "Editor.c"
}

static gboolean
___lambda51__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda51_ ((ENotesEditor*) self);
#line 103 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return result;
#line 430 "Editor.c"
}

ENotesEditor*
enotes_editor_construct (GType object_type)
{
	ENotesEditor * self = NULL;
	WordWrapper* _tmp0_;
	WordWrapper* _tmp1_;
	GtkSourceSearchSettings* _tmp2_;
	GtkSourceSearchSettings* _tmp3_;
	GtkSourceSearchSettings* _tmp4_;
	GtkSourceBuffer* _tmp5_;
	GtkSourceSearchSettings* _tmp6_;
	GtkSourceSearchContext* _tmp7_;
#line 99 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self = (ENotesEditor*) g_object_new (object_type, NULL);
#line 100 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_build_ui (self);
#line 101 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_reset (self, FALSE);
#line 103 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 60000, ___lambda51__gsource_func, g_object_ref (self), g_object_unref);
#line 108 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = word_wrapper_new ();
#line 108 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_;
#line 108 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (_tmp1_);
#line 110 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = gtk_source_search_settings_new ();
#line 110 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->search_settings);
#line 110 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->search_settings = _tmp2_;
#line 111 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = self->priv->search_settings;
#line 111 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_search_settings_set_case_sensitive (_tmp3_, FALSE);
#line 112 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = self->priv->search_settings;
#line 112 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_search_settings_set_regex_enabled (_tmp4_, FALSE);
#line 114 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp5_ = self->priv->code_buffer;
#line 114 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp6_ = self->priv->search_settings;
#line 114 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp7_ = gtk_source_search_context_new (_tmp5_, _tmp6_);
#line 114 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->search_context);
#line 114 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->search_context = _tmp7_;
#line 99 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return self;
#line 485 "Editor.c"
}

ENotesEditor*
enotes_editor_new (void)
{
#line 99 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return enotes_editor_construct (ENOTES_TYPE_EDITOR);
#line 493 "Editor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 118 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return self ? g_object_ref (self) : NULL;
#line 501 "Editor.c"
}

static void
_enotes_editor_trigger_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                        gpointer self)
{
#line 129 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_trigger_changed ((ENotesEditor*) self);
#line 510 "Editor.c"
}

static void
__lambda41_ (ENotesEditor* self)
{
	ENotesServicesSettings* _tmp0_;
	ENotesServicesSettings* _tmp1_;
	GtkSpellChecker* _tmp2_;
	const gchar* _tmp3_;
#line 147 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_services_settings_get_instance ();
#line 147 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_;
#line 147 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = self->priv->spell;
#line 147 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = gtk_spell_checker_get_language (_tmp2_);
#line 147 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_services_settings_set_spellcheck_language (_tmp1_, _tmp3_);
#line 147 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (_tmp1_);
#line 532 "Editor.c"
}

static void
___lambda41__gtk_spell_checker_language_changed (GtkSpellChecker* _sender,
                                                 const gchar* new_lang,
                                                 gpointer self)
{
#line 146 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda41_ ((ENotesEditor*) self);
#line 542 "Editor.c"
}

static void
__lambda44_ (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
#line 159 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 159 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 159 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 159 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 159 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_set_current_page (self, _tmp3_);
#line 562 "Editor.c"
}

static void
___lambda44__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 158 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda44_ ((ENotesEditor*) self);
#line 572 "Editor.c"
}

static void
__lambda45_ (ENotesEditor* self)
{
#line 163 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_save_file (self);
#line 580 "Editor.c"
}

static void
___lambda45__enotes_application_state_request_saving_page_info (ENotesApplicationState* _sender,
                                                                gpointer self)
{
#line 162 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda45_ ((ENotesEditor*) self);
#line 589 "Editor.c"
}

static void
__lambda46_ (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 167 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 167 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 167 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_editor_font (_tmp1_);
#line 167 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 167 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_set_font (self, _tmp3_);
#line 609 "Editor.c"
}

static void
___lambda46__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 166 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda46_ ((ENotesEditor*) self);
#line 619 "Editor.c"
}

static void
__lambda47_ (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 171 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 171 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 171 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_editor_scheme (_tmp1_);
#line 171 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 171 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_set_scheme (self, _tmp3_);
#line 639 "Editor.c"
}

static void
___lambda47__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 170 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda47_ ((ENotesEditor*) self);
#line 649 "Editor.c"
}

static void
__lambda48_ (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 175 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 175 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 175 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_editor_show_line_numbers (_tmp1_);
#line 175 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 175 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_show_line_numbers (self, _tmp3_);
#line 669 "Editor.c"
}

static void
___lambda48__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 174 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda48_ ((ENotesEditor*) self);
#line 679 "Editor.c"
}

static void
__lambda49_ (ENotesEditor* self)
{
	GtkSourceView* _tmp0_;
	ENotesApplication* _tmp1_;
	ENotesApplicationState* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 179 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->code_view;
#line 179 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = enotes_app;
#line 179 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = _tmp1_->state;
#line 179 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = enotes_application_state_get_editor_auto_indent (_tmp2_);
#line 179 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = _tmp3_;
#line 179 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_view_set_auto_indent (_tmp0_, _tmp4_);
#line 702 "Editor.c"
}

static void
___lambda49__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 178 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda49_ ((ENotesEditor*) self);
#line 712 "Editor.c"
}

static void
__lambda50_ (ENotesEditor* self)
{
	GtkSourceSearchSettings* _tmp0_;
	ENotesApplication* _tmp1_;
	ENotesApplicationState* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 183 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->search_settings;
#line 183 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = enotes_app;
#line 183 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = _tmp1_->state;
#line 183 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = enotes_application_state_get_search_field (_tmp2_);
#line 183 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = _tmp3_;
#line 183 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_search_settings_set_search_text (_tmp0_, _tmp4_);
#line 735 "Editor.c"
}

static void
___lambda50__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 182 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda50_ ((ENotesEditor*) self);
#line 745 "Editor.c"
}

static void
enotes_editor_build_ui (ENotesEditor* self)
{
	GtkSourceLanguageManager* manager = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* language = NULL;
	GtkSourceLanguage* _tmp2_;
	GtkSourceLanguage* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	GtkSourceBuffer* _tmp5_;
	GtkSourceBuffer* _tmp6_;
	GtkSourceView* _tmp7_;
	GtkSourceBuffer* _tmp8_;
	GtkSourceView* _tmp9_;
	GtkSourceView* _tmp10_;
	GtkScrolledWindow* scroll_box = NULL;
	GtkScrolledWindow* _tmp11_;
	GtkSourceView* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkSpellChecker* _tmp15_;
	GtkSpellChecker* _tmp16_;
	ENotesServicesSettings* _tmp17_;
	ENotesServicesSettings* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GtkSpellChecker* _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkSeparator* _tmp24_;
	GtkSeparator* _tmp25_;
	GtkBox* _tmp26_;
	ENotesApplication* _tmp27_;
	ENotesApplicationState* _tmp28_;
	ENotesApplication* _tmp29_;
	ENotesApplicationState* _tmp30_;
	ENotesApplication* _tmp31_;
	ENotesApplicationState* _tmp32_;
	ENotesApplication* _tmp33_;
	ENotesApplicationState* _tmp34_;
	ENotesApplication* _tmp35_;
	ENotesApplicationState* _tmp36_;
	ENotesApplication* _tmp37_;
	ENotesApplicationState* _tmp38_;
	ENotesApplication* _tmp39_;
	ENotesApplicationState* _tmp40_;
#line 117 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 118 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 118 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 118 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	manager = _tmp1_;
#line 119 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = gtk_source_language_manager_guess_language (manager, NULL, "text/x-markdown");
#line 119 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 119 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	language = _tmp3_;
#line 120 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = gtk_source_buffer_new_with_language (language);
#line 120 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->code_buffer);
#line 120 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->code_buffer = _tmp4_;
#line 121 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp5_ = self->priv->code_buffer;
#line 121 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_buffer_set_max_undo_levels (_tmp5_, 100);
#line 123 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp6_ = self->priv->code_buffer;
#line 123 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp7_ = (GtkSourceView*) gtk_source_view_new_with_buffer (_tmp6_);
#line 123 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp7_);
#line 123 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->code_view);
#line 123 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->code_view = _tmp7_;
#line 125 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
#line 126 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 127 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
#line 129 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp8_ = self->priv->code_buffer;
#line 129 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GtkTextBuffer*) _tmp8_, "changed", (GCallback) _enotes_editor_trigger_changed_gtk_text_buffer_changed, self, 0);
#line 131 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp9_ = self->priv->code_view;
#line 131 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp9_, 6);
#line 132 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp10_ = self->priv->code_view;
#line 132 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_text_view_set_wrap_mode ((GtkTextView*) _tmp10_, GTK_WRAP_WORD);
#line 133 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_show_line_numbers (self, FALSE);
#line 135 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp11_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 135 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp11_);
#line 135 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	scroll_box = _tmp11_;
#line 136 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp12_ = self->priv->code_view;
#line 136 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) scroll_box, (GtkWidget*) _tmp12_);
#line 138 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 138 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp13_);
#line 138 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->editor_and_help);
#line 138 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->editor_and_help = _tmp13_;
#line 139 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp14_ = self->priv->editor_and_help;
#line 139 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) scroll_box);
#line 141 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp15_ = gtk_spell_checker_new ();
#line 141 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp15_);
#line 141 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->spell);
#line 141 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->spell = _tmp15_;
#line 142 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp16_ = self->priv->spell;
#line 142 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_set (_tmp16_, "decode-language-codes", TRUE, NULL);
#line 144 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp17_ = enotes_services_settings_get_instance ();
#line 144 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp18_ = _tmp17_;
#line 144 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp19_ = enotes_services_settings_get_spellcheck (_tmp18_);
#line 144 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp20_ = _tmp19_;
#line 144 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_set_spellcheck (self, _tmp20_);
#line 144 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (_tmp18_);
#line 146 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp21_ = self->priv->spell;
#line 146 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object (_tmp21_, "language-changed", (GCallback) ___lambda41__gtk_spell_checker_language_changed, self, 0);
#line 150 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp22_ = enotes_editor_build_toolbar (self);
#line 150 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp23_ = _tmp22_;
#line 150 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
#line 150 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (_tmp23_);
#line 151 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp24_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 151 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp24_);
#line 151 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp25_ = _tmp24_;
#line 151 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
#line 151 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (_tmp25_);
#line 152 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp26_ = self->priv->editor_and_help;
#line 152 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp26_);
#line 153 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
#line 154 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_set ((GtkWidget*) scroll_box, "expand", TRUE, NULL);
#line 156 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 158 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp27_ = enotes_app;
#line 158 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp28_ = _tmp27_->state;
#line 158 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GObject*) _tmp28_, "notify::opened-page", (GCallback) ___lambda44__g_object_notify, self, 0);
#line 162 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp29_ = enotes_app;
#line 162 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp30_ = _tmp29_->state;
#line 162 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object (_tmp30_, "request-saving-page-info", (GCallback) ___lambda45__enotes_application_state_request_saving_page_info, self, 0);
#line 166 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp31_ = enotes_app;
#line 166 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp32_ = _tmp31_->state;
#line 166 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GObject*) _tmp32_, "notify::editor-font", (GCallback) ___lambda46__g_object_notify, self, 0);
#line 170 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp33_ = enotes_app;
#line 170 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp34_ = _tmp33_->state;
#line 170 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GObject*) _tmp34_, "notify::editor-scheme", (GCallback) ___lambda47__g_object_notify, self, 0);
#line 174 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp35_ = enotes_app;
#line 174 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp36_ = _tmp35_->state;
#line 174 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GObject*) _tmp36_, "notify::editor-show-line-numbers", (GCallback) ___lambda48__g_object_notify, self, 0);
#line 178 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp37_ = enotes_app;
#line 178 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp38_ = _tmp37_->state;
#line 178 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GObject*) _tmp38_, "notify::editor-auto-indent", (GCallback) ___lambda49__g_object_notify, self, 0);
#line 182 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp39_ = enotes_app;
#line 182 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp40_ = _tmp39_->state;
#line 182 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GObject*) _tmp40_, "notify::search-field", (GCallback) ___lambda50__g_object_notify, self, 0);
#line 117 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (scroll_box);
#line 117 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (language);
#line 117 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (manager);
#line 975 "Editor.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return _data2_;
#line 985 "Editor.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 995 "Editor.c"
		ENotesEditor* self;
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		self = _data2_->self;
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_g_object_unref0 (_data2_->help_button);
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_g_object_unref0 (self);
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_slice_free (Block2Data, _data2_);
#line 1005 "Editor.c"
	}
}

static void
___lambda43_ (ENotesEditor* self,
              const gchar* text)
{
	GtkSourceBuffer* _tmp0_;
#line 267 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (text != NULL);
#line 268 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->code_buffer;
#line 268 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _tmp0_, text, -1);
#line 1020 "Editor.c"
}

static void
____lambda43__enotes_help_box_insert_requested (ENotesHelpBox* _sender,
                                                const gchar* text,
                                                gpointer self)
{
#line 267 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	___lambda43_ ((ENotesEditor*) self, text);
#line 1030 "Editor.c"
}

static void
__lambda42_ (Block2Data* _data2_)
{
	ENotesEditor* self;
	ENotesHelpBox* _tmp0_;
	ENotesHelpBox* _tmp5_;
#line 264 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self = _data2_->self;
#line 265 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->help;
#line 265 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (_tmp0_ == NULL) {
#line 1045 "Editor.c"
		ENotesHelpBox* _tmp1_;
		ENotesHelpBox* _tmp2_;
		GtkBox* _tmp3_;
		ENotesHelpBox* _tmp4_;
#line 266 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp1_ = enotes_help_box_new ();
#line 266 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_object_ref_sink (_tmp1_);
#line 266 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_g_object_unref0 (self->priv->help);
#line 266 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		self->priv->help = _tmp1_;
#line 267 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp2_ = self->priv->help;
#line 267 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_signal_connect_object (_tmp2_, "insert-requested", (GCallback) ____lambda43__enotes_help_box_insert_requested, self, 0);
#line 271 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp3_ = self->priv->editor_and_help;
#line 271 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp4_ = self->priv->help;
#line 271 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
#line 1068 "Editor.c"
	}
#line 274 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp5_ = self->priv->help;
#line 274 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp5_, gtk_toggle_button_get_active (_data2_->help_button));
#line 1074 "Editor.c"
}

static void
___lambda42__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
#line 264 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__lambda42_ (self);
#line 1083 "Editor.c"
}

static GtkBox*
enotes_editor_build_toolbar (ENotesEditor* self)
{
	Block2Data* _data2_;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	ENotesApplication* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkSourceBuffer* _tmp9_;
	ENotesToolbarButton* _tmp10_;
	ENotesApplication* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkSourceBuffer* _tmp17_;
	ENotesToolbarButton* _tmp18_;
	ENotesApplication* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkSourceBuffer* _tmp25_;
	ENotesToolbarButton* _tmp26_;
	ENotesToolbarButton* quote_button = NULL;
	GtkSourceBuffer* _tmp27_;
	ENotesToolbarButton* _tmp28_;
	ENotesToolbarButton* code_button = NULL;
	GtkSourceBuffer* _tmp29_;
	ENotesToolbarButton* _tmp30_;
	ENotesToolbarButton* link_button = NULL;
	GtkSourceBuffer* _tmp31_;
	ENotesToolbarButton* _tmp32_;
	ENotesToolbarButton* bulleted_button = NULL;
	GtkSourceBuffer* _tmp33_;
	ENotesToolbarButton* _tmp34_;
	ENotesToolbarButton* numbered_button = NULL;
	GtkSourceBuffer* _tmp35_;
	ENotesToolbarButton* _tmp36_;
	ENotesToolbarButton* webimage_button = NULL;
	GtkSourceBuffer* _tmp37_;
	ENotesToolbarButton* _tmp38_;
	GtkSeparator* separator1 = NULL;
	GtkSeparator* _tmp39_;
	GtkSeparator* separator2 = NULL;
	GtkSeparator* _tmp40_;
	GtkSeparator* separator3 = NULL;
	GtkSeparator* _tmp41_;
	GtkSeparator* _tmp42_;
	GtkSeparator* _tmp43_;
	GtkSeparator* _tmp44_;
	GtkSeparator* _tmp45_;
	GtkSeparator* _tmp46_;
	GtkSeparator* _tmp47_;
	GtkBox* _tmp48_;
	ENotesToolbarButton* _tmp49_;
	GtkBox* _tmp50_;
	ENotesToolbarButton* _tmp51_;
	GtkBox* _tmp52_;
	ENotesToolbarButton* _tmp53_;
	GtkBox* _tmp54_;
	GtkSeparator* _tmp55_;
	GtkBox* _tmp56_;
	ENotesToolbarButton* _tmp57_;
	GtkBox* _tmp58_;
	ENotesToolbarButton* _tmp59_;
	GtkBox* _tmp60_;
	ENotesToolbarButton* _tmp61_;
	GtkBox* _tmp62_;
	ENotesToolbarButton* _tmp63_;
	GtkBox* _tmp64_;
	GtkSeparator* _tmp65_;
	GtkBox* _tmp66_;
	ENotesToolbarButton* _tmp67_;
	GtkBox* _tmp68_;
	ENotesToolbarButton* _tmp69_;
	GtkBox* _tmp70_;
	GtkSeparator* _tmp71_;
	ENotesPluginManager* _tmp72_;
	ENotesPluginManager* _tmp73_;
	gint _tmp74_ = 0;
	ENotesPlugin** _tmp75_;
	ENotesPlugin** _tmp76_;
	gint _tmp76__length1;
	GtkToggleButton* _tmp87_;
	GtkImage* help_icon = NULL;
	GtkImage* _tmp88_;
	GtkStyleContext* _tmp89_;
	GtkBox* _tmp90_;
	GtkBox* result;
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_data2_->_ref_count_ = 1;
#line 187 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_data2_->self = g_object_ref (self);
#line 188 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 188 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp0_);
#line 188 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	box = _tmp0_;
#line 189 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = box;
#line 189 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
#line 189 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_style_context_add_class (_tmp2_, "inline-toolbar");
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = enotes_app;
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp5_ = _tmp4_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp3_, "win.bold-action");
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp6_ = _tmp5_;
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp6__length1 = _vala_array_length (_tmp4_);
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp7_ = granite_markup_accel_tooltip (_tmp6_, (gint) _vala_array_length (_tmp4_), _ ("Add bold to text"));
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp8_ = _tmp7_;
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp9_ = self->priv->code_buffer;
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp10_ = enotes_toolbar_button_new ("format-text-bold-symbolic", "**", "**", _tmp8_, _tmp9_);
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp10_);
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->bold_button);
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->bold_button = _tmp10_;
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_free0 (_tmp8_);
#line 191 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp11_ = enotes_app;
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp13_ = _tmp12_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp11_, "win.italics-action");
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp14_ = _tmp13_;
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp14__length1 = _vala_array_length (_tmp12_);
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp15_ = granite_markup_accel_tooltip (_tmp14_, (gint) _vala_array_length (_tmp12_), _ ("Add italic to text"));
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp16_ = _tmp15_;
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp17_ = self->priv->code_buffer;
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp18_ = enotes_toolbar_button_new ("format-text-italic-symbolic", "_", "_", _tmp16_, _tmp17_);
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp18_);
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->italics_button);
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->italics_button = _tmp18_;
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_free0 (_tmp16_);
#line 198 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp19_ = enotes_app;
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp21_ = _tmp20_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp19_, "win.strike-action");
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp22_ = _tmp21_;
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp22__length1 = _vala_array_length (_tmp20_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp23_ = granite_markup_accel_tooltip (_tmp22_, (gint) _vala_array_length (_tmp20_), _ ("Strikethrough text"));
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp24_ = _tmp23_;
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp25_ = self->priv->code_buffer;
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp26_ = enotes_toolbar_button_new ("format-text-strikethrough-symbolic", "~~", "~~", _tmp24_, _tmp25_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp26_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->strike_button);
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->strike_button = _tmp26_;
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_free0 (_tmp24_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
#line 212 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp27_ = self->priv->code_buffer;
#line 212 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp28_ = enotes_toolbar_button_new ("format-indent-less-rtl", "> ", "", _ ("Insert a quote"), _tmp27_);
#line 212 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp28_);
#line 212 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	quote_button = _tmp28_;
#line 213 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp29_ = self->priv->code_buffer;
#line 213 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp30_ = enotes_toolbar_button_new ("system-run", "`", "`", _ ("Insert code"), _tmp29_);
#line 213 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp30_);
#line 213 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	code_button = _tmp30_;
#line 214 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp31_ = self->priv->code_buffer;
#line 214 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp32_ = enotes_toolbar_button_new ("insert-link", "[Link Text](", ")", _ ("Insert a link"), _tmp31_);
#line 214 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp32_);
#line 214 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	link_button = _tmp32_;
#line 216 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp33_ = self->priv->code_buffer;
#line 216 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp34_ = enotes_toolbar_button_new ("zoom-out", "\n- ", "", _ ("Add a bulleted list"), _tmp33_);
#line 216 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp34_);
#line 216 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	bulleted_button = _tmp34_;
#line 217 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp35_ = self->priv->code_buffer;
#line 217 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp36_ = enotes_toolbar_button_new ("zoom-original", "\n1. ", "", _ ("Add a Numbered list"), _tmp35_);
#line 217 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp36_);
#line 217 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	numbered_button = _tmp36_;
#line 219 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp37_ = self->priv->code_buffer;
#line 219 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp38_ = enotes_toolbar_button_new_is_image_button ("insert-image", "![](", ")", _ ("Insert an image"), _tmp37_);
#line 219 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp38_);
#line 219 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	webimage_button = _tmp38_;
#line 221 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp39_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 221 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp39_);
#line 221 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	separator1 = _tmp39_;
#line 222 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp40_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 222 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp40_);
#line 222 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	separator2 = _tmp40_;
#line 223 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp41_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 223 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp41_);
#line 223 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	separator3 = _tmp41_;
#line 225 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp42_ = separator1;
#line 225 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp42_, 4);
#line 226 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp43_ = separator2;
#line 226 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp43_, 4);
#line 227 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp44_ = separator3;
#line 227 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp44_, 4);
#line 229 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp45_ = separator1;
#line 229 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp45_, 4);
#line 230 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp46_ = separator2;
#line 230 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp46_, 4);
#line 231 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp47_ = separator3;
#line 231 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp47_, 4);
#line 233 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp48_ = box;
#line 233 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp49_ = self->bold_button;
#line 233 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
#line 234 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp50_ = box;
#line 234 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp51_ = self->italics_button;
#line 234 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
#line 235 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp52_ = box;
#line 235 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp53_ = self->strike_button;
#line 235 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
#line 236 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp54_ = box;
#line 236 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp55_ = separator1;
#line 236 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
#line 237 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp56_ = box;
#line 237 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp57_ = quote_button;
#line 237 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
#line 238 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp58_ = box;
#line 238 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp59_ = code_button;
#line 238 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
#line 240 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp60_ = box;
#line 240 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp61_ = bulleted_button;
#line 240 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
#line 241 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp62_ = box;
#line 241 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp63_ = numbered_button;
#line 241 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
#line 242 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp64_ = box;
#line 242 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp65_ = separator2;
#line 242 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
#line 243 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp66_ = box;
#line 243 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp67_ = link_button;
#line 243 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
#line 244 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp68_ = box;
#line 244 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp69_ = webimage_button;
#line 244 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
#line 245 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp70_ = box;
#line 245 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp71_ = separator3;
#line 245 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp72_ = enotes_plugin_manager_get_instance ();
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp73_ = _tmp72_;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp75_ = enotes_plugin_manager_get_plugs (_tmp73_, &_tmp74_);
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp76_ = _tmp75_;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp76__length1 = _tmp74_;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (_tmp73_);
#line 1459 "Editor.c"
	{
		ENotesPlugin** plugin_collection = NULL;
		gint plugin_collection_length1 = 0;
		gint _plugin_collection_size_ = 0;
		gint plugin_it = 0;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		plugin_collection = _tmp76_;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		plugin_collection_length1 = _tmp76__length1;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		for (plugin_it = 0; plugin_it < plugin_collection_length1; plugin_it = plugin_it + 1) {
#line 1471 "Editor.c"
			ENotesPlugin* _tmp77_;
			ENotesPlugin* plugin = NULL;
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp77_ = _g_object_ref0 (plugin_collection[plugin_it]);
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			plugin = _tmp77_;
#line 1478 "Editor.c"
			{
				GtkWidget* widget = NULL;
				ENotesPlugin* _tmp78_;
				GtkWidget* _tmp79_;
				GtkWidget* _tmp80_;
#line 249 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				_tmp78_ = plugin;
#line 249 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				_tmp79_ = enotes_plugin_editor_button (_tmp78_);
#line 249 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				widget = _tmp79_;
#line 250 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				_tmp80_ = widget;
#line 250 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				if (_tmp80_ != NULL) {
#line 1494 "Editor.c"
					GtkBox* _tmp81_;
					ENotesPlugin* _tmp82_;
					GtkWidget* _tmp83_;
					GtkSourceBuffer* _tmp84_;
					ENotesToolbarButton* _tmp85_;
					ENotesToolbarButton* _tmp86_;
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp81_ = box;
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp82_ = plugin;
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp83_ = widget;
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp84_ = self->priv->code_buffer;
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp85_ = enotes_toolbar_button_new_from_plugin (_tmp82_, _tmp83_, _tmp84_);
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					g_object_ref_sink (_tmp85_);
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp86_ = _tmp85_;
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					gtk_container_add ((GtkContainer*) _tmp81_, (GtkWidget*) _tmp86_);
#line 251 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_g_object_unref0 (_tmp86_);
#line 1519 "Editor.c"
				}
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				_g_object_unref0 (widget);
#line 248 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				_g_object_unref0 (plugin);
#line 1525 "Editor.c"
			}
		}
	}
#line 255 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp87_ = (GtkToggleButton*) gtk_toggle_button_new ();
#line 255 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp87_);
#line 255 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_data2_->help_button = _tmp87_;
#line 256 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp88_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-question-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 256 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_ref_sink (_tmp88_);
#line 256 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	help_icon = _tmp88_;
#line 258 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _data2_->help_button, _ ("Formatting"));
#line 259 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp89_ = gtk_widget_get_style_context ((GtkWidget*) _data2_->help_button);
#line 259 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_style_context_add_class (_tmp89_, "flat");
#line 260 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _data2_->help_button, FALSE);
#line 261 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _data2_->help_button, TRUE);
#line 262 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_set_halign ((GtkWidget*) _data2_->help_button, GTK_ALIGN_END);
#line 264 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_data (_data2_->help_button, "toggled", (GCallback) ___lambda42__gtk_toggle_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 277 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _data2_->help_button, (GtkWidget*) help_icon);
#line 278 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp90_ = box;
#line 278 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _data2_->help_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	result = box;
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (help_icon);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (separator3);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (separator2);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (separator1);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (webimage_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (numbered_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (bulleted_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (link_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (code_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (quote_button);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	block2_data_unref (_data2_);
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_data2_ = NULL;
#line 280 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return result;
#line 1589 "Editor.c"
}

void
enotes_editor_save_file (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
	gboolean _tmp14_ = FALSE;
#line 283 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 284 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 284 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 284 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 284 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 284 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (_tmp3_ == NULL) {
#line 284 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		return;
#line 1614 "Editor.c"
	}
#line 286 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (self->priv->edited) {
#line 1618 "Editor.c"
		ENotesApplication* _tmp4_;
		ENotesApplicationState* _tmp5_;
		ENotesPage* _tmp6_;
		ENotesPage* _tmp7_;
		gchar* _tmp8_;
		ENotesApplication* _tmp9_;
		ENotesApplicationState* _tmp10_;
		ENotesPage* _tmp11_;
		ENotesPage* _tmp12_;
		gchar* _tmp13_;
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp4_ = enotes_app;
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp5_ = _tmp4_->state;
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp6_ = enotes_application_state_get_opened_page (_tmp5_);
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp7_ = _tmp6_;
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp8_ = enotes_editor_get_text (self);
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_g_free0 (_tmp7_->data);
#line 287 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp7_->data = _tmp8_;
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp9_ = enotes_app;
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp10_ = _tmp9_->state;
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp11_ = enotes_application_state_get_opened_page (_tmp10_);
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp12_ = _tmp11_;
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp13_ = g_strdup ("");
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_g_free0 (_tmp12_->html_cache);
#line 288 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp12_->html_cache = _tmp13_;
#line 1657 "Editor.c"
	}
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (self->priv->edited) {
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp14_ = TRUE;
#line 1663 "Editor.c"
	} else {
		ENotesApplication* _tmp15_;
		ENotesApplicationState* _tmp16_;
		ENotesPage* _tmp17_;
		ENotesPage* _tmp18_;
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp15_ = enotes_app;
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp16_ = _tmp15_->state;
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp17_ = enotes_application_state_get_opened_page (_tmp16_);
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp18_ = _tmp17_;
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp14_ = _tmp18_->cache_changed;
#line 1679 "Editor.c"
	}
#line 291 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (_tmp14_) {
#line 1683 "Editor.c"
		ENotesApplication* _tmp19_;
		ENotesApplicationState* _tmp20_;
#line 292 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp19_ = enotes_app;
#line 292 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp20_ = _tmp19_->state;
#line 292 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		enotes_application_state_save_opened_page (_tmp20_);
#line 1692 "Editor.c"
	}
#line 295 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->edited = FALSE;
#line 1696 "Editor.c"
}

void
enotes_editor_reset (ENotesEditor* self,
                     gboolean disable_save)
{
	GtkSourceBuffer* _tmp0_;
#line 298 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 299 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (disable_save) {
#line 300 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		self->priv->edited = FALSE;
#line 1710 "Editor.c"
	}
#line 303 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->code_buffer;
#line 303 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_set ((GtkTextBuffer*) _tmp0_, "text", "", NULL);
#line 1716 "Editor.c"
}

gchar*
enotes_editor_get_text (ENotesEditor* self)
{
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 306 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->code_view;
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = _tmp1_;
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = _tmp3_;
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	result = _tmp4_;
#line 307 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return result;
#line 1744 "Editor.c"
}

void
enotes_editor_give_focus (ENotesEditor* self)
{
	GtkSourceView* _tmp0_;
#line 310 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 311 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->code_view;
#line 311 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 1757 "Editor.c"
}

static void
enotes_editor_show_line_numbers (ENotesEditor* self,
                                 gboolean show)
{
	GtkSourceView* _tmp0_;
#line 314 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 315 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = self->priv->code_view;
#line 315 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_view_set_show_line_numbers (_tmp0_, show);
#line 317 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (show) {
#line 1773 "Editor.c"
		GtkSourceView* _tmp1_;
#line 318 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp1_ = self->priv->code_view;
#line 318 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_text_view_set_left_margin ((GtkTextView*) _tmp1_, 6);
#line 1779 "Editor.c"
	} else {
		GtkSourceView* _tmp2_;
#line 320 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp2_ = self->priv->code_view;
#line 320 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_text_view_set_left_margin ((GtkTextView*) _tmp2_, 12);
#line 1786 "Editor.c"
	}
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 324 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 1795 "Editor.c"
}

static void
enotes_editor_set_font (ENotesEditor* self,
                        const gchar* name)
{
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp0_;
	GtkSourceView* _tmp1_;
#line 324 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 324 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (name != NULL);
#line 325 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = pango_font_description_from_string (name);
#line 325 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	font = _tmp0_;
#line 326 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = self->priv->code_view;
#line 326 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_widget_override_font ((GtkWidget*) _tmp1_, font);
#line 324 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	__vala_PangoFontDescription_free0 (font);
#line 1819 "Editor.c"
}

static void
enotes_editor_set_scheme (ENotesEditor* self,
                          const gchar* id)
{
	GtkSourceStyleSchemeManager* style_manager = NULL;
	GtkSourceStyleSchemeManager* _tmp0_;
	GtkSourceStyleSchemeManager* _tmp1_;
	GtkSourceStyleScheme* style = NULL;
	GtkSourceStyleScheme* _tmp2_;
	GtkSourceStyleScheme* _tmp3_;
	GtkSourceBuffer* _tmp4_;
#line 329 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 329 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (id != NULL);
#line 330 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = gtk_source_style_scheme_manager_get_default ();
#line 330 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 330 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	style_manager = _tmp1_;
#line 331 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = gtk_source_style_scheme_manager_get_scheme (style_manager, id);
#line 331 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 331 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	style = _tmp3_;
#line 332 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = self->priv->code_buffer;
#line 332 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_buffer_set_style_scheme (_tmp4_, style);
#line 329 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (style);
#line 329 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (style_manager);
#line 1857 "Editor.c"
}

static gboolean
__lambda40_ (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
	gchar* _tmp4_;
	ENotesApplication* _tmp5_;
	ENotesApplicationState* _tmp6_;
	gboolean result;
#line 347 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->text_change_timeout = (guint) 0;
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp4_ = enotes_editor_get_text (self);
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_free0 (_tmp3_->data);
#line 349 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_->data = _tmp4_;
#line 350 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp5_ = enotes_app;
#line 350 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp6_ = _tmp5_->state;
#line 350 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_emit_by_name (_tmp6_, "page-text-updated");
#line 352 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	result = G_SOURCE_REMOVE;
#line 352 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return result;
#line 1897 "Editor.c"
}

static gboolean
___lambda40__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda40_ ((ENotesEditor*) self);
#line 346 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	return result;
#line 1907 "Editor.c"
}

static void
enotes_editor_trigger_changed (ENotesEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
#line 336 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 337 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp0_ = enotes_app;
#line 337 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp1_ = _tmp0_->state;
#line 337 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 337 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp3_ = _tmp2_;
#line 337 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (_tmp3_ == NULL) {
#line 337 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		return;
#line 1931 "Editor.c"
	}
#line 339 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (self->priv->text_change_timeout != ((guint) 0)) {
#line 340 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_source_remove (self->priv->text_change_timeout);
#line 341 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		self->priv->text_change_timeout = (guint) 0;
#line 1939 "Editor.c"
	}
#line 344 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->edited = TRUE;
#line 346 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->text_change_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda40__gsource_func, g_object_ref (self), g_object_unref);
#line 1945 "Editor.c"
}

static void
enotes_editor_set_current_page (ENotesEditor* self,
                                ENotesPage* value)
{
	GtkSourceBuffer* _tmp8_;
	guint _tmp9_;
	GtkSourceBuffer* _tmp10_;
	GtkSourceBuffer* _tmp11_;
	const gchar* _tmp12_;
	GtkSourceBuffer* _tmp13_;
	GtkSourceBuffer* _tmp14_;
#line 35 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 36 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (self->priv->text_change_timeout != ((guint) 0)) {
#line 37 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_source_remove (self->priv->text_change_timeout);
#line 38 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		self->priv->text_change_timeout = (guint) 0;
#line 1967 "Editor.c"
	}
#line 41 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (value == NULL) {
#line 1971 "Editor.c"
		GtkSourceBuffer* _tmp0_;
		guint _tmp1_;
		GtkSourceBuffer* _tmp2_;
		GtkSourceBuffer* _tmp3_;
		GtkSourceBuffer* _tmp4_;
		GtkSourceBuffer* _tmp5_;
#line 42 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
#line 43 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp0_ = self->priv->code_buffer;
#line 43 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_signal_parse_name ("changed", gtk_text_buffer_get_type (), &_tmp1_, NULL, FALSE);
#line 43 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _enotes_editor_trigger_changed_gtk_text_buffer_changed, self);
#line 44 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp2_ = self->priv->code_buffer;
#line 44 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_source_buffer_begin_not_undoable_action (_tmp2_);
#line 45 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp3_ = self->priv->code_buffer;
#line 45 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_object_set ((GtkTextBuffer*) _tmp3_, "text", "", NULL);
#line 46 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		self->priv->edited = FALSE;
#line 47 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp4_ = self->priv->code_buffer;
#line 47 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_source_buffer_end_not_undoable_action (_tmp4_);
#line 48 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp5_ = self->priv->code_buffer;
#line 48 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		g_signal_connect_object ((GtkTextBuffer*) _tmp5_, "changed", (GCallback) _enotes_editor_trigger_changed_gtk_text_buffer_changed, self, 0);
#line 49 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		return;
#line 2006 "Editor.c"
	} else {
		ENotesTrash* _tmp6_;
		ENotesTrash* _tmp7_;
#line 51 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp6_ = enotes_trash_get_instance ();
#line 51 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp7_ = _tmp6_;
#line 51 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_widget_set_sensitive ((GtkWidget*) self, !enotes_trash_is_page_trashed (_tmp7_, value));
#line 51 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_g_object_unref0 (_tmp7_);
#line 2018 "Editor.c"
	}
#line 54 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp8_ = self->priv->code_buffer;
#line 54 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_parse_name ("changed", gtk_text_buffer_get_type (), &_tmp9_, NULL, FALSE);
#line 54 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _enotes_editor_trigger_changed_gtk_text_buffer_changed, self);
#line 55 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp10_ = self->priv->code_buffer;
#line 55 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_buffer_begin_not_undoable_action (_tmp10_);
#line 56 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp11_ = self->priv->code_buffer;
#line 56 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp12_ = value->data;
#line 56 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_set ((GtkTextBuffer*) _tmp11_, "text", _tmp12_, NULL);
#line 57 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->edited = FALSE;
#line 58 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp13_ = self->priv->code_buffer;
#line 58 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	gtk_source_buffer_end_not_undoable_action (_tmp13_);
#line 59 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_tmp14_ = self->priv->code_buffer;
#line 59 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_signal_connect_object ((GtkTextBuffer*) _tmp14_, "changed", (GCallback) _enotes_editor_trigger_changed_gtk_text_buffer_changed, self, 0);
#line 2046 "Editor.c"
}

static void
_g_free0_ (gpointer var)
{
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	var = (g_free (var), NULL);
#line 2054 "Editor.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 2062 "Editor.c"
}

void
enotes_editor_set_spellcheck (ENotesEditor* self,
                              gboolean value)
{
	GError* _inner_error0_ = NULL;
#line 64 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_return_if_fail (self != NULL);
#line 65 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	if (value) {
#line 2074 "Editor.c"
		{
			gchar* last_language = NULL;
			ENotesServicesSettings* _tmp0_;
			ENotesServicesSettings* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GList* language_list = NULL;
			GList* _tmp6_;
			gboolean language_set = FALSE;
			GList* _tmp7_;
			GList* _tmp13_;
			GtkSpellChecker* _tmp21_;
			GtkSourceView* _tmp22_;
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp0_ = enotes_services_settings_get_instance ();
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp1_ = _tmp0_;
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp2_ = enotes_services_settings_get_spellcheck_language (_tmp1_);
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp3_ = _tmp2_;
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp5_ = _tmp4_;
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_g_object_unref0 (_tmp1_);
#line 67 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			last_language = _tmp5_;
#line 68 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp6_ = gtk_spell_checker_get_language_list ();
#line 68 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			language_list = _tmp6_;
#line 70 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			language_set = FALSE;
#line 71 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp7_ = language_list;
#line 2114 "Editor.c"
			{
				GList* element_collection = NULL;
				GList* element_it = NULL;
#line 71 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				element_collection = _tmp7_;
#line 71 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
#line 2122 "Editor.c"
					gchar* _tmp8_;
					gchar* element = NULL;
#line 71 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp8_ = g_strdup ((const gchar*) element_it->data);
#line 71 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					element = _tmp8_;
#line 2129 "Editor.c"
					{
						const gchar* _tmp9_;
						const gchar* _tmp10_;
#line 72 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
						_tmp9_ = last_language;
#line 72 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
						_tmp10_ = element;
#line 72 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
						if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
#line 2139 "Editor.c"
							GtkSpellChecker* _tmp11_;
							const gchar* _tmp12_;
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							_tmp11_ = self->priv->spell;
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							_tmp12_ = last_language;
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							gtk_spell_checker_set_language (_tmp11_, _tmp12_, &_inner_error0_);
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
								_g_free0 (element);
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
								(language_list == NULL) ? NULL : (language_list = (_g_list_free__g_free0_ (language_list), NULL));
#line 73 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
								_g_free0 (last_language);
#line 2156 "Editor.c"
								goto __catch0_g_error;
							}
#line 74 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							language_set = TRUE;
#line 75 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							_g_free0 (element);
#line 75 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
							break;
#line 2165 "Editor.c"
						}
#line 71 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
						_g_free0 (element);
#line 2169 "Editor.c"
					}
				}
			}
#line 79 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp13_ = language_list;
#line 79 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			if (g_list_length (_tmp13_) == ((guint) 0)) {
#line 2177 "Editor.c"
				GtkSpellChecker* _tmp14_;
#line 80 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				_tmp14_ = self->priv->spell;
#line 80 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				gtk_spell_checker_set_language (_tmp14_, NULL, &_inner_error0_);
#line 80 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					(language_list == NULL) ? NULL : (language_list = (_g_list_free__g_free0_ (language_list), NULL));
#line 80 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_g_free0 (last_language);
#line 2189 "Editor.c"
					goto __catch0_g_error;
				}
			} else {
#line 81 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
				if (!language_set) {
#line 2195 "Editor.c"
					GList* _tmp15_;
					GList* _tmp16_;
					gconstpointer _tmp17_;
					gchar* _tmp18_;
					GtkSpellChecker* _tmp19_;
					const gchar* _tmp20_;
#line 82 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp15_ = language_list;
#line 82 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp16_ = g_list_first (_tmp15_);
#line 82 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp17_ = _tmp16_->data;
#line 82 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp18_ = g_strdup ((const gchar*) _tmp17_);
#line 82 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_g_free0 (last_language);
#line 82 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					last_language = _tmp18_;
#line 83 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp19_ = self->priv->spell;
#line 83 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					_tmp20_ = last_language;
#line 83 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					gtk_spell_checker_set_language (_tmp19_, _tmp20_, &_inner_error0_);
#line 83 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 83 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
						(language_list == NULL) ? NULL : (language_list = (_g_list_free__g_free0_ (language_list), NULL));
#line 83 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
						_g_free0 (last_language);
#line 2226 "Editor.c"
						goto __catch0_g_error;
					}
				}
			}
#line 85 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp21_ = self->priv->spell;
#line 85 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp22_ = self->priv->code_view;
#line 85 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			gtk_spell_checker_attach (_tmp21_, (GtkTextView*) _tmp22_);
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			(language_list == NULL) ? NULL : (language_list = (_g_list_free__g_free0_ (language_list), NULL));
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_g_free0 (last_language);
#line 2241 "Editor.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			e = _inner_error0_;
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_inner_error0_ = NULL;
#line 87 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp23_ = e;
#line 87 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_tmp24_ = _tmp23_->message;
#line 87 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			g_warning ("Editor.vala:87: %s", _tmp24_);
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			_g_error_free0 (e);
#line 2261 "Editor.c"
		}
		__finally0:
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			g_clear_error (&_inner_error0_);
#line 66 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
			return;
#line 2272 "Editor.c"
		}
	} else {
		GtkSpellChecker* _tmp25_;
#line 90 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		_tmp25_ = self->priv->spell;
#line 90 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		gtk_spell_checker_detach (_tmp25_);
#line 2280 "Editor.c"
	}
#line 64 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_notify_by_pspec ((GObject *) self, enotes_editor_properties[ENOTES_EDITOR_SPELLCHECK_PROPERTY]);
#line 2284 "Editor.c"
}

static void
enotes_editor_class_init (ENotesEditorClass * klass,
                          gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	enotes_editor_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_type_class_adjust_private_offset (klass, &ENotesEditor_private_offset);
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_enotes_editor_set_property;
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_editor_finalize;
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_EDITOR_SPELLCHECK_PROPERTY, enotes_editor_properties[ENOTES_EDITOR_SPELLCHECK_PROPERTY] = g_param_spec_boolean ("spellcheck", "spellcheck", "spellcheck", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
#line 2301 "Editor.c"
}

static void
enotes_editor_instance_init (ENotesEditor * self,
                             gpointer klass)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv = enotes_editor_get_instance_private (self);
#line 26 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->help = NULL;
#line 27 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->spell = NULL;
#line 29 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->edited = FALSE;
#line 335 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self->priv->text_change_timeout = (guint) 0;
#line 2318 "Editor.c"
}

static void
enotes_editor_finalize (GObject * obj)
{
	ENotesEditor * self;
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_EDITOR, ENotesEditor);
#line 23 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->code_view);
#line 24 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->code_buffer);
#line 25 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->editor_and_help);
#line 26 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->help);
#line 27 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->spell);
#line 31 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->search_context);
#line 32 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->priv->search_settings);
#line 95 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->bold_button);
#line 96 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->italics_button);
#line 97 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	_g_object_unref0 (self->strike_button);
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	G_OBJECT_CLASS (enotes_editor_parent_class)->finalize (obj);
#line 2349 "Editor.c"
}

static GType
enotes_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesEditor), 0, (GInstanceInitFunc) enotes_editor_instance_init, NULL };
	GType enotes_editor_type_id;
	enotes_editor_type_id = g_type_register_static (gtk_box_get_type (), "ENotesEditor", &g_define_type_info, 0);
	ENotesEditor_private_offset = g_type_add_instance_private (enotes_editor_type_id, sizeof (ENotesEditorPrivate));
	return enotes_editor_type_id;
}

GType
enotes_editor_get_type (void)
{
	static volatile gsize enotes_editor_type_id__once = 0;
	if (g_once_init_enter (&enotes_editor_type_id__once)) {
		GType enotes_editor_type_id;
		enotes_editor_type_id = enotes_editor_get_type_once ();
		g_once_init_leave (&enotes_editor_type_id__once, enotes_editor_type_id);
	}
	return enotes_editor_type_id__once;
}

static void
_vala_enotes_editor_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	ENotesEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ENOTES_TYPE_EDITOR, ENotesEditor);
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
	switch (property_id) {
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		case ENOTES_EDITOR_SPELLCHECK_PROPERTY:
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		enotes_editor_set_spellcheck (self, g_value_get_boolean (value));
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		break;
#line 2390 "Editor.c"
		default:
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Notes-up-2.0.6/src/Widgets/Editor.vala"
		break;
#line 2396 "Editor.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

