// SPDX-FileCopyrightText: Nheko Contributors
//
// SPDX-License-Identifier: GPL-3.0-or-later

#pragma once

#include <string>

#include <QDateTime>
#include <QString>

#include <mtx/common.hpp>
#include <mtx/events.hpp>

namespace mtx::events::collections {
struct TimelineEvents;
struct StateEvents;
}

namespace mtx::accessors {
const std::string &
event_id(const mtx::events::collections::TimelineEvents &event);

const std::string &
room_id(const mtx::events::collections::TimelineEvents &event);

const std::string &
sender(const mtx::events::collections::TimelineEvents &event);

bool
is_state_event(const mtx::events::collections::StateEvents &event);
bool
is_state_event(const mtx::events::collections::TimelineEvents &event);

QDateTime
origin_server_ts(const mtx::events::collections::TimelineEvents &event);

std::uint64_t
origin_server_ts_ms(const mtx::events::collections::TimelineEvents &event);

std::string
filename(const mtx::events::collections::TimelineEvents &event);

mtx::events::EventType
event_type(const mtx::events::collections::TimelineEvents &event);
mtx::events::MessageType
msg_type(const mtx::events::collections::TimelineEvents &event);
bool
is_message(const mtx::events::collections::TimelineEvents &event);
std::string
room_name(const mtx::events::collections::TimelineEvents &event);
std::string
room_topic(const mtx::events::collections::TimelineEvents &event);

std::string
call_type(const mtx::events::collections::TimelineEvents &event);

std::string
body(const mtx::events::collections::TimelineEvents &event);

std::string
formatted_body(const mtx::events::collections::TimelineEvents &event);

QString
formattedBodyWithFallback(const mtx::events::collections::TimelineEvents &event);

std::optional<mtx::crypto::EncryptedFile>
file(const mtx::events::collections::TimelineEvents &event);
std::optional<mtx::crypto::EncryptedFile>
thumbnail_file(const mtx::events::collections::TimelineEvents &event);

std::string
url(const mtx::events::collections::TimelineEvents &event);
std::string
thumbnail_url(const mtx::events::collections::TimelineEvents &event);
uint64_t
duration(const mtx::events::collections::TimelineEvents &event);
std::string
blurhash(const mtx::events::collections::TimelineEvents &event);
std::string
mimetype(const mtx::events::collections::TimelineEvents &event);
const mtx::common::Relations &
relations(const mtx::events::collections::TimelineEvents &event);
std::optional<mtx::common::Mentions>
mentions(const mtx::events::collections::TimelineEvents &event);
void
set_relations(mtx::events::collections::TimelineEvents &event, mtx::common::Relations relations);
std::string
transaction_id(const mtx::events::collections::TimelineEvents &event);

int64_t
filesize(const mtx::events::collections::TimelineEvents &event);

uint64_t
media_height(const mtx::events::collections::TimelineEvents &event);

uint64_t
media_width(const mtx::events::collections::TimelineEvents &event);

nlohmann::json
serialize_event(const mtx::events::collections::TimelineEvents &event);
}
