use crate::sidebar::FeedListItemID;
use glib::Boxed;
use news_flash::models::CategoryID;
use serde::{Deserialize, Serialize};
use std::fmt::{self, Display};

#[derive(Clone, Debug, Eq, Boxed, Serialize, Deserialize)]
#[boxed_type(name = "GFeedListItemID")]
pub struct GFeedListItemID(FeedListItemID);

impl Default for GFeedListItemID {
    fn default() -> Self {
        Self(FeedListItemID::Category(CategoryID::new("")))
    }
}

impl From<FeedListItemID> for GFeedListItemID {
    fn from(id: FeedListItemID) -> Self {
        Self(id)
    }
}

impl From<GFeedListItemID> for FeedListItemID {
    fn from(id: GFeedListItemID) -> Self {
        id.0
    }
}

impl AsRef<FeedListItemID> for GFeedListItemID {
    fn as_ref(&self) -> &FeedListItemID {
        &self.0
    }
}

impl PartialEq for GFeedListItemID {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}

impl Display for GFeedListItemID {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl GFeedListItemID {
    pub fn is_category(&self) -> bool {
        self.0.is_category()
    }

    pub fn is_feed(&self) -> bool {
        self.0.is_feed()
    }
}
