// Code generated by ndpgen. DO NOT EDIT.

package host

import (
	"context"
	"encoding/json"

	extism "github.com/extism/go-sdk"
)

// ConfigGetRequest is the request type for Config.Get.
type ConfigGetRequest struct {
	Key string `json:"key"`
}

// ConfigGetResponse is the response type for Config.Get.
type ConfigGetResponse struct {
	Value  string `json:"value,omitempty"`
	Exists bool   `json:"exists,omitempty"`
}

// ConfigGetIntRequest is the request type for Config.GetInt.
type ConfigGetIntRequest struct {
	Key string `json:"key"`
}

// ConfigGetIntResponse is the response type for Config.GetInt.
type ConfigGetIntResponse struct {
	Value  int64 `json:"value,omitempty"`
	Exists bool  `json:"exists,omitempty"`
}

// ConfigKeysRequest is the request type for Config.Keys.
type ConfigKeysRequest struct {
	Prefix string `json:"prefix"`
}

// ConfigKeysResponse is the response type for Config.Keys.
type ConfigKeysResponse struct {
	Keys []string `json:"keys,omitempty"`
}

// RegisterConfigHostFunctions registers Config service host functions.
// The returned host functions should be added to the plugin's configuration.
func RegisterConfigHostFunctions(service ConfigService) []extism.HostFunction {
	return []extism.HostFunction{
		newConfigGetHostFunction(service),
		newConfigGetIntHostFunction(service),
		newConfigKeysHostFunction(service),
	}
}

func newConfigGetHostFunction(service ConfigService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"config_get",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				configWriteError(p, stack, err)
				return
			}
			var req ConfigGetRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				configWriteError(p, stack, err)
				return
			}

			// Call the service method
			value, exists := service.Get(ctx, req.Key)

			// Write JSON response to plugin memory
			resp := ConfigGetResponse{
				Value:  value,
				Exists: exists,
			}
			configWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newConfigGetIntHostFunction(service ConfigService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"config_getint",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				configWriteError(p, stack, err)
				return
			}
			var req ConfigGetIntRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				configWriteError(p, stack, err)
				return
			}

			// Call the service method
			value, exists := service.GetInt(ctx, req.Key)

			// Write JSON response to plugin memory
			resp := ConfigGetIntResponse{
				Value:  value,
				Exists: exists,
			}
			configWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newConfigKeysHostFunction(service ConfigService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"config_keys",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				configWriteError(p, stack, err)
				return
			}
			var req ConfigKeysRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				configWriteError(p, stack, err)
				return
			}

			// Call the service method
			keys := service.Keys(ctx, req.Prefix)

			// Write JSON response to plugin memory
			resp := ConfigKeysResponse{
				Keys: keys,
			}
			configWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

// configWriteResponse writes a JSON response to plugin memory.
func configWriteResponse(p *extism.CurrentPlugin, stack []uint64, resp any) {
	respBytes, err := json.Marshal(resp)
	if err != nil {
		configWriteError(p, stack, err)
		return
	}
	respPtr, err := p.WriteBytes(respBytes)
	if err != nil {
		stack[0] = 0
		return
	}
	stack[0] = respPtr
}

// configWriteError writes an error response to plugin memory.
func configWriteError(p *extism.CurrentPlugin, stack []uint64, err error) {
	errResp := struct {
		Error string `json:"error"`
	}{Error: err.Error()}
	respBytes, _ := json.Marshal(errResp)
	respPtr, _ := p.WriteBytes(respBytes)
	stack[0] = respPtr
}
