/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/DataRefactoring/SingleDimension/Coefficient/CalcCoefficients.hpp"
// clang-format off
namespace mgard_x {

namespace data_refactoring {

namespace single_dimension {

template void CalcCoefficients<2, double, OPENMP>(
    DIM current_dim, SubArray<1, double, OPENMP> ratio,
    SubArray<2, double, OPENMP> v,
    SubArray<2, double, OPENMP> coarse,
    SubArray<2, double, OPENMP> coeff, int queue_idx);

} // namespace single_dimension

} // namespace data_refactoring

} // namespace mgard_x
// clang-format on
