
#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"
#include "ptimec_spec.hh"

// @%@
bool ptime_f1(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f1");
    if (len - off_inout < 1) {
        return false;
    }
    PTIME_CHECK_CHAR('@', str[off_inout + 0]);
    off_inout += 1;
    if (!ptime_at(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S.%f%z
bool ptime_f2(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f2");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S,%f%z
bool ptime_f3(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f3");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S.%f %Z
bool ptime_f4(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f4");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S,%f %Z
bool ptime_f5(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f5");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S,%L%z
bool ptime_f6(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f6");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S,%L %z
bool ptime_f7(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f7");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S.%L%z
bool ptime_f8(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f8");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S.%L %z
bool ptime_f9(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f9");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S.%L %Z
bool ptime_f10(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f10");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S:%L %z
bool ptime_f11(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f11");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S,%L
bool ptime_f12(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f12");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S.%L
bool ptime_f13(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f13");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S%z
bool ptime_f14(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f14");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S %Z
bool ptime_f15(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f15");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S %z
bool ptime_f16(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f16");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S:%L
bool ptime_f17(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f17");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M:%S
bool ptime_f18(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f18");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d %H:%M
bool ptime_f19(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f19");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%jT%H:%M:%S %p %Z
bool ptime_f20(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f20");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_j(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S %p %Z
bool ptime_f21(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f21");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%jT%H:%M:%S.%f%z
bool ptime_f22(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f22");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_j(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S.%f%z
bool ptime_f23(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f23");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %y-%m-%dT%H:%M:%S.%f%z
bool ptime_f24(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f24");
    off_inout += 0;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%jT%H:%M:%S.%L%z
bool ptime_f25(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f25");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_j(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S.%L%z
bool ptime_f26(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f26");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %y-%m-%dT%H:%M:%S.%L%z
bool ptime_f27(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f27");
    off_inout += 0;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%jT%H:%M:%S,%L%z
bool ptime_f28(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f28");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_j(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S,%L%z
bool ptime_f29(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f29");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %y-%m-%dT%H:%M:%S,%L%z
bool ptime_f30(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f30");
    off_inout += 0;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%jT%H:%M:%S.%L%Z
bool ptime_f31(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f31");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_j(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S.%L%Z
bool ptime_f32(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f32");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %y-%m-%dT%H:%M:%S.%L%Z
bool ptime_f33(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f33");
    off_inout += 0;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S%z
bool ptime_f34(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f34");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S%z
bool ptime_f35(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f35");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%jT%H:%M:%S
bool ptime_f36(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f36");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_j(dst, str, off_inout, len)) return false;
    if (!ptime_char('T', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M:%S
bool ptime_f37(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f37");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%dT%H:%M
bool ptime_f38(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f38");
    if (len - off_inout < 5) {
        return false;
    }
    if (!ptime_YmdTHM(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S %z
bool ptime_f39(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f39");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S%z
bool ptime_f40(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f40");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S.%f%z
bool ptime_f41(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f41");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S.%f%Z
bool ptime_f42(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f42");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S.%f %z
bool ptime_f43(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f43");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S.%f %Z
bool ptime_f44(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f44");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S.%f
bool ptime_f45(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f45");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S.%L
bool ptime_f46(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f46");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M:%S
bool ptime_f47(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f47");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d %H:%M
bool ptime_f48(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f48");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    return true;
}

// %Y %b %d %a %H:%M:%S.%L
bool ptime_f49(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f49");
    if (len - off_inout < 12) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 4]);
    PTIME_CHECK_b(dst, str, off_inout + 5);
    PTIME_CHECK_CHAR(' ', str[off_inout + 8]);
    PTIME_CHECK_d(dst, str, off_inout + 9);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    off_inout += 12;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %Y %b %d %H:%M:%S.%L
bool ptime_f50(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f50");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 4]);
    PTIME_CHECK_b(dst, str, off_inout + 5);
    PTIME_CHECK_CHAR(' ', str[off_inout + 8]);
    PTIME_CHECK_d(dst, str, off_inout + 9);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR('.', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %Y %b %d %H:%M:%S
bool ptime_f51(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f51");
    if (len - off_inout < 20) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 4]);
    PTIME_CHECK_b(dst, str, off_inout + 5);
    PTIME_CHECK_CHAR(' ', str[off_inout + 8]);
    PTIME_CHECK_d(dst, str, off_inout + 9);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    off_inout += 20;
    return true;
}

// %a %b %e %H:%M:%S %Y
bool ptime_f52(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f52");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M:%S.%f %Y
bool ptime_f53(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f53");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M:%S:%f %Y
bool ptime_f54(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f54");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M:%S %Z %Y
bool ptime_f55(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f55");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto(dst, str, off_inout, len, ' ')) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    return true;
}

// %a %b %e %I:%M:%S %p %Z %Y
bool ptime_f56(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f56");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_I(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto(dst, str, off_inout, len, ' ')) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M:%S 
bool ptime_f57(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f57");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M:%S.%L 
bool ptime_f58(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f58");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M 
bool ptime_f59(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f59");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    return true;
}

// %a %b %e %H:%M:%S %Z %Y
bool ptime_f60(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f60");
    off_inout += 0;
    if (!ptime_upto(' ', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_b(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto(dst, str, off_inout, len, ' ')) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    return true;
}

// %d/%m/%y %H:%M:%S
bool ptime_f61(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f61");
    if (len - off_inout < 3) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 2]);
    off_inout += 3;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %d/%b/%Y:%H:%M:%S %z
bool ptime_f62(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f62");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR('/', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(':', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR(' ', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %d-%b-%Y %H:%M:%S %z
bool ptime_f63(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f63");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR('-', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR(' ', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %d-%b-%Y %H:%M:%S %Z
bool ptime_f64(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f64");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR('-', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR(' ', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %d %b %Y %H:%M:%S
bool ptime_f65(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f65");
    if (len - off_inout < 20) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    off_inout += 20;
    return true;
}

// %d %b %Y %H:%M:%S.%L%z
bool ptime_f66(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f66");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR('.', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %d %b %Y %H:%M:%S,%L%z
bool ptime_f67(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f67");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR(',', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %d %b %Y %H:%M:%S.%L
bool ptime_f68(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f68");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR('.', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %d %b %Y %H:%M:%S,%L
bool ptime_f69(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f69");
    if (len - off_inout < 21) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    PTIME_CHECK_CHAR(',', str[off_inout + 20]);
    off_inout += 21;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    return true;
}

// %d %b %Y %H:%M
bool ptime_f70(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f70");
    if (len - off_inout < 17) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    off_inout += 17;
    return true;
}

// %b-%d %H:%M:%S
bool ptime_f71(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f71");
    if (len - off_inout < 15) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 3]);
    PTIME_CHECK_d(dst, str, off_inout + 4);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_H(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(':', str[off_inout + 9]);
    PTIME_CHECK_M(dst, str, off_inout + 10);
    PTIME_CHECK_CHAR(':', str[off_inout + 12]);
    PTIME_CHECK_S(dst, str, off_inout + 13);
    off_inout += 15;
    return true;
}

// %b %d %H:%M:%S
bool ptime_f72(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f72");
    if (len - off_inout < 15) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 3]);
    PTIME_CHECK_d(dst, str, off_inout + 4);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    PTIME_CHECK_H(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(':', str[off_inout + 9]);
    PTIME_CHECK_M(dst, str, off_inout + 10);
    PTIME_CHECK_CHAR(':', str[off_inout + 12]);
    PTIME_CHECK_S(dst, str, off_inout + 13);
    off_inout += 15;
    return true;
}

// %b %d %k:%M:%S
bool ptime_f73(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f73");
    if (len - off_inout < 7) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 3]);
    PTIME_CHECK_d(dst, str, off_inout + 4);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    off_inout += 7;
    if (!ptime_k(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %b %d %l:%M:%S
bool ptime_f74(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f74");
    if (len - off_inout < 7) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 3]);
    PTIME_CHECK_d(dst, str, off_inout + 4);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    off_inout += 7;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %b %d %l:%M
bool ptime_f75(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f75");
    if (len - off_inout < 7) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 3]);
    PTIME_CHECK_d(dst, str, off_inout + 4);
    PTIME_CHECK_CHAR(' ', str[off_inout + 6]);
    off_inout += 7;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    return true;
}

// %b %e, %Y %l:%M:%S %p
bool ptime_f76(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f76");
    if (len - off_inout < 4) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 3]);
    off_inout += 4;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char(',', str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    return true;
}

// %b %d, %Y %l:%M:%S %p
bool ptime_f77(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f77");
    if (len - off_inout < 13) {
        return false;
    }
    PTIME_CHECK_b(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(' ', str[off_inout + 3]);
    PTIME_CHECK_d(dst, str, off_inout + 4);
    PTIME_CHECK_CHAR(',', str[off_inout + 6]);
    PTIME_CHECK_CHAR(' ', str[off_inout + 7]);
    PTIME_CHECK_Y(dst, str, off_inout + 8);
    PTIME_CHECK_CHAR(' ', str[off_inout + 12]);
    off_inout += 13;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%Y %I:%M:%S:%L %p %Z
bool ptime_f78(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f78");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_I(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_L(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%Y %I:%M:%S %p %Z
bool ptime_f79(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f79");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_I(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%Y %l:%M:%S %p %Z
bool ptime_f80(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f80");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_Z_upto_end(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%Y %I:%M:%S %p%z
bool ptime_f81(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f81");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_I(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%Y %l:%M:%S %p%z
bool ptime_f82(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f82");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%e/%Y %l:%M:%S %p%z
bool ptime_f83(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f83");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%e/%Y %l:%M:%S %p %z
bool ptime_f84(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f84");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_z(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%e/%Y %I:%M:%S %p
bool ptime_f85(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f85");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_I(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%e/%Y %l:%M:%S%p
bool ptime_f86(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f86");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_e(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_l(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    if (!ptime_p(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%y %H:%M:%S
bool ptime_f87(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f87");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %m/%d/%Y %H:%M:%S
bool ptime_f88(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f88");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_Y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %d/%b/%Y %H:%M:%S
bool ptime_f89(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f89");
    if (len - off_inout < 20) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR('/', str[off_inout + 6]);
    PTIME_CHECK_Y(dst, str, off_inout + 7);
    PTIME_CHECK_CHAR(' ', str[off_inout + 11]);
    PTIME_CHECK_H(dst, str, off_inout + 12);
    PTIME_CHECK_CHAR(':', str[off_inout + 14]);
    PTIME_CHECK_M(dst, str, off_inout + 15);
    PTIME_CHECK_CHAR(':', str[off_inout + 17]);
    PTIME_CHECK_S(dst, str, off_inout + 18);
    off_inout += 20;
    return true;
}

// %d/%b/%y %H:%M:%S
bool ptime_f90(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f90");
    if (len - off_inout < 7) {
        return false;
    }
    PTIME_CHECK_d(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 2]);
    PTIME_CHECK_b(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR('/', str[off_inout + 6]);
    off_inout += 7;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %m.%d %H:%M:%S
bool ptime_f91(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f91");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %m%d %H:%M:%S
bool ptime_f92(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f92");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y%m%d %H:%M:%S
bool ptime_f93(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f93");
    if (len - off_inout < 4) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    off_inout += 4;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %y%m%d %H%M%S
bool ptime_f94(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f94");
    off_inout += 0;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %y%m%d %H:%M:%S
bool ptime_f95(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f95");
    off_inout += 0;
    if (!ptime_y(dst, str, off_inout, len)) return false;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y%m%d %H%M%S
bool ptime_f96(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f96");
    if (len - off_inout < 4) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    off_inout += 4;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y%m%d.%H%M%S
bool ptime_f97(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f97");
    if (len - off_inout < 4) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    off_inout += 4;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char('.', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %H:%M:%S
bool ptime_f98(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f98");
    if (len - off_inout < 8) {
        return false;
    }
    PTIME_CHECK_H(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(':', str[off_inout + 2]);
    PTIME_CHECK_M(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(':', str[off_inout + 5]);
    PTIME_CHECK_S(dst, str, off_inout + 6);
    off_inout += 8;
    return true;
}

// %H:%M:%S.%f
bool ptime_f99(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f99");
    if (len - off_inout < 9) {
        return false;
    }
    PTIME_CHECK_H(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(':', str[off_inout + 2]);
    PTIME_CHECK_M(dst, str, off_inout + 3);
    PTIME_CHECK_CHAR(':', str[off_inout + 5]);
    PTIME_CHECK_S(dst, str, off_inout + 6);
    PTIME_CHECK_CHAR('.', str[off_inout + 8]);
    off_inout += 9;
    if (!ptime_f(dst, str, off_inout, len)) return false;
    return true;
}

// %M:%S
bool ptime_f100(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f100");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_M(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR(':', str[off_inout + 2]);
    PTIME_CHECK_S(dst, str, off_inout + 3);
    off_inout += 5;
    return true;
}

// %m/%d %H:%M:%S
bool ptime_f101(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f101");
    off_inout += 0;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    if (!ptime_char(' ', str, off_inout, len)) return false;
    if (!ptime_H(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_M(dst, str, off_inout, len)) return false;
    if (!ptime_char(':', str, off_inout, len)) return false;
    if (!ptime_S(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m-%d
bool ptime_f102(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f102");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('-', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    return true;
}

// %Y-%m
bool ptime_f103(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f103");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('-', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m/%d
bool ptime_f104(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f104");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    if (!ptime_char('/', str, off_inout, len)) return false;
    if (!ptime_d(dst, str, off_inout, len)) return false;
    return true;
}

// %Y/%m
bool ptime_f105(struct exttm *dst, const char *str, off_t &off_inout, ssize_t len) {
    dst->et_flags = 0;
    // log_debug("ptime_f105");
    if (len - off_inout < 5) {
        return false;
    }
    PTIME_CHECK_Y(dst, str, off_inout + 0);
    PTIME_CHECK_CHAR('/', str[off_inout + 4]);
    off_inout += 5;
    if (!ptime_m(dst, str, off_inout, len)) return false;
    return true;
}

void ftime_f1(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_char(dst, off_inout, len, '@');
    ftime_at(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f2(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f3(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f4(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f5(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f6(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f7(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f8(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f9(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f10(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f11(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f12(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f13(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f14(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f15(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f16(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f17(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f18(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f19(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f20(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_j(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f21(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f22(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_j(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f23(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f24(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f25(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_j(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f26(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f27(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f28(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_j(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f29(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f30(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f31(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_j(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f32(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f33(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f34(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f35(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f36(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_j(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f37(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f38(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f39(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f40(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f41(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f42(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f43(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f44(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f45(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f46(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f47(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f48(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f49(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f50(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f51(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f52(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f53(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f54(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f55(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f56(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f57(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    dst[off_inout] = '\0';
}

void ftime_f58(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    dst[off_inout] = '\0';
}

void ftime_f59(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    dst[off_inout] = '\0';
}

void ftime_f60(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f61(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f62(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f63(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f64(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f65(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f66(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f67(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f68(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f69(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f70(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f71(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f72(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f73(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_k(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f74(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f75(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f76(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f77(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f78(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f79(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f80(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f81(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f82(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f83(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f84(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f85(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f86(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f87(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f88(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f89(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f90(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f91(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f92(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f93(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f94(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_M(dst, off_inout, len, tm);
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f95(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f96(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_M(dst, off_inout, len, tm);
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f97(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_H(dst, off_inout, len, tm);
    ftime_M(dst, off_inout, len, tm);
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f98(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f99(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f100(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f101(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f102(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f103(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f104(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f105(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

struct ptime_fmt PTIMEC_FORMATS[] = {
    { "@%@", ptime_f1, ftime_f1 },
    { "%Y-%m-%d %H:%M:%S.%f%z", ptime_f2, ftime_f2 },
    { "%Y-%m-%d %H:%M:%S,%f%z", ptime_f3, ftime_f3 },
    { "%Y-%m-%d %H:%M:%S.%f %Z", ptime_f4, ftime_f4 },
    { "%Y-%m-%d %H:%M:%S,%f %Z", ptime_f5, ftime_f5 },
    { "%Y-%m-%d %H:%M:%S,%L%z", ptime_f6, ftime_f6 },
    { "%Y-%m-%d %H:%M:%S,%L %z", ptime_f7, ftime_f7 },
    { "%Y-%m-%d %H:%M:%S.%L%z", ptime_f8, ftime_f8 },
    { "%Y-%m-%d %H:%M:%S.%L %z", ptime_f9, ftime_f9 },
    { "%Y-%m-%d %H:%M:%S.%L %Z", ptime_f10, ftime_f10 },
    { "%Y-%m-%d %H:%M:%S:%L %z", ptime_f11, ftime_f11 },
    { "%Y-%m-%d %H:%M:%S,%L", ptime_f12, ftime_f12 },
    { "%Y-%m-%d %H:%M:%S.%L", ptime_f13, ftime_f13 },
    { "%Y-%m-%d %H:%M:%S%z", ptime_f14, ftime_f14 },
    { "%Y-%m-%d %H:%M:%S %Z", ptime_f15, ftime_f15 },
    { "%Y-%m-%d %H:%M:%S %z", ptime_f16, ftime_f16 },
    { "%Y-%m-%d %H:%M:%S:%L", ptime_f17, ftime_f17 },
    { "%Y-%m-%d %H:%M:%S", ptime_f18, ftime_f18 },
    { "%Y-%m-%d %H:%M", ptime_f19, ftime_f19 },
    { "%Y-%jT%H:%M:%S %p %Z", ptime_f20, ftime_f20 },
    { "%Y-%m-%dT%H:%M:%S %p %Z", ptime_f21, ftime_f21 },
    { "%Y-%jT%H:%M:%S.%f%z", ptime_f22, ftime_f22 },
    { "%Y-%m-%dT%H:%M:%S.%f%z", ptime_f23, ftime_f23 },
    { "%y-%m-%dT%H:%M:%S.%f%z", ptime_f24, ftime_f24 },
    { "%Y-%jT%H:%M:%S.%L%z", ptime_f25, ftime_f25 },
    { "%Y-%m-%dT%H:%M:%S.%L%z", ptime_f26, ftime_f26 },
    { "%y-%m-%dT%H:%M:%S.%L%z", ptime_f27, ftime_f27 },
    { "%Y-%jT%H:%M:%S,%L%z", ptime_f28, ftime_f28 },
    { "%Y-%m-%dT%H:%M:%S,%L%z", ptime_f29, ftime_f29 },
    { "%y-%m-%dT%H:%M:%S,%L%z", ptime_f30, ftime_f30 },
    { "%Y-%jT%H:%M:%S.%L%Z", ptime_f31, ftime_f31 },
    { "%Y-%m-%dT%H:%M:%S.%L%Z", ptime_f32, ftime_f32 },
    { "%y-%m-%dT%H:%M:%S.%L%Z", ptime_f33, ftime_f33 },
    { "%Y-%m-%dT%H:%M:%S%z", ptime_f34, ftime_f34 },
    { "%Y-%m-%dT%H:%M:%S%z", ptime_f35, ftime_f35 },
    { "%Y-%jT%H:%M:%S", ptime_f36, ftime_f36 },
    { "%Y-%m-%dT%H:%M:%S", ptime_f37, ftime_f37 },
    { "%Y-%m-%dT%H:%M", ptime_f38, ftime_f38 },
    { "%Y/%m/%d %H:%M:%S %z", ptime_f39, ftime_f39 },
    { "%Y/%m/%d %H:%M:%S%z", ptime_f40, ftime_f40 },
    { "%Y/%m/%d %H:%M:%S.%f%z", ptime_f41, ftime_f41 },
    { "%Y/%m/%d %H:%M:%S.%f%Z", ptime_f42, ftime_f42 },
    { "%Y/%m/%d %H:%M:%S.%f %z", ptime_f43, ftime_f43 },
    { "%Y/%m/%d %H:%M:%S.%f %Z", ptime_f44, ftime_f44 },
    { "%Y/%m/%d %H:%M:%S.%f", ptime_f45, ftime_f45 },
    { "%Y/%m/%d %H:%M:%S.%L", ptime_f46, ftime_f46 },
    { "%Y/%m/%d %H:%M:%S", ptime_f47, ftime_f47 },
    { "%Y/%m/%d %H:%M", ptime_f48, ftime_f48 },
    { "%Y %b %d %a %H:%M:%S.%L", ptime_f49, ftime_f49 },
    { "%Y %b %d %H:%M:%S.%L", ptime_f50, ftime_f50 },
    { "%Y %b %d %H:%M:%S", ptime_f51, ftime_f51 },
    { "%a %b %e %H:%M:%S %Y", ptime_f52, ftime_f52 },
    { "%a %b %e %H:%M:%S.%f %Y", ptime_f53, ftime_f53 },
    { "%a %b %e %H:%M:%S:%f %Y", ptime_f54, ftime_f54 },
    { "%a %b %e %H:%M:%S %Z %Y", ptime_f55, ftime_f55 },
    { "%a %b %e %I:%M:%S %p %Z %Y", ptime_f56, ftime_f56 },
    { "%a %b %e %H:%M:%S ", ptime_f57, ftime_f57 },
    { "%a %b %e %H:%M:%S.%L ", ptime_f58, ftime_f58 },
    { "%a %b %e %H:%M ", ptime_f59, ftime_f59 },
    { "%a %b %e %H:%M:%S %Z %Y", ptime_f60, ftime_f60 },
    { "%d/%m/%y %H:%M:%S", ptime_f61, ftime_f61 },
    { "%d/%b/%Y:%H:%M:%S %z", ptime_f62, ftime_f62 },
    { "%d-%b-%Y %H:%M:%S %z", ptime_f63, ftime_f63 },
    { "%d-%b-%Y %H:%M:%S %Z", ptime_f64, ftime_f64 },
    { "%d %b %Y %H:%M:%S", ptime_f65, ftime_f65 },
    { "%d %b %Y %H:%M:%S.%L%z", ptime_f66, ftime_f66 },
    { "%d %b %Y %H:%M:%S,%L%z", ptime_f67, ftime_f67 },
    { "%d %b %Y %H:%M:%S.%L", ptime_f68, ftime_f68 },
    { "%d %b %Y %H:%M:%S,%L", ptime_f69, ftime_f69 },
    { "%d %b %Y %H:%M", ptime_f70, ftime_f70 },
    { "%b-%d %H:%M:%S", ptime_f71, ftime_f71 },
    { "%b %d %H:%M:%S", ptime_f72, ftime_f72 },
    { "%b %d %k:%M:%S", ptime_f73, ftime_f73 },
    { "%b %d %l:%M:%S", ptime_f74, ftime_f74 },
    { "%b %d %l:%M", ptime_f75, ftime_f75 },
    { "%b %e, %Y %l:%M:%S %p", ptime_f76, ftime_f76 },
    { "%b %d, %Y %l:%M:%S %p", ptime_f77, ftime_f77 },
    { "%m/%d/%Y %I:%M:%S:%L %p %Z", ptime_f78, ftime_f78 },
    { "%m/%d/%Y %I:%M:%S %p %Z", ptime_f79, ftime_f79 },
    { "%m/%d/%Y %l:%M:%S %p %Z", ptime_f80, ftime_f80 },
    { "%m/%d/%Y %I:%M:%S %p%z", ptime_f81, ftime_f81 },
    { "%m/%d/%Y %l:%M:%S %p%z", ptime_f82, ftime_f82 },
    { "%m/%e/%Y %l:%M:%S %p%z", ptime_f83, ftime_f83 },
    { "%m/%e/%Y %l:%M:%S %p %z", ptime_f84, ftime_f84 },
    { "%m/%e/%Y %I:%M:%S %p", ptime_f85, ftime_f85 },
    { "%m/%e/%Y %l:%M:%S%p", ptime_f86, ftime_f86 },
    { "%m/%d/%y %H:%M:%S", ptime_f87, ftime_f87 },
    { "%m/%d/%Y %H:%M:%S", ptime_f88, ftime_f88 },
    { "%d/%b/%Y %H:%M:%S", ptime_f89, ftime_f89 },
    { "%d/%b/%y %H:%M:%S", ptime_f90, ftime_f90 },
    { "%m.%d %H:%M:%S", ptime_f91, ftime_f91 },
    { "%m%d %H:%M:%S", ptime_f92, ftime_f92 },
    { "%Y%m%d %H:%M:%S", ptime_f93, ftime_f93 },
    { "%y%m%d %H%M%S", ptime_f94, ftime_f94 },
    { "%y%m%d %H:%M:%S", ptime_f95, ftime_f95 },
    { "%Y%m%d %H%M%S", ptime_f96, ftime_f96 },
    { "%Y%m%d.%H%M%S", ptime_f97, ftime_f97 },
    { "%H:%M:%S", ptime_f98, ftime_f98 },
    { "%H:%M:%S.%f", ptime_f99, ftime_f99 },
    { "%M:%S", ptime_f100, ftime_f100 },
    { "%m/%d %H:%M:%S", ptime_f101, ftime_f101 },
    { "%Y-%m-%d", ptime_f102, ftime_f102 },
    { "%Y-%m", ptime_f103, ftime_f103 },
    { "%Y/%m/%d", ptime_f104, ftime_f104 },
    { "%Y/%m", ptime_f105, ftime_f105 },

    { nullptr, nullptr, nullptr }
};
const char *PTIMEC_FORMAT_STR[] = {
    "@%@",
    "%Y-%m-%d %H:%M:%S.%f%z",
    "%Y-%m-%d %H:%M:%S,%f%z",
    "%Y-%m-%d %H:%M:%S.%f %Z",
    "%Y-%m-%d %H:%M:%S,%f %Z",
    "%Y-%m-%d %H:%M:%S,%L%z",
    "%Y-%m-%d %H:%M:%S,%L %z",
    "%Y-%m-%d %H:%M:%S.%L%z",
    "%Y-%m-%d %H:%M:%S.%L %z",
    "%Y-%m-%d %H:%M:%S.%L %Z",
    "%Y-%m-%d %H:%M:%S:%L %z",
    "%Y-%m-%d %H:%M:%S,%L",
    "%Y-%m-%d %H:%M:%S.%L",
    "%Y-%m-%d %H:%M:%S%z",
    "%Y-%m-%d %H:%M:%S %Z",
    "%Y-%m-%d %H:%M:%S %z",
    "%Y-%m-%d %H:%M:%S:%L",
    "%Y-%m-%d %H:%M:%S",
    "%Y-%m-%d %H:%M",
    "%Y-%jT%H:%M:%S %p %Z",
    "%Y-%m-%dT%H:%M:%S %p %Z",
    "%Y-%jT%H:%M:%S.%f%z",
    "%Y-%m-%dT%H:%M:%S.%f%z",
    "%y-%m-%dT%H:%M:%S.%f%z",
    "%Y-%jT%H:%M:%S.%L%z",
    "%Y-%m-%dT%H:%M:%S.%L%z",
    "%y-%m-%dT%H:%M:%S.%L%z",
    "%Y-%jT%H:%M:%S,%L%z",
    "%Y-%m-%dT%H:%M:%S,%L%z",
    "%y-%m-%dT%H:%M:%S,%L%z",
    "%Y-%jT%H:%M:%S.%L%Z",
    "%Y-%m-%dT%H:%M:%S.%L%Z",
    "%y-%m-%dT%H:%M:%S.%L%Z",
    "%Y-%m-%dT%H:%M:%S%z",
    "%Y-%m-%dT%H:%M:%S%z",
    "%Y-%jT%H:%M:%S",
    "%Y-%m-%dT%H:%M:%S",
    "%Y-%m-%dT%H:%M",
    "%Y/%m/%d %H:%M:%S %z",
    "%Y/%m/%d %H:%M:%S%z",
    "%Y/%m/%d %H:%M:%S.%f%z",
    "%Y/%m/%d %H:%M:%S.%f%Z",
    "%Y/%m/%d %H:%M:%S.%f %z",
    "%Y/%m/%d %H:%M:%S.%f %Z",
    "%Y/%m/%d %H:%M:%S.%f",
    "%Y/%m/%d %H:%M:%S.%L",
    "%Y/%m/%d %H:%M:%S",
    "%Y/%m/%d %H:%M",
    "%Y %b %d %a %H:%M:%S.%L",
    "%Y %b %d %H:%M:%S.%L",
    "%Y %b %d %H:%M:%S",
    "%a %b %e %H:%M:%S %Y",
    "%a %b %e %H:%M:%S.%f %Y",
    "%a %b %e %H:%M:%S:%f %Y",
    "%a %b %e %H:%M:%S %Z %Y",
    "%a %b %e %I:%M:%S %p %Z %Y",
    "%a %b %e %H:%M:%S ",
    "%a %b %e %H:%M:%S.%L ",
    "%a %b %e %H:%M ",
    "%a %b %e %H:%M:%S %Z %Y",
    "%d/%m/%y %H:%M:%S",
    "%d/%b/%Y:%H:%M:%S %z",
    "%d-%b-%Y %H:%M:%S %z",
    "%d-%b-%Y %H:%M:%S %Z",
    "%d %b %Y %H:%M:%S",
    "%d %b %Y %H:%M:%S.%L%z",
    "%d %b %Y %H:%M:%S,%L%z",
    "%d %b %Y %H:%M:%S.%L",
    "%d %b %Y %H:%M:%S,%L",
    "%d %b %Y %H:%M",
    "%b-%d %H:%M:%S",
    "%b %d %H:%M:%S",
    "%b %d %k:%M:%S",
    "%b %d %l:%M:%S",
    "%b %d %l:%M",
    "%b %e, %Y %l:%M:%S %p",
    "%b %d, %Y %l:%M:%S %p",
    "%m/%d/%Y %I:%M:%S:%L %p %Z",
    "%m/%d/%Y %I:%M:%S %p %Z",
    "%m/%d/%Y %l:%M:%S %p %Z",
    "%m/%d/%Y %I:%M:%S %p%z",
    "%m/%d/%Y %l:%M:%S %p%z",
    "%m/%e/%Y %l:%M:%S %p%z",
    "%m/%e/%Y %l:%M:%S %p %z",
    "%m/%e/%Y %I:%M:%S %p",
    "%m/%e/%Y %l:%M:%S%p",
    "%m/%d/%y %H:%M:%S",
    "%m/%d/%Y %H:%M:%S",
    "%d/%b/%Y %H:%M:%S",
    "%d/%b/%y %H:%M:%S",
    "%m.%d %H:%M:%S",
    "%m%d %H:%M:%S",
    "%Y%m%d %H:%M:%S",
    "%y%m%d %H%M%S",
    "%y%m%d %H:%M:%S",
    "%Y%m%d %H%M%S",
    "%Y%m%d.%H%M%S",
    "%H:%M:%S",
    "%H:%M:%S.%f",
    "%M:%S",
    "%m/%d %H:%M:%S",
    "%Y-%m-%d",
    "%Y-%m",
    "%Y/%m/%d",
    "%Y/%m",

    nullptr
};

size_t PTIMEC_DEFAULT_FMT_INDEX = 36;
