/* cairo-utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from cairo-utils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Marco Trevisan <marco.trevisan@canonical.com>
 *          Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
 */

#include <cairo-gobject.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#define CAIRO_UTILS_EXPONENTIAL_BLUR_APREC 16
#define CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC 7
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR (cairo_utils_exponential_blur_get_type ())
#define CAIRO_UTILS_EXPONENTIAL_BLUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR, CairoUtilsExponentialBlur))
#define CAIRO_UTILS_EXPONENTIAL_BLUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR, CairoUtilsExponentialBlurClass))
#define CAIRO_UTILS_IS_EXPONENTIAL_BLUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR))
#define CAIRO_UTILS_IS_EXPONENTIAL_BLUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR))
#define CAIRO_UTILS_EXPONENTIAL_BLUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR, CairoUtilsExponentialBlurClass))

typedef struct _CairoUtilsExponentialBlur CairoUtilsExponentialBlur;
typedef struct _CairoUtilsExponentialBlurClass CairoUtilsExponentialBlurClass;
typedef struct _CairoUtilsExponentialBlurPrivate CairoUtilsExponentialBlurPrivate;
typedef struct _CairoUtilsParamSpecExponentialBlur CairoUtilsParamSpecExponentialBlur;

struct _CairoUtilsExponentialBlur {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CairoUtilsExponentialBlurPrivate * priv;
};

struct _CairoUtilsExponentialBlurClass {
	GTypeClass parent_class;
	void (*finalize) (CairoUtilsExponentialBlur *self);
};

struct _CairoUtilsParamSpecExponentialBlur {
	GParamSpec parent_instance;
};

static gpointer cairo_utils_exponential_blur_parent_class = NULL;

VALA_EXTERN void cairo_utils_rounded_rectangle (cairo_t* c,
                                    gdouble x,
                                    gdouble y,
                                    gdouble width,
                                    gdouble height,
                                    gdouble radius);
VALA_EXTERN gpointer cairo_utils_exponential_blur_ref (gpointer instance);
VALA_EXTERN void cairo_utils_exponential_blur_unref (gpointer instance);
VALA_EXTERN GParamSpec* cairo_utils_param_spec_exponential_blur (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void cairo_utils_value_set_exponential_blur (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void cairo_utils_value_take_exponential_blur (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer cairo_utils_value_get_exponential_blur (const GValue* value);
VALA_EXTERN GType cairo_utils_exponential_blur_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CairoUtilsExponentialBlur, cairo_utils_exponential_blur_unref)
VALA_EXTERN void cairo_utils_exponential_blur_surface (cairo_surface_t* surface,
                                           gint radius);
static void cairo_utils_exponential_blur_blur (guchar* pixels,
                                        gint pixels_length1,
                                        gint width,
                                        gint height,
                                        gint channels,
                                        gint radius);
static void cairo_utils_exponential_blur_blurrow (guchar* pixels,
                                           gint pixels_length1,
                                           gint width,
                                           gint height,
                                           gint channels,
                                           gint line,
                                           gint alpha);
static void cairo_utils_exponential_blur_blurcol (guchar* pixels,
                                           gint pixels_length1,
                                           gint width,
                                           gint height,
                                           gint channels,
                                           gint x,
                                           gint alpha);
static void cairo_utils_exponential_blur_blurinner (guchar* pixel,
                                             gint alpha,
                                             gint* zR,
                                             gint* zG,
                                             gint* zB,
                                             gint* zA);
VALA_EXTERN CairoUtilsExponentialBlur* cairo_utils_exponential_blur_new (void);
VALA_EXTERN CairoUtilsExponentialBlur* cairo_utils_exponential_blur_construct (GType object_type);
static void cairo_utils_exponential_blur_finalize (CairoUtilsExponentialBlur * obj);
static GType cairo_utils_exponential_blur_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
cairo_utils_rounded_rectangle (cairo_t* c,
                               gdouble x,
                               gdouble y,
                               gdouble width,
                               gdouble height,
                               gdouble radius)
{
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble kappa = 0.0;
#line 24 "../src/cairo-utils.vala"
	g_return_if_fail (c != NULL);
#line 27 "../src/cairo-utils.vala"
	w = width - (radius * 2);
#line 28 "../src/cairo-utils.vala"
	h = height - (radius * 2);
#line 29 "../src/cairo-utils.vala"
	kappa = 0.5522847498 * radius;
#line 30 "../src/cairo-utils.vala"
	cairo_move_to (c, x + radius, y);
#line 31 "../src/cairo-utils.vala"
	cairo_rel_line_to (c, w, (gdouble) 0);
#line 32 "../src/cairo-utils.vala"
	cairo_rel_curve_to (c, kappa, (gdouble) 0, radius, radius - kappa, radius, radius);
#line 33 "../src/cairo-utils.vala"
	cairo_rel_line_to (c, (gdouble) 0, h);
#line 34 "../src/cairo-utils.vala"
	cairo_rel_curve_to (c, (gdouble) 0, kappa, kappa - radius, radius, -radius, radius);
#line 35 "../src/cairo-utils.vala"
	cairo_rel_line_to (c, -w, (gdouble) 0);
#line 36 "../src/cairo-utils.vala"
	cairo_rel_curve_to (c, -kappa, (gdouble) 0, -radius, kappa - radius, -radius, -radius);
#line 37 "../src/cairo-utils.vala"
	cairo_rel_line_to (c, (gdouble) 0, -h);
#line 38 "../src/cairo-utils.vala"
	cairo_rel_curve_to (c, (gdouble) 0, -kappa, radius - kappa, -radius, radius, -radius);
#line 174 "cairo-utils.c"
}

void
cairo_utils_exponential_blur_surface (cairo_surface_t* surface,
                                      gint radius)
{
	guchar* pixels = NULL;
	guchar* _tmp0_;
	gint pixels_length1;
	gint _pixels_size_;
	gint width = 0;
	gint height = 0;
	cairo_format_t format = 0;
#line 48 "../src/cairo-utils.vala"
	g_return_if_fail (surface != NULL);
#line 50 "../src/cairo-utils.vala"
	if (radius < 1) {
#line 51 "../src/cairo-utils.vala"
		return;
#line 194 "cairo-utils.c"
	}
#line 54 "../src/cairo-utils.vala"
	cairo_surface_flush (surface);
#line 56 "../src/cairo-utils.vala"
	_tmp0_ = cairo_image_surface_get_data (surface);
#line 56 "../src/cairo-utils.vala"
	pixels = _tmp0_;
#line 56 "../src/cairo-utils.vala"
	pixels_length1 = -1;
#line 56 "../src/cairo-utils.vala"
	_pixels_size_ = pixels_length1;
#line 57 "../src/cairo-utils.vala"
	width = cairo_image_surface_get_width (surface);
#line 58 "../src/cairo-utils.vala"
	height = cairo_image_surface_get_height (surface);
#line 59 "../src/cairo-utils.vala"
	format = cairo_image_surface_get_format (surface);
#line 61 "../src/cairo-utils.vala"
	switch (format) {
#line 61 "../src/cairo-utils.vala"
		case CAIRO_FORMAT_ARGB32:
#line 216 "cairo-utils.c"
		{
			guchar* _tmp1_;
			gint _tmp1__length1;
#line 64 "../src/cairo-utils.vala"
			_tmp1_ = pixels;
#line 64 "../src/cairo-utils.vala"
			_tmp1__length1 = pixels_length1;
#line 64 "../src/cairo-utils.vala"
			cairo_utils_exponential_blur_blur (_tmp1_, (gint) _tmp1__length1, width, height, 4, radius);
#line 65 "../src/cairo-utils.vala"
			break;
#line 228 "cairo-utils.c"
		}
#line 61 "../src/cairo-utils.vala"
		case CAIRO_FORMAT_RGB24:
#line 232 "cairo-utils.c"
		{
			guchar* _tmp2_;
			gint _tmp2__length1;
#line 68 "../src/cairo-utils.vala"
			_tmp2_ = pixels;
#line 68 "../src/cairo-utils.vala"
			_tmp2__length1 = pixels_length1;
#line 68 "../src/cairo-utils.vala"
			cairo_utils_exponential_blur_blur (_tmp2_, (gint) _tmp2__length1, width, height, 3, radius);
#line 69 "../src/cairo-utils.vala"
			break;
#line 244 "cairo-utils.c"
		}
#line 61 "../src/cairo-utils.vala"
		case CAIRO_FORMAT_A8:
#line 248 "cairo-utils.c"
		{
			guchar* _tmp3_;
			gint _tmp3__length1;
#line 72 "../src/cairo-utils.vala"
			_tmp3_ = pixels;
#line 72 "../src/cairo-utils.vala"
			_tmp3__length1 = pixels_length1;
#line 72 "../src/cairo-utils.vala"
			cairo_utils_exponential_blur_blur (_tmp3_, (gint) _tmp3__length1, width, height, 1, radius);
#line 73 "../src/cairo-utils.vala"
			break;
#line 260 "cairo-utils.c"
		}
		default:
		{
#line 77 "../src/cairo-utils.vala"
			break;
#line 266 "cairo-utils.c"
		}
	}
#line 81 "../src/cairo-utils.vala"
	cairo_surface_mark_dirty (surface);
#line 271 "cairo-utils.c"
}

static void
cairo_utils_exponential_blur_blur (guchar* pixels,
                                   gint pixels_length1,
                                   gint width,
                                   gint height,
                                   gint channels,
                                   gint radius)
{
	gint alpha = 0;
#line 90 "../src/cairo-utils.vala"
	alpha = (gint) ((1 << CAIRO_UTILS_EXPONENTIAL_BLUR_APREC) * (1.0f - expf ((-2.3f) / (radius + 1.0f))));
#line 285 "cairo-utils.c"
	{
		gint row = 0;
#line 92 "../src/cairo-utils.vala"
		row = 0;
#line 290 "cairo-utils.c"
		{
			gboolean _tmp0_ = FALSE;
#line 92 "../src/cairo-utils.vala"
			_tmp0_ = TRUE;
#line 92 "../src/cairo-utils.vala"
			while (TRUE) {
#line 92 "../src/cairo-utils.vala"
				if (!_tmp0_) {
#line 299 "cairo-utils.c"
					gint _tmp1_;
#line 92 "../src/cairo-utils.vala"
					row = row + 1;
#line 92 "../src/cairo-utils.vala"
					_tmp1_ = row;
#line 305 "cairo-utils.c"
				}
#line 92 "../src/cairo-utils.vala"
				_tmp0_ = FALSE;
#line 92 "../src/cairo-utils.vala"
				if (!(row < height)) {
#line 92 "../src/cairo-utils.vala"
					break;
#line 313 "cairo-utils.c"
				}
#line 93 "../src/cairo-utils.vala"
				cairo_utils_exponential_blur_blurrow (pixels, (gint) pixels_length1, width, height, channels, row, alpha);
#line 317 "cairo-utils.c"
			}
		}
	}
	{
		gint col = 0;
#line 95 "../src/cairo-utils.vala"
		col = 0;
#line 325 "cairo-utils.c"
		{
			gboolean _tmp2_ = FALSE;
#line 95 "../src/cairo-utils.vala"
			_tmp2_ = TRUE;
#line 95 "../src/cairo-utils.vala"
			while (TRUE) {
#line 95 "../src/cairo-utils.vala"
				if (!_tmp2_) {
#line 334 "cairo-utils.c"
					gint _tmp3_;
#line 95 "../src/cairo-utils.vala"
					col = col + 1;
#line 95 "../src/cairo-utils.vala"
					_tmp3_ = col;
#line 340 "cairo-utils.c"
				}
#line 95 "../src/cairo-utils.vala"
				_tmp2_ = FALSE;
#line 95 "../src/cairo-utils.vala"
				if (!(col < width)) {
#line 95 "../src/cairo-utils.vala"
					break;
#line 348 "cairo-utils.c"
				}
#line 96 "../src/cairo-utils.vala"
				cairo_utils_exponential_blur_blurcol (pixels, (gint) pixels_length1, width, height, channels, col, alpha);
#line 352 "cairo-utils.c"
			}
		}
	}
}

static void
cairo_utils_exponential_blur_blurrow (guchar* pixels,
                                      gint pixels_length1,
                                      gint width,
                                      gint height,
                                      gint channels,
                                      gint line,
                                      gint alpha)
{
	guchar* scanline = NULL;
	gint zR = 0;
	guchar* _tmp0_;
	gint zG = 0;
	guchar* _tmp1_;
	gint zB = 0;
	guchar* _tmp2_;
	gint zA = 0;
	guchar* _tmp3_;
#line 101 "../src/cairo-utils.vala"
	scanline = &pixels[(line * width) * channels];
#line 103 "../src/cairo-utils.vala"
	_tmp0_ = scanline;
#line 103 "../src/cairo-utils.vala"
	zR = (*_tmp0_) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 104 "../src/cairo-utils.vala"
	_tmp1_ = scanline;
#line 104 "../src/cairo-utils.vala"
	zG = (*(_tmp1_ + 1)) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 105 "../src/cairo-utils.vala"
	_tmp2_ = scanline;
#line 105 "../src/cairo-utils.vala"
	zB = (*(_tmp2_ + 2)) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 106 "../src/cairo-utils.vala"
	_tmp3_ = scanline;
#line 106 "../src/cairo-utils.vala"
	zA = (*(_tmp3_ + 3)) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 394 "cairo-utils.c"
	{
		gint index = 0;
#line 108 "../src/cairo-utils.vala"
		index = 0;
#line 399 "cairo-utils.c"
		{
			gboolean _tmp4_ = FALSE;
#line 108 "../src/cairo-utils.vala"
			_tmp4_ = TRUE;
#line 108 "../src/cairo-utils.vala"
			while (TRUE) {
#line 406 "cairo-utils.c"
				guchar* _tmp6_;
#line 108 "../src/cairo-utils.vala"
				if (!_tmp4_) {
#line 410 "cairo-utils.c"
					gint _tmp5_;
#line 108 "../src/cairo-utils.vala"
					index = index + 1;
#line 108 "../src/cairo-utils.vala"
					_tmp5_ = index;
#line 416 "cairo-utils.c"
				}
#line 108 "../src/cairo-utils.vala"
				_tmp4_ = FALSE;
#line 108 "../src/cairo-utils.vala"
				if (!(index < width)) {
#line 108 "../src/cairo-utils.vala"
					break;
#line 424 "cairo-utils.c"
				}
#line 110 "../src/cairo-utils.vala"
				_tmp6_ = scanline;
#line 110 "../src/cairo-utils.vala"
				cairo_utils_exponential_blur_blurinner (&_tmp6_[index * channels], alpha, &zR, &zG, &zB, &zA);
#line 430 "cairo-utils.c"
			}
		}
	}
	{
		gint index = 0;
#line 113 "../src/cairo-utils.vala"
		index = width - 2;
#line 438 "cairo-utils.c"
		{
			gboolean _tmp7_ = FALSE;
#line 113 "../src/cairo-utils.vala"
			_tmp7_ = TRUE;
#line 113 "../src/cairo-utils.vala"
			while (TRUE) {
#line 445 "cairo-utils.c"
				guchar* _tmp9_;
#line 113 "../src/cairo-utils.vala"
				if (!_tmp7_) {
#line 449 "cairo-utils.c"
					gint _tmp8_;
#line 113 "../src/cairo-utils.vala"
					index = index - 1;
#line 113 "../src/cairo-utils.vala"
					_tmp8_ = index;
#line 455 "cairo-utils.c"
				}
#line 113 "../src/cairo-utils.vala"
				_tmp7_ = FALSE;
#line 113 "../src/cairo-utils.vala"
				if (!(index >= 0)) {
#line 113 "../src/cairo-utils.vala"
					break;
#line 463 "cairo-utils.c"
				}
#line 115 "../src/cairo-utils.vala"
				_tmp9_ = scanline;
#line 115 "../src/cairo-utils.vala"
				cairo_utils_exponential_blur_blurinner (&_tmp9_[index * channels], alpha, &zR, &zG, &zB, &zA);
#line 469 "cairo-utils.c"
			}
		}
	}
}

static void
cairo_utils_exponential_blur_blurcol (guchar* pixels,
                                      gint pixels_length1,
                                      gint width,
                                      gint height,
                                      gint channels,
                                      gint x,
                                      gint alpha)
{
	guchar* ptr = NULL;
	gint zR = 0;
	guchar* _tmp0_;
	gint zG = 0;
	guchar* _tmp1_;
	gint zB = 0;
	guchar* _tmp2_;
	gint zA = 0;
	guchar* _tmp3_;
#line 121 "../src/cairo-utils.vala"
	ptr = &pixels[x * channels];
#line 123 "../src/cairo-utils.vala"
	_tmp0_ = ptr;
#line 123 "../src/cairo-utils.vala"
	zR = (*_tmp0_) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 124 "../src/cairo-utils.vala"
	_tmp1_ = ptr;
#line 124 "../src/cairo-utils.vala"
	zG = (*(_tmp1_ + 1)) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 125 "../src/cairo-utils.vala"
	_tmp2_ = ptr;
#line 125 "../src/cairo-utils.vala"
	zB = (*(_tmp2_ + 2)) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 126 "../src/cairo-utils.vala"
	_tmp3_ = ptr;
#line 126 "../src/cairo-utils.vala"
	zA = (*(_tmp3_ + 3)) << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC;
#line 511 "cairo-utils.c"
	{
		gint index = 0;
#line 128 "../src/cairo-utils.vala"
		index = width;
#line 516 "cairo-utils.c"
		{
			gboolean _tmp4_ = FALSE;
#line 128 "../src/cairo-utils.vala"
			_tmp4_ = TRUE;
#line 128 "../src/cairo-utils.vala"
			while (TRUE) {
#line 523 "cairo-utils.c"
				guchar* _tmp5_;
#line 128 "../src/cairo-utils.vala"
				if (!_tmp4_) {
#line 128 "../src/cairo-utils.vala"
					index += width;
#line 529 "cairo-utils.c"
				}
#line 128 "../src/cairo-utils.vala"
				_tmp4_ = FALSE;
#line 128 "../src/cairo-utils.vala"
				if (!(index < ((height - 1) * width))) {
#line 128 "../src/cairo-utils.vala"
					break;
#line 537 "cairo-utils.c"
				}
#line 130 "../src/cairo-utils.vala"
				_tmp5_ = ptr;
#line 130 "../src/cairo-utils.vala"
				cairo_utils_exponential_blur_blurinner (&_tmp5_[index * channels], alpha, &zR, &zG, &zB, &zA);
#line 543 "cairo-utils.c"
			}
		}
	}
	{
		gint index = 0;
#line 133 "../src/cairo-utils.vala"
		index = (height - 2) * width;
#line 551 "cairo-utils.c"
		{
			gboolean _tmp6_ = FALSE;
#line 133 "../src/cairo-utils.vala"
			_tmp6_ = TRUE;
#line 133 "../src/cairo-utils.vala"
			while (TRUE) {
#line 558 "cairo-utils.c"
				guchar* _tmp7_;
#line 133 "../src/cairo-utils.vala"
				if (!_tmp6_) {
#line 133 "../src/cairo-utils.vala"
					index -= width;
#line 564 "cairo-utils.c"
				}
#line 133 "../src/cairo-utils.vala"
				_tmp6_ = FALSE;
#line 133 "../src/cairo-utils.vala"
				if (!(index >= 0)) {
#line 133 "../src/cairo-utils.vala"
					break;
#line 572 "cairo-utils.c"
				}
#line 135 "../src/cairo-utils.vala"
				_tmp7_ = ptr;
#line 135 "../src/cairo-utils.vala"
				cairo_utils_exponential_blur_blurinner (&_tmp7_[index * channels], alpha, &zR, &zG, &zB, &zA);
#line 578 "cairo-utils.c"
			}
		}
	}
}

static void
cairo_utils_exponential_blur_blurinner (guchar* pixel,
                                        gint alpha,
                                        gint* zR,
                                        gint* zG,
                                        gint* zB,
                                        gint* zA)
{
	gint R = 0;
	gint G = 0;
	gint B = 0;
	guchar A = '\0';
#line 146 "../src/cairo-utils.vala"
	R = (gint) (*pixel);
#line 147 "../src/cairo-utils.vala"
	G = (gint) (*(pixel + 1));
#line 148 "../src/cairo-utils.vala"
	B = (gint) (*(pixel + 2));
#line 149 "../src/cairo-utils.vala"
	A = *(pixel + 3);
#line 151 "../src/cairo-utils.vala"
	*zR = (*zR) + ((alpha * ((R << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC) - (*zR))) >> CAIRO_UTILS_EXPONENTIAL_BLUR_APREC);
#line 152 "../src/cairo-utils.vala"
	*zG = (*zG) + ((alpha * ((G << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC) - (*zG))) >> CAIRO_UTILS_EXPONENTIAL_BLUR_APREC);
#line 153 "../src/cairo-utils.vala"
	*zB = (*zB) + ((alpha * ((B << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC) - (*zB))) >> CAIRO_UTILS_EXPONENTIAL_BLUR_APREC);
#line 154 "../src/cairo-utils.vala"
	*zA = (*zA) + ((alpha * ((A << CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC) - (*zA))) >> CAIRO_UTILS_EXPONENTIAL_BLUR_APREC);
#line 156 "../src/cairo-utils.vala"
	*pixel = (guchar) ((*zR) >> CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC);
#line 157 "../src/cairo-utils.vala"
	*(pixel + 1) = (guchar) ((*zG) >> CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC);
#line 158 "../src/cairo-utils.vala"
	*(pixel + 2) = (guchar) ((*zB) >> CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC);
#line 159 "../src/cairo-utils.vala"
	*(pixel + 3) = (guchar) ((*zA) >> CAIRO_UTILS_EXPONENTIAL_BLUR_ZPREC);
#line 620 "cairo-utils.c"
}

CairoUtilsExponentialBlur*
cairo_utils_exponential_blur_construct (GType object_type)
{
	CairoUtilsExponentialBlur* self = NULL;
#line 41 "../src/cairo-utils.vala"
	self = (CairoUtilsExponentialBlur*) g_type_create_instance (object_type);
#line 41 "../src/cairo-utils.vala"
	return self;
#line 631 "cairo-utils.c"
}

CairoUtilsExponentialBlur*
cairo_utils_exponential_blur_new (void)
{
#line 41 "../src/cairo-utils.vala"
	return cairo_utils_exponential_blur_construct (CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR);
#line 639 "cairo-utils.c"
}

static void
cairo_utils_value_exponential_blur_init (GValue* value)
{
#line 41 "../src/cairo-utils.vala"
	value->data[0].v_pointer = NULL;
#line 647 "cairo-utils.c"
}

static void
cairo_utils_value_exponential_blur_free_value (GValue* value)
{
#line 41 "../src/cairo-utils.vala"
	if (value->data[0].v_pointer) {
#line 41 "../src/cairo-utils.vala"
		cairo_utils_exponential_blur_unref (value->data[0].v_pointer);
#line 657 "cairo-utils.c"
	}
}

static void
cairo_utils_value_exponential_blur_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
#line 41 "../src/cairo-utils.vala"
	if (src_value->data[0].v_pointer) {
#line 41 "../src/cairo-utils.vala"
		dest_value->data[0].v_pointer = cairo_utils_exponential_blur_ref (src_value->data[0].v_pointer);
#line 669 "cairo-utils.c"
	} else {
#line 41 "../src/cairo-utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 673 "cairo-utils.c"
	}
}

static gpointer
cairo_utils_value_exponential_blur_peek_pointer (const GValue* value)
{
#line 41 "../src/cairo-utils.vala"
	return value->data[0].v_pointer;
#line 682 "cairo-utils.c"
}

static gchar*
cairo_utils_value_exponential_blur_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
#line 41 "../src/cairo-utils.vala"
	if (collect_values[0].v_pointer) {
#line 693 "cairo-utils.c"
		CairoUtilsExponentialBlur * object;
		object = collect_values[0].v_pointer;
#line 41 "../src/cairo-utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 41 "../src/cairo-utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 700 "cairo-utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 41 "../src/cairo-utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 704 "cairo-utils.c"
		}
#line 41 "../src/cairo-utils.vala"
		value->data[0].v_pointer = cairo_utils_exponential_blur_ref (object);
#line 708 "cairo-utils.c"
	} else {
#line 41 "../src/cairo-utils.vala"
		value->data[0].v_pointer = NULL;
#line 712 "cairo-utils.c"
	}
#line 41 "../src/cairo-utils.vala"
	return NULL;
#line 716 "cairo-utils.c"
}

static gchar*
cairo_utils_value_exponential_blur_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	CairoUtilsExponentialBlur ** object_p;
	object_p = collect_values[0].v_pointer;
#line 41 "../src/cairo-utils.vala"
	if (!object_p) {
#line 41 "../src/cairo-utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 731 "cairo-utils.c"
	}
#line 41 "../src/cairo-utils.vala"
	if (!value->data[0].v_pointer) {
#line 41 "../src/cairo-utils.vala"
		*object_p = NULL;
#line 737 "cairo-utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 41 "../src/cairo-utils.vala"
		*object_p = value->data[0].v_pointer;
#line 741 "cairo-utils.c"
	} else {
#line 41 "../src/cairo-utils.vala"
		*object_p = cairo_utils_exponential_blur_ref (value->data[0].v_pointer);
#line 745 "cairo-utils.c"
	}
#line 41 "../src/cairo-utils.vala"
	return NULL;
#line 749 "cairo-utils.c"
}

GParamSpec*
cairo_utils_param_spec_exponential_blur (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	CairoUtilsParamSpecExponentialBlur* spec;
#line 41 "../src/cairo-utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR), NULL);
#line 41 "../src/cairo-utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 41 "../src/cairo-utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 41 "../src/cairo-utils.vala"
	return G_PARAM_SPEC (spec);
#line 768 "cairo-utils.c"
}

gpointer
cairo_utils_value_get_exponential_blur (const GValue* value)
{
#line 41 "../src/cairo-utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR), NULL);
#line 41 "../src/cairo-utils.vala"
	return value->data[0].v_pointer;
#line 778 "cairo-utils.c"
}

void
cairo_utils_value_set_exponential_blur (GValue* value,
                                        gpointer v_object)
{
	CairoUtilsExponentialBlur * old;
#line 41 "../src/cairo-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR));
#line 41 "../src/cairo-utils.vala"
	old = value->data[0].v_pointer;
#line 41 "../src/cairo-utils.vala"
	if (v_object) {
#line 41 "../src/cairo-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR));
#line 41 "../src/cairo-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 41 "../src/cairo-utils.vala"
		value->data[0].v_pointer = v_object;
#line 41 "../src/cairo-utils.vala"
		cairo_utils_exponential_blur_ref (value->data[0].v_pointer);
#line 800 "cairo-utils.c"
	} else {
#line 41 "../src/cairo-utils.vala"
		value->data[0].v_pointer = NULL;
#line 804 "cairo-utils.c"
	}
#line 41 "../src/cairo-utils.vala"
	if (old) {
#line 41 "../src/cairo-utils.vala"
		cairo_utils_exponential_blur_unref (old);
#line 810 "cairo-utils.c"
	}
}

void
cairo_utils_value_take_exponential_blur (GValue* value,
                                         gpointer v_object)
{
	CairoUtilsExponentialBlur * old;
#line 41 "../src/cairo-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR));
#line 41 "../src/cairo-utils.vala"
	old = value->data[0].v_pointer;
#line 41 "../src/cairo-utils.vala"
	if (v_object) {
#line 41 "../src/cairo-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR));
#line 41 "../src/cairo-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 41 "../src/cairo-utils.vala"
		value->data[0].v_pointer = v_object;
#line 831 "cairo-utils.c"
	} else {
#line 41 "../src/cairo-utils.vala"
		value->data[0].v_pointer = NULL;
#line 835 "cairo-utils.c"
	}
#line 41 "../src/cairo-utils.vala"
	if (old) {
#line 41 "../src/cairo-utils.vala"
		cairo_utils_exponential_blur_unref (old);
#line 841 "cairo-utils.c"
	}
}

static void
cairo_utils_exponential_blur_class_init (CairoUtilsExponentialBlurClass * klass,
                                         gpointer klass_data)
{
#line 41 "../src/cairo-utils.vala"
	cairo_utils_exponential_blur_parent_class = g_type_class_peek_parent (klass);
#line 41 "../src/cairo-utils.vala"
	((CairoUtilsExponentialBlurClass *) klass)->finalize = cairo_utils_exponential_blur_finalize;
#line 853 "cairo-utils.c"
}

static void
cairo_utils_exponential_blur_instance_init (CairoUtilsExponentialBlur * self,
                                            gpointer klass)
{
#line 41 "../src/cairo-utils.vala"
	self->ref_count = 1;
#line 862 "cairo-utils.c"
}

static void
cairo_utils_exponential_blur_finalize (CairoUtilsExponentialBlur * obj)
{
	CairoUtilsExponentialBlur * self;
#line 41 "../src/cairo-utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAIRO_UTILS_TYPE_EXPONENTIAL_BLUR, CairoUtilsExponentialBlur);
#line 41 "../src/cairo-utils.vala"
	g_signal_handlers_destroy (self);
#line 873 "cairo-utils.c"
}

static GType
cairo_utils_exponential_blur_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { cairo_utils_value_exponential_blur_init, cairo_utils_value_exponential_blur_free_value, cairo_utils_value_exponential_blur_copy_value, cairo_utils_value_exponential_blur_peek_pointer, "p", cairo_utils_value_exponential_blur_collect_value, "p", cairo_utils_value_exponential_blur_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CairoUtilsExponentialBlurClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cairo_utils_exponential_blur_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CairoUtilsExponentialBlur), 0, (GInstanceInitFunc) cairo_utils_exponential_blur_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType cairo_utils_exponential_blur_type_id;
	cairo_utils_exponential_blur_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CairoUtilsExponentialBlur", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return cairo_utils_exponential_blur_type_id;
}

GType
cairo_utils_exponential_blur_get_type (void)
{
	static volatile gsize cairo_utils_exponential_blur_type_id__once = 0;
	if (g_once_init_enter (&cairo_utils_exponential_blur_type_id__once)) {
		GType cairo_utils_exponential_blur_type_id;
		cairo_utils_exponential_blur_type_id = cairo_utils_exponential_blur_get_type_once ();
		g_once_init_leave (&cairo_utils_exponential_blur_type_id__once, cairo_utils_exponential_blur_type_id);
	}
	return cairo_utils_exponential_blur_type_id__once;
}

gpointer
cairo_utils_exponential_blur_ref (gpointer instance)
{
	CairoUtilsExponentialBlur * self;
	self = instance;
#line 41 "../src/cairo-utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 41 "../src/cairo-utils.vala"
	return instance;
#line 908 "cairo-utils.c"
}

void
cairo_utils_exponential_blur_unref (gpointer instance)
{
	CairoUtilsExponentialBlur * self;
	self = instance;
#line 41 "../src/cairo-utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 41 "../src/cairo-utils.vala"
		CAIRO_UTILS_EXPONENTIAL_BLUR_GET_CLASS (self)->finalize (self);
#line 41 "../src/cairo-utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 922 "cairo-utils.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

