// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_KOLABFORMAT_XCAL_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_KOLABFORMAT_XCAL_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace icalendar_2_0
{
  class XlabelParamType;
  class XuidParamType;
  class XFBevent;
  class KolabVersion;
  class CustomType;
  class ContactType;
  class ValarmType;
  class KolabEvent;
  class KolabTodo;
  class KolabJournal;
  class KolabFreebusy;
  class VcalendarType;
  class IcalendarType;
  class properties;
  class properties1;
  class components;
  class properties2;
  class properties3;
  class properties4;
  class properties5;
  class components1;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

#include "iCalendar-props.hxx"

namespace icalendar_2_0
{
  class XlabelParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    XlabelParamType (const text_type&);

    XlabelParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    XlabelParamType (const XlabelParamType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual XlabelParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    XlabelParamType&
    operator= (const XlabelParamType&) = default;
#endif

    virtual 
    ~XlabelParamType ();
  };

  class XuidParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    XuidParamType (const text_type&);

    XuidParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    XuidParamType (const XuidParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual XuidParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    XuidParamType&
    operator= (const XuidParamType&) = default;
#endif

    virtual 
    ~XuidParamType ();
  };

  class XFBevent: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // uid
    //
    typedef ::xml_schema::string uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // summary
    //
    typedef ::xml_schema::string summary_type;
    typedef ::xsd::cxx::tree::traits< summary_type, char > summary_traits;

    const summary_type&
    summary () const;

    summary_type&
    summary ();

    void
    summary (const summary_type& x);

    void
    summary (::std::unique_ptr< summary_type > p);

    // location
    //
    typedef ::xml_schema::string location_type;
    typedef ::xsd::cxx::tree::traits< location_type, char > location_traits;

    const location_type&
    location () const;

    location_type&
    location ();

    void
    location (const location_type& x);

    void
    location (::std::unique_ptr< location_type > p);

    // Constructors.
    //
    XFBevent (const uid_type&,
              const summary_type&,
              const location_type&);

    XFBevent (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    XFBevent (const XFBevent& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual XFBevent*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    XFBevent&
    operator= (const XFBevent& x);

    virtual 
    ~XFBevent ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< summary_type > summary_;
    ::xsd::cxx::tree::one< location_type > location_;
  };

  class KolabVersion: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    static const text_type&
    text_default_value ();

    // Constructors.
    //
    KolabVersion (const text_type&);

    KolabVersion (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    KolabVersion (const KolabVersion& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual KolabVersion*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabVersion&
    operator= (const KolabVersion& x);

    virtual 
    ~KolabVersion ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
    static const text_type text_default_value_;
  };

  class CustomType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // identifier
    //
    typedef ::xml_schema::string identifier_type;
    typedef ::xsd::cxx::tree::traits< identifier_type, char > identifier_traits;

    const identifier_type&
    identifier () const;

    identifier_type&
    identifier ();

    void
    identifier (const identifier_type& x);

    void
    identifier (::std::unique_ptr< identifier_type > p);

    // value
    //
    typedef ::xml_schema::string value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    void
    value (::std::unique_ptr< value_type > p);

    // Constructors.
    //
    CustomType (const identifier_type&,
                const value_type&);

    CustomType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    CustomType (const CustomType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual CustomType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CustomType&
    operator= (const CustomType& x);

    virtual 
    ~CustomType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< identifier_type > identifier_;
    ::xsd::cxx::tree::one< value_type > value_;
  };

  class ContactType: public ::icalendar_2_0::CalAddressPropertyType
  {
    public:
    // Constructors.
    //
    ContactType (const cal_address_type&);

    ContactType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    ContactType (const ContactType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual ContactType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ContactType&
    operator= (const ContactType&) = default;
#endif

    virtual 
    ~ContactType ();
  };

  class ValarmType: public ::xml_schema::type
  {
    public:
    // properties
    //
    typedef ::icalendar_2_0::properties properties_type;
    typedef ::xsd::cxx::tree::traits< properties_type, char > properties_traits;

    const properties_type&
    properties () const;

    properties_type&
    properties ();

    void
    properties (const properties_type& x);

    void
    properties (::std::unique_ptr< properties_type > p);

    // Constructors.
    //
    ValarmType (const properties_type&);

    ValarmType (::std::unique_ptr< properties_type >);

    ValarmType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    ValarmType (const ValarmType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual ValarmType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ValarmType&
    operator= (const ValarmType& x);

    virtual 
    ~ValarmType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< properties_type > properties_;
  };

  class KolabEvent: public ::xml_schema::type
  {
    public:
    // properties
    //
    typedef ::icalendar_2_0::properties1 properties_type;
    typedef ::xsd::cxx::tree::traits< properties_type, char > properties_traits;

    const properties_type&
    properties () const;

    properties_type&
    properties ();

    void
    properties (const properties_type& x);

    void
    properties (::std::unique_ptr< properties_type > p);

    // components
    //
    typedef ::icalendar_2_0::components components_type;
    typedef ::xsd::cxx::tree::optional< components_type > components_optional;
    typedef ::xsd::cxx::tree::traits< components_type, char > components_traits;

    const components_optional&
    components () const;

    components_optional&
    components ();

    void
    components (const components_type& x);

    void
    components (const components_optional& x);

    void
    components (::std::unique_ptr< components_type > p);

    // Constructors.
    //
    KolabEvent (const properties_type&);

    KolabEvent (::std::unique_ptr< properties_type >);

    KolabEvent (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    KolabEvent (const KolabEvent& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual KolabEvent*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabEvent&
    operator= (const KolabEvent& x);

    virtual 
    ~KolabEvent ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< properties_type > properties_;
    components_optional components_;
  };

  class KolabTodo: public ::xml_schema::type
  {
    public:
    // properties
    //
    typedef ::icalendar_2_0::properties2 properties_type;
    typedef ::xsd::cxx::tree::traits< properties_type, char > properties_traits;

    const properties_type&
    properties () const;

    properties_type&
    properties ();

    void
    properties (const properties_type& x);

    void
    properties (::std::unique_ptr< properties_type > p);

    // components
    //
    typedef ::icalendar_2_0::components components_type;
    typedef ::xsd::cxx::tree::optional< components_type > components_optional;
    typedef ::xsd::cxx::tree::traits< components_type, char > components_traits;

    const components_optional&
    components () const;

    components_optional&
    components ();

    void
    components (const components_type& x);

    void
    components (const components_optional& x);

    void
    components (::std::unique_ptr< components_type > p);

    // Constructors.
    //
    KolabTodo (const properties_type&);

    KolabTodo (::std::unique_ptr< properties_type >);

    KolabTodo (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    KolabTodo (const KolabTodo& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual KolabTodo*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabTodo&
    operator= (const KolabTodo& x);

    virtual 
    ~KolabTodo ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< properties_type > properties_;
    components_optional components_;
  };

  class KolabJournal: public ::xml_schema::type
  {
    public:
    // properties
    //
    typedef ::icalendar_2_0::properties3 properties_type;
    typedef ::xsd::cxx::tree::traits< properties_type, char > properties_traits;

    const properties_type&
    properties () const;

    properties_type&
    properties ();

    void
    properties (const properties_type& x);

    void
    properties (::std::unique_ptr< properties_type > p);

    // Constructors.
    //
    KolabJournal (const properties_type&);

    KolabJournal (::std::unique_ptr< properties_type >);

    KolabJournal (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    KolabJournal (const KolabJournal& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual KolabJournal*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabJournal&
    operator= (const KolabJournal& x);

    virtual 
    ~KolabJournal ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< properties_type > properties_;
  };

  class KolabFreebusy: public ::xml_schema::type
  {
    public:
    // properties
    //
    typedef ::icalendar_2_0::properties4 properties_type;
    typedef ::xsd::cxx::tree::traits< properties_type, char > properties_traits;

    const properties_type&
    properties () const;

    properties_type&
    properties ();

    void
    properties (const properties_type& x);

    void
    properties (::std::unique_ptr< properties_type > p);

    // Constructors.
    //
    KolabFreebusy (const properties_type&);

    KolabFreebusy (::std::unique_ptr< properties_type >);

    KolabFreebusy (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    KolabFreebusy (const KolabFreebusy& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual KolabFreebusy*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabFreebusy&
    operator= (const KolabFreebusy& x);

    virtual 
    ~KolabFreebusy ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< properties_type > properties_;
  };

  class VcalendarType: public ::xml_schema::type
  {
    public:
    // properties
    //
    typedef ::icalendar_2_0::properties5 properties_type;
    typedef ::xsd::cxx::tree::traits< properties_type, char > properties_traits;

    const properties_type&
    properties () const;

    properties_type&
    properties ();

    void
    properties (const properties_type& x);

    void
    properties (::std::unique_ptr< properties_type > p);

    // components
    //
    typedef ::icalendar_2_0::components1 components_type;
    typedef ::xsd::cxx::tree::traits< components_type, char > components_traits;

    const components_type&
    components () const;

    components_type&
    components ();

    void
    components (const components_type& x);

    void
    components (::std::unique_ptr< components_type > p);

    // Constructors.
    //
    VcalendarType (const properties_type&,
                   const components_type&);

    VcalendarType (::std::unique_ptr< properties_type >,
                   ::std::unique_ptr< components_type >);

    VcalendarType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    VcalendarType (const VcalendarType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual VcalendarType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    VcalendarType&
    operator= (const VcalendarType& x);

    virtual 
    ~VcalendarType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< properties_type > properties_;
    ::xsd::cxx::tree::one< components_type > components_;
  };

  class IcalendarType: public ::xml_schema::type
  {
    public:
    // vcalendar
    //
    typedef ::icalendar_2_0::VcalendarType vcalendar_type;
    typedef ::xsd::cxx::tree::traits< vcalendar_type, char > vcalendar_traits;

    const vcalendar_type&
    vcalendar () const;

    vcalendar_type&
    vcalendar ();

    void
    vcalendar (const vcalendar_type& x);

    void
    vcalendar (::std::unique_ptr< vcalendar_type > p);

    // Constructors.
    //
    IcalendarType (const vcalendar_type&);

    IcalendarType (::std::unique_ptr< vcalendar_type >);

    IcalendarType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    IcalendarType (const IcalendarType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual IcalendarType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    IcalendarType&
    operator= (const IcalendarType& x);

    virtual 
    ~IcalendarType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< vcalendar_type > vcalendar_;
  };

  class properties: public ::xml_schema::type
  {
    public:
    // action
    //
    typedef ::icalendar_2_0::ActionPropType action_type;
    typedef ::xsd::cxx::tree::traits< action_type, char > action_traits;

    const action_type&
    action () const;

    action_type&
    action ();

    void
    action (const action_type& x);

    void
    action (::std::unique_ptr< action_type > p);

    // summary
    //
    typedef ::icalendar_2_0::TextPropertyType summary_type;
    typedef ::xsd::cxx::tree::optional< summary_type > summary_optional;
    typedef ::xsd::cxx::tree::traits< summary_type, char > summary_traits;

    const summary_optional&
    summary () const;

    summary_optional&
    summary ();

    void
    summary (const summary_type& x);

    void
    summary (const summary_optional& x);

    void
    summary (::std::unique_ptr< summary_type > p);

    // description
    //
    typedef ::icalendar_2_0::TextPropertyType description_type;
    typedef ::xsd::cxx::tree::optional< description_type > description_optional;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_optional&
    description () const;

    description_optional&
    description ();

    void
    description (const description_type& x);

    void
    description (const description_optional& x);

    void
    description (::std::unique_ptr< description_type > p);

    // attendee
    //
    typedef ::icalendar_2_0::ContactType attendee_type;
    typedef ::xsd::cxx::tree::sequence< attendee_type > attendee_sequence;
    typedef attendee_sequence::iterator attendee_iterator;
    typedef attendee_sequence::const_iterator attendee_const_iterator;
    typedef ::xsd::cxx::tree::traits< attendee_type, char > attendee_traits;

    const attendee_sequence&
    attendee () const;

    attendee_sequence&
    attendee ();

    void
    attendee (const attendee_sequence& s);

    // attach
    //
    typedef ::icalendar_2_0::AttachPropType attach_type;
    typedef ::xsd::cxx::tree::optional< attach_type > attach_optional;
    typedef ::xsd::cxx::tree::traits< attach_type, char > attach_traits;

    const attach_optional&
    attach () const;

    attach_optional&
    attach ();

    void
    attach (const attach_type& x);

    void
    attach (const attach_optional& x);

    void
    attach (::std::unique_ptr< attach_type > p);

    // trigger
    //
    typedef ::icalendar_2_0::TriggerPropType trigger_type;
    typedef ::xsd::cxx::tree::traits< trigger_type, char > trigger_traits;

    const trigger_type&
    trigger () const;

    trigger_type&
    trigger ();

    void
    trigger (const trigger_type& x);

    void
    trigger (::std::unique_ptr< trigger_type > p);

    // duration
    //
    typedef ::icalendar_2_0::DurationPropType duration_type;
    typedef ::xsd::cxx::tree::optional< duration_type > duration_optional;
    typedef ::xsd::cxx::tree::traits< duration_type, char > duration_traits;

    const duration_optional&
    duration () const;

    duration_optional&
    duration ();

    void
    duration (const duration_type& x);

    void
    duration (const duration_optional& x);

    void
    duration (::std::unique_ptr< duration_type > p);

    // repeat
    //
    typedef ::icalendar_2_0::RepeatPropType repeat_type;
    typedef ::xsd::cxx::tree::optional< repeat_type > repeat_optional;
    typedef ::xsd::cxx::tree::traits< repeat_type, char > repeat_traits;

    const repeat_optional&
    repeat () const;

    repeat_optional&
    repeat ();

    void
    repeat (const repeat_type& x);

    void
    repeat (const repeat_optional& x);

    void
    repeat (::std::unique_ptr< repeat_type > p);

    // Constructors.
    //
    properties (const action_type&,
                const trigger_type&);

    properties (::std::unique_ptr< action_type >,
                ::std::unique_ptr< trigger_type >);

    properties (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    properties (const properties& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual properties*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    properties&
    operator= (const properties& x);

    virtual 
    ~properties ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< action_type > action_;
    summary_optional summary_;
    description_optional description_;
    attendee_sequence attendee_;
    attach_optional attach_;
    ::xsd::cxx::tree::one< trigger_type > trigger_;
    duration_optional duration_;
    repeat_optional repeat_;
  };

  class properties1: public ::xml_schema::type
  {
    public:
    // uid
    //
    typedef ::icalendar_2_0::UidPropType uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // created
    //
    typedef ::icalendar_2_0::CreatedPropType created_type;
    typedef ::xsd::cxx::tree::traits< created_type, char > created_traits;

    const created_type&
    created () const;

    created_type&
    created ();

    void
    created (const created_type& x);

    void
    created (::std::unique_ptr< created_type > p);

    // dtstamp
    //
    typedef ::icalendar_2_0::DtstampPropType dtstamp_type;
    typedef ::xsd::cxx::tree::traits< dtstamp_type, char > dtstamp_traits;

    const dtstamp_type&
    dtstamp () const;

    dtstamp_type&
    dtstamp ();

    void
    dtstamp (const dtstamp_type& x);

    void
    dtstamp (::std::unique_ptr< dtstamp_type > p);

    // sequence
    //
    typedef ::icalendar_2_0::SequencePropType sequence_type;
    typedef ::xsd::cxx::tree::optional< sequence_type > sequence_optional;
    typedef ::xsd::cxx::tree::traits< sequence_type, char > sequence_traits;

    const sequence_optional&
    sequence () const;

    sequence_optional&
    sequence ();

    void
    sequence (const sequence_type& x);

    void
    sequence (const sequence_optional& x);

    void
    sequence (::std::unique_ptr< sequence_type > p);

    // class
    //
    typedef ::icalendar_2_0::ClassPropType class_type;
    typedef ::xsd::cxx::tree::optional< class_type > class_optional;
    typedef ::xsd::cxx::tree::traits< class_type, char > class_traits;

    const class_optional&
    class_ () const;

    class_optional&
    class_ ();

    void
    class_ (const class_type& x);

    void
    class_ (const class_optional& x);

    void
    class_ (::std::unique_ptr< class_type > p);

    // categories
    //
    typedef ::icalendar_2_0::CategoriesPropType categories_type;
    typedef ::xsd::cxx::tree::optional< categories_type > categories_optional;
    typedef ::xsd::cxx::tree::traits< categories_type, char > categories_traits;

    const categories_optional&
    categories () const;

    categories_optional&
    categories ();

    void
    categories (const categories_type& x);

    void
    categories (const categories_optional& x);

    void
    categories (::std::unique_ptr< categories_type > p);

    // dtstart
    //
    typedef ::icalendar_2_0::DtstartPropType dtstart_type;
    typedef ::xsd::cxx::tree::optional< dtstart_type > dtstart_optional;
    typedef ::xsd::cxx::tree::traits< dtstart_type, char > dtstart_traits;

    const dtstart_optional&
    dtstart () const;

    dtstart_optional&
    dtstart ();

    void
    dtstart (const dtstart_type& x);

    void
    dtstart (const dtstart_optional& x);

    void
    dtstart (::std::unique_ptr< dtstart_type > p);

    // dtend
    //
    typedef ::icalendar_2_0::DtendPropType dtend_type;
    typedef ::xsd::cxx::tree::optional< dtend_type > dtend_optional;
    typedef ::xsd::cxx::tree::traits< dtend_type, char > dtend_traits;

    const dtend_optional&
    dtend () const;

    dtend_optional&
    dtend ();

    void
    dtend (const dtend_type& x);

    void
    dtend (const dtend_optional& x);

    void
    dtend (::std::unique_ptr< dtend_type > p);

    // duration
    //
    typedef ::icalendar_2_0::DurationPropType duration_type;
    typedef ::xsd::cxx::tree::optional< duration_type > duration_optional;
    typedef ::xsd::cxx::tree::traits< duration_type, char > duration_traits;

    const duration_optional&
    duration () const;

    duration_optional&
    duration ();

    void
    duration (const duration_type& x);

    void
    duration (const duration_optional& x);

    void
    duration (::std::unique_ptr< duration_type > p);

    // transp
    //
    typedef ::icalendar_2_0::TranspPropType transp_type;
    typedef ::xsd::cxx::tree::optional< transp_type > transp_optional;
    typedef ::xsd::cxx::tree::traits< transp_type, char > transp_traits;

    const transp_optional&
    transp () const;

    transp_optional&
    transp ();

    void
    transp (const transp_type& x);

    void
    transp (const transp_optional& x);

    void
    transp (::std::unique_ptr< transp_type > p);

    // rrule
    //
    typedef ::icalendar_2_0::RrulePropType rrule_type;
    typedef ::xsd::cxx::tree::optional< rrule_type > rrule_optional;
    typedef ::xsd::cxx::tree::traits< rrule_type, char > rrule_traits;

    const rrule_optional&
    rrule () const;

    rrule_optional&
    rrule ();

    void
    rrule (const rrule_type& x);

    void
    rrule (const rrule_optional& x);

    void
    rrule (::std::unique_ptr< rrule_type > p);

    // rdate
    //
    typedef ::icalendar_2_0::RdatePropType rdate_type;
    typedef ::xsd::cxx::tree::optional< rdate_type > rdate_optional;
    typedef ::xsd::cxx::tree::traits< rdate_type, char > rdate_traits;

    const rdate_optional&
    rdate () const;

    rdate_optional&
    rdate ();

    void
    rdate (const rdate_type& x);

    void
    rdate (const rdate_optional& x);

    void
    rdate (::std::unique_ptr< rdate_type > p);

    // exdate
    //
    typedef ::icalendar_2_0::ExdatePropType exdate_type;
    typedef ::xsd::cxx::tree::optional< exdate_type > exdate_optional;
    typedef ::xsd::cxx::tree::traits< exdate_type, char > exdate_traits;

    const exdate_optional&
    exdate () const;

    exdate_optional&
    exdate ();

    void
    exdate (const exdate_type& x);

    void
    exdate (const exdate_optional& x);

    void
    exdate (::std::unique_ptr< exdate_type > p);

    // recurrence-id
    //
    typedef ::icalendar_2_0::RecurrenceIdPropType recurrence_id_type;
    typedef ::xsd::cxx::tree::optional< recurrence_id_type > recurrence_id_optional;
    typedef ::xsd::cxx::tree::traits< recurrence_id_type, char > recurrence_id_traits;

    const recurrence_id_optional&
    recurrence_id () const;

    recurrence_id_optional&
    recurrence_id ();

    void
    recurrence_id (const recurrence_id_type& x);

    void
    recurrence_id (const recurrence_id_optional& x);

    void
    recurrence_id (::std::unique_ptr< recurrence_id_type > p);

    // summary
    //
    typedef ::icalendar_2_0::SummaryPropType summary_type;
    typedef ::xsd::cxx::tree::optional< summary_type > summary_optional;
    typedef ::xsd::cxx::tree::traits< summary_type, char > summary_traits;

    const summary_optional&
    summary () const;

    summary_optional&
    summary ();

    void
    summary (const summary_type& x);

    void
    summary (const summary_optional& x);

    void
    summary (::std::unique_ptr< summary_type > p);

    // description
    //
    typedef ::icalendar_2_0::DescriptionPropType description_type;
    typedef ::xsd::cxx::tree::optional< description_type > description_optional;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_optional&
    description () const;

    description_optional&
    description ();

    void
    description (const description_type& x);

    void
    description (const description_optional& x);

    void
    description (::std::unique_ptr< description_type > p);

    // comment
    //
    typedef ::icalendar_2_0::CommentPropType comment_type;
    typedef ::xsd::cxx::tree::optional< comment_type > comment_optional;
    typedef ::xsd::cxx::tree::traits< comment_type, char > comment_traits;

    const comment_optional&
    comment () const;

    comment_optional&
    comment ();

    void
    comment (const comment_type& x);

    void
    comment (const comment_optional& x);

    void
    comment (::std::unique_ptr< comment_type > p);

    // priority
    //
    typedef ::icalendar_2_0::PriorityPropType priority_type;
    typedef ::xsd::cxx::tree::optional< priority_type > priority_optional;
    typedef ::xsd::cxx::tree::traits< priority_type, char > priority_traits;

    const priority_optional&
    priority () const;

    priority_optional&
    priority ();

    void
    priority (const priority_type& x);

    void
    priority (const priority_optional& x);

    void
    priority (::std::unique_ptr< priority_type > p);

    // status
    //
    typedef ::icalendar_2_0::StatusPropType status_type;
    typedef ::xsd::cxx::tree::optional< status_type > status_optional;
    typedef ::xsd::cxx::tree::traits< status_type, char > status_traits;

    const status_optional&
    status () const;

    status_optional&
    status ();

    void
    status (const status_type& x);

    void
    status (const status_optional& x);

    void
    status (::std::unique_ptr< status_type > p);

    // location
    //
    typedef ::icalendar_2_0::LocationPropType location_type;
    typedef ::xsd::cxx::tree::optional< location_type > location_optional;
    typedef ::xsd::cxx::tree::traits< location_type, char > location_traits;

    const location_optional&
    location () const;

    location_optional&
    location ();

    void
    location (const location_type& x);

    void
    location (const location_optional& x);

    void
    location (::std::unique_ptr< location_type > p);

    // organizer
    //
    typedef ::icalendar_2_0::OrganizerPropType organizer_type;
    typedef ::xsd::cxx::tree::optional< organizer_type > organizer_optional;
    typedef ::xsd::cxx::tree::traits< organizer_type, char > organizer_traits;

    const organizer_optional&
    organizer () const;

    organizer_optional&
    organizer ();

    void
    organizer (const organizer_type& x);

    void
    organizer (const organizer_optional& x);

    void
    organizer (::std::unique_ptr< organizer_type > p);

    // url
    //
    typedef ::icalendar_2_0::UrlPropType url_type;
    typedef ::xsd::cxx::tree::optional< url_type > url_optional;
    typedef ::xsd::cxx::tree::traits< url_type, char > url_traits;

    const url_optional&
    url () const;

    url_optional&
    url ();

    void
    url (const url_type& x);

    void
    url (const url_optional& x);

    void
    url (::std::unique_ptr< url_type > p);

    // attendee
    //
    typedef ::icalendar_2_0::AttendeePropType attendee_type;
    typedef ::xsd::cxx::tree::sequence< attendee_type > attendee_sequence;
    typedef attendee_sequence::iterator attendee_iterator;
    typedef attendee_sequence::const_iterator attendee_const_iterator;
    typedef ::xsd::cxx::tree::traits< attendee_type, char > attendee_traits;

    const attendee_sequence&
    attendee () const;

    attendee_sequence&
    attendee ();

    void
    attendee (const attendee_sequence& s);

    // attach
    //
    typedef ::icalendar_2_0::AttachPropType attach_type;
    typedef ::xsd::cxx::tree::sequence< attach_type > attach_sequence;
    typedef attach_sequence::iterator attach_iterator;
    typedef attach_sequence::const_iterator attach_const_iterator;
    typedef ::xsd::cxx::tree::traits< attach_type, char > attach_traits;

    const attach_sequence&
    attach () const;

    attach_sequence&
    attach ();

    void
    attach (const attach_sequence& s);

    // x-custom
    //
    typedef ::icalendar_2_0::CustomType x_custom_type;
    typedef ::xsd::cxx::tree::sequence< x_custom_type > x_custom_sequence;
    typedef x_custom_sequence::iterator x_custom_iterator;
    typedef x_custom_sequence::const_iterator x_custom_const_iterator;
    typedef ::xsd::cxx::tree::traits< x_custom_type, char > x_custom_traits;

    const x_custom_sequence&
    x_custom () const;

    x_custom_sequence&
    x_custom ();

    void
    x_custom (const x_custom_sequence& s);

    // Constructors.
    //
    properties1 (const uid_type&,
                 const created_type&,
                 const dtstamp_type&);

    properties1 (::std::unique_ptr< uid_type >,
                 ::std::unique_ptr< created_type >,
                 ::std::unique_ptr< dtstamp_type >);

    properties1 (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    properties1 (const properties1& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual properties1*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    properties1&
    operator= (const properties1& x);

    virtual 
    ~properties1 ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< created_type > created_;
    ::xsd::cxx::tree::one< dtstamp_type > dtstamp_;
    sequence_optional sequence_;
    class_optional class__;
    categories_optional categories_;
    dtstart_optional dtstart_;
    dtend_optional dtend_;
    duration_optional duration_;
    transp_optional transp_;
    rrule_optional rrule_;
    rdate_optional rdate_;
    exdate_optional exdate_;
    recurrence_id_optional recurrence_id_;
    summary_optional summary_;
    description_optional description_;
    comment_optional comment_;
    priority_optional priority_;
    status_optional status_;
    location_optional location_;
    organizer_optional organizer_;
    url_optional url_;
    attendee_sequence attendee_;
    attach_sequence attach_;
    x_custom_sequence x_custom_;
  };

  class components: public ::xml_schema::type
  {
    public:
    // valarm
    //
    typedef ::icalendar_2_0::ValarmType valarm_type;
    typedef ::xsd::cxx::tree::sequence< valarm_type > valarm_sequence;
    typedef valarm_sequence::iterator valarm_iterator;
    typedef valarm_sequence::const_iterator valarm_const_iterator;
    typedef ::xsd::cxx::tree::traits< valarm_type, char > valarm_traits;

    const valarm_sequence&
    valarm () const;

    valarm_sequence&
    valarm ();

    void
    valarm (const valarm_sequence& s);

    // Constructors.
    //
    components ();

    components (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    components (const components& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual components*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    components&
    operator= (const components& x);

    virtual 
    ~components ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    valarm_sequence valarm_;
  };

  class properties2: public ::xml_schema::type
  {
    public:
    // uid
    //
    typedef ::icalendar_2_0::UidPropType uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // created
    //
    typedef ::icalendar_2_0::CreatedPropType created_type;
    typedef ::xsd::cxx::tree::traits< created_type, char > created_traits;

    const created_type&
    created () const;

    created_type&
    created ();

    void
    created (const created_type& x);

    void
    created (::std::unique_ptr< created_type > p);

    // dtstamp
    //
    typedef ::icalendar_2_0::DtstampPropType dtstamp_type;
    typedef ::xsd::cxx::tree::traits< dtstamp_type, char > dtstamp_traits;

    const dtstamp_type&
    dtstamp () const;

    dtstamp_type&
    dtstamp ();

    void
    dtstamp (const dtstamp_type& x);

    void
    dtstamp (::std::unique_ptr< dtstamp_type > p);

    // sequence
    //
    typedef ::icalendar_2_0::SequencePropType sequence_type;
    typedef ::xsd::cxx::tree::optional< sequence_type > sequence_optional;
    typedef ::xsd::cxx::tree::traits< sequence_type, char > sequence_traits;

    const sequence_optional&
    sequence () const;

    sequence_optional&
    sequence ();

    void
    sequence (const sequence_type& x);

    void
    sequence (const sequence_optional& x);

    void
    sequence (::std::unique_ptr< sequence_type > p);

    // class
    //
    typedef ::icalendar_2_0::ClassPropType class_type;
    typedef ::xsd::cxx::tree::optional< class_type > class_optional;
    typedef ::xsd::cxx::tree::traits< class_type, char > class_traits;

    const class_optional&
    class_ () const;

    class_optional&
    class_ ();

    void
    class_ (const class_type& x);

    void
    class_ (const class_optional& x);

    void
    class_ (::std::unique_ptr< class_type > p);

    // categories
    //
    typedef ::icalendar_2_0::CategoriesPropType categories_type;
    typedef ::xsd::cxx::tree::optional< categories_type > categories_optional;
    typedef ::xsd::cxx::tree::traits< categories_type, char > categories_traits;

    const categories_optional&
    categories () const;

    categories_optional&
    categories ();

    void
    categories (const categories_type& x);

    void
    categories (const categories_optional& x);

    void
    categories (::std::unique_ptr< categories_type > p);

    // related-to
    //
    typedef ::icalendar_2_0::RelatedToPropType related_to_type;
    typedef ::xsd::cxx::tree::sequence< related_to_type > related_to_sequence;
    typedef related_to_sequence::iterator related_to_iterator;
    typedef related_to_sequence::const_iterator related_to_const_iterator;
    typedef ::xsd::cxx::tree::traits< related_to_type, char > related_to_traits;

    const related_to_sequence&
    related_to () const;

    related_to_sequence&
    related_to ();

    void
    related_to (const related_to_sequence& s);

    // dtstart
    //
    typedef ::icalendar_2_0::DtstartPropType dtstart_type;
    typedef ::xsd::cxx::tree::optional< dtstart_type > dtstart_optional;
    typedef ::xsd::cxx::tree::traits< dtstart_type, char > dtstart_traits;

    const dtstart_optional&
    dtstart () const;

    dtstart_optional&
    dtstart ();

    void
    dtstart (const dtstart_type& x);

    void
    dtstart (const dtstart_optional& x);

    void
    dtstart (::std::unique_ptr< dtstart_type > p);

    // due
    //
    typedef ::icalendar_2_0::DuePropType due_type;
    typedef ::xsd::cxx::tree::optional< due_type > due_optional;
    typedef ::xsd::cxx::tree::traits< due_type, char > due_traits;

    const due_optional&
    due () const;

    due_optional&
    due ();

    void
    due (const due_type& x);

    void
    due (const due_optional& x);

    void
    due (::std::unique_ptr< due_type > p);

    // rrule
    //
    typedef ::icalendar_2_0::RrulePropType rrule_type;
    typedef ::xsd::cxx::tree::optional< rrule_type > rrule_optional;
    typedef ::xsd::cxx::tree::traits< rrule_type, char > rrule_traits;

    const rrule_optional&
    rrule () const;

    rrule_optional&
    rrule ();

    void
    rrule (const rrule_type& x);

    void
    rrule (const rrule_optional& x);

    void
    rrule (::std::unique_ptr< rrule_type > p);

    // rdate
    //
    typedef ::icalendar_2_0::RdatePropType rdate_type;
    typedef ::xsd::cxx::tree::optional< rdate_type > rdate_optional;
    typedef ::xsd::cxx::tree::traits< rdate_type, char > rdate_traits;

    const rdate_optional&
    rdate () const;

    rdate_optional&
    rdate ();

    void
    rdate (const rdate_type& x);

    void
    rdate (const rdate_optional& x);

    void
    rdate (::std::unique_ptr< rdate_type > p);

    // exdate
    //
    typedef ::icalendar_2_0::ExdatePropType exdate_type;
    typedef ::xsd::cxx::tree::optional< exdate_type > exdate_optional;
    typedef ::xsd::cxx::tree::traits< exdate_type, char > exdate_traits;

    const exdate_optional&
    exdate () const;

    exdate_optional&
    exdate ();

    void
    exdate (const exdate_type& x);

    void
    exdate (const exdate_optional& x);

    void
    exdate (::std::unique_ptr< exdate_type > p);

    // recurrence-id
    //
    typedef ::icalendar_2_0::RecurrenceIdPropType recurrence_id_type;
    typedef ::xsd::cxx::tree::optional< recurrence_id_type > recurrence_id_optional;
    typedef ::xsd::cxx::tree::traits< recurrence_id_type, char > recurrence_id_traits;

    const recurrence_id_optional&
    recurrence_id () const;

    recurrence_id_optional&
    recurrence_id ();

    void
    recurrence_id (const recurrence_id_type& x);

    void
    recurrence_id (const recurrence_id_optional& x);

    void
    recurrence_id (::std::unique_ptr< recurrence_id_type > p);

    // summary
    //
    typedef ::icalendar_2_0::SummaryPropType summary_type;
    typedef ::xsd::cxx::tree::optional< summary_type > summary_optional;
    typedef ::xsd::cxx::tree::traits< summary_type, char > summary_traits;

    const summary_optional&
    summary () const;

    summary_optional&
    summary ();

    void
    summary (const summary_type& x);

    void
    summary (const summary_optional& x);

    void
    summary (::std::unique_ptr< summary_type > p);

    // description
    //
    typedef ::icalendar_2_0::DescriptionPropType description_type;
    typedef ::xsd::cxx::tree::optional< description_type > description_optional;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_optional&
    description () const;

    description_optional&
    description ();

    void
    description (const description_type& x);

    void
    description (const description_optional& x);

    void
    description (::std::unique_ptr< description_type > p);

    // comment
    //
    typedef ::icalendar_2_0::CommentPropType comment_type;
    typedef ::xsd::cxx::tree::optional< comment_type > comment_optional;
    typedef ::xsd::cxx::tree::traits< comment_type, char > comment_traits;

    const comment_optional&
    comment () const;

    comment_optional&
    comment ();

    void
    comment (const comment_type& x);

    void
    comment (const comment_optional& x);

    void
    comment (::std::unique_ptr< comment_type > p);

    // priority
    //
    typedef ::icalendar_2_0::PriorityPropType priority_type;
    typedef ::xsd::cxx::tree::optional< priority_type > priority_optional;
    typedef ::xsd::cxx::tree::traits< priority_type, char > priority_traits;

    const priority_optional&
    priority () const;

    priority_optional&
    priority ();

    void
    priority (const priority_type& x);

    void
    priority (const priority_optional& x);

    void
    priority (::std::unique_ptr< priority_type > p);

    // status
    //
    typedef ::icalendar_2_0::StatusPropType status_type;
    typedef ::xsd::cxx::tree::optional< status_type > status_optional;
    typedef ::xsd::cxx::tree::traits< status_type, char > status_traits;

    const status_optional&
    status () const;

    status_optional&
    status ();

    void
    status (const status_type& x);

    void
    status (const status_optional& x);

    void
    status (::std::unique_ptr< status_type > p);

    // percent-complete
    //
    typedef ::icalendar_2_0::PercentCompletePropType percent_complete_type;
    typedef ::xsd::cxx::tree::optional< percent_complete_type > percent_complete_optional;
    typedef ::xsd::cxx::tree::traits< percent_complete_type, char > percent_complete_traits;

    const percent_complete_optional&
    percent_complete () const;

    percent_complete_optional&
    percent_complete ();

    void
    percent_complete (const percent_complete_type& x);

    void
    percent_complete (const percent_complete_optional& x);

    void
    percent_complete (::std::unique_ptr< percent_complete_type > p);

    // location
    //
    typedef ::icalendar_2_0::LocationPropType location_type;
    typedef ::xsd::cxx::tree::optional< location_type > location_optional;
    typedef ::xsd::cxx::tree::traits< location_type, char > location_traits;

    const location_optional&
    location () const;

    location_optional&
    location ();

    void
    location (const location_type& x);

    void
    location (const location_optional& x);

    void
    location (::std::unique_ptr< location_type > p);

    // organizer
    //
    typedef ::icalendar_2_0::OrganizerPropType organizer_type;
    typedef ::xsd::cxx::tree::optional< organizer_type > organizer_optional;
    typedef ::xsd::cxx::tree::traits< organizer_type, char > organizer_traits;

    const organizer_optional&
    organizer () const;

    organizer_optional&
    organizer ();

    void
    organizer (const organizer_type& x);

    void
    organizer (const organizer_optional& x);

    void
    organizer (::std::unique_ptr< organizer_type > p);

    // url
    //
    typedef ::icalendar_2_0::UrlPropType url_type;
    typedef ::xsd::cxx::tree::optional< url_type > url_optional;
    typedef ::xsd::cxx::tree::traits< url_type, char > url_traits;

    const url_optional&
    url () const;

    url_optional&
    url ();

    void
    url (const url_type& x);

    void
    url (const url_optional& x);

    void
    url (::std::unique_ptr< url_type > p);

    // attendee
    //
    typedef ::icalendar_2_0::AttendeePropType attendee_type;
    typedef ::xsd::cxx::tree::sequence< attendee_type > attendee_sequence;
    typedef attendee_sequence::iterator attendee_iterator;
    typedef attendee_sequence::const_iterator attendee_const_iterator;
    typedef ::xsd::cxx::tree::traits< attendee_type, char > attendee_traits;

    const attendee_sequence&
    attendee () const;

    attendee_sequence&
    attendee ();

    void
    attendee (const attendee_sequence& s);

    // attach
    //
    typedef ::icalendar_2_0::AttachPropType attach_type;
    typedef ::xsd::cxx::tree::sequence< attach_type > attach_sequence;
    typedef attach_sequence::iterator attach_iterator;
    typedef attach_sequence::const_iterator attach_const_iterator;
    typedef ::xsd::cxx::tree::traits< attach_type, char > attach_traits;

    const attach_sequence&
    attach () const;

    attach_sequence&
    attach ();

    void
    attach (const attach_sequence& s);

    // x-custom
    //
    typedef ::icalendar_2_0::CustomType x_custom_type;
    typedef ::xsd::cxx::tree::sequence< x_custom_type > x_custom_sequence;
    typedef x_custom_sequence::iterator x_custom_iterator;
    typedef x_custom_sequence::const_iterator x_custom_const_iterator;
    typedef ::xsd::cxx::tree::traits< x_custom_type, char > x_custom_traits;

    const x_custom_sequence&
    x_custom () const;

    x_custom_sequence&
    x_custom ();

    void
    x_custom (const x_custom_sequence& s);

    // Constructors.
    //
    properties2 (const uid_type&,
                 const created_type&,
                 const dtstamp_type&);

    properties2 (::std::unique_ptr< uid_type >,
                 ::std::unique_ptr< created_type >,
                 ::std::unique_ptr< dtstamp_type >);

    properties2 (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    properties2 (const properties2& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual properties2*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    properties2&
    operator= (const properties2& x);

    virtual 
    ~properties2 ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< created_type > created_;
    ::xsd::cxx::tree::one< dtstamp_type > dtstamp_;
    sequence_optional sequence_;
    class_optional class__;
    categories_optional categories_;
    related_to_sequence related_to_;
    dtstart_optional dtstart_;
    due_optional due_;
    rrule_optional rrule_;
    rdate_optional rdate_;
    exdate_optional exdate_;
    recurrence_id_optional recurrence_id_;
    summary_optional summary_;
    description_optional description_;
    comment_optional comment_;
    priority_optional priority_;
    status_optional status_;
    percent_complete_optional percent_complete_;
    location_optional location_;
    organizer_optional organizer_;
    url_optional url_;
    attendee_sequence attendee_;
    attach_sequence attach_;
    x_custom_sequence x_custom_;
  };

  class properties3: public ::xml_schema::type
  {
    public:
    // uid
    //
    typedef ::icalendar_2_0::UidPropType uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // created
    //
    typedef ::icalendar_2_0::CreatedPropType created_type;
    typedef ::xsd::cxx::tree::traits< created_type, char > created_traits;

    const created_type&
    created () const;

    created_type&
    created ();

    void
    created (const created_type& x);

    void
    created (::std::unique_ptr< created_type > p);

    // dtstamp
    //
    typedef ::icalendar_2_0::DtstampPropType dtstamp_type;
    typedef ::xsd::cxx::tree::traits< dtstamp_type, char > dtstamp_traits;

    const dtstamp_type&
    dtstamp () const;

    dtstamp_type&
    dtstamp ();

    void
    dtstamp (const dtstamp_type& x);

    void
    dtstamp (::std::unique_ptr< dtstamp_type > p);

    // sequence
    //
    typedef ::icalendar_2_0::SequencePropType sequence_type;
    typedef ::xsd::cxx::tree::optional< sequence_type > sequence_optional;
    typedef ::xsd::cxx::tree::traits< sequence_type, char > sequence_traits;

    const sequence_optional&
    sequence () const;

    sequence_optional&
    sequence ();

    void
    sequence (const sequence_type& x);

    void
    sequence (const sequence_optional& x);

    void
    sequence (::std::unique_ptr< sequence_type > p);

    // class
    //
    typedef ::icalendar_2_0::ClassPropType class_type;
    typedef ::xsd::cxx::tree::optional< class_type > class_optional;
    typedef ::xsd::cxx::tree::traits< class_type, char > class_traits;

    const class_optional&
    class_ () const;

    class_optional&
    class_ ();

    void
    class_ (const class_type& x);

    void
    class_ (const class_optional& x);

    void
    class_ (::std::unique_ptr< class_type > p);

    // categories
    //
    typedef ::icalendar_2_0::CategoriesPropType categories_type;
    typedef ::xsd::cxx::tree::optional< categories_type > categories_optional;
    typedef ::xsd::cxx::tree::traits< categories_type, char > categories_traits;

    const categories_optional&
    categories () const;

    categories_optional&
    categories ();

    void
    categories (const categories_type& x);

    void
    categories (const categories_optional& x);

    void
    categories (::std::unique_ptr< categories_type > p);

    // related-to
    //
    typedef ::icalendar_2_0::RelatedToPropType related_to_type;
    typedef ::xsd::cxx::tree::sequence< related_to_type > related_to_sequence;
    typedef related_to_sequence::iterator related_to_iterator;
    typedef related_to_sequence::const_iterator related_to_const_iterator;
    typedef ::xsd::cxx::tree::traits< related_to_type, char > related_to_traits;

    const related_to_sequence&
    related_to () const;

    related_to_sequence&
    related_to ();

    void
    related_to (const related_to_sequence& s);

    // dtstart
    //
    typedef ::icalendar_2_0::DtstartPropType dtstart_type;
    typedef ::xsd::cxx::tree::optional< dtstart_type > dtstart_optional;
    typedef ::xsd::cxx::tree::traits< dtstart_type, char > dtstart_traits;

    const dtstart_optional&
    dtstart () const;

    dtstart_optional&
    dtstart ();

    void
    dtstart (const dtstart_type& x);

    void
    dtstart (const dtstart_optional& x);

    void
    dtstart (::std::unique_ptr< dtstart_type > p);

    // summary
    //
    typedef ::icalendar_2_0::SummaryPropType summary_type;
    typedef ::xsd::cxx::tree::optional< summary_type > summary_optional;
    typedef ::xsd::cxx::tree::traits< summary_type, char > summary_traits;

    const summary_optional&
    summary () const;

    summary_optional&
    summary ();

    void
    summary (const summary_type& x);

    void
    summary (const summary_optional& x);

    void
    summary (::std::unique_ptr< summary_type > p);

    // description
    //
    typedef ::icalendar_2_0::DescriptionPropType description_type;
    typedef ::xsd::cxx::tree::optional< description_type > description_optional;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_optional&
    description () const;

    description_optional&
    description ();

    void
    description (const description_type& x);

    void
    description (const description_optional& x);

    void
    description (::std::unique_ptr< description_type > p);

    // comment
    //
    typedef ::icalendar_2_0::CommentPropType comment_type;
    typedef ::xsd::cxx::tree::optional< comment_type > comment_optional;
    typedef ::xsd::cxx::tree::traits< comment_type, char > comment_traits;

    const comment_optional&
    comment () const;

    comment_optional&
    comment ();

    void
    comment (const comment_type& x);

    void
    comment (const comment_optional& x);

    void
    comment (::std::unique_ptr< comment_type > p);

    // status
    //
    typedef ::icalendar_2_0::StatusPropType status_type;
    typedef ::xsd::cxx::tree::optional< status_type > status_optional;
    typedef ::xsd::cxx::tree::traits< status_type, char > status_traits;

    const status_optional&
    status () const;

    status_optional&
    status ();

    void
    status (const status_type& x);

    void
    status (const status_optional& x);

    void
    status (::std::unique_ptr< status_type > p);

    // contact
    //
    typedef ::icalendar_2_0::ContactPropType contact_type;
    typedef ::xsd::cxx::tree::optional< contact_type > contact_optional;
    typedef ::xsd::cxx::tree::traits< contact_type, char > contact_traits;

    const contact_optional&
    contact () const;

    contact_optional&
    contact ();

    void
    contact (const contact_type& x);

    void
    contact (const contact_optional& x);

    void
    contact (::std::unique_ptr< contact_type > p);

    // attendee
    //
    typedef ::icalendar_2_0::AttendeePropType attendee_type;
    typedef ::xsd::cxx::tree::sequence< attendee_type > attendee_sequence;
    typedef attendee_sequence::iterator attendee_iterator;
    typedef attendee_sequence::const_iterator attendee_const_iterator;
    typedef ::xsd::cxx::tree::traits< attendee_type, char > attendee_traits;

    const attendee_sequence&
    attendee () const;

    attendee_sequence&
    attendee ();

    void
    attendee (const attendee_sequence& s);

    // attach
    //
    typedef ::icalendar_2_0::AttachPropType attach_type;
    typedef ::xsd::cxx::tree::sequence< attach_type > attach_sequence;
    typedef attach_sequence::iterator attach_iterator;
    typedef attach_sequence::const_iterator attach_const_iterator;
    typedef ::xsd::cxx::tree::traits< attach_type, char > attach_traits;

    const attach_sequence&
    attach () const;

    attach_sequence&
    attach ();

    void
    attach (const attach_sequence& s);

    // x-custom
    //
    typedef ::icalendar_2_0::CustomType x_custom_type;
    typedef ::xsd::cxx::tree::sequence< x_custom_type > x_custom_sequence;
    typedef x_custom_sequence::iterator x_custom_iterator;
    typedef x_custom_sequence::const_iterator x_custom_const_iterator;
    typedef ::xsd::cxx::tree::traits< x_custom_type, char > x_custom_traits;

    const x_custom_sequence&
    x_custom () const;

    x_custom_sequence&
    x_custom ();

    void
    x_custom (const x_custom_sequence& s);

    // Constructors.
    //
    properties3 (const uid_type&,
                 const created_type&,
                 const dtstamp_type&);

    properties3 (::std::unique_ptr< uid_type >,
                 ::std::unique_ptr< created_type >,
                 ::std::unique_ptr< dtstamp_type >);

    properties3 (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    properties3 (const properties3& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual properties3*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    properties3&
    operator= (const properties3& x);

    virtual 
    ~properties3 ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< created_type > created_;
    ::xsd::cxx::tree::one< dtstamp_type > dtstamp_;
    sequence_optional sequence_;
    class_optional class__;
    categories_optional categories_;
    related_to_sequence related_to_;
    dtstart_optional dtstart_;
    summary_optional summary_;
    description_optional description_;
    comment_optional comment_;
    status_optional status_;
    contact_optional contact_;
    attendee_sequence attendee_;
    attach_sequence attach_;
    x_custom_sequence x_custom_;
  };

  class properties4: public ::xml_schema::type
  {
    public:
    // uid
    //
    typedef ::icalendar_2_0::UidPropType uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // dtstamp
    //
    typedef ::icalendar_2_0::DtstampPropType dtstamp_type;
    typedef ::xsd::cxx::tree::traits< dtstamp_type, char > dtstamp_traits;

    const dtstamp_type&
    dtstamp () const;

    dtstamp_type&
    dtstamp ();

    void
    dtstamp (const dtstamp_type& x);

    void
    dtstamp (::std::unique_ptr< dtstamp_type > p);

    // dtstart
    //
    typedef ::icalendar_2_0::DtstartPropType dtstart_type;
    typedef ::xsd::cxx::tree::optional< dtstart_type > dtstart_optional;
    typedef ::xsd::cxx::tree::traits< dtstart_type, char > dtstart_traits;

    const dtstart_optional&
    dtstart () const;

    dtstart_optional&
    dtstart ();

    void
    dtstart (const dtstart_type& x);

    void
    dtstart (const dtstart_optional& x);

    void
    dtstart (::std::unique_ptr< dtstart_type > p);

    // dtend
    //
    typedef ::icalendar_2_0::DtendPropType dtend_type;
    typedef ::xsd::cxx::tree::optional< dtend_type > dtend_optional;
    typedef ::xsd::cxx::tree::traits< dtend_type, char > dtend_traits;

    const dtend_optional&
    dtend () const;

    dtend_optional&
    dtend ();

    void
    dtend (const dtend_type& x);

    void
    dtend (const dtend_optional& x);

    void
    dtend (::std::unique_ptr< dtend_type > p);

    // organizer
    //
    typedef ::icalendar_2_0::OrganizerPropType organizer_type;
    typedef ::xsd::cxx::tree::optional< organizer_type > organizer_optional;
    typedef ::xsd::cxx::tree::traits< organizer_type, char > organizer_traits;

    const organizer_optional&
    organizer () const;

    organizer_optional&
    organizer ();

    void
    organizer (const organizer_type& x);

    void
    organizer (const organizer_optional& x);

    void
    organizer (::std::unique_ptr< organizer_type > p);

    // freebusy
    //
    typedef ::icalendar_2_0::FreebusyPropType freebusy_type;
    typedef ::xsd::cxx::tree::sequence< freebusy_type > freebusy_sequence;
    typedef freebusy_sequence::iterator freebusy_iterator;
    typedef freebusy_sequence::const_iterator freebusy_const_iterator;
    typedef ::xsd::cxx::tree::traits< freebusy_type, char > freebusy_traits;

    const freebusy_sequence&
    freebusy () const;

    freebusy_sequence&
    freebusy ();

    void
    freebusy (const freebusy_sequence& s);

    // Constructors.
    //
    properties4 (const uid_type&,
                 const dtstamp_type&);

    properties4 (::std::unique_ptr< uid_type >,
                 ::std::unique_ptr< dtstamp_type >);

    properties4 (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    properties4 (const properties4& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual properties4*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    properties4&
    operator= (const properties4& x);

    virtual 
    ~properties4 ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< dtstamp_type > dtstamp_;
    dtstart_optional dtstart_;
    dtend_optional dtend_;
    organizer_optional organizer_;
    freebusy_sequence freebusy_;
  };

  class properties5: public ::xml_schema::type
  {
    public:
    // prodid
    //
    typedef ::icalendar_2_0::ProdidPropType prodid_type;
    typedef ::xsd::cxx::tree::traits< prodid_type, char > prodid_traits;

    const prodid_type&
    prodid () const;

    prodid_type&
    prodid ();

    void
    prodid (const prodid_type& x);

    void
    prodid (::std::unique_ptr< prodid_type > p);

    // version
    //
    typedef ::icalendar_2_0::VersionPropType version_type;
    typedef ::xsd::cxx::tree::traits< version_type, char > version_traits;

    const version_type&
    version () const;

    version_type&
    version ();

    void
    version (const version_type& x);

    void
    version (::std::unique_ptr< version_type > p);

    // x-kolab-version
    //
    typedef ::icalendar_2_0::KolabVersion x_kolab_version_type;
    typedef ::xsd::cxx::tree::traits< x_kolab_version_type, char > x_kolab_version_traits;

    const x_kolab_version_type&
    x_kolab_version () const;

    x_kolab_version_type&
    x_kolab_version ();

    void
    x_kolab_version (const x_kolab_version_type& x);

    void
    x_kolab_version (::std::unique_ptr< x_kolab_version_type > p);

    // Constructors.
    //
    properties5 (const prodid_type&,
                 const version_type&,
                 const x_kolab_version_type&);

    properties5 (::std::unique_ptr< prodid_type >,
                 ::std::unique_ptr< version_type >,
                 ::std::unique_ptr< x_kolab_version_type >);

    properties5 (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    properties5 (const properties5& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual properties5*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    properties5&
    operator= (const properties5& x);

    virtual 
    ~properties5 ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< prodid_type > prodid_;
    ::xsd::cxx::tree::one< version_type > version_;
    ::xsd::cxx::tree::one< x_kolab_version_type > x_kolab_version_;
  };

  class components1: public ::xml_schema::type
  {
    public:
    // vevent
    //
    typedef ::icalendar_2_0::KolabEvent vevent_type;
    typedef ::xsd::cxx::tree::sequence< vevent_type > vevent_sequence;
    typedef vevent_sequence::iterator vevent_iterator;
    typedef vevent_sequence::const_iterator vevent_const_iterator;
    typedef ::xsd::cxx::tree::traits< vevent_type, char > vevent_traits;

    const vevent_sequence&
    vevent () const;

    vevent_sequence&
    vevent ();

    void
    vevent (const vevent_sequence& s);

    // vtodo
    //
    typedef ::icalendar_2_0::KolabTodo vtodo_type;
    typedef ::xsd::cxx::tree::sequence< vtodo_type > vtodo_sequence;
    typedef vtodo_sequence::iterator vtodo_iterator;
    typedef vtodo_sequence::const_iterator vtodo_const_iterator;
    typedef ::xsd::cxx::tree::traits< vtodo_type, char > vtodo_traits;

    const vtodo_sequence&
    vtodo () const;

    vtodo_sequence&
    vtodo ();

    void
    vtodo (const vtodo_sequence& s);

    // vjournal
    //
    typedef ::icalendar_2_0::KolabJournal vjournal_type;
    typedef ::xsd::cxx::tree::sequence< vjournal_type > vjournal_sequence;
    typedef vjournal_sequence::iterator vjournal_iterator;
    typedef vjournal_sequence::const_iterator vjournal_const_iterator;
    typedef ::xsd::cxx::tree::traits< vjournal_type, char > vjournal_traits;

    const vjournal_sequence&
    vjournal () const;

    vjournal_sequence&
    vjournal ();

    void
    vjournal (const vjournal_sequence& s);

    // vfreebusy
    //
    typedef ::icalendar_2_0::KolabFreebusy vfreebusy_type;
    typedef ::xsd::cxx::tree::sequence< vfreebusy_type > vfreebusy_sequence;
    typedef vfreebusy_sequence::iterator vfreebusy_iterator;
    typedef vfreebusy_sequence::const_iterator vfreebusy_const_iterator;
    typedef ::xsd::cxx::tree::traits< vfreebusy_type, char > vfreebusy_traits;

    const vfreebusy_sequence&
    vfreebusy () const;

    vfreebusy_sequence&
    vfreebusy ();

    void
    vfreebusy (const vfreebusy_sequence& s);

    // Constructors.
    //
    components1 ();

    components1 (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    components1 (const components1& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual components1*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    components1&
    operator= (const components1& x);

    virtual 
    ~components1 ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    vevent_sequence vevent_;
    vtodo_sequence vtodo_;
    vjournal_sequence vjournal_;
    vfreebusy_sequence vfreebusy_;
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace icalendar_2_0
{
  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (const ::std::string& uri,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (const ::std::string& uri,
             ::xml_schema::error_handler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (const ::std::string& uri,
             ::xercesc::DOMErrorHandler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::std::istream& is,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::std::istream& is,
             ::xml_schema::error_handler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::std::istream& is,
             ::xercesc::DOMErrorHandler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::std::istream& is,
             const ::std::string& id,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::std::istream& is,
             const ::std::string& id,
             ::xml_schema::error_handler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::std::istream& is,
             const ::std::string& id,
             ::xercesc::DOMErrorHandler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::xercesc::InputSource& is,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::xercesc::InputSource& is,
             ::xml_schema::error_handler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::xercesc::InputSource& is,
             ::xercesc::DOMErrorHandler& eh,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (const ::xercesc::DOMDocument& d,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::icalendar_2_0::IcalendarType >
  icalendar (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
             ::xml_schema::flags f = 0,
             const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement&, const XlabelParamType&);

  void
  operator<< (::xercesc::DOMElement&, const XuidParamType&);

  void
  operator<< (::xercesc::DOMElement&, const XFBevent&);

  void
  operator<< (::xercesc::DOMElement&, const KolabVersion&);

  void
  operator<< (::xercesc::DOMElement&, const CustomType&);

  void
  operator<< (::xercesc::DOMElement&, const ContactType&);

  void
  operator<< (::xercesc::DOMElement&, const ValarmType&);

  void
  operator<< (::xercesc::DOMElement&, const KolabEvent&);

  void
  operator<< (::xercesc::DOMElement&, const KolabTodo&);

  void
  operator<< (::xercesc::DOMElement&, const KolabJournal&);

  void
  operator<< (::xercesc::DOMElement&, const KolabFreebusy&);

  void
  operator<< (::xercesc::DOMElement&, const VcalendarType&);

  void
  operator<< (::xercesc::DOMElement&, const IcalendarType&);

  // Serialize to std::ostream.
  //

  void
  icalendar (::std::ostream& os,
             const ::icalendar_2_0::IcalendarType& x, 
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             const ::std::string& e = "UTF-8",
             ::xml_schema::flags f = 0);

  void
  icalendar (::std::ostream& os,
             const ::icalendar_2_0::IcalendarType& x, 
             ::xml_schema::error_handler& eh,
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             const ::std::string& e = "UTF-8",
             ::xml_schema::flags f = 0);

  void
  icalendar (::std::ostream& os,
             const ::icalendar_2_0::IcalendarType& x, 
             ::xercesc::DOMErrorHandler& eh,
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             const ::std::string& e = "UTF-8",
             ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  icalendar (::xercesc::XMLFormatTarget& ft,
             const ::icalendar_2_0::IcalendarType& x, 
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             const ::std::string& e = "UTF-8",
             ::xml_schema::flags f = 0);

  void
  icalendar (::xercesc::XMLFormatTarget& ft,
             const ::icalendar_2_0::IcalendarType& x, 
             ::xml_schema::error_handler& eh,
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             const ::std::string& e = "UTF-8",
             ::xml_schema::flags f = 0);

  void
  icalendar (::xercesc::XMLFormatTarget& ft,
             const ::icalendar_2_0::IcalendarType& x, 
             ::xercesc::DOMErrorHandler& eh,
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             const ::std::string& e = "UTF-8",
             ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  icalendar (::xercesc::DOMDocument& d,
             const ::icalendar_2_0::IcalendarType& x,
             ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  icalendar (const ::icalendar_2_0::IcalendarType& x, 
             const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
             ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const properties&);

  void
  operator<< (::xercesc::DOMElement&, const properties1&);

  void
  operator<< (::xercesc::DOMElement&, const components&);

  void
  operator<< (::xercesc::DOMElement&, const properties2&);

  void
  operator<< (::xercesc::DOMElement&, const properties3&);

  void
  operator<< (::xercesc::DOMElement&, const properties4&);

  void
  operator<< (::xercesc::DOMElement&, const properties5&);

  void
  operator<< (::xercesc::DOMElement&, const components1&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_KOLABFORMAT_XCAL_HXX
