/* ==================================== JUCER_BINARY_RESOURCE ====================================

   This is an auto-generated file: Any edits you make may be overwritten!

*/

#include <cstring>

namespace BinaryData
{

//================== juce_SimpleBinaryBuilder.cpp ==================
static const unsigned char temp_binary_data_60[] =
"/*\r\n"
"  ==============================================================================\r\n"
"\r\n"
"   This file is part of the JUCE library.\r\n"
"   Copyright (c) 2022 - Raw Material Software Limited\r\n"
"\r\n"
"   JUCE is an open source library subject to commercial or open-source\r\n"
"   licensing.\r\n"
"\r\n"
"   By using JUCE, you agree to the terms of both the JUCE 7 End-User License\r\n"
"   Agreement and JUCE Privacy Policy.\r\n"
"\r\n"
"   End User License Agreement: www.juce.com/juce-7-licence\r\n"
"   Privacy Policy: www.juce.com/juce-privacy-policy\r\n"
"\r\n"
"   Or: You may also use this code under the terms of the GPL v3 (see\r\n"
"   www.gnu.org/licenses).\r\n"
"\r\n"
"   JUCE IS PROVIDED \"AS IS\" WITHOUT ANY WARRANTY, AND ALL WARRANTIES, WHETHER\r\n"
"   EXPRESSED OR IMPLIED, INCLUDING MERCHANTABILITY AND FITNESS FOR PURPOSE, ARE\r\n"
"   DISCLAIMED.\r\n"
"\r\n"
"  ==============================================================================\r\n"
"*/\r\n"
"\r\n"
"#include <sys/stat.h>\r\n"
"#include <unistd.h>\r\n"
"\r\n"
"#include <algorithm>\r\n"
"#include <cstdint>\r\n"
"#include <fstream>\r\n"
"#include <iomanip>\r\n"
"#include <iostream>\r\n"
"#include <optional>\r\n"
"#include <vector>\r\n"
"\r\n"
"//==============================================================================\r\n"
"struct FileHelpers\r\n"
"{\r\n"
"    static std::string getCurrentWorkingDirectory()\r\n"
"    {\r\n"
"        std::vector<char> buffer (1024);\r\n"
"\r\n"
"        while (getcwd (buffer.data(), buffer.size() - 1) == nullptr && errno == ERANGE)\r\n"
"            buffer.resize (buffer.size() * 2 / 3);\r\n"
"\r\n"
"        return { buffer.data() };\r\n"
"    }\r\n"
"\r\n"
"    static bool endsWith (const std::string& s, char c)\r\n"
"    {\r\n"
"        if (s.length() == 0)\r\n"
"            return false;\r\n"
"\r\n"
"        return *s.rbegin() == c;\r\n"
"    }\r\n"
"\r\n"
"    static std::string appendedPaths (const std::string& first, const std::string& second)\r\n"
"    {\r\n"
"        return endsWith (first, '/') ? first + second : first + \"/\" + second;\r\n"
"    }\r\n"
"\r\n"
"    static bool exists (const std::string& path)\r\n"
"    {\r\n"
"        return ! path.empty() && access (path.c_str(), F_OK) == 0;\r\n"
"    }\r\n"
"\r\n"
"    static bool deleteFile (const std::string& path)\r\n"
"    {\r\n"
"        if (! exists (path))\r\n"
"            return true;\r\n"
"\r\n"
"        return remove (path.c_str()) == 0;\r\n"
"    }\r\n"
"\r\n"
"    static std::string getFilename (const std::string& path)\r\n"
"    {\r\n"
"        return { std::find_if (path.rbegin(), path.rend(), [] (auto c) { return c == '/'; }).base(),\r\n"
"                 path.end() };\r\n"
"    }\r\n"
"\r\n"
"    static bool isDirectory (const std::string& path)\r\n"
"    {\r\n"
"       #if defined (__FreeBSD__) || defined (__OpenBSD__)\r\n"
"        #define JUCE_STAT stat\r\n"
"       #else\r\n"
"        #define JUCE_STAT stat64\r\n"
"       #endif\r\n"
"\r\n"
"        struct JUCE_STAT info;\r\n"
"\r\n"
"        return    ! path.empty()\r\n"
"               && JUCE_STAT (path.c_str(), &info) == 0\r\n"
"               && ((info.st_mode & S_IFDIR) != 0);\r\n"
"    }\r\n"
"\r\n"
"    static std::string getParentDirectory (const std::string& path)\r\n"
"    {\r\n"
"        std::string p { path.begin(),\r\n"
"                        std::find_if (path.rbegin(),\r\n"
"                                      path.rend(),\r\n"
"                                      [] (auto c) { return c == '/'; }).base() };\r\n"
"\r\n"
"        // Trim the ending slash, but only if not root\r\n"
"        if (endsWith (p, '/') && p.length() > 1)\r\n"
"            return { p.begin(), p.end() - 1 };\r\n"
"\r\n"
"        return p;\r\n"
"    }\r\n"
"\r\n"
"    static bool createDirectory (const std::string& path)\r\n"
"    {\r\n"
"        if (isDirectory (path))\r\n"
"            return true;\r\n"
"\r\n"
"        const auto parentDir = getParentDirectory (path);\r\n"
"\r\n"
"        if (path == parentDir)\r\n"
"            return false;\r\n"
"\r\n"
"        if (createDirectory (parentDir))\r\n"
"            return mkdir (path.c_str(), 0777) != -1;\r\n"
"\r\n"
"        return false;\r\n"
"    }\r\n"
"};\r\n"
"\r\n"
"//==============================================================================\r\n"
"struct StringHelpers\r\n"
"{\r\n"
"    static bool isQuoteCharacter (char c)\r\n"
"    {\r\n"
"        return c == '\"' || c == '\\'';\r\n"
"    }\r\n"
"\r\n"
"    static std::string unquoted (const std::string& str)\r\n"
"    {\r\n"
"        if (str.length() == 0 || (! isQuoteCharacter (str[0])))\r\n"
"            return str;\r\n"
"\r\n"
"        return str.substr (1, str.length() - (isQuoteCharacter (str[str.length() - 1]) ? 1 : 0));\r\n"
"    }\r\n"
"\r\n"
"    static void ltrim (std::string& s)\r\n"
"    {\r\n"
"        s.erase (s.begin(), std::find_if (s.begin(), s.end(), [] (int c) { return ! std::isspace (c); }));\r\n"
"    }\r\n"
"\r\n"
"    static void rtrim (std::string& s)\r\n"
"    {\r\n"
"        s.erase (std::find_if (s.rbegin(), s.rend(), [] (int c) { return ! std::isspace (c); }).base(), s.end());\r\n"
"    }\r\n"
"\r\n"
"    static std::string trimmed (const std::string& str)\r\n"
"    {\r\n"
"        auto result = str;\r\n"
"        ltrim (result);\r\n"
"        rtrim (result);\r\n"
"        return result;\r\n"
"    }\r\n"
"\r\n"
"    static std::string replaced (const std::string& str, char charToReplace, char replaceWith)\r\n"
"    {\r\n"
"        auto result = str;\r\n"
"        std::replace (result.begin(), result.end(), charToReplace, replaceWith);\r\n"
"        return result;\r\n"
"    }\r\n"
"};\r\n"
"\r\n"
"//==============================================================================\r\n"
"static bool addFile (const std::string& filePath,\r\n"
"                     const std::string& binaryNamespace,\r\n"
"                     std::ofstream& headerStream,\r\n"
"                     std::ofstream& cppStream,\r\n"
"                     bool verbose)\r\n"
"{\r\n"
"    std::ifstream fileStream (filePath, std::ios::in | std::ios::binary | std::ios::ate);\r\n"
"\r\n"
"    if (! fileStream.is_open())\r\n"
"    {\r\n"
"        std::cerr << \"Failed to open input file \" << filePath << std::endl;\r\n"
"        return false;\r\n"
"    }\r\n"
"\r\n"
"    std::vector<char> buffer ((size_t) fileStream.tellg());\r\n"
"    fileStream.seekg (0);\r\n"
"    fileStream.read (buffer.data(), static_cast<std::streamsize> (buffer.size()));\r\n"
"\r\n"
"    const auto variableName = StringHelpers::replaced (StringHelpers::replaced (FileHelpers::getFilename (filePath),\r\n"
"                                                                                ' ',\r\n"
"                                                                                '_'),\r\n"
"                                                       '.',\r\n"
"                                                       '_');\r\n"
"\r\n"
"    if (verbose)\r\n"
"    {\r\n"
"        std::cout << \"Adding \" << variableName << \": \"\r\n"
"                  << buffer.size() << \" bytes\" << std::endl;\r\n"
"    }\r\n"
"\r\n"
"    headerStream << \"    extern const char*  \" << variableName << \";\" << std::endl\r\n"
"                 << \"    const int           \" << variableName << \"Size = \"\r\n"
"                 << buffer.size() << \";\" << std::endl;\r\n"
"\r\n"
"    cppStream << \"static const unsigned char temp0[] = {\";\r\n"
"\r\n"
"    auto* data = (const uint8_t*) buffer.data();\r\n"
"\r\n"
"    for (size_t i = 0; i < buffer.size() - 1; ++i)\r\n"
"    {\r\n"
"        cppStream << (int) data[i] << \",\";\r\n"
"\r\n"
"        if ((i % 40) == 39)\r\n"
"            cppStream << std::endl << \"  \";\r\n"
"    }\r\n"
"\r\n"
"    cppStream << (int) data[buffer.size() - 1] << \",0,0};\" << std::endl;\r\n"
"    cppStream << \"const char* \" << binaryNamespace << \"::\" << variableName\r\n"
"              << \" = (const char*) temp0\" << \";\" << std::endl << std::endl;\r\n"
"\r\n"
"    return true;\r\n"
"}\r\n"
"\r\n"
"//==============================================================================\r\n"
"class Arguments\r\n"
"{\r\n"
"public:\r\n"
"    enum class PositionalArguments\r\n"
"    {\r\n"
"        sourceFile = 0,\r\n"
"        targetDirectory,\r\n"
"        targetFilename,\r\n"
"        binaryNamespace\r\n"
"    };\r\n"
"\r\n"
"    static std::optional<Arguments> create (int argc, char* argv[])\r\n"
"    {\r\n"
"        std::vector<std::string> arguments;\r\n"
"        bool verbose = false;\r\n"
"\r\n"
"        for (int i = 1; i < argc; ++i)\r\n"
"        {\r\n"
"            std::string arg { argv[i] };\r\n"
"\r\n"
"            if (arg == \"-v\" || arg == \"--verbose\")\r\n"
"                verbose = true;\r\n"
"            else\r\n"
"                arguments.emplace_back (std::move (arg));\r\n"
"        }\r\n"
"\r\n"
"        if (arguments.size() != static_cast<size_t> (PositionalArguments::binaryNamespace) + 1)\r\n"
"            return std::nullopt;\r\n"
"\r\n"
"        return Arguments { std::move (arguments), verbose };\r\n"
"    }\r\n"
"\r\n"
"    std::string get (PositionalArguments argument) const\r\n"
"    {\r\n"
"        return arguments[static_cast<size_t> (argument)];\r\n"
"    }\r\n"
"\r\n"
"    bool isVerbose() const\r\n"
"    {\r\n"
"        return verbose;\r\n"
"    }\r\n"
"\r\n"
"private:\r\n"
"    Arguments (std::vector<std::string> args, bool verboseIn)\r\n"
"        : arguments (std::move (args)), verbose (verboseIn)\r\n"
"    {\r\n"
"    }\r\n"
"\r\n"
"    std::vector<std::string> arguments;\r\n"
"    bool verbose = false;\r\n"
"};\r\n"
"\r\n"
"//==============================================================================\r\n"
"int main (int argc, char* argv[])\r\n"
"{\r\n"
"    const auto arguments = Arguments::create (argc, argv);\r\n"
"\r\n"
"    if (! arguments.has_value())\r\n"
"    {\r\n"
"        std::cout << \" Usage: SimpleBinaryBuilder  [-v | --verbose] sourcefile targetdirectory targetfilename namespace\"\r\n"
"                                                                                                        << std::endl << std::endl\r\n"
"                  << \" SimpleBinaryBuilder will encode the provided source file into\"                   << std::endl\r\n"
"                  << \" two files called (targetfilename).cpp and (targetfilename).h,\"                   << std::endl\r\n"
"                  << \" which it will write into the specified target directory.\"                        << std::endl\r\n"
"                  << \" The target directory will be automatically created if necessary. The binary\"     << std::endl\r\n"
"                  << \" resource will be available in the given namespace.\"                              << std::endl << std::endl;\r\n"
"\r\n"
"        return 0;\r\n"
"    }\r\n"
"\r\n"
"    const auto currentWorkingDirectory = FileHelpers::getCurrentWorkingDirectory();\r\n"
"\r\n"
"    using ArgType = Arguments::PositionalArguments;\r\n"
"\r\n"
"    const auto sourceFile = FileHelpers::appendedPaths (currentWorkingDirectory,\r\n"
"                                                        StringHelpers::unquoted (arguments->get (ArgType::sourceFile)));\r\n"
"\r\n"
"    if (! FileHelpers::exists (sourceFile))\r\n"
"    {\r\n"
"        std::cerr << \"Source file doesn't exist: \"\r\n"
"                  << sourceFile\r\n"
"                  << std::endl << std::endl;\r\n"
"\r\n"
"        return 1;\r\n"
"    }\r\n"
"\r\n"
"    const auto targetDirectory = FileHelpers::appendedPaths (currentWorkingDirectory,\r\n"
"                                                             StringHelpers::unquoted (arguments->get (ArgType::targetDirectory)));\r\n"
"\r\n"
"    if (! FileHelpers::exists (targetDirectory))\r\n"
"    {\r\n"
"        if (! FileHelpers::createDirectory (targetDirectory))\r\n"
"        {\r\n"
"            std::cerr << \"Failed to create target directory: \" << targetDirectory << std::endl;\r\n"
"            return 1;\r\n"
"        }\r\n"
"    }\r\n"
"\r\n"
"    const auto className = StringHelpers::trimmed (arguments->get (ArgType::targetFilename));\r\n"
"    const auto binaryNamespace = StringHelpers::trimmed (arguments->get (ArgType::binaryNamespace));\r\n"
"\r\n"
"    const auto headerFilePath = FileHelpers::appendedPaths (targetDirectory, className + \".h\");\r\n"
"    const auto cppFilePath    = FileHelpers::appendedPaths (targetDirectory, className + \".cpp\");\r\n"
"\r\n"
"    if (arguments->isVerbose())\r\n"
"    {\r\n"
"        std::cout << \"Creating \" << headerFilePath\r\n"
"                  << \" and \" << cppFilePath\r\n"
"                  << \" from file \" << sourceFile\r\n"
"                  << \"...\" << std::endl << std::endl;\r\n"
"    }\r\n"
"\r\n"
"    if (! FileHelpers::deleteFile (headerFilePath))\r\n"
"    {\r\n"
"        std::cerr << \"Failed to remove old header file: \" << headerFilePath << std::endl;\r\n"
"        return 1;\r\n"
"    }\r\n"
"\r\n"
"    if (! FileHelpers::deleteFile (cppFilePath))\r\n"
"    {\r\n"
"        std::cerr << \"Failed to remove old source file: \" << cppFilePath << std::endl;\r\n"
"        return 1;\r\n"
"    }\r\n"
"\r\n"
"    std::ofstream header (headerFilePath);\r\n"
"\r\n"
"    if (! header.is_open())\r\n"
"    {\r\n"
"        std::cerr << \"Failed to open \" << headerFilePath << std::endl;\r\n"
"\r\n"
"        return 1;\r\n"
"    }\r\n"
"\r\n"
"    std::ofstream cpp (cppFilePath);\r\n"
"\r\n"
"    if (! cpp.is_open())\r\n"
"    {\r\n"
"        std::cerr << \"Failed to open \" << headerFilePath << std::endl;\r\n"
"\r\n"
"        return 1;\r\n"
"    }\r\n"
"\r\n"
"    header << \"/* (Auto-generated binary data file). */\" << std::endl << std::endl\r\n"
"           << \"#pragma once\" << std::endl << std::endl\r\n"
"           << \"namespace \" << binaryNamespace << std::endl\r\n"
"           << \"{\" << std::endl;\r\n"
"\r\n"
"    cpp << \"/* (Auto-generated binary data file). */\" << std::endl << std::endl\r\n"
"        << \"#include \" << std::quoted (className + \".h\") << std::endl << std::endl;\r\n"
"\r\n"
"    if (! addFile (sourceFile, binaryNamespace, header, cpp, arguments->isVerbose()))\r\n"
"        return 1;\r\n"
"\r\n"
"    header << \"}\" << std::endl << std::endl;\r\n"
"\r\n"
"    return 0;\r\n"
"}\r\n";

const char* juce_SimpleBinaryBuilder_cpp = (const char*) temp_binary_data_60;
}
