/* autogenerated - do not edit */
#include <jim.h>
int Jim_binaryInit(Jim_Interp *interp)
{
	if (Jim_PackageProvide(interp, "binary", "1.0", JIM_ERRMSG)) return JIM_ERR;
	return Jim_EvalSource(interp, "binary.tcl", 1, "\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"package require pack\n"
"package require regexp\n"
"\n"
"proc binary {cmd args} {\n"
"	tailcall \"binary $cmd\" {*}$args\n"
"}\n"
"\n"
"proc \"binary format\" {formatString args} {\n"
"	set bitoffset 0\n"
"	set result {}\n"
"\n"
"	foreach {conv t u n} [regexp -all -inline {([^[:space:]])(u)?([*0-9]*)} $formatString] {\n"
"		switch -exact -- $t {\n"
"			a -\n"
"			A {\n"
"				set value [binary::nextarg args]\n"
"				set sn [string bytelength $value]\n"
"				if {$n ne \"*\"} {\n"
"					if {$n eq \"\"} {\n"
"						set n 1\n"
"					}\n"
"					if {$n > $sn} {\n"
"\n"
"						append value [string repeat [dict get {A \" \" a \\x00} $t] $($n - $sn)]\n"
"					}\n"
"				} else {\n"
"					set n $sn\n"
"				}\n"
"				if {$n} {\n"
"					set bitoffset [pack result $value -str $(8 * $n) $bitoffset]\n"
"				}\n"
"			}\n"
"			x {\n"
"				if {$n eq \"*\"} {\n"
"					return -code error {cannot use \"*\" in format string with \"x\"}\n"
"				}\n"
"				if {$n eq \"\"} {\n"
"					set n 1\n"
"				}\n"
"				loop i 0 $n {\n"
"					set bitoffset [pack result 0 -intbe 8 $bitoffset]\n"
"				}\n"
"			}\n"
"			@ {\n"
"				if {$n eq \"\"} {\n"
"					return -code error {missing count for \"@\" field specifier}\n"
"				}\n"
"				if {$n eq \"*\"} {\n"
"					set bitoffset $(8 * [string bytelength $result])\n"
"				} else {\n"
"\n"
"					set max [string bytelength $result]\n"
"					append result [string repeat \\x00 $($n - $max)]\n"
"					set bitoffset $(8 * $n)\n"
"				}\n"
"			}\n"
"			X {\n"
"				if {$n eq \"*\"} {\n"
"					set bitoffset 0\n"
"				} elseif {$n eq \"\"} {\n"
"					incr bitoffset -8\n"
"				} else {\n"
"					incr bitoffset $($n * -8)\n"
"				}\n"
"				if {$bitoffset < 0} {\n"
"					set bitoffset 0\n"
"				}\n"
"			}\n"
"			default {\n"
"				if {![info exists ::binary::scalarinfo($t)]} {\n"
"					return -code error \"bad field specifier \\\"$t\\\"\"\n"
"				}\n"
"\n"
"\n"
"				lassign $::binary::scalarinfo($t) type convtype size prefix\n"
"				set value [binary::nextarg args]\n"
"\n"
"				if {$type in {bin hex}} {\n"
"					set value [split $value {}]\n"
"				}\n"
"				set vn [llength $value]\n"
"				if {$n eq \"*\"} {\n"
"					set n $vn\n"
"				} elseif {$n eq \"\"} {\n"
"					set n 1\n"
"					set value [list $value]\n"
"				} elseif {$vn < $n} {\n"
"					if {$type in {bin hex}} {\n"
"\n"
"						lappend value {*}[lrepeat $($n - $vn) 0]\n"
"					} else {\n"
"						return -code error \"number of elements in list does not match count\"\n"
"					}\n"
"				} elseif {$vn > $n} {\n"
"\n"
"					set value [lrange $value 0 $n-1]\n"
"				}\n"
"\n"
"				set convtype -$::binary::convtype($convtype)\n"
"\n"
"				foreach v $value {\n"
"					set bitoffset [pack result $prefix$v $convtype $size $bitoffset]\n"
"				}\n"
"\n"
"				if {$bitoffset % 8} {\n"
"					set bitoffset [pack result 0 $convtype $(8 - $bitoffset % 8) $bitoffset]\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	return $result\n"
"}\n"
"\n"
"proc \"binary scan\" {value formatString {args varName}} {\n"
"\n"
"\n"
"	set bitoffset 0\n"
"	set count 0\n"
"\n"
"	foreach {conv t u n} [regexp -all -inline {([^[:space:]])(u)?([*0-9]*)} $formatString] {\n"
"		set rembytes $([string bytelength $value] - $bitoffset / 8)\n"
"		switch -exact -- $t {\n"
"			a -\n"
"			A {\n"
"				if {$n eq \"*\"} {\n"
"					set n $rembytes\n"
"				} elseif {$n eq \"\"} {\n"
"					set n 1\n"
"				}\n"
"				if {$n > $rembytes} {\n"
"					break\n"
"				}\n"
"\n"
"				set var [binary::nextarg varName]\n"
"\n"
"				set result [unpack $value -str $bitoffset $($n * 8)]\n"
"				incr bitoffset $([string bytelength $result] * 8)\n"
"				if {$t eq \"A\"} {\n"
"					set result [string trimright $result]\n"
"				}\n"
"			}\n"
"			x {\n"
"\n"
"				if {$n eq \"*\"} {\n"
"					set n $rembytes\n"
"				} elseif {$n eq \"\"} {\n"
"					set n 1\n"
"				}\n"
"				if {$n > $rembytes} {\n"
"					set n $rembytes\n"
"				}\n"
"				incr bitoffset $($n * 8)\n"
"				continue\n"
"			}\n"
"			X {\n"
"\n"
"				if {$n eq \"*\"} {\n"
"					set bitoffset 0\n"
"					continue\n"
"				}\n"
"				if {$n eq \"\"} {\n"
"					set n 1\n"
"				}\n"
"				if {$n * 8 > $bitoffset} {\n"
"					set bitoffset 0\n"
"					continue\n"
"				}\n"
"				incr bitoffset -$($n * 8)\n"
"				continue\n"
"			}\n"
"			@ {\n"
"				if {$n eq \"\"} {\n"
"					return -code error {missing count for \"@\" field specifier}\n"
"				}\n"
"				if {$n eq \"*\" || $n > $rembytes + $bitoffset / 8} {\n"
"					incr bitoffset $($rembytes * 8)\n"
"				} elseif {$n < 0} {\n"
"					set bitoffset 0\n"
"				} else {\n"
"					set bitoffset $($n * 8)\n"
"				}\n"
"				continue\n"
"			}\n"
"			default {\n"
"				if {![info exists ::binary::scalarinfo($t)]} {\n"
"					return -code error \"bad field specifier \\\"$t\\\"\"\n"
"				}\n"
"\n"
"				lassign $::binary::scalarinfo($t) type convtype size prefix\n"
"				set var [binary::nextarg varName]\n"
"\n"
"				if {$n eq \"*\"} {\n"
"					set n $($rembytes * 8 / $size)\n"
"				} else {\n"
"					if {$n eq \"\"} {\n"
"						set n 1\n"
"					}\n"
"				}\n"
"				if {$n * $size > $rembytes * 8} {\n"
"					break\n"
"				}\n"
"\n"
"				if {$type in {hex bin}} {\n"
"					set u u\n"
"				}\n"
"				set convtype -$u$::binary::convtype($convtype)\n"
"\n"
"				set result {}\n"
"				loop i 0 $n {\n"
"					set v [unpack $value $convtype $bitoffset $size]\n"
"					if {$type in {bin hex}} {\n"
"						append result [lindex {0 1 2 3 4 5 6 7 8 9 a b c d e f} $v]\n"
"					} else {\n"
"						lappend result $v\n"
"					}\n"
"					incr bitoffset $size\n"
"				}\n"
"\n"
"				if {$bitoffset % 8} {\n"
"					incr bitoffset $(8 - ($bitoffset % 8))\n"
"				}\n"
"			}\n"
"		}\n"
"		uplevel 1 [list set $var $result]\n"
"		incr count\n"
"	}\n"
"	return $count\n"
"}\n"
"\n"
"\n"
"\n"
"proc binary::nextarg {&arglist} {\n"
"	if {[llength $arglist] == 0} {\n"
"		return -level 2 -code error \"not enough arguments for all format specifiers\"\n"
"	}\n"
"	set arglist [lassign $arglist arg]\n"
"	return $arg\n"
"}\n"
"\n"
"set binary::scalarinfo {\n"
"	c {int be 8}\n"
"	s {int le 16}\n"
"	t {int host 16}\n"
"	S {int be 16}\n"
"	i {int le 32}\n"
"	I {int be 32}\n"
"	n {int host 32}\n"
"	w {int le 64}\n"
"	W {int be 64}\n"
"	m {int host 64}\n"
"	h {hex le 4 0x}\n"
"	H {hex be 4 0x}\n"
"	b {bin le 1}\n"
"	B {bin be 1}\n"
"	r {float fle 32}\n"
"	R {float fbe 32}\n"
"	f {float fhost 32}\n"
"	q {float fle 64}\n"
"	Q {float fbe 64}\n"
"	d {float fhost 64}\n"
"}\n"
"set binary::convtype {\n"
"	be intbe\n"
"	le intle\n"
"	fbe floatbe\n"
"	fle floatle\n"
"}\n"
"if {$::tcl_platform(byteOrder) eq \"bigEndian\"} {\n"
"	array set binary::convtype {host intbe fhost floatbe}\n"
"} else {\n"
"	array set binary::convtype {host intle fhost floatle}\n"
"}\n");
}
