// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/config/listener/v3/listener_components.proto

package listenerv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/type/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type FilterChainMatch_ConnectionSourceType int32

const (
	// Any connection source matches.
	FilterChainMatch_ANY FilterChainMatch_ConnectionSourceType = 0
	// Match a connection originating from the same host.
	FilterChainMatch_SAME_IP_OR_LOOPBACK FilterChainMatch_ConnectionSourceType = 1
	// Match a connection originating from a different host.
	FilterChainMatch_EXTERNAL FilterChainMatch_ConnectionSourceType = 2
)

// Enum value maps for FilterChainMatch_ConnectionSourceType.
var (
	FilterChainMatch_ConnectionSourceType_name = map[int32]string{
		0: "ANY",
		1: "SAME_IP_OR_LOOPBACK",
		2: "EXTERNAL",
	}
	FilterChainMatch_ConnectionSourceType_value = map[string]int32{
		"ANY":                 0,
		"SAME_IP_OR_LOOPBACK": 1,
		"EXTERNAL":            2,
	}
)

func (x FilterChainMatch_ConnectionSourceType) Enum() *FilterChainMatch_ConnectionSourceType {
	p := new(FilterChainMatch_ConnectionSourceType)
	*p = x
	return p
}

func (x FilterChainMatch_ConnectionSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterChainMatch_ConnectionSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_listener_v3_listener_components_proto_enumTypes[0].Descriptor()
}

func (FilterChainMatch_ConnectionSourceType) Type() protoreflect.EnumType {
	return &file_envoy_config_listener_v3_listener_components_proto_enumTypes[0]
}

func (x FilterChainMatch_ConnectionSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterChainMatch_ConnectionSourceType.Descriptor instead.
func (FilterChainMatch_ConnectionSourceType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{1, 0}
}

// [#next-free-field: 6]
type Filter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the filter configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to ConfigType:
	//
	//	*Filter_TypedConfig
	//	*Filter_ConfigDiscovery
	ConfigType    isFilter_ConfigType `protobuf_oneof:"config_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Filter) Reset() {
	*x = Filter{}
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{0}
}

func (x *Filter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Filter) GetConfigType() isFilter_ConfigType {
	if x != nil {
		return x.ConfigType
	}
	return nil
}

func (x *Filter) GetTypedConfig() *anypb.Any {
	if x != nil {
		if x, ok := x.ConfigType.(*Filter_TypedConfig); ok {
			return x.TypedConfig
		}
	}
	return nil
}

func (x *Filter) GetConfigDiscovery() *v3.ExtensionConfigSource {
	if x != nil {
		if x, ok := x.ConfigType.(*Filter_ConfigDiscovery); ok {
			return x.ConfigDiscovery
		}
	}
	return nil
}

type isFilter_ConfigType interface {
	isFilter_ConfigType()
}

type Filter_TypedConfig struct {
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	// [#extension-category: envoy.filters.network]
	TypedConfig *anypb.Any `protobuf:"bytes,4,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

type Filter_ConfigDiscovery struct {
	// Configuration source specifier for an extension configuration discovery
	// service. In case of a failure and without the default configuration, the
	// listener closes the connections.
	ConfigDiscovery *v3.ExtensionConfigSource `protobuf:"bytes,5,opt,name=config_discovery,json=configDiscovery,proto3,oneof"`
}

func (*Filter_TypedConfig) isFilter_ConfigType() {}

func (*Filter_ConfigDiscovery) isFilter_ConfigType() {}

// Specifies the match criteria for selecting a specific filter chain for a
// listener.
//
// In order for a filter chain to be selected, *ALL* of its criteria must be
// fulfilled by the incoming connection, properties of which are set by the
// networking stack and/or listener filters.
//
// The following order applies:
//
//  1. Destination port.
//  2. Destination IP address.
//  3. Server name (e.g. SNI for TLS protocol),
//  4. Transport protocol.
//  5. Application protocols (e.g. ALPN for TLS protocol).
//  6. Directly connected source IP address (this will only be different from the source IP address
//     when using a listener filter that overrides the source address, such as the :ref:`Proxy Protocol
//     listener filter <config_listener_filters_proxy_protocol>`).
//  7. Source type (e.g. any, local or external network).
//  8. Source IP address.
//  9. Source port.
//
// For criteria that allow ranges or wildcards, the most specific value in any
// of the configured filter chains that matches the incoming connection is going
// to be used (e.g. for SNI “www.example.com“ the most specific match would be
// “www.example.com“, then “*.example.com“, then “*.com“, then any filter
// chain without “server_names“ requirements).
//
// A different way to reason about the filter chain matches:
// Suppose there exists N filter chains. Prune the filter chain set using the above 8 steps.
// In each step, filter chains which most specifically matches the attributes continue to the next step.
// The listener guarantees at most 1 filter chain is left after all of the steps.
//
// Example:
//
// For destination port, filter chains specifying the destination port of incoming traffic are the
// most specific match. If none of the filter chains specifies the exact destination port, the filter
// chains which do not specify ports are the most specific match. Filter chains specifying the
// wrong port can never be the most specific match.
//
// [#comment: Implemented rules are kept in the preference order, with deprecated fields
// listed at the end, because that's how we want to list them in the docs.
//
// [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
// [#next-free-field: 14]
type FilterChainMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional destination port to consider when use_original_dst is set on the
	// listener in determining a filter chain match.
	DestinationPort *wrapperspb.UInt32Value `protobuf:"bytes,8,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// If non-empty, an IP address and prefix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	PrefixRanges []*v3.CidrRange `protobuf:"bytes,3,rep,name=prefix_ranges,json=prefixRanges,proto3" json:"prefix_ranges,omitempty"`
	// If non-empty, an IP address and suffix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	// [#not-implemented-hide:]
	AddressSuffix string `protobuf:"bytes,4,opt,name=address_suffix,json=addressSuffix,proto3" json:"address_suffix,omitempty"`
	// [#not-implemented-hide:]
	SuffixLen *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=suffix_len,json=suffixLen,proto3" json:"suffix_len,omitempty"`
	// The criteria is satisfied if the directly connected source IP address of the downstream
	// connection is contained in at least one of the specified subnets. If the parameter is not
	// specified or the list is empty, the directly connected source IP address is ignored.
	DirectSourcePrefixRanges []*v3.CidrRange `protobuf:"bytes,13,rep,name=direct_source_prefix_ranges,json=directSourcePrefixRanges,proto3" json:"direct_source_prefix_ranges,omitempty"`
	// Specifies the connection source IP match type. Can be any, local or external network.
	SourceType FilterChainMatch_ConnectionSourceType `protobuf:"varint,12,opt,name=source_type,json=sourceType,proto3,enum=envoy.config.listener.v3.FilterChainMatch_ConnectionSourceType" json:"source_type,omitempty"`
	// The criteria is satisfied if the source IP address of the downstream
	// connection is contained in at least one of the specified subnets. If the
	// parameter is not specified or the list is empty, the source IP address is
	// ignored.
	SourcePrefixRanges []*v3.CidrRange `protobuf:"bytes,6,rep,name=source_prefix_ranges,json=sourcePrefixRanges,proto3" json:"source_prefix_ranges,omitempty"`
	// The criteria is satisfied if the source port of the downstream connection
	// is contained in at least one of the specified ports. If the parameter is
	// not specified, the source port is ignored.
	SourcePorts []uint32 `protobuf:"varint,7,rep,packed,name=source_ports,json=sourcePorts,proto3" json:"source_ports,omitempty"`
	// If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
	// a filter chain match. Those values will be compared against the server names of a new
	// connection, when detected by one of the listener filters.
	//
	// The server name will be matched against all wildcard domains, i.e. “www.example.com“
	// will be first matched against “www.example.com“, then “*.example.com“, then “*.com“.
	//
	// Note that partial wildcards are not supported, and values like “*w.example.com“ are invalid.
	// The value “*“ is also not supported, and “server_names“ should be omitted instead.
	//
	// .. attention::
	//
	//	See the :ref:`FAQ entry <faq_how_to_setup_sni>` on how to configure SNI for more
	//	information.
	ServerNames []string `protobuf:"bytes,11,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// If non-empty, a transport protocol to consider when determining a filter chain match.
	// This value will be compared against the transport protocol of a new connection, when
	// it's detected by one of the listener filters.
	//
	// Suggested values include:
	//
	//   - “raw_buffer“ - default, used when no transport protocol is detected,
	//   - “tls“ - set by :ref:`envoy.filters.listener.tls_inspector <config_listener_filters_tls_inspector>`
	//     when TLS protocol is detected.
	TransportProtocol string `protobuf:"bytes,9,opt,name=transport_protocol,json=transportProtocol,proto3" json:"transport_protocol,omitempty"`
	// If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
	// determining a filter chain match. Those values will be compared against the application
	// protocols of a new connection, when detected by one of the listener filters.
	//
	// Suggested values include:
	//
	//   - “http/1.1“ - set by :ref:`envoy.filters.listener.tls_inspector
	//     <config_listener_filters_tls_inspector>`,
	//   - “h2“ - set by :ref:`envoy.filters.listener.tls_inspector <config_listener_filters_tls_inspector>`
	//
	// .. attention::
	//
	//	Currently, only :ref:`TLS Inspector <config_listener_filters_tls_inspector>` provides
	//	application protocol detection based on the requested
	//	`ALPN <https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation>`_ values.
	//
	//	However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
	//	and matching on values other than ``h2`` is going to lead to a lot of false negatives,
	//	unless all connecting clients are known to use ALPN.
	ApplicationProtocols []string `protobuf:"bytes,10,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *FilterChainMatch) Reset() {
	*x = FilterChainMatch{}
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterChainMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterChainMatch) ProtoMessage() {}

func (x *FilterChainMatch) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterChainMatch.ProtoReflect.Descriptor instead.
func (*FilterChainMatch) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{1}
}

func (x *FilterChainMatch) GetDestinationPort() *wrapperspb.UInt32Value {
	if x != nil {
		return x.DestinationPort
	}
	return nil
}

func (x *FilterChainMatch) GetPrefixRanges() []*v3.CidrRange {
	if x != nil {
		return x.PrefixRanges
	}
	return nil
}

func (x *FilterChainMatch) GetAddressSuffix() string {
	if x != nil {
		return x.AddressSuffix
	}
	return ""
}

func (x *FilterChainMatch) GetSuffixLen() *wrapperspb.UInt32Value {
	if x != nil {
		return x.SuffixLen
	}
	return nil
}

func (x *FilterChainMatch) GetDirectSourcePrefixRanges() []*v3.CidrRange {
	if x != nil {
		return x.DirectSourcePrefixRanges
	}
	return nil
}

func (x *FilterChainMatch) GetSourceType() FilterChainMatch_ConnectionSourceType {
	if x != nil {
		return x.SourceType
	}
	return FilterChainMatch_ANY
}

func (x *FilterChainMatch) GetSourcePrefixRanges() []*v3.CidrRange {
	if x != nil {
		return x.SourcePrefixRanges
	}
	return nil
}

func (x *FilterChainMatch) GetSourcePorts() []uint32 {
	if x != nil {
		return x.SourcePorts
	}
	return nil
}

func (x *FilterChainMatch) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

func (x *FilterChainMatch) GetTransportProtocol() string {
	if x != nil {
		return x.TransportProtocol
	}
	return ""
}

func (x *FilterChainMatch) GetApplicationProtocols() []string {
	if x != nil {
		return x.ApplicationProtocols
	}
	return nil
}

// A filter chain wraps a set of match criteria, an option TLS context, a set of filters, and
// various other parameters.
// [#next-free-field: 10]
type FilterChain struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The criteria to use when matching a connection to this filter chain.
	FilterChainMatch *FilterChainMatch `protobuf:"bytes,1,opt,name=filter_chain_match,json=filterChainMatch,proto3" json:"filter_chain_match,omitempty"`
	// A list of individual network filters that make up the filter chain for
	// connections established with the listener. Order matters as the filters are
	// processed sequentially as connection events happen. Note: If the filter
	// list is empty, the connection will close by default.
	//
	// For QUIC listeners, network filters other than HTTP Connection Manager (HCM)
	// can be created, but due to differences in the connection implementation compared
	// to TCP, the onData() method will never be called. Therefore, network filters
	// for QUIC listeners should only expect to do work at the start of a new connection
	// (i.e. in onNewConnection()). HCM must be the last (or only) filter in the chain.
	Filters []*Filter `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters,omitempty"`
	// Whether the listener should expect a PROXY protocol V1 header on new
	// connections. If this option is enabled, the listener will assume that that
	// remote address of the connection is the one specified in the header. Some
	// load balancers including the AWS ELB support this option. If the option is
	// absent or set to false, Envoy will use the physical peer address of the
	// connection as the remote address.
	//
	// This field is deprecated. Add a
	// :ref:`PROXY protocol listener filter <config_listener_filters_proxy_protocol>`
	// explicitly instead.
	//
	// Deprecated: Marked as deprecated in envoy/config/listener/v3/listener_components.proto.
	UseProxyProto *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=use_proxy_proto,json=useProxyProto,proto3" json:"use_proxy_proto,omitempty"`
	// Filter chain metadata.
	Metadata *v3.Metadata `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Optional custom transport socket implementation to use for downstream connections.
	// To setup TLS, set a transport socket with name “envoy.transport_sockets.tls“ and
	// :ref:`DownstreamTlsContext <envoy_v3_api_msg_extensions.transport_sockets.tls.v3.DownstreamTlsContext>` in the “typed_config“.
	// If no transport socket configuration is specified, new connections
	// will be set up with plaintext.
	// [#extension-category: envoy.transport_sockets.downstream]
	TransportSocket *v3.TransportSocket `protobuf:"bytes,6,opt,name=transport_socket,json=transportSocket,proto3" json:"transport_socket,omitempty"`
	// If present and nonzero, the amount of time to allow incoming connections to complete any
	// transport socket negotiations. If this expires before the transport reports connection
	// establishment, the connection is summarily closed.
	TransportSocketConnectTimeout *durationpb.Duration `protobuf:"bytes,9,opt,name=transport_socket_connect_timeout,json=transportSocketConnectTimeout,proto3" json:"transport_socket_connect_timeout,omitempty"`
	// The unique name (or empty) by which this filter chain is known.
	//
	// .. note::
	//
	//	:ref:`filter_chain_matcher
	//	<envoy_v3_api_field_config.listener.v3.Listener.filter_chain_matcher>`
	//	requires that filter chains are uniquely named within a listener.
	Name          string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FilterChain) Reset() {
	*x = FilterChain{}
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterChain) ProtoMessage() {}

func (x *FilterChain) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterChain.ProtoReflect.Descriptor instead.
func (*FilterChain) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{2}
}

func (x *FilterChain) GetFilterChainMatch() *FilterChainMatch {
	if x != nil {
		return x.FilterChainMatch
	}
	return nil
}

func (x *FilterChain) GetFilters() []*Filter {
	if x != nil {
		return x.Filters
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/config/listener/v3/listener_components.proto.
func (x *FilterChain) GetUseProxyProto() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseProxyProto
	}
	return nil
}

func (x *FilterChain) GetMetadata() *v3.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *FilterChain) GetTransportSocket() *v3.TransportSocket {
	if x != nil {
		return x.TransportSocket
	}
	return nil
}

func (x *FilterChain) GetTransportSocketConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.TransportSocketConnectTimeout
	}
	return nil
}

func (x *FilterChain) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Listener filter chain match configuration. This is a recursive structure which allows complex
// nested match configurations to be built using various logical operators.
//
// Examples:
//
// * Matches if the destination port is 3306.
//
// .. code-block:: yaml
//
//	destination_port_range:
//	 start: 3306
//	 end: 3307
//
// * Matches if the destination port is 3306 or 15000.
//
// .. code-block:: yaml
//
//	or_match:
//	  rules:
//	    - destination_port_range:
//	        start: 3306
//	        end: 3307
//	    - destination_port_range:
//	        start: 15000
//	        end: 15001
//
// [#next-free-field: 6]
type ListenerFilterChainMatchPredicate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Rule:
	//
	//	*ListenerFilterChainMatchPredicate_OrMatch
	//	*ListenerFilterChainMatchPredicate_AndMatch
	//	*ListenerFilterChainMatchPredicate_NotMatch
	//	*ListenerFilterChainMatchPredicate_AnyMatch
	//	*ListenerFilterChainMatchPredicate_DestinationPortRange
	Rule          isListenerFilterChainMatchPredicate_Rule `protobuf_oneof:"rule"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListenerFilterChainMatchPredicate) Reset() {
	*x = ListenerFilterChainMatchPredicate{}
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListenerFilterChainMatchPredicate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerFilterChainMatchPredicate) ProtoMessage() {}

func (x *ListenerFilterChainMatchPredicate) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerFilterChainMatchPredicate.ProtoReflect.Descriptor instead.
func (*ListenerFilterChainMatchPredicate) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{3}
}

func (x *ListenerFilterChainMatchPredicate) GetRule() isListenerFilterChainMatchPredicate_Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetOrMatch() *ListenerFilterChainMatchPredicate_MatchSet {
	if x != nil {
		if x, ok := x.Rule.(*ListenerFilterChainMatchPredicate_OrMatch); ok {
			return x.OrMatch
		}
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetAndMatch() *ListenerFilterChainMatchPredicate_MatchSet {
	if x != nil {
		if x, ok := x.Rule.(*ListenerFilterChainMatchPredicate_AndMatch); ok {
			return x.AndMatch
		}
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetNotMatch() *ListenerFilterChainMatchPredicate {
	if x != nil {
		if x, ok := x.Rule.(*ListenerFilterChainMatchPredicate_NotMatch); ok {
			return x.NotMatch
		}
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetAnyMatch() bool {
	if x != nil {
		if x, ok := x.Rule.(*ListenerFilterChainMatchPredicate_AnyMatch); ok {
			return x.AnyMatch
		}
	}
	return false
}

func (x *ListenerFilterChainMatchPredicate) GetDestinationPortRange() *v31.Int32Range {
	if x != nil {
		if x, ok := x.Rule.(*ListenerFilterChainMatchPredicate_DestinationPortRange); ok {
			return x.DestinationPortRange
		}
	}
	return nil
}

type isListenerFilterChainMatchPredicate_Rule interface {
	isListenerFilterChainMatchPredicate_Rule()
}

type ListenerFilterChainMatchPredicate_OrMatch struct {
	// A set that describes a logical OR. If any member of the set matches, the match configuration
	// matches.
	OrMatch *ListenerFilterChainMatchPredicate_MatchSet `protobuf:"bytes,1,opt,name=or_match,json=orMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_AndMatch struct {
	// A set that describes a logical AND. If all members of the set match, the match configuration
	// matches.
	AndMatch *ListenerFilterChainMatchPredicate_MatchSet `protobuf:"bytes,2,opt,name=and_match,json=andMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_NotMatch struct {
	// A negation match. The match configuration will match if the negated match condition matches.
	NotMatch *ListenerFilterChainMatchPredicate `protobuf:"bytes,3,opt,name=not_match,json=notMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_AnyMatch struct {
	// The match configuration will always match.
	AnyMatch bool `protobuf:"varint,4,opt,name=any_match,json=anyMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_DestinationPortRange struct {
	// Match destination port. Particularly, the match evaluation must use the recovered local port if
	// the owning listener filter is after :ref:`an original_dst listener filter <config_listener_filters_original_dst>`.
	DestinationPortRange *v31.Int32Range `protobuf:"bytes,5,opt,name=destination_port_range,json=destinationPortRange,proto3,oneof"`
}

func (*ListenerFilterChainMatchPredicate_OrMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_AndMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_NotMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_AnyMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_DestinationPortRange) isListenerFilterChainMatchPredicate_Rule() {
}

// [#next-free-field: 6]
type ListenerFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the filter configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to ConfigType:
	//
	//	*ListenerFilter_TypedConfig
	//	*ListenerFilter_ConfigDiscovery
	ConfigType isListenerFilter_ConfigType `protobuf_oneof:"config_type"`
	// Optional match predicate used to disable the filter. The filter is enabled when this field is empty.
	// See :ref:`ListenerFilterChainMatchPredicate <envoy_v3_api_msg_config.listener.v3.ListenerFilterChainMatchPredicate>`
	// for further examples.
	FilterDisabled *ListenerFilterChainMatchPredicate `protobuf:"bytes,4,opt,name=filter_disabled,json=filterDisabled,proto3" json:"filter_disabled,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ListenerFilter) Reset() {
	*x = ListenerFilter{}
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListenerFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerFilter) ProtoMessage() {}

func (x *ListenerFilter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerFilter.ProtoReflect.Descriptor instead.
func (*ListenerFilter) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{4}
}

func (x *ListenerFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListenerFilter) GetConfigType() isListenerFilter_ConfigType {
	if x != nil {
		return x.ConfigType
	}
	return nil
}

func (x *ListenerFilter) GetTypedConfig() *anypb.Any {
	if x != nil {
		if x, ok := x.ConfigType.(*ListenerFilter_TypedConfig); ok {
			return x.TypedConfig
		}
	}
	return nil
}

func (x *ListenerFilter) GetConfigDiscovery() *v3.ExtensionConfigSource {
	if x != nil {
		if x, ok := x.ConfigType.(*ListenerFilter_ConfigDiscovery); ok {
			return x.ConfigDiscovery
		}
	}
	return nil
}

func (x *ListenerFilter) GetFilterDisabled() *ListenerFilterChainMatchPredicate {
	if x != nil {
		return x.FilterDisabled
	}
	return nil
}

type isListenerFilter_ConfigType interface {
	isListenerFilter_ConfigType()
}

type ListenerFilter_TypedConfig struct {
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	// [#extension-category: envoy.filters.listener,envoy.filters.udp_listener]
	TypedConfig *anypb.Any `protobuf:"bytes,3,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

type ListenerFilter_ConfigDiscovery struct {
	// Configuration source specifier for an extension configuration discovery
	// service. In case of a failure and without the default configuration, the
	// listener closes the connections.
	ConfigDiscovery *v3.ExtensionConfigSource `protobuf:"bytes,5,opt,name=config_discovery,json=configDiscovery,proto3,oneof"`
}

func (*ListenerFilter_TypedConfig) isListenerFilter_ConfigType() {}

func (*ListenerFilter_ConfigDiscovery) isListenerFilter_ConfigType() {}

// A set of match configurations used for logical operations.
type ListenerFilterChainMatchPredicate_MatchSet struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The list of rules that make up the set.
	Rules         []*ListenerFilterChainMatchPredicate `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListenerFilterChainMatchPredicate_MatchSet) Reset() {
	*x = ListenerFilterChainMatchPredicate_MatchSet{}
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListenerFilterChainMatchPredicate_MatchSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerFilterChainMatchPredicate_MatchSet) ProtoMessage() {}

func (x *ListenerFilterChainMatchPredicate_MatchSet) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerFilterChainMatchPredicate_MatchSet.ProtoReflect.Descriptor instead.
func (*ListenerFilterChainMatchPredicate_MatchSet) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ListenerFilterChainMatchPredicate_MatchSet) GetRules() []*ListenerFilterChainMatchPredicate {
	if x != nil {
		return x.Rules
	}
	return nil
}

var File_envoy_config_listener_v3_listener_components_proto protoreflect.FileDescriptor

const file_envoy_config_listener_v3_listener_components_proto_rawDesc = "" +
	"\n" +
	"2envoy/config/listener/v3/listener_components.proto\x12\x18envoy.config.listener.v3\x1a\"envoy/config/core/v3/address.proto\x1a\x1fenvoy/config/core/v3/base.proto\x1a(envoy/config/core/v3/config_source.proto\x1a\x19envoy/type/v3/range.proto\x1a\x19google/protobuf/any.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a#envoy/annotations/deprecation.proto\x1a\x1dudpa/annotations/status.proto\x1a!udpa/annotations/versioning.proto\x1a\x17validate/validate.proto\"\x82\x02\n" +
	"\x06Filter\x12\x1b\n" +
	"\x04name\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\x04name\x129\n" +
	"\ftyped_config\x18\x04 \x01(\v2\x14.google.protobuf.AnyH\x00R\vtypedConfig\x12X\n" +
	"\x10config_discovery\x18\x05 \x01(\v2+.envoy.config.core.v3.ExtensionConfigSourceH\x00R\x0fconfigDiscovery:#\x9aň\x1e\x1e\n" +
	"\x1cenvoy.api.v2.listener.FilterB\r\n" +
	"\vconfig_typeJ\x04\b\x03\x10\x04J\x04\b\x02\x10\x03R\x06config\"\xea\x06\n" +
	"\x10FilterChainMatch\x12T\n" +
	"\x10destination_port\x18\b \x01(\v2\x1c.google.protobuf.UInt32ValueB\v\xfaB\b*\x06\x18\xff\xff\x03(\x01R\x0fdestinationPort\x12D\n" +
	"\rprefix_ranges\x18\x03 \x03(\v2\x1f.envoy.config.core.v3.CidrRangeR\fprefixRanges\x12%\n" +
	"\x0eaddress_suffix\x18\x04 \x01(\tR\raddressSuffix\x12;\n" +
	"\n" +
	"suffix_len\x18\x05 \x01(\v2\x1c.google.protobuf.UInt32ValueR\tsuffixLen\x12^\n" +
	"\x1bdirect_source_prefix_ranges\x18\r \x03(\v2\x1f.envoy.config.core.v3.CidrRangeR\x18directSourcePrefixRanges\x12j\n" +
	"\vsource_type\x18\f \x01(\x0e2?.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceTypeB\b\xfaB\x05\x82\x01\x02\x10\x01R\n" +
	"sourceType\x12Q\n" +
	"\x14source_prefix_ranges\x18\x06 \x03(\v2\x1f.envoy.config.core.v3.CidrRangeR\x12sourcePrefixRanges\x123\n" +
	"\fsource_ports\x18\a \x03(\rB\x10\xfaB\r\x92\x01\n" +
	"\"\b*\x06\x18\xff\xff\x03(\x01R\vsourcePorts\x12!\n" +
	"\fserver_names\x18\v \x03(\tR\vserverNames\x12-\n" +
	"\x12transport_protocol\x18\t \x01(\tR\x11transportProtocol\x123\n" +
	"\x15application_protocols\x18\n" +
	" \x03(\tR\x14applicationProtocols\"F\n" +
	"\x14ConnectionSourceType\x12\a\n" +
	"\x03ANY\x10\x00\x12\x17\n" +
	"\x13SAME_IP_OR_LOOPBACK\x10\x01\x12\f\n" +
	"\bEXTERNAL\x10\x02:-\x9aň\x1e(\n" +
	"&envoy.api.v2.listener.FilterChainMatchJ\x04\b\x01\x10\x02\"\xd6\x04\n" +
	"\vFilterChain\x12X\n" +
	"\x12filter_chain_match\x18\x01 \x01(\v2*.envoy.config.listener.v3.FilterChainMatchR\x10filterChainMatch\x12:\n" +
	"\afilters\x18\x03 \x03(\v2 .envoy.config.listener.v3.FilterR\afilters\x12O\n" +
	"\x0fuse_proxy_proto\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueB\v\x92ǆ\xd8\x04\x033.0\x18\x01R\ruseProxyProto\x12:\n" +
	"\bmetadata\x18\x05 \x01(\v2\x1e.envoy.config.core.v3.MetadataR\bmetadata\x12P\n" +
	"\x10transport_socket\x18\x06 \x01(\v2%.envoy.config.core.v3.TransportSocketR\x0ftransportSocket\x12b\n" +
	" transport_socket_connect_timeout\x18\t \x01(\v2\x19.google.protobuf.DurationR\x1dtransportSocketConnectTimeout\x12\x12\n" +
	"\x04name\x18\a \x01(\tR\x04name:(\x9aň\x1e#\n" +
	"!envoy.api.v2.listener.FilterChainJ\x04\b\x02\x10\x03J\x04\b\b\x10\tR\vtls_contextR\x17on_demand_configuration\"\xc2\x05\n" +
	"!ListenerFilterChainMatchPredicate\x12a\n" +
	"\bor_match\x18\x01 \x01(\v2D.envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSetH\x00R\aorMatch\x12c\n" +
	"\tand_match\x18\x02 \x01(\v2D.envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSetH\x00R\bandMatch\x12Z\n" +
	"\tnot_match\x18\x03 \x01(\v2;.envoy.config.listener.v3.ListenerFilterChainMatchPredicateH\x00R\bnotMatch\x12&\n" +
	"\tany_match\x18\x04 \x01(\bB\a\xfaB\x04j\x02\b\x01H\x00R\banyMatch\x12Q\n" +
	"\x16destination_port_range\x18\x05 \x01(\v2\x19.envoy.type.v3.Int32RangeH\x00R\x14destinationPortRange\x1a\xb0\x01\n" +
	"\bMatchSet\x12[\n" +
	"\x05rules\x18\x01 \x03(\v2;.envoy.config.listener.v3.ListenerFilterChainMatchPredicateB\b\xfaB\x05\x92\x01\x02\b\x02R\x05rules:G\x9aň\x1eB\n" +
	"@envoy.api.v2.listener.ListenerFilterChainMatchPredicate.MatchSet:>\x9aň\x1e9\n" +
	"7envoy.api.v2.listener.ListenerFilterChainMatchPredicateB\v\n" +
	"\x04rule\x12\x03\xf8B\x01\"\xf2\x02\n" +
	"\x0eListenerFilter\x12\x1b\n" +
	"\x04name\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\x04name\x129\n" +
	"\ftyped_config\x18\x03 \x01(\v2\x14.google.protobuf.AnyH\x00R\vtypedConfig\x12X\n" +
	"\x10config_discovery\x18\x05 \x01(\v2+.envoy.config.core.v3.ExtensionConfigSourceH\x00R\x0fconfigDiscovery\x12d\n" +
	"\x0ffilter_disabled\x18\x04 \x01(\v2;.envoy.config.listener.v3.ListenerFilterChainMatchPredicateR\x0efilterDisabled:+\x9aň\x1e&\n" +
	"$envoy.api.v2.listener.ListenerFilterB\r\n" +
	"\vconfig_typeJ\x04\b\x02\x10\x03R\x06configB\x97\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	"&io.envoyproxy.envoy.config.listener.v3B\x17ListenerComponentsProtoP\x01ZJgithub.com/envoyproxy/go-control-plane/envoy/config/listener/v3;listenerv3b\x06proto3"

var (
	file_envoy_config_listener_v3_listener_components_proto_rawDescOnce sync.Once
	file_envoy_config_listener_v3_listener_components_proto_rawDescData []byte
)

func file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP() []byte {
	file_envoy_config_listener_v3_listener_components_proto_rawDescOnce.Do(func() {
		file_envoy_config_listener_v3_listener_components_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_config_listener_v3_listener_components_proto_rawDesc), len(file_envoy_config_listener_v3_listener_components_proto_rawDesc)))
	})
	return file_envoy_config_listener_v3_listener_components_proto_rawDescData
}

var file_envoy_config_listener_v3_listener_components_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_config_listener_v3_listener_components_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_envoy_config_listener_v3_listener_components_proto_goTypes = []any{
	(FilterChainMatch_ConnectionSourceType)(0), // 0: envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType
	(*Filter)(nil),                                     // 1: envoy.config.listener.v3.Filter
	(*FilterChainMatch)(nil),                           // 2: envoy.config.listener.v3.FilterChainMatch
	(*FilterChain)(nil),                                // 3: envoy.config.listener.v3.FilterChain
	(*ListenerFilterChainMatchPredicate)(nil),          // 4: envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	(*ListenerFilter)(nil),                             // 5: envoy.config.listener.v3.ListenerFilter
	(*ListenerFilterChainMatchPredicate_MatchSet)(nil), // 6: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet
	(*anypb.Any)(nil),                                  // 7: google.protobuf.Any
	(*v3.ExtensionConfigSource)(nil),                   // 8: envoy.config.core.v3.ExtensionConfigSource
	(*wrapperspb.UInt32Value)(nil),                     // 9: google.protobuf.UInt32Value
	(*v3.CidrRange)(nil),                               // 10: envoy.config.core.v3.CidrRange
	(*wrapperspb.BoolValue)(nil),                       // 11: google.protobuf.BoolValue
	(*v3.Metadata)(nil),                                // 12: envoy.config.core.v3.Metadata
	(*v3.TransportSocket)(nil),                         // 13: envoy.config.core.v3.TransportSocket
	(*durationpb.Duration)(nil),                        // 14: google.protobuf.Duration
	(*v31.Int32Range)(nil),                             // 15: envoy.type.v3.Int32Range
}
var file_envoy_config_listener_v3_listener_components_proto_depIdxs = []int32{
	7,  // 0: envoy.config.listener.v3.Filter.typed_config:type_name -> google.protobuf.Any
	8,  // 1: envoy.config.listener.v3.Filter.config_discovery:type_name -> envoy.config.core.v3.ExtensionConfigSource
	9,  // 2: envoy.config.listener.v3.FilterChainMatch.destination_port:type_name -> google.protobuf.UInt32Value
	10, // 3: envoy.config.listener.v3.FilterChainMatch.prefix_ranges:type_name -> envoy.config.core.v3.CidrRange
	9,  // 4: envoy.config.listener.v3.FilterChainMatch.suffix_len:type_name -> google.protobuf.UInt32Value
	10, // 5: envoy.config.listener.v3.FilterChainMatch.direct_source_prefix_ranges:type_name -> envoy.config.core.v3.CidrRange
	0,  // 6: envoy.config.listener.v3.FilterChainMatch.source_type:type_name -> envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType
	10, // 7: envoy.config.listener.v3.FilterChainMatch.source_prefix_ranges:type_name -> envoy.config.core.v3.CidrRange
	2,  // 8: envoy.config.listener.v3.FilterChain.filter_chain_match:type_name -> envoy.config.listener.v3.FilterChainMatch
	1,  // 9: envoy.config.listener.v3.FilterChain.filters:type_name -> envoy.config.listener.v3.Filter
	11, // 10: envoy.config.listener.v3.FilterChain.use_proxy_proto:type_name -> google.protobuf.BoolValue
	12, // 11: envoy.config.listener.v3.FilterChain.metadata:type_name -> envoy.config.core.v3.Metadata
	13, // 12: envoy.config.listener.v3.FilterChain.transport_socket:type_name -> envoy.config.core.v3.TransportSocket
	14, // 13: envoy.config.listener.v3.FilterChain.transport_socket_connect_timeout:type_name -> google.protobuf.Duration
	6,  // 14: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.or_match:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet
	6,  // 15: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.and_match:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet
	4,  // 16: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.not_match:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	15, // 17: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.destination_port_range:type_name -> envoy.type.v3.Int32Range
	7,  // 18: envoy.config.listener.v3.ListenerFilter.typed_config:type_name -> google.protobuf.Any
	8,  // 19: envoy.config.listener.v3.ListenerFilter.config_discovery:type_name -> envoy.config.core.v3.ExtensionConfigSource
	4,  // 20: envoy.config.listener.v3.ListenerFilter.filter_disabled:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	4,  // 21: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet.rules:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_envoy_config_listener_v3_listener_components_proto_init() }
func file_envoy_config_listener_v3_listener_components_proto_init() {
	if File_envoy_config_listener_v3_listener_components_proto != nil {
		return
	}
	file_envoy_config_listener_v3_listener_components_proto_msgTypes[0].OneofWrappers = []any{
		(*Filter_TypedConfig)(nil),
		(*Filter_ConfigDiscovery)(nil),
	}
	file_envoy_config_listener_v3_listener_components_proto_msgTypes[3].OneofWrappers = []any{
		(*ListenerFilterChainMatchPredicate_OrMatch)(nil),
		(*ListenerFilterChainMatchPredicate_AndMatch)(nil),
		(*ListenerFilterChainMatchPredicate_NotMatch)(nil),
		(*ListenerFilterChainMatchPredicate_AnyMatch)(nil),
		(*ListenerFilterChainMatchPredicate_DestinationPortRange)(nil),
	}
	file_envoy_config_listener_v3_listener_components_proto_msgTypes[4].OneofWrappers = []any{
		(*ListenerFilter_TypedConfig)(nil),
		(*ListenerFilter_ConfigDiscovery)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_config_listener_v3_listener_components_proto_rawDesc), len(file_envoy_config_listener_v3_listener_components_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_config_listener_v3_listener_components_proto_goTypes,
		DependencyIndexes: file_envoy_config_listener_v3_listener_components_proto_depIdxs,
		EnumInfos:         file_envoy_config_listener_v3_listener_components_proto_enumTypes,
		MessageInfos:      file_envoy_config_listener_v3_listener_components_proto_msgTypes,
	}.Build()
	File_envoy_config_listener_v3_listener_components_proto = out.File
	file_envoy_config_listener_v3_listener_components_proto_goTypes = nil
	file_envoy_config_listener_v3_listener_components_proto_depIdxs = nil
}
