const char *default_config =
"servers = (\n"
"  { address = \"irc.dal.net\";       chatnet = \"DALnet\";    port = \"6667\"; },\n"
"  { address = \"ssl.efnet.org\";     chatnet = \"EFNet\";     port = \"9999\"; use_tls = \"yes\"; tls_verify = \"no\"; },\n"
"  { address = \"irc.esper.net\";     chatnet = \"EsperNet\";  port = \"6697\"; use_tls = \"yes\"; tls_verify = \"yes\"; },\n"
"  { address = \"irc.libera.chat\";   chatnet = \"liberachat\";port = \"6697\"; use_tls = \"yes\"; tls_verify = \"yes\"; },\n"
"  { address = \"irc.gamesurge.net\"; chatnet = \"GameSurge\"; port = \"6667\"; },\n"
"  { address = \"ssl.ircnet.ovh\";    chatnet = \"IRCnet\";    port = \"6697\"; use_tls = \"yes\"; tls_verify = \"yes\"; },\n"
"  { address = \"open.ircnet.net\";   chatnet = \"IRCnet\";    port = \"6667\"; },\n"
"  { address = \"irc.ircsource.net\"; chatnet = \"IRCSource\"; port = \"6667\"; },\n"
"  { address = \"irc.netfuze.net\";   chatnet = \"NetFuze\";   port = \"6667\"; },\n"
"  { address = \"irc.oftc.net\";      chatnet = \"OFTC\";      port = \"6697\"; use_tls = \"yes\"; tls_verify = \"yes\"; },\n"
"  { address = \"irc.quakenet.org\";  chatnet = \"QuakeNet\";  port = \"6667\"; },\n"
"  { address = \"irc.rizon.net\";     chatnet = \"Rizon\";     port = \"6697\"; use_tls = \"yes\"; tls_verify = \"yes\"; },\n"
"  { address = \"silc.silcnet.org\";  chatnet = \"SILC\";      port = \"706\";  },\n"
"  { address = \"irc.undernet.org\";  chatnet = \"Undernet\";  port = \"6667\"; }\n"
");\n"
"\n"
"chatnets = {\n"
"  DALnet = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"4\";\n"
"    max_msgs  = \"20\";\n"
"    max_whois = \"30\";\n"
"  }; \n"
"  EFNet = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"4\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  EsperNet = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"4\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  liberachat = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"4\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  GameSurge = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  IRCnet = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  IRCSource = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"4\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  NetFuze = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  OFTC = {   \n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  QuakeNet = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  Rizon = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"  SILC = {\n"
"    type = \"SILC\";\n"
"  };\n"
"  Undernet = {\n"
"    type      = \"IRC\";\n"
"    max_kicks = \"1\";\n"
"    max_msgs  = \"1\";\n"
"    max_whois = \"1\";\n"
"  };\n"
"};\n"
"\n"
"channels = (\n"
"  { name = \"#lobby\";     chatnet = \"EsperNet\";  autojoin = \"No\"; },\n"
"  { name = \"#libera\";    chatnet = \"liberachat\";autojoin = \"No\"; },\n"
"  { name = \"#irssi\";     chatnet = \"liberachat\";autojoin = \"No\"; },\n"
"  { name = \"#gamesurge\"; chatnet = \"GameSurge\"; autojoin = \"No\"; },\n"
"  { name = \"#irssi\";     chatnet = \"IRCNet\";    autojoin = \"No\"; },\n"
"  { name = \"#ircsource\"; chatnet = \"IRCSource\"; autojoin = \"No\"; },\n"
"  { name = \"#netfuze\";   chatnet = \"NetFuze\";   autojoin = \"No\"; },\n"
"  { name = \"#oftc\";      chatnet = \"OFTC\";      autojoin = \"No\"; },\n"
"  { name = \"silc\";       chatnet = \"SILC\";      autojoin = \"No\"; }\n"
");\n"
"\n"
"aliases = {\n"
"  ATAG        = \"WINDOW SERVER\";\n"
"  ADDALLCHANS = \"SCRIPT EXEC foreach my \\\\$channel (Irssi::channels()) { Irssi::command(\\\"CHANNEL ADD -auto \\\\$channel->{visible_name} \\\\$channel->{server}->{tag} \\\\$channel->{key}\\\")\\\\;}\";\n"
"  B           = \"BAN\";\n"
"  BACK        = \"AWAY\";\n"
"  BANS        = \"BAN\";\n"
"  BYE         = \"QUIT\";\n"
"  C           = \"CLEAR\";\n"
"  CALC        = \"EXEC - if command -v bc >/dev/null 2>&1\\\\; then printf '%s=' '$*'\\\\; echo '$*' | bc -l\\\\; else echo bc was not found\\\\; fi\";\n"
"  CHAT        = \"DCC CHAT\";\n"
"  CS          = \"QUOTE CS\";\n"
"  DATE        = \"TIME\";\n"
"  DEHIGHLIGHT = \"DEHILIGHT\";\n"
"  DESCRIBE    = \"ACTION\";\n"
"  DHL         = \"DEHILIGHT\";\n"
"  EXEMPTLIST  = \"MODE $C +e\";\n"
"  EXIT        = \"QUIT\";\n"
"  GOTO        = \"SCROLLBACK GOTO\";\n"
"  HIGHLIGHT   = \"HILIGHT\";\n"
"  HL          = \"HILIGHT\";\n"
"  HOST        = \"USERHOST\";\n"
"  INVITELIST  = \"MODE $C +I\";\n"
"  J           = \"JOIN\";\n"
"  K           = \"KICK\";\n"
"  KB          = \"KICKBAN\";\n"
"  KN          = \"KNOCKOUT\";\n"
"  LAST        = \"LASTLOG\";\n"
"  LEAVE       = \"PART\";\n"
"  M           = \"MSG\";\n"
"  MS          = \"QUOTE MS\";\n"
"  MUB         = \"UNBAN *\";\n"
"  N           = \"NAMES\";\n"
"  NMSG        = \"^MSG\";\n"
"  NS          = \"QUOTE NS\";\n"
"  OS          = \"QUOTE OS\";\n"
"  P           = \"PART\";\n"
"  Q           = \"QUERY\";\n"
"  RESET       = \"SET -default\";\n"
"  RUN         = \"SCRIPT LOAD\";\n"
"  SAY         = \"MSG *\";\n"
"  SB          = \"SCROLLBACK\";\n"
"  SBAR        = \"STATUSBAR\";\n"
"  SHELP       = \"QUOTE HELP\";\n"
"  SIGNOFF     = \"QUIT\";\n"
"  SV          = \"MSG * Irssi $J ($V) - https://irssi.org\";\n"
"  T           = \"TOPIC\"; \n"
"  UB          = \"UNBAN\";\n"
"  UMODE       = \"MODE $N\";\n"
"  UNSET       = \"SET -clear\";\n"
"  W           = \"WHO\";\n"
"  WC          = \"WINDOW CLOSE\";\n"
"  WG          = \"WINDOW GOTO\";\n"
"  WJOIN       = \"JOIN -window\";\n"
"  WI          = \"WHOIS\";\n"
"  WII         = \"WHOIS $0 $0\";\n"
"  WL          = \"WINDOW LIST\";\n"
"  WN          = \"WINDOW NEW HIDDEN\";\n"
"  WQUERY      = \"QUERY -window\";\n"
"  WW          = \"WHOWAS\";\n"
"};\n"
"\n"
"statusbar = {\n"
"\n"
"  items = {\n"
"    \n"
"    barstart = \"{sbstart}\";\n"
"    barend   = \"{sbend}\";\n"
"\n"
"    topicbarstart = \"{topicsbstart}\";\n"
"    topicbarend   = \"{topicsbend}\";\n"
"\n"
"    time = \"{sb $Z}\";\n"
"    user = \"{sb {sbnickmode $cumode}$N{sbmode $usermode}{sbaway $A}}\";\n"
"\n"
"    window       = \"{sb $winref:$tag/$itemname{sbmode $M}}\";\n"
"    window_empty = \"{sb $winref{sbservertag $tag}}\";\n"
"    \n"
"    prompt       = \"{prompt $[.15]itemname}\";\n"
"    prompt_empty = \"{prompt $winname}\";\n"
"    \n"
"    topic       = \" $topic\";\n"
"    topic_empty = \" Irssi v$J - https://irssi.org\";\n"
"\n"
"    lag  = \"{sb Lag: $0-}\";\n"
"    act  = \"{sb Act: $0-}\";\n"
"    more = \"-- more --\";\n"
"  };\n"
"\n"
"  default = {\n"
"\n"
"    window = {\n"
"\n"
"      disabled  = \"no\";\n"
"      type      = \"window\";\n"
"      placement = \"bottom\";\n"
"      position  = \"1\";\n"
"      visible   = \"active\";\n"
"\n"
"      items = {\n"
"        barstart     = { priority = \"100\"; };\n"
"        time         = { };\n"
"        user         = { };\n"
"        window       = { };\n"
"        window_empty = { };\n"
"        lag          = { priority = \"-1\"; };\n"
"        act          = { priority = \"10\"; };\n"
"        more         = { priority = \"-1\";  alignment = \"right\"; };\n"
"        barend       = { priority = \"100\"; alignment = \"right\"; };\n"
"      };\n"
"    };\n"
"\n"
"    window_inact = {\n"
"\n"
"      type      = \"window\";\n"
"      placement = \"bottom\";\n"
"      position  = \"1\";\n"
"      visible   = \"inactive\";\n"
"\n"
"      items = {\n"
"        barstart     = { priority = \"100\"; };\n"
"        window       = { };\n"
"        window_empty = { };\n"
"        more         = { priority = \"-1\";  alignment = \"right\"; };\n"
"        barend       = { priority = \"100\"; alignment = \"right\"; };\n"
"      };\n"
"    };\n"
"\n"
"    prompt = {\n"
"    \n"
"      type      = \"root\";\n"
"      placement = \"bottom\";\n"
"      position  = \"100\";\n"
"      visible   = \"always\";\n"
"\n"
"      items = {\n"
"        prompt       = { priority = \"-1\"; };\n"
"        prompt_empty = { priority = \"-1\"; };\n"
"        input        = { priority = \"10\"; };\n"
"      };\n"
"    };\n"
"\n"
"    topic = {\n"
"\n"
"      type      = \"root\";\n"
"      placement = \"top\";\n"
"      position  = \"1\";\n"
"      visible   = \"always\";\n"
"\n"
"      items = {\n"
"        topicbarstart = { priority = \"100\"; };\n"
"        topic         = { };\n"
"        topic_empty   = { };\n"
"        topicbarend   = { priority = \"100\"; alignment = \"right\"; };\n"
"      };\n"
"    };\n"
"  };\n"
"};\n"
;
