





/* CDBISDN database */
const int  CDBISDN_DBVERSION = 0x101;
const char CDBISDN_DATE[]  = "Sat Feb 21 11:43:59 2026";
/* vendor database */
static cdb_isdn_vendor cdb_isdnvendor_info_init[] = {
	{"Abocom/Magitek","Abocom",0,1},
	{"AsKey","AsKey",1,3},
	{"ASUSCOM","Asus",2,3},
	{"Auerswald","Auerswald",3,4},
	{"AVM Computersysteme Vertriebs GmbH","AVM",4,29},
	{"Berkom","Berkom",5,1},
	{"Billion","Billion",6,8},
	{"Cologne Chip AG","CC",7,1},
	{"Digi","Digi",8,4},
	{"Draytech","Draytech",9,1},
	{"Dynalink","Dynalink",10,3},
	{"Eicon Networks","Eicon",11,4},
	{"Elsa AG","Elsa",12,5},
	{"Formula-n","Formula-n",13,1},
	{"Gazel","Gazel",14,3},
	{"High Soft Tech","HST",15,1},
	{"Motorola","Motorola",16,1},
	{"Pyramid","Pyramid",17,1},
	{"Sagem","Sagem",18,1},
	{"Scitel","Scitel",19,1},
	{"Sedlbauer AG","Sedlbauer",20,5},
	{"Seyon","Seyon",21,1},
	{"SGS Thomson Microelectronics","SGST",22,1},
	{"Siemens","Siemens",23,6},
	{"Sitecom","Sitecom",24,3},
	{"Telekom AG","DTAG",25,2},
	{"Teles AG","Teles",26,4},
	{"TigerJet","TJET",27,3},
	{"U.S.Robotics","USR",28,1},
	{"Winbond","Winbond",29,1},
	{"Zolltrix","Zolltrix",30,1},
};
/* card database */
static cdb_isdn_card cdb_isdncard_info_init[] = {
	{0,0,"","",NULL,NULL,0,0,0,0,0,0,0,0,0},
	{1,0,"2BD1","Abocom 2BD1","ISDN Single Basic Rate","PCI",0,5073,11217,65535,65535,0,1,1,57},
	{2,30,"2BDS0","Zolltrix 2BDS0","ISDN Single Basic Rate","PCI",0,5552,11216,65535,65535,0,1,1,51},
	{3,27,"300 PCI","TJET 300 PCI","ISDN Single Basic Rate","PCI",0,57689,1,65535,65535,0,1,1,15},
	{4,10,"6692 PCI","Dynalink 6692 PCI","ISDN Single Basic Rate","PCI",0,1653,5890,65535,65535,0,1,1,64},
	{5,4,"A1 PCMCIA","AVM A1 PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,25},
	{6,4,"A1 PCMCIA","AVM A1 PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,2,86},
	{7,25,"A1T","DTAG A1T","ISDN Single Basic Rate","PCI",0,2161,65441,65535,65535,0,1,1,48},
	{8,5,"A4T","Berkom A4T","ISDN Single Basic Rate","PCI",0,4574,24864,2161,65444,0,1,1,31},
	{9,4,"AVM FRITZ!Box Fon","AVM AVM FRITZ!Box Fon","DSL","USB",0,1404,14848,65535,65535,0,0,1,108},
	{10,6,"B000","Billion B000","ISDN Single Basic Rate","PCI",0,5015,45056,65535,65535,0,1,1,36},
	{11,6,"B006","Billion B006","ISDN Single Basic Rate","PCI",0,5015,45062,65535,65535,0,1,1,37},
	{12,6,"B007","Billion B007","ISDN Single Basic Rate","PCI",0,5015,45063,65535,65535,0,1,1,38},
	{13,6,"B008","Billion B008","ISDN Single Basic Rate","PCI",0,5015,45064,65535,65535,0,1,1,39},
	{14,6,"B009","Billion B009","ISDN Single Basic Rate","PCI",0,5015,45065,65535,65535,0,1,1,40},
	{15,6,"B00A","Billion B00A","ISDN Single Basic Rate","PCI",0,5015,45066,65535,65535,0,1,1,41},
	{16,6,"B00B","Billion B00B","ISDN Single Basic Rate","PCI",0,5015,45067,65535,65535,0,1,1,42},
	{17,6,"B00C","Billion B00C","ISDN Single Basic Rate","PCI",0,5015,45068,65535,65535,0,1,1,43},
	{18,4,"B1","AVM B1","ISDN Single Basic Rate","ISA",0,65535,65535,65535,65535,0,0,1,1},
	{19,4,"B1 PCI","AVM B1 PCI","ISDN Single Basic Rate","PCI",0,4676,1792,65535,65535,0,1,1,79},
	{20,4,"B1 PCMCIA","AVM B1 PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,0,1,80},
	{21,21,"B100","Seyon B100","ISDN Single Basic Rate","PCI",0,5015,45312,65535,65535,0,1,1,44},
	{22,4,"BlueFRITZ!USB","AVM BlueFRITZ!USB","Others","USB",0,1404,8704,65535,65535,0,1,1,95},
	{23,4,"C2","AVM C2","ISDN Multiple Basic Rate","PCI",0,4113,4197,4676,4352,0,2,1,82},
	{24,4,"C4","AVM C4","ISDN Multiple Basic Rate","PCI",0,4113,4197,4676,2048,0,4,1,81},
	{25,3,"Comfort 1200 System Telephone","Auerswald Comfort 1200 System Telephone","ISDN Single Basic Rate","USB",0,2495,242,65535,65535,0,1,1,71},
	{26,3,"Comfort 2000 System Telephone","Auerswald Comfort 2000 System Telephone","ISDN Single Basic Rate","USB",0,2495,241,65535,65535,0,1,1,72},
	{27,3,"COMpact 2104 USB","Auerswald COMpact 2104 USB","ISDN Single Basic Rate","USB",0,2495,192,65535,65535,0,1,1,70},
	{28,3,"COMpact 2206 USB","Auerswald COMpact 2206 USB","ISDN Single Basic Rate","USB",0,2495,219,65535,65535,0,1,1,69},
	{29,25,"Concept","DTAG Concept","ISDN Single Basic Rate","PCI",0,2161,65442,65535,65535,0,1,1,49},
	{30,8,"DataFire Micro V (Europe)","Digi DataFire Micro V (Europe)","ISDN Single Basic Rate","PCI",0,4431,113,65535,65535,0,1,1,54},
	{31,8,"DataFire Micro V (North America)","Digi DataFire Micro V (North America)","ISDN Single Basic Rate","PCI",0,4431,115,65535,65535,0,1,1,56},
	{32,8,"DataFire Micro V IOM2 (Europe)","Digi DataFire Micro V IOM2 (Europe)","ISDN Single Basic Rate","PCI",0,4431,112,65535,65535,0,1,1,53},
	{33,8,"DataFire Micro V IOM2 (North America)","Digi DataFire Micro V IOM2 (North America)","ISDN Single Basic Rate","PCI",0,4431,114,65535,65535,0,1,1,55},
	{34,24,"DC 104 USB ISDN Modem Rev 2","Sitecom DC 104 USB ISDN Modem Rev 2","ISDN Single Basic Rate","USB",0,2393,11216,65535,65535,0,1,1,77},
	{35,24,"DC 105 ISDN TA","Sitecom DC 105 ISDN TA","ISDN Single Basic Rate","PCI",0,6189,12393,6189,12393,0,1,1,58},
	{36,24,"DC-104 USB ISDN Modem Rev 1","Sitecom DC-104 USB ISDN Modem Rev 1","ISDN Single Basic Rate","USB",0,1155,18448,65535,65535,0,1,1,75},
	{37,11,"Diva 2.0 PCI","Eicon Diva 2.0 PCI","ISDN Single Basic Rate","PCI",0,4403,57346,65535,65535,0,1,1,5},
	{38,11,"Diva 2.01 PCI","Eicon Diva 2.01 PCI","ISDN Single Basic Rate","PCI",0,4403,57349,65535,65535,0,1,1,6},
	{39,11,"Diva 2.02 PCI","Eicon Diva 2.02 PCI","ISDN Single Basic Rate","PCI",0,4403,57355,65535,65535,0,1,1,8},
	{40,11,"Diva 2.0U PCI","Eicon Diva 2.0U PCI","ISDN Single Basic Rate","PCI",0,4403,57348,65535,65535,0,1,1,7},
	{41,14,"Djinn Itoo","Gazel Djinn Itoo","ISDN Single Basic Rate","PCI",0,4277,4433,65535,65535,0,1,1,35},
	{42,13,"enter:now","Formula-n enter:now","ISDN Single Basic Rate","PCI",0,57689,1,85,2,0,1,1,68},
	{43,4,"FRITZ!Box","AVM FRITZ!Box","DSL","USB",0,1404,14082,65535,65535,0,0,1,103},
	{44,4,"FRITZ!Box (Annex A)","AVM FRITZ!Box (Annex A)","DSL","USB",0,1404,15873,65535,65535,0,0,1,107},
	{45,4,"FRITZ!Box Fon (Annex A)","AVM FRITZ!Box Fon (Annex A)","DSL","USB",0,1404,15360,65535,65535,0,0,1,106},
	{46,4,"FRITZ!Box Fon WLAN","AVM FRITZ!Box Fon WLAN","DSL","USB",0,1404,16385,65535,65535,0,0,1,105},
	{47,4,"FRITZ!Box SL","AVM FRITZ!Box SL","DSL","USB",0,1404,14081,65535,65535,0,0,1,102},
	{48,4,"FRITZ!Box SL WLAN","AVM FRITZ!Box SL WLAN","DSL","USB",0,1404,15360,65535,65535,0,0,1,104},
	{49,4,"FRITZ!Card DSL SL","AVM FRITZ!Card DSL SL","DSL","PCI",0,4676,9984,65535,65535,0,0,1,91},
	{50,4,"FRITZ!Card DSL SL USB","AVM FRITZ!Card DSL SL USB","DSL","USB",0,1404,13568,65535,65535,0,0,1,92},
	{51,4,"FRITZ!Card DSL USB","AVM FRITZ!Card DSL USB","ISDN Basic Rate and DSL","USB",0,1404,8960,65535,65535,0,1,1,89},
	{52,4,"FRITZ!Card DSL USB v2.0","AVM FRITZ!Card DSL USB v2.0","ISDN Basic Rate and DSL","USB",0,1404,13824,65535,65535,0,1,1,93},
	{53,4,"FRITZ!Card DSL v2.0","AVM FRITZ!Card DSL v2.0","ISDN Basic Rate and DSL","PCI",0,4676,10496,65535,65535,0,1,1,90},
	{54,4,"FRITZ!Card PCI","AVM FRITZ!Card PCI","ISDN Single Basic Rate","PCI",0,4676,2560,65535,65535,0,1,1,27},
	{55,4,"FRITZ!Card PCI","AVM FRITZ!Card PCI","ISDN Single Basic Rate","PCI",0,4676,2560,65535,65535,0,1,2,83},
	{56,4,"FRITZ!Card PCI v2.0","AVM FRITZ!Card PCI v2.0","ISDN Single Basic Rate","PCI",0,4676,3584,4676,3584,0,1,1,73},
	{57,4,"FRITZ!Card PCI v2.0","AVM FRITZ!Card PCI v2.0","ISDN Single Basic Rate","PCI",0,4676,3584,4676,3584,0,1,2,84},
	{58,4,"FRITZ!Card PCMCIA","AVM FRITZ!Card PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,23},
	{59,4,"FRITZ!Card PCMCIA","AVM FRITZ!Card PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,2,85},
	{60,4,"FRITZ!Card USB v2.0","AVM FRITZ!Card USB v2.0","ISDN Single Basic Rate","USB",0,1404,4096,65535,65535,0,1,1,87},
	{61,4,"FRITZ!Card USB v2.1","AVM FRITZ!Card USB v2.1","ISDN Single Basic Rate","USB",0,1404,6400,65535,65535,0,1,1,88},
	{62,23,"Gigaset M101 Data","Siemens Gigaset M101 Data","ISDN Single Basic Rate","Serial",0,65535,65535,65535,65535,0,1,1,101},
	{63,23,"Gigaset M105 Data","Siemens Gigaset M105 Data","ISDN Single Basic Rate","USB",0,1665,9,65535,65535,0,1,1,100},
	{64,23,"Gigaset SX205","Siemens Gigaset SX205","ISDN Single Basic Rate","USB",0,1665,1,65535,65535,0,1,1,96},
	{65,23,"Gigaset SX255","Siemens Gigaset SX255","ISDN Single Basic Rate","USB",0,1665,2,65535,65535,0,1,1,97},
	{66,23,"Gigaset SX303 isdn","Siemens Gigaset SX303 isdn","ISDN Single Basic Rate","USB",0,1665,33,65535,65535,0,1,1,98},
	{67,23,"Gigaset SX353 isdn","Siemens Gigaset SX353 isdn","ISDN Single Basic Rate","USB",0,1665,34,65535,65535,0,1,1,99},
	{68,7,"HFC 2BDS0","CC HFC 2BDS0","ISDN Single Basic Rate","PCI",0,5015,11216,65535,65535,0,1,1,52},
	{69,28,"ISDN PCI Card TA","USR ISDN PCI Card TA","ISDN Single Basic Rate","PCI",0,4176,26258,5868,13321,0,1,1,66},
	{70,16,"MC145575","Motorola MC145575","ISDN Single Basic Rate","PCI",0,4177,256,65535,65535,0,1,1,50},
	{71,12,"Microlink PCI","Elsa Microlink PCI","ISDN Single Basic Rate","PCI",0,4168,4096,65535,65535,0,1,1,14},
	{72,9,"miniVigor 128 ISDN TA","Draytech miniVigor 128 ISDN TA","ISDN Single Basic Rate","USB",0,2393,11216,65535,65535,0,1,1,78},
	{73,27,"NetJet PCI","TJET NetJet PCI","ISDN Single Basic Rate","PCI",0,57689,1,255,15,0,1,1,16},
	{74,27,"NetSpider-U PCI","TJET NetSpider-U PCI","ISDN Single Basic Rate","PCI",0,57689,1,65535,65535,0,1,1,67},
	{75,18,"Niccy PCI","Sagem Niccy PCI","ISDN Single Basic Rate","PCI",0,4711,4118,65535,65535,0,1,1,21},
	{76,26,"PCI","Teles PCI","ISDN Single Basic Rate","PCI",0,4574,24864,0,0,0,1,1,18},
	{77,1,"PCI (CCD HFC)","AsKey PCI (CCD HFC)","ISDN Single Basic Rate","PCI",0,5015,11216,5199,5892,0,1,1,47},
	{78,2,"PCI (CCD HFC)","Asus PCI (CCD HFC)","ISDN Single Basic Rate","PCI",0,4163,1653,1653,5892,0,1,1,45},
	{79,10,"PCI (CCD HFC)","Dynalink PCI (CCD HFC)","ISDN Single Basic Rate","PCI",0,5015,11216,4163,5892,0,1,1,46},
	{80,2,"PCI (W6692)","Asus PCI (W6692)","ISDN Single Basic Rate","PCI",0,4176,26258,4163,5890,0,1,1,59},
	{81,10,"PCI (W6692)","Dynalink PCI (W6692)","ISDN Single Basic Rate","PCI",0,4163,1653,1653,5890,0,1,1,63},
	{82,1,"PCI (W6692)","AsKey PCI (W6692)","ISDN Single Basic Rate","PCI",0,4176,26258,5199,5890,0,1,1,60},
	{83,1,"PCI + Voice (W6692)","AsKey PCI + Voice (W6692)","ISDN Single Basic Rate","PCI",0,4176,26258,5199,5891,0,1,1,62},
	{84,2,"PCI + Voice (W6692)","Asus PCI + Voice (W6692)","ISDN Single Basic Rate","PCI",0,4176,26258,4163,5891,0,1,1,61},
	{85,26,"PCI v2","Teles PCI v2","ISDN Single Basic Rate","PCI",0,57689,1,167,1,0,1,1,17},
	{86,12,"PCMCIA","Elsa PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,3},
	{87,26,"PCMCIA","Teles PCMCIA","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,2},
	{88,12,"PCMCIA IPAC","Elsa PCMCIA IPAC","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,4},
	{89,19,"Quadro","Scitel Quadro","ISDN Single Basic Rate","PCI",0,4277,36944,2161,65448,0,1,1,32},
	{90,12,"Quickstep 1000 PCI","Elsa Quickstep 1000 PCI","ISDN Single Basic Rate","PCI",0,4168,4096,65535,65535,0,1,1,12},
	{91,12,"Quickstep 3000 PCI","Elsa Quickstep 3000 PCI","ISDN Single Basic Rate","PCI",0,4168,12288,65535,65535,0,1,1,13},
	{92,14,"R685","Gazel R685","ISDN Single Basic Rate","PCI",0,4277,4144,65535,65535,0,1,1,33},
	{93,14,"R753","Gazel R753","ISDN Single Basic Rate","PCI",0,4277,4434,65535,65535,0,1,1,34},
	{94,26,"S0Box","Teles S0Box","ISDN Single Basic Rate","Parallel",0,65535,65535,65535,65535,0,1,1,22},
	{95,15,"saphir III","HST saphir III","ISDN Single Basic Rate","PCI",0,57689,2,82,1,0,1,1,11},
	{96,20,"Speed Fax+ PCI","Sedlbauer Speed Fax+ PCI","ISDN Single Basic Rate","PCI",0,57689,2,84,1,0,1,1,30},
	{97,17,"Speed Fax+ PCI","Pyramid Speed Fax+ PCI","ISDN Single Basic Rate","PCI",0,57689,2,81,1,0,1,1,29},
	{98,20,"Speed PCI","Sedlbauer Speed PCI","ISDN Single Basic Rate","PCI",0,57689,2,83,1,0,1,1,10},
	{99,20,"Speed Star","Sedlbauer Speed Star","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,19},
	{100,20,"Speed Star2","Sedlbauer Speed Star2","ISDN Single Basic Rate","PCMCIA",0,65535,65535,65535,65535,0,1,1,20},
	{101,20,"Speed Win2 PC104","Sedlbauer Speed Win2 PC104","ISDN Single Basic Rate","PC104",0,0,0,0,0,0,1,1,9},
	{102,22,"ST5481 USB Adapter","SGST ST5481 USB Adapter","ISDN Single Basic Rate","USB",0,1155,18448,65535,65535,0,1,1,76},
	{103,4,"T1 PCI","AVM T1 PCI","ISDN Primary Rate","PCI",0,4676,4608,65535,65535,0,1,1,94},
	{104,29,"W6692 card","Winbond W6692 card","ISDN Single Basic Rate","PCI",0,4176,26258,65535,65535,0,1,1,65},
};
static int cdb_isdncard_idsorted_init[] = {
	101,36,102,60,61,22,51,50,
	52,47,43,9,45,48,44,46,
	4,64,65,63,66,67,7,29,
	34,72,27,28,26,25,24,23,
	81,78,71,90,91,80,84,82,
	83,69,104,70,92,41,93,89,
	37,40,38,39,32,30,33,31,
	76,8,19,54,55,56,57,103,
	49,53,75,79,77,68,10,11,
	12,13,14,15,16,17,21,1,
	2,35,42,85,73,3,74,97,
	95,98,96,5,6,18,20,58,
	59,62,86,87,88,94,99,100,
};
/* driver database */
static cdb_isdn_vario cdb_isdnvario_info_init[] = {
	{0,0,0,0,0,0,"","","","","","","","","","","","","","",0,""},
	{1,0,0,0,0,0,"","","","","","","","","","","","","","",18,"CAPI 2.0 driver"},
	{2,0,8,8,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",87,"HiSax driver"},
	{3,0,393226,10,6,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",86,"HiSax driver"},
	{4,0,720906,10,11,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",88,"HiSax driver"},
	{5,0,131083,11,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",37,"HiSax driver"},
	{6,0,262155,11,4,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",38,"HiSax driver"},
	{7,0,786443,11,12,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",40,"HiSax driver"},
	{8,0,851979,11,13,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",39,"HiSax driver"},
	{9,0,262159,15,4,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",101,"HiSax driver"},
	{10,0,393231,15,6,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",98,"HiSax driver"},
	{11,0,589839,15,9,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",95,"HiSax driver"},
	{12,0,589842,18,9,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",90,"HiSax driver"},
	{13,0,655378,18,10,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",91,"HiSax driver"},
	{14,0,786450,18,12,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",71,"HiSax driver"},
	{15,0,20,20,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",3,"HiSax driver"},
	{16,0,65556,20,1,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",73,"HiSax driver"},
	{17,0,131092,20,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",85,"HiSax driver"},
	{18,0,21,21,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",76,"HiSax driver"},
	{19,0,131094,22,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",99,"HiSax driver"},
	{20,0,327702,22,5,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",100,"HiSax driver"},
	{21,0,131096,24,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",75,"HiSax driver"},
	{22,0,25,25,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","0x278,0x378,0x3bc","5,7","","",94,"HiSax driver"},
	{23,0,26,26,0,1,"hisax","","","","","OpenSource without Fax G3","i4l-base","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",58,"HiSax driver"},
	{24,0,26,26,0,1,"hisax","","","","","OpenSource without Fax G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",59,"HiSax driver"},
	{25,0,65562,26,1,1,"hisax","","","","","OpenSource without Fax G3","i4l-base","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",5,"HiSax driver"},
	{26,0,65562,26,1,1,"hisax","","","","","OpenSource without Fax G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",6,"HiSax driver"},
	{27,0,65563,27,1,1,"hisax","","","","","OpenSource without Fax G3","i4l-base","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",54,"HiSax driver"},
	{28,0,65563,27,1,1,"hisax","","","","","OpenSource without Fax G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",55,"HiSax driver"},
	{29,0,458780,28,7,1,"hisax","","","","ISAR.BIN","","i4l-base","","1TR6,DSS1,LEASED,NI1","FCLASS1,I4L","","","","Fax",97,"HiSax driver"},
	{30,0,524316,28,8,1,"hisax","","","","ISAR.BIN","","i4l-base","","1TR6,DSS1,LEASED,NI1","FCLASS1,I4L","","","","Fax",96,"HiSax driver"},
	{31,0,32,32,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",8,"HiSax driver"},
	{32,0,33,33,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",89,"HiSax driver"},
	{33,0,34,34,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",92,"HiSax driver"},
	{34,0,65570,34,1,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",93,"HiSax driver"},
	{35,0,131106,34,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",41,"HiSax driver"},
	{36,0,65571,35,1,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",10,"HiSax driver"},
	{37,0,131107,35,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",11,"HiSax driver"},
	{38,0,196643,35,3,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",12,"HiSax driver"},
	{39,0,262179,35,4,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",13,"HiSax driver"},
	{40,0,327715,35,5,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",14,"HiSax driver"},
	{41,0,393251,35,6,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",15,"HiSax driver"},
	{42,0,458787,35,7,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",16,"HiSax driver"},
	{43,0,524323,35,8,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",17,"HiSax driver"},
	{44,0,589859,35,9,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",21,"HiSax driver"},
	{45,0,655395,35,10,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",78,"HiSax driver"},
	{46,0,720931,35,11,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",79,"HiSax driver"},
	{47,0,786467,35,12,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",77,"HiSax driver"},
	{48,0,852003,35,13,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",7,"HiSax driver"},
	{49,0,917539,35,14,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",29,"HiSax driver"},
	{50,0,983075,35,15,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",70,"HiSax driver"},
	{51,0,1048611,35,16,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",2,"HiSax driver"},
	{52,0,1114147,35,17,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",68,"HiSax driver"},
	{53,0,1179683,35,18,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",32,"HiSax driver"},
	{54,0,1245219,35,19,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",30,"HiSax driver"},
	{55,0,1310755,35,20,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",33,"HiSax driver"},
	{56,0,1376291,35,21,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",31,"HiSax driver"},
	{57,0,1441827,35,22,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",1,"HiSax driver"},
	{58,0,1507363,35,23,1,"hisax","","","","","","","","1TR6,DSS1,LEASED,NI1","I4L","","","","",35,"HiSax driver"},
	{59,0,36,36,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",80,"HiSax driver"},
	{60,0,65572,36,1,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",82,"HiSax driver"},
	{61,0,131108,36,2,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",84,"HiSax driver"},
	{62,0,196644,36,3,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",83,"HiSax driver"},
	{63,0,262180,36,4,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",81,"HiSax driver"},
	{64,0,327716,36,5,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",4,"HiSax driver"},
	{65,0,393252,36,6,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",104,"HiSax driver"},
	{66,0,458788,36,7,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",69,"HiSax driver"},
	{67,0,38,38,0,1,"hisax","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",74,"HiSax driver"},
	{68,0,65577,41,1,1,"hisax","","","","","under development","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",42,"HiSax driver"},
	{69,0,65578,42,1,1,"auerswald","","","","","","i4l-base,i4l-isdnlog","","DSS1","I4L","","","","",28,"HiSax driver"},
	{70,0,131114,42,2,1,"auerswald","","","","","","i4l-base,i4l-isdnlog","","DSS1","I4L","","","","",27,"HiSax driver"},
	{71,0,196650,42,3,1,"auerswald","","","","","","i4l-base,i4l-isdnlog","","DSS1","I4L","","","","",25,"HiSax driver"},
	{72,0,262186,42,4,1,"auerswald","","","","","","i4l-base,i4l-isdnlog","","","I4L","","","","",26,"HiSax driver"},
	{73,0,1000,1000,0,1,"hisax_fcpcipnp","","","","","OpenSource without Fax G3","i4l-base","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",56,"HiSax driver"},
	{74,0,1000,1000,0,1,"hisax_fcpcipnp","","","","","OpenSource without Fax G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","1TR6,DSS1,LEASED,NI1","I4L","","","","Fax",57,"HiSax driver"},
	{75,0,1001,1001,0,1,"hisax_st5481","","","","","","i4l-base,i4l-isdnlog","","1TR6,DSS1,LEASED,NI1","I4L","","","","",36,"HiSax driver"},
	{76,0,66537,1001,1,1,"hisax_st5481","","","","","","i4l-base","","1TR6,DSS1,LEASED,NI1","I4L","","","","",102,"HiSax driver"},
	{77,0,66538,1002,1,1,"hfc_usb","","","","","","","","1TR6,DSS1,LEASED,NI1","I4L","","","","",34,"HiSax driver"},
	{78,0,66538,1002,1,1,"hfc_usb","","","","","","","","1TR6,DSS1,LEASED,NI1","I4L","","","","",72,"HiSax driver"},
	{79,0,73537,8001,1,1,"b1pci","","","","b1-%{PROTO}.t4","","capi4linux,i4l-base,i4l-isdnlog,i4lfirm","","1TR6,DSS1,LEASED,NI1","CAPI20,CAPI20 Fax,I4L","","","","Fax",19,"CAPI 2.0 driver"},
	{80,0,139073,8001,2,1,"b1pcmcia","","","","b1-%{PROTO}.t4","","capi4linux,i4l-base,i4l-isdnlog,i4lfirm","","1TR6,DSS1,LEASED,NI1","CAPI20,CAPI20 Fax,I4L","","","","Fax",20,"CAPI 2.0 driver"},
	{81,0,204609,8001,3,1,"c4","","","","c4.bin","","capi4linux,i4l-base,i4l-isdnlog,i4lfirm","","DSS1,LEASED","CAPI20,CAPI20 Fax,I4L","","","","Fax",24,"CAPI 2.0 driver"},
	{82,0,401217,8001,6,1,"c4","","","","c2.bin","","capi4linux,i4l-base,i4l-isdnlog,i4lfirm","","DSS1,LEASED","CAPI20,CAPI20 Fax,I4L","","","","Fax",23,"CAPI 2.0 driver"},
	{83,28,73538,8002,1,0,"fcpci","","","","","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","DSS1","CAPI20,CAPI20 Fax","","","","Fax",55,"CAPI 2.0 driver"},
	{84,74,139074,8002,2,0,"fcpci","","","","","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","DSS1","CAPI20,CAPI20 Fax","","","","Fax",57,"CAPI 2.0 driver"},
	{85,24,335682,8002,5,0,"fcpcmcia","","","","","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","DSS1","CAPI20,CAPI20 Fax","","","","Fax",59,"CAPI 2.0 driver"},
	{86,26,401218,8002,6,0,"fcpcmcia","","","","","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card has multiple drivers, some functions are only available on the binonly driver","DSS1","CAPI20,CAPI20 Fax","","","","Fax",6,"CAPI 2.0 driver"},
	{87,0,139075,8003,2,0,"fcusb2","","","","","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card is supported with binonly drivers from the manufacturer","DSS1","CAPI20,CAPI20 Fax","","","","Fax",60,"CAPI 2.0 driver"},
	{88,0,204611,8003,3,0,"fcusb2","","","","","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card is supported with binonly drivers from the manufacturer","DSS1","CAPI20,CAPI20 Fax","","","","Fax",61,"CAPI 2.0 driver"},
	{89,0,139076,8004,2,1,"fcdslusb","","","","fdsubase.frm","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card is supported with binonly drivers from the manufacturer","DSS1","CAPI20,CAPI20 Fax","","","","DSL,Fax",51,"CAPI 2.0 driver"},
	{90,0,204612,8004,3,1,"fcdsl2","","","","fds2base.bin","binary only CAPI with FAX G3 and DSL","capi4linux,i4l-base,i4l-isdnlog","card is supported with binary only drivers from the manufacturer","DSS1","CAPI20,CAPI20 Fax","","","","DSL,Fax",53,"CAPI 2.0 driver"},
	{91,0,270148,8004,4,1,"fcdslsl","","","","fdssbase.bin","DSL only card with CAPI2.0","capi4linux,i4l-base","DSL only card with binonly driver from the manufacturer","???","CAPI20","","","","DSLONLY",49,"CAPI 2.0 driver"},
	{92,0,335684,8004,5,1,"fcdslslusb","","","","fdlubase.frm","binary only CAPI","capi4linux,i4l-base","DSL only card with binonly drivers from the manufacturer","???","CAPI20","","","","DSLONLY",50,"CAPI 2.0 driver"},
	{93,0,401220,8004,6,1,"fcdslusb2","","","","fdsubase2.frm","binary only CAPI with FAX G3","capi4linux,i4l-base,i4l-isdnlog","This card is supported with binonly drivers from the manufacturer","DSS1","CAPI20,CAPI20 Fax","","","","DSL,Fax",52,"CAPI 2.0 driver"},
	{94,0,139077,8005,2,1,"t1pci","","","","t1-{PROF}.t4","","capi4linux,i4l-base,i4l-isdnlog,i4lfirm","","1TR6,DSS1","CAPI20,CAPI20 Fax,I4L","","","","Fax",103,"CAPI 2.0 driver"},
	{95,0,73542,8006,1,1,"bfusb","","","","bfubase.frm","","bluez-firmware,bluez-libs,bluez-utils,capi4linux,i4l-base,i4l-isdnlog","","DSS1","CAPI20","","","","BLUETOOTH,Basic Rate",22,"CAPI 2.0 driver"},
	{96,0,73636,8100,1,1,"bas_gigaset","","","","","","i4l-base","","DSS1","I4L","","","","",64,"I4L driver"},
	{97,0,139172,8100,2,1,"bas_gigaset","","","","","","i4l-base","","DSS1","I4L","","","","",65,"I4L driver"},
	{98,0,204708,8100,3,1,"bas_gigaset","","","","","","i4l-base","","DSS1","I4L","","","","",66,"I4L driver"},
	{99,0,270244,8100,4,1,"bas_gigaset","","","","","","i4l-base","","DSS1","I4L","","","","",67,"I4L driver"},
	{100,0,8101,8101,0,1,"usb_gigaset","","","","","","i4l-base","","DSS1","I4L","","","","",63,"I4L driver"},
	{101,0,8102,8102,0,1,"ser_gigaset","","","","","","i4l-base","","DSS1","I4L","","","","",62,"I4L driver"},
	{102,0,-65535,9999,1,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",47,"other"},
	{103,0,-65534,9999,2,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",43,"other"},
	{104,0,-65533,9999,3,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",48,"other"},
	{105,0,-65532,9999,4,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",46,"other"},
	{106,0,-65531,9999,5,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",45,"other"},
	{107,0,-65530,9999,6,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",44,"other"},
	{108,0,-65529,9999,7,1,"usbnet","","","","","","ppp,smpppd","","none","pppoe","","","","DSLONLY,PPPOE",9,"other"},
};
