{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttribute@ structure represents the common portions of all
-- attributes.
-- 
-- Particular types of attributes include this structure as their initial
-- portion. The common portion of the attribute holds the range to which
-- the value in the type-specific part of the attribute applies and should
-- be initialized using 'GI.Pango.Structs.Attribute.attributeInit'. By default, an attribute
-- will have an all-inclusive range of [0,@/G_MAXUINT/@].

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.Attribute
    ( 

-- * Exported types
    Attribute(..)                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [asColor]("GI.Pango.Structs.Attribute#g:method:asColor"), [asFloat]("GI.Pango.Structs.Attribute#g:method:asFloat"), [asFontDesc]("GI.Pango.Structs.Attribute#g:method:asFontDesc"), [asFontFeatures]("GI.Pango.Structs.Attribute#g:method:asFontFeatures"), [asInt]("GI.Pango.Structs.Attribute#g:method:asInt"), [asLanguage]("GI.Pango.Structs.Attribute#g:method:asLanguage"), [asShape]("GI.Pango.Structs.Attribute#g:method:asShape"), [asSize]("GI.Pango.Structs.Attribute#g:method:asSize"), [asString]("GI.Pango.Structs.Attribute#g:method:asString"), [copy]("GI.Pango.Structs.Attribute#g:method:copy"), [destroy]("GI.Pango.Structs.Attribute#g:method:destroy"), [equal]("GI.Pango.Structs.Attribute#g:method:equal"), [init]("GI.Pango.Structs.Attribute#g:method:init").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveAttributeMethod                  ,
#endif

-- ** asColor #method:asColor#

#if defined(ENABLE_OVERLOADING)
    AttributeAsColorMethodInfo              ,
#endif
    attributeAsColor                        ,


-- ** asFloat #method:asFloat#

#if defined(ENABLE_OVERLOADING)
    AttributeAsFloatMethodInfo              ,
#endif
    attributeAsFloat                        ,


-- ** asFontDesc #method:asFontDesc#

#if defined(ENABLE_OVERLOADING)
    AttributeAsFontDescMethodInfo           ,
#endif
    attributeAsFontDesc                     ,


-- ** asFontFeatures #method:asFontFeatures#

#if defined(ENABLE_OVERLOADING)
    AttributeAsFontFeaturesMethodInfo       ,
#endif
    attributeAsFontFeatures                 ,


-- ** asInt #method:asInt#

#if defined(ENABLE_OVERLOADING)
    AttributeAsIntMethodInfo                ,
#endif
    attributeAsInt                          ,


-- ** asLanguage #method:asLanguage#

#if defined(ENABLE_OVERLOADING)
    AttributeAsLanguageMethodInfo           ,
#endif
    attributeAsLanguage                     ,


-- ** asShape #method:asShape#

#if defined(ENABLE_OVERLOADING)
    AttributeAsShapeMethodInfo              ,
#endif
    attributeAsShape                        ,


-- ** asSize #method:asSize#

#if defined(ENABLE_OVERLOADING)
    AttributeAsSizeMethodInfo               ,
#endif
    attributeAsSize                         ,


-- ** asString #method:asString#

#if defined(ENABLE_OVERLOADING)
    AttributeAsStringMethodInfo             ,
#endif
    attributeAsString                       ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    AttributeCopyMethodInfo                 ,
#endif
    attributeCopy                           ,


-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    AttributeDestroyMethodInfo              ,
#endif
    attributeDestroy                        ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    AttributeEqualMethodInfo                ,
#endif
    attributeEqual                          ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    AttributeInitMethodInfo                 ,
#endif
    attributeInit                           ,




 -- * Properties


-- ** endIndex #attr:endIndex#
-- | end index of the range (in bytes). The character at this index
--   is not included in the range.

#if defined(ENABLE_OVERLOADING)
    attribute_endIndex                      ,
#endif
    getAttributeEndIndex                    ,
    setAttributeEndIndex                    ,


-- ** klass #attr:klass#
-- | the class structure holding information about the type of the attribute

#if defined(ENABLE_OVERLOADING)
    attribute_klass                         ,
#endif
    clearAttributeKlass                     ,
    getAttributeKlass                       ,
    setAttributeKlass                       ,


-- ** startIndex #attr:startIndex#
-- | the start index of the range (in bytes).

#if defined(ENABLE_OVERLOADING)
    attribute_startIndex                    ,
#endif
    getAttributeStartIndex                  ,
    setAttributeStartIndex                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString

#endif

-- | Memory-managed wrapper type.
newtype Attribute = Attribute (SP.ManagedPtr Attribute)
    deriving (Eq)

instance SP.ManagedPtrNewtype Attribute where
    toManagedPtr (Attribute p) = p

foreign import ccall "pango_attribute_get_type" c_pango_attribute_get_type :: 
    IO GType

type instance O.ParentTypes Attribute = '[]
instance O.HasParentTypes Attribute

instance B.Types.TypedObject Attribute where
    glibType = c_pango_attribute_get_type

instance B.Types.GBoxed Attribute

-- | Convert t'Attribute' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Attribute) where
    gvalueGType_ = c_pango_attribute_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Attribute)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Attribute)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Attribute ptr
        else return P.Nothing
        
    

-- | Get the value of the “@klass@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attribute #klass
-- @
getAttributeKlass :: MonadIO m => Attribute -> m (Maybe Pango.AttrClass.AttrClass)
getAttributeKlass s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Pango.AttrClass.AttrClass)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Pango.AttrClass.AttrClass) val'
        return val''
    return result

-- | Set the value of the “@klass@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attribute [ #klass 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttributeKlass :: MonadIO m => Attribute -> Ptr Pango.AttrClass.AttrClass -> m ()
setAttributeKlass s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Pango.AttrClass.AttrClass)

-- | Set the value of the “@klass@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #klass
-- @
clearAttributeKlass :: MonadIO m => Attribute -> m ()
clearAttributeKlass s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Pango.AttrClass.AttrClass)

#if defined(ENABLE_OVERLOADING)
data AttributeKlassFieldInfo
instance AttrInfo AttributeKlassFieldInfo where
    type AttrBaseTypeConstraint AttributeKlassFieldInfo = (~) Attribute
    type AttrAllowedOps AttributeKlassFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttributeKlassFieldInfo = (~) (Ptr Pango.AttrClass.AttrClass)
    type AttrTransferTypeConstraint AttributeKlassFieldInfo = (~)(Ptr Pango.AttrClass.AttrClass)
    type AttrTransferType AttributeKlassFieldInfo = (Ptr Pango.AttrClass.AttrClass)
    type AttrGetType AttributeKlassFieldInfo = Maybe Pango.AttrClass.AttrClass
    type AttrLabel AttributeKlassFieldInfo = "klass"
    type AttrOrigin AttributeKlassFieldInfo = Attribute
    attrGet = getAttributeKlass
    attrSet = setAttributeKlass
    attrConstruct = undefined
    attrClear = clearAttributeKlass
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.klass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#g:attr:klass"
        })

attribute_klass :: AttrLabelProxy "klass"
attribute_klass = AttrLabelProxy

#endif


-- | Get the value of the “@start_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attribute #startIndex
-- @
getAttributeStartIndex :: MonadIO m => Attribute -> m Word32
getAttributeStartIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@start_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attribute [ #startIndex 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttributeStartIndex :: MonadIO m => Attribute -> Word32 -> m ()
setAttributeStartIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data AttributeStartIndexFieldInfo
instance AttrInfo AttributeStartIndexFieldInfo where
    type AttrBaseTypeConstraint AttributeStartIndexFieldInfo = (~) Attribute
    type AttrAllowedOps AttributeStartIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttributeStartIndexFieldInfo = (~) Word32
    type AttrTransferTypeConstraint AttributeStartIndexFieldInfo = (~)Word32
    type AttrTransferType AttributeStartIndexFieldInfo = Word32
    type AttrGetType AttributeStartIndexFieldInfo = Word32
    type AttrLabel AttributeStartIndexFieldInfo = "start_index"
    type AttrOrigin AttributeStartIndexFieldInfo = Attribute
    attrGet = getAttributeStartIndex
    attrSet = setAttributeStartIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.startIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#g:attr:startIndex"
        })

attribute_startIndex :: AttrLabelProxy "startIndex"
attribute_startIndex = AttrLabelProxy

#endif


-- | Get the value of the “@end_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attribute #endIndex
-- @
getAttributeEndIndex :: MonadIO m => Attribute -> m Word32
getAttributeEndIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Word32
    return val

-- | Set the value of the “@end_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attribute [ #endIndex 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttributeEndIndex :: MonadIO m => Attribute -> Word32 -> m ()
setAttributeEndIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data AttributeEndIndexFieldInfo
instance AttrInfo AttributeEndIndexFieldInfo where
    type AttrBaseTypeConstraint AttributeEndIndexFieldInfo = (~) Attribute
    type AttrAllowedOps AttributeEndIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttributeEndIndexFieldInfo = (~) Word32
    type AttrTransferTypeConstraint AttributeEndIndexFieldInfo = (~)Word32
    type AttrTransferType AttributeEndIndexFieldInfo = Word32
    type AttrGetType AttributeEndIndexFieldInfo = Word32
    type AttrLabel AttributeEndIndexFieldInfo = "end_index"
    type AttrOrigin AttributeEndIndexFieldInfo = Attribute
    attrGet = getAttributeEndIndex
    attrSet = setAttributeEndIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.endIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#g:attr:endIndex"
        })

attribute_endIndex :: AttrLabelProxy "endIndex"
attribute_endIndex = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Attribute
type instance O.AttributeList Attribute = AttributeAttributeList
type AttributeAttributeList = ('[ '("klass", AttributeKlassFieldInfo), '("startIndex", AttributeStartIndexFieldInfo), '("endIndex", AttributeEndIndexFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Attribute::as_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` such as foreground"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "AttrColor" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_color" pango_attribute_as_color :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrColor.AttrColor)

-- | Returns the attribute cast to @PangoAttrColor@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsColor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ such as foreground
    -> m (Maybe Pango.AttrColor.AttrColor)
    -- ^ __Returns:__ The attribute as @PangoAttrColor@,
    --   or 'P.Nothing' if it\'s not a color attribute
attributeAsColor attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_color attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrColor.AttrColor) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsColorMethodInfo
instance (signature ~ (m (Maybe Pango.AttrColor.AttrColor)), MonadIO m) => O.OverloadedMethod AttributeAsColorMethodInfo Attribute signature where
    overloadedMethod = attributeAsColor

instance O.OverloadedMethodInfo AttributeAsColorMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsColor"
        })


#endif

-- method Attribute::as_float
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` such as scale"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "AttrFloat" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_float" pango_attribute_as_float :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrFloat.AttrFloat)

-- | Returns the attribute cast to @PangoAttrFloat@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsFloat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ such as scale
    -> m (Maybe Pango.AttrFloat.AttrFloat)
    -- ^ __Returns:__ The attribute as @PangoAttrFloat@,
    --   or 'P.Nothing' if it\'s not a floating point attribute
attributeAsFloat attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_float attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrFloat.AttrFloat) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsFloatMethodInfo
instance (signature ~ (m (Maybe Pango.AttrFloat.AttrFloat)), MonadIO m) => O.OverloadedMethod AttributeAsFloatMethodInfo Attribute signature where
    overloadedMethod = attributeAsFloat

instance O.OverloadedMethodInfo AttributeAsFloatMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsFloat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsFloat"
        })


#endif

-- method Attribute::as_font_desc
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A `PangoAttribute` representing a font description"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "AttrFontDesc" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_font_desc" pango_attribute_as_font_desc :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrFontDesc.AttrFontDesc)

-- | Returns the attribute cast to @PangoAttrFontDesc@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsFontDesc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ representing a font description
    -> m (Maybe Pango.AttrFontDesc.AttrFontDesc)
    -- ^ __Returns:__ The attribute as @PangoAttrFontDesc@,
    --   or 'P.Nothing' if it\'s not a font description attribute
attributeAsFontDesc attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_font_desc attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrFontDesc.AttrFontDesc) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsFontDescMethodInfo
instance (signature ~ (m (Maybe Pango.AttrFontDesc.AttrFontDesc)), MonadIO m) => O.OverloadedMethod AttributeAsFontDescMethodInfo Attribute signature where
    overloadedMethod = attributeAsFontDesc

instance O.OverloadedMethodInfo AttributeAsFontDescMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsFontDesc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsFontDesc"
        })


#endif

-- method Attribute::as_font_features
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` representing font features"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "AttrFontFeatures" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_font_features" pango_attribute_as_font_features :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrFontFeatures.AttrFontFeatures)

-- | Returns the attribute cast to @PangoAttrFontFeatures@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsFontFeatures ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ representing font features
    -> m (Maybe Pango.AttrFontFeatures.AttrFontFeatures)
    -- ^ __Returns:__ The attribute as @PangoAttrFontFeatures@,
    --   or 'P.Nothing' if it\'s not a font features attribute
attributeAsFontFeatures attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_font_features attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrFontFeatures.AttrFontFeatures) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsFontFeaturesMethodInfo
instance (signature ~ (m (Maybe Pango.AttrFontFeatures.AttrFontFeatures)), MonadIO m) => O.OverloadedMethod AttributeAsFontFeaturesMethodInfo Attribute signature where
    overloadedMethod = attributeAsFontFeatures

instance O.OverloadedMethodInfo AttributeAsFontFeaturesMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsFontFeatures",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsFontFeatures"
        })


#endif

-- method Attribute::as_int
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` such as weight"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "AttrInt" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_int" pango_attribute_as_int :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrInt.AttrInt)

-- | Returns the attribute cast to @PangoAttrInt@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsInt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ such as weight
    -> m (Maybe Pango.AttrInt.AttrInt)
    -- ^ __Returns:__ The attribute as @PangoAttrInt@,
    --   or 'P.Nothing' if it\'s not an integer attribute
attributeAsInt attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_int attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrInt.AttrInt) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsIntMethodInfo
instance (signature ~ (m (Maybe Pango.AttrInt.AttrInt)), MonadIO m) => O.OverloadedMethod AttributeAsIntMethodInfo Attribute signature where
    overloadedMethod = attributeAsInt

instance O.OverloadedMethodInfo AttributeAsIntMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsInt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsInt"
        })


#endif

-- method Attribute::as_language
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` representing a language"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "AttrLanguage" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_language" pango_attribute_as_language :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrLanguage.AttrLanguage)

-- | Returns the attribute cast to @PangoAttrLanguage@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsLanguage ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ representing a language
    -> m (Maybe Pango.AttrLanguage.AttrLanguage)
    -- ^ __Returns:__ The attribute as @PangoAttrLanguage@,
    --   or 'P.Nothing' if it\'s not a language attribute
attributeAsLanguage attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_language attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrLanguage.AttrLanguage) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsLanguageMethodInfo
instance (signature ~ (m (Maybe Pango.AttrLanguage.AttrLanguage)), MonadIO m) => O.OverloadedMethod AttributeAsLanguageMethodInfo Attribute signature where
    overloadedMethod = attributeAsLanguage

instance O.OverloadedMethodInfo AttributeAsLanguageMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsLanguage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsLanguage"
        })


#endif

-- method Attribute::as_shape
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` representing a shape"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "AttrShape" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_shape" pango_attribute_as_shape :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrShape.AttrShape)

-- | Returns the attribute cast to @PangoAttrShape@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsShape ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ representing a shape
    -> m (Maybe Pango.AttrShape.AttrShape)
    -- ^ __Returns:__ The attribute as @PangoAttrShape@,
    --   or 'P.Nothing' if it\'s not a shape attribute
attributeAsShape attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_shape attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrShape.AttrShape) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsShapeMethodInfo
instance (signature ~ (m (Maybe Pango.AttrShape.AttrShape)), MonadIO m) => O.OverloadedMethod AttributeAsShapeMethodInfo Attribute signature where
    overloadedMethod = attributeAsShape

instance O.OverloadedMethodInfo AttributeAsShapeMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsShape",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsShape"
        })


#endif

-- method Attribute::as_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` representing a size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "AttrSize" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_size" pango_attribute_as_size :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrSize.AttrSize)

-- | Returns the attribute cast to @PangoAttrSize@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ representing a size
    -> m (Maybe Pango.AttrSize.AttrSize)
    -- ^ __Returns:__ The attribute as @PangoAttrSize@,
    --   or NULL if it\'s not a size attribute
attributeAsSize attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_size attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrSize.AttrSize) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsSizeMethodInfo
instance (signature ~ (m (Maybe Pango.AttrSize.AttrSize)), MonadIO m) => O.OverloadedMethod AttributeAsSizeMethodInfo Attribute signature where
    overloadedMethod = attributeAsSize

instance O.OverloadedMethodInfo AttributeAsSizeMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsSize"
        })


#endif

-- method Attribute::as_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `PangoAttribute` such as family"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "AttrString" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_as_string" pango_attribute_as_string :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Pango.AttrString.AttrString)

-- | Returns the attribute cast to @PangoAttrString@.
-- 
-- This is mainly useful for language bindings.
-- 
-- /Since: 1.50/
attributeAsString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: A @PangoAttribute@ such as family
    -> m (Maybe Pango.AttrString.AttrString)
    -- ^ __Returns:__ The attribute as @PangoAttrString@,
    --   or 'P.Nothing' if it\'s not a string attribute
attributeAsString attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_as_string attr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Pango.AttrString.AttrString) result'
        return result''
    touchManagedPtr attr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AttributeAsStringMethodInfo
instance (signature ~ (m (Maybe Pango.AttrString.AttrString)), MonadIO m) => O.OverloadedMethod AttributeAsStringMethodInfo Attribute signature where
    overloadedMethod = attributeAsString

instance O.OverloadedMethodInfo AttributeAsStringMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeAsString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeAsString"
        })


#endif

-- method Attribute::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttribute`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_copy" pango_attribute_copy :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO (Ptr Attribute)

-- | Make a copy of an attribute.
attributeCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: a @PangoAttribute@
    -> m Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'.
attributeCopy attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- pango_attribute_copy attr'
    checkUnexpectedReturnNULL "attributeCopy" result
    result' <- (wrapBoxed Attribute) result
    touchManagedPtr attr
    return result'

#if defined(ENABLE_OVERLOADING)
data AttributeCopyMethodInfo
instance (signature ~ (m Attribute), MonadIO m) => O.OverloadedMethod AttributeCopyMethodInfo Attribute signature where
    overloadedMethod = attributeCopy

instance O.OverloadedMethodInfo AttributeCopyMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeCopy"
        })


#endif

-- method Attribute::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttribute`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_destroy" pango_attribute_destroy :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO ()

-- | Destroy a @PangoAttribute@ and free all associated memory.
attributeDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: a @PangoAttribute@.
    -> m ()
attributeDestroy attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    pango_attribute_destroy attr'
    touchManagedPtr attr
    return ()

#if defined(ENABLE_OVERLOADING)
data AttributeDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod AttributeDestroyMethodInfo Attribute signature where
    overloadedMethod = attributeDestroy

instance O.OverloadedMethodInfo AttributeDestroyMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeDestroy"
        })


#endif

-- method Attribute::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr1"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttribute`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attr2"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another `PangoAttribute`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_equal" pango_attribute_equal :: 
    Ptr Attribute ->                        -- attr1 : TInterface (Name {namespace = "Pango", name = "Attribute"})
    Ptr Attribute ->                        -- attr2 : TInterface (Name {namespace = "Pango", name = "Attribute"})
    IO CInt

-- | Compare two attributes for equality.
-- 
-- This compares only the actual value of the two
-- attributes and not the ranges that the attributes
-- apply to.
attributeEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr1@/: a @PangoAttribute@
    -> Attribute
    -- ^ /@attr2@/: another @PangoAttribute@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two attributes have the same value
attributeEqual attr1 attr2 = liftIO $ do
    attr1' <- unsafeManagedPtrGetPtr attr1
    attr2' <- unsafeManagedPtrGetPtr attr2
    result <- pango_attribute_equal attr1' attr2'
    let result' = (/= 0) result
    touchManagedPtr attr1
    touchManagedPtr attr2
    return result'

#if defined(ENABLE_OVERLOADING)
data AttributeEqualMethodInfo
instance (signature ~ (Attribute -> m Bool), MonadIO m) => O.OverloadedMethod AttributeEqualMethodInfo Attribute signature where
    overloadedMethod = attributeEqual

instance O.OverloadedMethodInfo AttributeEqualMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeEqual"
        })


#endif

-- method Attribute::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttribute`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "klass"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrClass`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_attribute_init" pango_attribute_init :: 
    Ptr Attribute ->                        -- attr : TInterface (Name {namespace = "Pango", name = "Attribute"})
    Ptr Pango.AttrClass.AttrClass ->        -- klass : TInterface (Name {namespace = "Pango", name = "AttrClass"})
    IO ()

-- | Initializes /@attr@/\'s klass to /@klass@/, it\'s start_index to
-- 'GI.Pango.Constants.ATTR_INDEX_FROM_TEXT_BEGINNING' and end_index to
-- 'GI.Pango.Constants.ATTR_INDEX_TO_TEXT_END' such that the attribute applies
-- to the entire text by default.
-- 
-- /Since: 1.20/
attributeInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Attribute
    -- ^ /@attr@/: a @PangoAttribute@
    -> Pango.AttrClass.AttrClass
    -- ^ /@klass@/: a @PangoAttrClass@
    -> m ()
attributeInit attr klass = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    klass' <- unsafeManagedPtrGetPtr klass
    pango_attribute_init attr' klass'
    touchManagedPtr attr
    touchManagedPtr klass
    return ()

#if defined(ENABLE_OVERLOADING)
data AttributeInitMethodInfo
instance (signature ~ (Pango.AttrClass.AttrClass -> m ()), MonadIO m) => O.OverloadedMethod AttributeInitMethodInfo Attribute signature where
    overloadedMethod = attributeInit

instance O.OverloadedMethodInfo AttributeInitMethodInfo Attribute where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Attribute.attributeInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Attribute.html#v:attributeInit"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttributeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttributeMethod "asColor" o = AttributeAsColorMethodInfo
    ResolveAttributeMethod "asFloat" o = AttributeAsFloatMethodInfo
    ResolveAttributeMethod "asFontDesc" o = AttributeAsFontDescMethodInfo
    ResolveAttributeMethod "asFontFeatures" o = AttributeAsFontFeaturesMethodInfo
    ResolveAttributeMethod "asInt" o = AttributeAsIntMethodInfo
    ResolveAttributeMethod "asLanguage" o = AttributeAsLanguageMethodInfo
    ResolveAttributeMethod "asShape" o = AttributeAsShapeMethodInfo
    ResolveAttributeMethod "asSize" o = AttributeAsSizeMethodInfo
    ResolveAttributeMethod "asString" o = AttributeAsStringMethodInfo
    ResolveAttributeMethod "copy" o = AttributeCopyMethodInfo
    ResolveAttributeMethod "destroy" o = AttributeDestroyMethodInfo
    ResolveAttributeMethod "equal" o = AttributeEqualMethodInfo
    ResolveAttributeMethod "init" o = AttributeInitMethodInfo
    ResolveAttributeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttributeMethod t Attribute, O.OverloadedMethod info Attribute p) => OL.IsLabel t (Attribute -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttributeMethod t Attribute, O.OverloadedMethod info Attribute p, R.HasField t Attribute p) => R.HasField t Attribute p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttributeMethod t Attribute, O.OverloadedMethodInfo info Attribute) => OL.IsLabel t (O.MethodProxy info Attribute) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


