{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Stores text and attributes for display in a @GtkTextView@.
-- 
-- You may wish to begin by reading the
-- <https://docs.gtk.org/gtk4/section-text-widget.html text widget conceptual overview>,
-- which gives an overview of all the objects and data types
-- related to the text widget and how they work together.
-- 
-- GtkTextBuffer can support undoing changes to the buffer
-- content, see 'GI.Gtk.Objects.TextBuffer.textBufferSetEnableUndo'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.TextBuffer
    ( 

-- * Exported types
    TextBuffer(..)                          ,
    IsTextBuffer                            ,
    toTextBuffer                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addCommitNotify]("GI.Gtk.Objects.TextBuffer#g:method:addCommitNotify"), [addMark]("GI.Gtk.Objects.TextBuffer#g:method:addMark"), [addSelectionClipboard]("GI.Gtk.Objects.TextBuffer#g:method:addSelectionClipboard"), [applyTag]("GI.Gtk.Objects.TextBuffer#g:method:applyTag"), [applyTagByName]("GI.Gtk.Objects.TextBuffer#g:method:applyTagByName"), [backspace]("GI.Gtk.Objects.TextBuffer#g:method:backspace"), [beginIrreversibleAction]("GI.Gtk.Objects.TextBuffer#g:method:beginIrreversibleAction"), [beginUserAction]("GI.Gtk.Objects.TextBuffer#g:method:beginUserAction"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [copyClipboard]("GI.Gtk.Objects.TextBuffer#g:method:copyClipboard"), [createChildAnchor]("GI.Gtk.Objects.TextBuffer#g:method:createChildAnchor"), [createMark]("GI.Gtk.Objects.TextBuffer#g:method:createMark"), [cutClipboard]("GI.Gtk.Objects.TextBuffer#g:method:cutClipboard"), [delete]("GI.Gtk.Objects.TextBuffer#g:method:delete"), [deleteInteractive]("GI.Gtk.Objects.TextBuffer#g:method:deleteInteractive"), [deleteMark]("GI.Gtk.Objects.TextBuffer#g:method:deleteMark"), [deleteMarkByName]("GI.Gtk.Objects.TextBuffer#g:method:deleteMarkByName"), [deleteSelection]("GI.Gtk.Objects.TextBuffer#g:method:deleteSelection"), [endIrreversibleAction]("GI.Gtk.Objects.TextBuffer#g:method:endIrreversibleAction"), [endUserAction]("GI.Gtk.Objects.TextBuffer#g:method:endUserAction"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [insert]("GI.Gtk.Objects.TextBuffer#g:method:insert"), [insertAtCursor]("GI.Gtk.Objects.TextBuffer#g:method:insertAtCursor"), [insertChildAnchor]("GI.Gtk.Objects.TextBuffer#g:method:insertChildAnchor"), [insertInteractive]("GI.Gtk.Objects.TextBuffer#g:method:insertInteractive"), [insertInteractiveAtCursor]("GI.Gtk.Objects.TextBuffer#g:method:insertInteractiveAtCursor"), [insertMarkup]("GI.Gtk.Objects.TextBuffer#g:method:insertMarkup"), [insertPaintable]("GI.Gtk.Objects.TextBuffer#g:method:insertPaintable"), [insertRange]("GI.Gtk.Objects.TextBuffer#g:method:insertRange"), [insertRangeInteractive]("GI.Gtk.Objects.TextBuffer#g:method:insertRangeInteractive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [moveMark]("GI.Gtk.Objects.TextBuffer#g:method:moveMark"), [moveMarkByName]("GI.Gtk.Objects.TextBuffer#g:method:moveMarkByName"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [pasteClipboard]("GI.Gtk.Objects.TextBuffer#g:method:pasteClipboard"), [placeCursor]("GI.Gtk.Objects.TextBuffer#g:method:placeCursor"), [redo]("GI.Gtk.Objects.TextBuffer#g:method:redo"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeAllTags]("GI.Gtk.Objects.TextBuffer#g:method:removeAllTags"), [removeCommitNotify]("GI.Gtk.Objects.TextBuffer#g:method:removeCommitNotify"), [removeSelectionClipboard]("GI.Gtk.Objects.TextBuffer#g:method:removeSelectionClipboard"), [removeTag]("GI.Gtk.Objects.TextBuffer#g:method:removeTag"), [removeTagByName]("GI.Gtk.Objects.TextBuffer#g:method:removeTagByName"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectRange]("GI.Gtk.Objects.TextBuffer#g:method:selectRange"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [undo]("GI.Gtk.Objects.TextBuffer#g:method:undo"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBounds]("GI.Gtk.Objects.TextBuffer#g:method:getBounds"), [getCanRedo]("GI.Gtk.Objects.TextBuffer#g:method:getCanRedo"), [getCanUndo]("GI.Gtk.Objects.TextBuffer#g:method:getCanUndo"), [getCharCount]("GI.Gtk.Objects.TextBuffer#g:method:getCharCount"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEnableUndo]("GI.Gtk.Objects.TextBuffer#g:method:getEnableUndo"), [getEndIter]("GI.Gtk.Objects.TextBuffer#g:method:getEndIter"), [getHasSelection]("GI.Gtk.Objects.TextBuffer#g:method:getHasSelection"), [getInsert]("GI.Gtk.Objects.TextBuffer#g:method:getInsert"), [getIterAtChildAnchor]("GI.Gtk.Objects.TextBuffer#g:method:getIterAtChildAnchor"), [getIterAtLine]("GI.Gtk.Objects.TextBuffer#g:method:getIterAtLine"), [getIterAtLineIndex]("GI.Gtk.Objects.TextBuffer#g:method:getIterAtLineIndex"), [getIterAtLineOffset]("GI.Gtk.Objects.TextBuffer#g:method:getIterAtLineOffset"), [getIterAtMark]("GI.Gtk.Objects.TextBuffer#g:method:getIterAtMark"), [getIterAtOffset]("GI.Gtk.Objects.TextBuffer#g:method:getIterAtOffset"), [getLineCount]("GI.Gtk.Objects.TextBuffer#g:method:getLineCount"), [getMark]("GI.Gtk.Objects.TextBuffer#g:method:getMark"), [getMaxUndoLevels]("GI.Gtk.Objects.TextBuffer#g:method:getMaxUndoLevels"), [getModified]("GI.Gtk.Objects.TextBuffer#g:method:getModified"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSelectionBound]("GI.Gtk.Objects.TextBuffer#g:method:getSelectionBound"), [getSelectionBounds]("GI.Gtk.Objects.TextBuffer#g:method:getSelectionBounds"), [getSelectionContent]("GI.Gtk.Objects.TextBuffer#g:method:getSelectionContent"), [getSlice]("GI.Gtk.Objects.TextBuffer#g:method:getSlice"), [getStartIter]("GI.Gtk.Objects.TextBuffer#g:method:getStartIter"), [getTagTable]("GI.Gtk.Objects.TextBuffer#g:method:getTagTable"), [getText]("GI.Gtk.Objects.TextBuffer#g:method:getText").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setEnableUndo]("GI.Gtk.Objects.TextBuffer#g:method:setEnableUndo"), [setMaxUndoLevels]("GI.Gtk.Objects.TextBuffer#g:method:setMaxUndoLevels"), [setModified]("GI.Gtk.Objects.TextBuffer#g:method:setModified"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setText]("GI.Gtk.Objects.TextBuffer#g:method:setText").

#if defined(ENABLE_OVERLOADING)
    ResolveTextBufferMethod                 ,
#endif

-- ** addCommitNotify #method:addCommitNotify#

#if defined(ENABLE_OVERLOADING)
    TextBufferAddCommitNotifyMethodInfo     ,
#endif
    textBufferAddCommitNotify               ,


-- ** addMark #method:addMark#

#if defined(ENABLE_OVERLOADING)
    TextBufferAddMarkMethodInfo             ,
#endif
    textBufferAddMark                       ,


-- ** addSelectionClipboard #method:addSelectionClipboard#

#if defined(ENABLE_OVERLOADING)
    TextBufferAddSelectionClipboardMethodInfo,
#endif
    textBufferAddSelectionClipboard         ,


-- ** applyTag #method:applyTag#

#if defined(ENABLE_OVERLOADING)
    TextBufferApplyTagMethodInfo            ,
#endif
    textBufferApplyTag                      ,


-- ** applyTagByName #method:applyTagByName#

#if defined(ENABLE_OVERLOADING)
    TextBufferApplyTagByNameMethodInfo      ,
#endif
    textBufferApplyTagByName                ,


-- ** backspace #method:backspace#

#if defined(ENABLE_OVERLOADING)
    TextBufferBackspaceMethodInfo           ,
#endif
    textBufferBackspace                     ,


-- ** beginIrreversibleAction #method:beginIrreversibleAction#

#if defined(ENABLE_OVERLOADING)
    TextBufferBeginIrreversibleActionMethodInfo,
#endif
    textBufferBeginIrreversibleAction       ,


-- ** beginUserAction #method:beginUserAction#

#if defined(ENABLE_OVERLOADING)
    TextBufferBeginUserActionMethodInfo     ,
#endif
    textBufferBeginUserAction               ,


-- ** copyClipboard #method:copyClipboard#

#if defined(ENABLE_OVERLOADING)
    TextBufferCopyClipboardMethodInfo       ,
#endif
    textBufferCopyClipboard                 ,


-- ** createChildAnchor #method:createChildAnchor#

#if defined(ENABLE_OVERLOADING)
    TextBufferCreateChildAnchorMethodInfo   ,
#endif
    textBufferCreateChildAnchor             ,


-- ** createMark #method:createMark#

#if defined(ENABLE_OVERLOADING)
    TextBufferCreateMarkMethodInfo          ,
#endif
    textBufferCreateMark                    ,


-- ** cutClipboard #method:cutClipboard#

#if defined(ENABLE_OVERLOADING)
    TextBufferCutClipboardMethodInfo        ,
#endif
    textBufferCutClipboard                  ,


-- ** delete #method:delete#

#if defined(ENABLE_OVERLOADING)
    TextBufferDeleteMethodInfo              ,
#endif
    textBufferDelete                        ,


-- ** deleteInteractive #method:deleteInteractive#

#if defined(ENABLE_OVERLOADING)
    TextBufferDeleteInteractiveMethodInfo   ,
#endif
    textBufferDeleteInteractive             ,


-- ** deleteMark #method:deleteMark#

#if defined(ENABLE_OVERLOADING)
    TextBufferDeleteMarkMethodInfo          ,
#endif
    textBufferDeleteMark                    ,


-- ** deleteMarkByName #method:deleteMarkByName#

#if defined(ENABLE_OVERLOADING)
    TextBufferDeleteMarkByNameMethodInfo    ,
#endif
    textBufferDeleteMarkByName              ,


-- ** deleteSelection #method:deleteSelection#

#if defined(ENABLE_OVERLOADING)
    TextBufferDeleteSelectionMethodInfo     ,
#endif
    textBufferDeleteSelection               ,


-- ** endIrreversibleAction #method:endIrreversibleAction#

#if defined(ENABLE_OVERLOADING)
    TextBufferEndIrreversibleActionMethodInfo,
#endif
    textBufferEndIrreversibleAction         ,


-- ** endUserAction #method:endUserAction#

#if defined(ENABLE_OVERLOADING)
    TextBufferEndUserActionMethodInfo       ,
#endif
    textBufferEndUserAction                 ,


-- ** getBounds #method:getBounds#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetBoundsMethodInfo           ,
#endif
    textBufferGetBounds                     ,


-- ** getCanRedo #method:getCanRedo#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetCanRedoMethodInfo          ,
#endif
    textBufferGetCanRedo                    ,


-- ** getCanUndo #method:getCanUndo#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetCanUndoMethodInfo          ,
#endif
    textBufferGetCanUndo                    ,


-- ** getCharCount #method:getCharCount#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetCharCountMethodInfo        ,
#endif
    textBufferGetCharCount                  ,


-- ** getEnableUndo #method:getEnableUndo#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetEnableUndoMethodInfo       ,
#endif
    textBufferGetEnableUndo                 ,


-- ** getEndIter #method:getEndIter#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetEndIterMethodInfo          ,
#endif
    textBufferGetEndIter                    ,


-- ** getHasSelection #method:getHasSelection#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetHasSelectionMethodInfo     ,
#endif
    textBufferGetHasSelection               ,


-- ** getInsert #method:getInsert#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetInsertMethodInfo           ,
#endif
    textBufferGetInsert                     ,


-- ** getIterAtChildAnchor #method:getIterAtChildAnchor#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetIterAtChildAnchorMethodInfo,
#endif
    textBufferGetIterAtChildAnchor          ,


-- ** getIterAtLine #method:getIterAtLine#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetIterAtLineMethodInfo       ,
#endif
    textBufferGetIterAtLine                 ,


-- ** getIterAtLineIndex #method:getIterAtLineIndex#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetIterAtLineIndexMethodInfo  ,
#endif
    textBufferGetIterAtLineIndex            ,


-- ** getIterAtLineOffset #method:getIterAtLineOffset#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetIterAtLineOffsetMethodInfo ,
#endif
    textBufferGetIterAtLineOffset           ,


-- ** getIterAtMark #method:getIterAtMark#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetIterAtMarkMethodInfo       ,
#endif
    textBufferGetIterAtMark                 ,


-- ** getIterAtOffset #method:getIterAtOffset#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetIterAtOffsetMethodInfo     ,
#endif
    textBufferGetIterAtOffset               ,


-- ** getLineCount #method:getLineCount#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetLineCountMethodInfo        ,
#endif
    textBufferGetLineCount                  ,


-- ** getMark #method:getMark#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetMarkMethodInfo             ,
#endif
    textBufferGetMark                       ,


-- ** getMaxUndoLevels #method:getMaxUndoLevels#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetMaxUndoLevelsMethodInfo    ,
#endif
    textBufferGetMaxUndoLevels              ,


-- ** getModified #method:getModified#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetModifiedMethodInfo         ,
#endif
    textBufferGetModified                   ,


-- ** getSelectionBound #method:getSelectionBound#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetSelectionBoundMethodInfo   ,
#endif
    textBufferGetSelectionBound             ,


-- ** getSelectionBounds #method:getSelectionBounds#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetSelectionBoundsMethodInfo  ,
#endif
    textBufferGetSelectionBounds            ,


-- ** getSelectionContent #method:getSelectionContent#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetSelectionContentMethodInfo ,
#endif
    textBufferGetSelectionContent           ,


-- ** getSlice #method:getSlice#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetSliceMethodInfo            ,
#endif
    textBufferGetSlice                      ,


-- ** getStartIter #method:getStartIter#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetStartIterMethodInfo        ,
#endif
    textBufferGetStartIter                  ,


-- ** getTagTable #method:getTagTable#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetTagTableMethodInfo         ,
#endif
    textBufferGetTagTable                   ,


-- ** getText #method:getText#

#if defined(ENABLE_OVERLOADING)
    TextBufferGetTextMethodInfo             ,
#endif
    textBufferGetText                       ,


-- ** insert #method:insert#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertMethodInfo              ,
#endif
    textBufferInsert                        ,


-- ** insertAtCursor #method:insertAtCursor#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertAtCursorMethodInfo      ,
#endif
    textBufferInsertAtCursor                ,


-- ** insertChildAnchor #method:insertChildAnchor#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertChildAnchorMethodInfo   ,
#endif
    textBufferInsertChildAnchor             ,


-- ** insertInteractive #method:insertInteractive#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertInteractiveMethodInfo   ,
#endif
    textBufferInsertInteractive             ,


-- ** insertInteractiveAtCursor #method:insertInteractiveAtCursor#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertInteractiveAtCursorMethodInfo,
#endif
    textBufferInsertInteractiveAtCursor     ,


-- ** insertMarkup #method:insertMarkup#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertMarkupMethodInfo        ,
#endif
    textBufferInsertMarkup                  ,


-- ** insertPaintable #method:insertPaintable#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertPaintableMethodInfo     ,
#endif
    textBufferInsertPaintable               ,


-- ** insertRange #method:insertRange#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertRangeMethodInfo         ,
#endif
    textBufferInsertRange                   ,


-- ** insertRangeInteractive #method:insertRangeInteractive#

#if defined(ENABLE_OVERLOADING)
    TextBufferInsertRangeInteractiveMethodInfo,
#endif
    textBufferInsertRangeInteractive        ,


-- ** moveMark #method:moveMark#

#if defined(ENABLE_OVERLOADING)
    TextBufferMoveMarkMethodInfo            ,
#endif
    textBufferMoveMark                      ,


-- ** moveMarkByName #method:moveMarkByName#

#if defined(ENABLE_OVERLOADING)
    TextBufferMoveMarkByNameMethodInfo      ,
#endif
    textBufferMoveMarkByName                ,


-- ** new #method:new#

    textBufferNew                           ,


-- ** pasteClipboard #method:pasteClipboard#

#if defined(ENABLE_OVERLOADING)
    TextBufferPasteClipboardMethodInfo      ,
#endif
    textBufferPasteClipboard                ,


-- ** placeCursor #method:placeCursor#

#if defined(ENABLE_OVERLOADING)
    TextBufferPlaceCursorMethodInfo         ,
#endif
    textBufferPlaceCursor                   ,


-- ** redo #method:redo#

#if defined(ENABLE_OVERLOADING)
    TextBufferRedoMethodInfo                ,
#endif
    textBufferRedo                          ,


-- ** removeAllTags #method:removeAllTags#

#if defined(ENABLE_OVERLOADING)
    TextBufferRemoveAllTagsMethodInfo       ,
#endif
    textBufferRemoveAllTags                 ,


-- ** removeCommitNotify #method:removeCommitNotify#

#if defined(ENABLE_OVERLOADING)
    TextBufferRemoveCommitNotifyMethodInfo  ,
#endif
    textBufferRemoveCommitNotify            ,


-- ** removeSelectionClipboard #method:removeSelectionClipboard#

#if defined(ENABLE_OVERLOADING)
    TextBufferRemoveSelectionClipboardMethodInfo,
#endif
    textBufferRemoveSelectionClipboard      ,


-- ** removeTag #method:removeTag#

#if defined(ENABLE_OVERLOADING)
    TextBufferRemoveTagMethodInfo           ,
#endif
    textBufferRemoveTag                     ,


-- ** removeTagByName #method:removeTagByName#

#if defined(ENABLE_OVERLOADING)
    TextBufferRemoveTagByNameMethodInfo     ,
#endif
    textBufferRemoveTagByName               ,


-- ** selectRange #method:selectRange#

#if defined(ENABLE_OVERLOADING)
    TextBufferSelectRangeMethodInfo         ,
#endif
    textBufferSelectRange                   ,


-- ** setEnableUndo #method:setEnableUndo#

#if defined(ENABLE_OVERLOADING)
    TextBufferSetEnableUndoMethodInfo       ,
#endif
    textBufferSetEnableUndo                 ,


-- ** setMaxUndoLevels #method:setMaxUndoLevels#

#if defined(ENABLE_OVERLOADING)
    TextBufferSetMaxUndoLevelsMethodInfo    ,
#endif
    textBufferSetMaxUndoLevels              ,


-- ** setModified #method:setModified#

#if defined(ENABLE_OVERLOADING)
    TextBufferSetModifiedMethodInfo         ,
#endif
    textBufferSetModified                   ,


-- ** setText #method:setText#

#if defined(ENABLE_OVERLOADING)
    TextBufferSetTextMethodInfo             ,
#endif
    textBufferSetText                       ,


-- ** undo #method:undo#

#if defined(ENABLE_OVERLOADING)
    TextBufferUndoMethodInfo                ,
#endif
    textBufferUndo                          ,




 -- * Properties


-- ** canRedo #attr:canRedo#
-- | Denotes that the buffer can reapply the last undone action.

#if defined(ENABLE_OVERLOADING)
    TextBufferCanRedoPropertyInfo           ,
#endif
    getTextBufferCanRedo                    ,
#if defined(ENABLE_OVERLOADING)
    textBufferCanRedo                       ,
#endif


-- ** canUndo #attr:canUndo#
-- | Denotes that the buffer can undo the last applied action.

#if defined(ENABLE_OVERLOADING)
    TextBufferCanUndoPropertyInfo           ,
#endif
    getTextBufferCanUndo                    ,
#if defined(ENABLE_OVERLOADING)
    textBufferCanUndo                       ,
#endif


-- ** cursorPosition #attr:cursorPosition#
-- | The position of the insert mark.
-- 
-- This is an offset from the beginning of the buffer.
-- It is useful for getting notified when the cursor moves.

#if defined(ENABLE_OVERLOADING)
    TextBufferCursorPositionPropertyInfo    ,
#endif
    getTextBufferCursorPosition             ,
#if defined(ENABLE_OVERLOADING)
    textBufferCursorPosition                ,
#endif


-- ** enableUndo #attr:enableUndo#
-- | Denotes if support for undoing and redoing changes to the buffer is allowed.

#if defined(ENABLE_OVERLOADING)
    TextBufferEnableUndoPropertyInfo        ,
#endif
    constructTextBufferEnableUndo           ,
    getTextBufferEnableUndo                 ,
    setTextBufferEnableUndo                 ,
#if defined(ENABLE_OVERLOADING)
    textBufferEnableUndo                    ,
#endif


-- ** hasSelection #attr:hasSelection#
-- | Whether the buffer has some text currently selected.

#if defined(ENABLE_OVERLOADING)
    TextBufferHasSelectionPropertyInfo      ,
#endif
    getTextBufferHasSelection               ,
#if defined(ENABLE_OVERLOADING)
    textBufferHasSelection                  ,
#endif


-- ** tagTable #attr:tagTable#
-- | The GtkTextTagTable for the buffer.

#if defined(ENABLE_OVERLOADING)
    TextBufferTagTablePropertyInfo          ,
#endif
    constructTextBufferTagTable             ,
    getTextBufferTagTable                   ,
#if defined(ENABLE_OVERLOADING)
    textBufferTagTable                      ,
#endif


-- ** text #attr:text#
-- | The text content of the buffer.
-- 
-- Without child widgets and images,
-- see 'GI.Gtk.Objects.TextBuffer.textBufferGetText' for more information.

#if defined(ENABLE_OVERLOADING)
    TextBufferTextPropertyInfo              ,
#endif
    clearTextBufferText                     ,
    constructTextBufferText                 ,
    getTextBufferText                       ,
    setTextBufferText                       ,
#if defined(ENABLE_OVERLOADING)
    textBufferText                          ,
#endif




 -- * Signals


-- ** applyTag #signal:applyTag#

    TextBufferApplyTagCallback              ,
#if defined(ENABLE_OVERLOADING)
    TextBufferApplyTagSignalInfo            ,
#endif
    afterTextBufferApplyTag                 ,
    onTextBufferApplyTag                    ,


-- ** beginUserAction #signal:beginUserAction#

    TextBufferBeginUserActionCallback       ,
#if defined(ENABLE_OVERLOADING)
    TextBufferBeginUserActionSignalInfo     ,
#endif
    afterTextBufferBeginUserAction          ,
    onTextBufferBeginUserAction             ,


-- ** changed #signal:changed#

    TextBufferChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    TextBufferChangedSignalInfo             ,
#endif
    afterTextBufferChanged                  ,
    onTextBufferChanged                     ,


-- ** deleteRange #signal:deleteRange#

    TextBufferDeleteRangeCallback           ,
#if defined(ENABLE_OVERLOADING)
    TextBufferDeleteRangeSignalInfo         ,
#endif
    afterTextBufferDeleteRange              ,
    onTextBufferDeleteRange                 ,


-- ** endUserAction #signal:endUserAction#

    TextBufferEndUserActionCallback         ,
#if defined(ENABLE_OVERLOADING)
    TextBufferEndUserActionSignalInfo       ,
#endif
    afterTextBufferEndUserAction            ,
    onTextBufferEndUserAction               ,


-- ** insertChildAnchor #signal:insertChildAnchor#

    TextBufferInsertChildAnchorCallback     ,
#if defined(ENABLE_OVERLOADING)
    TextBufferInsertChildAnchorSignalInfo   ,
#endif
    afterTextBufferInsertChildAnchor        ,
    onTextBufferInsertChildAnchor           ,


-- ** insertPaintable #signal:insertPaintable#

    TextBufferInsertPaintableCallback       ,
#if defined(ENABLE_OVERLOADING)
    TextBufferInsertPaintableSignalInfo     ,
#endif
    afterTextBufferInsertPaintable          ,
    onTextBufferInsertPaintable             ,


-- ** insertText #signal:insertText#

    TextBufferInsertTextCallback            ,
#if defined(ENABLE_OVERLOADING)
    TextBufferInsertTextSignalInfo          ,
#endif
    afterTextBufferInsertText               ,
    onTextBufferInsertText                  ,


-- ** markDeleted #signal:markDeleted#

    TextBufferMarkDeletedCallback           ,
#if defined(ENABLE_OVERLOADING)
    TextBufferMarkDeletedSignalInfo         ,
#endif
    afterTextBufferMarkDeleted              ,
    onTextBufferMarkDeleted                 ,


-- ** markSet #signal:markSet#

    TextBufferMarkSetCallback               ,
#if defined(ENABLE_OVERLOADING)
    TextBufferMarkSetSignalInfo             ,
#endif
    afterTextBufferMarkSet                  ,
    onTextBufferMarkSet                     ,


-- ** modifiedChanged #signal:modifiedChanged#

    TextBufferModifiedChangedCallback       ,
#if defined(ENABLE_OVERLOADING)
    TextBufferModifiedChangedSignalInfo     ,
#endif
    afterTextBufferModifiedChanged          ,
    onTextBufferModifiedChanged             ,


-- ** pasteDone #signal:pasteDone#

    TextBufferPasteDoneCallback             ,
#if defined(ENABLE_OVERLOADING)
    TextBufferPasteDoneSignalInfo           ,
#endif
    afterTextBufferPasteDone                ,
    onTextBufferPasteDone                   ,


-- ** redo #signal:redo#

    TextBufferRedoCallback                  ,
#if defined(ENABLE_OVERLOADING)
    TextBufferRedoSignalInfo                ,
#endif
    afterTextBufferRedo                     ,
    onTextBufferRedo                        ,


-- ** removeTag #signal:removeTag#

    TextBufferRemoveTagCallback             ,
#if defined(ENABLE_OVERLOADING)
    TextBufferRemoveTagSignalInfo           ,
#endif
    afterTextBufferRemoveTag                ,
    onTextBufferRemoveTag                   ,


-- ** undo #signal:undo#

    TextBufferUndoCallback                  ,
#if defined(ENABLE_OVERLOADING)
    TextBufferUndoSignalInfo                ,
#endif
    afterTextBufferUndo                     ,
    onTextBufferUndo                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTagTable as Gtk.TextTagTable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Flags as Pango.Flags
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language
import qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTagTable as Gtk.TextTagTable
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter

#endif

-- | Memory-managed wrapper type.
newtype TextBuffer = TextBuffer (SP.ManagedPtr TextBuffer)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextBuffer where
    toManagedPtr (TextBuffer p) = p

foreign import ccall "gtk_text_buffer_get_type"
    c_gtk_text_buffer_get_type :: IO B.Types.GType

instance B.Types.TypedObject TextBuffer where
    glibType = c_gtk_text_buffer_get_type

instance B.Types.GObject TextBuffer

-- | Type class for types which can be safely cast to t'TextBuffer', for instance with `toTextBuffer`.
class (SP.GObject o, O.IsDescendantOf TextBuffer o) => IsTextBuffer o
instance (SP.GObject o, O.IsDescendantOf TextBuffer o) => IsTextBuffer o

instance O.HasParentTypes TextBuffer
type instance O.ParentTypes TextBuffer = '[GObject.Object.Object]

-- | Cast to t'TextBuffer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTextBuffer :: (MIO.MonadIO m, IsTextBuffer o) => o -> m TextBuffer
toTextBuffer = MIO.liftIO . B.ManagedPtr.unsafeCastTo TextBuffer

-- | Convert t'TextBuffer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TextBuffer) where
    gvalueGType_ = c_gtk_text_buffer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TextBuffer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TextBuffer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TextBuffer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTextBufferMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextBufferMethod "addCommitNotify" o = TextBufferAddCommitNotifyMethodInfo
    ResolveTextBufferMethod "addMark" o = TextBufferAddMarkMethodInfo
    ResolveTextBufferMethod "addSelectionClipboard" o = TextBufferAddSelectionClipboardMethodInfo
    ResolveTextBufferMethod "applyTag" o = TextBufferApplyTagMethodInfo
    ResolveTextBufferMethod "applyTagByName" o = TextBufferApplyTagByNameMethodInfo
    ResolveTextBufferMethod "backspace" o = TextBufferBackspaceMethodInfo
    ResolveTextBufferMethod "beginIrreversibleAction" o = TextBufferBeginIrreversibleActionMethodInfo
    ResolveTextBufferMethod "beginUserAction" o = TextBufferBeginUserActionMethodInfo
    ResolveTextBufferMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTextBufferMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTextBufferMethod "copyClipboard" o = TextBufferCopyClipboardMethodInfo
    ResolveTextBufferMethod "createChildAnchor" o = TextBufferCreateChildAnchorMethodInfo
    ResolveTextBufferMethod "createMark" o = TextBufferCreateMarkMethodInfo
    ResolveTextBufferMethod "cutClipboard" o = TextBufferCutClipboardMethodInfo
    ResolveTextBufferMethod "delete" o = TextBufferDeleteMethodInfo
    ResolveTextBufferMethod "deleteInteractive" o = TextBufferDeleteInteractiveMethodInfo
    ResolveTextBufferMethod "deleteMark" o = TextBufferDeleteMarkMethodInfo
    ResolveTextBufferMethod "deleteMarkByName" o = TextBufferDeleteMarkByNameMethodInfo
    ResolveTextBufferMethod "deleteSelection" o = TextBufferDeleteSelectionMethodInfo
    ResolveTextBufferMethod "endIrreversibleAction" o = TextBufferEndIrreversibleActionMethodInfo
    ResolveTextBufferMethod "endUserAction" o = TextBufferEndUserActionMethodInfo
    ResolveTextBufferMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTextBufferMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTextBufferMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTextBufferMethod "insert" o = TextBufferInsertMethodInfo
    ResolveTextBufferMethod "insertAtCursor" o = TextBufferInsertAtCursorMethodInfo
    ResolveTextBufferMethod "insertChildAnchor" o = TextBufferInsertChildAnchorMethodInfo
    ResolveTextBufferMethod "insertInteractive" o = TextBufferInsertInteractiveMethodInfo
    ResolveTextBufferMethod "insertInteractiveAtCursor" o = TextBufferInsertInteractiveAtCursorMethodInfo
    ResolveTextBufferMethod "insertMarkup" o = TextBufferInsertMarkupMethodInfo
    ResolveTextBufferMethod "insertPaintable" o = TextBufferInsertPaintableMethodInfo
    ResolveTextBufferMethod "insertRange" o = TextBufferInsertRangeMethodInfo
    ResolveTextBufferMethod "insertRangeInteractive" o = TextBufferInsertRangeInteractiveMethodInfo
    ResolveTextBufferMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTextBufferMethod "moveMark" o = TextBufferMoveMarkMethodInfo
    ResolveTextBufferMethod "moveMarkByName" o = TextBufferMoveMarkByNameMethodInfo
    ResolveTextBufferMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTextBufferMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTextBufferMethod "pasteClipboard" o = TextBufferPasteClipboardMethodInfo
    ResolveTextBufferMethod "placeCursor" o = TextBufferPlaceCursorMethodInfo
    ResolveTextBufferMethod "redo" o = TextBufferRedoMethodInfo
    ResolveTextBufferMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTextBufferMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTextBufferMethod "removeAllTags" o = TextBufferRemoveAllTagsMethodInfo
    ResolveTextBufferMethod "removeCommitNotify" o = TextBufferRemoveCommitNotifyMethodInfo
    ResolveTextBufferMethod "removeSelectionClipboard" o = TextBufferRemoveSelectionClipboardMethodInfo
    ResolveTextBufferMethod "removeTag" o = TextBufferRemoveTagMethodInfo
    ResolveTextBufferMethod "removeTagByName" o = TextBufferRemoveTagByNameMethodInfo
    ResolveTextBufferMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTextBufferMethod "selectRange" o = TextBufferSelectRangeMethodInfo
    ResolveTextBufferMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTextBufferMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTextBufferMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTextBufferMethod "undo" o = TextBufferUndoMethodInfo
    ResolveTextBufferMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTextBufferMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTextBufferMethod "getBounds" o = TextBufferGetBoundsMethodInfo
    ResolveTextBufferMethod "getCanRedo" o = TextBufferGetCanRedoMethodInfo
    ResolveTextBufferMethod "getCanUndo" o = TextBufferGetCanUndoMethodInfo
    ResolveTextBufferMethod "getCharCount" o = TextBufferGetCharCountMethodInfo
    ResolveTextBufferMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTextBufferMethod "getEnableUndo" o = TextBufferGetEnableUndoMethodInfo
    ResolveTextBufferMethod "getEndIter" o = TextBufferGetEndIterMethodInfo
    ResolveTextBufferMethod "getHasSelection" o = TextBufferGetHasSelectionMethodInfo
    ResolveTextBufferMethod "getInsert" o = TextBufferGetInsertMethodInfo
    ResolveTextBufferMethod "getIterAtChildAnchor" o = TextBufferGetIterAtChildAnchorMethodInfo
    ResolveTextBufferMethod "getIterAtLine" o = TextBufferGetIterAtLineMethodInfo
    ResolveTextBufferMethod "getIterAtLineIndex" o = TextBufferGetIterAtLineIndexMethodInfo
    ResolveTextBufferMethod "getIterAtLineOffset" o = TextBufferGetIterAtLineOffsetMethodInfo
    ResolveTextBufferMethod "getIterAtMark" o = TextBufferGetIterAtMarkMethodInfo
    ResolveTextBufferMethod "getIterAtOffset" o = TextBufferGetIterAtOffsetMethodInfo
    ResolveTextBufferMethod "getLineCount" o = TextBufferGetLineCountMethodInfo
    ResolveTextBufferMethod "getMark" o = TextBufferGetMarkMethodInfo
    ResolveTextBufferMethod "getMaxUndoLevels" o = TextBufferGetMaxUndoLevelsMethodInfo
    ResolveTextBufferMethod "getModified" o = TextBufferGetModifiedMethodInfo
    ResolveTextBufferMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTextBufferMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTextBufferMethod "getSelectionBound" o = TextBufferGetSelectionBoundMethodInfo
    ResolveTextBufferMethod "getSelectionBounds" o = TextBufferGetSelectionBoundsMethodInfo
    ResolveTextBufferMethod "getSelectionContent" o = TextBufferGetSelectionContentMethodInfo
    ResolveTextBufferMethod "getSlice" o = TextBufferGetSliceMethodInfo
    ResolveTextBufferMethod "getStartIter" o = TextBufferGetStartIterMethodInfo
    ResolveTextBufferMethod "getTagTable" o = TextBufferGetTagTableMethodInfo
    ResolveTextBufferMethod "getText" o = TextBufferGetTextMethodInfo
    ResolveTextBufferMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTextBufferMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTextBufferMethod "setEnableUndo" o = TextBufferSetEnableUndoMethodInfo
    ResolveTextBufferMethod "setMaxUndoLevels" o = TextBufferSetMaxUndoLevelsMethodInfo
    ResolveTextBufferMethod "setModified" o = TextBufferSetModifiedMethodInfo
    ResolveTextBufferMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTextBufferMethod "setText" o = TextBufferSetTextMethodInfo
    ResolveTextBufferMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextBufferMethod t TextBuffer, O.OverloadedMethod info TextBuffer p) => OL.IsLabel t (TextBuffer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextBufferMethod t TextBuffer, O.OverloadedMethod info TextBuffer p, R.HasField t TextBuffer p) => R.HasField t TextBuffer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextBufferMethod t TextBuffer, O.OverloadedMethodInfo info TextBuffer) => OL.IsLabel t (O.MethodProxy info TextBuffer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal TextBuffer::apply-tag
-- | Emitted to apply a tag to a range of text in a @GtkTextBuffer@.
-- 
-- Applying actually occurs in the default handler.
-- 
-- Note that if your handler runs before the default handler
-- it must not invalidate the /@start@/ and /@end@/ iters (or has to
-- revalidate them).
-- 
-- See also:
-- 'GI.Gtk.Objects.TextBuffer.textBufferApplyTag',
-- t'GI.Gtk.Objects.TextBuffer.TextBuffer'.@/insert_with_tags/@(),
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertRange'.
type TextBufferApplyTagCallback =
    Gtk.TextTag.TextTag
    -- ^ /@tag@/: the applied tag
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: the start of the range the tag is applied to
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: the end of the range the tag is applied to
    -> IO ()

type C_TextBufferApplyTagCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextTag.TextTag ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferApplyTagCallback`.
foreign import ccall "wrapper"
    mk_TextBufferApplyTagCallback :: C_TextBufferApplyTagCallback -> IO (FunPtr C_TextBufferApplyTagCallback)

wrap_TextBufferApplyTagCallback :: 
    GObject a => (a -> TextBufferApplyTagCallback) ->
    C_TextBufferApplyTagCallback
wrap_TextBufferApplyTagCallback gi'cb gi'selfPtr tag start end _ = do
    tag' <- (newObject Gtk.TextTag.TextTag) tag
    B.ManagedPtr.withTransient  start $ \start' -> do
        B.ManagedPtr.withTransient  end $ \end' -> do
            B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tag' start' end'


-- | Connect a signal handler for the [applyTag](#signal:applyTag) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #applyTag callback
-- @
-- 
-- 
onTextBufferApplyTag :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferApplyTagCallback) -> m SignalHandlerId
onTextBufferApplyTag obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferApplyTagCallback wrapped
    wrapped'' <- mk_TextBufferApplyTagCallback wrapped'
    connectSignalFunPtr obj "apply-tag" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [applyTag](#signal:applyTag) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #applyTag callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferApplyTag :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferApplyTagCallback) -> m SignalHandlerId
afterTextBufferApplyTag obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferApplyTagCallback wrapped
    wrapped'' <- mk_TextBufferApplyTagCallback wrapped'
    connectSignalFunPtr obj "apply-tag" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferApplyTagSignalInfo
instance SignalInfo TextBufferApplyTagSignalInfo where
    type HaskellCallbackType TextBufferApplyTagSignalInfo = TextBufferApplyTagCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferApplyTagCallback cb
        cb'' <- mk_TextBufferApplyTagCallback cb'
        connectSignalFunPtr obj "apply-tag" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::apply-tag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:applyTag"})

#endif

-- signal TextBuffer::begin-user-action
-- | Emitted at the beginning of a single user-visible
-- operation on a @GtkTextBuffer@.
-- 
-- See also:
-- 'GI.Gtk.Objects.TextBuffer.textBufferBeginUserAction',
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertInteractive',
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertRangeInteractive',
-- 'GI.Gtk.Objects.TextBuffer.textBufferDeleteInteractive',
-- 'GI.Gtk.Objects.TextBuffer.textBufferBackspace',
-- 'GI.Gtk.Objects.TextBuffer.textBufferDeleteSelection'.
type TextBufferBeginUserActionCallback =
    IO ()

type C_TextBufferBeginUserActionCallback =
    Ptr TextBuffer ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferBeginUserActionCallback`.
foreign import ccall "wrapper"
    mk_TextBufferBeginUserActionCallback :: C_TextBufferBeginUserActionCallback -> IO (FunPtr C_TextBufferBeginUserActionCallback)

wrap_TextBufferBeginUserActionCallback :: 
    GObject a => (a -> TextBufferBeginUserActionCallback) ->
    C_TextBufferBeginUserActionCallback
wrap_TextBufferBeginUserActionCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [beginUserAction](#signal:beginUserAction) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #beginUserAction callback
-- @
-- 
-- 
onTextBufferBeginUserAction :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferBeginUserActionCallback) -> m SignalHandlerId
onTextBufferBeginUserAction obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferBeginUserActionCallback wrapped
    wrapped'' <- mk_TextBufferBeginUserActionCallback wrapped'
    connectSignalFunPtr obj "begin-user-action" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [beginUserAction](#signal:beginUserAction) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #beginUserAction callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferBeginUserAction :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferBeginUserActionCallback) -> m SignalHandlerId
afterTextBufferBeginUserAction obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferBeginUserActionCallback wrapped
    wrapped'' <- mk_TextBufferBeginUserActionCallback wrapped'
    connectSignalFunPtr obj "begin-user-action" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferBeginUserActionSignalInfo
instance SignalInfo TextBufferBeginUserActionSignalInfo where
    type HaskellCallbackType TextBufferBeginUserActionSignalInfo = TextBufferBeginUserActionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferBeginUserActionCallback cb
        cb'' <- mk_TextBufferBeginUserActionCallback cb'
        connectSignalFunPtr obj "begin-user-action" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::begin-user-action"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:beginUserAction"})

#endif

-- signal TextBuffer::changed
-- | Emitted when the content of a @GtkTextBuffer@ has changed.
type TextBufferChangedCallback =
    IO ()

type C_TextBufferChangedCallback =
    Ptr TextBuffer ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferChangedCallback`.
foreign import ccall "wrapper"
    mk_TextBufferChangedCallback :: C_TextBufferChangedCallback -> IO (FunPtr C_TextBufferChangedCallback)

wrap_TextBufferChangedCallback :: 
    GObject a => (a -> TextBufferChangedCallback) ->
    C_TextBufferChangedCallback
wrap_TextBufferChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #changed callback
-- @
-- 
-- 
onTextBufferChanged :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferChangedCallback) -> m SignalHandlerId
onTextBufferChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferChangedCallback wrapped
    wrapped'' <- mk_TextBufferChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferChanged :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferChangedCallback) -> m SignalHandlerId
afterTextBufferChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferChangedCallback wrapped
    wrapped'' <- mk_TextBufferChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferChangedSignalInfo
instance SignalInfo TextBufferChangedSignalInfo where
    type HaskellCallbackType TextBufferChangedSignalInfo = TextBufferChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferChangedCallback cb
        cb'' <- mk_TextBufferChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:changed"})

#endif

-- signal TextBuffer::delete-range
-- | Emitted to delete a range from a @GtkTextBuffer@.
-- 
-- Note that if your handler runs before the default handler
-- it must not invalidate the /@start@/ and /@end@/ iters (or has
-- to revalidate them). The default signal handler revalidates
-- the /@start@/ and /@end@/ iters to both point to the location
-- where text was deleted. Handlers which run after the default
-- handler (see @/g_signal_connect_after()/@) do not have access to
-- the deleted text.
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferDelete'.
type TextBufferDeleteRangeCallback =
    Gtk.TextIter.TextIter
    -- ^ /@start@/: the start of the range to be deleted
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: the end of the range to be deleted
    -> IO ()

type C_TextBufferDeleteRangeCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferDeleteRangeCallback`.
foreign import ccall "wrapper"
    mk_TextBufferDeleteRangeCallback :: C_TextBufferDeleteRangeCallback -> IO (FunPtr C_TextBufferDeleteRangeCallback)

wrap_TextBufferDeleteRangeCallback :: 
    GObject a => (a -> TextBufferDeleteRangeCallback) ->
    C_TextBufferDeleteRangeCallback
wrap_TextBufferDeleteRangeCallback gi'cb gi'selfPtr start end _ = do
    B.ManagedPtr.withTransient  start $ \start' -> do
        B.ManagedPtr.withTransient  end $ \end' -> do
            B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  start' end'


-- | Connect a signal handler for the [deleteRange](#signal:deleteRange) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #deleteRange callback
-- @
-- 
-- 
onTextBufferDeleteRange :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferDeleteRangeCallback) -> m SignalHandlerId
onTextBufferDeleteRange obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferDeleteRangeCallback wrapped
    wrapped'' <- mk_TextBufferDeleteRangeCallback wrapped'
    connectSignalFunPtr obj "delete-range" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [deleteRange](#signal:deleteRange) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #deleteRange callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferDeleteRange :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferDeleteRangeCallback) -> m SignalHandlerId
afterTextBufferDeleteRange obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferDeleteRangeCallback wrapped
    wrapped'' <- mk_TextBufferDeleteRangeCallback wrapped'
    connectSignalFunPtr obj "delete-range" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferDeleteRangeSignalInfo
instance SignalInfo TextBufferDeleteRangeSignalInfo where
    type HaskellCallbackType TextBufferDeleteRangeSignalInfo = TextBufferDeleteRangeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferDeleteRangeCallback cb
        cb'' <- mk_TextBufferDeleteRangeCallback cb'
        connectSignalFunPtr obj "delete-range" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::delete-range"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:deleteRange"})

#endif

-- signal TextBuffer::end-user-action
-- | Emitted at the end of a single user-visible
-- operation on the @GtkTextBuffer@.
-- 
-- See also:
-- 'GI.Gtk.Objects.TextBuffer.textBufferEndUserAction',
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertInteractive',
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertRangeInteractive',
-- 'GI.Gtk.Objects.TextBuffer.textBufferDeleteInteractive',
-- 'GI.Gtk.Objects.TextBuffer.textBufferBackspace',
-- 'GI.Gtk.Objects.TextBuffer.textBufferDeleteSelection',
-- 'GI.Gtk.Objects.TextBuffer.textBufferBackspace'.
type TextBufferEndUserActionCallback =
    IO ()

type C_TextBufferEndUserActionCallback =
    Ptr TextBuffer ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferEndUserActionCallback`.
foreign import ccall "wrapper"
    mk_TextBufferEndUserActionCallback :: C_TextBufferEndUserActionCallback -> IO (FunPtr C_TextBufferEndUserActionCallback)

wrap_TextBufferEndUserActionCallback :: 
    GObject a => (a -> TextBufferEndUserActionCallback) ->
    C_TextBufferEndUserActionCallback
wrap_TextBufferEndUserActionCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [endUserAction](#signal:endUserAction) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #endUserAction callback
-- @
-- 
-- 
onTextBufferEndUserAction :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferEndUserActionCallback) -> m SignalHandlerId
onTextBufferEndUserAction obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferEndUserActionCallback wrapped
    wrapped'' <- mk_TextBufferEndUserActionCallback wrapped'
    connectSignalFunPtr obj "end-user-action" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [endUserAction](#signal:endUserAction) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #endUserAction callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferEndUserAction :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferEndUserActionCallback) -> m SignalHandlerId
afterTextBufferEndUserAction obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferEndUserActionCallback wrapped
    wrapped'' <- mk_TextBufferEndUserActionCallback wrapped'
    connectSignalFunPtr obj "end-user-action" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferEndUserActionSignalInfo
instance SignalInfo TextBufferEndUserActionSignalInfo where
    type HaskellCallbackType TextBufferEndUserActionSignalInfo = TextBufferEndUserActionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferEndUserActionCallback cb
        cb'' <- mk_TextBufferEndUserActionCallback cb'
        connectSignalFunPtr obj "end-user-action" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::end-user-action"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:endUserAction"})

#endif

-- signal TextBuffer::insert-child-anchor
-- | Emitted to insert a @GtkTextChildAnchor@ in a @GtkTextBuffer@.
-- 
-- Insertion actually occurs in the default handler.
-- 
-- Note that if your handler runs before the default handler
-- it must not invalidate the /@location@/ iter (or has to
-- revalidate it). The default signal handler revalidates
-- it to be placed after the inserted /@anchor@/.
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferInsertChildAnchor'.
type TextBufferInsertChildAnchorCallback =
    Gtk.TextIter.TextIter
    -- ^ /@location@/: position to insert /@anchor@/ in /@textbuffer@/
    -> Gtk.TextChildAnchor.TextChildAnchor
    -- ^ /@anchor@/: the @GtkTextChildAnchor@ to be inserted
    -> IO ()

type C_TextBufferInsertChildAnchorCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextChildAnchor.TextChildAnchor ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferInsertChildAnchorCallback`.
foreign import ccall "wrapper"
    mk_TextBufferInsertChildAnchorCallback :: C_TextBufferInsertChildAnchorCallback -> IO (FunPtr C_TextBufferInsertChildAnchorCallback)

wrap_TextBufferInsertChildAnchorCallback :: 
    GObject a => (a -> TextBufferInsertChildAnchorCallback) ->
    C_TextBufferInsertChildAnchorCallback
wrap_TextBufferInsertChildAnchorCallback gi'cb gi'selfPtr location anchor _ = do
    B.ManagedPtr.withTransient  location $ \location' -> do
        anchor' <- (newObject Gtk.TextChildAnchor.TextChildAnchor) anchor
        B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  location' anchor'


-- | Connect a signal handler for the [insertChildAnchor](#signal:insertChildAnchor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #insertChildAnchor callback
-- @
-- 
-- 
onTextBufferInsertChildAnchor :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferInsertChildAnchorCallback) -> m SignalHandlerId
onTextBufferInsertChildAnchor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferInsertChildAnchorCallback wrapped
    wrapped'' <- mk_TextBufferInsertChildAnchorCallback wrapped'
    connectSignalFunPtr obj "insert-child-anchor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [insertChildAnchor](#signal:insertChildAnchor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #insertChildAnchor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferInsertChildAnchor :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferInsertChildAnchorCallback) -> m SignalHandlerId
afterTextBufferInsertChildAnchor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferInsertChildAnchorCallback wrapped
    wrapped'' <- mk_TextBufferInsertChildAnchorCallback wrapped'
    connectSignalFunPtr obj "insert-child-anchor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferInsertChildAnchorSignalInfo
instance SignalInfo TextBufferInsertChildAnchorSignalInfo where
    type HaskellCallbackType TextBufferInsertChildAnchorSignalInfo = TextBufferInsertChildAnchorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferInsertChildAnchorCallback cb
        cb'' <- mk_TextBufferInsertChildAnchorCallback cb'
        connectSignalFunPtr obj "insert-child-anchor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::insert-child-anchor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:insertChildAnchor"})

#endif

-- signal TextBuffer::insert-paintable
-- | Emitted to insert a @GdkPaintable@ in a @GtkTextBuffer@.
-- 
-- Insertion actually occurs in the default handler.
-- 
-- Note that if your handler runs before the default handler
-- it must not invalidate the /@location@/ iter (or has to
-- revalidate it). The default signal handler revalidates
-- it to be placed after the inserted /@paintable@/.
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferInsertPaintable'.
type TextBufferInsertPaintableCallback =
    Gtk.TextIter.TextIter
    -- ^ /@location@/: position to insert /@paintable@/ in /@textbuffer@/
    -> Gdk.Paintable.Paintable
    -- ^ /@paintable@/: the @GdkPaintable@ to be inserted
    -> IO ()

type C_TextBufferInsertPaintableCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gdk.Paintable.Paintable ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferInsertPaintableCallback`.
foreign import ccall "wrapper"
    mk_TextBufferInsertPaintableCallback :: C_TextBufferInsertPaintableCallback -> IO (FunPtr C_TextBufferInsertPaintableCallback)

wrap_TextBufferInsertPaintableCallback :: 
    GObject a => (a -> TextBufferInsertPaintableCallback) ->
    C_TextBufferInsertPaintableCallback
wrap_TextBufferInsertPaintableCallback gi'cb gi'selfPtr location paintable _ = do
    B.ManagedPtr.withTransient  location $ \location' -> do
        paintable' <- (newObject Gdk.Paintable.Paintable) paintable
        B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  location' paintable'


-- | Connect a signal handler for the [insertPaintable](#signal:insertPaintable) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #insertPaintable callback
-- @
-- 
-- 
onTextBufferInsertPaintable :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferInsertPaintableCallback) -> m SignalHandlerId
onTextBufferInsertPaintable obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferInsertPaintableCallback wrapped
    wrapped'' <- mk_TextBufferInsertPaintableCallback wrapped'
    connectSignalFunPtr obj "insert-paintable" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [insertPaintable](#signal:insertPaintable) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #insertPaintable callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferInsertPaintable :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferInsertPaintableCallback) -> m SignalHandlerId
afterTextBufferInsertPaintable obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferInsertPaintableCallback wrapped
    wrapped'' <- mk_TextBufferInsertPaintableCallback wrapped'
    connectSignalFunPtr obj "insert-paintable" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferInsertPaintableSignalInfo
instance SignalInfo TextBufferInsertPaintableSignalInfo where
    type HaskellCallbackType TextBufferInsertPaintableSignalInfo = TextBufferInsertPaintableCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferInsertPaintableCallback cb
        cb'' <- mk_TextBufferInsertPaintableCallback cb'
        connectSignalFunPtr obj "insert-paintable" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::insert-paintable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:insertPaintable"})

#endif

-- signal TextBuffer::insert-text
-- | Emitted to insert text in a @GtkTextBuffer@.
-- 
-- Insertion actually occurs in the default handler.
-- 
-- Note that if your handler runs before the default handler
-- it must not invalidate the /@location@/ iter (or has to
-- revalidate it). The default signal handler revalidates
-- it to point to the end of the inserted text.
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferInsert',
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertRange'.
type TextBufferInsertTextCallback =
    Gtk.TextIter.TextIter
    -- ^ /@location@/: position to insert /@text@/ in /@textbuffer@/
    -> T.Text
    -- ^ /@text@/: the UTF-8 text to be inserted
    -> Int32
    -- ^ /@len@/: length of the inserted text in bytes
    -> IO ()

type C_TextBufferInsertTextCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextIter.TextIter ->
    CString ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferInsertTextCallback`.
foreign import ccall "wrapper"
    mk_TextBufferInsertTextCallback :: C_TextBufferInsertTextCallback -> IO (FunPtr C_TextBufferInsertTextCallback)

wrap_TextBufferInsertTextCallback :: 
    GObject a => (a -> TextBufferInsertTextCallback) ->
    C_TextBufferInsertTextCallback
wrap_TextBufferInsertTextCallback gi'cb gi'selfPtr location text len _ = do
    B.ManagedPtr.withTransient  location $ \location' -> do
        text' <- cstringToText text
        B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  location' text' len


-- | Connect a signal handler for the [insertText](#signal:insertText) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #insertText callback
-- @
-- 
-- 
onTextBufferInsertText :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferInsertTextCallback) -> m SignalHandlerId
onTextBufferInsertText obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferInsertTextCallback wrapped
    wrapped'' <- mk_TextBufferInsertTextCallback wrapped'
    connectSignalFunPtr obj "insert-text" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [insertText](#signal:insertText) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #insertText callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferInsertText :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferInsertTextCallback) -> m SignalHandlerId
afterTextBufferInsertText obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferInsertTextCallback wrapped
    wrapped'' <- mk_TextBufferInsertTextCallback wrapped'
    connectSignalFunPtr obj "insert-text" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferInsertTextSignalInfo
instance SignalInfo TextBufferInsertTextSignalInfo where
    type HaskellCallbackType TextBufferInsertTextSignalInfo = TextBufferInsertTextCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferInsertTextCallback cb
        cb'' <- mk_TextBufferInsertTextCallback cb'
        connectSignalFunPtr obj "insert-text" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::insert-text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:insertText"})

#endif

-- signal TextBuffer::mark-deleted
-- | Emitted as notification after a @GtkTextMark@ is deleted.
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferDeleteMark'.
type TextBufferMarkDeletedCallback =
    Gtk.TextMark.TextMark
    -- ^ /@mark@/: The mark that was deleted
    -> IO ()

type C_TextBufferMarkDeletedCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextMark.TextMark ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferMarkDeletedCallback`.
foreign import ccall "wrapper"
    mk_TextBufferMarkDeletedCallback :: C_TextBufferMarkDeletedCallback -> IO (FunPtr C_TextBufferMarkDeletedCallback)

wrap_TextBufferMarkDeletedCallback :: 
    GObject a => (a -> TextBufferMarkDeletedCallback) ->
    C_TextBufferMarkDeletedCallback
wrap_TextBufferMarkDeletedCallback gi'cb gi'selfPtr mark _ = do
    mark' <- (newObject Gtk.TextMark.TextMark) mark
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  mark'


-- | Connect a signal handler for the [markDeleted](#signal:markDeleted) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #markDeleted callback
-- @
-- 
-- 
onTextBufferMarkDeleted :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferMarkDeletedCallback) -> m SignalHandlerId
onTextBufferMarkDeleted obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferMarkDeletedCallback wrapped
    wrapped'' <- mk_TextBufferMarkDeletedCallback wrapped'
    connectSignalFunPtr obj "mark-deleted" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [markDeleted](#signal:markDeleted) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #markDeleted callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferMarkDeleted :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferMarkDeletedCallback) -> m SignalHandlerId
afterTextBufferMarkDeleted obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferMarkDeletedCallback wrapped
    wrapped'' <- mk_TextBufferMarkDeletedCallback wrapped'
    connectSignalFunPtr obj "mark-deleted" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferMarkDeletedSignalInfo
instance SignalInfo TextBufferMarkDeletedSignalInfo where
    type HaskellCallbackType TextBufferMarkDeletedSignalInfo = TextBufferMarkDeletedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferMarkDeletedCallback cb
        cb'' <- mk_TextBufferMarkDeletedCallback cb'
        connectSignalFunPtr obj "mark-deleted" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::mark-deleted"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:markDeleted"})

#endif

-- signal TextBuffer::mark-set
-- | Emitted as notification after a @GtkTextMark@ is set.
-- 
-- See also:
-- 'GI.Gtk.Objects.TextBuffer.textBufferCreateMark',
-- 'GI.Gtk.Objects.TextBuffer.textBufferMoveMark'.
type TextBufferMarkSetCallback =
    Gtk.TextIter.TextIter
    -- ^ /@location@/: The location of /@mark@/ in /@textbuffer@/
    -> Gtk.TextMark.TextMark
    -- ^ /@mark@/: The mark that is set
    -> IO ()

type C_TextBufferMarkSetCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextMark.TextMark ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferMarkSetCallback`.
foreign import ccall "wrapper"
    mk_TextBufferMarkSetCallback :: C_TextBufferMarkSetCallback -> IO (FunPtr C_TextBufferMarkSetCallback)

wrap_TextBufferMarkSetCallback :: 
    GObject a => (a -> TextBufferMarkSetCallback) ->
    C_TextBufferMarkSetCallback
wrap_TextBufferMarkSetCallback gi'cb gi'selfPtr location mark _ = do
    B.ManagedPtr.withTransient  location $ \location' -> do
        mark' <- (newObject Gtk.TextMark.TextMark) mark
        B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  location' mark'


-- | Connect a signal handler for the [markSet](#signal:markSet) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #markSet callback
-- @
-- 
-- 
onTextBufferMarkSet :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferMarkSetCallback) -> m SignalHandlerId
onTextBufferMarkSet obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferMarkSetCallback wrapped
    wrapped'' <- mk_TextBufferMarkSetCallback wrapped'
    connectSignalFunPtr obj "mark-set" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [markSet](#signal:markSet) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #markSet callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferMarkSet :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferMarkSetCallback) -> m SignalHandlerId
afterTextBufferMarkSet obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferMarkSetCallback wrapped
    wrapped'' <- mk_TextBufferMarkSetCallback wrapped'
    connectSignalFunPtr obj "mark-set" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferMarkSetSignalInfo
instance SignalInfo TextBufferMarkSetSignalInfo where
    type HaskellCallbackType TextBufferMarkSetSignalInfo = TextBufferMarkSetCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferMarkSetCallback cb
        cb'' <- mk_TextBufferMarkSetCallback cb'
        connectSignalFunPtr obj "mark-set" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::mark-set"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:markSet"})

#endif

-- signal TextBuffer::modified-changed
-- | Emitted when the modified bit of a @GtkTextBuffer@ flips.
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferSetModified'.
type TextBufferModifiedChangedCallback =
    IO ()

type C_TextBufferModifiedChangedCallback =
    Ptr TextBuffer ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferModifiedChangedCallback`.
foreign import ccall "wrapper"
    mk_TextBufferModifiedChangedCallback :: C_TextBufferModifiedChangedCallback -> IO (FunPtr C_TextBufferModifiedChangedCallback)

wrap_TextBufferModifiedChangedCallback :: 
    GObject a => (a -> TextBufferModifiedChangedCallback) ->
    C_TextBufferModifiedChangedCallback
wrap_TextBufferModifiedChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [modifiedChanged](#signal:modifiedChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #modifiedChanged callback
-- @
-- 
-- 
onTextBufferModifiedChanged :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferModifiedChangedCallback) -> m SignalHandlerId
onTextBufferModifiedChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferModifiedChangedCallback wrapped
    wrapped'' <- mk_TextBufferModifiedChangedCallback wrapped'
    connectSignalFunPtr obj "modified-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [modifiedChanged](#signal:modifiedChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #modifiedChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferModifiedChanged :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferModifiedChangedCallback) -> m SignalHandlerId
afterTextBufferModifiedChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferModifiedChangedCallback wrapped
    wrapped'' <- mk_TextBufferModifiedChangedCallback wrapped'
    connectSignalFunPtr obj "modified-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferModifiedChangedSignalInfo
instance SignalInfo TextBufferModifiedChangedSignalInfo where
    type HaskellCallbackType TextBufferModifiedChangedSignalInfo = TextBufferModifiedChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferModifiedChangedCallback cb
        cb'' <- mk_TextBufferModifiedChangedCallback cb'
        connectSignalFunPtr obj "modified-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::modified-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:modifiedChanged"})

#endif

-- signal TextBuffer::paste-done
-- | Emitted after paste operation has been completed.
-- 
-- This is useful to properly scroll the view to the end
-- of the pasted text. See 'GI.Gtk.Objects.TextBuffer.textBufferPasteClipboard'
-- for more details.
type TextBufferPasteDoneCallback =
    Gdk.Clipboard.Clipboard
    -- ^ /@clipboard@/: the @GdkClipboard@ pasted from
    -> IO ()

type C_TextBufferPasteDoneCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gdk.Clipboard.Clipboard ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferPasteDoneCallback`.
foreign import ccall "wrapper"
    mk_TextBufferPasteDoneCallback :: C_TextBufferPasteDoneCallback -> IO (FunPtr C_TextBufferPasteDoneCallback)

wrap_TextBufferPasteDoneCallback :: 
    GObject a => (a -> TextBufferPasteDoneCallback) ->
    C_TextBufferPasteDoneCallback
wrap_TextBufferPasteDoneCallback gi'cb gi'selfPtr clipboard _ = do
    clipboard' <- (newObject Gdk.Clipboard.Clipboard) clipboard
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  clipboard'


-- | Connect a signal handler for the [pasteDone](#signal:pasteDone) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #pasteDone callback
-- @
-- 
-- 
onTextBufferPasteDone :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferPasteDoneCallback) -> m SignalHandlerId
onTextBufferPasteDone obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferPasteDoneCallback wrapped
    wrapped'' <- mk_TextBufferPasteDoneCallback wrapped'
    connectSignalFunPtr obj "paste-done" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pasteDone](#signal:pasteDone) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #pasteDone callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferPasteDone :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferPasteDoneCallback) -> m SignalHandlerId
afterTextBufferPasteDone obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferPasteDoneCallback wrapped
    wrapped'' <- mk_TextBufferPasteDoneCallback wrapped'
    connectSignalFunPtr obj "paste-done" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferPasteDoneSignalInfo
instance SignalInfo TextBufferPasteDoneSignalInfo where
    type HaskellCallbackType TextBufferPasteDoneSignalInfo = TextBufferPasteDoneCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferPasteDoneCallback cb
        cb'' <- mk_TextBufferPasteDoneCallback cb'
        connectSignalFunPtr obj "paste-done" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::paste-done"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:pasteDone"})

#endif

-- signal TextBuffer::redo
-- | Emitted when a request has been made to redo the
-- previously undone operation.
type TextBufferRedoCallback =
    IO ()

type C_TextBufferRedoCallback =
    Ptr TextBuffer ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferRedoCallback`.
foreign import ccall "wrapper"
    mk_TextBufferRedoCallback :: C_TextBufferRedoCallback -> IO (FunPtr C_TextBufferRedoCallback)

wrap_TextBufferRedoCallback :: 
    GObject a => (a -> TextBufferRedoCallback) ->
    C_TextBufferRedoCallback
wrap_TextBufferRedoCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [redo](#signal:redo) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #redo callback
-- @
-- 
-- 
onTextBufferRedo :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferRedoCallback) -> m SignalHandlerId
onTextBufferRedo obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferRedoCallback wrapped
    wrapped'' <- mk_TextBufferRedoCallback wrapped'
    connectSignalFunPtr obj "redo" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [redo](#signal:redo) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #redo callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferRedo :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferRedoCallback) -> m SignalHandlerId
afterTextBufferRedo obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferRedoCallback wrapped
    wrapped'' <- mk_TextBufferRedoCallback wrapped'
    connectSignalFunPtr obj "redo" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferRedoSignalInfo
instance SignalInfo TextBufferRedoSignalInfo where
    type HaskellCallbackType TextBufferRedoSignalInfo = TextBufferRedoCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferRedoCallback cb
        cb'' <- mk_TextBufferRedoCallback cb'
        connectSignalFunPtr obj "redo" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::redo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:redo"})

#endif

-- signal TextBuffer::remove-tag
-- | Emitted to remove all occurrences of /@tag@/ from a range
-- of text in a @GtkTextBuffer@.
-- 
-- Removal actually occurs in the default handler.
-- 
-- Note that if your handler runs before the default handler
-- it must not invalidate the /@start@/ and /@end@/ iters (or has
-- to revalidate them).
-- 
-- See also: 'GI.Gtk.Objects.TextBuffer.textBufferRemoveTag'.
type TextBufferRemoveTagCallback =
    Gtk.TextTag.TextTag
    -- ^ /@tag@/: the tag to be removed
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: the start of the range the tag is removed from
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: the end of the range the tag is removed from
    -> IO ()

type C_TextBufferRemoveTagCallback =
    Ptr TextBuffer ->                       -- object
    Ptr Gtk.TextTag.TextTag ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferRemoveTagCallback`.
foreign import ccall "wrapper"
    mk_TextBufferRemoveTagCallback :: C_TextBufferRemoveTagCallback -> IO (FunPtr C_TextBufferRemoveTagCallback)

wrap_TextBufferRemoveTagCallback :: 
    GObject a => (a -> TextBufferRemoveTagCallback) ->
    C_TextBufferRemoveTagCallback
wrap_TextBufferRemoveTagCallback gi'cb gi'selfPtr tag start end _ = do
    tag' <- (newObject Gtk.TextTag.TextTag) tag
    B.ManagedPtr.withTransient  start $ \start' -> do
        B.ManagedPtr.withTransient  end $ \end' -> do
            B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tag' start' end'


-- | Connect a signal handler for the [removeTag](#signal:removeTag) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #removeTag callback
-- @
-- 
-- 
onTextBufferRemoveTag :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferRemoveTagCallback) -> m SignalHandlerId
onTextBufferRemoveTag obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferRemoveTagCallback wrapped
    wrapped'' <- mk_TextBufferRemoveTagCallback wrapped'
    connectSignalFunPtr obj "remove-tag" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [removeTag](#signal:removeTag) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #removeTag callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferRemoveTag :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferRemoveTagCallback) -> m SignalHandlerId
afterTextBufferRemoveTag obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferRemoveTagCallback wrapped
    wrapped'' <- mk_TextBufferRemoveTagCallback wrapped'
    connectSignalFunPtr obj "remove-tag" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferRemoveTagSignalInfo
instance SignalInfo TextBufferRemoveTagSignalInfo where
    type HaskellCallbackType TextBufferRemoveTagSignalInfo = TextBufferRemoveTagCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferRemoveTagCallback cb
        cb'' <- mk_TextBufferRemoveTagCallback cb'
        connectSignalFunPtr obj "remove-tag" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::remove-tag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:removeTag"})

#endif

-- signal TextBuffer::undo
-- | Emitted when a request has been made to undo the
-- previous operation or set of operations that have
-- been grouped together.
type TextBufferUndoCallback =
    IO ()

type C_TextBufferUndoCallback =
    Ptr TextBuffer ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferUndoCallback`.
foreign import ccall "wrapper"
    mk_TextBufferUndoCallback :: C_TextBufferUndoCallback -> IO (FunPtr C_TextBufferUndoCallback)

wrap_TextBufferUndoCallback :: 
    GObject a => (a -> TextBufferUndoCallback) ->
    C_TextBufferUndoCallback
wrap_TextBufferUndoCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [undo](#signal:undo) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textBuffer #undo callback
-- @
-- 
-- 
onTextBufferUndo :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferUndoCallback) -> m SignalHandlerId
onTextBufferUndo obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferUndoCallback wrapped
    wrapped'' <- mk_TextBufferUndoCallback wrapped'
    connectSignalFunPtr obj "undo" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [undo](#signal:undo) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textBuffer #undo callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextBufferUndo :: (IsTextBuffer a, MonadIO m) => a -> ((?self :: a) => TextBufferUndoCallback) -> m SignalHandlerId
afterTextBufferUndo obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextBufferUndoCallback wrapped
    wrapped'' <- mk_TextBufferUndoCallback wrapped'
    connectSignalFunPtr obj "undo" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextBufferUndoSignalInfo
instance SignalInfo TextBufferUndoSignalInfo where
    type HaskellCallbackType TextBufferUndoSignalInfo = TextBufferUndoCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextBufferUndoCallback cb
        cb'' <- mk_TextBufferUndoCallback cb'
        connectSignalFunPtr obj "undo" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer::undo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:signal:undo"})

#endif

-- VVV Prop "can-redo"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@can-redo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #canRedo
-- @
getTextBufferCanRedo :: (MonadIO m, IsTextBuffer o) => o -> m Bool
getTextBufferCanRedo obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "can-redo"

#if defined(ENABLE_OVERLOADING)
data TextBufferCanRedoPropertyInfo
instance AttrInfo TextBufferCanRedoPropertyInfo where
    type AttrAllowedOps TextBufferCanRedoPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TextBufferCanRedoPropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferCanRedoPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TextBufferCanRedoPropertyInfo = (~) ()
    type AttrTransferType TextBufferCanRedoPropertyInfo = ()
    type AttrGetType TextBufferCanRedoPropertyInfo = Bool
    type AttrLabel TextBufferCanRedoPropertyInfo = "can-redo"
    type AttrOrigin TextBufferCanRedoPropertyInfo = TextBuffer
    attrGet = getTextBufferCanRedo
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.canRedo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:canRedo"
        })
#endif

-- VVV Prop "can-undo"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@can-undo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #canUndo
-- @
getTextBufferCanUndo :: (MonadIO m, IsTextBuffer o) => o -> m Bool
getTextBufferCanUndo obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "can-undo"

#if defined(ENABLE_OVERLOADING)
data TextBufferCanUndoPropertyInfo
instance AttrInfo TextBufferCanUndoPropertyInfo where
    type AttrAllowedOps TextBufferCanUndoPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TextBufferCanUndoPropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferCanUndoPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TextBufferCanUndoPropertyInfo = (~) ()
    type AttrTransferType TextBufferCanUndoPropertyInfo = ()
    type AttrGetType TextBufferCanUndoPropertyInfo = Bool
    type AttrLabel TextBufferCanUndoPropertyInfo = "can-undo"
    type AttrOrigin TextBufferCanUndoPropertyInfo = TextBuffer
    attrGet = getTextBufferCanUndo
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.canUndo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:canUndo"
        })
#endif

-- VVV Prop "cursor-position"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@cursor-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #cursorPosition
-- @
getTextBufferCursorPosition :: (MonadIO m, IsTextBuffer o) => o -> m Int32
getTextBufferCursorPosition obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "cursor-position"

#if defined(ENABLE_OVERLOADING)
data TextBufferCursorPositionPropertyInfo
instance AttrInfo TextBufferCursorPositionPropertyInfo where
    type AttrAllowedOps TextBufferCursorPositionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TextBufferCursorPositionPropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferCursorPositionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TextBufferCursorPositionPropertyInfo = (~) ()
    type AttrTransferType TextBufferCursorPositionPropertyInfo = ()
    type AttrGetType TextBufferCursorPositionPropertyInfo = Int32
    type AttrLabel TextBufferCursorPositionPropertyInfo = "cursor-position"
    type AttrOrigin TextBufferCursorPositionPropertyInfo = TextBuffer
    attrGet = getTextBufferCursorPosition
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.cursorPosition"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:cursorPosition"
        })
#endif

-- VVV Prop "enable-undo"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enable-undo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #enableUndo
-- @
getTextBufferEnableUndo :: (MonadIO m, IsTextBuffer o) => o -> m Bool
getTextBufferEnableUndo obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-undo"

-- | Set the value of the “@enable-undo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textBuffer [ #enableUndo 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextBufferEnableUndo :: (MonadIO m, IsTextBuffer o) => o -> Bool -> m ()
setTextBufferEnableUndo obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-undo" val

-- | Construct a t'GValueConstruct' with valid value for the “@enable-undo@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextBufferEnableUndo :: (IsTextBuffer o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTextBufferEnableUndo val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-undo" val

#if defined(ENABLE_OVERLOADING)
data TextBufferEnableUndoPropertyInfo
instance AttrInfo TextBufferEnableUndoPropertyInfo where
    type AttrAllowedOps TextBufferEnableUndoPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint TextBufferEnableUndoPropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferEnableUndoPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TextBufferEnableUndoPropertyInfo = (~) Bool
    type AttrTransferType TextBufferEnableUndoPropertyInfo = Bool
    type AttrGetType TextBufferEnableUndoPropertyInfo = Bool
    type AttrLabel TextBufferEnableUndoPropertyInfo = "enable-undo"
    type AttrOrigin TextBufferEnableUndoPropertyInfo = TextBuffer
    attrGet = getTextBufferEnableUndo
    attrSet = setTextBufferEnableUndo
    attrPut = setTextBufferEnableUndo
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextBufferEnableUndo
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.enableUndo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:enableUndo"
        })
#endif

-- VVV Prop "has-selection"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-selection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #hasSelection
-- @
getTextBufferHasSelection :: (MonadIO m, IsTextBuffer o) => o -> m Bool
getTextBufferHasSelection obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-selection"

#if defined(ENABLE_OVERLOADING)
data TextBufferHasSelectionPropertyInfo
instance AttrInfo TextBufferHasSelectionPropertyInfo where
    type AttrAllowedOps TextBufferHasSelectionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TextBufferHasSelectionPropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferHasSelectionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TextBufferHasSelectionPropertyInfo = (~) ()
    type AttrTransferType TextBufferHasSelectionPropertyInfo = ()
    type AttrGetType TextBufferHasSelectionPropertyInfo = Bool
    type AttrLabel TextBufferHasSelectionPropertyInfo = "has-selection"
    type AttrOrigin TextBufferHasSelectionPropertyInfo = TextBuffer
    attrGet = getTextBufferHasSelection
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.hasSelection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:hasSelection"
        })
#endif

-- VVV Prop "tag-table"
   -- Type: TInterface (Name {namespace = "Gtk", name = "TextTagTable"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@tag-table@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #tagTable
-- @
getTextBufferTagTable :: (MonadIO m, IsTextBuffer o) => o -> m Gtk.TextTagTable.TextTagTable
getTextBufferTagTable obj = MIO.liftIO $ checkUnexpectedNothing "getTextBufferTagTable" $ B.Properties.getObjectPropertyObject obj "tag-table" Gtk.TextTagTable.TextTagTable

-- | Construct a t'GValueConstruct' with valid value for the “@tag-table@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextBufferTagTable :: (IsTextBuffer o, MIO.MonadIO m, Gtk.TextTagTable.IsTextTagTable a) => a -> m (GValueConstruct o)
constructTextBufferTagTable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "tag-table" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TextBufferTagTablePropertyInfo
instance AttrInfo TextBufferTagTablePropertyInfo where
    type AttrAllowedOps TextBufferTagTablePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TextBufferTagTablePropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferTagTablePropertyInfo = Gtk.TextTagTable.IsTextTagTable
    type AttrTransferTypeConstraint TextBufferTagTablePropertyInfo = Gtk.TextTagTable.IsTextTagTable
    type AttrTransferType TextBufferTagTablePropertyInfo = Gtk.TextTagTable.TextTagTable
    type AttrGetType TextBufferTagTablePropertyInfo = Gtk.TextTagTable.TextTagTable
    type AttrLabel TextBufferTagTablePropertyInfo = "tag-table"
    type AttrOrigin TextBufferTagTablePropertyInfo = TextBuffer
    attrGet = getTextBufferTagTable
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.TextTagTable.TextTagTable v
    attrConstruct = constructTextBufferTagTable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.tagTable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:tagTable"
        })
#endif

-- VVV Prop "text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textBuffer #text
-- @
getTextBufferText :: (MonadIO m, IsTextBuffer o) => o -> m (Maybe T.Text)
getTextBufferText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "text"

-- | Set the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textBuffer [ #text 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextBufferText :: (MonadIO m, IsTextBuffer o) => o -> T.Text -> m ()
setTextBufferText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextBufferText :: (IsTextBuffer o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTextBufferText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "text" (P.Just val)

-- | Set the value of the “@text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #text
-- @
clearTextBufferText :: (MonadIO m, IsTextBuffer o) => o -> m ()
clearTextBufferText obj = liftIO $ B.Properties.setObjectPropertyString obj "text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data TextBufferTextPropertyInfo
instance AttrInfo TextBufferTextPropertyInfo where
    type AttrAllowedOps TextBufferTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TextBufferTextPropertyInfo = IsTextBuffer
    type AttrSetTypeConstraint TextBufferTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TextBufferTextPropertyInfo = (~) T.Text
    type AttrTransferType TextBufferTextPropertyInfo = T.Text
    type AttrGetType TextBufferTextPropertyInfo = (Maybe T.Text)
    type AttrLabel TextBufferTextPropertyInfo = "text"
    type AttrOrigin TextBufferTextPropertyInfo = TextBuffer
    attrGet = getTextBufferText
    attrSet = setTextBufferText
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextBufferText
    attrClear = clearTextBufferText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#g:attr:text"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TextBuffer
type instance O.AttributeList TextBuffer = TextBufferAttributeList
type TextBufferAttributeList = ('[ '("canRedo", TextBufferCanRedoPropertyInfo), '("canUndo", TextBufferCanUndoPropertyInfo), '("cursorPosition", TextBufferCursorPositionPropertyInfo), '("enableUndo", TextBufferEnableUndoPropertyInfo), '("hasSelection", TextBufferHasSelectionPropertyInfo), '("tagTable", TextBufferTagTablePropertyInfo), '("text", TextBufferTextPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
textBufferCanRedo :: AttrLabelProxy "canRedo"
textBufferCanRedo = AttrLabelProxy

textBufferCanUndo :: AttrLabelProxy "canUndo"
textBufferCanUndo = AttrLabelProxy

textBufferCursorPosition :: AttrLabelProxy "cursorPosition"
textBufferCursorPosition = AttrLabelProxy

textBufferEnableUndo :: AttrLabelProxy "enableUndo"
textBufferEnableUndo = AttrLabelProxy

textBufferHasSelection :: AttrLabelProxy "hasSelection"
textBufferHasSelection = AttrLabelProxy

textBufferTagTable :: AttrLabelProxy "tagTable"
textBufferTagTable = AttrLabelProxy

textBufferText :: AttrLabelProxy "text"
textBufferText = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TextBuffer = TextBufferSignalList
type TextBufferSignalList = ('[ '("applyTag", TextBufferApplyTagSignalInfo), '("beginUserAction", TextBufferBeginUserActionSignalInfo), '("changed", TextBufferChangedSignalInfo), '("deleteRange", TextBufferDeleteRangeSignalInfo), '("endUserAction", TextBufferEndUserActionSignalInfo), '("insertChildAnchor", TextBufferInsertChildAnchorSignalInfo), '("insertPaintable", TextBufferInsertPaintableSignalInfo), '("insertText", TextBufferInsertTextSignalInfo), '("markDeleted", TextBufferMarkDeletedSignalInfo), '("markSet", TextBufferMarkSetSignalInfo), '("modifiedChanged", TextBufferModifiedChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pasteDone", TextBufferPasteDoneSignalInfo), '("redo", TextBufferRedoSignalInfo), '("removeTag", TextBufferRemoveTagSignalInfo), '("undo", TextBufferUndoSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TextBuffer::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "table"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextTagTable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a tag table, or %NULL to create a new one"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextBuffer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_new" gtk_text_buffer_new :: 
    Ptr Gtk.TextTagTable.TextTagTable ->    -- table : TInterface (Name {namespace = "Gtk", name = "TextTagTable"})
    IO (Ptr TextBuffer)

-- | Creates a new text buffer.
textBufferNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TextTagTable.IsTextTagTable a) =>
    Maybe (a)
    -- ^ /@table@/: a tag table, or 'P.Nothing' to create a new one
    -> m TextBuffer
    -- ^ __Returns:__ a new text buffer
textBufferNew table = liftIO $ do
    maybeTable <- case table of
        Nothing -> return FP.nullPtr
        Just jTable -> do
            jTable' <- unsafeManagedPtrCastPtr jTable
            return jTable'
    result <- gtk_text_buffer_new maybeTable
    checkUnexpectedReturnNULL "textBufferNew" result
    result' <- (wrapObject TextBuffer) result
    whenJust table touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TextBuffer::add_commit_notify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [type@Gtk.TextBuffer]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "TextBufferNotifyFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "which notifications should be dispatched to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "commit_notify"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "TextBufferCommitNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a\n  [callback@Gtk.TextBufferCommitNotify] to call for commit notifications"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "closure data for @commit_notify"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to free @user_data when @commit_notify is removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_add_commit_notify" gtk_text_buffer_add_commit_notify :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "TextBufferNotifyFlags"})
    FunPtr Gtk.Callbacks.C_TextBufferCommitNotify -> -- commit_notify : TInterface (Name {namespace = "Gtk", name = "TextBufferCommitNotify"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Adds a [callback/@gtk@/.TextBufferCommitNotify] to be called when a change
-- is to be made to the [type/@gtk@/.TextBuffer].
-- 
-- Functions are explicitly forbidden from making changes to the
-- [type/@gtk@/.TextBuffer] from this callback. It is intended for tracking
-- changes to the buffer only.
-- 
-- It may be advantageous to use [callback/@gtk@/.TextBufferCommitNotify] over
-- connecting to the [TextBuffer::insertText]("GI.Gtk.Objects.TextBuffer#g:signal:insertText") or
-- [TextBuffer::deleteRange]("GI.Gtk.Objects.TextBuffer#g:signal:deleteRange") signals to avoid ordering issues with
-- other signal handlers which may further modify the [type/@gtk@/.TextBuffer].
-- 
-- /Since: 4.16/
textBufferAddCommitNotify ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a [type/@gtk@/.TextBuffer]
    -> [Gtk.Flags.TextBufferNotifyFlags]
    -- ^ /@flags@/: which notifications should be dispatched to /@callback@/
    -> Gtk.Callbacks.TextBufferCommitNotify
    -- ^ /@commitNotify@/: a
    --   [callback/@gtk@/.TextBufferCommitNotify] to call for commit notifications
    -> m Word32
    -- ^ __Returns:__ a handler id which may be used to remove the commit notify
    --   callback using 'GI.Gtk.Objects.TextBuffer.textBufferRemoveCommitNotify'.
textBufferAddCommitNotify buffer flags commitNotify = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    let flags' = gflagsToWord flags
    commitNotify' <- Gtk.Callbacks.mk_TextBufferCommitNotify (Gtk.Callbacks.wrap_TextBufferCommitNotify Nothing (Gtk.Callbacks.drop_closures_TextBufferCommitNotify commitNotify))
    let userData = castFunPtrToPtr commitNotify'
    let destroy = SP.safeFreeFunPtrPtr
    result <- gtk_text_buffer_add_commit_notify buffer' flags' commitNotify' userData destroy
    touchManagedPtr buffer
    return result

#if defined(ENABLE_OVERLOADING)
data TextBufferAddCommitNotifyMethodInfo
instance (signature ~ ([Gtk.Flags.TextBufferNotifyFlags] -> Gtk.Callbacks.TextBufferCommitNotify -> m Word32), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferAddCommitNotifyMethodInfo a signature where
    overloadedMethod = textBufferAddCommitNotify

instance O.OverloadedMethodInfo TextBufferAddCommitNotifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferAddCommitNotify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferAddCommitNotify"
        })


#endif

-- method TextBuffer::add_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the mark to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "where"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to place mark"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_add_mark" gtk_text_buffer_add_mark :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    Ptr Gtk.TextIter.TextIter ->            -- where : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Adds the mark at position /@where@/.
-- 
-- The mark must not be added to another buffer, and if its name
-- is not 'P.Nothing' then there must not be another mark in the buffer
-- with the same name.
-- 
-- Emits the [TextBuffer::markSet]("GI.Gtk.Objects.TextBuffer#g:signal:markSet") signal as notification
-- of the mark\'s initial placement.
textBufferAddMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@mark@/: the mark to add
    -> Gtk.TextIter.TextIter
    -- ^ /@where@/: location to place mark
    -> m ()
textBufferAddMark buffer mark where_ = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    mark' <- unsafeManagedPtrCastPtr mark
    where_' <- unsafeManagedPtrGetPtr where_
    gtk_text_buffer_add_mark buffer' mark' where_'
    touchManagedPtr buffer
    touchManagedPtr mark
    touchManagedPtr where_
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferAddMarkMethodInfo
instance (signature ~ (b -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextBufferAddMarkMethodInfo a signature where
    overloadedMethod = textBufferAddMark

instance O.OverloadedMethodInfo TextBufferAddMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferAddMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferAddMark"
        })


#endif

-- method TextBuffer::add_selection_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clipboard"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Clipboard" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkClipboard`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_add_selection_clipboard" gtk_text_buffer_add_selection_clipboard :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gdk.Clipboard.Clipboard ->          -- clipboard : TInterface (Name {namespace = "Gdk", name = "Clipboard"})
    IO ()

-- | Adds /@clipboard@/ to the list of clipboards in which the selection
-- contents of /@buffer@/ are available.
-- 
-- In most cases, /@clipboard@/ will be the @GdkClipboard@ returned by
-- 'GI.Gtk.Objects.Widget.widgetGetPrimaryClipboard' for a view of /@buffer@/.
textBufferAddSelectionClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@clipboard@/: a @GdkClipboard@
    -> m ()
textBufferAddSelectionClipboard buffer clipboard = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    clipboard' <- unsafeManagedPtrCastPtr clipboard
    gtk_text_buffer_add_selection_clipboard buffer' clipboard'
    touchManagedPtr buffer
    touchManagedPtr clipboard
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferAddSelectionClipboardMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) => O.OverloadedMethod TextBufferAddSelectionClipboardMethodInfo a signature where
    overloadedMethod = textBufferAddSelectionClipboard

instance O.OverloadedMethodInfo TextBufferAddSelectionClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferAddSelectionClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferAddSelectionClipboard"
        })


#endif

-- method TextBuffer::apply_tag
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tag"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextTag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextTag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "one bound of range to be tagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "other bound of range to be tagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_apply_tag" gtk_text_buffer_apply_tag :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextTag.TextTag ->              -- tag : TInterface (Name {namespace = "Gtk", name = "TextTag"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Emits the “apply-tag” signal on /@buffer@/.
-- 
-- The default handler for the signal applies
-- /@tag@/ to the given range. /@start@/ and /@end@/ do
-- not have to be in order.
textBufferApplyTag ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextTag.IsTextTag b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@tag@/: a @GtkTextTag@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: one bound of range to be tagged
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: other bound of range to be tagged
    -> m ()
textBufferApplyTag buffer tag start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    tag' <- unsafeManagedPtrCastPtr tag
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_apply_tag buffer' tag' start' end'
    touchManagedPtr buffer
    touchManagedPtr tag
    touchManagedPtr start
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferApplyTagMethodInfo
instance (signature ~ (b -> Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a, Gtk.TextTag.IsTextTag b) => O.OverloadedMethod TextBufferApplyTagMethodInfo a signature where
    overloadedMethod = textBufferApplyTag

instance O.OverloadedMethodInfo TextBufferApplyTagMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferApplyTag",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferApplyTag"
        })


#endif

-- method TextBuffer::apply_tag_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of a named `GtkTextTag`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "one bound of range to be tagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "other bound of range to be tagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_apply_tag_by_name" gtk_text_buffer_apply_tag_by_name :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Emits the “apply-tag” signal on /@buffer@/.
-- 
-- Calls 'GI.Gtk.Objects.TextTagTable.textTagTableLookup' on the buffer’s
-- tag table to get a @GtkTextTag@, then calls
-- 'GI.Gtk.Objects.TextBuffer.textBufferApplyTag'.
textBufferApplyTagByName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@name@/: name of a named @GtkTextTag@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: one bound of range to be tagged
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: other bound of range to be tagged
    -> m ()
textBufferApplyTagByName buffer name start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    name' <- textToCString name
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_apply_tag_by_name buffer' name' start' end'
    touchManagedPtr buffer
    touchManagedPtr start
    touchManagedPtr end
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferApplyTagByNameMethodInfo
instance (signature ~ (T.Text -> Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferApplyTagByNameMethodInfo a signature where
    overloadedMethod = textBufferApplyTagByName

instance O.OverloadedMethodInfo TextBufferApplyTagByNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferApplyTagByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferApplyTagByName"
        })


#endif

-- method TextBuffer::backspace
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interactive"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the deletion is caused by user interaction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the buffer is editable by default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_backspace" gtk_text_buffer_backspace :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- interactive : TBasicType TBoolean
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO CInt

-- | Performs the appropriate action as if the user hit the delete
-- key with the cursor at the position specified by /@iter@/.
-- 
-- In the normal case a single character will be deleted, but when
-- combining accents are involved, more than one character can
-- be deleted, and when precomposed character and accent combinations
-- are involved, less than one character will be deleted.
-- 
-- Because the buffer is modified, all outstanding iterators become
-- invalid after calling this function; however, the /@iter@/ will be
-- re-initialized to point to the location where text was deleted.
textBufferBackspace ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a position in /@buffer@/
    -> Bool
    -- ^ /@interactive@/: whether the deletion is caused by user interaction
    -> Bool
    -- ^ /@defaultEditable@/: whether the buffer is editable by default
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the buffer was modified
textBufferBackspace buffer iter interactive defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    let interactive' = (P.fromIntegral . P.fromEnum) interactive
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    result <- gtk_text_buffer_backspace buffer' iter' interactive' defaultEditable'
    let result' = (/= 0) result
    touchManagedPtr buffer
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferBackspaceMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Bool -> Bool -> m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferBackspaceMethodInfo a signature where
    overloadedMethod = textBufferBackspace

instance O.OverloadedMethodInfo TextBufferBackspaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferBackspace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferBackspace"
        })


#endif

-- method TextBuffer::begin_irreversible_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_begin_irreversible_action" gtk_text_buffer_begin_irreversible_action :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Denotes the beginning of an action that may not be undone.
-- 
-- This will cause any previous operations in the undo\/redo queue
-- to be cleared.
-- 
-- This should be paired with a call to
-- 'GI.Gtk.Objects.TextBuffer.textBufferEndIrreversibleAction' after the irreversible
-- action has completed.
-- 
-- You may nest calls to 'GI.Gtk.Objects.TextBuffer.textBufferBeginIrreversibleAction'
-- and 'GI.Gtk.Objects.TextBuffer.textBufferEndIrreversibleAction' pairs.
textBufferBeginIrreversibleAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textBufferBeginIrreversibleAction buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_begin_irreversible_action buffer'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferBeginIrreversibleActionMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferBeginIrreversibleActionMethodInfo a signature where
    overloadedMethod = textBufferBeginIrreversibleAction

instance O.OverloadedMethodInfo TextBufferBeginIrreversibleActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferBeginIrreversibleAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferBeginIrreversibleAction"
        })


#endif

-- method TextBuffer::begin_user_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_begin_user_action" gtk_text_buffer_begin_user_action :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Called to indicate that the buffer operations between here and a
-- call to 'GI.Gtk.Objects.TextBuffer.textBufferEndUserAction' are part of a single
-- user-visible operation.
-- 
-- The operations between 'GI.Gtk.Objects.TextBuffer.textBufferBeginUserAction' and
-- 'GI.Gtk.Objects.TextBuffer.textBufferEndUserAction' can then be grouped when creating
-- an undo stack. @GtkTextBuffer@ maintains a count of calls to
-- 'GI.Gtk.Objects.TextBuffer.textBufferBeginUserAction' that have not been closed with
-- a call to 'GI.Gtk.Objects.TextBuffer.textBufferEndUserAction', and emits the
-- “begin-user-action” and “end-user-action” signals only for the
-- outermost pair of calls. This allows you to build user actions
-- from other user actions.
-- 
-- The “interactive” buffer mutation functions, such as
-- 'GI.Gtk.Objects.TextBuffer.textBufferInsertInteractive', automatically call
-- begin\/end user action around the buffer operations they perform,
-- so there\'s no need to add extra calls if you user action consists
-- solely of a single call to one of those functions.
textBufferBeginUserAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textBufferBeginUserAction buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_begin_user_action buffer'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferBeginUserActionMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferBeginUserActionMethodInfo a signature where
    overloadedMethod = textBufferBeginUserAction

instance O.OverloadedMethodInfo TextBufferBeginUserActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferBeginUserAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferBeginUserAction"
        })


#endif

-- method TextBuffer::copy_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clipboard"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Clipboard" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkClipboard` object to copy to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_copy_clipboard" gtk_text_buffer_copy_clipboard :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gdk.Clipboard.Clipboard ->          -- clipboard : TInterface (Name {namespace = "Gdk", name = "Clipboard"})
    IO ()

-- | Copies the currently-selected text to a clipboard.
textBufferCopyClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@clipboard@/: the @GdkClipboard@ object to copy to
    -> m ()
textBufferCopyClipboard buffer clipboard = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    clipboard' <- unsafeManagedPtrCastPtr clipboard
    gtk_text_buffer_copy_clipboard buffer' clipboard'
    touchManagedPtr buffer
    touchManagedPtr clipboard
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferCopyClipboardMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) => O.OverloadedMethod TextBufferCopyClipboardMethodInfo a signature where
    overloadedMethod = textBufferCopyClipboard

instance O.OverloadedMethodInfo TextBufferCopyClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferCopyClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferCopyClipboard"
        })


#endif

-- method TextBuffer::create_child_anchor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location in the buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "TextChildAnchor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_create_child_anchor" gtk_text_buffer_create_child_anchor :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO (Ptr Gtk.TextChildAnchor.TextChildAnchor)

-- | Creates and inserts a child anchor.
-- 
-- This is a convenience function which simply creates a child anchor
-- with 'GI.Gtk.Objects.TextChildAnchor.textChildAnchorNew' and inserts it into the buffer
-- with 'GI.Gtk.Objects.TextBuffer.textBufferInsertChildAnchor'.
-- 
-- The new anchor is owned by the buffer; no reference count is
-- returned to the caller of this function.
textBufferCreateChildAnchor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: location in the buffer
    -> m Gtk.TextChildAnchor.TextChildAnchor
    -- ^ __Returns:__ the created child anchor
textBufferCreateChildAnchor buffer iter = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_buffer_create_child_anchor buffer' iter'
    checkUnexpectedReturnNULL "textBufferCreateChildAnchor" result
    result' <- (newObject Gtk.TextChildAnchor.TextChildAnchor) result
    touchManagedPtr buffer
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferCreateChildAnchorMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m Gtk.TextChildAnchor.TextChildAnchor), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferCreateChildAnchorMethodInfo a signature where
    overloadedMethod = textBufferCreateChildAnchor

instance O.OverloadedMethodInfo TextBufferCreateChildAnchorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferCreateChildAnchor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferCreateChildAnchor"
        })


#endif

-- method TextBuffer::create_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name for mark" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "where"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to place mark"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "left_gravity"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the mark has left gravity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextMark" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_create_mark" gtk_text_buffer_create_mark :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- mark_name : TBasicType TUTF8
    Ptr Gtk.TextIter.TextIter ->            -- where : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- left_gravity : TBasicType TBoolean
    IO (Ptr Gtk.TextMark.TextMark)

-- | Creates a mark at position /@where@/.
-- 
-- If /@markName@/ is 'P.Nothing', the mark is anonymous; otherwise, the mark
-- can be retrieved by name using 'GI.Gtk.Objects.TextBuffer.textBufferGetMark'.
-- If a mark has left gravity, and text is inserted at the mark’s
-- current location, the mark will be moved to the left of the
-- newly-inserted text. If the mark has right gravity
-- (/@leftGravity@/ = 'P.False'), the mark will end up on the right of
-- newly-inserted text. The standard left-to-right cursor is a mark
-- with right gravity (when you type, the cursor stays on the right
-- side of the text you’re typing).
-- 
-- The caller of this function does not own a
-- reference to the returned @GtkTextMark@, so you can ignore the
-- return value if you like. Marks are owned by the buffer and go
-- away when the buffer does.
-- 
-- Emits the [TextBuffer::markSet]("GI.Gtk.Objects.TextBuffer#g:signal:markSet") signal as notification
-- of the mark\'s initial placement.
textBufferCreateMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Maybe (T.Text)
    -- ^ /@markName@/: name for mark
    -> Gtk.TextIter.TextIter
    -- ^ /@where@/: location to place mark
    -> Bool
    -- ^ /@leftGravity@/: whether the mark has left gravity
    -> m Gtk.TextMark.TextMark
    -- ^ __Returns:__ the new @GtkTextMark@ object
textBufferCreateMark buffer markName where_ leftGravity = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    maybeMarkName <- case markName of
        Nothing -> return FP.nullPtr
        Just jMarkName -> do
            jMarkName' <- textToCString jMarkName
            return jMarkName'
    where_' <- unsafeManagedPtrGetPtr where_
    let leftGravity' = (P.fromIntegral . P.fromEnum) leftGravity
    result <- gtk_text_buffer_create_mark buffer' maybeMarkName where_' leftGravity'
    checkUnexpectedReturnNULL "textBufferCreateMark" result
    result' <- (newObject Gtk.TextMark.TextMark) result
    touchManagedPtr buffer
    touchManagedPtr where_
    freeMem maybeMarkName
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferCreateMarkMethodInfo
instance (signature ~ (Maybe (T.Text) -> Gtk.TextIter.TextIter -> Bool -> m Gtk.TextMark.TextMark), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferCreateMarkMethodInfo a signature where
    overloadedMethod = textBufferCreateMark

instance O.OverloadedMethodInfo TextBufferCreateMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferCreateMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferCreateMark"
        })


#endif

-- method TextBuffer::cut_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clipboard"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Clipboard" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkClipboard` object to cut to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default editability of the buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_cut_clipboard" gtk_text_buffer_cut_clipboard :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gdk.Clipboard.Clipboard ->          -- clipboard : TInterface (Name {namespace = "Gdk", name = "Clipboard"})
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO ()

-- | Copies the currently-selected text to a clipboard,
-- then deletes said text if it’s editable.
textBufferCutClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@clipboard@/: the @GdkClipboard@ object to cut to
    -> Bool
    -- ^ /@defaultEditable@/: default editability of the buffer
    -> m ()
textBufferCutClipboard buffer clipboard defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    clipboard' <- unsafeManagedPtrCastPtr clipboard
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    gtk_text_buffer_cut_clipboard buffer' clipboard' defaultEditable'
    touchManagedPtr buffer
    touchManagedPtr clipboard
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferCutClipboardMethodInfo
instance (signature ~ (b -> Bool -> m ()), MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) => O.OverloadedMethod TextBufferCutClipboardMethodInfo a signature where
    overloadedMethod = textBufferCutClipboard

instance O.OverloadedMethodInfo TextBufferCutClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferCutClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferCutClipboard"
        })


#endif

-- method TextBuffer::delete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another position in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_delete" gtk_text_buffer_delete :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Deletes text between /@start@/ and /@end@/.
-- 
-- The order of /@start@/ and /@end@/ is not actually relevant;
-- 'GI.Gtk.Objects.TextBuffer.textBufferDelete' will reorder them.
-- 
-- This function actually emits the “delete-range” signal, and
-- the default handler of that signal deletes the text. Because the
-- buffer is modified, all outstanding iterators become invalid after
-- calling this function; however, the /@start@/ and /@end@/ will be
-- re-initialized to point to the location where text was deleted.
textBufferDelete ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: a position in /@buffer@/
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: another position in /@buffer@/
    -> m ()
textBufferDelete buffer start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_delete buffer' start' end'
    touchManagedPtr buffer
    touchManagedPtr start
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferDeleteMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferDeleteMethodInfo a signature where
    overloadedMethod = textBufferDelete

instance O.OverloadedMethodInfo TextBufferDeleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferDelete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferDelete"
        })


#endif

-- method TextBuffer::delete_interactive
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start of range to delete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end_iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "end of range" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the buffer is editable by default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_delete_interactive" gtk_text_buffer_delete_interactive :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start_iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end_iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO CInt

-- | Deletes all editable text in the given range.
-- 
-- Calls 'GI.Gtk.Objects.TextBuffer.textBufferDelete' for each editable
-- sub-range of [/@start@/,/@end@/). /@start@/ and /@end@/ are revalidated
-- to point to the location of the last deleted range, or left
-- untouched if no text was deleted.
textBufferDeleteInteractive ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@startIter@/: start of range to delete
    -> Gtk.TextIter.TextIter
    -- ^ /@endIter@/: end of range
    -> Bool
    -- ^ /@defaultEditable@/: whether the buffer is editable by default
    -> m Bool
    -- ^ __Returns:__ whether some text was actually deleted
textBufferDeleteInteractive buffer startIter endIter defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    startIter' <- unsafeManagedPtrGetPtr startIter
    endIter' <- unsafeManagedPtrGetPtr endIter
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    result <- gtk_text_buffer_delete_interactive buffer' startIter' endIter' defaultEditable'
    let result' = (/= 0) result
    touchManagedPtr buffer
    touchManagedPtr startIter
    touchManagedPtr endIter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferDeleteInteractiveMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> Bool -> m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferDeleteInteractiveMethodInfo a signature where
    overloadedMethod = textBufferDeleteInteractive

instance O.OverloadedMethodInfo TextBufferDeleteInteractiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferDeleteInteractive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferDeleteInteractive"
        })


#endif

-- method TextBuffer::delete_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextMark` in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_delete_mark" gtk_text_buffer_delete_mark :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    IO ()

-- | Deletes /@mark@/, so that it’s no longer located anywhere in the
-- buffer.
-- 
-- Removes the reference the buffer holds to the mark, so if
-- you haven’t called 'GI.GObject.Objects.Object.objectRef' on the mark, it will be freed.
-- Even if the mark isn’t freed, most operations on /@mark@/ become
-- invalid, until it gets added to a buffer again with
-- 'GI.Gtk.Objects.TextBuffer.textBufferAddMark'. Use 'GI.Gtk.Objects.TextMark.textMarkGetDeleted'
-- to find out if a mark has been removed from its buffer.
-- 
-- The [TextBuffer::markDeleted]("GI.Gtk.Objects.TextBuffer#g:signal:markDeleted") signal will be emitted as
-- notification after the mark is deleted.
textBufferDeleteMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@mark@/: a @GtkTextMark@ in /@buffer@/
    -> m ()
textBufferDeleteMark buffer mark = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    mark' <- unsafeManagedPtrCastPtr mark
    gtk_text_buffer_delete_mark buffer' mark'
    touchManagedPtr buffer
    touchManagedPtr mark
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferDeleteMarkMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextBufferDeleteMarkMethodInfo a signature where
    overloadedMethod = textBufferDeleteMark

instance O.OverloadedMethodInfo TextBufferDeleteMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferDeleteMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferDeleteMark"
        })


#endif

-- method TextBuffer::delete_mark_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of a mark in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_delete_mark_by_name" gtk_text_buffer_delete_mark_by_name :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Deletes the mark named /@name@/; the mark must exist.
-- 
-- See 'GI.Gtk.Objects.TextBuffer.textBufferDeleteMark' for details.
textBufferDeleteMarkByName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@name@/: name of a mark in /@buffer@/
    -> m ()
textBufferDeleteMarkByName buffer name = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    name' <- textToCString name
    gtk_text_buffer_delete_mark_by_name buffer' name'
    touchManagedPtr buffer
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferDeleteMarkByNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferDeleteMarkByNameMethodInfo a signature where
    overloadedMethod = textBufferDeleteMarkByName

instance O.OverloadedMethodInfo TextBufferDeleteMarkByNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferDeleteMarkByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferDeleteMarkByName"
        })


#endif

-- method TextBuffer::delete_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interactive"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the deletion is caused by user interaction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the buffer is editable by default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_delete_selection" gtk_text_buffer_delete_selection :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CInt ->                                 -- interactive : TBasicType TBoolean
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO CInt

-- | Deletes the range between the “insert” and “selection_bound” marks,
-- that is, the currently-selected text.
-- 
-- If /@interactive@/ is 'P.True', the editability of the selection will be
-- considered (users can’t delete uneditable text).
textBufferDeleteSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Bool
    -- ^ /@interactive@/: whether the deletion is caused by user interaction
    -> Bool
    -- ^ /@defaultEditable@/: whether the buffer is editable by default
    -> m Bool
    -- ^ __Returns:__ whether there was a non-empty selection to delete
textBufferDeleteSelection buffer interactive defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    let interactive' = (P.fromIntegral . P.fromEnum) interactive
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    result <- gtk_text_buffer_delete_selection buffer' interactive' defaultEditable'
    let result' = (/= 0) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferDeleteSelectionMethodInfo
instance (signature ~ (Bool -> Bool -> m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferDeleteSelectionMethodInfo a signature where
    overloadedMethod = textBufferDeleteSelection

instance O.OverloadedMethodInfo TextBufferDeleteSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferDeleteSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferDeleteSelection"
        })


#endif

-- method TextBuffer::end_irreversible_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_end_irreversible_action" gtk_text_buffer_end_irreversible_action :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Denotes the end of an action that may not be undone.
-- 
-- This will cause any previous operations in the undo\/redo
-- queue to be cleared.
-- 
-- This should be called after completing modifications to the
-- text buffer after 'GI.Gtk.Objects.TextBuffer.textBufferBeginIrreversibleAction'
-- was called.
-- 
-- You may nest calls to 'GI.Gtk.Objects.TextBuffer.textBufferBeginIrreversibleAction'
-- and 'GI.Gtk.Objects.TextBuffer.textBufferEndIrreversibleAction' pairs.
textBufferEndIrreversibleAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textBufferEndIrreversibleAction buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_end_irreversible_action buffer'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferEndIrreversibleActionMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferEndIrreversibleActionMethodInfo a signature where
    overloadedMethod = textBufferEndIrreversibleAction

instance O.OverloadedMethodInfo TextBufferEndIrreversibleActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferEndIrreversibleAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferEndIrreversibleAction"
        })


#endif

-- method TextBuffer::end_user_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_end_user_action" gtk_text_buffer_end_user_action :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Ends a user-visible operation.
-- 
-- Should be paired with a call to
-- 'GI.Gtk.Objects.TextBuffer.textBufferBeginUserAction'.
-- See that function for a full explanation.
textBufferEndUserAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textBufferEndUserAction buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_end_user_action buffer'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferEndUserActionMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferEndUserActionMethodInfo a signature where
    overloadedMethod = textBufferEndUserAction

instance O.OverloadedMethodInfo TextBufferEndUserActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferEndUserAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferEndUserAction"
        })


#endif

-- method TextBuffer::get_bounds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "iterator to initialize with first position in the buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize with the end iterator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_bounds" gtk_text_buffer_get_bounds :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Retrieves the first and last iterators in the buffer, i.e. the
-- entire buffer lies within the range [/@start@/,/@end@/).
textBufferGetBounds ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ((Gtk.TextIter.TextIter, Gtk.TextIter.TextIter))
textBufferGetBounds buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    start <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    end <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    gtk_text_buffer_get_bounds buffer' start end
    start' <- (wrapBoxed Gtk.TextIter.TextIter) start
    end' <- (wrapBoxed Gtk.TextIter.TextIter) end
    touchManagedPtr buffer
    return (start', end')

#if defined(ENABLE_OVERLOADING)
data TextBufferGetBoundsMethodInfo
instance (signature ~ (m ((Gtk.TextIter.TextIter, Gtk.TextIter.TextIter))), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetBoundsMethodInfo a signature where
    overloadedMethod = textBufferGetBounds

instance O.OverloadedMethodInfo TextBufferGetBoundsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetBounds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetBounds"
        })


#endif

-- method TextBuffer::get_can_redo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_can_redo" gtk_text_buffer_get_can_redo :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO CInt

-- | Gets whether there is a redoable action in the history.
textBufferGetCanRedo ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there is a redoable action
textBufferGetCanRedo buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_can_redo buffer'
    let result' = (/= 0) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetCanRedoMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetCanRedoMethodInfo a signature where
    overloadedMethod = textBufferGetCanRedo

instance O.OverloadedMethodInfo TextBufferGetCanRedoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetCanRedo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetCanRedo"
        })


#endif

-- method TextBuffer::get_can_undo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_can_undo" gtk_text_buffer_get_can_undo :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO CInt

-- | Gets whether there is an undoable action in the history.
textBufferGetCanUndo ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there is an undoable action
textBufferGetCanUndo buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_can_undo buffer'
    let result' = (/= 0) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetCanUndoMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetCanUndoMethodInfo a signature where
    overloadedMethod = textBufferGetCanUndo

instance O.OverloadedMethodInfo TextBufferGetCanUndoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetCanUndo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetCanUndo"
        })


#endif

-- method TextBuffer::get_char_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_char_count" gtk_text_buffer_get_char_count :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO Int32

-- | Gets the number of characters in the buffer.
-- 
-- Note that characters and bytes are not the same, you can’t e.g.
-- expect the contents of the buffer in string form to be this
-- many bytes long.
-- 
-- The character count is cached, so this function is very fast.
textBufferGetCharCount ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Int32
    -- ^ __Returns:__ number of characters in the buffer
textBufferGetCharCount buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_char_count buffer'
    touchManagedPtr buffer
    return result

#if defined(ENABLE_OVERLOADING)
data TextBufferGetCharCountMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetCharCountMethodInfo a signature where
    overloadedMethod = textBufferGetCharCount

instance O.OverloadedMethodInfo TextBufferGetCharCountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetCharCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetCharCount"
        })


#endif

-- method TextBuffer::get_enable_undo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_enable_undo" gtk_text_buffer_get_enable_undo :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO CInt

-- | Gets whether the buffer is saving modifications to the buffer
-- to allow for undo and redo actions.
-- 
-- See 'GI.Gtk.Objects.TextBuffer.textBufferBeginIrreversibleAction' and
-- 'GI.Gtk.Objects.TextBuffer.textBufferEndIrreversibleAction' to create
-- changes to the buffer that cannot be undone.
textBufferGetEnableUndo ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if undoing and redoing changes to the buffer is allowed.
textBufferGetEnableUndo buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_enable_undo buffer'
    let result' = (/= 0) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetEnableUndoMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetEnableUndoMethodInfo a signature where
    overloadedMethod = textBufferGetEnableUndo

instance O.OverloadedMethodInfo TextBufferGetEnableUndoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetEnableUndo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetEnableUndo"
        })


#endif

-- method TextBuffer::get_end_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_end_iter" gtk_text_buffer_get_end_iter :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Initializes /@iter@/ with the “end iterator,” one past the last valid
-- character in the text buffer.
-- 
-- If dereferenced with 'GI.Gtk.Structs.TextIter.textIterGetChar', the end
-- iterator has a character value of 0.
-- The entire buffer lies in the range from the first position in
-- the buffer (call 'GI.Gtk.Objects.TextBuffer.textBufferGetStartIter' to get
-- character position 0) to the end iterator.
textBufferGetEndIter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m (Gtk.TextIter.TextIter)
textBufferGetEndIter buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    gtk_text_buffer_get_end_iter buffer' iter
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    return iter'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetEndIterMethodInfo
instance (signature ~ (m (Gtk.TextIter.TextIter)), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetEndIterMethodInfo a signature where
    overloadedMethod = textBufferGetEndIter

instance O.OverloadedMethodInfo TextBufferGetEndIterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetEndIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetEndIter"
        })


#endif

-- method TextBuffer::get_has_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_has_selection" gtk_text_buffer_get_has_selection :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO CInt

-- | Indicates whether the buffer has some text currently selected.
textBufferGetHasSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the there is text selected
textBufferGetHasSelection buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_has_selection buffer'
    let result' = (/= 0) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetHasSelectionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetHasSelectionMethodInfo a signature where
    overloadedMethod = textBufferGetHasSelection

instance O.OverloadedMethodInfo TextBufferGetHasSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetHasSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetHasSelection"
        })


#endif

-- method TextBuffer::get_insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextMark" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_insert" gtk_text_buffer_get_insert :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO (Ptr Gtk.TextMark.TextMark)

-- | Returns the mark that represents the cursor (insertion point).
-- 
-- Equivalent to calling 'GI.Gtk.Objects.TextBuffer.textBufferGetMark'
-- to get the mark named “insert”, but very slightly more
-- efficient, and involves less typing.
textBufferGetInsert ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Gtk.TextMark.TextMark
    -- ^ __Returns:__ insertion point mark
textBufferGetInsert buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_insert buffer'
    checkUnexpectedReturnNULL "textBufferGetInsert" result
    result' <- (newObject Gtk.TextMark.TextMark) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetInsertMethodInfo
instance (signature ~ (m Gtk.TextMark.TextMark), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetInsertMethodInfo a signature where
    overloadedMethod = textBufferGetInsert

instance O.OverloadedMethodInfo TextBufferGetInsertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetInsert"
        })


#endif

-- method TextBuffer::get_iter_at_child_anchor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an iterator to be initialized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "anchor"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextChildAnchor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child anchor that appears in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_iter_at_child_anchor" gtk_text_buffer_get_iter_at_child_anchor :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextChildAnchor.TextChildAnchor -> -- anchor : TInterface (Name {namespace = "Gtk", name = "TextChildAnchor"})
    IO ()

-- | Obtains the location of /@anchor@/ within /@buffer@/.
textBufferGetIterAtChildAnchor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextChildAnchor.IsTextChildAnchor b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@anchor@/: a child anchor that appears in /@buffer@/
    -> m (Gtk.TextIter.TextIter)
textBufferGetIterAtChildAnchor buffer anchor = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    anchor' <- unsafeManagedPtrCastPtr anchor
    gtk_text_buffer_get_iter_at_child_anchor buffer' iter anchor'
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    touchManagedPtr anchor
    return iter'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetIterAtChildAnchorMethodInfo
instance (signature ~ (b -> m (Gtk.TextIter.TextIter)), MonadIO m, IsTextBuffer a, Gtk.TextChildAnchor.IsTextChildAnchor b) => O.OverloadedMethod TextBufferGetIterAtChildAnchorMethodInfo a signature where
    overloadedMethod = textBufferGetIterAtChildAnchor

instance O.OverloadedMethodInfo TextBufferGetIterAtChildAnchorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetIterAtChildAnchor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetIterAtChildAnchor"
        })


#endif

-- method TextBuffer::get_iter_at_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_number"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "line number counting from 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_iter_at_line" gtk_text_buffer_get_iter_at_line :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- line_number : TBasicType TInt
    IO CInt

-- | Initializes /@iter@/ to the start of the given line.
-- 
-- If /@lineNumber@/ is greater than or equal to the number of lines
-- in the /@buffer@/, the end iterator is returned.
textBufferGetIterAtLine ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Int32
    -- ^ /@lineNumber@/: line number counting from 0
    -> m ((Bool, Gtk.TextIter.TextIter))
    -- ^ __Returns:__ whether the exact position has been found
textBufferGetIterAtLine buffer lineNumber = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    result <- gtk_text_buffer_get_iter_at_line buffer' iter lineNumber
    let result' = (/= 0) result
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    return (result', iter')

#if defined(ENABLE_OVERLOADING)
data TextBufferGetIterAtLineMethodInfo
instance (signature ~ (Int32 -> m ((Bool, Gtk.TextIter.TextIter))), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetIterAtLineMethodInfo a signature where
    overloadedMethod = textBufferGetIterAtLine

instance O.OverloadedMethodInfo TextBufferGetIterAtLineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetIterAtLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetIterAtLine"
        })


#endif

-- method TextBuffer::get_iter_at_line_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_number"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "line number counting from 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "byte_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "byte index from start of line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_iter_at_line_index" gtk_text_buffer_get_iter_at_line_index :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- line_number : TBasicType TInt
    Int32 ->                                -- byte_index : TBasicType TInt
    IO CInt

-- | Obtains an iterator pointing to /@byteIndex@/ within the given line.
-- 
-- /@byteIndex@/ must be the start of a UTF-8 character. Note bytes, not
-- characters; UTF-8 may encode one character as multiple bytes.
-- 
-- If /@lineNumber@/ is greater than or equal to the number of lines in the /@buffer@/,
-- the end iterator is returned. And if /@byteIndex@/ is off the
-- end of the line, the iterator at the end of the line is returned.
textBufferGetIterAtLineIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Int32
    -- ^ /@lineNumber@/: line number counting from 0
    -> Int32
    -- ^ /@byteIndex@/: byte index from start of line
    -> m ((Bool, Gtk.TextIter.TextIter))
    -- ^ __Returns:__ whether the exact position has been found
textBufferGetIterAtLineIndex buffer lineNumber byteIndex = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    result <- gtk_text_buffer_get_iter_at_line_index buffer' iter lineNumber byteIndex
    let result' = (/= 0) result
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    return (result', iter')

#if defined(ENABLE_OVERLOADING)
data TextBufferGetIterAtLineIndexMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Bool, Gtk.TextIter.TextIter))), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetIterAtLineIndexMethodInfo a signature where
    overloadedMethod = textBufferGetIterAtLineIndex

instance O.OverloadedMethodInfo TextBufferGetIterAtLineIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetIterAtLineIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetIterAtLineIndex"
        })


#endif

-- method TextBuffer::get_iter_at_line_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_number"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "line number counting from 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "char_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "char offset from start of line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_iter_at_line_offset" gtk_text_buffer_get_iter_at_line_offset :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- line_number : TBasicType TInt
    Int32 ->                                -- char_offset : TBasicType TInt
    IO CInt

-- | Obtains an iterator pointing to /@charOffset@/ within the given line.
-- 
-- Note characters, not bytes; UTF-8 may encode one character as multiple
-- bytes.
-- 
-- If /@lineNumber@/ is greater than or equal to the number of lines in the /@buffer@/,
-- the end iterator is returned. And if /@charOffset@/ is off the
-- end of the line, the iterator at the end of the line is returned.
textBufferGetIterAtLineOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Int32
    -- ^ /@lineNumber@/: line number counting from 0
    -> Int32
    -- ^ /@charOffset@/: char offset from start of line
    -> m ((Bool, Gtk.TextIter.TextIter))
    -- ^ __Returns:__ whether the exact position has been found
textBufferGetIterAtLineOffset buffer lineNumber charOffset = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    result <- gtk_text_buffer_get_iter_at_line_offset buffer' iter lineNumber charOffset
    let result' = (/= 0) result
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    return (result', iter')

#if defined(ENABLE_OVERLOADING)
data TextBufferGetIterAtLineOffsetMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Bool, Gtk.TextIter.TextIter))), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetIterAtLineOffsetMethodInfo a signature where
    overloadedMethod = textBufferGetIterAtLineOffset

instance O.OverloadedMethodInfo TextBufferGetIterAtLineOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetIterAtLineOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetIterAtLineOffset"
        })


#endif

-- method TextBuffer::get_iter_at_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextMark` in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_iter_at_mark" gtk_text_buffer_get_iter_at_mark :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    IO ()

-- | Initializes /@iter@/ with the current position of /@mark@/.
textBufferGetIterAtMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@mark@/: a @GtkTextMark@ in /@buffer@/
    -> m (Gtk.TextIter.TextIter)
textBufferGetIterAtMark buffer mark = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    mark' <- unsafeManagedPtrCastPtr mark
    gtk_text_buffer_get_iter_at_mark buffer' iter mark'
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    touchManagedPtr mark
    return iter'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetIterAtMarkMethodInfo
instance (signature ~ (b -> m (Gtk.TextIter.TextIter)), MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextBufferGetIterAtMarkMethodInfo a signature where
    overloadedMethod = textBufferGetIterAtMark

instance O.OverloadedMethodInfo TextBufferGetIterAtMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetIterAtMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetIterAtMark"
        })


#endif

-- method TextBuffer::get_iter_at_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "char_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "char offset from start of buffer, counting from 0, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_iter_at_offset" gtk_text_buffer_get_iter_at_offset :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- char_offset : TBasicType TInt
    IO ()

-- | Initializes /@iter@/ to a position /@charOffset@/ chars from the start
-- of the entire buffer.
-- 
-- If /@charOffset@/ is -1 or greater than the number
-- of characters in the buffer, /@iter@/ is initialized to the end iterator,
-- the iterator one past the last valid character in the buffer.
textBufferGetIterAtOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Int32
    -- ^ /@charOffset@/: char offset from start of buffer, counting from 0, or -1
    -> m (Gtk.TextIter.TextIter)
textBufferGetIterAtOffset buffer charOffset = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    gtk_text_buffer_get_iter_at_offset buffer' iter charOffset
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    return iter'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetIterAtOffsetMethodInfo
instance (signature ~ (Int32 -> m (Gtk.TextIter.TextIter)), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetIterAtOffsetMethodInfo a signature where
    overloadedMethod = textBufferGetIterAtOffset

instance O.OverloadedMethodInfo TextBufferGetIterAtOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetIterAtOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetIterAtOffset"
        })


#endif

-- method TextBuffer::get_line_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_line_count" gtk_text_buffer_get_line_count :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO Int32

-- | Obtains the number of lines in the buffer.
-- 
-- This value is cached, so the function is very fast.
textBufferGetLineCount ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Int32
    -- ^ __Returns:__ number of lines in the buffer
textBufferGetLineCount buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_line_count buffer'
    touchManagedPtr buffer
    return result

#if defined(ENABLE_OVERLOADING)
data TextBufferGetLineCountMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetLineCountMethodInfo a signature where
    overloadedMethod = textBufferGetLineCount

instance O.OverloadedMethodInfo TextBufferGetLineCountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetLineCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetLineCount"
        })


#endif

-- method TextBuffer::get_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mark name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextMark" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_mark" gtk_text_buffer_get_mark :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gtk.TextMark.TextMark)

-- | Returns the mark named /@name@/ in buffer /@buffer@/, or 'P.Nothing' if no such
-- mark exists in the buffer.
textBufferGetMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@name@/: a mark name
    -> m (Maybe Gtk.TextMark.TextMark)
    -- ^ __Returns:__ a @GtkTextMark@
textBufferGetMark buffer name = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    name' <- textToCString name
    result <- gtk_text_buffer_get_mark buffer' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.TextMark.TextMark) result'
        return result''
    touchManagedPtr buffer
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TextBufferGetMarkMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gtk.TextMark.TextMark)), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetMarkMethodInfo a signature where
    overloadedMethod = textBufferGetMark

instance O.OverloadedMethodInfo TextBufferGetMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetMark"
        })


#endif

-- method TextBuffer::get_max_undo_levels
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_max_undo_levels" gtk_text_buffer_get_max_undo_levels :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO Word32

-- | Gets the maximum number of undo levels to perform.
-- 
-- If 0, unlimited undo actions may be performed. Note that this may
-- have a memory usage impact as it requires storing an additional
-- copy of the inserted or removed text within the text buffer.
textBufferGetMaxUndoLevels ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Word32
    -- ^ __Returns:__ The max number of undo levels allowed (0 indicates unlimited).
textBufferGetMaxUndoLevels buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_max_undo_levels buffer'
    touchManagedPtr buffer
    return result

#if defined(ENABLE_OVERLOADING)
data TextBufferGetMaxUndoLevelsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetMaxUndoLevelsMethodInfo a signature where
    overloadedMethod = textBufferGetMaxUndoLevels

instance O.OverloadedMethodInfo TextBufferGetMaxUndoLevelsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetMaxUndoLevels",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetMaxUndoLevels"
        })


#endif

-- method TextBuffer::get_modified
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_modified" gtk_text_buffer_get_modified :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO CInt

-- | Indicates whether the buffer has been modified since the last call
-- to 'GI.Gtk.Objects.TextBuffer.textBufferSetModified' set the modification flag to
-- 'P.False'.
-- 
-- Used for example to enable a “save” function in a text editor.
textBufferGetModified ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the buffer has been modified
textBufferGetModified buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_modified buffer'
    let result' = (/= 0) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetModifiedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetModifiedMethodInfo a signature where
    overloadedMethod = textBufferGetModified

instance O.OverloadedMethodInfo TextBufferGetModifiedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetModified",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetModified"
        })


#endif

-- method TextBuffer::get_selection_bound
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextMark" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_selection_bound" gtk_text_buffer_get_selection_bound :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO (Ptr Gtk.TextMark.TextMark)

-- | Returns the mark that represents the selection bound.
-- 
-- Equivalent to calling 'GI.Gtk.Objects.TextBuffer.textBufferGetMark'
-- to get the mark named “selection_bound”, but very slightly
-- more efficient, and involves less typing.
-- 
-- The currently-selected text in /@buffer@/ is the region between the
-- “selection_bound” and “insert” marks. If “selection_bound” and
-- “insert” are in the same place, then there is no current selection.
-- 'GI.Gtk.Objects.TextBuffer.textBufferGetSelectionBounds' is another convenient
-- function for handling the selection, if you just want to know whether
-- there’s a selection and what its bounds are.
textBufferGetSelectionBound ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Gtk.TextMark.TextMark
    -- ^ __Returns:__ selection bound mark
textBufferGetSelectionBound buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_selection_bound buffer'
    checkUnexpectedReturnNULL "textBufferGetSelectionBound" result
    result' <- (newObject Gtk.TextMark.TextMark) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetSelectionBoundMethodInfo
instance (signature ~ (m Gtk.TextMark.TextMark), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetSelectionBoundMethodInfo a signature where
    overloadedMethod = textBufferGetSelectionBound

instance O.OverloadedMethodInfo TextBufferGetSelectionBoundMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetSelectionBound",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetSelectionBound"
        })


#endif

-- method TextBuffer::get_selection_bounds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer` a `GtkTextBuffer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize with selection start"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize with selection end"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_selection_bounds" gtk_text_buffer_get_selection_bounds :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO CInt

-- | Returns 'P.True' if some text is selected; places the bounds
-- of the selection in /@start@/ and /@end@/.
-- 
-- If the selection has length 0, then /@start@/ and /@end@/ are filled
-- in with the same value. /@start@/ and /@end@/ will be in ascending order.
-- If /@start@/ and /@end@/ are 'P.Nothing', then they are not filled in, but the
-- return value still indicates whether text is selected.
textBufferGetSelectionBounds ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@ a @GtkTextBuffer@
    -> m ((Bool, Gtk.TextIter.TextIter, Gtk.TextIter.TextIter))
    -- ^ __Returns:__ whether the selection has nonzero length
textBufferGetSelectionBounds buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    start <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    end <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    result <- gtk_text_buffer_get_selection_bounds buffer' start end
    let result' = (/= 0) result
    start' <- (wrapBoxed Gtk.TextIter.TextIter) start
    end' <- (wrapBoxed Gtk.TextIter.TextIter) end
    touchManagedPtr buffer
    return (result', start', end')

#if defined(ENABLE_OVERLOADING)
data TextBufferGetSelectionBoundsMethodInfo
instance (signature ~ (m ((Bool, Gtk.TextIter.TextIter, Gtk.TextIter.TextIter))), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetSelectionBoundsMethodInfo a signature where
    overloadedMethod = textBufferGetSelectionBounds

instance O.OverloadedMethodInfo TextBufferGetSelectionBoundsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetSelectionBounds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetSelectionBounds"
        })


#endif

-- method TextBuffer::get_selection_content
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_selection_content" gtk_text_buffer_get_selection_content :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO (Ptr Gdk.ContentProvider.ContentProvider)

-- | Get a content provider for this buffer.
-- 
-- It can be used to make the content of /@buffer@/ available
-- in a @GdkClipboard@, see 'GI.Gdk.Objects.Clipboard.clipboardSetContent'.
textBufferGetSelectionContent ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Gdk.ContentProvider.ContentProvider
    -- ^ __Returns:__ a new @GdkContentProvider@.
textBufferGetSelectionContent buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_selection_content buffer'
    checkUnexpectedReturnNULL "textBufferGetSelectionContent" result
    result' <- (wrapObject Gdk.ContentProvider.ContentProvider) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetSelectionContentMethodInfo
instance (signature ~ (m Gdk.ContentProvider.ContentProvider), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetSelectionContentMethodInfo a signature where
    overloadedMethod = textBufferGetSelectionContent

instance O.OverloadedMethodInfo TextBufferGetSelectionContentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetSelectionContent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetSelectionContent"
        })


#endif

-- method TextBuffer::get_slice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start of a range" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "end of a range" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "include_hidden_chars"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to include invisible text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_slice" gtk_text_buffer_get_slice :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- include_hidden_chars : TBasicType TBoolean
    IO CString

-- | Returns the text in the range [/@start@/,/@end@/).
-- 
-- Excludes undisplayed text (text marked with tags that set the
-- invisibility attribute) if /@includeHiddenChars@/ is 'P.False'.
-- The returned string includes a 0xFFFC character whenever the
-- buffer contains embedded images, so byte and character indexes
-- into the returned string do correspond to byte and character
-- indexes into the buffer. Contrast with 'GI.Gtk.Objects.TextBuffer.textBufferGetText'.
-- Note that 0xFFFC can occur in normal text as well, so it is not a
-- reliable indicator that a paintable or widget is in the buffer.
textBufferGetSlice ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: start of a range
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: end of a range
    -> Bool
    -- ^ /@includeHiddenChars@/: whether to include invisible text
    -> m T.Text
    -- ^ __Returns:__ an allocated UTF-8 string
textBufferGetSlice buffer start end includeHiddenChars = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    let includeHiddenChars' = (P.fromIntegral . P.fromEnum) includeHiddenChars
    result <- gtk_text_buffer_get_slice buffer' start' end' includeHiddenChars'
    checkUnexpectedReturnNULL "textBufferGetSlice" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr buffer
    touchManagedPtr start
    touchManagedPtr end
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetSliceMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> Bool -> m T.Text), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetSliceMethodInfo a signature where
    overloadedMethod = textBufferGetSlice

instance O.OverloadedMethodInfo TextBufferGetSliceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetSlice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetSlice"
        })


#endif

-- method TextBuffer::get_start_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "iterator to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_start_iter" gtk_text_buffer_get_start_iter :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Initialized /@iter@/ with the first position in the text buffer.
-- 
-- This is the same as using 'GI.Gtk.Objects.TextBuffer.textBufferGetIterAtOffset'
-- to get the iter at character offset 0.
textBufferGetStartIter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m (Gtk.TextIter.TextIter)
textBufferGetStartIter buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    gtk_text_buffer_get_start_iter buffer' iter
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr buffer
    return iter'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetStartIterMethodInfo
instance (signature ~ (m (Gtk.TextIter.TextIter)), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetStartIterMethodInfo a signature where
    overloadedMethod = textBufferGetStartIter

instance O.OverloadedMethodInfo TextBufferGetStartIterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetStartIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetStartIter"
        })


#endif

-- method TextBuffer::get_tag_table
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "TextTagTable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_tag_table" gtk_text_buffer_get_tag_table :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO (Ptr Gtk.TextTagTable.TextTagTable)

-- | Get the @GtkTextTagTable@ associated with this buffer.
textBufferGetTagTable ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m Gtk.TextTagTable.TextTagTable
    -- ^ __Returns:__ the buffer’s tag table
textBufferGetTagTable buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_buffer_get_tag_table buffer'
    checkUnexpectedReturnNULL "textBufferGetTagTable" result
    result' <- (newObject Gtk.TextTagTable.TextTagTable) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetTagTableMethodInfo
instance (signature ~ (m Gtk.TextTagTable.TextTagTable), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetTagTableMethodInfo a signature where
    overloadedMethod = textBufferGetTagTable

instance O.OverloadedMethodInfo TextBufferGetTagTableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetTagTable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetTagTable"
        })


#endif

-- method TextBuffer::get_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start of a range" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "end of a range" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "include_hidden_chars"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to include invisible text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_get_text" gtk_text_buffer_get_text :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- include_hidden_chars : TBasicType TBoolean
    IO CString

-- | Returns the text in the range [/@start@/,/@end@/).
-- 
-- Excludes undisplayed text (text marked with tags that set the
-- invisibility attribute) if /@includeHiddenChars@/ is 'P.False'.
-- Does not include characters representing embedded images, so
-- byte and character indexes into the returned string do not
-- correspond to byte and character indexes into the buffer.
-- Contrast with 'GI.Gtk.Objects.TextBuffer.textBufferGetSlice'.
textBufferGetText ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: start of a range
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: end of a range
    -> Bool
    -- ^ /@includeHiddenChars@/: whether to include invisible text
    -> m T.Text
    -- ^ __Returns:__ an allocated UTF-8 string
textBufferGetText buffer start end includeHiddenChars = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    let includeHiddenChars' = (P.fromIntegral . P.fromEnum) includeHiddenChars
    result <- gtk_text_buffer_get_text buffer' start' end' includeHiddenChars'
    checkUnexpectedReturnNULL "textBufferGetText" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr buffer
    touchManagedPtr start
    touchManagedPtr end
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferGetTextMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> Bool -> m T.Text), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferGetTextMethodInfo a signature where
    overloadedMethod = textBufferGetText

instance O.OverloadedMethodInfo TextBufferGetTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferGetText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferGetText"
        })


#endif

-- method TextBuffer::insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in the buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text in UTF-8 format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of text in bytes, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert" gtk_text_buffer_insert :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    IO ()

-- | Inserts /@len@/ bytes of /@text@/ at position /@iter@/.
-- 
-- If /@len@/ is -1, /@text@/ must be nul-terminated and will be inserted in its
-- entirety. Emits the “insert-text” signal; insertion actually occurs
-- in the default handler for the signal. /@iter@/ is invalidated when
-- insertion occurs (because the buffer contents change), but the
-- default signal handler revalidates it to point to the end of the
-- inserted text.
textBufferInsert ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a position in the buffer
    -> T.Text
    -- ^ /@text@/: text in UTF-8 format
    -> Int32
    -- ^ /@len@/: length of text in bytes, or -1
    -> m ()
textBufferInsert buffer iter text len = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    text' <- textToCString text
    gtk_text_buffer_insert buffer' iter' text' len
    touchManagedPtr buffer
    touchManagedPtr iter
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> T.Text -> Int32 -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertMethodInfo a signature where
    overloadedMethod = textBufferInsert

instance O.OverloadedMethodInfo TextBufferInsertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsert"
        })


#endif

-- method TextBuffer::insert_at_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text in UTF-8 format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of text, in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_at_cursor" gtk_text_buffer_insert_at_cursor :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    IO ()

-- | Inserts /@text@/ in /@buffer@/.
-- 
-- Simply calls 'GI.Gtk.Objects.TextBuffer.textBufferInsert',
-- using the current cursor position as the insertion point.
textBufferInsertAtCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@text@/: text in UTF-8 format
    -> Int32
    -- ^ /@len@/: length of text, in bytes
    -> m ()
textBufferInsertAtCursor buffer text len = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    text' <- textToCString text
    gtk_text_buffer_insert_at_cursor buffer' text' len
    touchManagedPtr buffer
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertAtCursorMethodInfo
instance (signature ~ (T.Text -> Int32 -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertAtCursorMethodInfo a signature where
    overloadedMethod = textBufferInsertAtCursor

instance O.OverloadedMethodInfo TextBufferInsertAtCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertAtCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertAtCursor"
        })


#endif

-- method TextBuffer::insert_child_anchor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to insert the anchor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "anchor"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextChildAnchor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextChildAnchor`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_child_anchor" gtk_text_buffer_insert_child_anchor :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextChildAnchor.TextChildAnchor -> -- anchor : TInterface (Name {namespace = "Gtk", name = "TextChildAnchor"})
    IO ()

-- | Inserts a child widget anchor into the text buffer at /@iter@/.
-- 
-- The anchor will be counted as one character in character counts, and
-- when obtaining the buffer contents as a string, will be represented
-- by the Unicode “object replacement character” 0xFFFC. Note that the
-- “slice” variants for obtaining portions of the buffer as a string
-- include this character for child anchors, but the “text” variants do
-- not. E.g. see 'GI.Gtk.Objects.TextBuffer.textBufferGetSlice' and
-- 'GI.Gtk.Objects.TextBuffer.textBufferGetText'.
-- 
-- Consider 'GI.Gtk.Objects.TextBuffer.textBufferCreateChildAnchor' as a more
-- convenient alternative to this function. The buffer will add a
-- reference to the anchor, so you can unref it after insertion.
textBufferInsertChildAnchor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextChildAnchor.IsTextChildAnchor b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: location to insert the anchor
    -> b
    -- ^ /@anchor@/: a @GtkTextChildAnchor@
    -> m ()
textBufferInsertChildAnchor buffer iter anchor = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    anchor' <- unsafeManagedPtrCastPtr anchor
    gtk_text_buffer_insert_child_anchor buffer' iter' anchor'
    touchManagedPtr buffer
    touchManagedPtr iter
    touchManagedPtr anchor
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertChildAnchorMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> b -> m ()), MonadIO m, IsTextBuffer a, Gtk.TextChildAnchor.IsTextChildAnchor b) => O.OverloadedMethod TextBufferInsertChildAnchorMethodInfo a signature where
    overloadedMethod = textBufferInsertChildAnchor

instance O.OverloadedMethodInfo TextBufferInsertChildAnchorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertChildAnchor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertChildAnchor"
        })


#endif

-- method TextBuffer::insert_interactive
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "some UTF-8 text" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of text in bytes, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default editability of buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_interactive" gtk_text_buffer_insert_interactive :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO CInt

-- | Inserts /@text@/ in /@buffer@/.
-- 
-- Like 'GI.Gtk.Objects.TextBuffer.textBufferInsert', but the insertion will not occur
-- if /@iter@/ is at a non-editable location in the buffer. Usually you
-- want to prevent insertions at ineditable locations if the insertion
-- results from a user action (is interactive).
-- 
-- /@defaultEditable@/ indicates the editability of text that doesn\'t
-- have a tag affecting editability applied to it. Typically the
-- result of 'GI.Gtk.Objects.TextView.textViewGetEditable' is appropriate here.
textBufferInsertInteractive ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a position in /@buffer@/
    -> T.Text
    -- ^ /@text@/: some UTF-8 text
    -> Int32
    -- ^ /@len@/: length of text in bytes, or -1
    -> Bool
    -- ^ /@defaultEditable@/: default editability of buffer
    -> m Bool
    -- ^ __Returns:__ whether text was actually inserted
textBufferInsertInteractive buffer iter text len defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    text' <- textToCString text
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    result <- gtk_text_buffer_insert_interactive buffer' iter' text' len defaultEditable'
    let result' = (/= 0) result
    touchManagedPtr buffer
    touchManagedPtr iter
    freeMem text'
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertInteractiveMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> T.Text -> Int32 -> Bool -> m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertInteractiveMethodInfo a signature where
    overloadedMethod = textBufferInsertInteractive

instance O.OverloadedMethodInfo TextBufferInsertInteractiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertInteractive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertInteractive"
        })


#endif

-- method TextBuffer::insert_interactive_at_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text in UTF-8 format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of text in bytes, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default editability of buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_interactive_at_cursor" gtk_text_buffer_insert_interactive_at_cursor :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO CInt

-- | Inserts /@text@/ in /@buffer@/.
-- 
-- Calls 'GI.Gtk.Objects.TextBuffer.textBufferInsertInteractive'
-- at the cursor position.
-- 
-- /@defaultEditable@/ indicates the editability of text that doesn\'t
-- have a tag affecting editability applied to it. Typically the
-- result of 'GI.Gtk.Objects.TextView.textViewGetEditable' is appropriate here.
textBufferInsertInteractiveAtCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@text@/: text in UTF-8 format
    -> Int32
    -- ^ /@len@/: length of text in bytes, or -1
    -> Bool
    -- ^ /@defaultEditable@/: default editability of buffer
    -> m Bool
    -- ^ __Returns:__ whether text was actually inserted
textBufferInsertInteractiveAtCursor buffer text len defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    text' <- textToCString text
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    result <- gtk_text_buffer_insert_interactive_at_cursor buffer' text' len defaultEditable'
    let result' = (/= 0) result
    touchManagedPtr buffer
    freeMem text'
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertInteractiveAtCursorMethodInfo
instance (signature ~ (T.Text -> Int32 -> Bool -> m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertInteractiveAtCursorMethodInfo a signature where
    overloadedMethod = textBufferInsertInteractiveAtCursor

instance O.OverloadedMethodInfo TextBufferInsertInteractiveAtCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertInteractiveAtCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertInteractiveAtCursor"
        })


#endif

-- method TextBuffer::insert_markup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to insert the markup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "markup"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a nul-terminated UTF-8 string containing Pango markup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @markup in bytes, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_markup" gtk_text_buffer_insert_markup :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CString ->                              -- markup : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    IO ()

-- | Inserts the text in /@markup@/ at position /@iter@/.
-- 
-- /@markup@/ will be inserted in its entirety and must be nul-terminated
-- and valid UTF-8. Emits the [TextBuffer::insertText]("GI.Gtk.Objects.TextBuffer#g:signal:insertText") signal,
-- possibly multiple times; insertion actually occurs in the default handler
-- for the signal. /@iter@/ will point to the end of the inserted text on return.
textBufferInsertMarkup ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: location to insert the markup
    -> T.Text
    -- ^ /@markup@/: a nul-terminated UTF-8 string containing Pango markup
    -> Int32
    -- ^ /@len@/: length of /@markup@/ in bytes, or -1
    -> m ()
textBufferInsertMarkup buffer iter markup len = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    markup' <- textToCString markup
    gtk_text_buffer_insert_markup buffer' iter' markup' len
    touchManagedPtr buffer
    touchManagedPtr iter
    freeMem markup'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertMarkupMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> T.Text -> Int32 -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertMarkupMethodInfo a signature where
    overloadedMethod = textBufferInsertMarkup

instance O.OverloadedMethodInfo TextBufferInsertMarkupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertMarkup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertMarkup"
        })


#endif

-- method TextBuffer::insert_paintable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to insert the paintable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_paintable" gtk_text_buffer_insert_paintable :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gdk.Paintable.Paintable ->          -- paintable : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    IO ()

-- | Inserts an image into the text buffer at /@iter@/.
-- 
-- The image will be counted as one character in character counts,
-- and when obtaining the buffer contents as a string, will be
-- represented by the Unicode “object replacement character” 0xFFFC.
-- Note that the “slice” variants for obtaining portions of the buffer
-- as a string include this character for paintable, but the “text”
-- variants do not. e.g. see 'GI.Gtk.Objects.TextBuffer.textBufferGetSlice' and
-- 'GI.Gtk.Objects.TextBuffer.textBufferGetText'.
textBufferInsertPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gdk.Paintable.IsPaintable b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: location to insert the paintable
    -> b
    -- ^ /@paintable@/: a @GdkPaintable@
    -> m ()
textBufferInsertPaintable buffer iter paintable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    paintable' <- unsafeManagedPtrCastPtr paintable
    gtk_text_buffer_insert_paintable buffer' iter' paintable'
    touchManagedPtr buffer
    touchManagedPtr iter
    touchManagedPtr paintable
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertPaintableMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> b -> m ()), MonadIO m, IsTextBuffer a, Gdk.Paintable.IsPaintable b) => O.OverloadedMethod TextBufferInsertPaintableMethodInfo a signature where
    overloadedMethod = textBufferInsertPaintable

instance O.OverloadedMethodInfo TextBufferInsertPaintableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertPaintable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertPaintable"
        })


#endif

-- method TextBuffer::insert_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in a `GtkTextBuffer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another position in the same buffer as @start"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_range" gtk_text_buffer_insert_range :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Copies text, tags, and paintables between /@start@/ and /@end@/
-- and inserts the copy at /@iter@/.
-- 
-- The order of /@start@/ and /@end@/ doesn’t matter.
-- 
-- Used instead of simply getting\/inserting text because it preserves
-- images and tags. If /@start@/ and /@end@/ are in a different buffer from
-- /@buffer@/, the two buffers must share the same tag table.
-- 
-- Implemented via emissions of the [insertText](#g:signal:insertText) and [applyTag](#g:signal:applyTag) signals,
-- so expect those.
textBufferInsertRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a position in /@buffer@/
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: a position in a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: another position in the same buffer as /@start@/
    -> m ()
textBufferInsertRange buffer iter start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_insert_range buffer' iter' start' end'
    touchManagedPtr buffer
    touchManagedPtr iter
    touchManagedPtr start
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertRangeMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertRangeMethodInfo a signature where
    overloadedMethod = textBufferInsertRange

instance O.OverloadedMethodInfo TextBufferInsertRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertRange"
        })


#endif

-- method TextBuffer::insert_range_interactive
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in a `GtkTextBuffer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another position in the same buffer as @start"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default editability of the buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_insert_range_interactive" gtk_text_buffer_insert_range_interactive :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO CInt

-- | Copies text, tags, and paintables between /@start@/ and /@end@/
-- and inserts the copy at /@iter@/.
-- 
-- Same as 'GI.Gtk.Objects.TextBuffer.textBufferInsertRange', but does nothing
-- if the insertion point isn’t editable. The /@defaultEditable@/
-- parameter indicates whether the text is editable at /@iter@/ if
-- no tags enclosing /@iter@/ affect editability. Typically the result
-- of 'GI.Gtk.Objects.TextView.textViewGetEditable' is appropriate here.
textBufferInsertRangeInteractive ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a position in /@buffer@/
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: a position in a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: another position in the same buffer as /@start@/
    -> Bool
    -- ^ /@defaultEditable@/: default editability of the buffer
    -> m Bool
    -- ^ __Returns:__ whether an insertion was possible at /@iter@/
textBufferInsertRangeInteractive buffer iter start end defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    iter' <- unsafeManagedPtrGetPtr iter
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    result <- gtk_text_buffer_insert_range_interactive buffer' iter' start' end' defaultEditable'
    let result' = (/= 0) result
    touchManagedPtr buffer
    touchManagedPtr iter
    touchManagedPtr start
    touchManagedPtr end
    return result'

#if defined(ENABLE_OVERLOADING)
data TextBufferInsertRangeInteractiveMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> Bool -> m Bool), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferInsertRangeInteractiveMethodInfo a signature where
    overloadedMethod = textBufferInsertRangeInteractive

instance O.OverloadedMethodInfo TextBufferInsertRangeInteractiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferInsertRangeInteractive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferInsertRangeInteractive"
        })


#endif

-- method TextBuffer::move_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextMark`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "where"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new location for @mark in @buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_move_mark" gtk_text_buffer_move_mark :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    Ptr Gtk.TextIter.TextIter ->            -- where : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Moves /@mark@/ to the new location /@where@/.
-- 
-- Emits the [TextBuffer::markSet]("GI.Gtk.Objects.TextBuffer#g:signal:markSet") signal
-- as notification of the move.
textBufferMoveMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@mark@/: a @GtkTextMark@
    -> Gtk.TextIter.TextIter
    -- ^ /@where@/: new location for /@mark@/ in /@buffer@/
    -> m ()
textBufferMoveMark buffer mark where_ = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    mark' <- unsafeManagedPtrCastPtr mark
    where_' <- unsafeManagedPtrGetPtr where_
    gtk_text_buffer_move_mark buffer' mark' where_'
    touchManagedPtr buffer
    touchManagedPtr mark
    touchManagedPtr where_
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferMoveMarkMethodInfo
instance (signature ~ (b -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextBufferMoveMarkMethodInfo a signature where
    overloadedMethod = textBufferMoveMark

instance O.OverloadedMethodInfo TextBufferMoveMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferMoveMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferMoveMark"
        })


#endif

-- method TextBuffer::move_mark_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of a mark" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "where"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new location for mark"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_move_mark_by_name" gtk_text_buffer_move_mark_by_name :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr Gtk.TextIter.TextIter ->            -- where : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Moves the mark named /@name@/ (which must exist) to location /@where@/.
-- 
-- See 'GI.Gtk.Objects.TextBuffer.textBufferMoveMark' for details.
textBufferMoveMarkByName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@name@/: name of a mark
    -> Gtk.TextIter.TextIter
    -- ^ /@where@/: new location for mark
    -> m ()
textBufferMoveMarkByName buffer name where_ = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    name' <- textToCString name
    where_' <- unsafeManagedPtrGetPtr where_
    gtk_text_buffer_move_mark_by_name buffer' name' where_'
    touchManagedPtr buffer
    touchManagedPtr where_
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferMoveMarkByNameMethodInfo
instance (signature ~ (T.Text -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferMoveMarkByNameMethodInfo a signature where
    overloadedMethod = textBufferMoveMarkByName

instance O.OverloadedMethodInfo TextBufferMoveMarkByNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferMoveMarkByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferMoveMarkByName"
        })


#endif

-- method TextBuffer::paste_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clipboard"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Clipboard" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkClipboard` to paste from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "override_location"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to insert pasted text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_editable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the buffer is editable by default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_paste_clipboard" gtk_text_buffer_paste_clipboard :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gdk.Clipboard.Clipboard ->          -- clipboard : TInterface (Name {namespace = "Gdk", name = "Clipboard"})
    Ptr Gtk.TextIter.TextIter ->            -- override_location : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CInt ->                                 -- default_editable : TBasicType TBoolean
    IO ()

-- | Pastes the contents of a clipboard.
-- 
-- If /@overrideLocation@/ is 'P.Nothing', the pasted text will be inserted
-- at the cursor position, or the buffer selection will be replaced
-- if the selection is non-empty.
-- 
-- Note: pasting is asynchronous, that is, we’ll ask for the paste data
-- and return, and at some point later after the main loop runs, the paste
-- data will be inserted.
textBufferPasteClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@clipboard@/: the @GdkClipboard@ to paste from
    -> Maybe (Gtk.TextIter.TextIter)
    -- ^ /@overrideLocation@/: location to insert pasted text
    -> Bool
    -- ^ /@defaultEditable@/: whether the buffer is editable by default
    -> m ()
textBufferPasteClipboard buffer clipboard overrideLocation defaultEditable = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    clipboard' <- unsafeManagedPtrCastPtr clipboard
    maybeOverrideLocation <- case overrideLocation of
        Nothing -> return FP.nullPtr
        Just jOverrideLocation -> do
            jOverrideLocation' <- unsafeManagedPtrGetPtr jOverrideLocation
            return jOverrideLocation'
    let defaultEditable' = (P.fromIntegral . P.fromEnum) defaultEditable
    gtk_text_buffer_paste_clipboard buffer' clipboard' maybeOverrideLocation defaultEditable'
    touchManagedPtr buffer
    touchManagedPtr clipboard
    whenJust overrideLocation touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferPasteClipboardMethodInfo
instance (signature ~ (b -> Maybe (Gtk.TextIter.TextIter) -> Bool -> m ()), MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) => O.OverloadedMethod TextBufferPasteClipboardMethodInfo a signature where
    overloadedMethod = textBufferPasteClipboard

instance O.OverloadedMethodInfo TextBufferPasteClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferPasteClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferPasteClipboard"
        })


#endif

-- method TextBuffer::place_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "where"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "where to put the cursor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_place_cursor" gtk_text_buffer_place_cursor :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- where : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | This function moves the “insert” and “selection_bound” marks
-- simultaneously.
-- 
-- If you move them to the same place in two steps with
-- 'GI.Gtk.Objects.TextBuffer.textBufferMoveMark', you will temporarily select a
-- region in between their old and new locations, which can be pretty
-- inefficient since the temporarily-selected region will force stuff
-- to be recalculated. This function moves them as a unit, which can
-- be optimized.
textBufferPlaceCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@where@/: where to put the cursor
    -> m ()
textBufferPlaceCursor buffer where_ = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    where_' <- unsafeManagedPtrGetPtr where_
    gtk_text_buffer_place_cursor buffer' where_'
    touchManagedPtr buffer
    touchManagedPtr where_
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferPlaceCursorMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferPlaceCursorMethodInfo a signature where
    overloadedMethod = textBufferPlaceCursor

instance O.OverloadedMethodInfo TextBufferPlaceCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferPlaceCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferPlaceCursor"
        })


#endif

-- method TextBuffer::redo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_redo" gtk_text_buffer_redo :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Redoes the next redoable action on the buffer, if there is one.
textBufferRedo ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textBufferRedo buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_redo buffer'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferRedoMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferRedoMethodInfo a signature where
    overloadedMethod = textBufferRedo

instance O.OverloadedMethodInfo TextBufferRedoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferRedo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferRedo"
        })


#endif

-- method TextBuffer::remove_all_tags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "one bound of range to be untagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "other bound of range to be untagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_remove_all_tags" gtk_text_buffer_remove_all_tags :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Removes all tags in the range between /@start@/ and /@end@/.
-- 
-- Be careful with this function; it could remove tags added in code
-- unrelated to the code you’re currently writing. That is, using this
-- function is probably a bad idea if you have two or more unrelated
-- code sections that add tags.
textBufferRemoveAllTags ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: one bound of range to be untagged
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: other bound of range to be untagged
    -> m ()
textBufferRemoveAllTags buffer start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_remove_all_tags buffer' start' end'
    touchManagedPtr buffer
    touchManagedPtr start
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferRemoveAllTagsMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferRemoveAllTagsMethodInfo a signature where
    overloadedMethod = textBufferRemoveAllTags

instance O.OverloadedMethodInfo TextBufferRemoveAllTagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferRemoveAllTags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferRemoveAllTags"
        })


#endif

-- method TextBuffer::remove_commit_notify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "commit_notify_handler"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the notify handler identifier returned from\n  [method@Gtk.TextBuffer.add_commit_notify]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_remove_commit_notify" gtk_text_buffer_remove_commit_notify :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Word32 ->                               -- commit_notify_handler : TBasicType TUInt
    IO ()

-- | Removes the @GtkTextBufferCommitNotify@ handler previously registered
-- with 'GI.Gtk.Objects.TextBuffer.textBufferAddCommitNotify'.
-- 
-- This may result in the @user_data_destroy@ being called that was passed when registering
-- the commit notify functions.
-- 
-- /Since: 4.16/
textBufferRemoveCommitNotify ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Word32
    -- ^ /@commitNotifyHandler@/: the notify handler identifier returned from
    --   'GI.Gtk.Objects.TextBuffer.textBufferAddCommitNotify'.
    -> m ()
textBufferRemoveCommitNotify buffer commitNotifyHandler = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_remove_commit_notify buffer' commitNotifyHandler
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferRemoveCommitNotifyMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferRemoveCommitNotifyMethodInfo a signature where
    overloadedMethod = textBufferRemoveCommitNotify

instance O.OverloadedMethodInfo TextBufferRemoveCommitNotifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferRemoveCommitNotify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferRemoveCommitNotify"
        })


#endif

-- method TextBuffer::remove_selection_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clipboard"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Clipboard" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GdkClipboard` added to @buffer by\n  [method@Gtk.TextBuffer.add_selection_clipboard]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_remove_selection_clipboard" gtk_text_buffer_remove_selection_clipboard :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gdk.Clipboard.Clipboard ->          -- clipboard : TInterface (Name {namespace = "Gdk", name = "Clipboard"})
    IO ()

-- | Removes a @GdkClipboard@ added with
-- 'GI.Gtk.Objects.TextBuffer.textBufferAddSelectionClipboard'
textBufferRemoveSelectionClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@clipboard@/: a @GdkClipboard@ added to /@buffer@/ by
    --   'GI.Gtk.Objects.TextBuffer.textBufferAddSelectionClipboard'
    -> m ()
textBufferRemoveSelectionClipboard buffer clipboard = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    clipboard' <- unsafeManagedPtrCastPtr clipboard
    gtk_text_buffer_remove_selection_clipboard buffer' clipboard'
    touchManagedPtr buffer
    touchManagedPtr clipboard
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferRemoveSelectionClipboardMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTextBuffer a, Gdk.Clipboard.IsClipboard b) => O.OverloadedMethod TextBufferRemoveSelectionClipboardMethodInfo a signature where
    overloadedMethod = textBufferRemoveSelectionClipboard

instance O.OverloadedMethodInfo TextBufferRemoveSelectionClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferRemoveSelectionClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferRemoveSelectionClipboard"
        })


#endif

-- method TextBuffer::remove_tag
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tag"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextTag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextTag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "one bound of range to be untagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "other bound of range to be untagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_remove_tag" gtk_text_buffer_remove_tag :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextTag.TextTag ->              -- tag : TInterface (Name {namespace = "Gtk", name = "TextTag"})
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Emits the “remove-tag” signal.
-- 
-- The default handler for the signal removes all occurrences
-- of /@tag@/ from the given range. /@start@/ and /@end@/ don’t have
-- to be in order.
textBufferRemoveTag ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a, Gtk.TextTag.IsTextTag b) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> b
    -- ^ /@tag@/: a @GtkTextTag@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: one bound of range to be untagged
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: other bound of range to be untagged
    -> m ()
textBufferRemoveTag buffer tag start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    tag' <- unsafeManagedPtrCastPtr tag
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_remove_tag buffer' tag' start' end'
    touchManagedPtr buffer
    touchManagedPtr tag
    touchManagedPtr start
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferRemoveTagMethodInfo
instance (signature ~ (b -> Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a, Gtk.TextTag.IsTextTag b) => O.OverloadedMethod TextBufferRemoveTagMethodInfo a signature where
    overloadedMethod = textBufferRemoveTag

instance O.OverloadedMethodInfo TextBufferRemoveTagMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferRemoveTag",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferRemoveTag"
        })


#endif

-- method TextBuffer::remove_tag_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of a `GtkTextTag`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "one bound of range to be untagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "other bound of range to be untagged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_remove_tag_by_name" gtk_text_buffer_remove_tag_by_name :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr Gtk.TextIter.TextIter ->            -- start : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- end : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | Emits the “remove-tag” signal.
-- 
-- Calls 'GI.Gtk.Objects.TextTagTable.textTagTableLookup' on the buffer’s
-- tag table to get a @GtkTextTag@, then calls
-- 'GI.Gtk.Objects.TextBuffer.textBufferRemoveTag'.
textBufferRemoveTagByName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@name@/: name of a @GtkTextTag@
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: one bound of range to be untagged
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: other bound of range to be untagged
    -> m ()
textBufferRemoveTagByName buffer name start end = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    name' <- textToCString name
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    gtk_text_buffer_remove_tag_by_name buffer' name' start' end'
    touchManagedPtr buffer
    touchManagedPtr start
    touchManagedPtr end
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferRemoveTagByNameMethodInfo
instance (signature ~ (T.Text -> Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferRemoveTagByNameMethodInfo a signature where
    overloadedMethod = textBufferRemoveTagByName

instance O.OverloadedMethodInfo TextBufferRemoveTagByNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferRemoveTagByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferRemoveTagByName"
        })


#endif

-- method TextBuffer::select_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ins"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "where to put the \8220insert\8221 mark"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bound"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "where to put the \8220selection_bound\8221 mark"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_select_range" gtk_text_buffer_select_range :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Ptr Gtk.TextIter.TextIter ->            -- ins : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gtk.TextIter.TextIter ->            -- bound : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO ()

-- | This function moves the “insert” and “selection_bound” marks
-- simultaneously.
-- 
-- If you move them in two steps with
-- 'GI.Gtk.Objects.TextBuffer.textBufferMoveMark', you will temporarily select a
-- region in between their old and new locations, which can be pretty
-- inefficient since the temporarily-selected region will force stuff
-- to be recalculated. This function moves them as a unit, which can
-- be optimized.
textBufferSelectRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Gtk.TextIter.TextIter
    -- ^ /@ins@/: where to put the “insert” mark
    -> Gtk.TextIter.TextIter
    -- ^ /@bound@/: where to put the “selection_bound” mark
    -> m ()
textBufferSelectRange buffer ins bound = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    ins' <- unsafeManagedPtrGetPtr ins
    bound' <- unsafeManagedPtrGetPtr bound
    gtk_text_buffer_select_range buffer' ins' bound'
    touchManagedPtr buffer
    touchManagedPtr ins
    touchManagedPtr bound
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferSelectRangeMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Gtk.TextIter.TextIter -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferSelectRangeMethodInfo a signature where
    overloadedMethod = textBufferSelectRange

instance O.OverloadedMethodInfo TextBufferSelectRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferSelectRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferSelectRange"
        })


#endif

-- method TextBuffer::set_enable_undo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enable_undo"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to enable undo"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_set_enable_undo" gtk_text_buffer_set_enable_undo :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CInt ->                                 -- enable_undo : TBasicType TBoolean
    IO ()

-- | Sets whether or not to enable undoable actions in the text buffer.
-- 
-- Undoable actions in this context are changes to the text content of
-- the buffer. Changes to tags and marks are not tracked.
-- 
-- If enabled, the user will be able to undo the last number of actions
-- up to 'GI.Gtk.Objects.TextBuffer.textBufferGetMaxUndoLevels'.
-- 
-- See 'GI.Gtk.Objects.TextBuffer.textBufferBeginIrreversibleAction' and
-- 'GI.Gtk.Objects.TextBuffer.textBufferEndIrreversibleAction' to create
-- changes to the buffer that cannot be undone.
textBufferSetEnableUndo ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Bool
    -- ^ /@enableUndo@/: 'P.True' to enable undo
    -> m ()
textBufferSetEnableUndo buffer enableUndo = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    let enableUndo' = (P.fromIntegral . P.fromEnum) enableUndo
    gtk_text_buffer_set_enable_undo buffer' enableUndo'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferSetEnableUndoMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferSetEnableUndoMethodInfo a signature where
    overloadedMethod = textBufferSetEnableUndo

instance O.OverloadedMethodInfo TextBufferSetEnableUndoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferSetEnableUndo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferSetEnableUndo"
        })


#endif

-- method TextBuffer::set_max_undo_levels
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_undo_levels"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum number of undo actions to perform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_set_max_undo_levels" gtk_text_buffer_set_max_undo_levels :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    Word32 ->                               -- max_undo_levels : TBasicType TUInt
    IO ()

-- | Sets the maximum number of undo levels to perform.
-- 
-- If 0, unlimited undo actions may be performed. Note that this may
-- have a memory usage impact as it requires storing an additional
-- copy of the inserted or removed text within the text buffer.
textBufferSetMaxUndoLevels ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Word32
    -- ^ /@maxUndoLevels@/: the maximum number of undo actions to perform
    -> m ()
textBufferSetMaxUndoLevels buffer maxUndoLevels = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_set_max_undo_levels buffer' maxUndoLevels
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferSetMaxUndoLevelsMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferSetMaxUndoLevelsMethodInfo a signature where
    overloadedMethod = textBufferSetMaxUndoLevels

instance O.OverloadedMethodInfo TextBufferSetMaxUndoLevelsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferSetMaxUndoLevels",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferSetMaxUndoLevels"
        })


#endif

-- method TextBuffer::set_modified
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "modification flag setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_set_modified" gtk_text_buffer_set_modified :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Used to keep track of whether the buffer has been
-- modified since the last time it was saved.
-- 
-- Whenever the buffer is saved to disk, call
-- @gtk_text_buffer_set_modified (\@buffer, FALSE)@.
-- When the buffer is modified, it will automatically
-- toggle on the modified bit again. When the modified
-- bit flips, the buffer emits the
-- [TextBuffer::modifiedChanged]("GI.Gtk.Objects.TextBuffer#g:signal:modifiedChanged") signal.
textBufferSetModified ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> Bool
    -- ^ /@setting@/: modification flag setting
    -> m ()
textBufferSetModified buffer setting = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_text_buffer_set_modified buffer' setting'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferSetModifiedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferSetModifiedMethodInfo a signature where
    overloadedMethod = textBufferSetModified

instance O.OverloadedMethodInfo TextBufferSetModifiedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferSetModified",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferSetModified"
        })


#endif

-- method TextBuffer::set_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "UTF-8 text to insert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @text in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_set_text" gtk_text_buffer_set_text :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    IO ()

-- | Deletes current contents of /@buffer@/, and inserts /@text@/ instead. This is
-- automatically marked as an irreversible action in the undo stack. If you
-- wish to mark this action as part of a larger undo operation, call
-- [method/@textBuffer@/.delete] and [method/@textBuffer@/.insert] directly instead.
-- 
-- If /@len@/ is -1, /@text@/ must be nul-terminated.
-- /@text@/ must be valid UTF-8.
textBufferSetText ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> T.Text
    -- ^ /@text@/: UTF-8 text to insert
    -> Int32
    -- ^ /@len@/: length of /@text@/ in bytes
    -> m ()
textBufferSetText buffer text len = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    text' <- textToCString text
    gtk_text_buffer_set_text buffer' text' len
    touchManagedPtr buffer
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferSetTextMethodInfo
instance (signature ~ (T.Text -> Int32 -> m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferSetTextMethodInfo a signature where
    overloadedMethod = textBufferSetText

instance O.OverloadedMethodInfo TextBufferSetTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferSetText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferSetText"
        })


#endif

-- method TextBuffer::undo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_buffer_undo" gtk_text_buffer_undo :: 
    Ptr TextBuffer ->                       -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Undoes the last undoable action on the buffer, if there is one.
textBufferUndo ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textBufferUndo buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    gtk_text_buffer_undo buffer'
    touchManagedPtr buffer
    return ()

#if defined(ENABLE_OVERLOADING)
data TextBufferUndoMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextBuffer a) => O.OverloadedMethod TextBufferUndoMethodInfo a signature where
    overloadedMethod = textBufferUndo

instance O.OverloadedMethodInfo TextBufferUndoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextBuffer.textBufferUndo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TextBuffer.html#v:textBufferUndo"
        })


#endif


