{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Reveals a search entry when search is started.
-- 
-- \<picture>
--   \<source srcset=\"search-bar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkSearchBar\" src=\"search-bar.png\">
-- \<\/picture>
-- 
-- It can also contain additional widgets, such as drop-down menus,
-- or buttons.  The search bar would appear when a search is started
-- through typing on the keyboard, or the application’s search mode
-- is toggled on.
-- 
-- For keyboard presses to start a search, the search bar must be told
-- of a widget to capture key events from through
-- 'GI.Gtk.Objects.SearchBar.searchBarSetKeyCaptureWidget'. This widget will
-- typically be the top-level window, or a parent container of the
-- search bar. Common shortcuts such as Ctrl+F should be handled as an
-- application action, or through the menu items.
-- 
-- You will also need to tell the search bar about which entry you
-- are using as your search entry using 'GI.Gtk.Objects.SearchBar.searchBarConnectEntry'.
-- 
-- == Creating a search bar
-- 
-- The following example shows you how to create a more complex search
-- entry.
-- 
-- <https://gitlab.gnome.org/GNOME/gtk/tree/main/examples/search-bar.c A simple example>
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkSearchBar@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Escape\<\/kbd> hides the search bar.
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >searchbar
-- >╰── revealer
-- >    ╰── box
-- >         ├── [child]
-- >         ╰── [button.close]
-- 
-- 
-- @GtkSearchBar@ has a main CSS node with name searchbar. It has a child
-- node with name revealer that contains a node with name box. The box node
-- contains both the CSS node of the child widget as well as an optional button
-- node which gets the .close style class applied.
-- 
-- = Accessibility
-- 
-- @GtkSearchBar@ uses the 'GI.Gtk.Enums.AccessibleRoleSearch' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SearchBar
    ( 

-- * Exported types
    SearchBar(..)                           ,
    IsSearchBar                             ,
    toSearchBar                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [connectEntry]("GI.Gtk.Objects.SearchBar#g:method:connectEntry"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.SearchBar#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getKeyCaptureWidget]("GI.Gtk.Objects.SearchBar#g:method:getKeyCaptureWidget"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSearchMode]("GI.Gtk.Objects.SearchBar#g:method:getSearchMode"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowCloseButton]("GI.Gtk.Objects.SearchBar#g:method:getShowCloseButton"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.SearchBar#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setKeyCaptureWidget]("GI.Gtk.Objects.SearchBar#g:method:setKeyCaptureWidget"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSearchMode]("GI.Gtk.Objects.SearchBar#g:method:setSearchMode"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowCloseButton]("GI.Gtk.Objects.SearchBar#g:method:setShowCloseButton"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveSearchBarMethod                  ,
#endif

-- ** connectEntry #method:connectEntry#

#if defined(ENABLE_OVERLOADING)
    SearchBarConnectEntryMethodInfo         ,
#endif
    searchBarConnectEntry                   ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    SearchBarGetChildMethodInfo             ,
#endif
    searchBarGetChild                       ,


-- ** getKeyCaptureWidget #method:getKeyCaptureWidget#

#if defined(ENABLE_OVERLOADING)
    SearchBarGetKeyCaptureWidgetMethodInfo  ,
#endif
    searchBarGetKeyCaptureWidget            ,


-- ** getSearchMode #method:getSearchMode#

#if defined(ENABLE_OVERLOADING)
    SearchBarGetSearchModeMethodInfo        ,
#endif
    searchBarGetSearchMode                  ,


-- ** getShowCloseButton #method:getShowCloseButton#

#if defined(ENABLE_OVERLOADING)
    SearchBarGetShowCloseButtonMethodInfo   ,
#endif
    searchBarGetShowCloseButton             ,


-- ** new #method:new#

    searchBarNew                            ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    SearchBarSetChildMethodInfo             ,
#endif
    searchBarSetChild                       ,


-- ** setKeyCaptureWidget #method:setKeyCaptureWidget#

#if defined(ENABLE_OVERLOADING)
    SearchBarSetKeyCaptureWidgetMethodInfo  ,
#endif
    searchBarSetKeyCaptureWidget            ,


-- ** setSearchMode #method:setSearchMode#

#if defined(ENABLE_OVERLOADING)
    SearchBarSetSearchModeMethodInfo        ,
#endif
    searchBarSetSearchMode                  ,


-- ** setShowCloseButton #method:setShowCloseButton#

#if defined(ENABLE_OVERLOADING)
    SearchBarSetShowCloseButtonMethodInfo   ,
#endif
    searchBarSetShowCloseButton             ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    SearchBarChildPropertyInfo              ,
#endif
    clearSearchBarChild                     ,
    constructSearchBarChild                 ,
    getSearchBarChild                       ,
#if defined(ENABLE_OVERLOADING)
    searchBarChild                          ,
#endif
    setSearchBarChild                       ,


-- ** keyCaptureWidget #attr:keyCaptureWidget#
-- | The key capture widget.

#if defined(ENABLE_OVERLOADING)
    SearchBarKeyCaptureWidgetPropertyInfo   ,
#endif
    clearSearchBarKeyCaptureWidget          ,
    constructSearchBarKeyCaptureWidget      ,
    getSearchBarKeyCaptureWidget            ,
#if defined(ENABLE_OVERLOADING)
    searchBarKeyCaptureWidget               ,
#endif
    setSearchBarKeyCaptureWidget            ,


-- ** searchModeEnabled #attr:searchModeEnabled#
-- | Whether the search mode is on and the search bar shown.

#if defined(ENABLE_OVERLOADING)
    SearchBarSearchModeEnabledPropertyInfo  ,
#endif
    constructSearchBarSearchModeEnabled     ,
    getSearchBarSearchModeEnabled           ,
#if defined(ENABLE_OVERLOADING)
    searchBarSearchModeEnabled              ,
#endif
    setSearchBarSearchModeEnabled           ,


-- ** showCloseButton #attr:showCloseButton#
-- | Whether to show the close button in the search bar.

#if defined(ENABLE_OVERLOADING)
    SearchBarShowCloseButtonPropertyInfo    ,
#endif
    constructSearchBarShowCloseButton       ,
    getSearchBarShowCloseButton             ,
#if defined(ENABLE_OVERLOADING)
    searchBarShowCloseButton                ,
#endif
    setSearchBarShowCloseButton             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype SearchBar = SearchBar (SP.ManagedPtr SearchBar)
    deriving (Eq)

instance SP.ManagedPtrNewtype SearchBar where
    toManagedPtr (SearchBar p) = p

foreign import ccall "gtk_search_bar_get_type"
    c_gtk_search_bar_get_type :: IO B.Types.GType

instance B.Types.TypedObject SearchBar where
    glibType = c_gtk_search_bar_get_type

instance B.Types.GObject SearchBar

-- | Type class for types which can be safely cast to t'SearchBar', for instance with `toSearchBar`.
class (SP.GObject o, O.IsDescendantOf SearchBar o) => IsSearchBar o
instance (SP.GObject o, O.IsDescendantOf SearchBar o) => IsSearchBar o

instance O.HasParentTypes SearchBar
type instance O.ParentTypes SearchBar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'SearchBar', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSearchBar :: (MIO.MonadIO m, IsSearchBar o) => o -> m SearchBar
toSearchBar = MIO.liftIO . B.ManagedPtr.unsafeCastTo SearchBar

-- | Convert t'SearchBar' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SearchBar) where
    gvalueGType_ = c_gtk_search_bar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SearchBar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SearchBar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SearchBar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSearchBarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSearchBarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveSearchBarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveSearchBarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveSearchBarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveSearchBarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveSearchBarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveSearchBarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveSearchBarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveSearchBarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveSearchBarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveSearchBarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSearchBarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSearchBarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveSearchBarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveSearchBarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveSearchBarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveSearchBarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveSearchBarMethod "connectEntry" o = SearchBarConnectEntryMethodInfo
    ResolveSearchBarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveSearchBarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveSearchBarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveSearchBarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveSearchBarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveSearchBarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveSearchBarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSearchBarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSearchBarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSearchBarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveSearchBarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveSearchBarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveSearchBarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveSearchBarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveSearchBarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveSearchBarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveSearchBarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveSearchBarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveSearchBarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveSearchBarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveSearchBarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveSearchBarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveSearchBarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSearchBarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveSearchBarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveSearchBarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveSearchBarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveSearchBarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveSearchBarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveSearchBarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveSearchBarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveSearchBarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSearchBarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSearchBarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveSearchBarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveSearchBarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveSearchBarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveSearchBarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveSearchBarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveSearchBarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveSearchBarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSearchBarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSearchBarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveSearchBarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveSearchBarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveSearchBarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveSearchBarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveSearchBarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveSearchBarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveSearchBarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSearchBarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveSearchBarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveSearchBarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveSearchBarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveSearchBarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSearchBarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSearchBarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSearchBarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveSearchBarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveSearchBarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveSearchBarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveSearchBarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveSearchBarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSearchBarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveSearchBarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveSearchBarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveSearchBarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveSearchBarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveSearchBarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveSearchBarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSearchBarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveSearchBarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveSearchBarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveSearchBarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveSearchBarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveSearchBarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveSearchBarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveSearchBarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveSearchBarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveSearchBarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveSearchBarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveSearchBarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveSearchBarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveSearchBarMethod "getChild" o = SearchBarGetChildMethodInfo
    ResolveSearchBarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveSearchBarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveSearchBarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveSearchBarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveSearchBarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveSearchBarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveSearchBarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSearchBarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveSearchBarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveSearchBarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveSearchBarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveSearchBarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveSearchBarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveSearchBarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveSearchBarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveSearchBarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveSearchBarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveSearchBarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveSearchBarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveSearchBarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveSearchBarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveSearchBarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveSearchBarMethod "getKeyCaptureWidget" o = SearchBarGetKeyCaptureWidgetMethodInfo
    ResolveSearchBarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveSearchBarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveSearchBarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveSearchBarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveSearchBarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveSearchBarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveSearchBarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveSearchBarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveSearchBarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveSearchBarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveSearchBarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveSearchBarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveSearchBarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveSearchBarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveSearchBarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveSearchBarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveSearchBarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveSearchBarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveSearchBarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveSearchBarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveSearchBarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSearchBarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSearchBarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveSearchBarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveSearchBarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveSearchBarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveSearchBarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveSearchBarMethod "getSearchMode" o = SearchBarGetSearchModeMethodInfo
    ResolveSearchBarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveSearchBarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveSearchBarMethod "getShowCloseButton" o = SearchBarGetShowCloseButtonMethodInfo
    ResolveSearchBarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveSearchBarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveSearchBarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveSearchBarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveSearchBarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveSearchBarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveSearchBarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveSearchBarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveSearchBarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveSearchBarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveSearchBarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveSearchBarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveSearchBarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveSearchBarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveSearchBarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveSearchBarMethod "setChild" o = SearchBarSetChildMethodInfo
    ResolveSearchBarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveSearchBarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveSearchBarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveSearchBarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveSearchBarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSearchBarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSearchBarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveSearchBarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveSearchBarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveSearchBarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveSearchBarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveSearchBarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveSearchBarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveSearchBarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveSearchBarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveSearchBarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveSearchBarMethod "setKeyCaptureWidget" o = SearchBarSetKeyCaptureWidgetMethodInfo
    ResolveSearchBarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveSearchBarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveSearchBarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveSearchBarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveSearchBarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveSearchBarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveSearchBarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveSearchBarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveSearchBarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveSearchBarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveSearchBarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSearchBarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveSearchBarMethod "setSearchMode" o = SearchBarSetSearchModeMethodInfo
    ResolveSearchBarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveSearchBarMethod "setShowCloseButton" o = SearchBarSetShowCloseButtonMethodInfo
    ResolveSearchBarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveSearchBarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveSearchBarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveSearchBarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveSearchBarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveSearchBarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveSearchBarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveSearchBarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveSearchBarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSearchBarMethod t SearchBar, O.OverloadedMethod info SearchBar p) => OL.IsLabel t (SearchBar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSearchBarMethod t SearchBar, O.OverloadedMethod info SearchBar p, R.HasField t SearchBar p) => R.HasField t SearchBar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSearchBarMethod t SearchBar, O.OverloadedMethodInfo info SearchBar) => OL.IsLabel t (O.MethodProxy info SearchBar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchBar #child
-- @
getSearchBarChild :: (MonadIO m, IsSearchBar o) => o -> m (Maybe Gtk.Widget.Widget)
getSearchBarChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchBar [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchBarChild :: (MonadIO m, IsSearchBar o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setSearchBarChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchBarChild :: (IsSearchBar o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructSearchBarChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearSearchBarChild :: (MonadIO m, IsSearchBar o) => o -> m ()
clearSearchBarChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data SearchBarChildPropertyInfo
instance AttrInfo SearchBarChildPropertyInfo where
    type AttrAllowedOps SearchBarChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SearchBarChildPropertyInfo = IsSearchBar
    type AttrSetTypeConstraint SearchBarChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint SearchBarChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType SearchBarChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType SearchBarChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel SearchBarChildPropertyInfo = "child"
    type AttrOrigin SearchBarChildPropertyInfo = SearchBar
    attrGet = getSearchBarChild
    attrSet = setSearchBarChild
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructSearchBarChild
    attrClear = clearSearchBarChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#g:attr:child"
        })
#endif

-- VVV Prop "key-capture-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@key-capture-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchBar #keyCaptureWidget
-- @
getSearchBarKeyCaptureWidget :: (MonadIO m, IsSearchBar o) => o -> m (Maybe Gtk.Widget.Widget)
getSearchBarKeyCaptureWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "key-capture-widget" Gtk.Widget.Widget

-- | Set the value of the “@key-capture-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchBar [ #keyCaptureWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchBarKeyCaptureWidget :: (MonadIO m, IsSearchBar o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setSearchBarKeyCaptureWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "key-capture-widget" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@key-capture-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchBarKeyCaptureWidget :: (IsSearchBar o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructSearchBarKeyCaptureWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "key-capture-widget" (P.Just val)

-- | Set the value of the “@key-capture-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #keyCaptureWidget
-- @
clearSearchBarKeyCaptureWidget :: (MonadIO m, IsSearchBar o) => o -> m ()
clearSearchBarKeyCaptureWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "key-capture-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data SearchBarKeyCaptureWidgetPropertyInfo
instance AttrInfo SearchBarKeyCaptureWidgetPropertyInfo where
    type AttrAllowedOps SearchBarKeyCaptureWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SearchBarKeyCaptureWidgetPropertyInfo = IsSearchBar
    type AttrSetTypeConstraint SearchBarKeyCaptureWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint SearchBarKeyCaptureWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType SearchBarKeyCaptureWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType SearchBarKeyCaptureWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel SearchBarKeyCaptureWidgetPropertyInfo = "key-capture-widget"
    type AttrOrigin SearchBarKeyCaptureWidgetPropertyInfo = SearchBar
    attrGet = getSearchBarKeyCaptureWidget
    attrSet = setSearchBarKeyCaptureWidget
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructSearchBarKeyCaptureWidget
    attrClear = clearSearchBarKeyCaptureWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.keyCaptureWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#g:attr:keyCaptureWidget"
        })
#endif

-- VVV Prop "search-mode-enabled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@search-mode-enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchBar #searchModeEnabled
-- @
getSearchBarSearchModeEnabled :: (MonadIO m, IsSearchBar o) => o -> m Bool
getSearchBarSearchModeEnabled obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "search-mode-enabled"

-- | Set the value of the “@search-mode-enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchBar [ #searchModeEnabled 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchBarSearchModeEnabled :: (MonadIO m, IsSearchBar o) => o -> Bool -> m ()
setSearchBarSearchModeEnabled obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "search-mode-enabled" val

-- | Construct a t'GValueConstruct' with valid value for the “@search-mode-enabled@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchBarSearchModeEnabled :: (IsSearchBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSearchBarSearchModeEnabled val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "search-mode-enabled" val

#if defined(ENABLE_OVERLOADING)
data SearchBarSearchModeEnabledPropertyInfo
instance AttrInfo SearchBarSearchModeEnabledPropertyInfo where
    type AttrAllowedOps SearchBarSearchModeEnabledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint SearchBarSearchModeEnabledPropertyInfo = IsSearchBar
    type AttrSetTypeConstraint SearchBarSearchModeEnabledPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SearchBarSearchModeEnabledPropertyInfo = (~) Bool
    type AttrTransferType SearchBarSearchModeEnabledPropertyInfo = Bool
    type AttrGetType SearchBarSearchModeEnabledPropertyInfo = Bool
    type AttrLabel SearchBarSearchModeEnabledPropertyInfo = "search-mode-enabled"
    type AttrOrigin SearchBarSearchModeEnabledPropertyInfo = SearchBar
    attrGet = getSearchBarSearchModeEnabled
    attrSet = setSearchBarSearchModeEnabled
    attrPut = setSearchBarSearchModeEnabled
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchBarSearchModeEnabled
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchModeEnabled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#g:attr:searchModeEnabled"
        })
#endif

-- VVV Prop "show-close-button"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-close-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchBar #showCloseButton
-- @
getSearchBarShowCloseButton :: (MonadIO m, IsSearchBar o) => o -> m Bool
getSearchBarShowCloseButton obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-close-button"

-- | Set the value of the “@show-close-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchBar [ #showCloseButton 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchBarShowCloseButton :: (MonadIO m, IsSearchBar o) => o -> Bool -> m ()
setSearchBarShowCloseButton obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-close-button" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-close-button@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchBarShowCloseButton :: (IsSearchBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSearchBarShowCloseButton val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-close-button" val

#if defined(ENABLE_OVERLOADING)
data SearchBarShowCloseButtonPropertyInfo
instance AttrInfo SearchBarShowCloseButtonPropertyInfo where
    type AttrAllowedOps SearchBarShowCloseButtonPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint SearchBarShowCloseButtonPropertyInfo = IsSearchBar
    type AttrSetTypeConstraint SearchBarShowCloseButtonPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SearchBarShowCloseButtonPropertyInfo = (~) Bool
    type AttrTransferType SearchBarShowCloseButtonPropertyInfo = Bool
    type AttrGetType SearchBarShowCloseButtonPropertyInfo = Bool
    type AttrLabel SearchBarShowCloseButtonPropertyInfo = "show-close-button"
    type AttrOrigin SearchBarShowCloseButtonPropertyInfo = SearchBar
    attrGet = getSearchBarShowCloseButton
    attrSet = setSearchBarShowCloseButton
    attrPut = setSearchBarShowCloseButton
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchBarShowCloseButton
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.showCloseButton"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#g:attr:showCloseButton"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SearchBar
type instance O.AttributeList SearchBar = SearchBarAttributeList
type SearchBarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", SearchBarChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("keyCaptureWidget", SearchBarKeyCaptureWidgetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("searchModeEnabled", SearchBarSearchModeEnabledPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showCloseButton", SearchBarShowCloseButtonPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
searchBarChild :: AttrLabelProxy "child"
searchBarChild = AttrLabelProxy

searchBarKeyCaptureWidget :: AttrLabelProxy "keyCaptureWidget"
searchBarKeyCaptureWidget = AttrLabelProxy

searchBarSearchModeEnabled :: AttrLabelProxy "searchModeEnabled"
searchBarSearchModeEnabled = AttrLabelProxy

searchBarShowCloseButton :: AttrLabelProxy "showCloseButton"
searchBarShowCloseButton = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SearchBar = SearchBarSignalList
type SearchBarSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SearchBar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SearchBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_new" gtk_search_bar_new :: 
    IO (Ptr SearchBar)

-- | Creates a @GtkSearchBar@.
-- 
-- You will need to tell it about which widget is going to be your text
-- entry using 'GI.Gtk.Objects.SearchBar.searchBarConnectEntry'.
searchBarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SearchBar
    -- ^ __Returns:__ a new @GtkSearchBar@
searchBarNew  = liftIO $ do
    result <- gtk_search_bar_new
    checkUnexpectedReturnNULL "searchBarNew" result
    result' <- (newObject SearchBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SearchBar::connect_entry
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Editable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEditable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_connect_entry" gtk_search_bar_connect_entry :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    Ptr Gtk.Editable.Editable ->            -- entry : TInterface (Name {namespace = "Gtk", name = "Editable"})
    IO ()

-- | Connects the @GtkEditable@ widget passed as the one to be used in
-- this search bar.
-- 
-- The entry should be a descendant of the search bar. Calling this
-- function manually is only required if the entry isn’t the direct
-- child of the search bar (as in our main example).
searchBarConnectEntry ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a, Gtk.Editable.IsEditable b) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> b
    -- ^ /@entry@/: a @GtkEditable@
    -> m ()
searchBarConnectEntry bar entry = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    entry' <- unsafeManagedPtrCastPtr entry
    gtk_search_bar_connect_entry bar' entry'
    touchManagedPtr bar
    touchManagedPtr entry
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchBarConnectEntryMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsSearchBar a, Gtk.Editable.IsEditable b) => O.OverloadedMethod SearchBarConnectEntryMethodInfo a signature where
    overloadedMethod = searchBarConnectEntry

instance O.OverloadedMethodInfo SearchBarConnectEntryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarConnectEntry",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarConnectEntry"
        })


#endif

-- method SearchBar::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_get_child" gtk_search_bar_get_child :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@bar@/.
searchBarGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@bar@/
searchBarGetChild bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_search_bar_get_child bar'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr bar
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SearchBarGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsSearchBar a) => O.OverloadedMethod SearchBarGetChildMethodInfo a signature where
    overloadedMethod = searchBarGetChild

instance O.OverloadedMethodInfo SearchBarGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarGetChild"
        })


#endif

-- method SearchBar::get_key_capture_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_get_key_capture_widget" gtk_search_bar_get_key_capture_widget :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the widget that /@bar@/ is capturing key events from.
searchBarGetKeyCaptureWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The key capture widget.
searchBarGetKeyCaptureWidget bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_search_bar_get_key_capture_widget bar'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr bar
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SearchBarGetKeyCaptureWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsSearchBar a) => O.OverloadedMethod SearchBarGetKeyCaptureWidgetMethodInfo a signature where
    overloadedMethod = searchBarGetKeyCaptureWidget

instance O.OverloadedMethodInfo SearchBarGetKeyCaptureWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarGetKeyCaptureWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarGetKeyCaptureWidget"
        })


#endif

-- method SearchBar::get_search_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_get_search_mode" gtk_search_bar_get_search_mode :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    IO CInt

-- | Returns whether the search mode is on or off.
searchBarGetSearchMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> m Bool
    -- ^ __Returns:__ whether search mode is toggled on
searchBarGetSearchMode bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_search_bar_get_search_mode bar'
    let result' = (/= 0) result
    touchManagedPtr bar
    return result'

#if defined(ENABLE_OVERLOADING)
data SearchBarGetSearchModeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSearchBar a) => O.OverloadedMethod SearchBarGetSearchModeMethodInfo a signature where
    overloadedMethod = searchBarGetSearchMode

instance O.OverloadedMethodInfo SearchBarGetSearchModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarGetSearchMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarGetSearchMode"
        })


#endif

-- method SearchBar::get_show_close_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_get_show_close_button" gtk_search_bar_get_show_close_button :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    IO CInt

-- | Returns whether the close button is shown.
searchBarGetShowCloseButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> m Bool
    -- ^ __Returns:__ whether the close button is shown
searchBarGetShowCloseButton bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_search_bar_get_show_close_button bar'
    let result' = (/= 0) result
    touchManagedPtr bar
    return result'

#if defined(ENABLE_OVERLOADING)
data SearchBarGetShowCloseButtonMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSearchBar a) => O.OverloadedMethod SearchBarGetShowCloseButtonMethodInfo a signature where
    overloadedMethod = searchBarGetShowCloseButton

instance O.OverloadedMethodInfo SearchBarGetShowCloseButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarGetShowCloseButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarGetShowCloseButton"
        })


#endif

-- method SearchBar::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_set_child" gtk_search_bar_set_child :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@bar@/.
searchBarSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
searchBarSetChild bar child = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_search_bar_set_child bar' maybeChild
    touchManagedPtr bar
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchBarSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSearchBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod SearchBarSetChildMethodInfo a signature where
    overloadedMethod = searchBarSetChild

instance O.OverloadedMethodInfo SearchBarSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarSetChild"
        })


#endif

-- method SearchBar::set_key_capture_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_set_key_capture_widget" gtk_search_bar_set_key_capture_widget :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets /@widget@/ as the widget that /@bar@/ will capture key events
-- from.
-- 
-- If key events are handled by the search bar, the bar will
-- be shown, and the entry populated with the entered text.
-- 
-- Note that despite the name of this function, the events
-- are only \'captured\' in the bubble phase, which means that
-- editable child widgets of /@widget@/ will receive text input
-- before it gets captured. If that is not desired, you can
-- capture and forward the events yourself with
-- 'GI.Gtk.Objects.EventControllerKey.eventControllerKeyForward'.
searchBarSetKeyCaptureWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> Maybe (b)
    -- ^ /@widget@/: a @GtkWidget@
    -> m ()
searchBarSetKeyCaptureWidget bar widget = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_search_bar_set_key_capture_widget bar' maybeWidget
    touchManagedPtr bar
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchBarSetKeyCaptureWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSearchBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod SearchBarSetKeyCaptureWidgetMethodInfo a signature where
    overloadedMethod = searchBarSetKeyCaptureWidget

instance O.OverloadedMethodInfo SearchBarSetKeyCaptureWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarSetKeyCaptureWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarSetKeyCaptureWidget"
        })


#endif

-- method SearchBar::set_search_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "search_mode"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new state of the search mode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_set_search_mode" gtk_search_bar_set_search_mode :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    CInt ->                                 -- search_mode : TBasicType TBoolean
    IO ()

-- | Switches the search mode on or off.
searchBarSetSearchMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> Bool
    -- ^ /@searchMode@/: the new state of the search mode
    -> m ()
searchBarSetSearchMode bar searchMode = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    let searchMode' = (P.fromIntegral . P.fromEnum) searchMode
    gtk_search_bar_set_search_mode bar' searchMode'
    touchManagedPtr bar
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchBarSetSearchModeMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSearchBar a) => O.OverloadedMethod SearchBarSetSearchModeMethodInfo a signature where
    overloadedMethod = searchBarSetSearchMode

instance O.OverloadedMethodInfo SearchBarSetSearchModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarSetSearchMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarSetSearchMode"
        })


#endif

-- method SearchBar::set_show_close_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "visible"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the close button will be shown or not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_bar_set_show_close_button" gtk_search_bar_set_show_close_button :: 
    Ptr SearchBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "SearchBar"})
    CInt ->                                 -- visible : TBasicType TBoolean
    IO ()

-- | Shows or hides the close button.
-- 
-- Applications that already have a “search” toggle button should not
-- show a close button in their search bar, as it duplicates the role
-- of the toggle button.
searchBarSetShowCloseButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchBar a) =>
    a
    -- ^ /@bar@/: a @GtkSearchBar@
    -> Bool
    -- ^ /@visible@/: whether the close button will be shown or not
    -> m ()
searchBarSetShowCloseButton bar visible = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    let visible' = (P.fromIntegral . P.fromEnum) visible
    gtk_search_bar_set_show_close_button bar' visible'
    touchManagedPtr bar
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchBarSetShowCloseButtonMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSearchBar a) => O.OverloadedMethod SearchBarSetShowCloseButtonMethodInfo a signature where
    overloadedMethod = searchBarSetShowCloseButton

instance O.OverloadedMethodInfo SearchBarSetShowCloseButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchBar.searchBarSetShowCloseButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchBar.html#v:searchBarSetShowCloseButton"
        })


#endif


