{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents a file descriptor, which events to poll for, and which events
-- occurred.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.PollFD
    ( 

-- * Exported types
    PollFD(..)                              ,
    newZeroPollFD                           ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolvePollFDMethod                     ,
#endif



 -- * Properties


-- ** events #attr:events#
-- | a bitwise combination from t'GI.GLib.Flags.IOCondition', specifying which
--     events should be polled for. Typically for reading from a file
--     descriptor you would use 'GI.GLib.Flags.IOConditionIn' | 'GI.GLib.Flags.IOConditionHup' | 'GI.GLib.Flags.IOConditionErr', and
--     for writing you would use 'GI.GLib.Flags.IOConditionOut' | 'GI.GLib.Flags.IOConditionErr'.

    getPollFDEvents                         ,
#if defined(ENABLE_OVERLOADING)
    pollFD_events                           ,
#endif
    setPollFDEvents                         ,


-- ** fd #attr:fd#
-- | the file descriptor to poll (or a HANDLE on Win32)

    getPollFDFd                             ,
#if defined(ENABLE_OVERLOADING)
    pollFD_fd                               ,
#endif
    setPollFDFd                             ,


-- ** revents #attr:revents#
-- | a bitwise combination of flags from t'GI.GLib.Flags.IOCondition', returned
--     from the @/poll()/@ function to indicate which events occurred.

    getPollFDRevents                        ,
#if defined(ENABLE_OVERLOADING)
    pollFD_revents                          ,
#endif
    setPollFDRevents                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype PollFD = PollFD (SP.ManagedPtr PollFD)
    deriving (Eq)

instance SP.ManagedPtrNewtype PollFD where
    toManagedPtr (PollFD p) = p

foreign import ccall "g_pollfd_get_type" c_g_pollfd_get_type :: 
    IO GType

type instance O.ParentTypes PollFD = '[]
instance O.HasParentTypes PollFD

instance B.Types.TypedObject PollFD where
    glibType = c_g_pollfd_get_type

instance B.Types.GBoxed PollFD

-- | Convert t'PollFD' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PollFD) where
    gvalueGType_ = c_g_pollfd_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr PollFD)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr PollFD)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed PollFD ptr
        else return P.Nothing
        
    

-- | Construct a t'PollFD' struct initialized to zero.
newZeroPollFD :: MonadIO m => m PollFD
newZeroPollFD = liftIO $ callocBoxedBytes 8 >>= wrapBoxed PollFD

instance tag ~ 'AttrSet => Constructible PollFD tag where
    new _ attrs = do
        o <- newZeroPollFD
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@fd@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pollFD #fd
-- @
getPollFDFd :: MonadIO m => PollFD -> m Int32
getPollFDFd s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@fd@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pollFD [ #fd 'Data.GI.Base.Attributes.:=' value ]
-- @
setPollFDFd :: MonadIO m => PollFD -> Int32 -> m ()
setPollFDFd s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data PollFDFdFieldInfo
instance AttrInfo PollFDFdFieldInfo where
    type AttrBaseTypeConstraint PollFDFdFieldInfo = (~) PollFD
    type AttrAllowedOps PollFDFdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PollFDFdFieldInfo = (~) Int32
    type AttrTransferTypeConstraint PollFDFdFieldInfo = (~)Int32
    type AttrTransferType PollFDFdFieldInfo = Int32
    type AttrGetType PollFDFdFieldInfo = Int32
    type AttrLabel PollFDFdFieldInfo = "fd"
    type AttrOrigin PollFDFdFieldInfo = PollFD
    attrGet = getPollFDFd
    attrSet = setPollFDFd
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.PollFD.fd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-PollFD.html#g:attr:fd"
        })

pollFD_fd :: AttrLabelProxy "fd"
pollFD_fd = AttrLabelProxy

#endif


-- | Get the value of the “@events@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pollFD #events
-- @
getPollFDEvents :: MonadIO m => PollFD -> m FCT.CUShort
getPollFDEvents s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO FCT.CUShort
    return val

-- | Set the value of the “@events@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pollFD [ #events 'Data.GI.Base.Attributes.:=' value ]
-- @
setPollFDEvents :: MonadIO m => PollFD -> FCT.CUShort -> m ()
setPollFDEvents s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: FCT.CUShort)

#if defined(ENABLE_OVERLOADING)
data PollFDEventsFieldInfo
instance AttrInfo PollFDEventsFieldInfo where
    type AttrBaseTypeConstraint PollFDEventsFieldInfo = (~) PollFD
    type AttrAllowedOps PollFDEventsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PollFDEventsFieldInfo = (~) FCT.CUShort
    type AttrTransferTypeConstraint PollFDEventsFieldInfo = (~)FCT.CUShort
    type AttrTransferType PollFDEventsFieldInfo = FCT.CUShort
    type AttrGetType PollFDEventsFieldInfo = FCT.CUShort
    type AttrLabel PollFDEventsFieldInfo = "events"
    type AttrOrigin PollFDEventsFieldInfo = PollFD
    attrGet = getPollFDEvents
    attrSet = setPollFDEvents
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.PollFD.events"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-PollFD.html#g:attr:events"
        })

pollFD_events :: AttrLabelProxy "events"
pollFD_events = AttrLabelProxy

#endif


-- | Get the value of the “@revents@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pollFD #revents
-- @
getPollFDRevents :: MonadIO m => PollFD -> m FCT.CUShort
getPollFDRevents s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 6) :: IO FCT.CUShort
    return val

-- | Set the value of the “@revents@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pollFD [ #revents 'Data.GI.Base.Attributes.:=' value ]
-- @
setPollFDRevents :: MonadIO m => PollFD -> FCT.CUShort -> m ()
setPollFDRevents s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 6) (val :: FCT.CUShort)

#if defined(ENABLE_OVERLOADING)
data PollFDReventsFieldInfo
instance AttrInfo PollFDReventsFieldInfo where
    type AttrBaseTypeConstraint PollFDReventsFieldInfo = (~) PollFD
    type AttrAllowedOps PollFDReventsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PollFDReventsFieldInfo = (~) FCT.CUShort
    type AttrTransferTypeConstraint PollFDReventsFieldInfo = (~)FCT.CUShort
    type AttrTransferType PollFDReventsFieldInfo = FCT.CUShort
    type AttrGetType PollFDReventsFieldInfo = FCT.CUShort
    type AttrLabel PollFDReventsFieldInfo = "revents"
    type AttrOrigin PollFDReventsFieldInfo = PollFD
    attrGet = getPollFDRevents
    attrSet = setPollFDRevents
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.PollFD.revents"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-PollFD.html#g:attr:revents"
        })

pollFD_revents :: AttrLabelProxy "revents"
pollFD_revents = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PollFD
type instance O.AttributeList PollFD = PollFDAttributeList
type PollFDAttributeList = ('[ '("fd", PollFDFdFieldInfo), '("events", PollFDEventsFieldInfo), '("revents", PollFDReventsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePollFDMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePollFDMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePollFDMethod t PollFD, O.OverloadedMethod info PollFD p) => OL.IsLabel t (PollFD -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePollFDMethod t PollFD, O.OverloadedMethod info PollFD p, R.HasField t PollFD p) => R.HasField t PollFD p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePollFDMethod t PollFD, O.OverloadedMethodInfo info PollFD) => OL.IsLabel t (O.MethodProxy info PollFD) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


