{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Window
    ( 

-- * Exported types
    Window(..)                              ,
    IsWindow                                ,
    toWindow                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Window#g:method:beep"), [beginDrawFrame]("GI.Gdk.Objects.Window#g:method:beginDrawFrame"), [beginMoveDrag]("GI.Gdk.Objects.Window#g:method:beginMoveDrag"), [beginMoveDragForDevice]("GI.Gdk.Objects.Window#g:method:beginMoveDragForDevice"), [beginPaintRect]("GI.Gdk.Objects.Window#g:method:beginPaintRect"), [beginPaintRegion]("GI.Gdk.Objects.Window#g:method:beginPaintRegion"), [beginResizeDrag]("GI.Gdk.Objects.Window#g:method:beginResizeDrag"), [beginResizeDragForDevice]("GI.Gdk.Objects.Window#g:method:beginResizeDragForDevice"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [configureFinished]("GI.Gdk.Objects.Window#g:method:configureFinished"), [coordsFromParent]("GI.Gdk.Objects.Window#g:method:coordsFromParent"), [coordsToParent]("GI.Gdk.Objects.Window#g:method:coordsToParent"), [createGlContext]("GI.Gdk.Objects.Window#g:method:createGlContext"), [createSimilarImageSurface]("GI.Gdk.Objects.Window#g:method:createSimilarImageSurface"), [createSimilarSurface]("GI.Gdk.Objects.Window#g:method:createSimilarSurface"), [deiconify]("GI.Gdk.Objects.Window#g:method:deiconify"), [destroy]("GI.Gdk.Objects.Window#g:method:destroy"), [destroyNotify]("GI.Gdk.Objects.Window#g:method:destroyNotify"), [enableSynchronizedConfigure]("GI.Gdk.Objects.Window#g:method:enableSynchronizedConfigure"), [endDrawFrame]("GI.Gdk.Objects.Window#g:method:endDrawFrame"), [endPaint]("GI.Gdk.Objects.Window#g:method:endPaint"), [ensureNative]("GI.Gdk.Objects.Window#g:method:ensureNative"), [flush]("GI.Gdk.Objects.Window#g:method:flush"), [focus]("GI.Gdk.Objects.Window#g:method:focus"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [freezeToplevelUpdatesLibgtkOnly]("GI.Gdk.Objects.Window#g:method:freezeToplevelUpdatesLibgtkOnly"), [freezeUpdates]("GI.Gdk.Objects.Window#g:method:freezeUpdates"), [fullscreen]("GI.Gdk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gdk.Objects.Window#g:method:fullscreenOnMonitor"), [geometryChanged]("GI.Gdk.Objects.Window#g:method:geometryChanged"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasNative]("GI.Gdk.Objects.Window#g:method:hasNative"), [hide]("GI.Gdk.Objects.Window#g:method:hide"), [iconify]("GI.Gdk.Objects.Window#g:method:iconify"), [inputShapeCombineRegion]("GI.Gdk.Objects.Window#g:method:inputShapeCombineRegion"), [invalidateMaybeRecurse]("GI.Gdk.Objects.Window#g:method:invalidateMaybeRecurse"), [invalidateRect]("GI.Gdk.Objects.Window#g:method:invalidateRect"), [invalidateRegion]("GI.Gdk.Objects.Window#g:method:invalidateRegion"), [isDestroyed]("GI.Gdk.Objects.Window#g:method:isDestroyed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isInputOnly]("GI.Gdk.Objects.Window#g:method:isInputOnly"), [isShaped]("GI.Gdk.Objects.Window#g:method:isShaped"), [isViewable]("GI.Gdk.Objects.Window#g:method:isViewable"), [isVisible]("GI.Gdk.Objects.Window#g:method:isVisible"), [lower]("GI.Gdk.Objects.Window#g:method:lower"), [markPaintFromClip]("GI.Gdk.Objects.Window#g:method:markPaintFromClip"), [maximize]("GI.Gdk.Objects.Window#g:method:maximize"), [mergeChildInputShapes]("GI.Gdk.Objects.Window#g:method:mergeChildInputShapes"), [mergeChildShapes]("GI.Gdk.Objects.Window#g:method:mergeChildShapes"), [move]("GI.Gdk.Objects.Window#g:method:move"), [moveRegion]("GI.Gdk.Objects.Window#g:method:moveRegion"), [moveResize]("GI.Gdk.Objects.Window#g:method:moveResize"), [moveToRect]("GI.Gdk.Objects.Window#g:method:moveToRect"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [peekChildren]("GI.Gdk.Objects.Window#g:method:peekChildren"), [processUpdates]("GI.Gdk.Objects.Window#g:method:processUpdates"), [raise]("GI.Gdk.Objects.Window#g:method:raise"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [registerDnd]("GI.Gdk.Objects.Window#g:method:registerDnd"), [reparent]("GI.Gdk.Objects.Window#g:method:reparent"), [resize]("GI.Gdk.Objects.Window#g:method:resize"), [restack]("GI.Gdk.Objects.Window#g:method:restack"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scroll]("GI.Gdk.Objects.Window#g:method:scroll"), [shapeCombineRegion]("GI.Gdk.Objects.Window#g:method:shapeCombineRegion"), [show]("GI.Gdk.Objects.Window#g:method:show"), [showUnraised]("GI.Gdk.Objects.Window#g:method:showUnraised"), [showWindowMenu]("GI.Gdk.Objects.Window#g:method:showWindowMenu"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stick]("GI.Gdk.Objects.Window#g:method:stick"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [thawToplevelUpdatesLibgtkOnly]("GI.Gdk.Objects.Window#g:method:thawToplevelUpdatesLibgtkOnly"), [thawUpdates]("GI.Gdk.Objects.Window#g:method:thawUpdates"), [unfullscreen]("GI.Gdk.Objects.Window#g:method:unfullscreen"), [unmaximize]("GI.Gdk.Objects.Window#g:method:unmaximize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unstick]("GI.Gdk.Objects.Window#g:method:unstick"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [withdraw]("GI.Gdk.Objects.Window#g:method:withdraw").
-- 
-- ==== Getters
-- [getAcceptFocus]("GI.Gdk.Objects.Window#g:method:getAcceptFocus"), [getBackgroundPattern]("GI.Gdk.Objects.Window#g:method:getBackgroundPattern"), [getChildren]("GI.Gdk.Objects.Window#g:method:getChildren"), [getChildrenWithUserData]("GI.Gdk.Objects.Window#g:method:getChildrenWithUserData"), [getClipRegion]("GI.Gdk.Objects.Window#g:method:getClipRegion"), [getComposited]("GI.Gdk.Objects.Window#g:method:getComposited"), [getCursor]("GI.Gdk.Objects.Window#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorations]("GI.Gdk.Objects.Window#g:method:getDecorations"), [getDeviceCursor]("GI.Gdk.Objects.Window#g:method:getDeviceCursor"), [getDeviceEvents]("GI.Gdk.Objects.Window#g:method:getDeviceEvents"), [getDevicePosition]("GI.Gdk.Objects.Window#g:method:getDevicePosition"), [getDevicePositionDouble]("GI.Gdk.Objects.Window#g:method:getDevicePositionDouble"), [getDisplay]("GI.Gdk.Objects.Window#g:method:getDisplay"), [getDragProtocol]("GI.Gdk.Objects.Window#g:method:getDragProtocol"), [getEffectiveParent]("GI.Gdk.Objects.Window#g:method:getEffectiveParent"), [getEffectiveToplevel]("GI.Gdk.Objects.Window#g:method:getEffectiveToplevel"), [getEventCompression]("GI.Gdk.Objects.Window#g:method:getEventCompression"), [getEvents]("GI.Gdk.Objects.Window#g:method:getEvents"), [getFocusOnMap]("GI.Gdk.Objects.Window#g:method:getFocusOnMap"), [getFrameClock]("GI.Gdk.Objects.Window#g:method:getFrameClock"), [getFrameExtents]("GI.Gdk.Objects.Window#g:method:getFrameExtents"), [getFullscreenMode]("GI.Gdk.Objects.Window#g:method:getFullscreenMode"), [getGeometry]("GI.Gdk.Objects.Window#g:method:getGeometry"), [getGroup]("GI.Gdk.Objects.Window#g:method:getGroup"), [getHeight]("GI.Gdk.Objects.Window#g:method:getHeight"), [getModalHint]("GI.Gdk.Objects.Window#g:method:getModalHint"), [getOrigin]("GI.Gdk.Objects.Window#g:method:getOrigin"), [getParent]("GI.Gdk.Objects.Window#g:method:getParent"), [getPassThrough]("GI.Gdk.Objects.Window#g:method:getPassThrough"), [getPointer]("GI.Gdk.Objects.Window#g:method:getPointer"), [getPosition]("GI.Gdk.Objects.Window#g:method:getPosition"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRootCoords]("GI.Gdk.Objects.Window#g:method:getRootCoords"), [getRootOrigin]("GI.Gdk.Objects.Window#g:method:getRootOrigin"), [getScaleFactor]("GI.Gdk.Objects.Window#g:method:getScaleFactor"), [getScreen]("GI.Gdk.Objects.Window#g:method:getScreen"), [getSourceEvents]("GI.Gdk.Objects.Window#g:method:getSourceEvents"), [getState]("GI.Gdk.Objects.Window#g:method:getState"), [getSupportMultidevice]("GI.Gdk.Objects.Window#g:method:getSupportMultidevice"), [getToplevel]("GI.Gdk.Objects.Window#g:method:getToplevel"), [getTypeHint]("GI.Gdk.Objects.Window#g:method:getTypeHint"), [getUpdateArea]("GI.Gdk.Objects.Window#g:method:getUpdateArea"), [getUserData]("GI.Gdk.Objects.Window#g:method:getUserData"), [getVisibleRegion]("GI.Gdk.Objects.Window#g:method:getVisibleRegion"), [getVisual]("GI.Gdk.Objects.Window#g:method:getVisual"), [getWidth]("GI.Gdk.Objects.Window#g:method:getWidth"), [getWindowType]("GI.Gdk.Objects.Window#g:method:getWindowType").
-- 
-- ==== Setters
-- [setAcceptFocus]("GI.Gdk.Objects.Window#g:method:setAcceptFocus"), [setBackground]("GI.Gdk.Objects.Window#g:method:setBackground"), [setBackgroundPattern]("GI.Gdk.Objects.Window#g:method:setBackgroundPattern"), [setBackgroundRgba]("GI.Gdk.Objects.Window#g:method:setBackgroundRgba"), [setChildInputShapes]("GI.Gdk.Objects.Window#g:method:setChildInputShapes"), [setChildShapes]("GI.Gdk.Objects.Window#g:method:setChildShapes"), [setComposited]("GI.Gdk.Objects.Window#g:method:setComposited"), [setCursor]("GI.Gdk.Objects.Window#g:method:setCursor"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorations]("GI.Gdk.Objects.Window#g:method:setDecorations"), [setDeviceCursor]("GI.Gdk.Objects.Window#g:method:setDeviceCursor"), [setDeviceEvents]("GI.Gdk.Objects.Window#g:method:setDeviceEvents"), [setEventCompression]("GI.Gdk.Objects.Window#g:method:setEventCompression"), [setEvents]("GI.Gdk.Objects.Window#g:method:setEvents"), [setFocusOnMap]("GI.Gdk.Objects.Window#g:method:setFocusOnMap"), [setFullscreenMode]("GI.Gdk.Objects.Window#g:method:setFullscreenMode"), [setFunctions]("GI.Gdk.Objects.Window#g:method:setFunctions"), [setGeometryHints]("GI.Gdk.Objects.Window#g:method:setGeometryHints"), [setGroup]("GI.Gdk.Objects.Window#g:method:setGroup"), [setIconList]("GI.Gdk.Objects.Window#g:method:setIconList"), [setIconName]("GI.Gdk.Objects.Window#g:method:setIconName"), [setKeepAbove]("GI.Gdk.Objects.Window#g:method:setKeepAbove"), [setKeepBelow]("GI.Gdk.Objects.Window#g:method:setKeepBelow"), [setModalHint]("GI.Gdk.Objects.Window#g:method:setModalHint"), [setOpacity]("GI.Gdk.Objects.Window#g:method:setOpacity"), [setOpaqueRegion]("GI.Gdk.Objects.Window#g:method:setOpaqueRegion"), [setOverrideRedirect]("GI.Gdk.Objects.Window#g:method:setOverrideRedirect"), [setPassThrough]("GI.Gdk.Objects.Window#g:method:setPassThrough"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Gdk.Objects.Window#g:method:setRole"), [setShadowWidth]("GI.Gdk.Objects.Window#g:method:setShadowWidth"), [setSkipPagerHint]("GI.Gdk.Objects.Window#g:method:setSkipPagerHint"), [setSkipTaskbarHint]("GI.Gdk.Objects.Window#g:method:setSkipTaskbarHint"), [setSourceEvents]("GI.Gdk.Objects.Window#g:method:setSourceEvents"), [setStartupId]("GI.Gdk.Objects.Window#g:method:setStartupId"), [setStaticGravities]("GI.Gdk.Objects.Window#g:method:setStaticGravities"), [setSupportMultidevice]("GI.Gdk.Objects.Window#g:method:setSupportMultidevice"), [setTitle]("GI.Gdk.Objects.Window#g:method:setTitle"), [setTransientFor]("GI.Gdk.Objects.Window#g:method:setTransientFor"), [setTypeHint]("GI.Gdk.Objects.Window#g:method:setTypeHint"), [setUrgencyHint]("GI.Gdk.Objects.Window#g:method:setUrgencyHint"), [setUserData]("GI.Gdk.Objects.Window#g:method:setUserData").

#if defined(ENABLE_OVERLOADING)
    ResolveWindowMethod                     ,
#endif

-- ** atPointer #method:atPointer#

    windowAtPointer                         ,


-- ** beep #method:beep#

#if defined(ENABLE_OVERLOADING)
    WindowBeepMethodInfo                    ,
#endif
    windowBeep                              ,


-- ** beginDrawFrame #method:beginDrawFrame#

#if defined(ENABLE_OVERLOADING)
    WindowBeginDrawFrameMethodInfo          ,
#endif
    windowBeginDrawFrame                    ,


-- ** beginMoveDrag #method:beginMoveDrag#

#if defined(ENABLE_OVERLOADING)
    WindowBeginMoveDragMethodInfo           ,
#endif
    windowBeginMoveDrag                     ,


-- ** beginMoveDragForDevice #method:beginMoveDragForDevice#

#if defined(ENABLE_OVERLOADING)
    WindowBeginMoveDragForDeviceMethodInfo  ,
#endif
    windowBeginMoveDragForDevice            ,


-- ** beginPaintRect #method:beginPaintRect#

#if defined(ENABLE_OVERLOADING)
    WindowBeginPaintRectMethodInfo          ,
#endif
    windowBeginPaintRect                    ,


-- ** beginPaintRegion #method:beginPaintRegion#

#if defined(ENABLE_OVERLOADING)
    WindowBeginPaintRegionMethodInfo        ,
#endif
    windowBeginPaintRegion                  ,


-- ** beginResizeDrag #method:beginResizeDrag#

#if defined(ENABLE_OVERLOADING)
    WindowBeginResizeDragMethodInfo         ,
#endif
    windowBeginResizeDrag                   ,


-- ** beginResizeDragForDevice #method:beginResizeDragForDevice#

#if defined(ENABLE_OVERLOADING)
    WindowBeginResizeDragForDeviceMethodInfo,
#endif
    windowBeginResizeDragForDevice          ,


-- ** configureFinished #method:configureFinished#

#if defined(ENABLE_OVERLOADING)
    WindowConfigureFinishedMethodInfo       ,
#endif
    windowConfigureFinished                 ,


-- ** constrainSize #method:constrainSize#

    windowConstrainSize                     ,


-- ** coordsFromParent #method:coordsFromParent#

#if defined(ENABLE_OVERLOADING)
    WindowCoordsFromParentMethodInfo        ,
#endif
    windowCoordsFromParent                  ,


-- ** coordsToParent #method:coordsToParent#

#if defined(ENABLE_OVERLOADING)
    WindowCoordsToParentMethodInfo          ,
#endif
    windowCoordsToParent                    ,


-- ** createGlContext #method:createGlContext#

#if defined(ENABLE_OVERLOADING)
    WindowCreateGlContextMethodInfo         ,
#endif
    windowCreateGlContext                   ,


-- ** createSimilarImageSurface #method:createSimilarImageSurface#

#if defined(ENABLE_OVERLOADING)
    WindowCreateSimilarImageSurfaceMethodInfo,
#endif
    windowCreateSimilarImageSurface         ,


-- ** createSimilarSurface #method:createSimilarSurface#

#if defined(ENABLE_OVERLOADING)
    WindowCreateSimilarSurfaceMethodInfo    ,
#endif
    windowCreateSimilarSurface              ,


-- ** deiconify #method:deiconify#

#if defined(ENABLE_OVERLOADING)
    WindowDeiconifyMethodInfo               ,
#endif
    windowDeiconify                         ,


-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    WindowDestroyMethodInfo                 ,
#endif
    windowDestroy                           ,


-- ** destroyNotify #method:destroyNotify#

#if defined(ENABLE_OVERLOADING)
    WindowDestroyNotifyMethodInfo           ,
#endif
    windowDestroyNotify                     ,


-- ** enableSynchronizedConfigure #method:enableSynchronizedConfigure#

#if defined(ENABLE_OVERLOADING)
    WindowEnableSynchronizedConfigureMethodInfo,
#endif
    windowEnableSynchronizedConfigure       ,


-- ** endDrawFrame #method:endDrawFrame#

#if defined(ENABLE_OVERLOADING)
    WindowEndDrawFrameMethodInfo            ,
#endif
    windowEndDrawFrame                      ,


-- ** endPaint #method:endPaint#

#if defined(ENABLE_OVERLOADING)
    WindowEndPaintMethodInfo                ,
#endif
    windowEndPaint                          ,


-- ** ensureNative #method:ensureNative#

#if defined(ENABLE_OVERLOADING)
    WindowEnsureNativeMethodInfo            ,
#endif
    windowEnsureNative                      ,


-- ** flush #method:flush#

#if defined(ENABLE_OVERLOADING)
    WindowFlushMethodInfo                   ,
#endif
    windowFlush                             ,


-- ** focus #method:focus#

#if defined(ENABLE_OVERLOADING)
    WindowFocusMethodInfo                   ,
#endif
    windowFocus                             ,


-- ** freezeToplevelUpdatesLibgtkOnly #method:freezeToplevelUpdatesLibgtkOnly#

#if defined(ENABLE_OVERLOADING)
    WindowFreezeToplevelUpdatesLibgtkOnlyMethodInfo,
#endif
    windowFreezeToplevelUpdatesLibgtkOnly   ,


-- ** freezeUpdates #method:freezeUpdates#

#if defined(ENABLE_OVERLOADING)
    WindowFreezeUpdatesMethodInfo           ,
#endif
    windowFreezeUpdates                     ,


-- ** fullscreen #method:fullscreen#

#if defined(ENABLE_OVERLOADING)
    WindowFullscreenMethodInfo              ,
#endif
    windowFullscreen                        ,


-- ** fullscreenOnMonitor #method:fullscreenOnMonitor#

#if defined(ENABLE_OVERLOADING)
    WindowFullscreenOnMonitorMethodInfo     ,
#endif
    windowFullscreenOnMonitor               ,


-- ** geometryChanged #method:geometryChanged#

#if defined(ENABLE_OVERLOADING)
    WindowGeometryChangedMethodInfo         ,
#endif
    windowGeometryChanged                   ,


-- ** getAcceptFocus #method:getAcceptFocus#

#if defined(ENABLE_OVERLOADING)
    WindowGetAcceptFocusMethodInfo          ,
#endif
    windowGetAcceptFocus                    ,


-- ** getBackgroundPattern #method:getBackgroundPattern#

#if defined(ENABLE_OVERLOADING)
    WindowGetBackgroundPatternMethodInfo    ,
#endif
    windowGetBackgroundPattern              ,


-- ** getChildren #method:getChildren#

#if defined(ENABLE_OVERLOADING)
    WindowGetChildrenMethodInfo             ,
#endif
    windowGetChildren                       ,


-- ** getChildrenWithUserData #method:getChildrenWithUserData#

#if defined(ENABLE_OVERLOADING)
    WindowGetChildrenWithUserDataMethodInfo ,
#endif
    windowGetChildrenWithUserData           ,


-- ** getClipRegion #method:getClipRegion#

#if defined(ENABLE_OVERLOADING)
    WindowGetClipRegionMethodInfo           ,
#endif
    windowGetClipRegion                     ,


-- ** getComposited #method:getComposited#

#if defined(ENABLE_OVERLOADING)
    WindowGetCompositedMethodInfo           ,
#endif
    windowGetComposited                     ,


-- ** getCursor #method:getCursor#

#if defined(ENABLE_OVERLOADING)
    WindowGetCursorMethodInfo               ,
#endif
    windowGetCursor                         ,


-- ** getDecorations #method:getDecorations#

#if defined(ENABLE_OVERLOADING)
    WindowGetDecorationsMethodInfo          ,
#endif
    windowGetDecorations                    ,


-- ** getDeviceCursor #method:getDeviceCursor#

#if defined(ENABLE_OVERLOADING)
    WindowGetDeviceCursorMethodInfo         ,
#endif
    windowGetDeviceCursor                   ,


-- ** getDeviceEvents #method:getDeviceEvents#

#if defined(ENABLE_OVERLOADING)
    WindowGetDeviceEventsMethodInfo         ,
#endif
    windowGetDeviceEvents                   ,


-- ** getDevicePosition #method:getDevicePosition#

#if defined(ENABLE_OVERLOADING)
    WindowGetDevicePositionMethodInfo       ,
#endif
    windowGetDevicePosition                 ,


-- ** getDevicePositionDouble #method:getDevicePositionDouble#

#if defined(ENABLE_OVERLOADING)
    WindowGetDevicePositionDoubleMethodInfo ,
#endif
    windowGetDevicePositionDouble           ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    WindowGetDisplayMethodInfo              ,
#endif
    windowGetDisplay                        ,


-- ** getDragProtocol #method:getDragProtocol#

#if defined(ENABLE_OVERLOADING)
    WindowGetDragProtocolMethodInfo         ,
#endif
    windowGetDragProtocol                   ,


-- ** getEffectiveParent #method:getEffectiveParent#

#if defined(ENABLE_OVERLOADING)
    WindowGetEffectiveParentMethodInfo      ,
#endif
    windowGetEffectiveParent                ,


-- ** getEffectiveToplevel #method:getEffectiveToplevel#

#if defined(ENABLE_OVERLOADING)
    WindowGetEffectiveToplevelMethodInfo    ,
#endif
    windowGetEffectiveToplevel              ,


-- ** getEventCompression #method:getEventCompression#

#if defined(ENABLE_OVERLOADING)
    WindowGetEventCompressionMethodInfo     ,
#endif
    windowGetEventCompression               ,


-- ** getEvents #method:getEvents#

#if defined(ENABLE_OVERLOADING)
    WindowGetEventsMethodInfo               ,
#endif
    windowGetEvents                         ,


-- ** getFocusOnMap #method:getFocusOnMap#

#if defined(ENABLE_OVERLOADING)
    WindowGetFocusOnMapMethodInfo           ,
#endif
    windowGetFocusOnMap                     ,


-- ** getFrameClock #method:getFrameClock#

#if defined(ENABLE_OVERLOADING)
    WindowGetFrameClockMethodInfo           ,
#endif
    windowGetFrameClock                     ,


-- ** getFrameExtents #method:getFrameExtents#

#if defined(ENABLE_OVERLOADING)
    WindowGetFrameExtentsMethodInfo         ,
#endif
    windowGetFrameExtents                   ,


-- ** getFullscreenMode #method:getFullscreenMode#

#if defined(ENABLE_OVERLOADING)
    WindowGetFullscreenModeMethodInfo       ,
#endif
    windowGetFullscreenMode                 ,


-- ** getGeometry #method:getGeometry#

#if defined(ENABLE_OVERLOADING)
    WindowGetGeometryMethodInfo             ,
#endif
    windowGetGeometry                       ,


-- ** getGroup #method:getGroup#

#if defined(ENABLE_OVERLOADING)
    WindowGetGroupMethodInfo                ,
#endif
    windowGetGroup                          ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    WindowGetHeightMethodInfo               ,
#endif
    windowGetHeight                         ,


-- ** getModalHint #method:getModalHint#

#if defined(ENABLE_OVERLOADING)
    WindowGetModalHintMethodInfo            ,
#endif
    windowGetModalHint                      ,


-- ** getOrigin #method:getOrigin#

#if defined(ENABLE_OVERLOADING)
    WindowGetOriginMethodInfo               ,
#endif
    windowGetOrigin                         ,


-- ** getParent #method:getParent#

#if defined(ENABLE_OVERLOADING)
    WindowGetParentMethodInfo               ,
#endif
    windowGetParent                         ,


-- ** getPassThrough #method:getPassThrough#

#if defined(ENABLE_OVERLOADING)
    WindowGetPassThroughMethodInfo          ,
#endif
    windowGetPassThrough                    ,


-- ** getPointer #method:getPointer#

#if defined(ENABLE_OVERLOADING)
    WindowGetPointerMethodInfo              ,
#endif
    windowGetPointer                        ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    WindowGetPositionMethodInfo             ,
#endif
    windowGetPosition                       ,


-- ** getRootCoords #method:getRootCoords#

#if defined(ENABLE_OVERLOADING)
    WindowGetRootCoordsMethodInfo           ,
#endif
    windowGetRootCoords                     ,


-- ** getRootOrigin #method:getRootOrigin#

#if defined(ENABLE_OVERLOADING)
    WindowGetRootOriginMethodInfo           ,
#endif
    windowGetRootOrigin                     ,


-- ** getScaleFactor #method:getScaleFactor#

#if defined(ENABLE_OVERLOADING)
    WindowGetScaleFactorMethodInfo          ,
#endif
    windowGetScaleFactor                    ,


-- ** getScreen #method:getScreen#

#if defined(ENABLE_OVERLOADING)
    WindowGetScreenMethodInfo               ,
#endif
    windowGetScreen                         ,


-- ** getSourceEvents #method:getSourceEvents#

#if defined(ENABLE_OVERLOADING)
    WindowGetSourceEventsMethodInfo         ,
#endif
    windowGetSourceEvents                   ,


-- ** getState #method:getState#

#if defined(ENABLE_OVERLOADING)
    WindowGetStateMethodInfo                ,
#endif
    windowGetState                          ,


-- ** getSupportMultidevice #method:getSupportMultidevice#

#if defined(ENABLE_OVERLOADING)
    WindowGetSupportMultideviceMethodInfo   ,
#endif
    windowGetSupportMultidevice             ,


-- ** getToplevel #method:getToplevel#

#if defined(ENABLE_OVERLOADING)
    WindowGetToplevelMethodInfo             ,
#endif
    windowGetToplevel                       ,


-- ** getTypeHint #method:getTypeHint#

#if defined(ENABLE_OVERLOADING)
    WindowGetTypeHintMethodInfo             ,
#endif
    windowGetTypeHint                       ,


-- ** getUpdateArea #method:getUpdateArea#

#if defined(ENABLE_OVERLOADING)
    WindowGetUpdateAreaMethodInfo           ,
#endif
    windowGetUpdateArea                     ,


-- ** getUserData #method:getUserData#

#if defined(ENABLE_OVERLOADING)
    WindowGetUserDataMethodInfo             ,
#endif
    windowGetUserData                       ,


-- ** getVisibleRegion #method:getVisibleRegion#

#if defined(ENABLE_OVERLOADING)
    WindowGetVisibleRegionMethodInfo        ,
#endif
    windowGetVisibleRegion                  ,


-- ** getVisual #method:getVisual#

#if defined(ENABLE_OVERLOADING)
    WindowGetVisualMethodInfo               ,
#endif
    windowGetVisual                         ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    WindowGetWidthMethodInfo                ,
#endif
    windowGetWidth                          ,


-- ** getWindowType #method:getWindowType#

#if defined(ENABLE_OVERLOADING)
    WindowGetWindowTypeMethodInfo           ,
#endif
    windowGetWindowType                     ,


-- ** hasNative #method:hasNative#

#if defined(ENABLE_OVERLOADING)
    WindowHasNativeMethodInfo               ,
#endif
    windowHasNative                         ,


-- ** hide #method:hide#

#if defined(ENABLE_OVERLOADING)
    WindowHideMethodInfo                    ,
#endif
    windowHide                              ,


-- ** iconify #method:iconify#

#if defined(ENABLE_OVERLOADING)
    WindowIconifyMethodInfo                 ,
#endif
    windowIconify                           ,


-- ** inputShapeCombineRegion #method:inputShapeCombineRegion#

#if defined(ENABLE_OVERLOADING)
    WindowInputShapeCombineRegionMethodInfo ,
#endif
    windowInputShapeCombineRegion           ,


-- ** invalidateMaybeRecurse #method:invalidateMaybeRecurse#

#if defined(ENABLE_OVERLOADING)
    WindowInvalidateMaybeRecurseMethodInfo  ,
#endif
    windowInvalidateMaybeRecurse            ,


-- ** invalidateRect #method:invalidateRect#

#if defined(ENABLE_OVERLOADING)
    WindowInvalidateRectMethodInfo          ,
#endif
    windowInvalidateRect                    ,


-- ** invalidateRegion #method:invalidateRegion#

#if defined(ENABLE_OVERLOADING)
    WindowInvalidateRegionMethodInfo        ,
#endif
    windowInvalidateRegion                  ,


-- ** isDestroyed #method:isDestroyed#

#if defined(ENABLE_OVERLOADING)
    WindowIsDestroyedMethodInfo             ,
#endif
    windowIsDestroyed                       ,


-- ** isInputOnly #method:isInputOnly#

#if defined(ENABLE_OVERLOADING)
    WindowIsInputOnlyMethodInfo             ,
#endif
    windowIsInputOnly                       ,


-- ** isShaped #method:isShaped#

#if defined(ENABLE_OVERLOADING)
    WindowIsShapedMethodInfo                ,
#endif
    windowIsShaped                          ,


-- ** isViewable #method:isViewable#

#if defined(ENABLE_OVERLOADING)
    WindowIsViewableMethodInfo              ,
#endif
    windowIsViewable                        ,


-- ** isVisible #method:isVisible#

#if defined(ENABLE_OVERLOADING)
    WindowIsVisibleMethodInfo               ,
#endif
    windowIsVisible                         ,


-- ** lower #method:lower#

#if defined(ENABLE_OVERLOADING)
    WindowLowerMethodInfo                   ,
#endif
    windowLower                             ,


-- ** markPaintFromClip #method:markPaintFromClip#

#if defined(ENABLE_OVERLOADING)
    WindowMarkPaintFromClipMethodInfo       ,
#endif
    windowMarkPaintFromClip                 ,


-- ** maximize #method:maximize#

#if defined(ENABLE_OVERLOADING)
    WindowMaximizeMethodInfo                ,
#endif
    windowMaximize                          ,


-- ** mergeChildInputShapes #method:mergeChildInputShapes#

#if defined(ENABLE_OVERLOADING)
    WindowMergeChildInputShapesMethodInfo   ,
#endif
    windowMergeChildInputShapes             ,


-- ** mergeChildShapes #method:mergeChildShapes#

#if defined(ENABLE_OVERLOADING)
    WindowMergeChildShapesMethodInfo        ,
#endif
    windowMergeChildShapes                  ,


-- ** move #method:move#

#if defined(ENABLE_OVERLOADING)
    WindowMoveMethodInfo                    ,
#endif
    windowMove                              ,


-- ** moveRegion #method:moveRegion#

#if defined(ENABLE_OVERLOADING)
    WindowMoveRegionMethodInfo              ,
#endif
    windowMoveRegion                        ,


-- ** moveResize #method:moveResize#

#if defined(ENABLE_OVERLOADING)
    WindowMoveResizeMethodInfo              ,
#endif
    windowMoveResize                        ,


-- ** moveToRect #method:moveToRect#

#if defined(ENABLE_OVERLOADING)
    WindowMoveToRectMethodInfo              ,
#endif
    windowMoveToRect                        ,


-- ** new #method:new#

    windowNew                               ,


-- ** peekChildren #method:peekChildren#

#if defined(ENABLE_OVERLOADING)
    WindowPeekChildrenMethodInfo            ,
#endif
    windowPeekChildren                      ,


-- ** processAllUpdates #method:processAllUpdates#

    windowProcessAllUpdates                 ,


-- ** processUpdates #method:processUpdates#

#if defined(ENABLE_OVERLOADING)
    WindowProcessUpdatesMethodInfo          ,
#endif
    windowProcessUpdates                    ,


-- ** raise #method:raise#

#if defined(ENABLE_OVERLOADING)
    WindowRaiseMethodInfo                   ,
#endif
    windowRaise                             ,


-- ** registerDnd #method:registerDnd#

#if defined(ENABLE_OVERLOADING)
    WindowRegisterDndMethodInfo             ,
#endif
    windowRegisterDnd                       ,


-- ** reparent #method:reparent#

#if defined(ENABLE_OVERLOADING)
    WindowReparentMethodInfo                ,
#endif
    windowReparent                          ,


-- ** resize #method:resize#

#if defined(ENABLE_OVERLOADING)
    WindowResizeMethodInfo                  ,
#endif
    windowResize                            ,


-- ** restack #method:restack#

#if defined(ENABLE_OVERLOADING)
    WindowRestackMethodInfo                 ,
#endif
    windowRestack                           ,


-- ** scroll #method:scroll#

#if defined(ENABLE_OVERLOADING)
    WindowScrollMethodInfo                  ,
#endif
    windowScroll                            ,


-- ** setAcceptFocus #method:setAcceptFocus#

#if defined(ENABLE_OVERLOADING)
    WindowSetAcceptFocusMethodInfo          ,
#endif
    windowSetAcceptFocus                    ,


-- ** setBackground #method:setBackground#

#if defined(ENABLE_OVERLOADING)
    WindowSetBackgroundMethodInfo           ,
#endif
    windowSetBackground                     ,


-- ** setBackgroundPattern #method:setBackgroundPattern#

#if defined(ENABLE_OVERLOADING)
    WindowSetBackgroundPatternMethodInfo    ,
#endif
    windowSetBackgroundPattern              ,


-- ** setBackgroundRgba #method:setBackgroundRgba#

#if defined(ENABLE_OVERLOADING)
    WindowSetBackgroundRgbaMethodInfo       ,
#endif
    windowSetBackgroundRgba                 ,


-- ** setChildInputShapes #method:setChildInputShapes#

#if defined(ENABLE_OVERLOADING)
    WindowSetChildInputShapesMethodInfo     ,
#endif
    windowSetChildInputShapes               ,


-- ** setChildShapes #method:setChildShapes#

#if defined(ENABLE_OVERLOADING)
    WindowSetChildShapesMethodInfo          ,
#endif
    windowSetChildShapes                    ,


-- ** setComposited #method:setComposited#

#if defined(ENABLE_OVERLOADING)
    WindowSetCompositedMethodInfo           ,
#endif
    windowSetComposited                     ,


-- ** setCursor #method:setCursor#

#if defined(ENABLE_OVERLOADING)
    WindowSetCursorMethodInfo               ,
#endif
    windowSetCursor                         ,


-- ** setDebugUpdates #method:setDebugUpdates#

    windowSetDebugUpdates                   ,


-- ** setDecorations #method:setDecorations#

#if defined(ENABLE_OVERLOADING)
    WindowSetDecorationsMethodInfo          ,
#endif
    windowSetDecorations                    ,


-- ** setDeviceCursor #method:setDeviceCursor#

#if defined(ENABLE_OVERLOADING)
    WindowSetDeviceCursorMethodInfo         ,
#endif
    windowSetDeviceCursor                   ,


-- ** setDeviceEvents #method:setDeviceEvents#

#if defined(ENABLE_OVERLOADING)
    WindowSetDeviceEventsMethodInfo         ,
#endif
    windowSetDeviceEvents                   ,


-- ** setEventCompression #method:setEventCompression#

#if defined(ENABLE_OVERLOADING)
    WindowSetEventCompressionMethodInfo     ,
#endif
    windowSetEventCompression               ,


-- ** setEvents #method:setEvents#

#if defined(ENABLE_OVERLOADING)
    WindowSetEventsMethodInfo               ,
#endif
    windowSetEvents                         ,


-- ** setFocusOnMap #method:setFocusOnMap#

#if defined(ENABLE_OVERLOADING)
    WindowSetFocusOnMapMethodInfo           ,
#endif
    windowSetFocusOnMap                     ,


-- ** setFullscreenMode #method:setFullscreenMode#

#if defined(ENABLE_OVERLOADING)
    WindowSetFullscreenModeMethodInfo       ,
#endif
    windowSetFullscreenMode                 ,


-- ** setFunctions #method:setFunctions#

#if defined(ENABLE_OVERLOADING)
    WindowSetFunctionsMethodInfo            ,
#endif
    windowSetFunctions                      ,


-- ** setGeometryHints #method:setGeometryHints#

#if defined(ENABLE_OVERLOADING)
    WindowSetGeometryHintsMethodInfo        ,
#endif
    windowSetGeometryHints                  ,


-- ** setGroup #method:setGroup#

#if defined(ENABLE_OVERLOADING)
    WindowSetGroupMethodInfo                ,
#endif
    windowSetGroup                          ,


-- ** setIconList #method:setIconList#

#if defined(ENABLE_OVERLOADING)
    WindowSetIconListMethodInfo             ,
#endif
    windowSetIconList                       ,


-- ** setIconName #method:setIconName#

#if defined(ENABLE_OVERLOADING)
    WindowSetIconNameMethodInfo             ,
#endif
    windowSetIconName                       ,


-- ** setKeepAbove #method:setKeepAbove#

#if defined(ENABLE_OVERLOADING)
    WindowSetKeepAboveMethodInfo            ,
#endif
    windowSetKeepAbove                      ,


-- ** setKeepBelow #method:setKeepBelow#

#if defined(ENABLE_OVERLOADING)
    WindowSetKeepBelowMethodInfo            ,
#endif
    windowSetKeepBelow                      ,


-- ** setModalHint #method:setModalHint#

#if defined(ENABLE_OVERLOADING)
    WindowSetModalHintMethodInfo            ,
#endif
    windowSetModalHint                      ,


-- ** setOpacity #method:setOpacity#

#if defined(ENABLE_OVERLOADING)
    WindowSetOpacityMethodInfo              ,
#endif
    windowSetOpacity                        ,


-- ** setOpaqueRegion #method:setOpaqueRegion#

#if defined(ENABLE_OVERLOADING)
    WindowSetOpaqueRegionMethodInfo         ,
#endif
    windowSetOpaqueRegion                   ,


-- ** setOverrideRedirect #method:setOverrideRedirect#

#if defined(ENABLE_OVERLOADING)
    WindowSetOverrideRedirectMethodInfo     ,
#endif
    windowSetOverrideRedirect               ,


-- ** setPassThrough #method:setPassThrough#

#if defined(ENABLE_OVERLOADING)
    WindowSetPassThroughMethodInfo          ,
#endif
    windowSetPassThrough                    ,


-- ** setRole #method:setRole#

#if defined(ENABLE_OVERLOADING)
    WindowSetRoleMethodInfo                 ,
#endif
    windowSetRole                           ,


-- ** setShadowWidth #method:setShadowWidth#

#if defined(ENABLE_OVERLOADING)
    WindowSetShadowWidthMethodInfo          ,
#endif
    windowSetShadowWidth                    ,


-- ** setSkipPagerHint #method:setSkipPagerHint#

#if defined(ENABLE_OVERLOADING)
    WindowSetSkipPagerHintMethodInfo        ,
#endif
    windowSetSkipPagerHint                  ,


-- ** setSkipTaskbarHint #method:setSkipTaskbarHint#

#if defined(ENABLE_OVERLOADING)
    WindowSetSkipTaskbarHintMethodInfo      ,
#endif
    windowSetSkipTaskbarHint                ,


-- ** setSourceEvents #method:setSourceEvents#

#if defined(ENABLE_OVERLOADING)
    WindowSetSourceEventsMethodInfo         ,
#endif
    windowSetSourceEvents                   ,


-- ** setStartupId #method:setStartupId#

#if defined(ENABLE_OVERLOADING)
    WindowSetStartupIdMethodInfo            ,
#endif
    windowSetStartupId                      ,


-- ** setStaticGravities #method:setStaticGravities#

#if defined(ENABLE_OVERLOADING)
    WindowSetStaticGravitiesMethodInfo      ,
#endif
    windowSetStaticGravities                ,


-- ** setSupportMultidevice #method:setSupportMultidevice#

#if defined(ENABLE_OVERLOADING)
    WindowSetSupportMultideviceMethodInfo   ,
#endif
    windowSetSupportMultidevice             ,


-- ** setTitle #method:setTitle#

#if defined(ENABLE_OVERLOADING)
    WindowSetTitleMethodInfo                ,
#endif
    windowSetTitle                          ,


-- ** setTransientFor #method:setTransientFor#

#if defined(ENABLE_OVERLOADING)
    WindowSetTransientForMethodInfo         ,
#endif
    windowSetTransientFor                   ,


-- ** setTypeHint #method:setTypeHint#

#if defined(ENABLE_OVERLOADING)
    WindowSetTypeHintMethodInfo             ,
#endif
    windowSetTypeHint                       ,


-- ** setUrgencyHint #method:setUrgencyHint#

#if defined(ENABLE_OVERLOADING)
    WindowSetUrgencyHintMethodInfo          ,
#endif
    windowSetUrgencyHint                    ,


-- ** setUserData #method:setUserData#

#if defined(ENABLE_OVERLOADING)
    WindowSetUserDataMethodInfo             ,
#endif
    windowSetUserData                       ,


-- ** shapeCombineRegion #method:shapeCombineRegion#

#if defined(ENABLE_OVERLOADING)
    WindowShapeCombineRegionMethodInfo      ,
#endif
    windowShapeCombineRegion                ,


-- ** show #method:show#

#if defined(ENABLE_OVERLOADING)
    WindowShowMethodInfo                    ,
#endif
    windowShow                              ,


-- ** showUnraised #method:showUnraised#

#if defined(ENABLE_OVERLOADING)
    WindowShowUnraisedMethodInfo            ,
#endif
    windowShowUnraised                      ,


-- ** showWindowMenu #method:showWindowMenu#

#if defined(ENABLE_OVERLOADING)
    WindowShowWindowMenuMethodInfo          ,
#endif
    windowShowWindowMenu                    ,


-- ** stick #method:stick#

#if defined(ENABLE_OVERLOADING)
    WindowStickMethodInfo                   ,
#endif
    windowStick                             ,


-- ** thawToplevelUpdatesLibgtkOnly #method:thawToplevelUpdatesLibgtkOnly#

#if defined(ENABLE_OVERLOADING)
    WindowThawToplevelUpdatesLibgtkOnlyMethodInfo,
#endif
    windowThawToplevelUpdatesLibgtkOnly     ,


-- ** thawUpdates #method:thawUpdates#

#if defined(ENABLE_OVERLOADING)
    WindowThawUpdatesMethodInfo             ,
#endif
    windowThawUpdates                       ,


-- ** unfullscreen #method:unfullscreen#

#if defined(ENABLE_OVERLOADING)
    WindowUnfullscreenMethodInfo            ,
#endif
    windowUnfullscreen                      ,


-- ** unmaximize #method:unmaximize#

#if defined(ENABLE_OVERLOADING)
    WindowUnmaximizeMethodInfo              ,
#endif
    windowUnmaximize                        ,


-- ** unstick #method:unstick#

#if defined(ENABLE_OVERLOADING)
    WindowUnstickMethodInfo                 ,
#endif
    windowUnstick                           ,


-- ** withdraw #method:withdraw#

#if defined(ENABLE_OVERLOADING)
    WindowWithdrawMethodInfo                ,
#endif
    windowWithdraw                          ,




 -- * Properties


-- ** cursor #attr:cursor#
-- | The mouse pointer for a t'GI.Gdk.Objects.Window.Window'. See 'GI.Gdk.Objects.Window.windowSetCursor' and
-- 'GI.Gdk.Objects.Window.windowGetCursor' for details.
-- 
-- /Since: 2.18/

#if defined(ENABLE_OVERLOADING)
    WindowCursorPropertyInfo                ,
#endif
    clearWindowCursor                       ,
    constructWindowCursor                   ,
    getWindowCursor                         ,
    setWindowCursor                         ,
#if defined(ENABLE_OVERLOADING)
    windowCursor                            ,
#endif




 -- * Signals


-- ** createSurface #signal:createSurface#

    WindowCreateSurfaceCallback             ,
#if defined(ENABLE_OVERLOADING)
    WindowCreateSurfaceSignalInfo           ,
#endif
    afterWindowCreateSurface                ,
    onWindowCreateSurface                   ,


-- ** fromEmbedder #signal:fromEmbedder#

    WindowFromEmbedderCallback              ,
#if defined(ENABLE_OVERLOADING)
    WindowFromEmbedderSignalInfo            ,
#endif
    afterWindowFromEmbedder                 ,
    onWindowFromEmbedder                    ,


-- ** movedToRect #signal:movedToRect#

    WindowMovedToRectCallback               ,
#if defined(ENABLE_OVERLOADING)
    WindowMovedToRectSignalInfo             ,
#endif
    afterWindowMovedToRect                  ,
    onWindowMovedToRect                     ,


-- ** pickEmbeddedChild #signal:pickEmbeddedChild#

    WindowPickEmbeddedChildCallback         ,
#if defined(ENABLE_OVERLOADING)
    WindowPickEmbeddedChildSignalInfo       ,
#endif
    afterWindowPickEmbeddedChild            ,
    onWindowPickEmbeddedChild               ,


-- ** toEmbedder #signal:toEmbedder#

    WindowToEmbedderCallback                ,
#if defined(ENABLE_OVERLOADING)
    WindowToEmbedderSignalInfo              ,
#endif
    afterWindowToEmbedder                   ,
    onWindowToEmbedder                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf

#endif

-- | Memory-managed wrapper type.
newtype Window = Window (SP.ManagedPtr Window)
    deriving (Eq)

instance SP.ManagedPtrNewtype Window where
    toManagedPtr (Window p) = p

foreign import ccall "gdk_window_get_type"
    c_gdk_window_get_type :: IO B.Types.GType

instance B.Types.TypedObject Window where
    glibType = c_gdk_window_get_type

instance B.Types.GObject Window

-- | Type class for types which can be safely cast to t'Window', for instance with `toWindow`.
class (SP.GObject o, O.IsDescendantOf Window o) => IsWindow o
instance (SP.GObject o, O.IsDescendantOf Window o) => IsWindow o

instance O.HasParentTypes Window
type instance O.ParentTypes Window = '[GObject.Object.Object]

-- | Cast to t'Window', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toWindow :: (MIO.MonadIO m, IsWindow o) => o -> m Window
toWindow = MIO.liftIO . B.ManagedPtr.unsafeCastTo Window

-- | Convert t'Window' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Window) where
    gvalueGType_ = c_gdk_window_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Window)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Window)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Window ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveWindowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWindowMethod "beep" o = WindowBeepMethodInfo
    ResolveWindowMethod "beginDrawFrame" o = WindowBeginDrawFrameMethodInfo
    ResolveWindowMethod "beginMoveDrag" o = WindowBeginMoveDragMethodInfo
    ResolveWindowMethod "beginMoveDragForDevice" o = WindowBeginMoveDragForDeviceMethodInfo
    ResolveWindowMethod "beginPaintRect" o = WindowBeginPaintRectMethodInfo
    ResolveWindowMethod "beginPaintRegion" o = WindowBeginPaintRegionMethodInfo
    ResolveWindowMethod "beginResizeDrag" o = WindowBeginResizeDragMethodInfo
    ResolveWindowMethod "beginResizeDragForDevice" o = WindowBeginResizeDragForDeviceMethodInfo
    ResolveWindowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveWindowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveWindowMethod "configureFinished" o = WindowConfigureFinishedMethodInfo
    ResolveWindowMethod "coordsFromParent" o = WindowCoordsFromParentMethodInfo
    ResolveWindowMethod "coordsToParent" o = WindowCoordsToParentMethodInfo
    ResolveWindowMethod "createGlContext" o = WindowCreateGlContextMethodInfo
    ResolveWindowMethod "createSimilarImageSurface" o = WindowCreateSimilarImageSurfaceMethodInfo
    ResolveWindowMethod "createSimilarSurface" o = WindowCreateSimilarSurfaceMethodInfo
    ResolveWindowMethod "deiconify" o = WindowDeiconifyMethodInfo
    ResolveWindowMethod "destroy" o = WindowDestroyMethodInfo
    ResolveWindowMethod "destroyNotify" o = WindowDestroyNotifyMethodInfo
    ResolveWindowMethod "enableSynchronizedConfigure" o = WindowEnableSynchronizedConfigureMethodInfo
    ResolveWindowMethod "endDrawFrame" o = WindowEndDrawFrameMethodInfo
    ResolveWindowMethod "endPaint" o = WindowEndPaintMethodInfo
    ResolveWindowMethod "ensureNative" o = WindowEnsureNativeMethodInfo
    ResolveWindowMethod "flush" o = WindowFlushMethodInfo
    ResolveWindowMethod "focus" o = WindowFocusMethodInfo
    ResolveWindowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveWindowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveWindowMethod "freezeToplevelUpdatesLibgtkOnly" o = WindowFreezeToplevelUpdatesLibgtkOnlyMethodInfo
    ResolveWindowMethod "freezeUpdates" o = WindowFreezeUpdatesMethodInfo
    ResolveWindowMethod "fullscreen" o = WindowFullscreenMethodInfo
    ResolveWindowMethod "fullscreenOnMonitor" o = WindowFullscreenOnMonitorMethodInfo
    ResolveWindowMethod "geometryChanged" o = WindowGeometryChangedMethodInfo
    ResolveWindowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveWindowMethod "hasNative" o = WindowHasNativeMethodInfo
    ResolveWindowMethod "hide" o = WindowHideMethodInfo
    ResolveWindowMethod "iconify" o = WindowIconifyMethodInfo
    ResolveWindowMethod "inputShapeCombineRegion" o = WindowInputShapeCombineRegionMethodInfo
    ResolveWindowMethod "invalidateMaybeRecurse" o = WindowInvalidateMaybeRecurseMethodInfo
    ResolveWindowMethod "invalidateRect" o = WindowInvalidateRectMethodInfo
    ResolveWindowMethod "invalidateRegion" o = WindowInvalidateRegionMethodInfo
    ResolveWindowMethod "isDestroyed" o = WindowIsDestroyedMethodInfo
    ResolveWindowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveWindowMethod "isInputOnly" o = WindowIsInputOnlyMethodInfo
    ResolveWindowMethod "isShaped" o = WindowIsShapedMethodInfo
    ResolveWindowMethod "isViewable" o = WindowIsViewableMethodInfo
    ResolveWindowMethod "isVisible" o = WindowIsVisibleMethodInfo
    ResolveWindowMethod "lower" o = WindowLowerMethodInfo
    ResolveWindowMethod "markPaintFromClip" o = WindowMarkPaintFromClipMethodInfo
    ResolveWindowMethod "maximize" o = WindowMaximizeMethodInfo
    ResolveWindowMethod "mergeChildInputShapes" o = WindowMergeChildInputShapesMethodInfo
    ResolveWindowMethod "mergeChildShapes" o = WindowMergeChildShapesMethodInfo
    ResolveWindowMethod "move" o = WindowMoveMethodInfo
    ResolveWindowMethod "moveRegion" o = WindowMoveRegionMethodInfo
    ResolveWindowMethod "moveResize" o = WindowMoveResizeMethodInfo
    ResolveWindowMethod "moveToRect" o = WindowMoveToRectMethodInfo
    ResolveWindowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveWindowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveWindowMethod "peekChildren" o = WindowPeekChildrenMethodInfo
    ResolveWindowMethod "processUpdates" o = WindowProcessUpdatesMethodInfo
    ResolveWindowMethod "raise" o = WindowRaiseMethodInfo
    ResolveWindowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveWindowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveWindowMethod "registerDnd" o = WindowRegisterDndMethodInfo
    ResolveWindowMethod "reparent" o = WindowReparentMethodInfo
    ResolveWindowMethod "resize" o = WindowResizeMethodInfo
    ResolveWindowMethod "restack" o = WindowRestackMethodInfo
    ResolveWindowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveWindowMethod "scroll" o = WindowScrollMethodInfo
    ResolveWindowMethod "shapeCombineRegion" o = WindowShapeCombineRegionMethodInfo
    ResolveWindowMethod "show" o = WindowShowMethodInfo
    ResolveWindowMethod "showUnraised" o = WindowShowUnraisedMethodInfo
    ResolveWindowMethod "showWindowMenu" o = WindowShowWindowMenuMethodInfo
    ResolveWindowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveWindowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveWindowMethod "stick" o = WindowStickMethodInfo
    ResolveWindowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveWindowMethod "thawToplevelUpdatesLibgtkOnly" o = WindowThawToplevelUpdatesLibgtkOnlyMethodInfo
    ResolveWindowMethod "thawUpdates" o = WindowThawUpdatesMethodInfo
    ResolveWindowMethod "unfullscreen" o = WindowUnfullscreenMethodInfo
    ResolveWindowMethod "unmaximize" o = WindowUnmaximizeMethodInfo
    ResolveWindowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveWindowMethod "unstick" o = WindowUnstickMethodInfo
    ResolveWindowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveWindowMethod "withdraw" o = WindowWithdrawMethodInfo
    ResolveWindowMethod "getAcceptFocus" o = WindowGetAcceptFocusMethodInfo
    ResolveWindowMethod "getBackgroundPattern" o = WindowGetBackgroundPatternMethodInfo
    ResolveWindowMethod "getChildren" o = WindowGetChildrenMethodInfo
    ResolveWindowMethod "getChildrenWithUserData" o = WindowGetChildrenWithUserDataMethodInfo
    ResolveWindowMethod "getClipRegion" o = WindowGetClipRegionMethodInfo
    ResolveWindowMethod "getComposited" o = WindowGetCompositedMethodInfo
    ResolveWindowMethod "getCursor" o = WindowGetCursorMethodInfo
    ResolveWindowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveWindowMethod "getDecorations" o = WindowGetDecorationsMethodInfo
    ResolveWindowMethod "getDeviceCursor" o = WindowGetDeviceCursorMethodInfo
    ResolveWindowMethod "getDeviceEvents" o = WindowGetDeviceEventsMethodInfo
    ResolveWindowMethod "getDevicePosition" o = WindowGetDevicePositionMethodInfo
    ResolveWindowMethod "getDevicePositionDouble" o = WindowGetDevicePositionDoubleMethodInfo
    ResolveWindowMethod "getDisplay" o = WindowGetDisplayMethodInfo
    ResolveWindowMethod "getDragProtocol" o = WindowGetDragProtocolMethodInfo
    ResolveWindowMethod "getEffectiveParent" o = WindowGetEffectiveParentMethodInfo
    ResolveWindowMethod "getEffectiveToplevel" o = WindowGetEffectiveToplevelMethodInfo
    ResolveWindowMethod "getEventCompression" o = WindowGetEventCompressionMethodInfo
    ResolveWindowMethod "getEvents" o = WindowGetEventsMethodInfo
    ResolveWindowMethod "getFocusOnMap" o = WindowGetFocusOnMapMethodInfo
    ResolveWindowMethod "getFrameClock" o = WindowGetFrameClockMethodInfo
    ResolveWindowMethod "getFrameExtents" o = WindowGetFrameExtentsMethodInfo
    ResolveWindowMethod "getFullscreenMode" o = WindowGetFullscreenModeMethodInfo
    ResolveWindowMethod "getGeometry" o = WindowGetGeometryMethodInfo
    ResolveWindowMethod "getGroup" o = WindowGetGroupMethodInfo
    ResolveWindowMethod "getHeight" o = WindowGetHeightMethodInfo
    ResolveWindowMethod "getModalHint" o = WindowGetModalHintMethodInfo
    ResolveWindowMethod "getOrigin" o = WindowGetOriginMethodInfo
    ResolveWindowMethod "getParent" o = WindowGetParentMethodInfo
    ResolveWindowMethod "getPassThrough" o = WindowGetPassThroughMethodInfo
    ResolveWindowMethod "getPointer" o = WindowGetPointerMethodInfo
    ResolveWindowMethod "getPosition" o = WindowGetPositionMethodInfo
    ResolveWindowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveWindowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveWindowMethod "getRootCoords" o = WindowGetRootCoordsMethodInfo
    ResolveWindowMethod "getRootOrigin" o = WindowGetRootOriginMethodInfo
    ResolveWindowMethod "getScaleFactor" o = WindowGetScaleFactorMethodInfo
    ResolveWindowMethod "getScreen" o = WindowGetScreenMethodInfo
    ResolveWindowMethod "getSourceEvents" o = WindowGetSourceEventsMethodInfo
    ResolveWindowMethod "getState" o = WindowGetStateMethodInfo
    ResolveWindowMethod "getSupportMultidevice" o = WindowGetSupportMultideviceMethodInfo
    ResolveWindowMethod "getToplevel" o = WindowGetToplevelMethodInfo
    ResolveWindowMethod "getTypeHint" o = WindowGetTypeHintMethodInfo
    ResolveWindowMethod "getUpdateArea" o = WindowGetUpdateAreaMethodInfo
    ResolveWindowMethod "getUserData" o = WindowGetUserDataMethodInfo
    ResolveWindowMethod "getVisibleRegion" o = WindowGetVisibleRegionMethodInfo
    ResolveWindowMethod "getVisual" o = WindowGetVisualMethodInfo
    ResolveWindowMethod "getWidth" o = WindowGetWidthMethodInfo
    ResolveWindowMethod "getWindowType" o = WindowGetWindowTypeMethodInfo
    ResolveWindowMethod "setAcceptFocus" o = WindowSetAcceptFocusMethodInfo
    ResolveWindowMethod "setBackground" o = WindowSetBackgroundMethodInfo
    ResolveWindowMethod "setBackgroundPattern" o = WindowSetBackgroundPatternMethodInfo
    ResolveWindowMethod "setBackgroundRgba" o = WindowSetBackgroundRgbaMethodInfo
    ResolveWindowMethod "setChildInputShapes" o = WindowSetChildInputShapesMethodInfo
    ResolveWindowMethod "setChildShapes" o = WindowSetChildShapesMethodInfo
    ResolveWindowMethod "setComposited" o = WindowSetCompositedMethodInfo
    ResolveWindowMethod "setCursor" o = WindowSetCursorMethodInfo
    ResolveWindowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveWindowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveWindowMethod "setDecorations" o = WindowSetDecorationsMethodInfo
    ResolveWindowMethod "setDeviceCursor" o = WindowSetDeviceCursorMethodInfo
    ResolveWindowMethod "setDeviceEvents" o = WindowSetDeviceEventsMethodInfo
    ResolveWindowMethod "setEventCompression" o = WindowSetEventCompressionMethodInfo
    ResolveWindowMethod "setEvents" o = WindowSetEventsMethodInfo
    ResolveWindowMethod "setFocusOnMap" o = WindowSetFocusOnMapMethodInfo
    ResolveWindowMethod "setFullscreenMode" o = WindowSetFullscreenModeMethodInfo
    ResolveWindowMethod "setFunctions" o = WindowSetFunctionsMethodInfo
    ResolveWindowMethod "setGeometryHints" o = WindowSetGeometryHintsMethodInfo
    ResolveWindowMethod "setGroup" o = WindowSetGroupMethodInfo
    ResolveWindowMethod "setIconList" o = WindowSetIconListMethodInfo
    ResolveWindowMethod "setIconName" o = WindowSetIconNameMethodInfo
    ResolveWindowMethod "setKeepAbove" o = WindowSetKeepAboveMethodInfo
    ResolveWindowMethod "setKeepBelow" o = WindowSetKeepBelowMethodInfo
    ResolveWindowMethod "setModalHint" o = WindowSetModalHintMethodInfo
    ResolveWindowMethod "setOpacity" o = WindowSetOpacityMethodInfo
    ResolveWindowMethod "setOpaqueRegion" o = WindowSetOpaqueRegionMethodInfo
    ResolveWindowMethod "setOverrideRedirect" o = WindowSetOverrideRedirectMethodInfo
    ResolveWindowMethod "setPassThrough" o = WindowSetPassThroughMethodInfo
    ResolveWindowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveWindowMethod "setRole" o = WindowSetRoleMethodInfo
    ResolveWindowMethod "setShadowWidth" o = WindowSetShadowWidthMethodInfo
    ResolveWindowMethod "setSkipPagerHint" o = WindowSetSkipPagerHintMethodInfo
    ResolveWindowMethod "setSkipTaskbarHint" o = WindowSetSkipTaskbarHintMethodInfo
    ResolveWindowMethod "setSourceEvents" o = WindowSetSourceEventsMethodInfo
    ResolveWindowMethod "setStartupId" o = WindowSetStartupIdMethodInfo
    ResolveWindowMethod "setStaticGravities" o = WindowSetStaticGravitiesMethodInfo
    ResolveWindowMethod "setSupportMultidevice" o = WindowSetSupportMultideviceMethodInfo
    ResolveWindowMethod "setTitle" o = WindowSetTitleMethodInfo
    ResolveWindowMethod "setTransientFor" o = WindowSetTransientForMethodInfo
    ResolveWindowMethod "setTypeHint" o = WindowSetTypeHintMethodInfo
    ResolveWindowMethod "setUrgencyHint" o = WindowSetUrgencyHintMethodInfo
    ResolveWindowMethod "setUserData" o = WindowSetUserDataMethodInfo
    ResolveWindowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWindowMethod t Window, O.OverloadedMethod info Window p) => OL.IsLabel t (Window -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWindowMethod t Window, O.OverloadedMethod info Window p, R.HasField t Window p) => R.HasField t Window p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWindowMethod t Window, O.OverloadedMethodInfo info Window) => OL.IsLabel t (O.MethodProxy info Window) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Window::create-surface
-- | The [createSurface](#g:signal:createSurface) signal is emitted when an offscreen window
-- needs its surface (re)created, which happens either when the
-- window is first drawn to, or when the window is being
-- resized. The first signal handler that returns a non-'P.Nothing'
-- surface will stop any further signal emission, and its surface
-- will be used.
-- 
-- Note that it is not possible to access the window\'s previous
-- surface from within any callback of this signal. Calling
-- 'GI.Gdk.Functions.offscreenWindowGetSurface' will lead to a crash.
-- 
-- /Since: 3.0/
type WindowCreateSurfaceCallback =
    Int32
    -- ^ /@width@/: the width of the offscreen surface to create
    -> Int32
    -- ^ /@height@/: the height of the offscreen surface to create
    -> IO Cairo.Surface.Surface
    -- ^ __Returns:__ the newly created t'GI.Cairo.Structs.Surface.Surface' for the offscreen window

type C_WindowCreateSurfaceCallback =
    Ptr Window ->                           -- object
    Int32 ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO (Ptr Cairo.Surface.Surface)

-- | Generate a function pointer callable from C code, from a `C_WindowCreateSurfaceCallback`.
foreign import ccall "wrapper"
    mk_WindowCreateSurfaceCallback :: C_WindowCreateSurfaceCallback -> IO (FunPtr C_WindowCreateSurfaceCallback)

wrap_WindowCreateSurfaceCallback :: 
    GObject a => (a -> WindowCreateSurfaceCallback) ->
    C_WindowCreateSurfaceCallback
wrap_WindowCreateSurfaceCallback gi'cb gi'selfPtr width height _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  width height
    result' <- B.ManagedPtr.disownBoxed result
    return result'


-- | Connect a signal handler for the [createSurface](#signal:createSurface) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #createSurface callback
-- @
-- 
-- 
onWindowCreateSurface :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowCreateSurfaceCallback) -> m SignalHandlerId
onWindowCreateSurface obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowCreateSurfaceCallback wrapped
    wrapped'' <- mk_WindowCreateSurfaceCallback wrapped'
    connectSignalFunPtr obj "create-surface" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [createSurface](#signal:createSurface) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #createSurface callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowCreateSurface :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowCreateSurfaceCallback) -> m SignalHandlerId
afterWindowCreateSurface obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowCreateSurfaceCallback wrapped
    wrapped'' <- mk_WindowCreateSurfaceCallback wrapped'
    connectSignalFunPtr obj "create-surface" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowCreateSurfaceSignalInfo
instance SignalInfo WindowCreateSurfaceSignalInfo where
    type HaskellCallbackType WindowCreateSurfaceSignalInfo = WindowCreateSurfaceCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowCreateSurfaceCallback cb
        cb'' <- mk_WindowCreateSurfaceCallback cb'
        connectSignalFunPtr obj "create-surface" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window::create-surface"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#g:signal:createSurface"})

#endif

-- signal Window::from-embedder
-- | The [fromEmbedder](#g:signal:fromEmbedder) signal is emitted to translate coordinates
-- in the embedder of an offscreen window to the offscreen window.
-- 
-- See also [Window::toEmbedder]("GI.Gdk.Objects.Window#g:signal:toEmbedder").
-- 
-- /Since: 2.18/
type WindowFromEmbedderCallback =
    Double
    -- ^ /@embedderX@/: x coordinate in the embedder window
    -> Double
    -- ^ /@embedderY@/: y coordinate in the embedder window
    -> IO ((Double, Double))

type C_WindowFromEmbedderCallback =
    Ptr Window ->                           -- object
    CDouble ->
    CDouble ->
    Ptr CDouble ->
    Ptr CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WindowFromEmbedderCallback`.
foreign import ccall "wrapper"
    mk_WindowFromEmbedderCallback :: C_WindowFromEmbedderCallback -> IO (FunPtr C_WindowFromEmbedderCallback)

wrap_WindowFromEmbedderCallback :: 
    GObject a => (a -> WindowFromEmbedderCallback) ->
    C_WindowFromEmbedderCallback
wrap_WindowFromEmbedderCallback gi'cb gi'selfPtr embedderX embedderY offscreenX offscreenY _ = do
    let embedderX' = realToFrac embedderX
    let embedderY' = realToFrac embedderY
    (outoffscreenX, outoffscreenY) <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  embedderX' embedderY'
    let outoffscreenX' = realToFrac outoffscreenX
    poke offscreenX outoffscreenX'
    let outoffscreenY' = realToFrac outoffscreenY
    poke offscreenY outoffscreenY'


-- | Connect a signal handler for the [fromEmbedder](#signal:fromEmbedder) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #fromEmbedder callback
-- @
-- 
-- 
onWindowFromEmbedder :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowFromEmbedderCallback) -> m SignalHandlerId
onWindowFromEmbedder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowFromEmbedderCallback wrapped
    wrapped'' <- mk_WindowFromEmbedderCallback wrapped'
    connectSignalFunPtr obj "from-embedder" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [fromEmbedder](#signal:fromEmbedder) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #fromEmbedder callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowFromEmbedder :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowFromEmbedderCallback) -> m SignalHandlerId
afterWindowFromEmbedder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowFromEmbedderCallback wrapped
    wrapped'' <- mk_WindowFromEmbedderCallback wrapped'
    connectSignalFunPtr obj "from-embedder" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowFromEmbedderSignalInfo
instance SignalInfo WindowFromEmbedderSignalInfo where
    type HaskellCallbackType WindowFromEmbedderSignalInfo = WindowFromEmbedderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowFromEmbedderCallback cb
        cb'' <- mk_WindowFromEmbedderCallback cb'
        connectSignalFunPtr obj "from-embedder" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window::from-embedder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#g:signal:fromEmbedder"})

#endif

-- signal Window::moved-to-rect
-- | Emitted when the position of /@window@/ is finalized after being moved to a
-- destination rectangle.
-- 
-- /@window@/ might be flipped over the destination rectangle in order to keep
-- it on-screen, in which case /@flippedX@/ and /@flippedY@/ will be set to 'P.True'
-- accordingly.
-- 
-- /@flippedRect@/ is the ideal position of /@window@/ after any possible
-- flipping, but before any possible sliding. /@finalRect@/ is /@flippedRect@/,
-- but possibly translated in the case that flipping is still ineffective in
-- keeping /@window@/ on-screen.
-- 
-- /Since: 3.22/
type WindowMovedToRectCallback =
    Ptr ()
    -- ^ /@flippedRect@/: the position of /@window@/ after any possible
    --                flipping or 'P.Nothing' if the backend can\'t obtain it
    -> Ptr ()
    -- ^ /@finalRect@/: the final position of /@window@/ or 'P.Nothing' if the
    --              backend can\'t obtain it
    -> Bool
    -- ^ /@flippedX@/: 'P.True' if the anchors were flipped horizontally
    -> Bool
    -- ^ /@flippedY@/: 'P.True' if the anchors were flipped vertically
    -> IO ()

type C_WindowMovedToRectCallback =
    Ptr Window ->                           -- object
    Ptr () ->
    Ptr () ->
    CInt ->
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WindowMovedToRectCallback`.
foreign import ccall "wrapper"
    mk_WindowMovedToRectCallback :: C_WindowMovedToRectCallback -> IO (FunPtr C_WindowMovedToRectCallback)

wrap_WindowMovedToRectCallback :: 
    GObject a => (a -> WindowMovedToRectCallback) ->
    C_WindowMovedToRectCallback
wrap_WindowMovedToRectCallback gi'cb gi'selfPtr flippedRect finalRect flippedX flippedY _ = do
    let flippedX' = (/= 0) flippedX
    let flippedY' = (/= 0) flippedY
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  flippedRect finalRect flippedX' flippedY'


-- | Connect a signal handler for the [movedToRect](#signal:movedToRect) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #movedToRect callback
-- @
-- 
-- 
onWindowMovedToRect :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowMovedToRectCallback) -> m SignalHandlerId
onWindowMovedToRect obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowMovedToRectCallback wrapped
    wrapped'' <- mk_WindowMovedToRectCallback wrapped'
    connectSignalFunPtr obj "moved-to-rect" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [movedToRect](#signal:movedToRect) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #movedToRect callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowMovedToRect :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowMovedToRectCallback) -> m SignalHandlerId
afterWindowMovedToRect obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowMovedToRectCallback wrapped
    wrapped'' <- mk_WindowMovedToRectCallback wrapped'
    connectSignalFunPtr obj "moved-to-rect" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowMovedToRectSignalInfo
instance SignalInfo WindowMovedToRectSignalInfo where
    type HaskellCallbackType WindowMovedToRectSignalInfo = WindowMovedToRectCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowMovedToRectCallback cb
        cb'' <- mk_WindowMovedToRectCallback cb'
        connectSignalFunPtr obj "moved-to-rect" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window::moved-to-rect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#g:signal:movedToRect"})

#endif

-- signal Window::pick-embedded-child
-- | The [pickEmbeddedChild](#g:signal:pickEmbeddedChild) signal is emitted to find an embedded
-- child at the given position.
-- 
-- /Since: 2.18/
type WindowPickEmbeddedChildCallback =
    Double
    -- ^ /@x@/: x coordinate in the window
    -> Double
    -- ^ /@y@/: y coordinate in the window
    -> IO (Maybe Window)
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Window.Window' of the
    --     embedded child at /@x@/, /@y@/, or 'P.Nothing'

type C_WindowPickEmbeddedChildCallback =
    Ptr Window ->                           -- object
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO (Ptr Window)

-- | Generate a function pointer callable from C code, from a `C_WindowPickEmbeddedChildCallback`.
foreign import ccall "wrapper"
    mk_WindowPickEmbeddedChildCallback :: C_WindowPickEmbeddedChildCallback -> IO (FunPtr C_WindowPickEmbeddedChildCallback)

wrap_WindowPickEmbeddedChildCallback :: 
    GObject a => (a -> WindowPickEmbeddedChildCallback) ->
    C_WindowPickEmbeddedChildCallback
wrap_WindowPickEmbeddedChildCallback gi'cb gi'selfPtr x y _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  x' y'
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- unsafeManagedPtrCastPtr result'
        return result''


-- | Connect a signal handler for the [pickEmbeddedChild](#signal:pickEmbeddedChild) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #pickEmbeddedChild callback
-- @
-- 
-- 
onWindowPickEmbeddedChild :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowPickEmbeddedChildCallback) -> m SignalHandlerId
onWindowPickEmbeddedChild obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowPickEmbeddedChildCallback wrapped
    wrapped'' <- mk_WindowPickEmbeddedChildCallback wrapped'
    connectSignalFunPtr obj "pick-embedded-child" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pickEmbeddedChild](#signal:pickEmbeddedChild) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #pickEmbeddedChild callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowPickEmbeddedChild :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowPickEmbeddedChildCallback) -> m SignalHandlerId
afterWindowPickEmbeddedChild obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowPickEmbeddedChildCallback wrapped
    wrapped'' <- mk_WindowPickEmbeddedChildCallback wrapped'
    connectSignalFunPtr obj "pick-embedded-child" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowPickEmbeddedChildSignalInfo
instance SignalInfo WindowPickEmbeddedChildSignalInfo where
    type HaskellCallbackType WindowPickEmbeddedChildSignalInfo = WindowPickEmbeddedChildCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowPickEmbeddedChildCallback cb
        cb'' <- mk_WindowPickEmbeddedChildCallback cb'
        connectSignalFunPtr obj "pick-embedded-child" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window::pick-embedded-child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#g:signal:pickEmbeddedChild"})

#endif

-- signal Window::to-embedder
-- | The [toEmbedder](#g:signal:toEmbedder) signal is emitted to translate coordinates
-- in an offscreen window to its embedder.
-- 
-- See also [Window::fromEmbedder]("GI.Gdk.Objects.Window#g:signal:fromEmbedder").
-- 
-- /Since: 2.18/
type WindowToEmbedderCallback =
    Double
    -- ^ /@offscreenX@/: x coordinate in the offscreen window
    -> Double
    -- ^ /@offscreenY@/: y coordinate in the offscreen window
    -> IO ((Double, Double))

type C_WindowToEmbedderCallback =
    Ptr Window ->                           -- object
    CDouble ->
    CDouble ->
    Ptr CDouble ->
    Ptr CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WindowToEmbedderCallback`.
foreign import ccall "wrapper"
    mk_WindowToEmbedderCallback :: C_WindowToEmbedderCallback -> IO (FunPtr C_WindowToEmbedderCallback)

wrap_WindowToEmbedderCallback :: 
    GObject a => (a -> WindowToEmbedderCallback) ->
    C_WindowToEmbedderCallback
wrap_WindowToEmbedderCallback gi'cb gi'selfPtr offscreenX offscreenY embedderX embedderY _ = do
    let offscreenX' = realToFrac offscreenX
    let offscreenY' = realToFrac offscreenY
    (outembedderX, outembedderY) <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  offscreenX' offscreenY'
    let outembedderX' = realToFrac outembedderX
    poke embedderX outembedderX'
    let outembedderY' = realToFrac outembedderY
    poke embedderY outembedderY'


-- | Connect a signal handler for the [toEmbedder](#signal:toEmbedder) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #toEmbedder callback
-- @
-- 
-- 
onWindowToEmbedder :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowToEmbedderCallback) -> m SignalHandlerId
onWindowToEmbedder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowToEmbedderCallback wrapped
    wrapped'' <- mk_WindowToEmbedderCallback wrapped'
    connectSignalFunPtr obj "to-embedder" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toEmbedder](#signal:toEmbedder) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #toEmbedder callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowToEmbedder :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowToEmbedderCallback) -> m SignalHandlerId
afterWindowToEmbedder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowToEmbedderCallback wrapped
    wrapped'' <- mk_WindowToEmbedderCallback wrapped'
    connectSignalFunPtr obj "to-embedder" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowToEmbedderSignalInfo
instance SignalInfo WindowToEmbedderSignalInfo where
    type HaskellCallbackType WindowToEmbedderSignalInfo = WindowToEmbedderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowToEmbedderCallback cb
        cb'' <- mk_WindowToEmbedderCallback cb'
        connectSignalFunPtr obj "to-embedder" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window::to-embedder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#g:signal:toEmbedder"})

#endif

-- VVV Prop "cursor"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Cursor"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@cursor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #cursor
-- @
getWindowCursor :: (MonadIO m, IsWindow o) => o -> m (Maybe Gdk.Cursor.Cursor)
getWindowCursor obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "cursor" Gdk.Cursor.Cursor

-- | Set the value of the “@cursor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #cursor 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowCursor :: (MonadIO m, IsWindow o, Gdk.Cursor.IsCursor a) => o -> a -> m ()
setWindowCursor obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "cursor" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@cursor@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowCursor :: (IsWindow o, MIO.MonadIO m, Gdk.Cursor.IsCursor a) => a -> m (GValueConstruct o)
constructWindowCursor val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "cursor" (P.Just val)

-- | Set the value of the “@cursor@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #cursor
-- @
clearWindowCursor :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowCursor obj = liftIO $ B.Properties.setObjectPropertyObject obj "cursor" (Nothing :: Maybe Gdk.Cursor.Cursor)

#if defined(ENABLE_OVERLOADING)
data WindowCursorPropertyInfo
instance AttrInfo WindowCursorPropertyInfo where
    type AttrAllowedOps WindowCursorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowCursorPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowCursorPropertyInfo = Gdk.Cursor.IsCursor
    type AttrTransferTypeConstraint WindowCursorPropertyInfo = Gdk.Cursor.IsCursor
    type AttrTransferType WindowCursorPropertyInfo = Gdk.Cursor.Cursor
    type AttrGetType WindowCursorPropertyInfo = (Maybe Gdk.Cursor.Cursor)
    type AttrLabel WindowCursorPropertyInfo = "cursor"
    type AttrOrigin WindowCursorPropertyInfo = Window
    attrGet = getWindowCursor
    attrSet = setWindowCursor
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Cursor.Cursor v
    attrConstruct = constructWindowCursor
    attrClear = clearWindowCursor
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#g:attr:cursor"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Window
type instance O.AttributeList Window = WindowAttributeList
type WindowAttributeList = ('[ '("cursor", WindowCursorPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
windowCursor :: AttrLabelProxy "cursor"
windowCursor = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Window = WindowSignalList
type WindowSignalList = ('[ '("createSurface", WindowCreateSurfaceSignalInfo), '("fromEmbedder", WindowFromEmbedderSignalInfo), '("movedToRect", WindowMovedToRectSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pickEmbeddedChild", WindowPickEmbeddedChildSignalInfo), '("toEmbedder", WindowToEmbedderSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Window::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GdkWindow, or %NULL to create the window as a child of\n  the default root window for the default display."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attributes"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowAttr" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "attributes of the new window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attributes_mask"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "WindowAttributesType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "mask indicating which\n  fields in @attributes are valid"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_new" gdk_window_new :: 
    Ptr Window ->                           -- parent : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.WindowAttr.WindowAttr ->        -- attributes : TInterface (Name {namespace = "Gdk", name = "WindowAttr"})
    CUInt ->                                -- attributes_mask : TInterface (Name {namespace = "Gdk", name = "WindowAttributesType"})
    IO (Ptr Window)

-- | Creates a new t'GI.Gdk.Objects.Window.Window' using the attributes from
-- /@attributes@/. See t'GI.Gdk.Structs.WindowAttr.WindowAttr' and t'GI.Gdk.Flags.WindowAttributesType' for
-- more details.  Note: to use this on displays other than the default
-- display, /@parent@/ must be specified.
windowNew ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    Maybe (a)
    -- ^ /@parent@/: a t'GI.Gdk.Objects.Window.Window', or 'P.Nothing' to create the window as a child of
    --   the default root window for the default display.
    -> Gdk.WindowAttr.WindowAttr
    -- ^ /@attributes@/: attributes of the new window
    -> [Gdk.Flags.WindowAttributesType]
    -- ^ /@attributesMask@/: mask indicating which
    --   fields in /@attributes@/ are valid
    -> m Window
    -- ^ __Returns:__ the new t'GI.Gdk.Objects.Window.Window'
windowNew parent attributes attributesMask = liftIO $ do
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    attributes' <- unsafeManagedPtrGetPtr attributes
    let attributesMask' = gflagsToWord attributesMask
    result <- gdk_window_new maybeParent attributes' attributesMask'
    checkUnexpectedReturnNULL "windowNew" result
    result' <- (wrapObject Window) result
    whenJust parent touchManagedPtr
    touchManagedPtr attributes
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::beep
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_beep" gdk_window_beep :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Emits a short beep associated to /@window@/ in the appropriate
-- display, if supported. Otherwise, emits a short beep on
-- the display just as 'GI.Gdk.Objects.Display.displayBeep'.
-- 
-- /Since: 2.12/
windowBeep ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowBeep window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_beep window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeepMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowBeepMethodInfo a signature where
    overloadedMethod = windowBeep

instance O.OverloadedMethodInfo WindowBeepMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeep",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeep"
        })


#endif

-- method Window::begin_draw_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Cairo region" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DrawingContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_draw_frame" gdk_window_begin_draw_frame :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO (Ptr Gdk.DrawingContext.DrawingContext)

-- | Indicates that you are beginning the process of redrawing /@region@/
-- on /@window@/, and provides you with a t'GI.Gdk.Objects.DrawingContext.DrawingContext'.
-- 
-- If /@window@/ is a top level t'GI.Gdk.Objects.Window.Window', backed by a native window
-- implementation, a backing store (offscreen buffer) large enough to
-- contain /@region@/ will be created. The backing store will be initialized
-- with the background color or background surface for /@window@/. Then, all
-- drawing operations performed on /@window@/ will be diverted to the
-- backing store. When you call @/gdk_window_end_frame()/@, the contents of
-- the backing store will be copied to /@window@/, making it visible
-- on screen. Only the part of /@window@/ contained in /@region@/ will be
-- modified; that is, drawing operations are clipped to /@region@/.
-- 
-- The net result of all this is to remove flicker, because the user
-- sees the finished product appear all at once when you call
-- 'GI.Gdk.Objects.Window.windowEndDrawFrame'. If you draw to /@window@/ directly without
-- calling 'GI.Gdk.Objects.Window.windowBeginDrawFrame', the user may see flicker
-- as individual drawing operations are performed in sequence.
-- 
-- When using GTK+, the widget system automatically places calls to
-- 'GI.Gdk.Objects.Window.windowBeginDrawFrame' and 'GI.Gdk.Objects.Window.windowEndDrawFrame' around
-- emissions of the @GtkWidget::draw@ signal. That is, if you’re
-- drawing the contents of the widget yourself, you can assume that the
-- widget has a cleared background, is already set as the clip region,
-- and already has a backing store. Therefore in most cases, application
-- code in GTK does not need to call 'GI.Gdk.Objects.Window.windowBeginDrawFrame'
-- explicitly.
-- 
-- /Since: 3.22/
windowBeginDrawFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: a Cairo region
    -> m Gdk.DrawingContext.DrawingContext
    -- ^ __Returns:__ a t'GI.Gdk.Objects.DrawingContext.DrawingContext' context that should be
    --   used to draw the contents of the window; the returned context is owned
    --   by GDK.
windowBeginDrawFrame window region = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    region' <- unsafeManagedPtrGetPtr region
    result <- gdk_window_begin_draw_frame window' region'
    checkUnexpectedReturnNULL "windowBeginDrawFrame" result
    result' <- (newObject Gdk.DrawingContext.DrawingContext) result
    touchManagedPtr window
    touchManagedPtr region
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowBeginDrawFrameMethodInfo
instance (signature ~ (Cairo.Region.Region -> m Gdk.DrawingContext.DrawingContext), MonadIO m, IsWindow a) => O.OverloadedMethod WindowBeginDrawFrameMethodInfo a signature where
    overloadedMethod = windowBeginDrawFrame

instance O.OverloadedMethodInfo WindowBeginDrawFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginDrawFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginDrawFrame"
        })


#endif

-- method Window::begin_move_drag
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the button being used to drag, or 0 for a keyboard-initiated drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window X coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window Y coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "timestamp of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_move_drag" gdk_window_begin_move_drag :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- button : TBasicType TInt
    Int32 ->                                -- root_x : TBasicType TInt
    Int32 ->                                -- root_y : TBasicType TInt
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Begins a window move operation (for a toplevel window).
-- 
-- This function assumes that the drag is controlled by the
-- client pointer device, use 'GI.Gdk.Objects.Window.windowBeginMoveDragForDevice'
-- to begin a drag with a different device.
windowBeginMoveDrag ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@button@/: the button being used to drag, or 0 for a keyboard-initiated drag
    -> Int32
    -- ^ /@rootX@/: root window X coordinate of mouse click that began the drag
    -> Int32
    -- ^ /@rootY@/: root window Y coordinate of mouse click that began the drag
    -> Word32
    -- ^ /@timestamp@/: timestamp of mouse click that began the drag
    -> m ()
windowBeginMoveDrag window button rootX rootY timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_begin_move_drag window' button rootX rootY timestamp
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeginMoveDragMethodInfo
instance (signature ~ (Int32 -> Int32 -> Int32 -> Word32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowBeginMoveDragMethodInfo a signature where
    overloadedMethod = windowBeginMoveDrag

instance O.OverloadedMethodInfo WindowBeginMoveDragMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginMoveDrag",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginMoveDrag"
        })


#endif

-- method Window::begin_move_drag_for_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device used for the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the button being used to drag, or 0 for a keyboard-initiated drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window X coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window Y coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "timestamp of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_move_drag_for_device" gdk_window_begin_move_drag_for_device :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Int32 ->                                -- button : TBasicType TInt
    Int32 ->                                -- root_x : TBasicType TInt
    Int32 ->                                -- root_y : TBasicType TInt
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Begins a window move operation (for a toplevel window).
-- You might use this function to implement a “window move grip,” for
-- example. The function works best with window managers that support the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints>
-- but has a fallback implementation for other window managers.
-- 
-- /Since: 3.4/
windowBeginMoveDragForDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@device@/: the device used for the operation
    -> Int32
    -- ^ /@button@/: the button being used to drag, or 0 for a keyboard-initiated drag
    -> Int32
    -- ^ /@rootX@/: root window X coordinate of mouse click that began the drag
    -> Int32
    -- ^ /@rootY@/: root window Y coordinate of mouse click that began the drag
    -> Word32
    -- ^ /@timestamp@/: timestamp of mouse click that began the drag
    -> m ()
windowBeginMoveDragForDevice window device button rootX rootY timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    gdk_window_begin_move_drag_for_device window' device' button rootX rootY timestamp
    touchManagedPtr window
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeginMoveDragForDeviceMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> Int32 -> Word32 -> m ()), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowBeginMoveDragForDeviceMethodInfo a signature where
    overloadedMethod = windowBeginMoveDragForDevice

instance O.OverloadedMethodInfo WindowBeginMoveDragForDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginMoveDragForDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginMoveDragForDevice"
        })


#endif

-- method Window::begin_paint_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rectangle"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle you intend to draw to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_paint_rect" gdk_window_begin_paint_rect :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rectangle : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

{-# DEPRECATED windowBeginPaintRect ["(Since version 3.22)","Use 'GI.Gdk.Objects.Window.windowBeginDrawFrame' instead"] #-}
-- | A convenience wrapper around 'GI.Gdk.Objects.Window.windowBeginPaintRegion' which
-- creates a rectangular region for you. See
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion' for details.
windowBeginPaintRect ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Rectangle.Rectangle
    -- ^ /@rectangle@/: rectangle you intend to draw to
    -> m ()
windowBeginPaintRect window rectangle = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    rectangle' <- unsafeManagedPtrGetPtr rectangle
    gdk_window_begin_paint_rect window' rectangle'
    touchManagedPtr window
    touchManagedPtr rectangle
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeginPaintRectMethodInfo
instance (signature ~ (Gdk.Rectangle.Rectangle -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowBeginPaintRectMethodInfo a signature where
    overloadedMethod = windowBeginPaintRect

instance O.OverloadedMethodInfo WindowBeginPaintRectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginPaintRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginPaintRect"
        })


#endif

-- method Window::begin_paint_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "region you intend to draw to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_paint_region" gdk_window_begin_paint_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

{-# DEPRECATED windowBeginPaintRegion ["(Since version 3.22)","Use 'GI.Gdk.Objects.Window.windowBeginDrawFrame' instead"] #-}
-- | Indicates that you are beginning the process of redrawing /@region@/.
-- A backing store (offscreen buffer) large enough to contain /@region@/
-- will be created. The backing store will be initialized with the
-- background color or background surface for /@window@/. Then, all
-- drawing operations performed on /@window@/ will be diverted to the
-- backing store.  When you call 'GI.Gdk.Objects.Window.windowEndPaint', the backing
-- store will be copied to /@window@/, making it visible onscreen. Only
-- the part of /@window@/ contained in /@region@/ will be modified; that is,
-- drawing operations are clipped to /@region@/.
-- 
-- The net result of all this is to remove flicker, because the user
-- sees the finished product appear all at once when you call
-- 'GI.Gdk.Objects.Window.windowEndPaint'. If you draw to /@window@/ directly without
-- calling 'GI.Gdk.Objects.Window.windowBeginPaintRegion', the user may see flicker
-- as individual drawing operations are performed in sequence.  The
-- clipping and background-initializing features of
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion' are conveniences for the
-- programmer, so you can avoid doing that work yourself.
-- 
-- When using GTK+, the widget system automatically places calls to
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion' and 'GI.Gdk.Objects.Window.windowEndPaint' around
-- emissions of the expose_event signal. That is, if you’re writing an
-- expose event handler, you can assume that the exposed area in
-- t'GI.Gdk.Structs.EventExpose.EventExpose' has already been cleared to the window background,
-- is already set as the clip region, and already has a backing store.
-- Therefore in most cases, application code need not call
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion'. (You can disable the automatic
-- calls around expose events on a widget-by-widget basis by calling
-- @/gtk_widget_set_double_buffered()/@.)
-- 
-- If you call this function multiple times before calling the
-- matching 'GI.Gdk.Objects.Window.windowEndPaint', the backing stores are pushed onto
-- a stack. 'GI.Gdk.Objects.Window.windowEndPaint' copies the topmost backing store
-- onscreen, subtracts the topmost region from all other regions in
-- the stack, and pops the stack. All drawing operations affect only
-- the topmost backing store in the stack. One matching call to
-- 'GI.Gdk.Objects.Window.windowEndPaint' is required for each call to
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion'.
windowBeginPaintRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: region you intend to draw to
    -> m ()
windowBeginPaintRegion window region = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    region' <- unsafeManagedPtrGetPtr region
    gdk_window_begin_paint_region window' region'
    touchManagedPtr window
    touchManagedPtr region
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeginPaintRegionMethodInfo
instance (signature ~ (Cairo.Region.Region -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowBeginPaintRegionMethodInfo a signature where
    overloadedMethod = windowBeginPaintRegion

instance O.OverloadedMethodInfo WindowBeginPaintRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginPaintRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginPaintRegion"
        })


#endif

-- method Window::begin_resize_drag
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "edge"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowEdge" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the edge or corner from which the drag is started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the button being used to drag, or 0 for a keyboard-initiated drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window X coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window Y coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp of mouse click that began the drag (use gdk_event_get_time())"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_resize_drag" gdk_window_begin_resize_drag :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- edge : TInterface (Name {namespace = "Gdk", name = "WindowEdge"})
    Int32 ->                                -- button : TBasicType TInt
    Int32 ->                                -- root_x : TBasicType TInt
    Int32 ->                                -- root_y : TBasicType TInt
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Begins a window resize operation (for a toplevel window).
-- 
-- This function assumes that the drag is controlled by the
-- client pointer device, use 'GI.Gdk.Objects.Window.windowBeginResizeDragForDevice'
-- to begin a drag with a different device.
windowBeginResizeDrag ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Enums.WindowEdge
    -- ^ /@edge@/: the edge or corner from which the drag is started
    -> Int32
    -- ^ /@button@/: the button being used to drag, or 0 for a keyboard-initiated drag
    -> Int32
    -- ^ /@rootX@/: root window X coordinate of mouse click that began the drag
    -> Int32
    -- ^ /@rootY@/: root window Y coordinate of mouse click that began the drag
    -> Word32
    -- ^ /@timestamp@/: timestamp of mouse click that began the drag (use 'GI.Gdk.Unions.Event.eventGetTime')
    -> m ()
windowBeginResizeDrag window edge button rootX rootY timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let edge' = (fromIntegral . fromEnum) edge
    gdk_window_begin_resize_drag window' edge' button rootX rootY timestamp
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeginResizeDragMethodInfo
instance (signature ~ (Gdk.Enums.WindowEdge -> Int32 -> Int32 -> Int32 -> Word32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowBeginResizeDragMethodInfo a signature where
    overloadedMethod = windowBeginResizeDrag

instance O.OverloadedMethodInfo WindowBeginResizeDragMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginResizeDrag",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginResizeDrag"
        })


#endif

-- method Window::begin_resize_drag_for_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "edge"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowEdge" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the edge or corner from which the drag is started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device used for the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the button being used to drag, or 0 for a keyboard-initiated drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window X coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "root window Y coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp of mouse click that began the drag (use gdk_event_get_time())"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_begin_resize_drag_for_device" gdk_window_begin_resize_drag_for_device :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- edge : TInterface (Name {namespace = "Gdk", name = "WindowEdge"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Int32 ->                                -- button : TBasicType TInt
    Int32 ->                                -- root_x : TBasicType TInt
    Int32 ->                                -- root_y : TBasicType TInt
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Begins a window resize operation (for a toplevel window).
-- You might use this function to implement a “window resize grip,” for
-- example; in fact @/GtkStatusbar/@ uses it. The function works best
-- with window managers that support the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints>
-- but has a fallback implementation for other window managers.
-- 
-- /Since: 3.4/
windowBeginResizeDragForDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Enums.WindowEdge
    -- ^ /@edge@/: the edge or corner from which the drag is started
    -> b
    -- ^ /@device@/: the device used for the operation
    -> Int32
    -- ^ /@button@/: the button being used to drag, or 0 for a keyboard-initiated drag
    -> Int32
    -- ^ /@rootX@/: root window X coordinate of mouse click that began the drag
    -> Int32
    -- ^ /@rootY@/: root window Y coordinate of mouse click that began the drag
    -> Word32
    -- ^ /@timestamp@/: timestamp of mouse click that began the drag (use 'GI.Gdk.Unions.Event.eventGetTime')
    -> m ()
windowBeginResizeDragForDevice window edge device button rootX rootY timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let edge' = (fromIntegral . fromEnum) edge
    device' <- unsafeManagedPtrCastPtr device
    gdk_window_begin_resize_drag_for_device window' edge' device' button rootX rootY timestamp
    touchManagedPtr window
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowBeginResizeDragForDeviceMethodInfo
instance (signature ~ (Gdk.Enums.WindowEdge -> b -> Int32 -> Int32 -> Int32 -> Word32 -> m ()), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowBeginResizeDragForDeviceMethodInfo a signature where
    overloadedMethod = windowBeginResizeDragForDevice

instance O.OverloadedMethodInfo WindowBeginResizeDragForDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowBeginResizeDragForDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowBeginResizeDragForDevice"
        })


#endif

-- method Window::configure_finished
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_configure_finished" gdk_window_configure_finished :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

{-# DEPRECATED windowConfigureFinished ["(Since version 3.8)","this function is no longer needed"] #-}
-- | Does nothing, present only for compatiblity.
-- 
-- /Since: 2.6/
windowConfigureFinished ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowConfigureFinished window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_configure_finished window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowConfigureFinishedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowConfigureFinishedMethodInfo a signature where
    overloadedMethod = windowConfigureFinished

instance O.OverloadedMethodInfo WindowConfigureFinishedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowConfigureFinished",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowConfigureFinished"
        })


#endif

-- method Window::coords_from_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "X coordinate in parent\8217s coordinate system"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Y coordinate in parent\8217s coordinate system"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for X coordinate in child\8217s coordinate system"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for Y coordinate in child\8217s coordinate system"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_coords_from_parent" gdk_window_coords_from_parent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CDouble ->                              -- parent_x : TBasicType TDouble
    CDouble ->                              -- parent_y : TBasicType TDouble
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    IO ()

-- | Transforms window coordinates from a parent window to a child
-- window, where the parent window is the normal parent as returned by
-- 'GI.Gdk.Objects.Window.windowGetParent' for normal windows, and the window\'s
-- embedder as returned by 'GI.Gdk.Functions.offscreenWindowGetEmbedder' for
-- offscreen windows.
-- 
-- For normal windows, calling this function is equivalent to subtracting
-- the return values of 'GI.Gdk.Objects.Window.windowGetPosition' from the parent coordinates.
-- For offscreen windows however (which can be arbitrarily transformed),
-- this function calls the GdkWindow[fromEmbedder](#g:signal:fromEmbedder): signal to translate
-- the coordinates.
-- 
-- You should always use this function when writing generic code that
-- walks down a window hierarchy.
-- 
-- See also: 'GI.Gdk.Objects.Window.windowCoordsToParent'
-- 
-- /Since: 2.22/
windowCoordsFromParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a child window
    -> Double
    -- ^ /@parentX@/: X coordinate in parent’s coordinate system
    -> Double
    -- ^ /@parentY@/: Y coordinate in parent’s coordinate system
    -> m ((Double, Double))
windowCoordsFromParent window parentX parentY = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let parentX' = realToFrac parentX
    let parentY' = realToFrac parentY
    x <- allocMem :: IO (Ptr CDouble)
    y <- allocMem :: IO (Ptr CDouble)
    gdk_window_coords_from_parent window' parentX' parentY' x y
    x' <- peek x
    let x'' = realToFrac x'
    y' <- peek y
    let y'' = realToFrac y'
    touchManagedPtr window
    freeMem x
    freeMem y
    return (x'', y'')

#if defined(ENABLE_OVERLOADING)
data WindowCoordsFromParentMethodInfo
instance (signature ~ (Double -> Double -> m ((Double, Double))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowCoordsFromParentMethodInfo a signature where
    overloadedMethod = windowCoordsFromParent

instance O.OverloadedMethodInfo WindowCoordsFromParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowCoordsFromParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowCoordsFromParent"
        })


#endif

-- method Window::coords_to_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate in child\8217s coordinate system"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate in child\8217s coordinate system"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for X coordinate\nin parent\8217s coordinate system, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "parent_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for Y coordinate\nin parent\8217s coordinate system, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_coords_to_parent" gdk_window_coords_to_parent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    Ptr CDouble ->                          -- parent_x : TBasicType TDouble
    Ptr CDouble ->                          -- parent_y : TBasicType TDouble
    IO ()

-- | Transforms window coordinates from a child window to its parent
-- window, where the parent window is the normal parent as returned by
-- 'GI.Gdk.Objects.Window.windowGetParent' for normal windows, and the window\'s
-- embedder as returned by 'GI.Gdk.Functions.offscreenWindowGetEmbedder' for
-- offscreen windows.
-- 
-- For normal windows, calling this function is equivalent to adding
-- the return values of 'GI.Gdk.Objects.Window.windowGetPosition' to the child coordinates.
-- For offscreen windows however (which can be arbitrarily transformed),
-- this function calls the GdkWindow[toEmbedder](#g:signal:toEmbedder): signal to translate
-- the coordinates.
-- 
-- You should always use this function when writing generic code that
-- walks up a window hierarchy.
-- 
-- See also: 'GI.Gdk.Objects.Window.windowCoordsFromParent'
-- 
-- /Since: 2.22/
windowCoordsToParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a child window
    -> Double
    -- ^ /@x@/: X coordinate in child’s coordinate system
    -> Double
    -- ^ /@y@/: Y coordinate in child’s coordinate system
    -> m ((Double, Double))
windowCoordsToParent window x y = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let x' = realToFrac x
    let y' = realToFrac y
    parentX <- allocMem :: IO (Ptr CDouble)
    parentY <- allocMem :: IO (Ptr CDouble)
    gdk_window_coords_to_parent window' x' y' parentX parentY
    parentX' <- peek parentX
    let parentX'' = realToFrac parentX'
    parentY' <- peek parentY
    let parentY'' = realToFrac parentY'
    touchManagedPtr window
    freeMem parentX
    freeMem parentY
    return (parentX'', parentY'')

#if defined(ENABLE_OVERLOADING)
data WindowCoordsToParentMethodInfo
instance (signature ~ (Double -> Double -> m ((Double, Double))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowCoordsToParentMethodInfo a signature where
    overloadedMethod = windowCoordsToParent

instance O.OverloadedMethodInfo WindowCoordsToParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowCoordsToParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowCoordsToParent"
        })


#endif

-- method Window::create_gl_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GLContext" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_window_create_gl_context" gdk_window_create_gl_context :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gdk.GLContext.GLContext)

-- | Creates a new t'GI.Gdk.Objects.GLContext.GLContext' matching the
-- framebuffer format to the visual of the t'GI.Gdk.Objects.Window.Window'. The context
-- is disconnected from any particular window or surface.
-- 
-- If the creation of the t'GI.Gdk.Objects.GLContext.GLContext' failed, /@error@/ will be set.
-- 
-- Before using the returned t'GI.Gdk.Objects.GLContext.GLContext', you will need to
-- call 'GI.Gdk.Objects.GLContext.gLContextMakeCurrent' or 'GI.Gdk.Objects.GLContext.gLContextRealize'.
-- 
-- /Since: 3.16/
windowCreateGlContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.GLContext.GLContext
    -- ^ __Returns:__ the newly created t'GI.Gdk.Objects.GLContext.GLContext', or
    -- 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
windowCreateGlContext window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    onException (do
        result <- propagateGError $ gdk_window_create_gl_context window'
        checkUnexpectedReturnNULL "windowCreateGlContext" result
        result' <- (wrapObject Gdk.GLContext.GLContext) result
        touchManagedPtr window
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data WindowCreateGlContextMethodInfo
instance (signature ~ (m Gdk.GLContext.GLContext), MonadIO m, IsWindow a) => O.OverloadedMethod WindowCreateGlContextMethodInfo a signature where
    overloadedMethod = windowCreateGlContext

instance O.OverloadedMethodInfo WindowCreateGlContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowCreateGlContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowCreateGlContext"
        })


#endif

-- method Window::create_similar_image_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "window to make new surface similar to, or\n  %NULL if none"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Format" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the format for the new surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width of the new surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "height of the new surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the scale of the new surface, or 0 to use same as @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_create_similar_image_surface" gdk_window_create_similar_image_surface :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- format : TInterface (Name {namespace = "cairo", name = "Format"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    Int32 ->                                -- scale : TBasicType TInt
    IO (Ptr Cairo.Surface.Surface)

-- | Create a new image surface that is efficient to draw on the
-- given /@window@/.
-- 
-- Initially the surface contents are all 0 (transparent if contents
-- have transparency, black otherwise.)
-- 
-- The /@width@/ and /@height@/ of the new surface are not affected by
-- the scaling factor of the /@window@/, or by the /@scale@/ argument; they
-- are the size of the surface in device pixels. If you wish to create
-- an image surface capable of holding the contents of /@window@/ you can
-- use:
-- 
-- 
-- === /C code/
-- >
-- >  int scale = gdk_window_get_scale_factor (window);
-- >  int width = gdk_window_get_width (window) * scale;
-- >  int height = gdk_window_get_height (window) * scale;
-- >
-- >  // format is set elsewhere
-- >  cairo_surface_t *surface =
-- >    gdk_window_create_similar_image_surface (window,
-- >                                             format,
-- >                                             width, height,
-- >                                             scale);
-- 
-- 
-- Note that unlike @/cairo_surface_create_similar_image()/@, the new
-- surface\'s device scale is set to /@scale@/, or to the scale factor of
-- /@window@/ if /@scale@/ is 0.
-- 
-- /Since: 3.10/
windowCreateSimilarImageSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    Maybe (a)
    -- ^ /@window@/: window to make new surface similar to, or
    --   'P.Nothing' if none
    -> Cairo.Enums.Format
    -- ^ /@format@/: the format for the new surface
    -> Int32
    -- ^ /@width@/: width of the new surface
    -> Int32
    -- ^ /@height@/: height of the new surface
    -> Int32
    -- ^ /@scale@/: the scale of the new surface, or 0 to use same as /@window@/
    -> m Cairo.Surface.Surface
    -- ^ __Returns:__ a pointer to the newly allocated surface. The caller
    -- owns the surface and should call @/cairo_surface_destroy()/@ when done
    -- with it.
    -- 
    -- This function always returns a valid pointer, but it will return a
    -- pointer to a “nil” surface if /@other@/ is already in an error state
    -- or any other error occurs.
windowCreateSimilarImageSurface window format width height scale = liftIO $ do
    maybeWindow <- case window of
        Nothing -> return FP.nullPtr
        Just jWindow -> do
            jWindow' <- unsafeManagedPtrCastPtr jWindow
            return jWindow'
    let format' = (fromIntegral . fromEnum) format
    result <- gdk_window_create_similar_image_surface maybeWindow format' width height scale
    checkUnexpectedReturnNULL "windowCreateSimilarImageSurface" result
    result' <- (wrapBoxed Cairo.Surface.Surface) result
    whenJust window touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowCreateSimilarImageSurfaceMethodInfo
instance (signature ~ (Cairo.Enums.Format -> Int32 -> Int32 -> Int32 -> m Cairo.Surface.Surface), MonadIO m, IsWindow a) => O.OverloadedMethod WindowCreateSimilarImageSurfaceMethodInfo a signature where
    overloadedMethod i = windowCreateSimilarImageSurface (Just i)

instance O.OverloadedMethodInfo WindowCreateSimilarImageSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowCreateSimilarImageSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowCreateSimilarImageSurface"
        })


#endif

-- method Window::create_similar_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window to make new surface similar to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Content" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content for the new surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width of the new surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "height of the new surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_create_similar_surface" gdk_window_create_similar_surface :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- content : TInterface (Name {namespace = "cairo", name = "Content"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO (Ptr Cairo.Surface.Surface)

-- | Create a new surface that is as compatible as possible with the
-- given /@window@/. For example the new surface will have the same
-- fallback resolution and font options as /@window@/. Generally, the new
-- surface will also use the same backend as /@window@/, unless that is
-- not possible for some reason. The type of the returned surface may
-- be examined with @/cairo_surface_get_type()/@.
-- 
-- Initially the surface contents are all 0 (transparent if contents
-- have transparency, black otherwise.)
-- 
-- /Since: 2.22/
windowCreateSimilarSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: window to make new surface similar to
    -> Cairo.Enums.Content
    -- ^ /@content@/: the content for the new surface
    -> Int32
    -- ^ /@width@/: width of the new surface
    -> Int32
    -- ^ /@height@/: height of the new surface
    -> m Cairo.Surface.Surface
    -- ^ __Returns:__ a pointer to the newly allocated surface. The caller
    -- owns the surface and should call @/cairo_surface_destroy()/@ when done
    -- with it.
    -- 
    -- This function always returns a valid pointer, but it will return a
    -- pointer to a “nil” surface if /@other@/ is already in an error state
    -- or any other error occurs.
windowCreateSimilarSurface window content width height = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let content' = (fromIntegral . fromEnum) content
    result <- gdk_window_create_similar_surface window' content' width height
    checkUnexpectedReturnNULL "windowCreateSimilarSurface" result
    result' <- (wrapBoxed Cairo.Surface.Surface) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowCreateSimilarSurfaceMethodInfo
instance (signature ~ (Cairo.Enums.Content -> Int32 -> Int32 -> m Cairo.Surface.Surface), MonadIO m, IsWindow a) => O.OverloadedMethod WindowCreateSimilarSurfaceMethodInfo a signature where
    overloadedMethod = windowCreateSimilarSurface

instance O.OverloadedMethodInfo WindowCreateSimilarSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowCreateSimilarSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowCreateSimilarSurface"
        })


#endif

-- method Window::deiconify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_deiconify" gdk_window_deiconify :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Attempt to deiconify (unminimize) /@window@/. On X11 the window manager may
-- choose to ignore the request to deiconify. When using GTK+,
-- use @/gtk_window_deiconify()/@ instead of the t'GI.Gdk.Objects.Window.Window' variant. Or better yet,
-- you probably want to use @/gtk_window_present_with_time()/@, which raises the window, focuses it,
-- unminimizes it, and puts it on the current desktop.
windowDeiconify ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowDeiconify window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_deiconify window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowDeiconifyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowDeiconifyMethodInfo a signature where
    overloadedMethod = windowDeiconify

instance O.OverloadedMethodInfo WindowDeiconifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowDeiconify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowDeiconify"
        })


#endif

-- method Window::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_destroy" gdk_window_destroy :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Destroys the window system resources associated with /@window@/ and decrements /@window@/\'s
-- reference count. The window system resources for all children of /@window@/ are also
-- destroyed, but the children’s reference counts are not decremented.
-- 
-- Note that a window will not be destroyed automatically when its reference count
-- reaches zero. You must call this function yourself before that happens.
windowDestroy ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowDestroy window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_destroy window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowDestroyMethodInfo a signature where
    overloadedMethod = windowDestroy

instance O.OverloadedMethodInfo WindowDestroyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowDestroy"
        })


#endif

-- method Window::destroy_notify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_destroy_notify" gdk_window_destroy_notify :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | /No description available in the introspection data./
windowDestroyNotify ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -> m ()
windowDestroyNotify window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_destroy_notify window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowDestroyNotifyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowDestroyNotifyMethodInfo a signature where
    overloadedMethod = windowDestroyNotify

instance O.OverloadedMethodInfo WindowDestroyNotifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowDestroyNotify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowDestroyNotify"
        })


#endif

-- method Window::enable_synchronized_configure
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_enable_synchronized_configure" gdk_window_enable_synchronized_configure :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

{-# DEPRECATED windowEnableSynchronizedConfigure ["(Since version 3.8)","this function is no longer needed"] #-}
-- | Does nothing, present only for compatiblity.
-- 
-- /Since: 2.6/
windowEnableSynchronizedConfigure ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowEnableSynchronizedConfigure window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_enable_synchronized_configure window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowEnableSynchronizedConfigureMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowEnableSynchronizedConfigureMethodInfo a signature where
    overloadedMethod = windowEnableSynchronizedConfigure

instance O.OverloadedMethodInfo WindowEnableSynchronizedConfigureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowEnableSynchronizedConfigure",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowEnableSynchronizedConfigure"
        })


#endif

-- method Window::end_draw_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawingContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GdkDrawingContext created by gdk_window_begin_draw_frame()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_end_draw_frame" gdk_window_end_draw_frame :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.DrawingContext.DrawingContext -> -- context : TInterface (Name {namespace = "Gdk", name = "DrawingContext"})
    IO ()

-- | Indicates that the drawing of the contents of /@window@/ started with
-- @/gdk_window_begin_frame()/@ has been completed.
-- 
-- This function will take care of destroying the t'GI.Gdk.Objects.DrawingContext.DrawingContext'.
-- 
-- It is an error to call this function without a matching
-- @/gdk_window_begin_frame()/@ first.
-- 
-- /Since: 3.22/
windowEndDrawFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.DrawingContext.IsDrawingContext b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@context@/: the t'GI.Gdk.Objects.DrawingContext.DrawingContext' created by 'GI.Gdk.Objects.Window.windowBeginDrawFrame'
    -> m ()
windowEndDrawFrame window context = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    context' <- unsafeManagedPtrCastPtr context
    gdk_window_end_draw_frame window' context'
    touchManagedPtr window
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowEndDrawFrameMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsWindow a, Gdk.DrawingContext.IsDrawingContext b) => O.OverloadedMethod WindowEndDrawFrameMethodInfo a signature where
    overloadedMethod = windowEndDrawFrame

instance O.OverloadedMethodInfo WindowEndDrawFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowEndDrawFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowEndDrawFrame"
        })


#endif

-- method Window::end_paint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_end_paint" gdk_window_end_paint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Indicates that the backing store created by the most recent call
-- to 'GI.Gdk.Objects.Window.windowBeginPaintRegion' should be copied onscreen and
-- deleted, leaving the next-most-recent backing store or no backing
-- store at all as the active paint region. See
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion' for full details.
-- 
-- It is an error to call this function without a matching
-- 'GI.Gdk.Objects.Window.windowBeginPaintRegion' first.
windowEndPaint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowEndPaint window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_end_paint window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowEndPaintMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowEndPaintMethodInfo a signature where
    overloadedMethod = windowEndPaint

instance O.OverloadedMethodInfo WindowEndPaintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowEndPaint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowEndPaint"
        })


#endif

-- method Window::ensure_native
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_ensure_native" gdk_window_ensure_native :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Tries to ensure that there is a window-system native window for this
-- GdkWindow. This may fail in some situations, returning 'P.False'.
-- 
-- Offscreen window and children of them can never have native windows.
-- 
-- Some backends may not support native child windows.
-- 
-- /Since: 2.18/
windowEnsureNative ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window has a native window, 'P.False' otherwise
windowEnsureNative window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_ensure_native window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowEnsureNativeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowEnsureNativeMethodInfo a signature where
    overloadedMethod = windowEnsureNative

instance O.OverloadedMethodInfo WindowEnsureNativeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowEnsureNative",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowEnsureNative"
        })


#endif

-- method Window::flush
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_flush" gdk_window_flush :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

{-# DEPRECATED windowFlush ["(Since version 3.14)"] #-}
-- | This function does nothing.
-- 
-- /Since: 2.18/
windowFlush ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowFlush window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_flush window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFlushMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFlushMethodInfo a signature where
    overloadedMethod = windowFlush

instance O.OverloadedMethodInfo WindowFlushMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowFlush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowFlush"
        })


#endif

-- method Window::focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "timestamp of the event triggering the window focus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_focus" gdk_window_focus :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Sets keyboard focus to /@window@/. In most cases, @/gtk_window_present_with_time()/@
-- should be used on a @/GtkWindow/@, rather than calling this function.
windowFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Word32
    -- ^ /@timestamp@/: timestamp of the event triggering the window focus
    -> m ()
windowFocus window timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_focus window' timestamp
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFocusMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFocusMethodInfo a signature where
    overloadedMethod = windowFocus

instance O.OverloadedMethodInfo WindowFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowFocus"
        })


#endif

-- method Window::freeze_toplevel_updates_libgtk_only
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_freeze_toplevel_updates_libgtk_only" gdk_window_freeze_toplevel_updates_libgtk_only :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

{-# DEPRECATED windowFreezeToplevelUpdatesLibgtkOnly ["(Since version 3.16)","This symbol was never meant to be used outside of GTK+"] #-}
-- | Temporarily freezes a window and all its descendants such that it won\'t
-- receive expose events.  The window will begin receiving expose events
-- again when 'GI.Gdk.Objects.Window.windowThawToplevelUpdatesLibgtkOnly' is called. If
-- 'GI.Gdk.Objects.Window.windowFreezeToplevelUpdatesLibgtkOnly'
-- has been called more than once,
-- 'GI.Gdk.Objects.Window.windowThawToplevelUpdatesLibgtkOnly' must be called
-- an equal number of times to begin processing exposes.
-- 
-- This function is not part of the GDK public API and is only
-- for use by GTK+.
windowFreezeToplevelUpdatesLibgtkOnly ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowFreezeToplevelUpdatesLibgtkOnly window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_freeze_toplevel_updates_libgtk_only window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFreezeToplevelUpdatesLibgtkOnlyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFreezeToplevelUpdatesLibgtkOnlyMethodInfo a signature where
    overloadedMethod = windowFreezeToplevelUpdatesLibgtkOnly

instance O.OverloadedMethodInfo WindowFreezeToplevelUpdatesLibgtkOnlyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowFreezeToplevelUpdatesLibgtkOnly",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowFreezeToplevelUpdatesLibgtkOnly"
        })


#endif

-- method Window::freeze_updates
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_freeze_updates" gdk_window_freeze_updates :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Temporarily freezes a window such that it won’t receive expose
-- events.  The window will begin receiving expose events again when
-- 'GI.Gdk.Objects.Window.windowThawUpdates' is called. If 'GI.Gdk.Objects.Window.windowFreezeUpdates'
-- has been called more than once, 'GI.Gdk.Objects.Window.windowThawUpdates' must be called
-- an equal number of times to begin processing exposes.
windowFreezeUpdates ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowFreezeUpdates window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_freeze_updates window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFreezeUpdatesMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFreezeUpdatesMethodInfo a signature where
    overloadedMethod = windowFreezeUpdates

instance O.OverloadedMethodInfo WindowFreezeUpdatesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowFreezeUpdates",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowFreezeUpdates"
        })


#endif

-- method Window::fullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_fullscreen" gdk_window_fullscreen :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Moves the window into fullscreen mode. This means the
-- window covers the entire screen and is above any panels
-- or task bars.
-- 
-- If the window was already fullscreen, then this function does nothing.
-- 
-- On X11, asks the window manager to put /@window@/ in a fullscreen
-- state, if the window manager supports this operation. Not all
-- window managers support this, and some deliberately ignore it or
-- don’t have a concept of “fullscreen”; so you can’t rely on the
-- fullscreenification actually happening. But it will happen with
-- most standard window managers, and GDK makes a best effort to get
-- it to happen.
-- 
-- /Since: 2.2/
windowFullscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowFullscreen window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_fullscreen window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFullscreenMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFullscreenMethodInfo a signature where
    overloadedMethod = windowFullscreen

instance O.OverloadedMethodInfo WindowFullscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowFullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowFullscreen"
        })


#endif

-- method Window::fullscreen_on_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Which monitor to display fullscreen on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_fullscreen_on_monitor" gdk_window_fullscreen_on_monitor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- monitor : TBasicType TInt
    IO ()

-- | Moves the window into fullscreen mode on the given monitor. This means
-- the window covers the entire screen and is above any panels or task bars.
-- 
-- If the window was already fullscreen, then this function does nothing.
windowFullscreenOnMonitor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@monitor@/: Which monitor to display fullscreen on.
    -> m ()
windowFullscreenOnMonitor window monitor = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_fullscreen_on_monitor window' monitor
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFullscreenOnMonitorMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFullscreenOnMonitorMethodInfo a signature where
    overloadedMethod = windowFullscreenOnMonitor

instance O.OverloadedMethodInfo WindowFullscreenOnMonitorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowFullscreenOnMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowFullscreenOnMonitor"
        })


#endif

-- method Window::geometry_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an embedded offscreen #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_geometry_changed" gdk_window_geometry_changed :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | This function informs GDK that the geometry of an embedded
-- offscreen window has changed. This is necessary for GDK to keep
-- track of which offscreen window the pointer is in.
-- 
-- /Since: 2.18/
windowGeometryChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: an embedded offscreen t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowGeometryChanged window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_geometry_changed window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowGeometryChangedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGeometryChangedMethodInfo a signature where
    overloadedMethod = windowGeometryChanged

instance O.OverloadedMethodInfo WindowGeometryChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGeometryChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGeometryChanged"
        })


#endif

-- method Window::get_accept_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_accept_focus" gdk_window_get_accept_focus :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Determines whether or not the desktop environment shuld be hinted that
-- the window does not want to receive input focus.
-- 
-- /Since: 2.22/
windowGetAcceptFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'.
    -> m Bool
    -- ^ __Returns:__ whether or not the window should receive input focus.
windowGetAcceptFocus window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_accept_focus window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetAcceptFocusMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetAcceptFocusMethodInfo a signature where
    overloadedMethod = windowGetAcceptFocus

instance O.OverloadedMethodInfo WindowGetAcceptFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetAcceptFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetAcceptFocus"
        })


#endif

-- method Window::get_background_pattern
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Pattern" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_background_pattern" gdk_window_get_background_pattern :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Pattern.Pattern)

{-# DEPRECATED windowGetBackgroundPattern ["(Since version 3.22)","Don\\'t use this function"] #-}
-- | Gets the pattern used to clear the background on /@window@/.
-- 
-- /Since: 2.22/
windowGetBackgroundPattern ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Cairo.Pattern.Pattern)
    -- ^ __Returns:__ The pattern to use for the
    -- background or 'P.Nothing' if there is no background.
windowGetBackgroundPattern window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_background_pattern window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Cairo.Pattern.Pattern) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetBackgroundPatternMethodInfo
instance (signature ~ (m (Maybe Cairo.Pattern.Pattern)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetBackgroundPatternMethodInfo a signature where
    overloadedMethod = windowGetBackgroundPattern

instance O.OverloadedMethodInfo WindowGetBackgroundPatternMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetBackgroundPattern",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetBackgroundPattern"
        })


#endif

-- method Window::get_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Window" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_children" gdk_window_get_children :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr (GList (Ptr Window)))

-- | Gets the list of children of /@window@/ known to GDK.
-- This function only returns children created via GDK,
-- so for example it’s useless when used with the root window;
-- it only returns windows an application created itself.
-- 
-- The returned list must be freed, but the elements in the
-- list need not be.
windowGetChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m [Window]
    -- ^ __Returns:__ 
    --     list of child windows inside /@window@/
windowGetChildren window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_children window'
    result' <- unpackGList result
    result'' <- mapM (newObject Window) result'
    g_list_free result
    touchManagedPtr window
    return result''

#if defined(ENABLE_OVERLOADING)
data WindowGetChildrenMethodInfo
instance (signature ~ (m [Window]), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetChildrenMethodInfo a signature where
    overloadedMethod = windowGetChildren

instance O.OverloadedMethodInfo WindowGetChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetChildren"
        })


#endif

-- method Window::get_children_with_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to look for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Window" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_children_with_user_data" gdk_window_get_children_with_user_data :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO (Ptr (GList (Ptr Window)))

-- | Gets the list of children of /@window@/ known to GDK with a
-- particular /@userData@/ set on it.
-- 
-- The returned list must be freed, but the elements in the
-- list need not be.
-- 
-- The list is returned in (relative) stacking order, i.e. the
-- lowest window is first.
-- 
-- /Since: 3.10/
windowGetChildrenWithUserData ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Ptr ()
    -- ^ /@userData@/: user data to look for
    -> m [Window]
    -- ^ __Returns:__ 
    --     list of child windows inside /@window@/
windowGetChildrenWithUserData window userData = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_children_with_user_data window' userData
    result' <- unpackGList result
    result'' <- mapM (newObject Window) result'
    g_list_free result
    touchManagedPtr window
    return result''

#if defined(ENABLE_OVERLOADING)
data WindowGetChildrenWithUserDataMethodInfo
instance (signature ~ (Ptr () -> m [Window]), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetChildrenWithUserDataMethodInfo a signature where
    overloadedMethod = windowGetChildrenWithUserData

instance O.OverloadedMethodInfo WindowGetChildrenWithUserDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetChildrenWithUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetChildrenWithUserData"
        })


#endif

-- method Window::get_clip_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_clip_region" gdk_window_get_clip_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Region.Region)

-- | Computes the region of a window that potentially can be written
-- to by drawing primitives. This region may not take into account
-- other factors such as if the window is obscured by other windows,
-- but no area outside of this region will be affected by drawing
-- primitives.
windowGetClipRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Cairo.Region.Region
    -- ^ __Returns:__ a t'GI.Cairo.Structs.Region.Region'. This must be freed with @/cairo_region_destroy()/@
    --          when you are done.
windowGetClipRegion window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_clip_region window'
    checkUnexpectedReturnNULL "windowGetClipRegion" result
    result' <- (wrapBoxed Cairo.Region.Region) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetClipRegionMethodInfo
instance (signature ~ (m Cairo.Region.Region), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetClipRegionMethodInfo a signature where
    overloadedMethod = windowGetClipRegion

instance O.OverloadedMethodInfo WindowGetClipRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetClipRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetClipRegion"
        })


#endif

-- method Window::get_composited
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_composited" gdk_window_get_composited :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

{-# DEPRECATED windowGetComposited ["(Since version 3.16)","Compositing is an outdated technology that","  only ever worked on X11."] #-}
-- | Determines whether /@window@/ is composited.
-- 
-- See 'GI.Gdk.Objects.Window.windowSetComposited'.
-- 
-- /Since: 2.22/
windowGetComposited ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window is composited.
windowGetComposited window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_composited window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetCompositedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetCompositedMethodInfo a signature where
    overloadedMethod = windowGetComposited

instance O.OverloadedMethodInfo WindowGetCompositedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetComposited",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetComposited"
        })


#endif

-- method Window::get_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_cursor" gdk_window_get_cursor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.Cursor.Cursor)

-- | Retrieves a t'GI.Gdk.Objects.Cursor.Cursor' pointer for the cursor currently set on the
-- specified t'GI.Gdk.Objects.Window.Window', or 'P.Nothing'.  If the return value is 'P.Nothing' then
-- there is no custom cursor set on the specified window, and it is
-- using the cursor for its parent window.
-- 
-- /Since: 2.18/
windowGetCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m (Maybe Gdk.Cursor.Cursor)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Cursor.Cursor', or 'P.Nothing'. The
    --   returned object is owned by the t'GI.Gdk.Objects.Window.Window' and should not be
    --   unreferenced directly. Use 'GI.Gdk.Objects.Window.windowSetCursor' to unset the
    --   cursor of the window
windowGetCursor window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_cursor window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Cursor.Cursor) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetCursorMethodInfo
instance (signature ~ (m (Maybe Gdk.Cursor.Cursor)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetCursorMethodInfo a signature where
    overloadedMethod = windowGetCursor

instance O.OverloadedMethodInfo WindowGetCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetCursor"
        })


#endif

-- method Window::get_decorations
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The toplevel #GdkWindow to get the decorations from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "decorations"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WMDecoration" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The window decorations will be written here"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_decorations" gdk_window_get_decorations :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr CUInt ->                            -- decorations : TInterface (Name {namespace = "Gdk", name = "WMDecoration"})
    IO CInt

-- | Returns the decorations set on the GdkWindow with
-- 'GI.Gdk.Objects.Window.windowSetDecorations'.
windowGetDecorations ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: The toplevel t'GI.Gdk.Objects.Window.Window' to get the decorations from
    -> m ((Bool, [Gdk.Flags.WMDecoration]))
    -- ^ __Returns:__ 'P.True' if the window has decorations set, 'P.False' otherwise.
windowGetDecorations window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    decorations <- allocMem :: IO (Ptr CUInt)
    result <- gdk_window_get_decorations window' decorations
    let result' = (/= 0) result
    decorations' <- peek decorations
    let decorations'' = wordToGFlags decorations'
    touchManagedPtr window
    freeMem decorations
    return (result', decorations'')

#if defined(ENABLE_OVERLOADING)
data WindowGetDecorationsMethodInfo
instance (signature ~ (m ((Bool, [Gdk.Flags.WMDecoration]))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDecorationsMethodInfo a signature where
    overloadedMethod = windowGetDecorations

instance O.OverloadedMethodInfo WindowGetDecorationsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDecorations",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDecorations"
        })


#endif

-- method Window::get_device_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a master, pointer #GdkDevice."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Cursor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_device_cursor" gdk_window_get_device_cursor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.Cursor.Cursor)

-- | Retrieves a t'GI.Gdk.Objects.Cursor.Cursor' pointer for the /@device@/ currently set on the
-- specified t'GI.Gdk.Objects.Window.Window', or 'P.Nothing'.  If the return value is 'P.Nothing' then
-- there is no custom cursor set on the specified window, and it is
-- using the cursor for its parent window.
-- 
-- /Since: 3.0/
windowGetDeviceCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> b
    -- ^ /@device@/: a master, pointer t'GI.Gdk.Objects.Device.Device'.
    -> m (Maybe Gdk.Cursor.Cursor)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Cursor.Cursor', or 'P.Nothing'. The
    --   returned object is owned by the t'GI.Gdk.Objects.Window.Window' and should not be
    --   unreferenced directly. Use 'GI.Gdk.Objects.Window.windowSetCursor' to unset the
    --   cursor of the window
windowGetDeviceCursor window device = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_window_get_device_cursor window' device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Cursor.Cursor) result'
        return result''
    touchManagedPtr window
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetDeviceCursorMethodInfo
instance (signature ~ (b -> m (Maybe Gdk.Cursor.Cursor)), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowGetDeviceCursorMethodInfo a signature where
    overloadedMethod = windowGetDeviceCursor

instance O.OverloadedMethodInfo WindowGetDeviceCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDeviceCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDeviceCursor"
        })


#endif

-- method Window::get_device_events
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "EventMask" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_device_events" gdk_window_get_device_events :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Returns the event mask for /@window@/ corresponding to an specific device.
-- 
-- /Since: 3.0/
windowGetDeviceEvents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> b
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'.
    -> m [Gdk.Flags.EventMask]
    -- ^ __Returns:__ device event mask for /@window@/
windowGetDeviceEvents window device = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_window_get_device_events window' device'
    let result' = wordToGFlags result
    touchManagedPtr window
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetDeviceEventsMethodInfo
instance (signature ~ (b -> m [Gdk.Flags.EventMask]), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowGetDeviceEventsMethodInfo a signature where
    overloadedMethod = windowGetDeviceEvents

instance O.OverloadedMethodInfo WindowGetDeviceEventsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDeviceEvents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDeviceEvents"
        })


#endif

-- method Window::get_device_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer #GdkDevice to query to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the X coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the Y coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the modifier mask, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_device_position" gdk_window_get_device_position :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    Ptr CUInt ->                            -- mask : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO (Ptr Window)

-- | Obtains the current device position and modifier state.
-- The position is given in coordinates relative to the upper left
-- corner of /@window@/.
-- 
-- Use 'GI.Gdk.Objects.Window.windowGetDevicePositionDouble' if you need subpixel precision.
-- 
-- /Since: 3.0/
windowGetDevicePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> b
    -- ^ /@device@/: pointer t'GI.Gdk.Objects.Device.Device' to query to.
    -> m ((Maybe Window, Int32, Int32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ The window underneath /@device@/
    -- (as with 'GI.Gdk.Objects.Device.deviceGetWindowAtPosition'), or 'P.Nothing' if the
    -- window is not known to GDK.
windowGetDevicePosition window device = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    mask <- allocMem :: IO (Ptr CUInt)
    result <- gdk_window_get_device_position window' device' x y mask
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Window) result'
        return result''
    x' <- peek x
    y' <- peek y
    mask' <- peek mask
    let mask'' = wordToGFlags mask'
    touchManagedPtr window
    touchManagedPtr device
    freeMem x
    freeMem y
    freeMem mask
    return (maybeResult, x', y', mask'')

#if defined(ENABLE_OVERLOADING)
data WindowGetDevicePositionMethodInfo
instance (signature ~ (b -> m ((Maybe Window, Int32, Int32, [Gdk.Flags.ModifierType]))), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowGetDevicePositionMethodInfo a signature where
    overloadedMethod = windowGetDevicePosition

instance O.OverloadedMethodInfo WindowGetDevicePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDevicePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDevicePosition"
        })


#endif

-- method Window::get_device_position_double
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer #GdkDevice to query to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the X coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the Y coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the modifier mask, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_device_position_double" gdk_window_get_device_position_double :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    Ptr CUInt ->                            -- mask : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO (Ptr Window)

-- | Obtains the current device position in doubles and modifier state.
-- The position is given in coordinates relative to the upper left
-- corner of /@window@/.
-- 
-- /Since: 3.10/
windowGetDevicePositionDouble ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> b
    -- ^ /@device@/: pointer t'GI.Gdk.Objects.Device.Device' to query to.
    -> m ((Maybe Window, Double, Double, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ The window underneath /@device@/
    -- (as with 'GI.Gdk.Objects.Device.deviceGetWindowAtPosition'), or 'P.Nothing' if the
    -- window is not known to GDK.
windowGetDevicePositionDouble window device = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    x <- allocMem :: IO (Ptr CDouble)
    y <- allocMem :: IO (Ptr CDouble)
    mask <- allocMem :: IO (Ptr CUInt)
    result <- gdk_window_get_device_position_double window' device' x y mask
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Window) result'
        return result''
    x' <- peek x
    let x'' = realToFrac x'
    y' <- peek y
    let y'' = realToFrac y'
    mask' <- peek mask
    let mask'' = wordToGFlags mask'
    touchManagedPtr window
    touchManagedPtr device
    freeMem x
    freeMem y
    freeMem mask
    return (maybeResult, x'', y'', mask'')

#if defined(ENABLE_OVERLOADING)
data WindowGetDevicePositionDoubleMethodInfo
instance (signature ~ (b -> m ((Maybe Window, Double, Double, [Gdk.Flags.ModifierType]))), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowGetDevicePositionDoubleMethodInfo a signature where
    overloadedMethod = windowGetDevicePositionDouble

instance O.OverloadedMethodInfo WindowGetDevicePositionDoubleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDevicePositionDouble",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDevicePositionDouble"
        })


#endif

-- method Window::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_display" gdk_window_get_display :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the t'GI.Gdk.Objects.Display.Display' associated with a t'GI.Gdk.Objects.Window.Window'.
-- 
-- /Since: 2.24/
windowGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Display.Display
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Display.Display' associated with /@window@/
windowGetDisplay window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_display window'
    checkUnexpectedReturnNULL "windowGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDisplayMethodInfo a signature where
    overloadedMethod = windowGetDisplay

instance O.OverloadedMethodInfo WindowGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDisplay"
        })


#endif

-- method Window::get_drag_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the destination window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location of the window\n   where the drop should happen. This may be @window or a proxy window,\n   or %NULL if @window does not support Drag and Drop."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DragProtocol" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_drag_protocol" gdk_window_get_drag_protocol :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr (Ptr Window) ->                     -- target : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CUInt

-- | Finds out the DND protocol supported by a window.
-- 
-- /Since: 3.0/
windowGetDragProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: the destination window
    -> m ((Gdk.Enums.DragProtocol, Window))
    -- ^ __Returns:__ the supported DND protocol.
windowGetDragProtocol window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    target <- callocMem :: IO (Ptr (Ptr Window))
    result <- gdk_window_get_drag_protocol window' target
    let result' = (toEnum . fromIntegral) result
    target' <- peek target
    target'' <- (wrapObject Window) target'
    touchManagedPtr window
    freeMem target
    return (result', target'')

#if defined(ENABLE_OVERLOADING)
data WindowGetDragProtocolMethodInfo
instance (signature ~ (m ((Gdk.Enums.DragProtocol, Window))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDragProtocolMethodInfo a signature where
    overloadedMethod = windowGetDragProtocol

instance O.OverloadedMethodInfo WindowGetDragProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetDragProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetDragProtocol"
        })


#endif

-- method Window::get_effective_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_effective_parent" gdk_window_get_effective_parent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Window)

-- | Obtains the parent of /@window@/, as known to GDK. Works like
-- 'GI.Gdk.Objects.Window.windowGetParent' for normal windows, but returns the
-- window’s embedder for offscreen windows.
-- 
-- See also: 'GI.Gdk.Functions.offscreenWindowGetEmbedder'
-- 
-- /Since: 2.22/
windowGetEffectiveParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Window
    -- ^ __Returns:__ effective parent of /@window@/
windowGetEffectiveParent window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_effective_parent window'
    checkUnexpectedReturnNULL "windowGetEffectiveParent" result
    result' <- (newObject Window) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetEffectiveParentMethodInfo
instance (signature ~ (m Window), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetEffectiveParentMethodInfo a signature where
    overloadedMethod = windowGetEffectiveParent

instance O.OverloadedMethodInfo WindowGetEffectiveParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetEffectiveParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetEffectiveParent"
        })


#endif

-- method Window::get_effective_toplevel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_effective_toplevel" gdk_window_get_effective_toplevel :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Window)

-- | Gets the toplevel window that’s an ancestor of /@window@/.
-- 
-- Works like 'GI.Gdk.Objects.Window.windowGetToplevel', but treats an offscreen window\'s
-- embedder as its parent, using 'GI.Gdk.Objects.Window.windowGetEffectiveParent'.
-- 
-- See also: 'GI.Gdk.Functions.offscreenWindowGetEmbedder'
-- 
-- /Since: 2.22/
windowGetEffectiveToplevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Window
    -- ^ __Returns:__ the effective toplevel window containing /@window@/
windowGetEffectiveToplevel window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_effective_toplevel window'
    checkUnexpectedReturnNULL "windowGetEffectiveToplevel" result
    result' <- (newObject Window) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetEffectiveToplevelMethodInfo
instance (signature ~ (m Window), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetEffectiveToplevelMethodInfo a signature where
    overloadedMethod = windowGetEffectiveToplevel

instance O.OverloadedMethodInfo WindowGetEffectiveToplevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetEffectiveToplevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetEffectiveToplevel"
        })


#endif

-- method Window::get_event_compression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_event_compression" gdk_window_get_event_compression :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Get the current event compression setting for this window.
-- 
-- /Since: 3.12/
windowGetEventCompression ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if motion events will be compressed
windowGetEventCompression window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_event_compression window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetEventCompressionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetEventCompressionMethodInfo a signature where
    overloadedMethod = windowGetEventCompression

instance O.OverloadedMethodInfo WindowGetEventCompressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetEventCompression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetEventCompression"
        })


#endif

-- method Window::get_events
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "EventMask" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_events" gdk_window_get_events :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CUInt

-- | Gets the event mask for /@window@/ for all master input devices. See
-- 'GI.Gdk.Objects.Window.windowSetEvents'.
windowGetEvents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m [Gdk.Flags.EventMask]
    -- ^ __Returns:__ event mask for /@window@/
windowGetEvents window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_events window'
    let result' = wordToGFlags result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetEventsMethodInfo
instance (signature ~ (m [Gdk.Flags.EventMask]), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetEventsMethodInfo a signature where
    overloadedMethod = windowGetEvents

instance O.OverloadedMethodInfo WindowGetEventsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetEvents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetEvents"
        })


#endif

-- method Window::get_focus_on_map
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_focus_on_map" gdk_window_get_focus_on_map :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Determines whether or not the desktop environment should be hinted that the
-- window does not want to receive input focus when it is mapped.
-- 
-- /Since: 2.22/
windowGetFocusOnMap ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'.
    -> m Bool
    -- ^ __Returns:__ whether or not the window wants to receive input focus when
    -- it is mapped.
windowGetFocusOnMap window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_focus_on_map window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetFocusOnMapMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetFocusOnMapMethodInfo a signature where
    overloadedMethod = windowGetFocusOnMap

instance O.OverloadedMethodInfo WindowGetFocusOnMapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetFocusOnMap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetFocusOnMap"
        })


#endif

-- method Window::get_frame_clock
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window to get frame clock for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "FrameClock" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_frame_clock" gdk_window_get_frame_clock :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.FrameClock.FrameClock)

-- | Gets the frame clock for the window. The frame clock for a window
-- never changes unless the window is reparented to a new toplevel
-- window.
-- 
-- /Since: 3.8/
windowGetFrameClock ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: window to get frame clock for
    -> m Gdk.FrameClock.FrameClock
    -- ^ __Returns:__ the frame clock
windowGetFrameClock window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_frame_clock window'
    checkUnexpectedReturnNULL "windowGetFrameClock" result
    result' <- (newObject Gdk.FrameClock.FrameClock) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetFrameClockMethodInfo
instance (signature ~ (m Gdk.FrameClock.FrameClock), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetFrameClockMethodInfo a signature where
    overloadedMethod = windowGetFrameClock

instance O.OverloadedMethodInfo WindowGetFrameClockMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetFrameClock",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetFrameClock"
        })


#endif

-- method Window::get_frame_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "rectangle to fill with bounding box of the window frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_frame_extents" gdk_window_get_frame_extents :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Obtains the bounding box of the window, including window manager
-- titlebar\/borders if any. The frame position is given in root window
-- coordinates. To get the position of the window itself (rather than
-- the frame) in root window coordinates, use 'GI.Gdk.Objects.Window.windowGetOrigin'.
windowGetFrameExtents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m (Gdk.Rectangle.Rectangle)
windowGetFrameExtents window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    rect <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gdk_window_get_frame_extents window' rect
    rect' <- (wrapBoxed Gdk.Rectangle.Rectangle) rect
    touchManagedPtr window
    return rect'

#if defined(ENABLE_OVERLOADING)
data WindowGetFrameExtentsMethodInfo
instance (signature ~ (m (Gdk.Rectangle.Rectangle)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetFrameExtentsMethodInfo a signature where
    overloadedMethod = windowGetFrameExtents

instance O.OverloadedMethodInfo WindowGetFrameExtentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetFrameExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetFrameExtents"
        })


#endif

-- method Window::get_fullscreen_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "FullscreenMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_fullscreen_mode" gdk_window_get_fullscreen_mode :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CUInt

-- | Obtains the t'GI.Gdk.Enums.FullscreenMode' of the /@window@/.
-- 
-- /Since: 3.8/
windowGetFullscreenMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Enums.FullscreenMode
    -- ^ __Returns:__ The t'GI.Gdk.Enums.FullscreenMode' applied to the window when fullscreen.
windowGetFullscreenMode window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_fullscreen_mode window'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetFullscreenModeMethodInfo
instance (signature ~ (m Gdk.Enums.FullscreenMode), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetFullscreenModeMethodInfo a signature where
    overloadedMethod = windowGetFullscreenMode

instance O.OverloadedMethodInfo WindowGetFullscreenModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetFullscreenMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetFullscreenMode"
        })


#endif

-- method Window::get_geometry
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for X coordinate of window (relative to its parent)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for Y coordinate of window (relative to its parent)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for width of window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for height of window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_geometry" gdk_window_get_geometry :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    Ptr Int32 ->                            -- width : TBasicType TInt
    Ptr Int32 ->                            -- height : TBasicType TInt
    IO ()

-- | Any of the return location arguments to this function may be 'P.Nothing',
-- if you aren’t interested in getting the value of that field.
-- 
-- The X and Y coordinates returned are relative to the parent window
-- of /@window@/, which for toplevels usually means relative to the
-- window decorations (titlebar, etc.) rather than relative to the
-- root window (screen-size background window).
-- 
-- On the X11 platform, the geometry is obtained from the X server,
-- so reflects the latest position of /@window@/; this may be out-of-sync
-- with the position of /@window@/ delivered in the most-recently-processed
-- t'GI.Gdk.Structs.EventConfigure.EventConfigure'. 'GI.Gdk.Objects.Window.windowGetPosition' in contrast gets the
-- position from the most recent configure event.
-- 
-- Note: If /@window@/ is not a toplevel, it is much better
-- to call 'GI.Gdk.Objects.Window.windowGetPosition', 'GI.Gdk.Objects.Window.windowGetWidth' and
-- 'GI.Gdk.Objects.Window.windowGetHeight' instead, because it avoids the roundtrip to
-- the X server and because these functions support the full 32-bit
-- coordinate space, whereas 'GI.Gdk.Objects.Window.windowGetGeometry' is restricted to
-- the 16-bit coordinates of X11.
windowGetGeometry ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ((Int32, Int32, Int32, Int32))
windowGetGeometry window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    width <- allocMem :: IO (Ptr Int32)
    height <- allocMem :: IO (Ptr Int32)
    gdk_window_get_geometry window' x y width height
    x' <- peek x
    y' <- peek y
    width' <- peek width
    height' <- peek height
    touchManagedPtr window
    freeMem x
    freeMem y
    freeMem width
    freeMem height
    return (x', y', width', height')

#if defined(ENABLE_OVERLOADING)
data WindowGetGeometryMethodInfo
instance (signature ~ (m ((Int32, Int32, Int32, Int32))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetGeometryMethodInfo a signature where
    overloadedMethod = windowGetGeometry

instance O.OverloadedMethodInfo WindowGetGeometryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetGeometry",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetGeometry"
        })


#endif

-- method Window::get_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_group" gdk_window_get_group :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Window)

-- | Returns the group leader window for /@window@/. See 'GI.Gdk.Objects.Window.windowSetGroup'.
-- 
-- /Since: 2.4/
windowGetGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m Window
    -- ^ __Returns:__ the group leader window for /@window@/
windowGetGroup window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_group window'
    checkUnexpectedReturnNULL "windowGetGroup" result
    result' <- (newObject Window) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetGroupMethodInfo
instance (signature ~ (m Window), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetGroupMethodInfo a signature where
    overloadedMethod = windowGetGroup

instance O.OverloadedMethodInfo WindowGetGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetGroup"
        })


#endif

-- method Window::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_height" gdk_window_get_height :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO Int32

-- | Returns the height of the given /@window@/.
-- 
-- On the X11 platform the returned size is the size reported in the
-- most-recently-processed configure event, rather than the current
-- size on the X server.
-- 
-- /Since: 2.24/
windowGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Int32
    -- ^ __Returns:__ The height of /@window@/
windowGetHeight window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_height window'
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data WindowGetHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetHeightMethodInfo a signature where
    overloadedMethod = windowGetHeight

instance O.OverloadedMethodInfo WindowGetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetHeight"
        })


#endif

-- method Window::get_modal_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A toplevel #GdkWindow."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_modal_hint" gdk_window_get_modal_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Determines whether or not the window manager is hinted that /@window@/
-- has modal behaviour.
-- 
-- /Since: 2.22/
windowGetModalHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: A toplevel t'GI.Gdk.Objects.Window.Window'.
    -> m Bool
    -- ^ __Returns:__ whether or not the window has the modal hint set.
windowGetModalHint window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_modal_hint window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetModalHintMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetModalHintMethodInfo a signature where
    overloadedMethod = windowGetModalHint

instance O.OverloadedMethodInfo WindowGetModalHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetModalHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetModalHint"
        })


#endif

-- method Window::get_origin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for X coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for Y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_origin" gdk_window_get_origin :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    IO Int32

-- | Obtains the position of a window in root window coordinates.
-- (Compare with 'GI.Gdk.Objects.Window.windowGetPosition' and
-- 'GI.Gdk.Objects.Window.windowGetGeometry' which return the position of a window
-- relative to its parent window.)
windowGetOrigin ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ((Int32, Int32, Int32))
    -- ^ __Returns:__ not meaningful, ignore
windowGetOrigin window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    result <- gdk_window_get_origin window' x y
    x' <- peek x
    y' <- peek y
    touchManagedPtr window
    freeMem x
    freeMem y
    return (result, x', y')

#if defined(ENABLE_OVERLOADING)
data WindowGetOriginMethodInfo
instance (signature ~ (m ((Int32, Int32, Int32))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetOriginMethodInfo a signature where
    overloadedMethod = windowGetOrigin

instance O.OverloadedMethodInfo WindowGetOriginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetOrigin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetOrigin"
        })


#endif

-- method Window::get_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_parent" gdk_window_get_parent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Window)

-- | Obtains the parent of /@window@/, as known to GDK. Does not query the
-- X server; thus this returns the parent as passed to 'GI.Gdk.Objects.Window.windowNew',
-- not the actual parent. This should never matter unless you’re using
-- Xlib calls mixed with GDK calls on the X11 platform. It may also
-- matter for toplevel windows, because the window manager may choose
-- to reparent them.
-- 
-- Note that you should use 'GI.Gdk.Objects.Window.windowGetEffectiveParent' when
-- writing generic code that walks up a window hierarchy, because
-- 'GI.Gdk.Objects.Window.windowGetParent' will most likely not do what you expect if
-- there are offscreen windows in the hierarchy.
windowGetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Window
    -- ^ __Returns:__ parent of /@window@/
windowGetParent window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_parent window'
    checkUnexpectedReturnNULL "windowGetParent" result
    result' <- (newObject Window) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetParentMethodInfo
instance (signature ~ (m Window), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetParentMethodInfo a signature where
    overloadedMethod = windowGetParent

instance O.OverloadedMethodInfo WindowGetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetParent"
        })


#endif

-- method Window::get_pass_through
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_pass_through" gdk_window_get_pass_through :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Returns whether input to the window is passed through to the window
-- below.
-- 
-- See 'GI.Gdk.Objects.Window.windowSetPassThrough' for details
-- 
-- /Since: 3.18/
windowGetPassThrough ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
windowGetPassThrough window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_pass_through window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetPassThroughMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetPassThroughMethodInfo a signature where
    overloadedMethod = windowGetPassThrough

instance O.OverloadedMethodInfo WindowGetPassThroughMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetPassThrough",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetPassThrough"
        })


#endif

-- method Window::get_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for X coordinate of pointer or %NULL to not\n     return the X coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for Y coordinate of pointer or %NULL to not\n     return the Y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for modifier mask or %NULL to not return the\n     modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_pointer" gdk_window_get_pointer :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    Ptr CUInt ->                            -- mask : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO (Ptr Window)

{-# DEPRECATED windowGetPointer ["(Since version 3.0)","Use 'GI.Gdk.Objects.Window.windowGetDevicePosition' instead."] #-}
-- | Obtains the current pointer position and modifier state.
-- The position is given in coordinates relative to the upper left
-- corner of /@window@/.
windowGetPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ((Maybe Window, Int32, Int32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ the window containing the
    -- pointer (as with 'GI.Gdk.Objects.Window.windowAtPointer'), or 'P.Nothing' if the window
    -- containing the pointer isn’t known to GDK
windowGetPointer window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    mask <- allocMem :: IO (Ptr CUInt)
    result <- gdk_window_get_pointer window' x y mask
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Window) result'
        return result''
    x' <- peek x
    y' <- peek y
    mask' <- peek mask
    let mask'' = wordToGFlags mask'
    touchManagedPtr window
    freeMem x
    freeMem y
    freeMem mask
    return (maybeResult, x', y', mask'')

#if defined(ENABLE_OVERLOADING)
data WindowGetPointerMethodInfo
instance (signature ~ (m ((Maybe Window, Int32, Int32, [Gdk.Flags.ModifierType]))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetPointerMethodInfo a signature where
    overloadedMethod = windowGetPointer

instance O.OverloadedMethodInfo WindowGetPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetPointer"
        })


#endif

-- method Window::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_position" gdk_window_get_position :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    IO ()

-- | Obtains the position of the window as reported in the
-- most-recently-processed t'GI.Gdk.Structs.EventConfigure.EventConfigure'. Contrast with
-- 'GI.Gdk.Objects.Window.windowGetGeometry' which queries the X server for the
-- current window position, regardless of which events have been
-- received or processed.
-- 
-- The position coordinates are relative to the window’s parent window.
windowGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ((Int32, Int32))
windowGetPosition window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    gdk_window_get_position window' x y
    x' <- peek x
    y' <- peek y
    touchManagedPtr window
    freeMem x
    freeMem y
    return (x', y')

#if defined(ENABLE_OVERLOADING)
data WindowGetPositionMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetPositionMethodInfo a signature where
    overloadedMethod = windowGetPosition

instance O.OverloadedMethodInfo WindowGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetPosition"
        })


#endif

-- method Window::get_root_coords
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate in window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate in window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for X coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "root_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for Y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_root_coords" gdk_window_get_root_coords :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Ptr Int32 ->                            -- root_x : TBasicType TInt
    Ptr Int32 ->                            -- root_y : TBasicType TInt
    IO ()

-- | Obtains the position of a window position in root
-- window coordinates. This is similar to
-- 'GI.Gdk.Objects.Window.windowGetOrigin' but allows you to pass
-- in any position in the window, not just the origin.
-- 
-- /Since: 2.18/
windowGetRootCoords ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@x@/: X coordinate in window
    -> Int32
    -- ^ /@y@/: Y coordinate in window
    -> m ((Int32, Int32))
windowGetRootCoords window x y = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    rootX <- allocMem :: IO (Ptr Int32)
    rootY <- allocMem :: IO (Ptr Int32)
    gdk_window_get_root_coords window' x y rootX rootY
    rootX' <- peek rootX
    rootY' <- peek rootY
    touchManagedPtr window
    freeMem rootX
    freeMem rootY
    return (rootX', rootY')

#if defined(ENABLE_OVERLOADING)
data WindowGetRootCoordsMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Int32, Int32))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetRootCoordsMethodInfo a signature where
    overloadedMethod = windowGetRootCoords

instance O.OverloadedMethodInfo WindowGetRootCoordsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetRootCoords",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetRootCoords"
        })


#endif

-- method Window::get_root_origin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for X position of window frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for Y position of window frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_root_origin" gdk_window_get_root_origin :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    IO ()

-- | Obtains the top-left corner of the window manager frame in root
-- window coordinates.
windowGetRootOrigin ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ((Int32, Int32))
windowGetRootOrigin window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    gdk_window_get_root_origin window' x y
    x' <- peek x
    y' <- peek y
    touchManagedPtr window
    freeMem x
    freeMem y
    return (x', y')

#if defined(ENABLE_OVERLOADING)
data WindowGetRootOriginMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetRootOriginMethodInfo a signature where
    overloadedMethod = windowGetRootOrigin

instance O.OverloadedMethodInfo WindowGetRootOriginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetRootOrigin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetRootOrigin"
        })


#endif

-- method Window::get_scale_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window to get scale factor for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_scale_factor" gdk_window_get_scale_factor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO Int32

-- | Returns the internal scale factor that maps from window coordiantes
-- to the actual device pixels. On traditional systems this is 1, but
-- on very high density outputs this can be a higher value (often 2).
-- 
-- A higher value means that drawing is automatically scaled up to
-- a higher resolution, so any code doing drawing will automatically look
-- nicer. However, if you are supplying pixel-based data the scale
-- value can be used to determine whether to use a pixel resource
-- with higher resolution data.
-- 
-- The scale of a window may change during runtime, if this happens
-- a configure event will be sent to the toplevel window.
-- 
-- /Since: 3.10/
windowGetScaleFactor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: window to get scale factor for
    -> m Int32
    -- ^ __Returns:__ the scale factor
windowGetScaleFactor window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_scale_factor window'
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data WindowGetScaleFactorMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetScaleFactorMethodInfo a signature where
    overloadedMethod = windowGetScaleFactor

instance O.OverloadedMethodInfo WindowGetScaleFactorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetScaleFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetScaleFactor"
        })


#endif

-- method Window::get_screen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_screen" gdk_window_get_screen :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.Screen.Screen)

-- | Gets the t'GI.Gdk.Objects.Screen.Screen' associated with a t'GI.Gdk.Objects.Window.Window'.
-- 
-- /Since: 2.24/
windowGetScreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Screen.Screen
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Screen.Screen' associated with /@window@/
windowGetScreen window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_screen window'
    checkUnexpectedReturnNULL "windowGetScreen" result
    result' <- (newObject Gdk.Screen.Screen) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetScreenMethodInfo
instance (signature ~ (m Gdk.Screen.Screen), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetScreenMethodInfo a signature where
    overloadedMethod = windowGetScreen

instance O.OverloadedMethodInfo WindowGetScreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetScreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetScreen"
        })


#endif

-- method Window::get_source_events
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "InputSource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkInputSource to define the source class."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "EventMask" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_source_events" gdk_window_get_source_events :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- source : TInterface (Name {namespace = "Gdk", name = "InputSource"})
    IO CUInt

-- | Returns the event mask for /@window@/ corresponding to the device class specified
-- by /@source@/.
windowGetSourceEvents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Enums.InputSource
    -- ^ /@source@/: a t'GI.Gdk.Enums.InputSource' to define the source class.
    -> m [Gdk.Flags.EventMask]
    -- ^ __Returns:__ source event mask for /@window@/
windowGetSourceEvents window source = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let source' = (fromIntegral . fromEnum) source
    result <- gdk_window_get_source_events window' source'
    let result' = wordToGFlags result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetSourceEventsMethodInfo
instance (signature ~ (Gdk.Enums.InputSource -> m [Gdk.Flags.EventMask]), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetSourceEventsMethodInfo a signature where
    overloadedMethod = windowGetSourceEvents

instance O.OverloadedMethodInfo WindowGetSourceEventsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetSourceEvents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetSourceEvents"
        })


#endif

-- method Window::get_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "WindowState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_state" gdk_window_get_state :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CUInt

-- | Gets the bitwise OR of the currently active window state flags,
-- from the t'GI.Gdk.Flags.WindowState' enumeration.
windowGetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m [Gdk.Flags.WindowState]
    -- ^ __Returns:__ window state bitfield
windowGetState window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_state window'
    let result' = wordToGFlags result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetStateMethodInfo
instance (signature ~ (m [Gdk.Flags.WindowState]), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetStateMethodInfo a signature where
    overloadedMethod = windowGetState

instance O.OverloadedMethodInfo WindowGetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetState"
        })


#endif

-- method Window::get_support_multidevice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_support_multidevice" gdk_window_get_support_multidevice :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Returns 'P.True' if the window is aware of the existence of multiple
-- devices.
-- 
-- /Since: 3.0/
windowGetSupportMultidevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window handles multidevice features.
windowGetSupportMultidevice window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_support_multidevice window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetSupportMultideviceMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetSupportMultideviceMethodInfo a signature where
    overloadedMethod = windowGetSupportMultidevice

instance O.OverloadedMethodInfo WindowGetSupportMultideviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetSupportMultidevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetSupportMultidevice"
        })


#endif

-- method Window::get_toplevel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_toplevel" gdk_window_get_toplevel :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Window)

-- | Gets the toplevel window that’s an ancestor of /@window@/.
-- 
-- Any window type but 'GI.Gdk.Enums.WindowTypeChild' is considered a
-- toplevel window, as is a 'GI.Gdk.Enums.WindowTypeChild' window that
-- has a root window as parent.
-- 
-- Note that you should use 'GI.Gdk.Objects.Window.windowGetEffectiveToplevel' when
-- you want to get to a window’s toplevel as seen on screen, because
-- 'GI.Gdk.Objects.Window.windowGetToplevel' will most likely not do what you expect
-- if there are offscreen windows in the hierarchy.
windowGetToplevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Window
    -- ^ __Returns:__ the toplevel window containing /@window@/
windowGetToplevel window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_toplevel window'
    checkUnexpectedReturnNULL "windowGetToplevel" result
    result' <- (newObject Window) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetToplevelMethodInfo
instance (signature ~ (m Window), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetToplevelMethodInfo a signature where
    overloadedMethod = windowGetToplevel

instance O.OverloadedMethodInfo WindowGetToplevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetToplevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetToplevel"
        })


#endif

-- method Window::get_type_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "WindowTypeHint" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_type_hint" gdk_window_get_type_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CUInt

-- | This function returns the type hint set for a window.
-- 
-- /Since: 2.10/
windowGetTypeHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: A toplevel t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Enums.WindowTypeHint
    -- ^ __Returns:__ The type hint set for /@window@/
windowGetTypeHint window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_type_hint window'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetTypeHintMethodInfo
instance (signature ~ (m Gdk.Enums.WindowTypeHint), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetTypeHintMethodInfo a signature where
    overloadedMethod = windowGetTypeHint

instance O.OverloadedMethodInfo WindowGetTypeHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetTypeHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetTypeHint"
        })


#endif

-- method Window::get_update_area
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_update_area" gdk_window_get_update_area :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Region.Region)

-- | Transfers ownership of the update area from /@window@/ to the caller
-- of the function. That is, after calling this function, /@window@/ will
-- no longer have an invalid\/dirty region; the update area is removed
-- from /@window@/ and handed to you. If a window has no update area,
-- 'GI.Gdk.Objects.Window.windowGetUpdateArea' returns 'P.Nothing'. You are responsible for
-- calling @/cairo_region_destroy()/@ on the returned region if it’s non-'P.Nothing'.
windowGetUpdateArea ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Cairo.Region.Region
    -- ^ __Returns:__ the update area for /@window@/
windowGetUpdateArea window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_update_area window'
    checkUnexpectedReturnNULL "windowGetUpdateArea" result
    result' <- (wrapBoxed Cairo.Region.Region) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetUpdateAreaMethodInfo
instance (signature ~ (m Cairo.Region.Region), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetUpdateAreaMethodInfo a signature where
    overloadedMethod = windowGetUpdateArea

instance O.OverloadedMethodInfo WindowGetUpdateAreaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetUpdateArea",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetUpdateArea"
        })


#endif

-- method Window::get_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for user data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_user_data" gdk_window_get_user_data :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr (Ptr ()) ->                         -- data : TBasicType TPtr
    IO ()

-- | Retrieves the user data for /@window@/, which is normally the widget
-- that /@window@/ belongs to. See 'GI.Gdk.Objects.Window.windowSetUserData'.
windowGetUserData ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ((Ptr ()))
windowGetUserData window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    data_ <- callocMem :: IO (Ptr (Ptr ()))
    gdk_window_get_user_data window' data_
    data_' <- peek data_
    touchManagedPtr window
    freeMem data_
    return data_'

#if defined(ENABLE_OVERLOADING)
data WindowGetUserDataMethodInfo
instance (signature ~ (m ((Ptr ()))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetUserDataMethodInfo a signature where
    overloadedMethod = windowGetUserData

instance O.OverloadedMethodInfo WindowGetUserDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetUserData"
        })


#endif

-- method Window::get_visible_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_visible_region" gdk_window_get_visible_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Region.Region)

-- | Computes the region of the /@window@/ that is potentially visible.
-- This does not necessarily take into account if the window is
-- obscured by other windows, but no area outside of this region
-- is visible.
windowGetVisibleRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Cairo.Region.Region
    -- ^ __Returns:__ a t'GI.Cairo.Structs.Region.Region'. This must be freed with @/cairo_region_destroy()/@
    --          when you are done.
windowGetVisibleRegion window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_visible_region window'
    checkUnexpectedReturnNULL "windowGetVisibleRegion" result
    result' <- (wrapBoxed Cairo.Region.Region) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetVisibleRegionMethodInfo
instance (signature ~ (m Cairo.Region.Region), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetVisibleRegionMethodInfo a signature where
    overloadedMethod = windowGetVisibleRegion

instance O.OverloadedMethodInfo WindowGetVisibleRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetVisibleRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetVisibleRegion"
        })


#endif

-- method Window::get_visual
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Visual" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_visual" gdk_window_get_visual :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.Visual.Visual)

-- | Gets the t'GI.Gdk.Objects.Visual.Visual' describing the pixel format of /@window@/.
-- 
-- /Since: 2.24/
windowGetVisual ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Visual.Visual
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Visual.Visual'
windowGetVisual window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_visual window'
    checkUnexpectedReturnNULL "windowGetVisual" result
    result' <- (newObject Gdk.Visual.Visual) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetVisualMethodInfo
instance (signature ~ (m Gdk.Visual.Visual), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetVisualMethodInfo a signature where
    overloadedMethod = windowGetVisual

instance O.OverloadedMethodInfo WindowGetVisualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetVisual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetVisual"
        })


#endif

-- method Window::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_width" gdk_window_get_width :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO Int32

-- | Returns the width of the given /@window@/.
-- 
-- On the X11 platform the returned size is the size reported in the
-- most-recently-processed configure event, rather than the current
-- size on the X server.
-- 
-- /Since: 2.24/
windowGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Int32
    -- ^ __Returns:__ The width of /@window@/
windowGetWidth window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_width window'
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data WindowGetWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetWidthMethodInfo a signature where
    overloadedMethod = windowGetWidth

instance O.OverloadedMethodInfo WindowGetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetWidth"
        })


#endif

-- method Window::get_window_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "WindowType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_get_window_type" gdk_window_get_window_type :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CUInt

-- | Gets the type of the window. See t'GI.Gdk.Enums.WindowType'.
windowGetWindowType ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Enums.WindowType
    -- ^ __Returns:__ type of window
windowGetWindowType window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_get_window_type window'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetWindowTypeMethodInfo
instance (signature ~ (m Gdk.Enums.WindowType), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetWindowTypeMethodInfo a signature where
    overloadedMethod = windowGetWindowType

instance O.OverloadedMethodInfo WindowGetWindowTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowGetWindowType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowGetWindowType"
        })


#endif

-- method Window::has_native
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_has_native" gdk_window_has_native :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Checks whether the window has a native window or not. Note that
-- you can use 'GI.Gdk.Objects.Window.windowEnsureNative' if a native window is needed.
-- 
-- /Since: 2.22/
windowHasNative ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@window@/ has a native window, 'P.False' otherwise.
windowHasNative window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_has_native window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowHasNativeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowHasNativeMethodInfo a signature where
    overloadedMethod = windowHasNative

instance O.OverloadedMethodInfo WindowHasNativeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowHasNative",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowHasNative"
        })


#endif

-- method Window::hide
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_hide" gdk_window_hide :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | For toplevel windows, withdraws them, so they will no longer be
-- known to the window manager; for all windows, unmaps them, so
-- they won’t be displayed. Normally done automatically as
-- part of @/gtk_widget_hide()/@.
windowHide ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowHide window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_hide window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowHideMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowHideMethodInfo a signature where
    overloadedMethod = windowHide

instance O.OverloadedMethodInfo WindowHideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowHide",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowHide"
        })


#endif

-- method Window::iconify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_iconify" gdk_window_iconify :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Asks to iconify (minimize) /@window@/. The window manager may choose
-- to ignore the request, but normally will honor it. Using
-- @/gtk_window_iconify()/@ is preferred, if you have a @/GtkWindow/@ widget.
-- 
-- This function only makes sense when /@window@/ is a toplevel window.
windowIconify ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowIconify window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_iconify window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowIconifyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIconifyMethodInfo a signature where
    overloadedMethod = windowIconify

instance O.OverloadedMethodInfo WindowIconifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowIconify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowIconify"
        })


#endif

-- method Window::input_shape_combine_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shape_region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "region of window to be non-transparent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "X position of @shape_region in @window coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Y position of @shape_region in @window coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_input_shape_combine_region" gdk_window_input_shape_combine_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- shape_region : TInterface (Name {namespace = "cairo", name = "Region"})
    Int32 ->                                -- offset_x : TBasicType TInt
    Int32 ->                                -- offset_y : TBasicType TInt
    IO ()

-- | Like 'GI.Gdk.Objects.Window.windowShapeCombineRegion', but the shape applies
-- only to event handling. Mouse events which happen while
-- the pointer position corresponds to an unset bit in the
-- mask will be passed on the window below /@window@/.
-- 
-- An input shape is typically used with RGBA windows.
-- The alpha channel of the window defines which pixels are
-- invisible and allows for nicely antialiased borders,
-- and the input shape controls where the window is
-- “clickable”.
-- 
-- On the X11 platform, this requires version 1.1 of the
-- shape extension.
-- 
-- On the Win32 platform, this functionality is not present and the
-- function does nothing.
-- 
-- /Since: 2.10/
windowInputShapeCombineRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@shapeRegion@/: region of window to be non-transparent
    -> Int32
    -- ^ /@offsetX@/: X position of /@shapeRegion@/ in /@window@/ coordinates
    -> Int32
    -- ^ /@offsetY@/: Y position of /@shapeRegion@/ in /@window@/ coordinates
    -> m ()
windowInputShapeCombineRegion window shapeRegion offsetX offsetY = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    shapeRegion' <- unsafeManagedPtrGetPtr shapeRegion
    gdk_window_input_shape_combine_region window' shapeRegion' offsetX offsetY
    touchManagedPtr window
    touchManagedPtr shapeRegion
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowInputShapeCombineRegionMethodInfo
instance (signature ~ (Cairo.Region.Region -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowInputShapeCombineRegionMethodInfo a signature where
    overloadedMethod = windowInputShapeCombineRegion

instance O.OverloadedMethodInfo WindowInputShapeCombineRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowInputShapeCombineRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowInputShapeCombineRegion"
        })


#endif

-- method Window::invalidate_maybe_recurse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #cairo_region_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_func"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowChildFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function to use to decide if to\n    recurse to a child, %NULL means never recurse."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to @child_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_invalidate_maybe_recurse" gdk_window_invalidate_maybe_recurse :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    FunPtr Gdk.Callbacks.C_WindowChildFunc -> -- child_func : TInterface (Name {namespace = "Gdk", name = "WindowChildFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Adds /@region@/ to the update area for /@window@/. The update area is the
-- region that needs to be redrawn, or “dirty region.” The call
-- 'GI.Gdk.Objects.Window.windowProcessUpdates' sends one or more expose events to the
-- window, which together cover the entire update area. An
-- application would normally redraw the contents of /@window@/ in
-- response to those expose events.
-- 
-- GDK will call 'GI.Gdk.Objects.Window.windowProcessAllUpdates' on your behalf
-- whenever your program returns to the main loop and becomes idle, so
-- normally there’s no need to do that manually, you just need to
-- invalidate regions that you know should be redrawn.
-- 
-- The /@childFunc@/ parameter controls whether the region of
-- each child window that intersects /@region@/ will also be invalidated.
-- Only children for which /@childFunc@/ returns @/TRUE/@ will have the area
-- invalidated.
windowInvalidateMaybeRecurse ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: a t'GI.Cairo.Structs.Region.Region'
    -> Maybe (Gdk.Callbacks.WindowChildFunc)
    -- ^ /@childFunc@/: function to use to decide if to
    --     recurse to a child, 'P.Nothing' means never recurse.
    -> m ()
windowInvalidateMaybeRecurse window region childFunc = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    region' <- unsafeManagedPtrGetPtr region
    maybeChildFunc <- case childFunc of
        Nothing -> return FP.nullFunPtr
        Just jChildFunc -> do
            jChildFunc' <- Gdk.Callbacks.mk_WindowChildFunc (Gdk.Callbacks.wrap_WindowChildFunc Nothing (Gdk.Callbacks.drop_closures_WindowChildFunc jChildFunc))
            return jChildFunc'
    let userData = nullPtr
    gdk_window_invalidate_maybe_recurse window' region' maybeChildFunc userData
    safeFreeFunPtr $ castFunPtrToPtr maybeChildFunc
    touchManagedPtr window
    touchManagedPtr region
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowInvalidateMaybeRecurseMethodInfo
instance (signature ~ (Cairo.Region.Region -> Maybe (Gdk.Callbacks.WindowChildFunc) -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowInvalidateMaybeRecurseMethodInfo a signature where
    overloadedMethod = windowInvalidateMaybeRecurse

instance O.OverloadedMethodInfo WindowInvalidateMaybeRecurseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowInvalidateMaybeRecurse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowInvalidateMaybeRecurse"
        })


#endif

-- method Window::invalidate_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle to invalidate or %NULL to invalidate the whole\n     window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invalidate_children"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to also invalidate child windows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_invalidate_rect" gdk_window_invalidate_rect :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    CInt ->                                 -- invalidate_children : TBasicType TBoolean
    IO ()

-- | A convenience wrapper around 'GI.Gdk.Objects.Window.windowInvalidateRegion' which
-- invalidates a rectangular region. See
-- 'GI.Gdk.Objects.Window.windowInvalidateRegion' for details.
windowInvalidateRect ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Maybe (Gdk.Rectangle.Rectangle)
    -- ^ /@rect@/: rectangle to invalidate or 'P.Nothing' to invalidate the whole
    --      window
    -> Bool
    -- ^ /@invalidateChildren@/: whether to also invalidate child windows
    -> m ()
windowInvalidateRect window rect invalidateChildren = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeRect <- case rect of
        Nothing -> return FP.nullPtr
        Just jRect -> do
            jRect' <- unsafeManagedPtrGetPtr jRect
            return jRect'
    let invalidateChildren' = (P.fromIntegral . P.fromEnum) invalidateChildren
    gdk_window_invalidate_rect window' maybeRect invalidateChildren'
    touchManagedPtr window
    whenJust rect touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowInvalidateRectMethodInfo
instance (signature ~ (Maybe (Gdk.Rectangle.Rectangle) -> Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowInvalidateRectMethodInfo a signature where
    overloadedMethod = windowInvalidateRect

instance O.OverloadedMethodInfo WindowInvalidateRectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowInvalidateRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowInvalidateRect"
        })


#endif

-- method Window::invalidate_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #cairo_region_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invalidate_children"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to also invalidate child windows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_invalidate_region" gdk_window_invalidate_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    CInt ->                                 -- invalidate_children : TBasicType TBoolean
    IO ()

-- | Adds /@region@/ to the update area for /@window@/. The update area is the
-- region that needs to be redrawn, or “dirty region.” The call
-- 'GI.Gdk.Objects.Window.windowProcessUpdates' sends one or more expose events to the
-- window, which together cover the entire update area. An
-- application would normally redraw the contents of /@window@/ in
-- response to those expose events.
-- 
-- GDK will call 'GI.Gdk.Objects.Window.windowProcessAllUpdates' on your behalf
-- whenever your program returns to the main loop and becomes idle, so
-- normally there’s no need to do that manually, you just need to
-- invalidate regions that you know should be redrawn.
-- 
-- The /@invalidateChildren@/ parameter controls whether the region of
-- each child window that intersects /@region@/ will also be invalidated.
-- If 'P.False', then the update area for child windows will remain
-- unaffected. See gdk_window_invalidate_maybe_recurse if you need
-- fine grained control over which children are invalidated.
windowInvalidateRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: a t'GI.Cairo.Structs.Region.Region'
    -> Bool
    -- ^ /@invalidateChildren@/: 'P.True' to also invalidate child windows
    -> m ()
windowInvalidateRegion window region invalidateChildren = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    region' <- unsafeManagedPtrGetPtr region
    let invalidateChildren' = (P.fromIntegral . P.fromEnum) invalidateChildren
    gdk_window_invalidate_region window' region' invalidateChildren'
    touchManagedPtr window
    touchManagedPtr region
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowInvalidateRegionMethodInfo
instance (signature ~ (Cairo.Region.Region -> Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowInvalidateRegionMethodInfo a signature where
    overloadedMethod = windowInvalidateRegion

instance O.OverloadedMethodInfo WindowInvalidateRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowInvalidateRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowInvalidateRegion"
        })


#endif

-- method Window::is_destroyed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_is_destroyed" gdk_window_is_destroyed :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Check to see if a window is destroyed..
-- 
-- /Since: 2.18/
windowIsDestroyed ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window is destroyed
windowIsDestroyed window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_is_destroyed window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsDestroyedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsDestroyedMethodInfo a signature where
    overloadedMethod = windowIsDestroyed

instance O.OverloadedMethodInfo WindowIsDestroyedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowIsDestroyed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowIsDestroyed"
        })


#endif

-- method Window::is_input_only
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_is_input_only" gdk_window_is_input_only :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Determines whether or not the window is an input only window.
-- 
-- /Since: 2.22/
windowIsInputOnly ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@window@/ is input only
windowIsInputOnly window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_is_input_only window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsInputOnlyMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsInputOnlyMethodInfo a signature where
    overloadedMethod = windowIsInputOnly

instance O.OverloadedMethodInfo WindowIsInputOnlyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowIsInputOnly",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowIsInputOnly"
        })


#endif

-- method Window::is_shaped
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_is_shaped" gdk_window_is_shaped :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Determines whether or not the window is shaped.
-- 
-- /Since: 2.22/
windowIsShaped ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@window@/ is shaped
windowIsShaped window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_is_shaped window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsShapedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsShapedMethodInfo a signature where
    overloadedMethod = windowIsShaped

instance O.OverloadedMethodInfo WindowIsShapedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowIsShaped",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowIsShaped"
        })


#endif

-- method Window::is_viewable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_is_viewable" gdk_window_is_viewable :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Check if the window and all ancestors of the window are
-- mapped. (This is not necessarily \"viewable\" in the X sense, since
-- we only check as far as we have GDK window parents, not to the root
-- window.)
windowIsViewable ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window is viewable
windowIsViewable window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_is_viewable window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsViewableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsViewableMethodInfo a signature where
    overloadedMethod = windowIsViewable

instance O.OverloadedMethodInfo WindowIsViewableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowIsViewable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowIsViewable"
        })


#endif

-- method Window::is_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_is_visible" gdk_window_is_visible :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO CInt

-- | Checks whether the window has been mapped (with 'GI.Gdk.Objects.Window.windowShow' or
-- 'GI.Gdk.Objects.Window.windowShowUnraised').
windowIsVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window is mapped
windowIsVisible window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_is_visible window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsVisibleMethodInfo a signature where
    overloadedMethod = windowIsVisible

instance O.OverloadedMethodInfo WindowIsVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowIsVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowIsVisible"
        })


#endif

-- method Window::lower
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_lower" gdk_window_lower :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Lowers /@window@/ to the bottom of the Z-order (stacking order), so that
-- other windows with the same parent window appear above /@window@/.
-- This is true whether or not the other windows are visible.
-- 
-- If /@window@/ is a toplevel, the window manager may choose to deny the
-- request to move the window in the Z-order, 'GI.Gdk.Objects.Window.windowLower' only
-- requests the restack, does not guarantee it.
-- 
-- Note that 'GI.Gdk.Objects.Window.windowShow' raises the window again, so don’t call this
-- function before 'GI.Gdk.Objects.Window.windowShow'. (Try 'GI.Gdk.Objects.Window.windowShowUnraised'.)
windowLower ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowLower window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_lower window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowLowerMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowLowerMethodInfo a signature where
    overloadedMethod = windowLower

instance O.OverloadedMethodInfo WindowLowerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowLower",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowLower"
        })


#endif

-- method Window::mark_paint_from_clip
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #cairo_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_mark_paint_from_clip" gdk_window_mark_paint_from_clip :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    IO ()

-- | If you call this during a paint (e.g. between 'GI.Gdk.Objects.Window.windowBeginPaintRegion'
-- and 'GI.Gdk.Objects.Window.windowEndPaint' then GDK will mark the current clip region of the
-- window as being drawn. This is required when mixing GL rendering via
-- 'GI.Gdk.Functions.cairoDrawFromGl' and cairo rendering, as otherwise GDK has no way
-- of knowing when something paints over the GL-drawn regions.
-- 
-- This is typically called automatically by GTK+ and you don\'t need
-- to care about this.
-- 
-- /Since: 3.16/
windowMarkPaintFromClip ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Context.Context
    -- ^ /@cr@/: a t'GI.Cairo.Structs.Context.Context'
    -> m ()
windowMarkPaintFromClip window cr = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    cr' <- unsafeManagedPtrGetPtr cr
    gdk_window_mark_paint_from_clip window' cr'
    touchManagedPtr window
    touchManagedPtr cr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMarkPaintFromClipMethodInfo
instance (signature ~ (Cairo.Context.Context -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMarkPaintFromClipMethodInfo a signature where
    overloadedMethod = windowMarkPaintFromClip

instance O.OverloadedMethodInfo WindowMarkPaintFromClipMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMarkPaintFromClip",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMarkPaintFromClip"
        })


#endif

-- method Window::maximize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_maximize" gdk_window_maximize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Maximizes the window. If the window was already maximized, then
-- this function does nothing.
-- 
-- On X11, asks the window manager to maximize /@window@/, if the window
-- manager supports this operation. Not all window managers support
-- this, and some deliberately ignore it or don’t have a concept of
-- “maximized”; so you can’t rely on the maximization actually
-- happening. But it will happen with most standard window managers,
-- and GDK makes a best effort to get it to happen.
-- 
-- On Windows, reliably maximizes the window.
windowMaximize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowMaximize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_maximize window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMaximizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMaximizeMethodInfo a signature where
    overloadedMethod = windowMaximize

instance O.OverloadedMethodInfo WindowMaximizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMaximize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMaximize"
        })


#endif

-- method Window::merge_child_input_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_merge_child_input_shapes" gdk_window_merge_child_input_shapes :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Merges the input shape masks for any child windows into the
-- input shape mask for /@window@/. i.e. the union of all input masks
-- for /@window@/ and its children will become the new input mask
-- for /@window@/. See 'GI.Gdk.Objects.Window.windowInputShapeCombineRegion'.
-- 
-- This function is distinct from 'GI.Gdk.Objects.Window.windowSetChildInputShapes'
-- because it includes /@window@/’s input shape mask in the set of
-- shapes to be merged.
-- 
-- /Since: 2.10/
windowMergeChildInputShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowMergeChildInputShapes window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_merge_child_input_shapes window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMergeChildInputShapesMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMergeChildInputShapesMethodInfo a signature where
    overloadedMethod = windowMergeChildInputShapes

instance O.OverloadedMethodInfo WindowMergeChildInputShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMergeChildInputShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMergeChildInputShapes"
        })


#endif

-- method Window::merge_child_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_merge_child_shapes" gdk_window_merge_child_shapes :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Merges the shape masks for any child windows into the
-- shape mask for /@window@/. i.e. the union of all masks
-- for /@window@/ and its children will become the new mask
-- for /@window@/. See 'GI.Gdk.Objects.Window.windowShapeCombineRegion'.
-- 
-- This function is distinct from 'GI.Gdk.Objects.Window.windowSetChildShapes'
-- because it includes /@window@/’s shape mask in the set of shapes to
-- be merged.
windowMergeChildShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowMergeChildShapes window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_merge_child_shapes window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMergeChildShapesMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMergeChildShapesMethodInfo a signature where
    overloadedMethod = windowMergeChildShapes

instance O.OverloadedMethodInfo WindowMergeChildShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMergeChildShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMergeChildShapes"
        })


#endif

-- method Window::move
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate relative to window\8217s parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate relative to window\8217s parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_move" gdk_window_move :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO ()

-- | Repositions a window relative to its parent window.
-- For toplevel windows, window managers may ignore or modify the move;
-- you should probably use @/gtk_window_move()/@ on a @/GtkWindow/@ widget
-- anyway, instead of using GDK functions. For child windows,
-- the move will reliably succeed.
-- 
-- If you’re also planning to resize the window, use 'GI.Gdk.Objects.Window.windowMoveResize'
-- to both move and resize simultaneously, for a nicer visual effect.
windowMove ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@x@/: X coordinate relative to window’s parent
    -> Int32
    -- ^ /@y@/: Y coordinate relative to window’s parent
    -> m ()
windowMove window x y = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_move window' x y
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMoveMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMoveMethodInfo a signature where
    overloadedMethod = windowMove

instance O.OverloadedMethodInfo WindowMoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMove"
        })


#endif

-- method Window::move_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #cairo_region_t to move"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Amount to move in the X direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Amount to move in the Y direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_move_region" gdk_window_move_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    Int32 ->                                -- dx : TBasicType TInt
    Int32 ->                                -- dy : TBasicType TInt
    IO ()

-- | Move the part of /@window@/ indicated by /@region@/ by /@dy@/ pixels in the Y
-- direction and /@dx@/ pixels in the X direction. The portions of /@region@/
-- that not covered by the new position of /@region@/ are invalidated.
-- 
-- Child windows are not moved.
-- 
-- /Since: 2.8/
windowMoveRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: The t'GI.Cairo.Structs.Region.Region' to move
    -> Int32
    -- ^ /@dx@/: Amount to move in the X direction
    -> Int32
    -- ^ /@dy@/: Amount to move in the Y direction
    -> m ()
windowMoveRegion window region dx dy = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    region' <- unsafeManagedPtrGetPtr region
    gdk_window_move_region window' region' dx dy
    touchManagedPtr window
    touchManagedPtr region
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMoveRegionMethodInfo
instance (signature ~ (Cairo.Region.Region -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMoveRegionMethodInfo a signature where
    overloadedMethod = windowMoveRegion

instance O.OverloadedMethodInfo WindowMoveRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMoveRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMoveRegion"
        })


#endif

-- method Window::move_resize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "new X position relative to window\8217s parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "new Y position relative to window\8217s parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_move_resize" gdk_window_move_resize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Equivalent to calling 'GI.Gdk.Objects.Window.windowMove' and 'GI.Gdk.Objects.Window.windowResize',
-- except that both operations are performed at once, avoiding strange
-- visual effects. (i.e. the user may be able to see the window first
-- move, then resize, if you don’t use 'GI.Gdk.Objects.Window.windowMoveResize'.)
windowMoveResize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@x@/: new X position relative to window’s parent
    -> Int32
    -- ^ /@y@/: new Y position relative to window’s parent
    -> Int32
    -- ^ /@width@/: new width
    -> Int32
    -- ^ /@height@/: new height
    -> m ()
windowMoveResize window x y width height = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_move_resize window' x y width height
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMoveResizeMethodInfo
instance (signature ~ (Int32 -> Int32 -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMoveResizeMethodInfo a signature where
    overloadedMethod = windowMoveResize

instance O.OverloadedMethodInfo WindowMoveResizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMoveResize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMoveResize"
        })


#endif

-- method Window::move_to_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkWindow to move"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the destination #GdkRectangle to align @window with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect_anchor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Gravity" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the point on @rect to align with @window's anchor point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window_anchor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Gravity" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the point on @window to align with @rect's anchor point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "anchor_hints"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "AnchorHints" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "positioning hints to use when limited on space"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect_anchor_dx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "horizontal offset to shift @window, i.e. @rect's anchor\n                 point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect_anchor_dy"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "vertical offset to shift @window, i.e. @rect's anchor point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_move_to_rect" gdk_window_move_to_rect :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    CUInt ->                                -- rect_anchor : TInterface (Name {namespace = "Gdk", name = "Gravity"})
    CUInt ->                                -- window_anchor : TInterface (Name {namespace = "Gdk", name = "Gravity"})
    CUInt ->                                -- anchor_hints : TInterface (Name {namespace = "Gdk", name = "AnchorHints"})
    Int32 ->                                -- rect_anchor_dx : TBasicType TInt
    Int32 ->                                -- rect_anchor_dy : TBasicType TInt
    IO ()

-- | Moves /@window@/ to /@rect@/, aligning their anchor points.
-- 
-- /@rect@/ is relative to the top-left corner of the window that /@window@/ is
-- transient for. /@rectAnchor@/ and /@windowAnchor@/ determine anchor points on
-- /@rect@/ and /@window@/ to pin together. /@rect@/\'s anchor point can optionally be
-- offset by /@rectAnchorDx@/ and /@rectAnchorDy@/, which is equivalent to
-- offsetting the position of /@window@/.
-- 
-- /@anchorHints@/ determines how /@window@/ will be moved if the anchor points cause
-- it to move off-screen. For example, 'GI.Gdk.Flags.AnchorHintsFlipX' will replace
-- 'GI.Gdk.Enums.GravityNorthWest' with 'GI.Gdk.Enums.GravityNorthEast' and vice versa if
-- /@window@/ extends beyond the left or right edges of the monitor.
-- 
-- Connect to the [Window::movedToRect]("GI.Gdk.Objects.Window#g:signal:movedToRect") signal to find out how it was
-- actually positioned.
-- 
-- /Since: 3.24/
windowMoveToRect ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' to move
    -> Gdk.Rectangle.Rectangle
    -- ^ /@rect@/: the destination t'GI.Gdk.Structs.Rectangle.Rectangle' to align /@window@/ with
    -> Gdk.Enums.Gravity
    -- ^ /@rectAnchor@/: the point on /@rect@/ to align with /@window@/\'s anchor point
    -> Gdk.Enums.Gravity
    -- ^ /@windowAnchor@/: the point on /@window@/ to align with /@rect@/\'s anchor point
    -> [Gdk.Flags.AnchorHints]
    -- ^ /@anchorHints@/: positioning hints to use when limited on space
    -> Int32
    -- ^ /@rectAnchorDx@/: horizontal offset to shift /@window@/, i.e. /@rect@/\'s anchor
    --                  point
    -> Int32
    -- ^ /@rectAnchorDy@/: vertical offset to shift /@window@/, i.e. /@rect@/\'s anchor point
    -> m ()
windowMoveToRect window rect rectAnchor windowAnchor anchorHints rectAnchorDx rectAnchorDy = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    rect' <- unsafeManagedPtrGetPtr rect
    let rectAnchor' = (fromIntegral . fromEnum) rectAnchor
    let windowAnchor' = (fromIntegral . fromEnum) windowAnchor
    let anchorHints' = gflagsToWord anchorHints
    gdk_window_move_to_rect window' rect' rectAnchor' windowAnchor' anchorHints' rectAnchorDx rectAnchorDy
    touchManagedPtr window
    touchManagedPtr rect
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMoveToRectMethodInfo
instance (signature ~ (Gdk.Rectangle.Rectangle -> Gdk.Enums.Gravity -> Gdk.Enums.Gravity -> [Gdk.Flags.AnchorHints] -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMoveToRectMethodInfo a signature where
    overloadedMethod = windowMoveToRect

instance O.OverloadedMethodInfo WindowMoveToRectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowMoveToRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowMoveToRect"
        })


#endif

-- method Window::peek_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Window" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_peek_children" gdk_window_peek_children :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr (GList (Ptr Window)))

-- | Like 'GI.Gdk.Objects.Window.windowGetChildren', but does not copy the list of
-- children, so the list does not need to be freed.
windowPeekChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m [Window]
    -- ^ __Returns:__ 
    --     a reference to the list of child windows in /@window@/
windowPeekChildren window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_window_peek_children window'
    result' <- unpackGList result
    result'' <- mapM (newObject Window) result'
    touchManagedPtr window
    return result''

#if defined(ENABLE_OVERLOADING)
data WindowPeekChildrenMethodInfo
instance (signature ~ (m [Window]), MonadIO m, IsWindow a) => O.OverloadedMethod WindowPeekChildrenMethodInfo a signature where
    overloadedMethod = windowPeekChildren

instance O.OverloadedMethodInfo WindowPeekChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowPeekChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowPeekChildren"
        })


#endif

-- method Window::process_updates
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "update_children"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to also process updates for child windows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_process_updates" gdk_window_process_updates :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- update_children : TBasicType TBoolean
    IO ()

{-# DEPRECATED windowProcessUpdates ["(Since version 3.22)"] #-}
-- | Sends one or more expose events to /@window@/. The areas in each
-- expose event will cover the entire update area for the window (see
-- 'GI.Gdk.Objects.Window.windowInvalidateRegion' for details). Normally GDK calls
-- 'GI.Gdk.Objects.Window.windowProcessAllUpdates' on your behalf, so there’s no
-- need to call this function unless you want to force expose events
-- to be delivered immediately and synchronously (vs. the usual
-- case, where GDK delivers them in an idle handler). Occasionally
-- this is useful to produce nicer scrolling behavior, for example.
windowProcessUpdates ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@updateChildren@/: whether to also process updates for child windows
    -> m ()
windowProcessUpdates window updateChildren = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let updateChildren' = (P.fromIntegral . P.fromEnum) updateChildren
    gdk_window_process_updates window' updateChildren'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowProcessUpdatesMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowProcessUpdatesMethodInfo a signature where
    overloadedMethod = windowProcessUpdates

instance O.OverloadedMethodInfo WindowProcessUpdatesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowProcessUpdates",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowProcessUpdates"
        })


#endif

-- method Window::raise
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_raise" gdk_window_raise :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Raises /@window@/ to the top of the Z-order (stacking order), so that
-- other windows with the same parent window appear below /@window@/.
-- This is true whether or not the windows are visible.
-- 
-- If /@window@/ is a toplevel, the window manager may choose to deny the
-- request to move the window in the Z-order, 'GI.Gdk.Objects.Window.windowRaise' only
-- requests the restack, does not guarantee it.
windowRaise ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowRaise window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_raise window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowRaiseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowRaiseMethodInfo a signature where
    overloadedMethod = windowRaise

instance O.OverloadedMethodInfo WindowRaiseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowRaise",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowRaise"
        })


#endif

-- method Window::register_dnd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_register_dnd" gdk_window_register_dnd :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Registers a window as a potential drop destination.
windowRegisterDnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> m ()
windowRegisterDnd window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_register_dnd window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowRegisterDndMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowRegisterDndMethodInfo a signature where
    overloadedMethod = windowRegisterDnd

instance O.OverloadedMethodInfo WindowRegisterDndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowRegisterDnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowRegisterDnd"
        })


#endif

-- method Window::reparent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_parent"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new parent to move @window into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X location inside the new parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y location inside the new parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_reparent" gdk_window_reparent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Window ->                           -- new_parent : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO ()

-- | Reparents /@window@/ into the given /@newParent@/. The window being
-- reparented will be unmapped as a side effect.
windowReparent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, IsWindow b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@newParent@/: new parent to move /@window@/ into
    -> Int32
    -- ^ /@x@/: X location inside the new parent
    -> Int32
    -- ^ /@y@/: Y location inside the new parent
    -> m ()
windowReparent window newParent x y = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    newParent' <- unsafeManagedPtrCastPtr newParent
    gdk_window_reparent window' newParent' x y
    touchManagedPtr window
    touchManagedPtr newParent
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowReparentMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a, IsWindow b) => O.OverloadedMethod WindowReparentMethodInfo a signature where
    overloadedMethod = windowReparent

instance O.OverloadedMethodInfo WindowReparentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowReparent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowReparent"
        })


#endif

-- method Window::resize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new width of the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new height of the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_resize" gdk_window_resize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Resizes /@window@/; for toplevel windows, asks the window manager to resize
-- the window. The window manager may not allow the resize. When using GTK+,
-- use @/gtk_window_resize()/@ instead of this low-level GDK function.
-- 
-- Windows may not be resized below 1x1.
-- 
-- If you’re also planning to move the window, use 'GI.Gdk.Objects.Window.windowMoveResize'
-- to both move and resize simultaneously, for a nicer visual effect.
windowResize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@width@/: new width of the window
    -> Int32
    -- ^ /@height@/: new height of the window
    -> m ()
windowResize window width height = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_resize window' width height
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowResizeMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowResizeMethodInfo a signature where
    overloadedMethod = windowResize

instance O.OverloadedMethodInfo WindowResizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowResize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowResize"
        })


#endif

-- method Window::restack
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sibling"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkWindow that is a sibling of @window, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "above"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a boolean" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_restack" gdk_window_restack :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Window ->                           -- sibling : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- above : TBasicType TBoolean
    IO ()

-- | Changes the position of  /@window@/ in the Z-order (stacking order), so that
-- it is above /@sibling@/ (if /@above@/ is 'P.True') or below /@sibling@/ (if /@above@/ is
-- 'P.False').
-- 
-- If /@sibling@/ is 'P.Nothing', then this either raises (if /@above@/ is 'P.True') or
-- lowers the window.
-- 
-- If /@window@/ is a toplevel, the window manager may choose to deny the
-- request to move the window in the Z-order, 'GI.Gdk.Objects.Window.windowRestack' only
-- requests the restack, does not guarantee it.
-- 
-- /Since: 2.18/
windowRestack ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, IsWindow b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Maybe (b)
    -- ^ /@sibling@/: a t'GI.Gdk.Objects.Window.Window' that is a sibling of /@window@/, or 'P.Nothing'
    -> Bool
    -- ^ /@above@/: a boolean
    -> m ()
windowRestack window sibling above = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeSibling <- case sibling of
        Nothing -> return FP.nullPtr
        Just jSibling -> do
            jSibling' <- unsafeManagedPtrCastPtr jSibling
            return jSibling'
    let above' = (P.fromIntegral . P.fromEnum) above
    gdk_window_restack window' maybeSibling above'
    touchManagedPtr window
    whenJust sibling touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowRestackMethodInfo
instance (signature ~ (Maybe (b) -> Bool -> m ()), MonadIO m, IsWindow a, IsWindow b) => O.OverloadedMethod WindowRestackMethodInfo a signature where
    overloadedMethod = windowRestack

instance O.OverloadedMethodInfo WindowRestackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowRestack",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowRestack"
        })


#endif

-- method Window::scroll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Amount to scroll in the X direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Amount to scroll in the Y direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_scroll" gdk_window_scroll :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- dx : TBasicType TInt
    Int32 ->                                -- dy : TBasicType TInt
    IO ()

-- | Scroll the contents of /@window@/, both pixels and children, by the
-- given amount. /@window@/ itself does not move. Portions of the window
-- that the scroll operation brings in from offscreen areas are
-- invalidated. The invalidated region may be bigger than what would
-- strictly be necessary.
-- 
-- For X11, a minimum area will be invalidated if the window has no
-- subwindows, or if the edges of the window’s parent do not extend
-- beyond the edges of the window. In other cases, a multi-step process
-- is used to scroll the window which may produce temporary visual
-- artifacts and unnecessary invalidations.
windowScroll ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@dx@/: Amount to scroll in the X direction
    -> Int32
    -- ^ /@dy@/: Amount to scroll in the Y direction
    -> m ()
windowScroll window dx dy = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_scroll window' dx dy
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowScrollMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowScrollMethodInfo a signature where
    overloadedMethod = windowScroll

instance O.OverloadedMethodInfo WindowScrollMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowScroll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowScroll"
        })


#endif

-- method Window::set_accept_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accept_focus"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the window should receive input focus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_accept_focus" gdk_window_set_accept_focus :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- accept_focus : TBasicType TBoolean
    IO ()

-- | Setting /@acceptFocus@/ to 'P.False' hints the desktop environment that the
-- window doesn’t want to receive input focus.
-- 
-- On X, it is the responsibility of the window manager to interpret this
-- hint. ICCCM-compliant window manager usually respect it.
-- 
-- /Since: 2.4/
windowSetAcceptFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@acceptFocus@/: 'P.True' if the window should receive input focus
    -> m ()
windowSetAcceptFocus window acceptFocus = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let acceptFocus' = (P.fromIntegral . P.fromEnum) acceptFocus
    gdk_window_set_accept_focus window' acceptFocus'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetAcceptFocusMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetAcceptFocusMethodInfo a signature where
    overloadedMethod = windowSetAcceptFocus

instance O.OverloadedMethodInfo WindowSetAcceptFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetAcceptFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetAcceptFocus"
        })


#endif

-- method Window::set_background
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkColor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_background" gdk_window_set_background :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Color.Color ->                  -- color : TInterface (Name {namespace = "Gdk", name = "Color"})
    IO ()

{-# DEPRECATED windowSetBackground ["(Since version 3.4)","Don\\'t use this function"] #-}
-- | Sets the background color of /@window@/.
-- 
-- However, when using GTK+, influence the background of a widget
-- using a style class or CSS — if you’re an application — or with
-- @/gtk_style_context_set_background()/@ — if you\'re implementing a
-- custom widget.
windowSetBackground ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Color.Color
    -- ^ /@color@/: a t'GI.Gdk.Structs.Color.Color'
    -> m ()
windowSetBackground window color = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    color' <- unsafeManagedPtrGetPtr color
    gdk_window_set_background window' color'
    touchManagedPtr window
    touchManagedPtr color
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetBackgroundMethodInfo
instance (signature ~ (Gdk.Color.Color -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetBackgroundMethodInfo a signature where
    overloadedMethod = windowSetBackground

instance O.OverloadedMethodInfo WindowSetBackgroundMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetBackground",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetBackground"
        })


#endif

-- method Window::set_background_pattern
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pattern"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Pattern" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pattern to use, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_background_pattern" gdk_window_set_background_pattern :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Pattern.Pattern ->            -- pattern : TInterface (Name {namespace = "cairo", name = "Pattern"})
    IO ()

{-# DEPRECATED windowSetBackgroundPattern ["(Since version 3.22)","Don\\'t use this function"] #-}
-- | Sets the background of /@window@/.
-- 
-- A background of 'P.Nothing' means that the window won\'t have any background. On the
-- X11 backend it\'s also possible to inherit the background from the parent
-- window using @/gdk_x11_get_parent_relative_pattern()/@.
-- 
-- The windowing system will normally fill a window with its background
-- when the window is obscured then exposed.
windowSetBackgroundPattern ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Maybe (Cairo.Pattern.Pattern)
    -- ^ /@pattern@/: a pattern to use, or 'P.Nothing'
    -> m ()
windowSetBackgroundPattern window pattern = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybePattern <- case pattern of
        Nothing -> return FP.nullPtr
        Just jPattern -> do
            jPattern' <- unsafeManagedPtrGetPtr jPattern
            return jPattern'
    gdk_window_set_background_pattern window' maybePattern
    touchManagedPtr window
    whenJust pattern touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetBackgroundPatternMethodInfo
instance (signature ~ (Maybe (Cairo.Pattern.Pattern) -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetBackgroundPatternMethodInfo a signature where
    overloadedMethod = windowSetBackgroundPattern

instance O.OverloadedMethodInfo WindowSetBackgroundPatternMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetBackgroundPattern",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetBackgroundPattern"
        })


#endif

-- method Window::set_background_rgba
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rgba"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkRGBA color" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_background_rgba" gdk_window_set_background_rgba :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.RGBA.RGBA ->                    -- rgba : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO ()

{-# DEPRECATED windowSetBackgroundRgba ["(Since version 3.22)","Don\\'t use this function"] #-}
-- | Sets the background color of /@window@/.
-- 
-- See also 'GI.Gdk.Objects.Window.windowSetBackgroundPattern'.
windowSetBackgroundRgba ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.RGBA.RGBA
    -- ^ /@rgba@/: a t'GI.Gdk.Structs.RGBA.RGBA' color
    -> m ()
windowSetBackgroundRgba window rgba = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    rgba' <- unsafeManagedPtrGetPtr rgba
    gdk_window_set_background_rgba window' rgba'
    touchManagedPtr window
    touchManagedPtr rgba
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetBackgroundRgbaMethodInfo
instance (signature ~ (Gdk.RGBA.RGBA -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetBackgroundRgbaMethodInfo a signature where
    overloadedMethod = windowSetBackgroundRgba

instance O.OverloadedMethodInfo WindowSetBackgroundRgbaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetBackgroundRgba",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetBackgroundRgba"
        })


#endif

-- method Window::set_child_input_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_child_input_shapes" gdk_window_set_child_input_shapes :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Sets the input shape mask of /@window@/ to the union of input shape masks
-- for all children of /@window@/, ignoring the input shape mask of /@window@/
-- itself. Contrast with 'GI.Gdk.Objects.Window.windowMergeChildInputShapes' which includes
-- the input shape mask of /@window@/ in the masks to be merged.
-- 
-- /Since: 2.10/
windowSetChildInputShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowSetChildInputShapes window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_set_child_input_shapes window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetChildInputShapesMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetChildInputShapesMethodInfo a signature where
    overloadedMethod = windowSetChildInputShapes

instance O.OverloadedMethodInfo WindowSetChildInputShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetChildInputShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetChildInputShapes"
        })


#endif

-- method Window::set_child_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_child_shapes" gdk_window_set_child_shapes :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Sets the shape mask of /@window@/ to the union of shape masks
-- for all children of /@window@/, ignoring the shape mask of /@window@/
-- itself. Contrast with 'GI.Gdk.Objects.Window.windowMergeChildShapes' which includes
-- the shape mask of /@window@/ in the masks to be merged.
windowSetChildShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowSetChildShapes window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_set_child_shapes window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetChildShapesMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetChildShapesMethodInfo a signature where
    overloadedMethod = windowSetChildShapes

instance O.OverloadedMethodInfo WindowSetChildShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetChildShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetChildShapes"
        })


#endif

-- method Window::set_composited
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "composited"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to set the window as composited"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_composited" gdk_window_set_composited :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- composited : TBasicType TBoolean
    IO ()

{-# DEPRECATED windowSetComposited ["(Since version 3.16)","Compositing is an outdated technology that","  only ever worked on X11."] #-}
-- | Sets a t'GI.Gdk.Objects.Window.Window' as composited, or unsets it. Composited
-- windows do not automatically have their contents drawn to
-- the screen. Drawing is redirected to an offscreen buffer
-- and an expose event is emitted on the parent of the composited
-- window. It is the responsibility of the parent’s expose handler
-- to manually merge the off-screen content onto the screen in
-- whatever way it sees fit.
-- 
-- It only makes sense for child windows to be composited; see
-- 'GI.Gdk.Objects.Window.windowSetOpacity' if you need translucent toplevel
-- windows.
-- 
-- An additional effect of this call is that the area of this
-- window is no longer clipped from regions marked for
-- invalidation on its parent. Draws done on the parent
-- window are also no longer clipped by the child.
-- 
-- This call is only supported on some systems (currently,
-- only X11 with new enough Xcomposite and Xdamage extensions).
-- You must call 'GI.Gdk.Objects.Display.displaySupportsComposite' to check if
-- setting a window as composited is supported before
-- attempting to do so.
-- 
-- /Since: 2.12/
windowSetComposited ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@composited@/: 'P.True' to set the window as composited
    -> m ()
windowSetComposited window composited = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let composited' = (P.fromIntegral . P.fromEnum) composited
    gdk_window_set_composited window' composited'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetCompositedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetCompositedMethodInfo a signature where
    overloadedMethod = windowSetComposited

instance O.OverloadedMethodInfo WindowSetCompositedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetComposited",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetComposited"
        })


#endif

-- method Window::set_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_cursor" gdk_window_set_cursor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Cursor.Cursor ->                -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO ()

-- | Sets the default mouse pointer for a t'GI.Gdk.Objects.Window.Window'.
-- 
-- Note that /@cursor@/ must be for the same display as /@window@/.
-- 
-- Use 'GI.Gdk.Objects.Cursor.cursorNewForDisplay' or 'GI.Gdk.Objects.Cursor.cursorNewFromPixbuf' to
-- create the cursor. To make the cursor invisible, use 'GI.Gdk.Enums.CursorTypeBlankCursor'.
-- Passing 'P.Nothing' for the /@cursor@/ argument to 'GI.Gdk.Objects.Window.windowSetCursor' means
-- that /@window@/ will use the cursor of its parent window. Most windows
-- should use this default.
windowSetCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Cursor.IsCursor b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Maybe (b)
    -- ^ /@cursor@/: a cursor
    -> m ()
windowSetCursor window cursor = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeCursor <- case cursor of
        Nothing -> return FP.nullPtr
        Just jCursor -> do
            jCursor' <- unsafeManagedPtrCastPtr jCursor
            return jCursor'
    gdk_window_set_cursor window' maybeCursor
    touchManagedPtr window
    whenJust cursor touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetCursorMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, Gdk.Cursor.IsCursor b) => O.OverloadedMethod WindowSetCursorMethodInfo a signature where
    overloadedMethod = windowSetCursor

instance O.OverloadedMethodInfo WindowSetCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetCursor"
        })


#endif

-- method Window::set_decorations
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "decorations"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WMDecoration" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "decoration hint mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_decorations" gdk_window_set_decorations :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- decorations : TInterface (Name {namespace = "Gdk", name = "WMDecoration"})
    IO ()

-- | “Decorations” are the features the window manager adds to a toplevel t'GI.Gdk.Objects.Window.Window'.
-- This function sets the traditional Motif window manager hints that tell the
-- window manager which decorations you would like your window to have.
-- Usually you should use @/gtk_window_set_decorated()/@ on a @/GtkWindow/@ instead of
-- using the GDK function directly.
-- 
-- The /@decorations@/ argument is the logical OR of the fields in
-- the t'GI.Gdk.Flags.WMDecoration' enumeration. If @/GDK_DECOR_ALL/@ is included in the
-- mask, the other bits indicate which decorations should be turned off.
-- If @/GDK_DECOR_ALL/@ is not included, then the other bits indicate
-- which decorations should be turned on.
-- 
-- Most window managers honor a decorations hint of 0 to disable all decorations,
-- but very few honor all possible combinations of bits.
windowSetDecorations ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> [Gdk.Flags.WMDecoration]
    -- ^ /@decorations@/: decoration hint mask
    -> m ()
windowSetDecorations window decorations = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let decorations' = gflagsToWord decorations
    gdk_window_set_decorations window' decorations'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDecorationsMethodInfo
instance (signature ~ ([Gdk.Flags.WMDecoration] -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetDecorationsMethodInfo a signature where
    overloadedMethod = windowSetDecorations

instance O.OverloadedMethodInfo WindowSetDecorationsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetDecorations",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetDecorations"
        })


#endif

-- method Window::set_device_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a master, pointer #GdkDevice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkCursor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_device_cursor" gdk_window_set_device_cursor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr Gdk.Cursor.Cursor ->                -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO ()

-- | Sets a specific t'GI.Gdk.Objects.Cursor.Cursor' for a given device when it gets inside /@window@/.
-- Use 'GI.Gdk.Objects.Cursor.cursorNewForDisplay' or 'GI.Gdk.Objects.Cursor.cursorNewFromPixbuf' to create
-- the cursor. To make the cursor invisible, use 'GI.Gdk.Enums.CursorTypeBlankCursor'. Passing
-- 'P.Nothing' for the /@cursor@/ argument to 'GI.Gdk.Objects.Window.windowSetCursor' means that
-- /@window@/ will use the cursor of its parent window. Most windows should
-- use this default.
-- 
-- /Since: 3.0/
windowSetDeviceCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b, Gdk.Cursor.IsCursor c) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@device@/: a master, pointer t'GI.Gdk.Objects.Device.Device'
    -> c
    -- ^ /@cursor@/: a t'GI.Gdk.Objects.Cursor.Cursor'
    -> m ()
windowSetDeviceCursor window device cursor = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    cursor' <- unsafeManagedPtrCastPtr cursor
    gdk_window_set_device_cursor window' device' cursor'
    touchManagedPtr window
    touchManagedPtr device
    touchManagedPtr cursor
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDeviceCursorMethodInfo
instance (signature ~ (b -> c -> m ()), MonadIO m, IsWindow a, Gdk.Device.IsDevice b, Gdk.Cursor.IsCursor c) => O.OverloadedMethod WindowSetDeviceCursorMethodInfo a signature where
    overloadedMethod = windowSetDeviceCursor

instance O.OverloadedMethodInfo WindowSetDeviceCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetDeviceCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetDeviceCursor"
        })


#endif

-- method Window::set_device_events
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GdkDevice to enable events for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "event mask for @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_device_events" gdk_window_set_device_events :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    CUInt ->                                -- event_mask : TInterface (Name {namespace = "Gdk", name = "EventMask"})
    IO ()

-- | Sets the event mask for a given device (Normally a floating device, not
-- attached to any visible pointer) to /@window@/. For example, an event mask
-- including @/GDK_BUTTON_PRESS_MASK/@ means the window should report button
-- press events. The event mask is the bitwise OR of values from the
-- t'GI.Gdk.Flags.EventMask' enumeration.
-- 
-- See the [input handling overview][event-masks] for details.
-- 
-- /Since: 3.0/
windowSetDeviceEvents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@device@/: t'GI.Gdk.Objects.Device.Device' to enable events for.
    -> [Gdk.Flags.EventMask]
    -- ^ /@eventMask@/: event mask for /@window@/
    -> m ()
windowSetDeviceEvents window device eventMask = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    let eventMask' = gflagsToWord eventMask
    gdk_window_set_device_events window' device' eventMask'
    touchManagedPtr window
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDeviceEventsMethodInfo
instance (signature ~ (b -> [Gdk.Flags.EventMask] -> m ()), MonadIO m, IsWindow a, Gdk.Device.IsDevice b) => O.OverloadedMethod WindowSetDeviceEventsMethodInfo a signature where
    overloadedMethod = windowSetDeviceEvents

instance O.OverloadedMethodInfo WindowSetDeviceEventsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetDeviceEvents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetDeviceEvents"
        })


#endif

-- method Window::set_event_compression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_compression"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if motion events should be compressed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_event_compression" gdk_window_set_event_compression :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- event_compression : TBasicType TBoolean
    IO ()

-- | Determines whether or not extra unprocessed motion events in
-- the event queue can be discarded. If 'P.True' only the most recent
-- event will be delivered.
-- 
-- Some types of applications, e.g. paint programs, need to see all
-- motion events and will benefit from turning off event compression.
-- 
-- By default, event compression is enabled.
-- 
-- /Since: 3.12/
windowSetEventCompression ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@eventCompression@/: 'P.True' if motion events should be compressed
    -> m ()
windowSetEventCompression window eventCompression = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let eventCompression' = (P.fromIntegral . P.fromEnum) eventCompression
    gdk_window_set_event_compression window' eventCompression'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetEventCompressionMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetEventCompressionMethodInfo a signature where
    overloadedMethod = windowSetEventCompression

instance O.OverloadedMethodInfo WindowSetEventCompressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetEventCompression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetEventCompression"
        })


#endif

-- method Window::set_events
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "event mask for @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_events" gdk_window_set_events :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- event_mask : TInterface (Name {namespace = "Gdk", name = "EventMask"})
    IO ()

-- | The event mask for a window determines which events will be reported
-- for that window from all master input devices. For example, an event mask
-- including @/GDK_BUTTON_PRESS_MASK/@ means the window should report button
-- press events. The event mask is the bitwise OR of values from the
-- t'GI.Gdk.Flags.EventMask' enumeration.
-- 
-- See the [input handling overview][event-masks] for details.
windowSetEvents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> [Gdk.Flags.EventMask]
    -- ^ /@eventMask@/: event mask for /@window@/
    -> m ()
windowSetEvents window eventMask = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let eventMask' = gflagsToWord eventMask
    gdk_window_set_events window' eventMask'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetEventsMethodInfo
instance (signature ~ ([Gdk.Flags.EventMask] -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetEventsMethodInfo a signature where
    overloadedMethod = windowSetEvents

instance O.OverloadedMethodInfo WindowSetEventsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetEvents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetEvents"
        })


#endif

-- method Window::set_focus_on_map
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "focus_on_map"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the window should receive input focus when mapped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_focus_on_map" gdk_window_set_focus_on_map :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- focus_on_map : TBasicType TBoolean
    IO ()

-- | Setting /@focusOnMap@/ to 'P.False' hints the desktop environment that the
-- window doesn’t want to receive input focus when it is mapped.
-- focus_on_map should be turned off for windows that aren’t triggered
-- interactively (such as popups from network activity).
-- 
-- On X, it is the responsibility of the window manager to interpret
-- this hint. Window managers following the freedesktop.org window
-- manager extension specification should respect it.
-- 
-- /Since: 2.6/
windowSetFocusOnMap ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@focusOnMap@/: 'P.True' if the window should receive input focus when mapped
    -> m ()
windowSetFocusOnMap window focusOnMap = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let focusOnMap' = (P.fromIntegral . P.fromEnum) focusOnMap
    gdk_window_set_focus_on_map window' focusOnMap'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetFocusOnMapMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetFocusOnMapMethodInfo a signature where
    overloadedMethod = windowSetFocusOnMap

instance O.OverloadedMethodInfo WindowSetFocusOnMapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetFocusOnMap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetFocusOnMap"
        })


#endif

-- method Window::set_fullscreen_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FullscreenMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "fullscreen mode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_fullscreen_mode" gdk_window_set_fullscreen_mode :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gdk", name = "FullscreenMode"})
    IO ()

-- | Specifies whether the /@window@/ should span over all monitors (in a multi-head
-- setup) or only the current monitor when in fullscreen mode.
-- 
-- The /@mode@/ argument is from the t'GI.Gdk.Enums.FullscreenMode' enumeration.
-- If @/GDK_FULLSCREEN_ON_ALL_MONITORS/@ is specified, the fullscreen /@window@/ will
-- span over all monitors from the t'GI.Gdk.Objects.Screen.Screen'.
-- 
-- On X11, searches through the list of monitors from the t'GI.Gdk.Objects.Screen.Screen' the ones
-- which delimit the 4 edges of the entire t'GI.Gdk.Objects.Screen.Screen' and will ask the window
-- manager to span the /@window@/ over these monitors.
-- 
-- If the XINERAMA extension is not available or not usable, this function
-- has no effect.
-- 
-- Not all window managers support this, so you can’t rely on the fullscreen
-- window to span over the multiple monitors when @/GDK_FULLSCREEN_ON_ALL_MONITORS/@
-- is specified.
-- 
-- /Since: 3.8/
windowSetFullscreenMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Enums.FullscreenMode
    -- ^ /@mode@/: fullscreen mode
    -> m ()
windowSetFullscreenMode window mode = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let mode' = (fromIntegral . fromEnum) mode
    gdk_window_set_fullscreen_mode window' mode'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetFullscreenModeMethodInfo
instance (signature ~ (Gdk.Enums.FullscreenMode -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetFullscreenModeMethodInfo a signature where
    overloadedMethod = windowSetFullscreenMode

instance O.OverloadedMethodInfo WindowSetFullscreenModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetFullscreenMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetFullscreenMode"
        })


#endif

-- method Window::set_functions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "functions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WMFunction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bitmask of operations to allow on @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_functions" gdk_window_set_functions :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- functions : TInterface (Name {namespace = "Gdk", name = "WMFunction"})
    IO ()

-- | Sets hints about the window management functions to make available
-- via buttons on the window frame.
-- 
-- On the X backend, this function sets the traditional Motif window
-- manager hint for this purpose. However, few window managers do
-- anything reliable or interesting with this hint. Many ignore it
-- entirely.
-- 
-- The /@functions@/ argument is the logical OR of values from the
-- t'GI.Gdk.Flags.WMFunction' enumeration. If the bitmask includes @/GDK_FUNC_ALL/@,
-- then the other bits indicate which functions to disable; if
-- it doesn’t include @/GDK_FUNC_ALL/@, it indicates which functions to
-- enable.
windowSetFunctions ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> [Gdk.Flags.WMFunction]
    -- ^ /@functions@/: bitmask of operations to allow on /@window@/
    -> m ()
windowSetFunctions window functions = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let functions' = gflagsToWord functions
    gdk_window_set_functions window' functions'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetFunctionsMethodInfo
instance (signature ~ ([Gdk.Flags.WMFunction] -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetFunctionsMethodInfo a signature where
    overloadedMethod = windowSetFunctions

instance O.OverloadedMethodInfo WindowSetFunctionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetFunctions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetFunctions"
        })


#endif

-- method Window::set_geometry_hints
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "geometry"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Geometry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "geometry hints" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "geom_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowHints" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "bitmask indicating fields of @geometry to pay attention to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_geometry_hints" gdk_window_set_geometry_hints :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Geometry.Geometry ->            -- geometry : TInterface (Name {namespace = "Gdk", name = "Geometry"})
    CUInt ->                                -- geom_mask : TInterface (Name {namespace = "Gdk", name = "WindowHints"})
    IO ()

-- | Sets the geometry hints for /@window@/. Hints flagged in /@geomMask@/
-- are set, hints not flagged in /@geomMask@/ are unset.
-- To unset all hints, use a /@geomMask@/ of 0 and a /@geometry@/ of 'P.Nothing'.
-- 
-- This function provides hints to the windowing system about
-- acceptable sizes for a toplevel window. The purpose of
-- this is to constrain user resizing, but the windowing system
-- will typically  (but is not required to) also constrain the
-- current size of the window to the provided values and
-- constrain programatic resizing via 'GI.Gdk.Objects.Window.windowResize' or
-- 'GI.Gdk.Objects.Window.windowMoveResize'.
-- 
-- Note that on X11, this effect has no effect on windows
-- of type 'GI.Gdk.Enums.WindowTypeTemp' or windows where override redirect
-- has been turned on via 'GI.Gdk.Objects.Window.windowSetOverrideRedirect'
-- since these windows are not resizable by the user.
-- 
-- Since you can’t count on the windowing system doing the
-- constraints for programmatic resizes, you should generally
-- call 'GI.Gdk.Objects.Window.windowConstrainSize' yourself to determine
-- appropriate sizes.
windowSetGeometryHints ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Geometry.Geometry
    -- ^ /@geometry@/: geometry hints
    -> [Gdk.Flags.WindowHints]
    -- ^ /@geomMask@/: bitmask indicating fields of /@geometry@/ to pay attention to
    -> m ()
windowSetGeometryHints window geometry geomMask = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    geometry' <- unsafeManagedPtrGetPtr geometry
    let geomMask' = gflagsToWord geomMask
    gdk_window_set_geometry_hints window' geometry' geomMask'
    touchManagedPtr window
    touchManagedPtr geometry
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetGeometryHintsMethodInfo
instance (signature ~ (Gdk.Geometry.Geometry -> [Gdk.Flags.WindowHints] -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetGeometryHintsMethodInfo a signature where
    overloadedMethod = windowSetGeometryHints

instance O.OverloadedMethodInfo WindowSetGeometryHintsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetGeometryHints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetGeometryHints"
        })


#endif

-- method Window::set_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "leader"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "group leader window, or %NULL to restore the default group leader window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_group" gdk_window_set_group :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Window ->                           -- leader : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Sets the group leader window for /@window@/. By default,
-- GDK sets the group leader for all toplevel windows
-- to a global window implicitly created by GDK. With this function
-- you can override this default.
-- 
-- The group leader window allows the window manager to distinguish
-- all windows that belong to a single application. It may for example
-- allow users to minimize\/unminimize all windows belonging to an
-- application at once. You should only set a non-default group window
-- if your application pretends to be multiple applications.
windowSetGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, IsWindow b) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Maybe (b)
    -- ^ /@leader@/: group leader window, or 'P.Nothing' to restore the default group leader window
    -> m ()
windowSetGroup window leader = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeLeader <- case leader of
        Nothing -> return FP.nullPtr
        Just jLeader -> do
            jLeader' <- unsafeManagedPtrCastPtr jLeader
            return jLeader'
    gdk_window_set_group window' maybeLeader
    touchManagedPtr window
    whenJust leader touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetGroupMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, IsWindow b) => O.OverloadedMethod WindowSetGroupMethodInfo a signature where
    overloadedMethod = windowSetGroup

instance O.OverloadedMethodInfo WindowSetGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetGroup"
        })


#endif

-- method Window::set_icon_list
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #GdkWindow toplevel window to set the icon of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbufs"
--           , argType =
--               TGList
--                 (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n    A list of pixbufs, of different sizes."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_icon_list" gdk_window_set_icon_list :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr (GList (Ptr GdkPixbuf.Pixbuf.Pixbuf)) -> -- pixbufs : TGList (TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"}))
    IO ()

-- | Sets a list of icons for the window. One of these will be used
-- to represent the window when it has been iconified. The icon is
-- usually shown in an icon box or some sort of task bar. Which icon
-- size is shown depends on the window manager. The window manager
-- can scale the icon  but setting several size icons can give better
-- image quality since the window manager may only need to scale the
-- icon by a small amount or not at all.
-- 
-- Note that some platforms don\'t support window icons.
windowSetIconList ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, GdkPixbuf.Pixbuf.IsPixbuf b) =>
    a
    -- ^ /@window@/: The t'GI.Gdk.Objects.Window.Window' toplevel window to set the icon of.
    -> [b]
    -- ^ /@pixbufs@/: 
    --     A list of pixbufs, of different sizes.
    -> m ()
windowSetIconList window pixbufs = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    pixbufs' <- mapM unsafeManagedPtrCastPtr pixbufs
    pixbufs'' <- packGList pixbufs'
    gdk_window_set_icon_list window' pixbufs''
    touchManagedPtr window
    mapM_ touchManagedPtr pixbufs
    g_list_free pixbufs''
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetIconListMethodInfo
instance (signature ~ ([b] -> m ()), MonadIO m, IsWindow a, GdkPixbuf.Pixbuf.IsPixbuf b) => O.OverloadedMethod WindowSetIconListMethodInfo a signature where
    overloadedMethod = windowSetIconList

instance O.OverloadedMethodInfo WindowSetIconListMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetIconList",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetIconList"
        })


#endif

-- method Window::set_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of window while iconified (minimized)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_icon_name" gdk_window_set_icon_name :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Windows may have a name used while minimized, distinct from the
-- name they display in their titlebar. Most of the time this is a bad
-- idea from a user interface standpoint. But you can set such a name
-- with this function, if you like.
-- 
-- After calling this with a non-'P.Nothing' /@name@/, calls to 'GI.Gdk.Objects.Window.windowSetTitle'
-- will not update the icon title.
-- 
-- Using 'P.Nothing' for /@name@/ unsets the icon title; further calls to
-- 'GI.Gdk.Objects.Window.windowSetTitle' will again update the icon title as well.
-- 
-- Note that some platforms don\'t support window icons.
windowSetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Maybe (T.Text)
    -- ^ /@name@/: name of window while iconified (minimized)
    -> m ()
windowSetIconName window name = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    gdk_window_set_icon_name window' maybeName
    touchManagedPtr window
    freeMem maybeName
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetIconNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetIconNameMethodInfo a signature where
    overloadedMethod = windowSetIconName

instance O.OverloadedMethodInfo WindowSetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetIconName"
        })


#endif

-- method Window::set_keep_above
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to keep @window above other windows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_keep_above" gdk_window_set_keep_above :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Set if /@window@/ must be kept above other windows. If the
-- window was already above, then this function does nothing.
-- 
-- On X11, asks the window manager to keep /@window@/ above, if the window
-- manager supports this operation. Not all window managers support
-- this, and some deliberately ignore it or don’t have a concept of
-- “keep above”; so you can’t rely on the window being kept above.
-- But it will happen with most standard window managers,
-- and GDK makes a best effort to get it to happen.
-- 
-- /Since: 2.4/
windowSetKeepAbove ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@setting@/: whether to keep /@window@/ above other windows
    -> m ()
windowSetKeepAbove window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gdk_window_set_keep_above window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetKeepAboveMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetKeepAboveMethodInfo a signature where
    overloadedMethod = windowSetKeepAbove

instance O.OverloadedMethodInfo WindowSetKeepAboveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetKeepAbove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetKeepAbove"
        })


#endif

-- method Window::set_keep_below
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to keep @window below other windows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_keep_below" gdk_window_set_keep_below :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Set if /@window@/ must be kept below other windows. If the
-- window was already below, then this function does nothing.
-- 
-- On X11, asks the window manager to keep /@window@/ below, if the window
-- manager supports this operation. Not all window managers support
-- this, and some deliberately ignore it or don’t have a concept of
-- “keep below”; so you can’t rely on the window being kept below.
-- But it will happen with most standard window managers,
-- and GDK makes a best effort to get it to happen.
-- 
-- /Since: 2.4/
windowSetKeepBelow ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@setting@/: whether to keep /@window@/ below other windows
    -> m ()
windowSetKeepBelow window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gdk_window_set_keep_below window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetKeepBelowMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetKeepBelowMethodInfo a signature where
    overloadedMethod = windowSetKeepBelow

instance O.OverloadedMethodInfo WindowSetKeepBelowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetKeepBelow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetKeepBelow"
        })


#endif

-- method Window::set_modal_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the window is modal, %FALSE otherwise."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_modal_hint" gdk_window_set_modal_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

-- | The application can use this hint to tell the window manager
-- that a certain window has modal behaviour. The window manager
-- can use this information to handle modal windows in a special
-- way.
-- 
-- You should only use this on windows for which you have
-- previously called 'GI.Gdk.Objects.Window.windowSetTransientFor'
windowSetModalHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: A toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@modal@/: 'P.True' if the window is modal, 'P.False' otherwise.
    -> m ()
windowSetModalHint window modal = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gdk_window_set_modal_hint window' modal'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetModalHintMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetModalHintMethodInfo a signature where
    overloadedMethod = windowSetModalHint

instance O.OverloadedMethodInfo WindowSetModalHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetModalHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetModalHint"
        })


#endif

-- method Window::set_opacity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a top-level or non-native #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "opacity"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "opacity" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_opacity" gdk_window_set_opacity :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CDouble ->                              -- opacity : TBasicType TDouble
    IO ()

-- | Set /@window@/ to render as partially transparent,
-- with opacity 0 being fully transparent and 1 fully opaque. (Values
-- of the opacity parameter are clamped to the [0,1] range.)
-- 
-- For toplevel windows this depends on support from the windowing system
-- that may not always be there. For instance, On X11, this works only on
-- X screens with a compositing manager running. On Wayland, there is no
-- per-window opacity value that the compositor would apply. Instead, use
-- @gdk_window_set_opaque_region (window, NULL)@ to tell the compositor
-- that the entire window is (potentially) non-opaque, and draw your content
-- with alpha, or use @/gtk_widget_set_opacity()/@ to set an overall opacity
-- for your widgets.
-- 
-- For child windows this function only works for non-native windows.
-- 
-- For setting up per-pixel alpha topelevels, see 'GI.Gdk.Objects.Screen.screenGetRgbaVisual',
-- and for non-toplevels, see 'GI.Gdk.Objects.Window.windowSetComposited'.
-- 
-- Support for non-toplevel windows was added in 3.8.
-- 
-- /Since: 2.12/
windowSetOpacity ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a top-level or non-native t'GI.Gdk.Objects.Window.Window'
    -> Double
    -- ^ /@opacity@/: opacity
    -> m ()
windowSetOpacity window opacity = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let opacity' = realToFrac opacity
    gdk_window_set_opacity window' opacity'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetOpacityMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetOpacityMethodInfo a signature where
    overloadedMethod = windowSetOpacity

instance O.OverloadedMethodInfo WindowSetOpacityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetOpacity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetOpacity"
        })


#endif

-- method Window::set_opaque_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a top-level or non-native #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a region, or %NULL" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_opaque_region" gdk_window_set_opaque_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

-- | For optimisation purposes, compositing window managers may
-- like to not draw obscured regions of windows, or turn off blending
-- during for these regions. With RGB windows with no transparency,
-- this is just the shape of the window, but with ARGB32 windows, the
-- compositor does not know what regions of the window are transparent
-- or not.
-- 
-- This function only works for toplevel windows.
-- 
-- GTK+ will update this property automatically if
-- the /@window@/ background is opaque, as we know where the opaque regions
-- are. If your window background is not opaque, please update this
-- property in your @/GtkWidget::style-updated/@ handler.
-- 
-- /Since: 3.10/
windowSetOpaqueRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a top-level or non-native t'GI.Gdk.Objects.Window.Window'
    -> Maybe (Cairo.Region.Region)
    -- ^ /@region@/: a region, or 'P.Nothing'
    -> m ()
windowSetOpaqueRegion window region = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeRegion <- case region of
        Nothing -> return FP.nullPtr
        Just jRegion -> do
            jRegion' <- unsafeManagedPtrGetPtr jRegion
            return jRegion'
    gdk_window_set_opaque_region window' maybeRegion
    touchManagedPtr window
    whenJust region touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetOpaqueRegionMethodInfo
instance (signature ~ (Maybe (Cairo.Region.Region) -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetOpaqueRegionMethodInfo a signature where
    overloadedMethod = windowSetOpaqueRegion

instance O.OverloadedMethodInfo WindowSetOpaqueRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetOpaqueRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetOpaqueRegion"
        })


#endif

-- method Window::set_override_redirect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "override_redirect"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if window should be override redirect"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_override_redirect" gdk_window_set_override_redirect :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- override_redirect : TBasicType TBoolean
    IO ()

-- | An override redirect window is not under the control of the window manager.
-- This means it won’t have a titlebar, won’t be minimizable, etc. - it will
-- be entirely under the control of the application. The window manager
-- can’t see the override redirect window at all.
-- 
-- Override redirect should only be used for short-lived temporary
-- windows, such as popup menus. @/GtkMenu/@ uses an override redirect
-- window in its implementation, for example.
windowSetOverrideRedirect ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@overrideRedirect@/: 'P.True' if window should be override redirect
    -> m ()
windowSetOverrideRedirect window overrideRedirect = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let overrideRedirect' = (P.fromIntegral . P.fromEnum) overrideRedirect
    gdk_window_set_override_redirect window' overrideRedirect'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetOverrideRedirectMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetOverrideRedirectMethodInfo a signature where
    overloadedMethod = windowSetOverrideRedirect

instance O.OverloadedMethodInfo WindowSetOverrideRedirectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetOverrideRedirect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetOverrideRedirect"
        })


#endif

-- method Window::set_pass_through
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pass_through"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a boolean" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_pass_through" gdk_window_set_pass_through :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- pass_through : TBasicType TBoolean
    IO ()

-- | Sets whether input to the window is passed through to the window
-- below.
-- 
-- The default value of this is 'P.False', which means that pointer
-- events that happen inside the window are send first to the window,
-- but if the event is not selected by the event mask then the event
-- is sent to the parent window, and so on up the hierarchy.
-- 
-- If /@passThrough@/ is 'P.True' then such pointer events happen as if the
-- window wasn\'t there at all, and thus will be sent first to any
-- windows below /@window@/. This is useful if the window is used in a
-- transparent fashion. In the terminology of the web this would be called
-- \"pointer-events: none\".
-- 
-- Note that a window with /@passThrough@/ 'P.True' can still have a subwindow
-- without pass through, so you can get events on a subset of a window. And in
-- that cases you would get the in-between related events such as the pointer
-- enter\/leave events on its way to the destination window.
-- 
-- /Since: 3.18/
windowSetPassThrough ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@passThrough@/: a boolean
    -> m ()
windowSetPassThrough window passThrough = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let passThrough' = (P.fromIntegral . P.fromEnum) passThrough
    gdk_window_set_pass_through window' passThrough'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetPassThroughMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetPassThroughMethodInfo a signature where
    overloadedMethod = windowSetPassThrough

instance O.OverloadedMethodInfo WindowSetPassThroughMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetPassThrough",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetPassThrough"
        })


#endif

-- method Window::set_role
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "role"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string indicating its role"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_role" gdk_window_set_role :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CString ->                              -- role : TBasicType TUTF8
    IO ()

-- | When using GTK+, typically you should use @/gtk_window_set_role()/@ instead
-- of this low-level function.
-- 
-- The window manager and session manager use a window’s role to
-- distinguish it from other kinds of window in the same application.
-- When an application is restarted after being saved in a previous
-- session, all windows with the same title and role are treated as
-- interchangeable.  So if you have two windows with the same title
-- that should be distinguished for session management purposes, you
-- should set the role on those windows. It doesn’t matter what string
-- you use for the role, as long as you have a different role for each
-- non-interchangeable kind of window.
windowSetRole ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> T.Text
    -- ^ /@role@/: a string indicating its role
    -> m ()
windowSetRole window role = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    role' <- textToCString role
    gdk_window_set_role window' role'
    touchManagedPtr window
    freeMem role'
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetRoleMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetRoleMethodInfo a signature where
    overloadedMethod = windowSetRole

instance O.OverloadedMethodInfo WindowSetRoleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetRole",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetRole"
        })


#endif

-- method Window::set_shadow_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "left"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The left extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "right"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The right extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "top"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The top extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bottom"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The bottom extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_shadow_width" gdk_window_set_shadow_width :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- left : TBasicType TInt
    Int32 ->                                -- right : TBasicType TInt
    Int32 ->                                -- top : TBasicType TInt
    Int32 ->                                -- bottom : TBasicType TInt
    IO ()

-- | Newer GTK+ windows using client-side decorations use extra geometry
-- around their frames for effects like shadows and invisible borders.
-- Window managers that want to maximize windows or snap to edges need
-- to know where the extents of the actual frame lie, so that users
-- don’t feel like windows are snapping against random invisible edges.
-- 
-- Note that this property is automatically updated by GTK+, so this
-- function should only be used by applications which do not use GTK+
-- to create toplevel windows.
-- 
-- /Since: 3.12/
windowSetShadowWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@left@/: The left extent
    -> Int32
    -- ^ /@right@/: The right extent
    -> Int32
    -- ^ /@top@/: The top extent
    -> Int32
    -- ^ /@bottom@/: The bottom extent
    -> m ()
windowSetShadowWidth window left right top bottom = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_set_shadow_width window' left right top bottom
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetShadowWidthMethodInfo
instance (signature ~ (Int32 -> Int32 -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetShadowWidthMethodInfo a signature where
    overloadedMethod = windowSetShadowWidth

instance O.OverloadedMethodInfo WindowSetShadowWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetShadowWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetShadowWidth"
        })


#endif

-- method Window::set_skip_pager_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "skips_pager"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to skip the pager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_skip_pager_hint" gdk_window_set_skip_pager_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- skips_pager : TBasicType TBoolean
    IO ()

-- | Toggles whether a window should appear in a pager (workspace
-- switcher, or other desktop utility program that displays a small
-- thumbnail representation of the windows on the desktop). If a
-- window’s semantic type as specified with 'GI.Gdk.Objects.Window.windowSetTypeHint'
-- already fully describes the window, this function should
-- not be called in addition, instead you should
-- allow the window to be treated according to standard policy for
-- its semantic type.
-- 
-- /Since: 2.2/
windowSetSkipPagerHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@skipsPager@/: 'P.True' to skip the pager
    -> m ()
windowSetSkipPagerHint window skipsPager = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let skipsPager' = (P.fromIntegral . P.fromEnum) skipsPager
    gdk_window_set_skip_pager_hint window' skipsPager'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetSkipPagerHintMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetSkipPagerHintMethodInfo a signature where
    overloadedMethod = windowSetSkipPagerHint

instance O.OverloadedMethodInfo WindowSetSkipPagerHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetSkipPagerHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetSkipPagerHint"
        })


#endif

-- method Window::set_skip_taskbar_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "skips_taskbar"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to skip the taskbar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_skip_taskbar_hint" gdk_window_set_skip_taskbar_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- skips_taskbar : TBasicType TBoolean
    IO ()

-- | Toggles whether a window should appear in a task list or window
-- list. If a window’s semantic type as specified with
-- 'GI.Gdk.Objects.Window.windowSetTypeHint' already fully describes the window, this
-- function should not be called in addition,
-- instead you should allow the window to be treated according to
-- standard policy for its semantic type.
-- 
-- /Since: 2.2/
windowSetSkipTaskbarHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@skipsTaskbar@/: 'P.True' to skip the taskbar
    -> m ()
windowSetSkipTaskbarHint window skipsTaskbar = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let skipsTaskbar' = (P.fromIntegral . P.fromEnum) skipsTaskbar
    gdk_window_set_skip_taskbar_hint window' skipsTaskbar'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetSkipTaskbarHintMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetSkipTaskbarHintMethodInfo a signature where
    overloadedMethod = windowSetSkipTaskbarHint

instance O.OverloadedMethodInfo WindowSetSkipTaskbarHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetSkipTaskbarHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetSkipTaskbarHint"
        })


#endif

-- method Window::set_source_events
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "InputSource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkInputSource to define the source class."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "event mask for @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_source_events" gdk_window_set_source_events :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- source : TInterface (Name {namespace = "Gdk", name = "InputSource"})
    CUInt ->                                -- event_mask : TInterface (Name {namespace = "Gdk", name = "EventMask"})
    IO ()

-- | Sets the event mask for any floating device (i.e. not attached to any
-- visible pointer) that has the source defined as /@source@/. This event
-- mask will be applied both to currently existing, newly added devices
-- after this call, and devices being attached\/detached.
-- 
-- /Since: 3.0/
windowSetSourceEvents ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Enums.InputSource
    -- ^ /@source@/: a t'GI.Gdk.Enums.InputSource' to define the source class.
    -> [Gdk.Flags.EventMask]
    -- ^ /@eventMask@/: event mask for /@window@/
    -> m ()
windowSetSourceEvents window source eventMask = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let source' = (fromIntegral . fromEnum) source
    let eventMask' = gflagsToWord eventMask
    gdk_window_set_source_events window' source' eventMask'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetSourceEventsMethodInfo
instance (signature ~ (Gdk.Enums.InputSource -> [Gdk.Flags.EventMask] -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetSourceEventsMethodInfo a signature where
    overloadedMethod = windowSetSourceEvents

instance O.OverloadedMethodInfo WindowSetSourceEventsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetSourceEvents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetSourceEvents"
        })


#endif

-- method Window::set_startup_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string with startup-notification identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_startup_id" gdk_window_set_startup_id :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

-- | When using GTK+, typically you should use @/gtk_window_set_startup_id()/@
-- instead of this low-level function.
-- 
-- /Since: 2.12/
windowSetStartupId ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> T.Text
    -- ^ /@startupId@/: a string with startup-notification identifier
    -> m ()
windowSetStartupId window startupId = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    startupId' <- textToCString startupId
    gdk_window_set_startup_id window' startupId'
    touchManagedPtr window
    freeMem startupId'
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetStartupIdMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetStartupIdMethodInfo a signature where
    overloadedMethod = windowSetStartupId

instance O.OverloadedMethodInfo WindowSetStartupIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetStartupId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetStartupId"
        })


#endif

-- method Window::set_static_gravities
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_static"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to turn on static gravity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_static_gravities" gdk_window_set_static_gravities :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- use_static : TBasicType TBoolean
    IO CInt

{-# DEPRECATED windowSetStaticGravities ["(Since version 3.16)","static gravities haven\\'t worked on anything but X11","  for a long time."] #-}
-- | Used to set the bit gravity of the given window to static, and flag
-- it so all children get static subwindow gravity. This is used if you
-- are implementing scary features that involve deep knowledge of the
-- windowing system. Don’t worry about it.
windowSetStaticGravities ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@useStatic@/: 'P.True' to turn on static gravity
    -> m Bool
    -- ^ __Returns:__ 'P.False'
windowSetStaticGravities window useStatic = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let useStatic' = (P.fromIntegral . P.fromEnum) useStatic
    result <- gdk_window_set_static_gravities window' useStatic'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowSetStaticGravitiesMethodInfo
instance (signature ~ (Bool -> m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetStaticGravitiesMethodInfo a signature where
    overloadedMethod = windowSetStaticGravities

instance O.OverloadedMethodInfo WindowSetStaticGravitiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetStaticGravities",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetStaticGravities"
        })


#endif

-- method Window::set_support_multidevice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "support_multidevice"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE to enable multidevice support in @window."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_support_multidevice" gdk_window_set_support_multidevice :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- support_multidevice : TBasicType TBoolean
    IO ()

-- | This function will enable multidevice features in /@window@/.
-- 
-- Multidevice aware windows will need to handle properly multiple,
-- per device enter\/leave events, device grabs and grab ownerships.
-- 
-- /Since: 3.0/
windowSetSupportMultidevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'.
    -> Bool
    -- ^ /@supportMultidevice@/: 'P.True' to enable multidevice support in /@window@/.
    -> m ()
windowSetSupportMultidevice window supportMultidevice = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let supportMultidevice' = (P.fromIntegral . P.fromEnum) supportMultidevice
    gdk_window_set_support_multidevice window' supportMultidevice'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetSupportMultideviceMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetSupportMultideviceMethodInfo a signature where
    overloadedMethod = windowSetSupportMultidevice

instance O.OverloadedMethodInfo WindowSetSupportMultideviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetSupportMultidevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetSupportMultidevice"
        })


#endif

-- method Window::set_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "title of @window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_title" gdk_window_set_title :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CString ->                              -- title : TBasicType TUTF8
    IO ()

-- | Sets the title of a toplevel window, to be displayed in the titlebar.
-- If you haven’t explicitly set the icon name for the window
-- (using 'GI.Gdk.Objects.Window.windowSetIconName'), the icon name will be set to
-- /@title@/ as well. /@title@/ must be in UTF-8 encoding (as with all
-- user-readable strings in GDK\/GTK+). /@title@/ may not be 'P.Nothing'.
windowSetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> T.Text
    -- ^ /@title@/: title of /@window@/
    -> m ()
windowSetTitle window title = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    title' <- textToCString title
    gdk_window_set_title window' title'
    touchManagedPtr window
    freeMem title'
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetTitleMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetTitleMethodInfo a signature where
    overloadedMethod = windowSetTitle

instance O.OverloadedMethodInfo WindowSetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetTitle"
        })


#endif

-- method Window::set_transient_for
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_transient_for" gdk_window_set_transient_for :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Window ->                           -- parent : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Indicates to the window manager that /@window@/ is a transient dialog
-- associated with the application window /@parent@/. This allows the
-- window manager to do things like center /@window@/ on /@parent@/ and
-- keep /@window@/ above /@parent@/.
-- 
-- See @/gtk_window_set_transient_for()/@ if you’re using @/GtkWindow/@ or
-- @/GtkDialog/@.
windowSetTransientFor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, IsWindow b) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@parent@/: another toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowSetTransientFor window parent = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    parent' <- unsafeManagedPtrCastPtr parent
    gdk_window_set_transient_for window' parent'
    touchManagedPtr window
    touchManagedPtr parent
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetTransientForMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsWindow a, IsWindow b) => O.OverloadedMethod WindowSetTransientForMethodInfo a signature where
    overloadedMethod = windowSetTransientFor

instance O.OverloadedMethodInfo WindowSetTransientForMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetTransientFor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetTransientFor"
        })


#endif

-- method Window::set_type_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hint"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowTypeHint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A hint of the function this window will have"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_type_hint" gdk_window_set_type_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- hint : TInterface (Name {namespace = "Gdk", name = "WindowTypeHint"})
    IO ()

-- | The application can use this call to provide a hint to the window
-- manager about the functionality of a window. The window manager
-- can use this information when determining the decoration and behaviour
-- of the window.
-- 
-- The hint must be set before the window is mapped.
windowSetTypeHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: A toplevel t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Enums.WindowTypeHint
    -- ^ /@hint@/: A hint of the function this window will have
    -> m ()
windowSetTypeHint window hint = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let hint' = (fromIntegral . fromEnum) hint
    gdk_window_set_type_hint window' hint'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetTypeHintMethodInfo
instance (signature ~ (Gdk.Enums.WindowTypeHint -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetTypeHintMethodInfo a signature where
    overloadedMethod = windowSetTypeHint

instance O.OverloadedMethodInfo WindowSetTypeHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetTypeHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetTypeHint"
        })


#endif

-- method Window::set_urgency_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "urgent"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the window is urgent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_urgency_hint" gdk_window_set_urgency_hint :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- urgent : TBasicType TBoolean
    IO ()

-- | Toggles whether a window needs the user\'s
-- urgent attention.
-- 
-- /Since: 2.8/
windowSetUrgencyHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@urgent@/: 'P.True' if the window is urgent
    -> m ()
windowSetUrgencyHint window urgent = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let urgent' = (P.fromIntegral . P.fromEnum) urgent
    gdk_window_set_urgency_hint window' urgent'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetUrgencyHintMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetUrgencyHintMethodInfo a signature where
    overloadedMethod = windowSetUrgencyHint

instance O.OverloadedMethodInfo WindowSetUrgencyHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetUrgencyHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetUrgencyHint"
        })


#endif

-- method Window::set_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_user_data" gdk_window_set_user_data :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr GObject.Object.Object ->            -- user_data : TInterface (Name {namespace = "GObject", name = "Object"})
    IO ()

-- | For most purposes this function is deprecated in favor of
-- 'GI.GObject.Objects.Object.objectSetData'. However, for historical reasons GTK+ stores
-- the @/GtkWidget/@ that owns a t'GI.Gdk.Objects.Window.Window' as user data on the
-- t'GI.Gdk.Objects.Window.Window'. So, custom widget implementations should use
-- this function for that. If GTK+ receives an event for a t'GI.Gdk.Objects.Window.Window',
-- and the user data for the window is non-'P.Nothing', GTK+ will assume the
-- user data is a @/GtkWidget/@, and forward the event to that widget.
windowSetUserData ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, GObject.Object.IsObject b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Maybe (b)
    -- ^ /@userData@/: user data
    -> m ()
windowSetUserData window userData = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeUserData <- case userData of
        Nothing -> return FP.nullPtr
        Just jUserData -> do
            jUserData' <- unsafeManagedPtrCastPtr jUserData
            return jUserData'
    gdk_window_set_user_data window' maybeUserData
    touchManagedPtr window
    whenJust userData touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetUserDataMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, GObject.Object.IsObject b) => O.OverloadedMethod WindowSetUserDataMethodInfo a signature where
    overloadedMethod = windowSetUserData

instance O.OverloadedMethodInfo WindowSetUserDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowSetUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowSetUserData"
        })


#endif

-- method Window::shape_combine_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shape_region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "region of window to be non-transparent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "X position of @shape_region in @window coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Y position of @shape_region in @window coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_shape_combine_region" gdk_window_shape_combine_region :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Cairo.Region.Region ->              -- shape_region : TInterface (Name {namespace = "cairo", name = "Region"})
    Int32 ->                                -- offset_x : TBasicType TInt
    Int32 ->                                -- offset_y : TBasicType TInt
    IO ()

-- | Makes pixels in /@window@/ outside /@shapeRegion@/ be transparent,
-- so that the window may be nonrectangular.
-- 
-- If /@shapeRegion@/ is 'P.Nothing', the shape will be unset, so the whole
-- window will be opaque again. /@offsetX@/ and /@offsetY@/ are ignored
-- if /@shapeRegion@/ is 'P.Nothing'.
-- 
-- On the X11 platform, this uses an X server extension which is
-- widely available on most common platforms, but not available on
-- very old X servers, and occasionally the implementation will be
-- buggy. On servers without the shape extension, this function
-- will do nothing.
-- 
-- This function works on both toplevel and child windows.
windowShapeCombineRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Maybe (Cairo.Region.Region)
    -- ^ /@shapeRegion@/: region of window to be non-transparent
    -> Int32
    -- ^ /@offsetX@/: X position of /@shapeRegion@/ in /@window@/ coordinates
    -> Int32
    -- ^ /@offsetY@/: Y position of /@shapeRegion@/ in /@window@/ coordinates
    -> m ()
windowShapeCombineRegion window shapeRegion offsetX offsetY = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeShapeRegion <- case shapeRegion of
        Nothing -> return FP.nullPtr
        Just jShapeRegion -> do
            jShapeRegion' <- unsafeManagedPtrGetPtr jShapeRegion
            return jShapeRegion'
    gdk_window_shape_combine_region window' maybeShapeRegion offsetX offsetY
    touchManagedPtr window
    whenJust shapeRegion touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowShapeCombineRegionMethodInfo
instance (signature ~ (Maybe (Cairo.Region.Region) -> Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowShapeCombineRegionMethodInfo a signature where
    overloadedMethod = windowShapeCombineRegion

instance O.OverloadedMethodInfo WindowShapeCombineRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowShapeCombineRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowShapeCombineRegion"
        })


#endif

-- method Window::show
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_show" gdk_window_show :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Like 'GI.Gdk.Objects.Window.windowShowUnraised', but also raises the window to the
-- top of the window stack (moves the window to the front of the
-- Z-order).
-- 
-- This function maps a window so it’s visible onscreen. Its opposite
-- is 'GI.Gdk.Objects.Window.windowHide'.
-- 
-- When implementing a @/GtkWidget/@, you should call this function on the widget\'s
-- t'GI.Gdk.Objects.Window.Window' as part of the “map” method.
windowShow ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowShow window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_show window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowShowMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowShowMethodInfo a signature where
    overloadedMethod = windowShow

instance O.OverloadedMethodInfo WindowShowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowShow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowShow"
        })


#endif

-- method Window::show_unraised
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_show_unraised" gdk_window_show_unraised :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Shows a t'GI.Gdk.Objects.Window.Window' onscreen, but does not modify its stacking
-- order. In contrast, 'GI.Gdk.Objects.Window.windowShow' will raise the window
-- to the top of the window stack.
-- 
-- On the X11 platform, in Xlib terms, this function calls
-- @/XMapWindow()/@ (it also updates some internal GDK state, which means
-- that you can’t really use @/XMapWindow()/@ directly on a GDK window).
windowShowUnraised ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowShowUnraised window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_show_unraised window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowShowUnraisedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowShowUnraisedMethodInfo a signature where
    overloadedMethod = windowShowUnraised

instance O.OverloadedMethodInfo WindowShowUnraisedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowShowUnraised",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowShowUnraised"
        })


#endif

-- method Window::show_window_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent to show the menu for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_show_window_menu" gdk_window_show_window_menu :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | Asks the windowing system to show the window menu. The window menu
-- is the menu shown when right-clicking the titlebar on traditional
-- windows managed by the window manager. This is useful for windows
-- using client-side decorations, activating it with a right-click
-- on the window decorations.
-- 
-- /Since: 3.14/
windowShowWindowMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Event.Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event' to show the menu for
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window menu was shown and 'P.False' otherwise.
windowShowWindowMenu window event = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_window_show_window_menu window' event'
    let result' = (/= 0) result
    touchManagedPtr window
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowShowWindowMenuMethodInfo
instance (signature ~ (Gdk.Event.Event -> m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowShowWindowMenuMethodInfo a signature where
    overloadedMethod = windowShowWindowMenu

instance O.OverloadedMethodInfo WindowShowWindowMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowShowWindowMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowShowWindowMenu"
        })


#endif

-- method Window::stick
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_stick" gdk_window_stick :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | “Pins” a window such that it’s on all workspaces and does not scroll
-- with viewports, for window managers that have scrollable viewports.
-- (When using @/GtkWindow/@, @/gtk_window_stick()/@ may be more useful.)
-- 
-- On the X11 platform, this function depends on window manager
-- support, so may have no effect with many window managers. However,
-- GDK will do the best it can to convince the window manager to stick
-- the window. For window managers that don’t support this operation,
-- there’s nothing you can do to force it to happen.
windowStick ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowStick window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_stick window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowStickMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowStickMethodInfo a signature where
    overloadedMethod = windowStick

instance O.OverloadedMethodInfo WindowStickMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowStick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowStick"
        })


#endif

-- method Window::thaw_toplevel_updates_libgtk_only
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_thaw_toplevel_updates_libgtk_only" gdk_window_thaw_toplevel_updates_libgtk_only :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

{-# DEPRECATED windowThawToplevelUpdatesLibgtkOnly ["(Since version 3.16)","This symbol was never meant to be used outside of GTK+"] #-}
-- | Thaws a window frozen with
-- 'GI.Gdk.Objects.Window.windowFreezeToplevelUpdatesLibgtkOnly'.
-- 
-- This function is not part of the GDK public API and is only
-- for use by GTK+.
windowThawToplevelUpdatesLibgtkOnly ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowThawToplevelUpdatesLibgtkOnly window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_thaw_toplevel_updates_libgtk_only window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowThawToplevelUpdatesLibgtkOnlyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowThawToplevelUpdatesLibgtkOnlyMethodInfo a signature where
    overloadedMethod = windowThawToplevelUpdatesLibgtkOnly

instance O.OverloadedMethodInfo WindowThawToplevelUpdatesLibgtkOnlyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowThawToplevelUpdatesLibgtkOnly",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowThawToplevelUpdatesLibgtkOnly"
        })


#endif

-- method Window::thaw_updates
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_thaw_updates" gdk_window_thaw_updates :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Thaws a window frozen with 'GI.Gdk.Objects.Window.windowFreezeUpdates'.
windowThawUpdates ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowThawUpdates window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_thaw_updates window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowThawUpdatesMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowThawUpdatesMethodInfo a signature where
    overloadedMethod = windowThawUpdates

instance O.OverloadedMethodInfo WindowThawUpdatesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowThawUpdates",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowThawUpdates"
        })


#endif

-- method Window::unfullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_unfullscreen" gdk_window_unfullscreen :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Moves the window out of fullscreen mode. If the window was not
-- fullscreen, does nothing.
-- 
-- On X11, asks the window manager to move /@window@/ out of the fullscreen
-- state, if the window manager supports this operation. Not all
-- window managers support this, and some deliberately ignore it or
-- don’t have a concept of “fullscreen”; so you can’t rely on the
-- unfullscreenification actually happening. But it will happen with
-- most standard window managers, and GDK makes a best effort to get
-- it to happen.
-- 
-- /Since: 2.2/
windowUnfullscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowUnfullscreen window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_unfullscreen window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowUnfullscreenMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowUnfullscreenMethodInfo a signature where
    overloadedMethod = windowUnfullscreen

instance O.OverloadedMethodInfo WindowUnfullscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowUnfullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowUnfullscreen"
        })


#endif

-- method Window::unmaximize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_unmaximize" gdk_window_unmaximize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Unmaximizes the window. If the window wasn’t maximized, then this
-- function does nothing.
-- 
-- On X11, asks the window manager to unmaximize /@window@/, if the
-- window manager supports this operation. Not all window managers
-- support this, and some deliberately ignore it or don’t have a
-- concept of “maximized”; so you can’t rely on the unmaximization
-- actually happening. But it will happen with most standard window
-- managers, and GDK makes a best effort to get it to happen.
-- 
-- On Windows, reliably unmaximizes the window.
windowUnmaximize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowUnmaximize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_unmaximize window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowUnmaximizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowUnmaximizeMethodInfo a signature where
    overloadedMethod = windowUnmaximize

instance O.OverloadedMethodInfo WindowUnmaximizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowUnmaximize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowUnmaximize"
        })


#endif

-- method Window::unstick
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_unstick" gdk_window_unstick :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Reverse operation for 'GI.Gdk.Objects.Window.windowStick'; see 'GI.Gdk.Objects.Window.windowStick',
-- and @/gtk_window_unstick()/@.
windowUnstick ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowUnstick window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_unstick window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowUnstickMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowUnstickMethodInfo a signature where
    overloadedMethod = windowUnstick

instance O.OverloadedMethodInfo WindowUnstickMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowUnstick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowUnstick"
        })


#endif

-- method Window::withdraw
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_withdraw" gdk_window_withdraw :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Withdraws a window (unmaps it and asks the window manager to forget about it).
-- This function is not really useful as 'GI.Gdk.Objects.Window.windowHide' automatically
-- withdraws toplevel windows before hiding them.
windowWithdraw ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a toplevel t'GI.Gdk.Objects.Window.Window'
    -> m ()
windowWithdraw window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_window_withdraw window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowWithdrawMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowWithdrawMethodInfo a signature where
    overloadedMethod = windowWithdraw

instance O.OverloadedMethodInfo WindowWithdrawMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Window.windowWithdraw",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Window.html#v:windowWithdraw"
        })


#endif

-- method Window::at_pointer
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "win_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for origin of the window under the pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "win_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for origin of the window under the pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_at_pointer" gdk_window_at_pointer :: 
    Ptr Int32 ->                            -- win_x : TBasicType TInt
    Ptr Int32 ->                            -- win_y : TBasicType TInt
    IO (Ptr Window)

{-# DEPRECATED windowAtPointer ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceGetWindowAtPosition' instead."] #-}
-- | Obtains the window underneath the mouse pointer, returning the
-- location of that window in /@winX@/, /@winY@/. Returns 'P.Nothing' if the
-- window under the mouse pointer is not known to GDK (if the window
-- belongs to another application and a t'GI.Gdk.Objects.Window.Window' hasn’t been created
-- for it with @/gdk_window_foreign_new()/@)
-- 
-- NOTE: For multihead-aware widgets or applications use
-- 'GI.Gdk.Objects.Display.displayGetWindowAtPointer' instead.
windowAtPointer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ((Window, Int32, Int32))
    -- ^ __Returns:__ window under the mouse pointer
windowAtPointer  = liftIO $ do
    winX <- allocMem :: IO (Ptr Int32)
    winY <- allocMem :: IO (Ptr Int32)
    result <- gdk_window_at_pointer winX winY
    checkUnexpectedReturnNULL "windowAtPointer" result
    result' <- (newObject Window) result
    winX' <- peek winX
    winY' <- peek winY
    freeMem winX
    freeMem winY
    return (result', winX', winY')

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::constrain_size
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "geometry"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Geometry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGeometry structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowHints" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a mask indicating what portions of @geometry are set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "desired width of window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "desired height of the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store resulting width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "new_height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store resulting height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_constrain_size" gdk_window_constrain_size :: 
    Ptr Gdk.Geometry.Geometry ->            -- geometry : TInterface (Name {namespace = "Gdk", name = "Geometry"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gdk", name = "WindowHints"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    Ptr Int32 ->                            -- new_width : TBasicType TInt
    Ptr Int32 ->                            -- new_height : TBasicType TInt
    IO ()

-- | Constrains a desired width and height according to a
-- set of geometry hints (such as minimum and maximum size).
windowConstrainSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Geometry.Geometry
    -- ^ /@geometry@/: a t'GI.Gdk.Structs.Geometry.Geometry' structure
    -> [Gdk.Flags.WindowHints]
    -- ^ /@flags@/: a mask indicating what portions of /@geometry@/ are set
    -> Int32
    -- ^ /@width@/: desired width of window
    -> Int32
    -- ^ /@height@/: desired height of the window
    -> m ((Int32, Int32))
windowConstrainSize geometry flags width height = liftIO $ do
    geometry' <- unsafeManagedPtrGetPtr geometry
    let flags' = gflagsToWord flags
    newWidth <- allocMem :: IO (Ptr Int32)
    newHeight <- allocMem :: IO (Ptr Int32)
    gdk_window_constrain_size geometry' flags' width height newWidth newHeight
    newWidth' <- peek newWidth
    newHeight' <- peek newHeight
    touchManagedPtr geometry
    freeMem newWidth
    freeMem newHeight
    return (newWidth', newHeight')

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::process_all_updates
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_process_all_updates" gdk_window_process_all_updates :: 
    IO ()

{-# DEPRECATED windowProcessAllUpdates ["(Since version 3.22)"] #-}
-- | Calls 'GI.Gdk.Objects.Window.windowProcessUpdates' for all windows (see t'GI.Gdk.Objects.Window.Window')
-- in the application.
windowProcessAllUpdates ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
windowProcessAllUpdates  = liftIO $ do
    gdk_window_process_all_updates
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::set_debug_updates
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to turn on update debugging"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_window_set_debug_updates" gdk_window_set_debug_updates :: 
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED windowSetDebugUpdates ["(Since version 3.22)"] #-}
-- | With update debugging enabled, calls to
-- 'GI.Gdk.Objects.Window.windowInvalidateRegion' clear the invalidated region of the
-- screen to a noticeable color, and GDK pauses for a short time
-- before sending exposes to windows during
-- 'GI.Gdk.Objects.Window.windowProcessUpdates'.  The net effect is that you can see
-- the invalid region for each window and watch redraws as they
-- occur. This allows you to diagnose inefficiencies in your application.
-- 
-- In essence, because the GDK rendering model prevents all flicker,
-- if you are redrawing the same region 400 times you may never
-- notice, aside from noticing a speed problem. Enabling update
-- debugging causes GTK to flicker slowly and noticeably, so you can
-- see exactly what’s being redrawn when, in what order.
-- 
-- The --gtk-debug=updates command line option passed to GTK+ programs
-- enables this debug option at application startup time. That\'s
-- usually more useful than calling 'GI.Gdk.Objects.Window.windowSetDebugUpdates'
-- yourself, though you might want to use this function to enable
-- updates sometime after application startup time.
windowSetDebugUpdates ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@setting@/: 'P.True' to turn on update debugging
    -> m ()
windowSetDebugUpdates setting = liftIO $ do
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gdk_window_set_debug_updates setting'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif


