{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents the platform-specific Vulkan draw context.
-- 
-- @GdkVulkanContext@s are created for a surface using
-- 'GI.Gdk.Objects.Surface.surfaceCreateVulkanContext', and the context will match
-- the characteristics of the surface.
-- 
-- Support for @GdkVulkanContext@ is platform-specific and context creation
-- can fail, returning 'P.Nothing' context.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.VulkanContext
    ( 

-- * Exported types
    VulkanContext(..)                       ,
    IsVulkanContext                         ,
    toVulkanContext                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beginFrame]("GI.Gdk.Objects.DrawContext#g:method:beginFrame"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [endFrame]("GI.Gdk.Objects.DrawContext#g:method:endFrame"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isInFrame]("GI.Gdk.Objects.DrawContext#g:method:isInFrame"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.DrawContext#g:method:getDisplay"), [getFrameRegion]("GI.Gdk.Objects.DrawContext#g:method:getFrameRegion"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gdk.Objects.DrawContext#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveVulkanContextMethod              ,
#endif



 -- * Signals


-- ** imagesUpdated #signal:imagesUpdated#

    VulkanContextImagesUpdatedCallback      ,
#if defined(ENABLE_OVERLOADING)
    VulkanContextImagesUpdatedSignalInfo    ,
#endif
    afterVulkanContextImagesUpdated         ,
    onVulkanContextImagesUpdated            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext

#endif

-- | Memory-managed wrapper type.
newtype VulkanContext = VulkanContext (SP.ManagedPtr VulkanContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype VulkanContext where
    toManagedPtr (VulkanContext p) = p

foreign import ccall "gdk_vulkan_context_get_type"
    c_gdk_vulkan_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject VulkanContext where
    glibType = c_gdk_vulkan_context_get_type

instance B.Types.GObject VulkanContext

-- | Type class for types which can be safely cast to t'VulkanContext', for instance with `toVulkanContext`.
class (SP.GObject o, O.IsDescendantOf VulkanContext o) => IsVulkanContext o
instance (SP.GObject o, O.IsDescendantOf VulkanContext o) => IsVulkanContext o

instance O.HasParentTypes VulkanContext
type instance O.ParentTypes VulkanContext = '[Gdk.DrawContext.DrawContext, GObject.Object.Object]

-- | Cast to t'VulkanContext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toVulkanContext :: (MIO.MonadIO m, IsVulkanContext o) => o -> m VulkanContext
toVulkanContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo VulkanContext

-- | Convert t'VulkanContext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe VulkanContext) where
    gvalueGType_ = c_gdk_vulkan_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr VulkanContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr VulkanContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject VulkanContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveVulkanContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVulkanContextMethod "beginFrame" o = Gdk.DrawContext.DrawContextBeginFrameMethodInfo
    ResolveVulkanContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveVulkanContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveVulkanContextMethod "endFrame" o = Gdk.DrawContext.DrawContextEndFrameMethodInfo
    ResolveVulkanContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveVulkanContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveVulkanContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveVulkanContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveVulkanContextMethod "isInFrame" o = Gdk.DrawContext.DrawContextIsInFrameMethodInfo
    ResolveVulkanContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveVulkanContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveVulkanContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveVulkanContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveVulkanContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveVulkanContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveVulkanContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveVulkanContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveVulkanContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveVulkanContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveVulkanContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveVulkanContextMethod "getDisplay" o = Gdk.DrawContext.DrawContextGetDisplayMethodInfo
    ResolveVulkanContextMethod "getFrameRegion" o = Gdk.DrawContext.DrawContextGetFrameRegionMethodInfo
    ResolveVulkanContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveVulkanContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveVulkanContextMethod "getSurface" o = Gdk.DrawContext.DrawContextGetSurfaceMethodInfo
    ResolveVulkanContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveVulkanContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveVulkanContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveVulkanContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVulkanContextMethod t VulkanContext, O.OverloadedMethod info VulkanContext p) => OL.IsLabel t (VulkanContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVulkanContextMethod t VulkanContext, O.OverloadedMethod info VulkanContext p, R.HasField t VulkanContext p) => R.HasField t VulkanContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVulkanContextMethod t VulkanContext, O.OverloadedMethodInfo info VulkanContext) => OL.IsLabel t (O.MethodProxy info VulkanContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal VulkanContext::images-updated
-- | Emitted when the images managed by this context have changed.
-- 
-- Usually this means that the swapchain had to be recreated,
-- for example in response to a change of the surface size.
type VulkanContextImagesUpdatedCallback =
    IO ()

type C_VulkanContextImagesUpdatedCallback =
    Ptr VulkanContext ->                    -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VulkanContextImagesUpdatedCallback`.
foreign import ccall "wrapper"
    mk_VulkanContextImagesUpdatedCallback :: C_VulkanContextImagesUpdatedCallback -> IO (FunPtr C_VulkanContextImagesUpdatedCallback)

wrap_VulkanContextImagesUpdatedCallback :: 
    GObject a => (a -> VulkanContextImagesUpdatedCallback) ->
    C_VulkanContextImagesUpdatedCallback
wrap_VulkanContextImagesUpdatedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [imagesUpdated](#signal:imagesUpdated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' vulkanContext #imagesUpdated callback
-- @
-- 
-- 
onVulkanContextImagesUpdated :: (IsVulkanContext a, MonadIO m) => a -> ((?self :: a) => VulkanContextImagesUpdatedCallback) -> m SignalHandlerId
onVulkanContextImagesUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VulkanContextImagesUpdatedCallback wrapped
    wrapped'' <- mk_VulkanContextImagesUpdatedCallback wrapped'
    connectSignalFunPtr obj "images-updated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [imagesUpdated](#signal:imagesUpdated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' vulkanContext #imagesUpdated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVulkanContextImagesUpdated :: (IsVulkanContext a, MonadIO m) => a -> ((?self :: a) => VulkanContextImagesUpdatedCallback) -> m SignalHandlerId
afterVulkanContextImagesUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VulkanContextImagesUpdatedCallback wrapped
    wrapped'' <- mk_VulkanContextImagesUpdatedCallback wrapped'
    connectSignalFunPtr obj "images-updated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VulkanContextImagesUpdatedSignalInfo
instance SignalInfo VulkanContextImagesUpdatedSignalInfo where
    type HaskellCallbackType VulkanContextImagesUpdatedSignalInfo = VulkanContextImagesUpdatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VulkanContextImagesUpdatedCallback cb
        cb'' <- mk_VulkanContextImagesUpdatedCallback cb'
        connectSignalFunPtr obj "images-updated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.VulkanContext::images-updated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-VulkanContext.html#g:signal:imagesUpdated"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList VulkanContext
type instance O.AttributeList VulkanContext = VulkanContextAttributeList
type VulkanContextAttributeList = ('[ '("display", Gdk.DrawContext.DrawContextDisplayPropertyInfo), '("surface", Gdk.DrawContext.DrawContextSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList VulkanContext = VulkanContextSignalList
type VulkanContextSignalList = ('[ '("imagesUpdated", VulkanContextImagesUpdatedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


