{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The base object class for the Accessibility Toolkit API.
-- 
-- This class is the primary class for accessibility support via the
-- Accessibility ToolKit (ATK).  Objects which are instances of
-- t'GI.Atk.Objects.Object.Object' (or instances of AtkObject-derived types) are queried
-- for properties which relate basic (and generic) properties of a UI
-- component such as name and description.  Instances of t'GI.Atk.Objects.Object.Object'
-- may also be queried as to whether they implement other ATK
-- interfaces (e.g. t'GI.Atk.Interfaces.Action.Action', t'GI.Atk.Interfaces.Component.Component', etc.), as appropriate
-- to the role which a given UI component plays in a user interface.
-- 
-- All UI components in an application which provide useful
-- information or services to the user must provide corresponding
-- t'GI.Atk.Objects.Object.Object' instances on request (in GTK+, for instance, usually on
-- a call to @/gtk_widget_get_accessible/@ ()), either via ATK support
-- built into the toolkit for the widget class or ancestor class, or
-- in the case of custom widgets, if the inherited t'GI.Atk.Objects.Object.Object'
-- implementation is insufficient, via instances of a new t'GI.Atk.Objects.Object.Object'
-- subclass.
-- 
-- See [class/@atkObjectFactory@/], [class/@atkRegistry@/].  (GTK+ users see also
-- @/GtkAccessible/@).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.Object
    ( 

-- * Exported types
    Object(..)                              ,
    IsObject                                ,
    toObject                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addRelationship]("GI.Atk.Objects.Object#g:method:addRelationship"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [initialize]("GI.Atk.Objects.Object#g:method:initialize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStateChange]("GI.Atk.Objects.Object#g:method:notifyStateChange"), [peekParent]("GI.Atk.Objects.Object#g:method:peekParent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refAccessibleChild]("GI.Atk.Objects.Object#g:method:refAccessibleChild"), [refRelationSet]("GI.Atk.Objects.Object#g:method:refRelationSet"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refStateSet]("GI.Atk.Objects.Object#g:method:refStateSet"), [removePropertyChangeHandler]("GI.Atk.Objects.Object#g:method:removePropertyChangeHandler"), [removeRelationship]("GI.Atk.Objects.Object#g:method:removeRelationship"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleId]("GI.Atk.Objects.Object#g:method:getAccessibleId"), [getAttributes]("GI.Atk.Objects.Object#g:method:getAttributes"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Atk.Objects.Object#g:method:getDescription"), [getHelpText]("GI.Atk.Objects.Object#g:method:getHelpText"), [getIndexInParent]("GI.Atk.Objects.Object#g:method:getIndexInParent"), [getLayer]("GI.Atk.Objects.Object#g:method:getLayer"), [getMdiZorder]("GI.Atk.Objects.Object#g:method:getMdiZorder"), [getNAccessibleChildren]("GI.Atk.Objects.Object#g:method:getNAccessibleChildren"), [getName]("GI.Atk.Objects.Object#g:method:getName"), [getObjectLocale]("GI.Atk.Objects.Object#g:method:getObjectLocale"), [getParent]("GI.Atk.Objects.Object#g:method:getParent"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRole]("GI.Atk.Objects.Object#g:method:getRole").
-- 
-- ==== Setters
-- [setAccessibleId]("GI.Atk.Objects.Object#g:method:setAccessibleId"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Atk.Objects.Object#g:method:setDescription"), [setHelpText]("GI.Atk.Objects.Object#g:method:setHelpText"), [setName]("GI.Atk.Objects.Object#g:method:setName"), [setParent]("GI.Atk.Objects.Object#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Atk.Objects.Object#g:method:setRole").

#if defined(ENABLE_OVERLOADING)
    ResolveObjectMethod                     ,
#endif

-- ** addRelationship #method:addRelationship#

#if defined(ENABLE_OVERLOADING)
    ObjectAddRelationshipMethodInfo         ,
#endif
    objectAddRelationship                   ,


-- ** getAccessibleId #method:getAccessibleId#

#if defined(ENABLE_OVERLOADING)
    ObjectGetAccessibleIdMethodInfo         ,
#endif
    objectGetAccessibleId                   ,


-- ** getAttributes #method:getAttributes#

#if defined(ENABLE_OVERLOADING)
    ObjectGetAttributesMethodInfo           ,
#endif
    objectGetAttributes                     ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    ObjectGetDescriptionMethodInfo          ,
#endif
    objectGetDescription                    ,


-- ** getHelpText #method:getHelpText#

#if defined(ENABLE_OVERLOADING)
    ObjectGetHelpTextMethodInfo             ,
#endif
    objectGetHelpText                       ,


-- ** getIndexInParent #method:getIndexInParent#

#if defined(ENABLE_OVERLOADING)
    ObjectGetIndexInParentMethodInfo        ,
#endif
    objectGetIndexInParent                  ,


-- ** getLayer #method:getLayer#

#if defined(ENABLE_OVERLOADING)
    ObjectGetLayerMethodInfo                ,
#endif
    objectGetLayer                          ,


-- ** getMdiZorder #method:getMdiZorder#

#if defined(ENABLE_OVERLOADING)
    ObjectGetMdiZorderMethodInfo            ,
#endif
    objectGetMdiZorder                      ,


-- ** getNAccessibleChildren #method:getNAccessibleChildren#

#if defined(ENABLE_OVERLOADING)
    ObjectGetNAccessibleChildrenMethodInfo  ,
#endif
    objectGetNAccessibleChildren            ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    ObjectGetNameMethodInfo                 ,
#endif
    objectGetName                           ,


-- ** getObjectLocale #method:getObjectLocale#

#if defined(ENABLE_OVERLOADING)
    ObjectGetObjectLocaleMethodInfo         ,
#endif
    objectGetObjectLocale                   ,


-- ** getParent #method:getParent#

#if defined(ENABLE_OVERLOADING)
    ObjectGetParentMethodInfo               ,
#endif
    objectGetParent                         ,


-- ** getRole #method:getRole#

#if defined(ENABLE_OVERLOADING)
    ObjectGetRoleMethodInfo                 ,
#endif
    objectGetRole                           ,


-- ** initialize #method:initialize#

#if defined(ENABLE_OVERLOADING)
    ObjectInitializeMethodInfo              ,
#endif
    objectInitialize                        ,


-- ** notifyStateChange #method:notifyStateChange#

#if defined(ENABLE_OVERLOADING)
    ObjectNotifyStateChangeMethodInfo       ,
#endif
    objectNotifyStateChange                 ,


-- ** peekParent #method:peekParent#

#if defined(ENABLE_OVERLOADING)
    ObjectPeekParentMethodInfo              ,
#endif
    objectPeekParent                        ,


-- ** refAccessibleChild #method:refAccessibleChild#

#if defined(ENABLE_OVERLOADING)
    ObjectRefAccessibleChildMethodInfo      ,
#endif
    objectRefAccessibleChild                ,


-- ** refRelationSet #method:refRelationSet#

#if defined(ENABLE_OVERLOADING)
    ObjectRefRelationSetMethodInfo          ,
#endif
    objectRefRelationSet                    ,


-- ** refStateSet #method:refStateSet#

#if defined(ENABLE_OVERLOADING)
    ObjectRefStateSetMethodInfo             ,
#endif
    objectRefStateSet                       ,


-- ** removePropertyChangeHandler #method:removePropertyChangeHandler#

#if defined(ENABLE_OVERLOADING)
    ObjectRemovePropertyChangeHandlerMethodInfo,
#endif
    objectRemovePropertyChangeHandler       ,


-- ** removeRelationship #method:removeRelationship#

#if defined(ENABLE_OVERLOADING)
    ObjectRemoveRelationshipMethodInfo      ,
#endif
    objectRemoveRelationship                ,


-- ** setAccessibleId #method:setAccessibleId#

#if defined(ENABLE_OVERLOADING)
    ObjectSetAccessibleIdMethodInfo         ,
#endif
    objectSetAccessibleId                   ,


-- ** setDescription #method:setDescription#

#if defined(ENABLE_OVERLOADING)
    ObjectSetDescriptionMethodInfo          ,
#endif
    objectSetDescription                    ,


-- ** setHelpText #method:setHelpText#

#if defined(ENABLE_OVERLOADING)
    ObjectSetHelpTextMethodInfo             ,
#endif
    objectSetHelpText                       ,


-- ** setName #method:setName#

#if defined(ENABLE_OVERLOADING)
    ObjectSetNameMethodInfo                 ,
#endif
    objectSetName                           ,


-- ** setParent #method:setParent#

#if defined(ENABLE_OVERLOADING)
    ObjectSetParentMethodInfo               ,
#endif
    objectSetParent                         ,


-- ** setRole #method:setRole#

#if defined(ENABLE_OVERLOADING)
    ObjectSetRoleMethodInfo                 ,
#endif
    objectSetRole                           ,




 -- * Properties


-- ** accessibleComponentLayer #attr:accessibleComponentLayer#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleComponentLayerPropertyInfo,
#endif
    getObjectAccessibleComponentLayer       ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleComponentLayer          ,
#endif


-- ** accessibleComponentMdiZorder #attr:accessibleComponentMdiZorder#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleComponentMdiZorderPropertyInfo,
#endif
    getObjectAccessibleComponentMdiZorder   ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleComponentMdiZorder      ,
#endif


-- ** accessibleDescription #attr:accessibleDescription#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleDescriptionPropertyInfo ,
#endif
    clearObjectAccessibleDescription        ,
    constructObjectAccessibleDescription    ,
    getObjectAccessibleDescription          ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleDescription             ,
#endif
    setObjectAccessibleDescription          ,


-- ** accessibleHelpText #attr:accessibleHelpText#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleHelpTextPropertyInfo    ,
#endif
    clearObjectAccessibleHelpText           ,
    constructObjectAccessibleHelpText       ,
    getObjectAccessibleHelpText             ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleHelpText                ,
#endif
    setObjectAccessibleHelpText             ,


-- ** accessibleHypertextNlinks #attr:accessibleHypertextNlinks#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleHypertextNlinksPropertyInfo,
#endif
    getObjectAccessibleHypertextNlinks      ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleHypertextNlinks         ,
#endif


-- ** accessibleId #attr:accessibleId#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleIdPropertyInfo          ,
#endif
    constructObjectAccessibleId             ,
    getObjectAccessibleId                   ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleId                      ,
#endif
    setObjectAccessibleId                   ,


-- ** accessibleName #attr:accessibleName#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleNamePropertyInfo        ,
#endif
    clearObjectAccessibleName               ,
    constructObjectAccessibleName           ,
    getObjectAccessibleName                 ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleName                    ,
#endif
    setObjectAccessibleName                 ,


-- ** accessibleParent #attr:accessibleParent#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleParentPropertyInfo      ,
#endif
    clearObjectAccessibleParent             ,
    constructObjectAccessibleParent         ,
    getObjectAccessibleParent               ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleParent                  ,
#endif
    setObjectAccessibleParent               ,


-- ** accessibleRole #attr:accessibleRole#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleRolePropertyInfo        ,
#endif
    constructObjectAccessibleRole           ,
    getObjectAccessibleRole                 ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleRole                    ,
#endif
    setObjectAccessibleRole                 ,


-- ** accessibleTableCaption #attr:accessibleTableCaption#
-- | Table caption.

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableCaptionPropertyInfo,
#endif
    clearObjectAccessibleTableCaption       ,
    constructObjectAccessibleTableCaption   ,
    getObjectAccessibleTableCaption         ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableCaption            ,
#endif
    setObjectAccessibleTableCaption         ,


-- ** accessibleTableCaptionObject #attr:accessibleTableCaptionObject#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableCaptionObjectPropertyInfo,
#endif
    clearObjectAccessibleTableCaptionObject ,
    constructObjectAccessibleTableCaptionObject,
    getObjectAccessibleTableCaptionObject   ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableCaptionObject      ,
#endif
    setObjectAccessibleTableCaptionObject   ,


-- ** accessibleTableColumnDescription #attr:accessibleTableColumnDescription#
-- | Accessible table column description.

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableColumnDescriptionPropertyInfo,
#endif
    clearObjectAccessibleTableColumnDescription,
    constructObjectAccessibleTableColumnDescription,
    getObjectAccessibleTableColumnDescription,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableColumnDescription  ,
#endif
    setObjectAccessibleTableColumnDescription,


-- ** accessibleTableColumnHeader #attr:accessibleTableColumnHeader#
-- | Accessible table column header.

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableColumnHeaderPropertyInfo,
#endif
    clearObjectAccessibleTableColumnHeader  ,
    constructObjectAccessibleTableColumnHeader,
    getObjectAccessibleTableColumnHeader    ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableColumnHeader       ,
#endif
    setObjectAccessibleTableColumnHeader    ,


-- ** accessibleTableRowDescription #attr:accessibleTableRowDescription#
-- | Accessible table row description.

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableRowDescriptionPropertyInfo,
#endif
    clearObjectAccessibleTableRowDescription,
    constructObjectAccessibleTableRowDescription,
    getObjectAccessibleTableRowDescription  ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableRowDescription     ,
#endif
    setObjectAccessibleTableRowDescription  ,


-- ** accessibleTableRowHeader #attr:accessibleTableRowHeader#
-- | Accessible table row header.

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableRowHeaderPropertyInfo,
#endif
    clearObjectAccessibleTableRowHeader     ,
    constructObjectAccessibleTableRowHeader ,
    getObjectAccessibleTableRowHeader       ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableRowHeader          ,
#endif
    setObjectAccessibleTableRowHeader       ,


-- ** accessibleTableSummary #attr:accessibleTableSummary#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleTableSummaryPropertyInfo,
#endif
    clearObjectAccessibleTableSummary       ,
    constructObjectAccessibleTableSummary   ,
    getObjectAccessibleTableSummary         ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleTableSummary            ,
#endif
    setObjectAccessibleTableSummary         ,


-- ** accessibleValue #attr:accessibleValue#
-- | Numeric value of this object, in case being and AtkValue.

#if defined(ENABLE_OVERLOADING)
    ObjectAccessibleValuePropertyInfo       ,
#endif
    constructObjectAccessibleValue          ,
    getObjectAccessibleValue                ,
#if defined(ENABLE_OVERLOADING)
    objectAccessibleValue                   ,
#endif
    setObjectAccessibleValue                ,




 -- * Signals


-- ** activeDescendantChanged #signal:activeDescendantChanged#

    ObjectActiveDescendantChangedCallback   ,
#if defined(ENABLE_OVERLOADING)
    ObjectActiveDescendantChangedSignalInfo ,
#endif
    afterObjectActiveDescendantChanged      ,
    onObjectActiveDescendantChanged         ,


-- ** announcement #signal:announcement#

    ObjectAnnouncementCallback              ,
#if defined(ENABLE_OVERLOADING)
    ObjectAnnouncementSignalInfo            ,
#endif
    afterObjectAnnouncement                 ,
    onObjectAnnouncement                    ,


-- ** attributeChanged #signal:attributeChanged#

    ObjectAttributeChangedCallback          ,
#if defined(ENABLE_OVERLOADING)
    ObjectAttributeChangedSignalInfo        ,
#endif
    afterObjectAttributeChanged             ,
    onObjectAttributeChanged                ,


-- ** childrenChanged #signal:childrenChanged#

    ObjectChildrenChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    ObjectChildrenChangedSignalInfo         ,
#endif
    afterObjectChildrenChanged              ,
    onObjectChildrenChanged                 ,


-- ** focusEvent #signal:focusEvent#

    ObjectFocusEventCallback                ,
#if defined(ENABLE_OVERLOADING)
    ObjectFocusEventSignalInfo              ,
#endif
    afterObjectFocusEvent                   ,
    onObjectFocusEvent                      ,


-- ** notification #signal:notification#

    ObjectNotificationCallback              ,
#if defined(ENABLE_OVERLOADING)
    ObjectNotificationSignalInfo            ,
#endif
    afterObjectNotification                 ,
    onObjectNotification                    ,


-- ** propertyChange #signal:propertyChange#

    ObjectPropertyChangeCallback            ,
#if defined(ENABLE_OVERLOADING)
    ObjectPropertyChangeSignalInfo          ,
#endif
    afterObjectPropertyChange               ,
    onObjectPropertyChange                  ,


-- ** stateChange #signal:stateChange#

    ObjectStateChangeCallback               ,
#if defined(ENABLE_OVERLOADING)
    ObjectStateChangeSignalInfo             ,
#endif
    afterObjectStateChange                  ,
    onObjectStateChange                     ,


-- ** visibleDataChanged #signal:visibleDataChanged#

    ObjectVisibleDataChangedCallback        ,
#if defined(ENABLE_OVERLOADING)
    ObjectVisibleDataChangedSignalInfo      ,
#endif
    afterObjectVisibleDataChanged           ,
    onObjectVisibleDataChanged              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Object = Object (SP.ManagedPtr Object)
    deriving (Eq)

instance SP.ManagedPtrNewtype Object where
    toManagedPtr (Object p) = p

foreign import ccall "atk_object_get_type"
    c_atk_object_get_type :: IO B.Types.GType

instance B.Types.TypedObject Object where
    glibType = c_atk_object_get_type

instance B.Types.GObject Object

-- | Type class for types which can be safely cast to t'Object', for instance with `toObject`.
class (SP.GObject o, O.IsDescendantOf Object o) => IsObject o
instance (SP.GObject o, O.IsDescendantOf Object o) => IsObject o

instance O.HasParentTypes Object
type instance O.ParentTypes Object = '[GObject.Object.Object]

-- | Cast to t'Object', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toObject :: (MIO.MonadIO m, IsObject o) => o -> m Object
toObject = MIO.liftIO . B.ManagedPtr.unsafeCastTo Object

-- | Convert t'Object' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Object) where
    gvalueGType_ = c_atk_object_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Object)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Object)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Object ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveObjectMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveObjectMethod "addRelationship" o = ObjectAddRelationshipMethodInfo
    ResolveObjectMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveObjectMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveObjectMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveObjectMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveObjectMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveObjectMethod "initialize" o = ObjectInitializeMethodInfo
    ResolveObjectMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveObjectMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveObjectMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveObjectMethod "notifyStateChange" o = ObjectNotifyStateChangeMethodInfo
    ResolveObjectMethod "peekParent" o = ObjectPeekParentMethodInfo
    ResolveObjectMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveObjectMethod "refAccessibleChild" o = ObjectRefAccessibleChildMethodInfo
    ResolveObjectMethod "refRelationSet" o = ObjectRefRelationSetMethodInfo
    ResolveObjectMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveObjectMethod "refStateSet" o = ObjectRefStateSetMethodInfo
    ResolveObjectMethod "removePropertyChangeHandler" o = ObjectRemovePropertyChangeHandlerMethodInfo
    ResolveObjectMethod "removeRelationship" o = ObjectRemoveRelationshipMethodInfo
    ResolveObjectMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveObjectMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveObjectMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveObjectMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveObjectMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveObjectMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveObjectMethod "getAccessibleId" o = ObjectGetAccessibleIdMethodInfo
    ResolveObjectMethod "getAttributes" o = ObjectGetAttributesMethodInfo
    ResolveObjectMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveObjectMethod "getDescription" o = ObjectGetDescriptionMethodInfo
    ResolveObjectMethod "getHelpText" o = ObjectGetHelpTextMethodInfo
    ResolveObjectMethod "getIndexInParent" o = ObjectGetIndexInParentMethodInfo
    ResolveObjectMethod "getLayer" o = ObjectGetLayerMethodInfo
    ResolveObjectMethod "getMdiZorder" o = ObjectGetMdiZorderMethodInfo
    ResolveObjectMethod "getNAccessibleChildren" o = ObjectGetNAccessibleChildrenMethodInfo
    ResolveObjectMethod "getName" o = ObjectGetNameMethodInfo
    ResolveObjectMethod "getObjectLocale" o = ObjectGetObjectLocaleMethodInfo
    ResolveObjectMethod "getParent" o = ObjectGetParentMethodInfo
    ResolveObjectMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveObjectMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveObjectMethod "getRole" o = ObjectGetRoleMethodInfo
    ResolveObjectMethod "setAccessibleId" o = ObjectSetAccessibleIdMethodInfo
    ResolveObjectMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveObjectMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveObjectMethod "setDescription" o = ObjectSetDescriptionMethodInfo
    ResolveObjectMethod "setHelpText" o = ObjectSetHelpTextMethodInfo
    ResolveObjectMethod "setName" o = ObjectSetNameMethodInfo
    ResolveObjectMethod "setParent" o = ObjectSetParentMethodInfo
    ResolveObjectMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveObjectMethod "setRole" o = ObjectSetRoleMethodInfo
    ResolveObjectMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveObjectMethod t Object, O.OverloadedMethod info Object p) => OL.IsLabel t (Object -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveObjectMethod t Object, O.OverloadedMethod info Object p, R.HasField t Object p) => R.HasField t Object p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveObjectMethod t Object, O.OverloadedMethodInfo info Object) => OL.IsLabel t (O.MethodProxy info Object) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Object::active-descendant-changed
-- | The \"active-descendant-changed\" signal is emitted by an object
-- which has the state ATK_STATE_MANAGES_DESCENDANTS when the focus
-- object in the object changes. For instance, a table will emit the
-- signal when the cell in the table which has focus changes.
type ObjectActiveDescendantChangedCallback =
    Maybe Object
    -- ^ /@arg1@/: the newly focused object.
    -> IO ()

type C_ObjectActiveDescendantChangedCallback =
    Ptr Object ->                           -- object
    Ptr Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectActiveDescendantChangedCallback`.
foreign import ccall "wrapper"
    mk_ObjectActiveDescendantChangedCallback :: C_ObjectActiveDescendantChangedCallback -> IO (FunPtr C_ObjectActiveDescendantChangedCallback)

wrap_ObjectActiveDescendantChangedCallback :: 
    GObject a => (a -> ObjectActiveDescendantChangedCallback) ->
    C_ObjectActiveDescendantChangedCallback
wrap_ObjectActiveDescendantChangedCallback gi'cb gi'selfPtr arg1 _ = do
    maybeArg1 <-
        if arg1 == FP.nullPtr
        then return Nothing
        else do
            arg1' <- (newObject Object) arg1
            return $ Just arg1'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  maybeArg1


-- | Connect a signal handler for the [activeDescendantChanged](#signal:activeDescendantChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #activeDescendantChanged callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@active-descendant-changed::detail@” instead.
-- 
onObjectActiveDescendantChanged :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectActiveDescendantChangedCallback) -> m SignalHandlerId
onObjectActiveDescendantChanged obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectActiveDescendantChangedCallback wrapped
    wrapped'' <- mk_ObjectActiveDescendantChangedCallback wrapped'
    connectSignalFunPtr obj "active-descendant-changed" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [activeDescendantChanged](#signal:activeDescendantChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #activeDescendantChanged callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@active-descendant-changed::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectActiveDescendantChanged :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectActiveDescendantChangedCallback) -> m SignalHandlerId
afterObjectActiveDescendantChanged obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectActiveDescendantChangedCallback wrapped
    wrapped'' <- mk_ObjectActiveDescendantChangedCallback wrapped'
    connectSignalFunPtr obj "active-descendant-changed" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data ObjectActiveDescendantChangedSignalInfo
instance SignalInfo ObjectActiveDescendantChangedSignalInfo where
    type HaskellCallbackType ObjectActiveDescendantChangedSignalInfo = ObjectActiveDescendantChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectActiveDescendantChangedCallback cb
        cb'' <- mk_ObjectActiveDescendantChangedCallback cb'
        connectSignalFunPtr obj "active-descendant-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::active-descendant-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:activeDescendantChanged"})

#endif

-- signal Object::announcement
-- | The \"announcement\" signal can be emitted to pass an announcement on to
-- be read by a screen reader.
-- 
-- Depcrecated (2.50): Use AtkObject[notification](#g:signal:notification) instead.
-- 
-- /Since: 2.46/
type ObjectAnnouncementCallback =
    T.Text
    -- ^ /@arg1@/: the text to be announced.
    -> IO ()

type C_ObjectAnnouncementCallback =
    Ptr Object ->                           -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectAnnouncementCallback`.
foreign import ccall "wrapper"
    mk_ObjectAnnouncementCallback :: C_ObjectAnnouncementCallback -> IO (FunPtr C_ObjectAnnouncementCallback)

wrap_ObjectAnnouncementCallback :: 
    GObject a => (a -> ObjectAnnouncementCallback) ->
    C_ObjectAnnouncementCallback
wrap_ObjectAnnouncementCallback gi'cb gi'selfPtr arg1 _ = do
    arg1' <- cstringToText arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1'


-- | Connect a signal handler for the [announcement](#signal:announcement) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #announcement callback
-- @
-- 
-- 
onObjectAnnouncement :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectAnnouncementCallback) -> m SignalHandlerId
onObjectAnnouncement obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectAnnouncementCallback wrapped
    wrapped'' <- mk_ObjectAnnouncementCallback wrapped'
    connectSignalFunPtr obj "announcement" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [announcement](#signal:announcement) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #announcement callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectAnnouncement :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectAnnouncementCallback) -> m SignalHandlerId
afterObjectAnnouncement obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectAnnouncementCallback wrapped
    wrapped'' <- mk_ObjectAnnouncementCallback wrapped'
    connectSignalFunPtr obj "announcement" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ObjectAnnouncementSignalInfo
instance SignalInfo ObjectAnnouncementSignalInfo where
    type HaskellCallbackType ObjectAnnouncementSignalInfo = ObjectAnnouncementCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectAnnouncementCallback cb
        cb'' <- mk_ObjectAnnouncementCallback cb'
        connectSignalFunPtr obj "announcement" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::announcement"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:announcement"})

#endif

-- signal Object::attribute-changed
-- | The \"attribute-changed\" signal should be emitted when one of an object\'s
-- attributes changes.
-- 
-- /Since: 2.52/
type ObjectAttributeChangedCallback =
    T.Text
    -- ^ /@arg1@/: the name of the attribute being modified, or 'P.Nothing' if not
    --          available.
    -> T.Text
    -- ^ /@arg2@/: the attribute\'s new value, or @/null/@ if not available.
    -> IO ()

type C_ObjectAttributeChangedCallback =
    Ptr Object ->                           -- object
    CString ->
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectAttributeChangedCallback`.
foreign import ccall "wrapper"
    mk_ObjectAttributeChangedCallback :: C_ObjectAttributeChangedCallback -> IO (FunPtr C_ObjectAttributeChangedCallback)

wrap_ObjectAttributeChangedCallback :: 
    GObject a => (a -> ObjectAttributeChangedCallback) ->
    C_ObjectAttributeChangedCallback
wrap_ObjectAttributeChangedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- cstringToText arg1
    arg2' <- cstringToText arg2
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2'


-- | Connect a signal handler for the [attributeChanged](#signal:attributeChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #attributeChanged callback
-- @
-- 
-- 
onObjectAttributeChanged :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectAttributeChangedCallback) -> m SignalHandlerId
onObjectAttributeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectAttributeChangedCallback wrapped
    wrapped'' <- mk_ObjectAttributeChangedCallback wrapped'
    connectSignalFunPtr obj "attribute-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [attributeChanged](#signal:attributeChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #attributeChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectAttributeChanged :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectAttributeChangedCallback) -> m SignalHandlerId
afterObjectAttributeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectAttributeChangedCallback wrapped
    wrapped'' <- mk_ObjectAttributeChangedCallback wrapped'
    connectSignalFunPtr obj "attribute-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ObjectAttributeChangedSignalInfo
instance SignalInfo ObjectAttributeChangedSignalInfo where
    type HaskellCallbackType ObjectAttributeChangedSignalInfo = ObjectAttributeChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectAttributeChangedCallback cb
        cb'' <- mk_ObjectAttributeChangedCallback cb'
        connectSignalFunPtr obj "attribute-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::attribute-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:attributeChanged"})

#endif

-- signal Object::children-changed
-- | The signal \"children-changed\" is emitted when a child is added or
-- removed from an object. It supports two details: \"add\" and
-- \"remove\"
type ObjectChildrenChangedCallback =
    Word32
    -- ^ /@arg1@/: The index of the added or removed child. The value can be
    -- -1. This is used if the value is not known by the implementor
    -- when the child is added\/removed or irrelevant.
    -> Maybe Object
    -- ^ /@arg2@/: A gpointer to the child AtkObject which was added or
    -- removed. If the child was removed, it is possible that it is not
    -- available for the implementor. In that case this pointer can be
    -- NULL.
    -> IO ()

type C_ObjectChildrenChangedCallback =
    Ptr Object ->                           -- object
    Word32 ->
    Ptr Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectChildrenChangedCallback`.
foreign import ccall "wrapper"
    mk_ObjectChildrenChangedCallback :: C_ObjectChildrenChangedCallback -> IO (FunPtr C_ObjectChildrenChangedCallback)

wrap_ObjectChildrenChangedCallback :: 
    GObject a => (a -> ObjectChildrenChangedCallback) ->
    C_ObjectChildrenChangedCallback
wrap_ObjectChildrenChangedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    maybeArg2 <-
        if arg2 == FP.nullPtr
        then return Nothing
        else do
            arg2' <- (newObject Object) arg2
            return $ Just arg2'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1 maybeArg2


-- | Connect a signal handler for the [childrenChanged](#signal:childrenChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #childrenChanged callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@children-changed::detail@” instead.
-- 
onObjectChildrenChanged :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectChildrenChangedCallback) -> m SignalHandlerId
onObjectChildrenChanged obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectChildrenChangedCallback wrapped
    wrapped'' <- mk_ObjectChildrenChangedCallback wrapped'
    connectSignalFunPtr obj "children-changed" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [childrenChanged](#signal:childrenChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #childrenChanged callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@children-changed::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectChildrenChanged :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectChildrenChangedCallback) -> m SignalHandlerId
afterObjectChildrenChanged obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectChildrenChangedCallback wrapped
    wrapped'' <- mk_ObjectChildrenChangedCallback wrapped'
    connectSignalFunPtr obj "children-changed" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data ObjectChildrenChangedSignalInfo
instance SignalInfo ObjectChildrenChangedSignalInfo where
    type HaskellCallbackType ObjectChildrenChangedSignalInfo = ObjectChildrenChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectChildrenChangedCallback cb
        cb'' <- mk_ObjectChildrenChangedCallback cb'
        connectSignalFunPtr obj "children-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::children-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:childrenChanged"})

#endif

-- signal Object::focus-event
{-# DEPRECATED ObjectFocusEventCallback ["(Since version 2.9.4)","Use the [Object::stateChange](\"GI.Atk.Objects.Object#g:signal:stateChange\") signal instead."] #-}
-- | The signal \"focus-event\" is emitted when an object gained or lost
-- focus.
type ObjectFocusEventCallback =
    Bool
    -- ^ /@arg1@/: a boolean value which indicates whether the object gained
    -- or lost focus.
    -> IO ()

type C_ObjectFocusEventCallback =
    Ptr Object ->                           -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectFocusEventCallback`.
foreign import ccall "wrapper"
    mk_ObjectFocusEventCallback :: C_ObjectFocusEventCallback -> IO (FunPtr C_ObjectFocusEventCallback)

wrap_ObjectFocusEventCallback :: 
    GObject a => (a -> ObjectFocusEventCallback) ->
    C_ObjectFocusEventCallback
wrap_ObjectFocusEventCallback gi'cb gi'selfPtr arg1 _ = do
    let arg1' = (/= 0) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1'


-- | Connect a signal handler for the [focusEvent](#signal:focusEvent) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #focusEvent callback
-- @
-- 
-- 
onObjectFocusEvent :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectFocusEventCallback) -> m SignalHandlerId
onObjectFocusEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectFocusEventCallback wrapped
    wrapped'' <- mk_ObjectFocusEventCallback wrapped'
    connectSignalFunPtr obj "focus-event" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [focusEvent](#signal:focusEvent) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #focusEvent callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectFocusEvent :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectFocusEventCallback) -> m SignalHandlerId
afterObjectFocusEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectFocusEventCallback wrapped
    wrapped'' <- mk_ObjectFocusEventCallback wrapped'
    connectSignalFunPtr obj "focus-event" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ObjectFocusEventSignalInfo
instance SignalInfo ObjectFocusEventSignalInfo where
    type HaskellCallbackType ObjectFocusEventSignalInfo = ObjectFocusEventCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectFocusEventCallback cb
        cb'' <- mk_ObjectFocusEventCallback cb'
        connectSignalFunPtr obj "focus-event" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::focus-event"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:focusEvent"})

#endif

-- signal Object::notification
-- | The \"notification\" signal can be emitted to pass an announcement on to
-- be read by a screen reader.
-- 
-- /Since: 2.50/
type ObjectNotificationCallback =
    T.Text
    -- ^ /@arg1@/: the text to be announced.
    -> Int32
    -- ^ /@arg2@/: an t'GI.Atk.Enums.Live' specifying the politeness of the notification.
    -- Should be either ATK_LIVE_POLITE or ATK_LIVE_ASSERTIVE.
    -> IO ()

type C_ObjectNotificationCallback =
    Ptr Object ->                           -- object
    CString ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectNotificationCallback`.
foreign import ccall "wrapper"
    mk_ObjectNotificationCallback :: C_ObjectNotificationCallback -> IO (FunPtr C_ObjectNotificationCallback)

wrap_ObjectNotificationCallback :: 
    GObject a => (a -> ObjectNotificationCallback) ->
    C_ObjectNotificationCallback
wrap_ObjectNotificationCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- cstringToText arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2


-- | Connect a signal handler for the [notification](#signal:notification) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #notification callback
-- @
-- 
-- 
onObjectNotification :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectNotificationCallback) -> m SignalHandlerId
onObjectNotification obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectNotificationCallback wrapped
    wrapped'' <- mk_ObjectNotificationCallback wrapped'
    connectSignalFunPtr obj "notification" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [notification](#signal:notification) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #notification callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectNotification :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectNotificationCallback) -> m SignalHandlerId
afterObjectNotification obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectNotificationCallback wrapped
    wrapped'' <- mk_ObjectNotificationCallback wrapped'
    connectSignalFunPtr obj "notification" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ObjectNotificationSignalInfo
instance SignalInfo ObjectNotificationSignalInfo where
    type HaskellCallbackType ObjectNotificationSignalInfo = ObjectNotificationCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectNotificationCallback cb
        cb'' <- mk_ObjectNotificationCallback cb'
        connectSignalFunPtr obj "notification" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::notification"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:notification"})

#endif

-- signal Object::property-change
-- | The signal \"property-change\" is emitted when an object\'s property
-- value changes. /@arg1@/ contains an t'GI.Atk.Structs.PropertyValues.PropertyValues' with the name
-- and the new value of the property whose value has changed. Note
-- that, as with GObject notify, getting this signal does not
-- guarantee that the value of the property has actually changed; it
-- may also be emitted when the setter of the property is called to
-- reinstate the previous value.
-- 
-- Toolkit implementor note: ATK implementors should use
-- 'GI.GObject.Objects.Object.objectNotify' to emit property-changed
-- notifications. t'GI.Atk.Objects.Object.Object'::@/property-changed/@ is needed by the
-- implementation of @/atk_add_global_event_listener()/@ because GObject
-- notify doesn\'t support emission hooks.
type ObjectPropertyChangeCallback =
    Maybe Atk.PropertyValues.PropertyValues
    -- ^ /@arg1@/: an t'GI.Atk.Structs.PropertyValues.PropertyValues' containing the new
    -- value of the property which changed.
    -> IO ()

type C_ObjectPropertyChangeCallback =
    Ptr Object ->                           -- object
    Ptr Atk.PropertyValues.PropertyValues ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectPropertyChangeCallback`.
foreign import ccall "wrapper"
    mk_ObjectPropertyChangeCallback :: C_ObjectPropertyChangeCallback -> IO (FunPtr C_ObjectPropertyChangeCallback)

wrap_ObjectPropertyChangeCallback :: 
    GObject a => (a -> ObjectPropertyChangeCallback) ->
    C_ObjectPropertyChangeCallback
wrap_ObjectPropertyChangeCallback gi'cb gi'selfPtr arg1 _ = do
    maybeArg1 <-
        if arg1 == FP.nullPtr
        then return Nothing
        else do
            arg1' <- (newPtr Atk.PropertyValues.PropertyValues) arg1
            return $ Just arg1'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  maybeArg1


-- | Connect a signal handler for the [propertyChange](#signal:propertyChange) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #propertyChange callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@property-change::detail@” instead.
-- 
onObjectPropertyChange :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectPropertyChangeCallback) -> m SignalHandlerId
onObjectPropertyChange obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectPropertyChangeCallback wrapped
    wrapped'' <- mk_ObjectPropertyChangeCallback wrapped'
    connectSignalFunPtr obj "property-change" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [propertyChange](#signal:propertyChange) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #propertyChange callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@property-change::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectPropertyChange :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectPropertyChangeCallback) -> m SignalHandlerId
afterObjectPropertyChange obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectPropertyChangeCallback wrapped
    wrapped'' <- mk_ObjectPropertyChangeCallback wrapped'
    connectSignalFunPtr obj "property-change" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data ObjectPropertyChangeSignalInfo
instance SignalInfo ObjectPropertyChangeSignalInfo where
    type HaskellCallbackType ObjectPropertyChangeSignalInfo = ObjectPropertyChangeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectPropertyChangeCallback cb
        cb'' <- mk_ObjectPropertyChangeCallback cb'
        connectSignalFunPtr obj "property-change" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::property-change"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:propertyChange"})

#endif

-- signal Object::state-change
-- | The \"state-change\" signal is emitted when an object\'s state
-- changes.  The detail value identifies the state type which has
-- changed.
type ObjectStateChangeCallback =
    T.Text
    -- ^ /@arg1@/: The name of the state which has changed
    -> Bool
    -- ^ /@arg2@/: A boolean which indicates whether the state has been set or unset.
    -> IO ()

type C_ObjectStateChangeCallback =
    Ptr Object ->                           -- object
    CString ->
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectStateChangeCallback`.
foreign import ccall "wrapper"
    mk_ObjectStateChangeCallback :: C_ObjectStateChangeCallback -> IO (FunPtr C_ObjectStateChangeCallback)

wrap_ObjectStateChangeCallback :: 
    GObject a => (a -> ObjectStateChangeCallback) ->
    C_ObjectStateChangeCallback
wrap_ObjectStateChangeCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- cstringToText arg1
    let arg2' = (/= 0) arg2
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2'


-- | Connect a signal handler for the [stateChange](#signal:stateChange) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #stateChange callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@state-change::detail@” instead.
-- 
onObjectStateChange :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectStateChangeCallback) -> m SignalHandlerId
onObjectStateChange obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectStateChangeCallback wrapped
    wrapped'' <- mk_ObjectStateChangeCallback wrapped'
    connectSignalFunPtr obj "state-change" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [stateChange](#signal:stateChange) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #stateChange callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@state-change::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectStateChange :: (IsObject a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => ObjectStateChangeCallback) -> m SignalHandlerId
afterObjectStateChange obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectStateChangeCallback wrapped
    wrapped'' <- mk_ObjectStateChangeCallback wrapped'
    connectSignalFunPtr obj "state-change" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data ObjectStateChangeSignalInfo
instance SignalInfo ObjectStateChangeSignalInfo where
    type HaskellCallbackType ObjectStateChangeSignalInfo = ObjectStateChangeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectStateChangeCallback cb
        cb'' <- mk_ObjectStateChangeCallback cb'
        connectSignalFunPtr obj "state-change" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::state-change"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:stateChange"})

#endif

-- signal Object::visible-data-changed
-- | The \"visible-data-changed\" signal is emitted when the visual
-- appearance of the object changed.
type ObjectVisibleDataChangedCallback =
    IO ()

type C_ObjectVisibleDataChangedCallback =
    Ptr Object ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ObjectVisibleDataChangedCallback`.
foreign import ccall "wrapper"
    mk_ObjectVisibleDataChangedCallback :: C_ObjectVisibleDataChangedCallback -> IO (FunPtr C_ObjectVisibleDataChangedCallback)

wrap_ObjectVisibleDataChangedCallback :: 
    GObject a => (a -> ObjectVisibleDataChangedCallback) ->
    C_ObjectVisibleDataChangedCallback
wrap_ObjectVisibleDataChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [visibleDataChanged](#signal:visibleDataChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' object #visibleDataChanged callback
-- @
-- 
-- 
onObjectVisibleDataChanged :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectVisibleDataChangedCallback) -> m SignalHandlerId
onObjectVisibleDataChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectVisibleDataChangedCallback wrapped
    wrapped'' <- mk_ObjectVisibleDataChangedCallback wrapped'
    connectSignalFunPtr obj "visible-data-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [visibleDataChanged](#signal:visibleDataChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' object #visibleDataChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterObjectVisibleDataChanged :: (IsObject a, MonadIO m) => a -> ((?self :: a) => ObjectVisibleDataChangedCallback) -> m SignalHandlerId
afterObjectVisibleDataChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ObjectVisibleDataChangedCallback wrapped
    wrapped'' <- mk_ObjectVisibleDataChangedCallback wrapped'
    connectSignalFunPtr obj "visible-data-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ObjectVisibleDataChangedSignalInfo
instance SignalInfo ObjectVisibleDataChangedSignalInfo where
    type HaskellCallbackType ObjectVisibleDataChangedSignalInfo = ObjectVisibleDataChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ObjectVisibleDataChangedCallback cb
        cb'' <- mk_ObjectVisibleDataChangedCallback cb'
        connectSignalFunPtr obj "visible-data-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object::visible-data-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:signal:visibleDataChanged"})

#endif

-- VVV Prop "accessible-component-layer"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-component-layer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleComponentLayer
-- @
getObjectAccessibleComponentLayer :: (MonadIO m, IsObject o) => o -> m Int32
getObjectAccessibleComponentLayer obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "accessible-component-layer"

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleComponentLayerPropertyInfo
instance AttrInfo ObjectAccessibleComponentLayerPropertyInfo where
    type AttrAllowedOps ObjectAccessibleComponentLayerPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ObjectAccessibleComponentLayerPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleComponentLayerPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ObjectAccessibleComponentLayerPropertyInfo = (~) ()
    type AttrTransferType ObjectAccessibleComponentLayerPropertyInfo = ()
    type AttrGetType ObjectAccessibleComponentLayerPropertyInfo = Int32
    type AttrLabel ObjectAccessibleComponentLayerPropertyInfo = "accessible-component-layer"
    type AttrOrigin ObjectAccessibleComponentLayerPropertyInfo = Object
    attrGet = getObjectAccessibleComponentLayer
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleComponentLayer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleComponentLayer"
        })
#endif

-- VVV Prop "accessible-component-mdi-zorder"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-component-mdi-zorder@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleComponentMdiZorder
-- @
getObjectAccessibleComponentMdiZorder :: (MonadIO m, IsObject o) => o -> m Int32
getObjectAccessibleComponentMdiZorder obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "accessible-component-mdi-zorder"

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleComponentMdiZorderPropertyInfo
instance AttrInfo ObjectAccessibleComponentMdiZorderPropertyInfo where
    type AttrAllowedOps ObjectAccessibleComponentMdiZorderPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ObjectAccessibleComponentMdiZorderPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleComponentMdiZorderPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ObjectAccessibleComponentMdiZorderPropertyInfo = (~) ()
    type AttrTransferType ObjectAccessibleComponentMdiZorderPropertyInfo = ()
    type AttrGetType ObjectAccessibleComponentMdiZorderPropertyInfo = Int32
    type AttrLabel ObjectAccessibleComponentMdiZorderPropertyInfo = "accessible-component-mdi-zorder"
    type AttrOrigin ObjectAccessibleComponentMdiZorderPropertyInfo = Object
    attrGet = getObjectAccessibleComponentMdiZorder
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleComponentMdiZorder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleComponentMdiZorder"
        })
#endif

-- VVV Prop "accessible-description"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleDescription
-- @
getObjectAccessibleDescription :: (MonadIO m, IsObject o) => o -> m (Maybe T.Text)
getObjectAccessibleDescription obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accessible-description"

-- | Set the value of the “@accessible-description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleDescription 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleDescription :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleDescription obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-description" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-description@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleDescription :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleDescription val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-description" (P.Just val)

-- | Set the value of the “@accessible-description@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleDescription
-- @
clearObjectAccessibleDescription :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleDescription obj = liftIO $ B.Properties.setObjectPropertyString obj "accessible-description" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleDescriptionPropertyInfo
instance AttrInfo ObjectAccessibleDescriptionPropertyInfo where
    type AttrAllowedOps ObjectAccessibleDescriptionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleDescriptionPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleDescriptionPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleDescriptionPropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleDescriptionPropertyInfo = T.Text
    type AttrGetType ObjectAccessibleDescriptionPropertyInfo = (Maybe T.Text)
    type AttrLabel ObjectAccessibleDescriptionPropertyInfo = "accessible-description"
    type AttrOrigin ObjectAccessibleDescriptionPropertyInfo = Object
    attrGet = getObjectAccessibleDescription
    attrSet = setObjectAccessibleDescription
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleDescription
    attrClear = clearObjectAccessibleDescription
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleDescription"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleDescription"
        })
#endif

-- VVV Prop "accessible-help-text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-help-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleHelpText
-- @
getObjectAccessibleHelpText :: (MonadIO m, IsObject o) => o -> m (Maybe T.Text)
getObjectAccessibleHelpText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accessible-help-text"

-- | Set the value of the “@accessible-help-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleHelpText 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleHelpText :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleHelpText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-help-text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-help-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleHelpText :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleHelpText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-help-text" (P.Just val)

-- | Set the value of the “@accessible-help-text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleHelpText
-- @
clearObjectAccessibleHelpText :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleHelpText obj = liftIO $ B.Properties.setObjectPropertyString obj "accessible-help-text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleHelpTextPropertyInfo
instance AttrInfo ObjectAccessibleHelpTextPropertyInfo where
    type AttrAllowedOps ObjectAccessibleHelpTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleHelpTextPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleHelpTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleHelpTextPropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleHelpTextPropertyInfo = T.Text
    type AttrGetType ObjectAccessibleHelpTextPropertyInfo = (Maybe T.Text)
    type AttrLabel ObjectAccessibleHelpTextPropertyInfo = "accessible-help-text"
    type AttrOrigin ObjectAccessibleHelpTextPropertyInfo = Object
    attrGet = getObjectAccessibleHelpText
    attrSet = setObjectAccessibleHelpText
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleHelpText
    attrClear = clearObjectAccessibleHelpText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleHelpText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleHelpText"
        })
#endif

-- VVV Prop "accessible-hypertext-nlinks"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-hypertext-nlinks@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleHypertextNlinks
-- @
getObjectAccessibleHypertextNlinks :: (MonadIO m, IsObject o) => o -> m Int32
getObjectAccessibleHypertextNlinks obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "accessible-hypertext-nlinks"

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleHypertextNlinksPropertyInfo
instance AttrInfo ObjectAccessibleHypertextNlinksPropertyInfo where
    type AttrAllowedOps ObjectAccessibleHypertextNlinksPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ObjectAccessibleHypertextNlinksPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleHypertextNlinksPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ObjectAccessibleHypertextNlinksPropertyInfo = (~) ()
    type AttrTransferType ObjectAccessibleHypertextNlinksPropertyInfo = ()
    type AttrGetType ObjectAccessibleHypertextNlinksPropertyInfo = Int32
    type AttrLabel ObjectAccessibleHypertextNlinksPropertyInfo = "accessible-hypertext-nlinks"
    type AttrOrigin ObjectAccessibleHypertextNlinksPropertyInfo = Object
    attrGet = getObjectAccessibleHypertextNlinks
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleHypertextNlinks"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleHypertextNlinks"
        })
#endif

-- VVV Prop "accessible-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@accessible-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleId
-- @
getObjectAccessibleId :: (MonadIO m, IsObject o) => o -> m T.Text
getObjectAccessibleId obj = MIO.liftIO $ checkUnexpectedNothing "getObjectAccessibleId" $ B.Properties.getObjectPropertyString obj "accessible-id"

-- | Set the value of the “@accessible-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleId 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleId :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleId obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-id" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleId :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleIdPropertyInfo
instance AttrInfo ObjectAccessibleIdPropertyInfo where
    type AttrAllowedOps ObjectAccessibleIdPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ObjectAccessibleIdPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleIdPropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleIdPropertyInfo = T.Text
    type AttrGetType ObjectAccessibleIdPropertyInfo = T.Text
    type AttrLabel ObjectAccessibleIdPropertyInfo = "accessible-id"
    type AttrOrigin ObjectAccessibleIdPropertyInfo = Object
    attrGet = getObjectAccessibleId
    attrSet = setObjectAccessibleId
    attrPut = setObjectAccessibleId
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleId"
        })
#endif

-- VVV Prop "accessible-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleName
-- @
getObjectAccessibleName :: (MonadIO m, IsObject o) => o -> m (Maybe T.Text)
getObjectAccessibleName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accessible-name"

-- | Set the value of the “@accessible-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleName 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleName :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleName :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-name" (P.Just val)

-- | Set the value of the “@accessible-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleName
-- @
clearObjectAccessibleName :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleName obj = liftIO $ B.Properties.setObjectPropertyString obj "accessible-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleNamePropertyInfo
instance AttrInfo ObjectAccessibleNamePropertyInfo where
    type AttrAllowedOps ObjectAccessibleNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleNamePropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleNamePropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleNamePropertyInfo = T.Text
    type AttrGetType ObjectAccessibleNamePropertyInfo = (Maybe T.Text)
    type AttrLabel ObjectAccessibleNamePropertyInfo = "accessible-name"
    type AttrOrigin ObjectAccessibleNamePropertyInfo = Object
    attrGet = getObjectAccessibleName
    attrSet = setObjectAccessibleName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleName
    attrClear = clearObjectAccessibleName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleName"
        })
#endif

-- VVV Prop "accessible-parent"
   -- Type: TInterface (Name {namespace = "Atk", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-parent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleParent
-- @
getObjectAccessibleParent :: (MonadIO m, IsObject o) => o -> m (Maybe Object)
getObjectAccessibleParent obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "accessible-parent" Object

-- | Set the value of the “@accessible-parent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleParent 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleParent :: (MonadIO m, IsObject o, IsObject a) => o -> a -> m ()
setObjectAccessibleParent obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accessible-parent" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-parent@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleParent :: (IsObject o, MIO.MonadIO m, IsObject a) => a -> m (GValueConstruct o)
constructObjectAccessibleParent val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accessible-parent" (P.Just val)

-- | Set the value of the “@accessible-parent@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleParent
-- @
clearObjectAccessibleParent :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleParent obj = liftIO $ B.Properties.setObjectPropertyObject obj "accessible-parent" (Nothing :: Maybe Object)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleParentPropertyInfo
instance AttrInfo ObjectAccessibleParentPropertyInfo where
    type AttrAllowedOps ObjectAccessibleParentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleParentPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleParentPropertyInfo = IsObject
    type AttrTransferTypeConstraint ObjectAccessibleParentPropertyInfo = IsObject
    type AttrTransferType ObjectAccessibleParentPropertyInfo = Object
    type AttrGetType ObjectAccessibleParentPropertyInfo = (Maybe Object)
    type AttrLabel ObjectAccessibleParentPropertyInfo = "accessible-parent"
    type AttrOrigin ObjectAccessibleParentPropertyInfo = Object
    attrGet = getObjectAccessibleParent
    attrSet = setObjectAccessibleParent
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Object v
    attrConstruct = constructObjectAccessibleParent
    attrClear = clearObjectAccessibleParent
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleParent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleParent"
        })
#endif

-- VVV Prop "accessible-role"
   -- Type: TInterface (Name {namespace = "Atk", name = "Role"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-role@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleRole
-- @
getObjectAccessibleRole :: (MonadIO m, IsObject o) => o -> m Atk.Enums.Role
getObjectAccessibleRole obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "accessible-role"

-- | Set the value of the “@accessible-role@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleRole 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleRole :: (MonadIO m, IsObject o) => o -> Atk.Enums.Role -> m ()
setObjectAccessibleRole obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "accessible-role" val

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-role@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleRole :: (IsObject o, MIO.MonadIO m) => Atk.Enums.Role -> m (GValueConstruct o)
constructObjectAccessibleRole val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "accessible-role" val

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleRolePropertyInfo
instance AttrInfo ObjectAccessibleRolePropertyInfo where
    type AttrAllowedOps ObjectAccessibleRolePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ObjectAccessibleRolePropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleRolePropertyInfo = (~) Atk.Enums.Role
    type AttrTransferTypeConstraint ObjectAccessibleRolePropertyInfo = (~) Atk.Enums.Role
    type AttrTransferType ObjectAccessibleRolePropertyInfo = Atk.Enums.Role
    type AttrGetType ObjectAccessibleRolePropertyInfo = Atk.Enums.Role
    type AttrLabel ObjectAccessibleRolePropertyInfo = "accessible-role"
    type AttrOrigin ObjectAccessibleRolePropertyInfo = Object
    attrGet = getObjectAccessibleRole
    attrSet = setObjectAccessibleRole
    attrPut = setObjectAccessibleRole
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleRole
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleRole"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleRole"
        })
#endif

-- VVV Prop "accessible-table-caption"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-caption@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableCaption
-- @
getObjectAccessibleTableCaption :: (MonadIO m, IsObject o) => o -> m (Maybe T.Text)
getObjectAccessibleTableCaption obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accessible-table-caption"

-- | Set the value of the “@accessible-table-caption@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableCaption 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableCaption :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleTableCaption obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-table-caption" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-caption@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableCaption :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleTableCaption val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-table-caption" (P.Just val)

-- | Set the value of the “@accessible-table-caption@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableCaption
-- @
clearObjectAccessibleTableCaption :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableCaption obj = liftIO $ B.Properties.setObjectPropertyString obj "accessible-table-caption" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableCaptionPropertyInfo
instance AttrInfo ObjectAccessibleTableCaptionPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableCaptionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableCaptionPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableCaptionPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleTableCaptionPropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleTableCaptionPropertyInfo = T.Text
    type AttrGetType ObjectAccessibleTableCaptionPropertyInfo = (Maybe T.Text)
    type AttrLabel ObjectAccessibleTableCaptionPropertyInfo = "accessible-table-caption"
    type AttrOrigin ObjectAccessibleTableCaptionPropertyInfo = Object
    attrGet = getObjectAccessibleTableCaption
    attrSet = setObjectAccessibleTableCaption
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleTableCaption
    attrClear = clearObjectAccessibleTableCaption
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableCaption"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableCaption"
        })
#endif

-- VVV Prop "accessible-table-caption-object"
   -- Type: TInterface (Name {namespace = "Atk", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-caption-object@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableCaptionObject
-- @
getObjectAccessibleTableCaptionObject :: (MonadIO m, IsObject o) => o -> m (Maybe Object)
getObjectAccessibleTableCaptionObject obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "accessible-table-caption-object" Object

-- | Set the value of the “@accessible-table-caption-object@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableCaptionObject 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableCaptionObject :: (MonadIO m, IsObject o, IsObject a) => o -> a -> m ()
setObjectAccessibleTableCaptionObject obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accessible-table-caption-object" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-caption-object@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableCaptionObject :: (IsObject o, MIO.MonadIO m, IsObject a) => a -> m (GValueConstruct o)
constructObjectAccessibleTableCaptionObject val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accessible-table-caption-object" (P.Just val)

-- | Set the value of the “@accessible-table-caption-object@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableCaptionObject
-- @
clearObjectAccessibleTableCaptionObject :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableCaptionObject obj = liftIO $ B.Properties.setObjectPropertyObject obj "accessible-table-caption-object" (Nothing :: Maybe Object)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableCaptionObjectPropertyInfo
instance AttrInfo ObjectAccessibleTableCaptionObjectPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableCaptionObjectPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableCaptionObjectPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableCaptionObjectPropertyInfo = IsObject
    type AttrTransferTypeConstraint ObjectAccessibleTableCaptionObjectPropertyInfo = IsObject
    type AttrTransferType ObjectAccessibleTableCaptionObjectPropertyInfo = Object
    type AttrGetType ObjectAccessibleTableCaptionObjectPropertyInfo = (Maybe Object)
    type AttrLabel ObjectAccessibleTableCaptionObjectPropertyInfo = "accessible-table-caption-object"
    type AttrOrigin ObjectAccessibleTableCaptionObjectPropertyInfo = Object
    attrGet = getObjectAccessibleTableCaptionObject
    attrSet = setObjectAccessibleTableCaptionObject
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Object v
    attrConstruct = constructObjectAccessibleTableCaptionObject
    attrClear = clearObjectAccessibleTableCaptionObject
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableCaptionObject"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableCaptionObject"
        })
#endif

-- VVV Prop "accessible-table-column-description"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-column-description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableColumnDescription
-- @
getObjectAccessibleTableColumnDescription :: (MonadIO m, IsObject o) => o -> m (Maybe T.Text)
getObjectAccessibleTableColumnDescription obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accessible-table-column-description"

-- | Set the value of the “@accessible-table-column-description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableColumnDescription 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableColumnDescription :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleTableColumnDescription obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-table-column-description" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-column-description@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableColumnDescription :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleTableColumnDescription val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-table-column-description" (P.Just val)

-- | Set the value of the “@accessible-table-column-description@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableColumnDescription
-- @
clearObjectAccessibleTableColumnDescription :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableColumnDescription obj = liftIO $ B.Properties.setObjectPropertyString obj "accessible-table-column-description" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableColumnDescriptionPropertyInfo
instance AttrInfo ObjectAccessibleTableColumnDescriptionPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableColumnDescriptionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableColumnDescriptionPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableColumnDescriptionPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleTableColumnDescriptionPropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleTableColumnDescriptionPropertyInfo = T.Text
    type AttrGetType ObjectAccessibleTableColumnDescriptionPropertyInfo = (Maybe T.Text)
    type AttrLabel ObjectAccessibleTableColumnDescriptionPropertyInfo = "accessible-table-column-description"
    type AttrOrigin ObjectAccessibleTableColumnDescriptionPropertyInfo = Object
    attrGet = getObjectAccessibleTableColumnDescription
    attrSet = setObjectAccessibleTableColumnDescription
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleTableColumnDescription
    attrClear = clearObjectAccessibleTableColumnDescription
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableColumnDescription"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableColumnDescription"
        })
#endif

-- VVV Prop "accessible-table-column-header"
   -- Type: TInterface (Name {namespace = "Atk", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-column-header@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableColumnHeader
-- @
getObjectAccessibleTableColumnHeader :: (MonadIO m, IsObject o) => o -> m (Maybe Object)
getObjectAccessibleTableColumnHeader obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "accessible-table-column-header" Object

-- | Set the value of the “@accessible-table-column-header@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableColumnHeader 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableColumnHeader :: (MonadIO m, IsObject o, IsObject a) => o -> a -> m ()
setObjectAccessibleTableColumnHeader obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accessible-table-column-header" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-column-header@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableColumnHeader :: (IsObject o, MIO.MonadIO m, IsObject a) => a -> m (GValueConstruct o)
constructObjectAccessibleTableColumnHeader val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accessible-table-column-header" (P.Just val)

-- | Set the value of the “@accessible-table-column-header@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableColumnHeader
-- @
clearObjectAccessibleTableColumnHeader :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableColumnHeader obj = liftIO $ B.Properties.setObjectPropertyObject obj "accessible-table-column-header" (Nothing :: Maybe Object)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableColumnHeaderPropertyInfo
instance AttrInfo ObjectAccessibleTableColumnHeaderPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableColumnHeaderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableColumnHeaderPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableColumnHeaderPropertyInfo = IsObject
    type AttrTransferTypeConstraint ObjectAccessibleTableColumnHeaderPropertyInfo = IsObject
    type AttrTransferType ObjectAccessibleTableColumnHeaderPropertyInfo = Object
    type AttrGetType ObjectAccessibleTableColumnHeaderPropertyInfo = (Maybe Object)
    type AttrLabel ObjectAccessibleTableColumnHeaderPropertyInfo = "accessible-table-column-header"
    type AttrOrigin ObjectAccessibleTableColumnHeaderPropertyInfo = Object
    attrGet = getObjectAccessibleTableColumnHeader
    attrSet = setObjectAccessibleTableColumnHeader
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Object v
    attrConstruct = constructObjectAccessibleTableColumnHeader
    attrClear = clearObjectAccessibleTableColumnHeader
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableColumnHeader"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableColumnHeader"
        })
#endif

-- VVV Prop "accessible-table-row-description"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-row-description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableRowDescription
-- @
getObjectAccessibleTableRowDescription :: (MonadIO m, IsObject o) => o -> m (Maybe T.Text)
getObjectAccessibleTableRowDescription obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accessible-table-row-description"

-- | Set the value of the “@accessible-table-row-description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableRowDescription 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableRowDescription :: (MonadIO m, IsObject o) => o -> T.Text -> m ()
setObjectAccessibleTableRowDescription obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accessible-table-row-description" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-row-description@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableRowDescription :: (IsObject o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructObjectAccessibleTableRowDescription val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accessible-table-row-description" (P.Just val)

-- | Set the value of the “@accessible-table-row-description@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableRowDescription
-- @
clearObjectAccessibleTableRowDescription :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableRowDescription obj = liftIO $ B.Properties.setObjectPropertyString obj "accessible-table-row-description" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableRowDescriptionPropertyInfo
instance AttrInfo ObjectAccessibleTableRowDescriptionPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableRowDescriptionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableRowDescriptionPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableRowDescriptionPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ObjectAccessibleTableRowDescriptionPropertyInfo = (~) T.Text
    type AttrTransferType ObjectAccessibleTableRowDescriptionPropertyInfo = T.Text
    type AttrGetType ObjectAccessibleTableRowDescriptionPropertyInfo = (Maybe T.Text)
    type AttrLabel ObjectAccessibleTableRowDescriptionPropertyInfo = "accessible-table-row-description"
    type AttrOrigin ObjectAccessibleTableRowDescriptionPropertyInfo = Object
    attrGet = getObjectAccessibleTableRowDescription
    attrSet = setObjectAccessibleTableRowDescription
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleTableRowDescription
    attrClear = clearObjectAccessibleTableRowDescription
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableRowDescription"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableRowDescription"
        })
#endif

-- VVV Prop "accessible-table-row-header"
   -- Type: TInterface (Name {namespace = "Atk", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-row-header@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableRowHeader
-- @
getObjectAccessibleTableRowHeader :: (MonadIO m, IsObject o) => o -> m (Maybe Object)
getObjectAccessibleTableRowHeader obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "accessible-table-row-header" Object

-- | Set the value of the “@accessible-table-row-header@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableRowHeader 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableRowHeader :: (MonadIO m, IsObject o, IsObject a) => o -> a -> m ()
setObjectAccessibleTableRowHeader obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accessible-table-row-header" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-row-header@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableRowHeader :: (IsObject o, MIO.MonadIO m, IsObject a) => a -> m (GValueConstruct o)
constructObjectAccessibleTableRowHeader val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accessible-table-row-header" (P.Just val)

-- | Set the value of the “@accessible-table-row-header@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableRowHeader
-- @
clearObjectAccessibleTableRowHeader :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableRowHeader obj = liftIO $ B.Properties.setObjectPropertyObject obj "accessible-table-row-header" (Nothing :: Maybe Object)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableRowHeaderPropertyInfo
instance AttrInfo ObjectAccessibleTableRowHeaderPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableRowHeaderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableRowHeaderPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableRowHeaderPropertyInfo = IsObject
    type AttrTransferTypeConstraint ObjectAccessibleTableRowHeaderPropertyInfo = IsObject
    type AttrTransferType ObjectAccessibleTableRowHeaderPropertyInfo = Object
    type AttrGetType ObjectAccessibleTableRowHeaderPropertyInfo = (Maybe Object)
    type AttrLabel ObjectAccessibleTableRowHeaderPropertyInfo = "accessible-table-row-header"
    type AttrOrigin ObjectAccessibleTableRowHeaderPropertyInfo = Object
    attrGet = getObjectAccessibleTableRowHeader
    attrSet = setObjectAccessibleTableRowHeader
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Object v
    attrConstruct = constructObjectAccessibleTableRowHeader
    attrClear = clearObjectAccessibleTableRowHeader
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableRowHeader"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableRowHeader"
        })
#endif

-- VVV Prop "accessible-table-summary"
   -- Type: TInterface (Name {namespace = "Atk", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-table-summary@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleTableSummary
-- @
getObjectAccessibleTableSummary :: (MonadIO m, IsObject o) => o -> m (Maybe Object)
getObjectAccessibleTableSummary obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "accessible-table-summary" Object

-- | Set the value of the “@accessible-table-summary@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleTableSummary 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleTableSummary :: (MonadIO m, IsObject o, IsObject a) => o -> a -> m ()
setObjectAccessibleTableSummary obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accessible-table-summary" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-table-summary@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleTableSummary :: (IsObject o, MIO.MonadIO m, IsObject a) => a -> m (GValueConstruct o)
constructObjectAccessibleTableSummary val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accessible-table-summary" (P.Just val)

-- | Set the value of the “@accessible-table-summary@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accessibleTableSummary
-- @
clearObjectAccessibleTableSummary :: (MonadIO m, IsObject o) => o -> m ()
clearObjectAccessibleTableSummary obj = liftIO $ B.Properties.setObjectPropertyObject obj "accessible-table-summary" (Nothing :: Maybe Object)

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleTableSummaryPropertyInfo
instance AttrInfo ObjectAccessibleTableSummaryPropertyInfo where
    type AttrAllowedOps ObjectAccessibleTableSummaryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ObjectAccessibleTableSummaryPropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleTableSummaryPropertyInfo = IsObject
    type AttrTransferTypeConstraint ObjectAccessibleTableSummaryPropertyInfo = IsObject
    type AttrTransferType ObjectAccessibleTableSummaryPropertyInfo = Object
    type AttrGetType ObjectAccessibleTableSummaryPropertyInfo = (Maybe Object)
    type AttrLabel ObjectAccessibleTableSummaryPropertyInfo = "accessible-table-summary"
    type AttrOrigin ObjectAccessibleTableSummaryPropertyInfo = Object
    attrGet = getObjectAccessibleTableSummary
    attrSet = setObjectAccessibleTableSummary
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Object v
    attrConstruct = constructObjectAccessibleTableSummary
    attrClear = clearObjectAccessibleTableSummary
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleTableSummary"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleTableSummary"
        })
#endif

-- VVV Prop "accessible-value"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accessible-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' object #accessibleValue
-- @
getObjectAccessibleValue :: (MonadIO m, IsObject o) => o -> m Double
getObjectAccessibleValue obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "accessible-value"

-- | Set the value of the “@accessible-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' object [ #accessibleValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectAccessibleValue :: (MonadIO m, IsObject o) => o -> Double -> m ()
setObjectAccessibleValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "accessible-value" val

-- | Construct a t'GValueConstruct' with valid value for the “@accessible-value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructObjectAccessibleValue :: (IsObject o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructObjectAccessibleValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "accessible-value" val

#if defined(ENABLE_OVERLOADING)
data ObjectAccessibleValuePropertyInfo
instance AttrInfo ObjectAccessibleValuePropertyInfo where
    type AttrAllowedOps ObjectAccessibleValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ObjectAccessibleValuePropertyInfo = IsObject
    type AttrSetTypeConstraint ObjectAccessibleValuePropertyInfo = (~) Double
    type AttrTransferTypeConstraint ObjectAccessibleValuePropertyInfo = (~) Double
    type AttrTransferType ObjectAccessibleValuePropertyInfo = Double
    type AttrGetType ObjectAccessibleValuePropertyInfo = Double
    type AttrLabel ObjectAccessibleValuePropertyInfo = "accessible-value"
    type AttrOrigin ObjectAccessibleValuePropertyInfo = Object
    attrGet = getObjectAccessibleValue
    attrSet = setObjectAccessibleValue
    attrPut = setObjectAccessibleValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructObjectAccessibleValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.accessibleValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#g:attr:accessibleValue"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Object
type instance O.AttributeList Object = ObjectAttributeList
type ObjectAttributeList = ('[ '("accessibleComponentLayer", ObjectAccessibleComponentLayerPropertyInfo), '("accessibleComponentMdiZorder", ObjectAccessibleComponentMdiZorderPropertyInfo), '("accessibleDescription", ObjectAccessibleDescriptionPropertyInfo), '("accessibleHelpText", ObjectAccessibleHelpTextPropertyInfo), '("accessibleHypertextNlinks", ObjectAccessibleHypertextNlinksPropertyInfo), '("accessibleId", ObjectAccessibleIdPropertyInfo), '("accessibleName", ObjectAccessibleNamePropertyInfo), '("accessibleParent", ObjectAccessibleParentPropertyInfo), '("accessibleRole", ObjectAccessibleRolePropertyInfo), '("accessibleTableCaption", ObjectAccessibleTableCaptionPropertyInfo), '("accessibleTableCaptionObject", ObjectAccessibleTableCaptionObjectPropertyInfo), '("accessibleTableColumnDescription", ObjectAccessibleTableColumnDescriptionPropertyInfo), '("accessibleTableColumnHeader", ObjectAccessibleTableColumnHeaderPropertyInfo), '("accessibleTableRowDescription", ObjectAccessibleTableRowDescriptionPropertyInfo), '("accessibleTableRowHeader", ObjectAccessibleTableRowHeaderPropertyInfo), '("accessibleTableSummary", ObjectAccessibleTableSummaryPropertyInfo), '("accessibleValue", ObjectAccessibleValuePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
objectAccessibleComponentLayer :: AttrLabelProxy "accessibleComponentLayer"
objectAccessibleComponentLayer = AttrLabelProxy

objectAccessibleComponentMdiZorder :: AttrLabelProxy "accessibleComponentMdiZorder"
objectAccessibleComponentMdiZorder = AttrLabelProxy

objectAccessibleDescription :: AttrLabelProxy "accessibleDescription"
objectAccessibleDescription = AttrLabelProxy

objectAccessibleHelpText :: AttrLabelProxy "accessibleHelpText"
objectAccessibleHelpText = AttrLabelProxy

objectAccessibleHypertextNlinks :: AttrLabelProxy "accessibleHypertextNlinks"
objectAccessibleHypertextNlinks = AttrLabelProxy

objectAccessibleId :: AttrLabelProxy "accessibleId"
objectAccessibleId = AttrLabelProxy

objectAccessibleName :: AttrLabelProxy "accessibleName"
objectAccessibleName = AttrLabelProxy

objectAccessibleParent :: AttrLabelProxy "accessibleParent"
objectAccessibleParent = AttrLabelProxy

objectAccessibleRole :: AttrLabelProxy "accessibleRole"
objectAccessibleRole = AttrLabelProxy

objectAccessibleTableCaption :: AttrLabelProxy "accessibleTableCaption"
objectAccessibleTableCaption = AttrLabelProxy

objectAccessibleTableCaptionObject :: AttrLabelProxy "accessibleTableCaptionObject"
objectAccessibleTableCaptionObject = AttrLabelProxy

objectAccessibleTableColumnDescription :: AttrLabelProxy "accessibleTableColumnDescription"
objectAccessibleTableColumnDescription = AttrLabelProxy

objectAccessibleTableColumnHeader :: AttrLabelProxy "accessibleTableColumnHeader"
objectAccessibleTableColumnHeader = AttrLabelProxy

objectAccessibleTableRowDescription :: AttrLabelProxy "accessibleTableRowDescription"
objectAccessibleTableRowDescription = AttrLabelProxy

objectAccessibleTableRowHeader :: AttrLabelProxy "accessibleTableRowHeader"
objectAccessibleTableRowHeader = AttrLabelProxy

objectAccessibleTableSummary :: AttrLabelProxy "accessibleTableSummary"
objectAccessibleTableSummary = AttrLabelProxy

objectAccessibleValue :: AttrLabelProxy "accessibleValue"
objectAccessibleValue = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Object = ObjectSignalList
type ObjectSignalList = ('[ '("activeDescendantChanged", ObjectActiveDescendantChangedSignalInfo), '("announcement", ObjectAnnouncementSignalInfo), '("attributeChanged", ObjectAttributeChangedSignalInfo), '("childrenChanged", ObjectChildrenChangedSignalInfo), '("focusEvent", ObjectFocusEventSignalInfo), '("notification", ObjectNotificationSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("propertyChange", ObjectPropertyChangeSignalInfo), '("stateChange", ObjectStateChangeSignalInfo), '("visibleDataChanged", ObjectVisibleDataChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Object::add_relationship
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #AtkObject to which an AtkRelation is to be added."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "relationship"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "RelationType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #AtkRelationType of the relation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #AtkObject which is to be the target of the relation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_add_relationship" atk_object_add_relationship :: 
    Ptr Object ->                           -- object : TInterface (Name {namespace = "Atk", name = "Object"})
    CUInt ->                                -- relationship : TInterface (Name {namespace = "Atk", name = "RelationType"})
    Ptr Object ->                           -- target : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CInt

-- | Adds a relationship of the specified type with the specified target.
objectAddRelationship ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a, IsObject b) =>
    a
    -- ^ /@object@/: The t'GI.Atk.Objects.Object.Object' to which an AtkRelation is to be added.
    -> Atk.Enums.RelationType
    -- ^ /@relationship@/: The t'GI.Atk.Enums.RelationType' of the relation
    -> b
    -- ^ /@target@/: The t'GI.Atk.Objects.Object.Object' which is to be the target of the relation.
    -> m Bool
    -- ^ __Returns:__ TRUE if the relationship is added.
objectAddRelationship object relationship target = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    let relationship' = (fromIntegral . fromEnum) relationship
    target' <- unsafeManagedPtrCastPtr target
    result <- atk_object_add_relationship object' relationship' target'
    let result' = (/= 0) result
    touchManagedPtr object
    touchManagedPtr target
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectAddRelationshipMethodInfo
instance (signature ~ (Atk.Enums.RelationType -> b -> m Bool), MonadIO m, IsObject a, IsObject b) => O.OverloadedMethod ObjectAddRelationshipMethodInfo a signature where
    overloadedMethod = objectAddRelationship

instance O.OverloadedMethodInfo ObjectAddRelationshipMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectAddRelationship",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectAddRelationship"
        })


#endif

-- method Object::get_accessible_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_accessible_id" atk_object_get_accessible_id :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CString

-- | Gets the accessible id of the accessible.
-- 
-- /Since: 2.34/
objectGetAccessibleId ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m T.Text
    -- ^ __Returns:__ a character string representing the accessible id of the object, or
    -- NULL if no such string was set.
objectGetAccessibleId accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_accessible_id accessible'
    checkUnexpectedReturnNULL "objectGetAccessibleId" result
    result' <- cstringToText result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetAccessibleIdMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetAccessibleIdMethodInfo a signature where
    overloadedMethod = objectGetAccessibleId

instance O.OverloadedMethodInfo ObjectGetAccessibleIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetAccessibleId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetAccessibleId"
        })


#endif

-- method Object::get_attributes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An #AtkObject." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGSList (TBasicType TPtr))
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_attributes" atk_object_get_attributes :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO (Ptr (GSList (Ptr ())))

-- | Get a list of properties applied to this object as a whole, as an @/AtkAttributeSet/@ consisting of
-- name-value pairs. As such these attributes may be considered weakly-typed properties or annotations,
-- as distinct from strongly-typed object data available via other get\/set methods.
-- Not all objects have explicit \"name-value pair\" @/AtkAttributeSet/@ properties.
-- 
-- /Since: 1.12/
objectGetAttributes ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: An t'GI.Atk.Objects.Object.Object'.
    -> m ([Ptr ()])
    -- ^ __Returns:__ an @/AtkAttributeSet/@ consisting of all
    -- explicit properties\/annotations applied to the object, or an empty
    -- set if the object has no name-value pair attributes assigned to
    -- it. This @/atkattributeset/@ should be freed by a call to
    -- 'GI.Atk.Functions.attributeSetFree'.
objectGetAttributes accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_attributes accessible'
    result' <- unpackGSList result
    g_slist_free result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetAttributesMethodInfo
instance (signature ~ (m ([Ptr ()])), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetAttributesMethodInfo a signature where
    overloadedMethod = objectGetAttributes

instance O.OverloadedMethodInfo ObjectGetAttributesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetAttributes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetAttributes"
        })


#endif

-- method Object::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_description" atk_object_get_description :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CString

-- | Gets the accessible description of the accessible.
objectGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m T.Text
    -- ^ __Returns:__ a character string representing the accessible description
    -- of the accessible.
objectGetDescription accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_description accessible'
    checkUnexpectedReturnNULL "objectGetDescription" result
    result' <- cstringToText result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetDescriptionMethodInfo a signature where
    overloadedMethod = objectGetDescription

instance O.OverloadedMethodInfo ObjectGetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetDescription"
        })


#endif

-- method Object::get_help_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_help_text" atk_object_get_help_text :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CString

-- | Gets the help text associated with the accessible.
-- 
-- /Since: 2.52/
objectGetHelpText ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m T.Text
    -- ^ __Returns:__ a character string representing the help text or the object, or
    -- NULL if no such string was set.
objectGetHelpText accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_help_text accessible'
    checkUnexpectedReturnNULL "objectGetHelpText" result
    result' <- cstringToText result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetHelpTextMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetHelpTextMethodInfo a signature where
    overloadedMethod = objectGetHelpText

instance O.OverloadedMethodInfo ObjectGetHelpTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetHelpText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetHelpText"
        })


#endif

-- method Object::get_index_in_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_index_in_parent" atk_object_get_index_in_parent :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO Int32

-- | Gets the 0-based index of this accessible in its parent; returns -1 if the
-- accessible does not have an accessible parent.
objectGetIndexInParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Int32
    -- ^ __Returns:__ an integer which is the index of the accessible in its parent
objectGetIndexInParent accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_index_in_parent accessible'
    touchManagedPtr accessible
    return result

#if defined(ENABLE_OVERLOADING)
data ObjectGetIndexInParentMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetIndexInParentMethodInfo a signature where
    overloadedMethod = objectGetIndexInParent

instance O.OverloadedMethodInfo ObjectGetIndexInParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetIndexInParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetIndexInParent"
        })


#endif

-- method Object::get_layer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Layer" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_layer" atk_object_get_layer :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CUInt

{-# DEPRECATED objectGetLayer ["Use atk_component_get_layer instead."] #-}
-- | Gets the layer of the accessible.
objectGetLayer ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Atk.Enums.Layer
    -- ^ __Returns:__ an t'GI.Atk.Enums.Layer' which is the layer of the accessible
objectGetLayer accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_layer accessible'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetLayerMethodInfo
instance (signature ~ (m Atk.Enums.Layer), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetLayerMethodInfo a signature where
    overloadedMethod = objectGetLayer

instance O.OverloadedMethodInfo ObjectGetLayerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetLayer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetLayer"
        })


#endif

-- method Object::get_mdi_zorder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_mdi_zorder" atk_object_get_mdi_zorder :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO Int32

{-# DEPRECATED objectGetMdiZorder ["Use atk_component_get_mdi_zorder instead."] #-}
-- | Gets the zorder of the accessible. The value G_MININT will be returned
-- if the layer of the accessible is not ATK_LAYER_MDI.
objectGetMdiZorder ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Int32
    -- ^ __Returns:__ a gint which is the zorder of the accessible, i.e. the depth at
    -- which the component is shown in relation to other components in the same
    -- container.
objectGetMdiZorder accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_mdi_zorder accessible'
    touchManagedPtr accessible
    return result

#if defined(ENABLE_OVERLOADING)
data ObjectGetMdiZorderMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetMdiZorderMethodInfo a signature where
    overloadedMethod = objectGetMdiZorder

instance O.OverloadedMethodInfo ObjectGetMdiZorderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetMdiZorder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetMdiZorder"
        })


#endif

-- method Object::get_n_accessible_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_n_accessible_children" atk_object_get_n_accessible_children :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO Int32

-- | Gets the number of accessible children of the accessible.
objectGetNAccessibleChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Int32
    -- ^ __Returns:__ an integer representing the number of accessible children
    -- of the accessible.
objectGetNAccessibleChildren accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_n_accessible_children accessible'
    touchManagedPtr accessible
    return result

#if defined(ENABLE_OVERLOADING)
data ObjectGetNAccessibleChildrenMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetNAccessibleChildrenMethodInfo a signature where
    overloadedMethod = objectGetNAccessibleChildren

instance O.OverloadedMethodInfo ObjectGetNAccessibleChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetNAccessibleChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetNAccessibleChildren"
        })


#endif

-- method Object::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_name" atk_object_get_name :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CString

-- | Gets the accessible name of the accessible.
objectGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m T.Text
    -- ^ __Returns:__ a character string representing the accessible name of the object.
objectGetName accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_name accessible'
    checkUnexpectedReturnNULL "objectGetName" result
    result' <- cstringToText result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetNameMethodInfo a signature where
    overloadedMethod = objectGetName

instance O.OverloadedMethodInfo ObjectGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetName"
        })


#endif

-- method Object::get_object_locale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_object_locale" atk_object_get_object_locale :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CString

-- | Gets a UTF-8 string indicating the POSIX-style LC_MESSAGES locale
-- of /@accessible@/.
-- 
-- /Since: 2.8/
objectGetObjectLocale ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m T.Text
    -- ^ __Returns:__ a UTF-8 string indicating the POSIX-style LC_MESSAGES
    --          locale of /@accessible@/.
objectGetObjectLocale accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_object_locale accessible'
    checkUnexpectedReturnNULL "objectGetObjectLocale" result
    result' <- cstringToText result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetObjectLocaleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetObjectLocaleMethodInfo a signature where
    overloadedMethod = objectGetObjectLocale

instance O.OverloadedMethodInfo ObjectGetObjectLocaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetObjectLocale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetObjectLocale"
        })


#endif

-- method Object::get_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_parent" atk_object_get_parent :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO (Ptr Object)

-- | Gets the accessible parent of the accessible. By default this is
-- the one assigned with 'GI.Atk.Objects.Object.objectSetParent', but it is assumed
-- that ATK implementors have ways to get the parent of the object
-- without the need of assigning it manually with
-- 'GI.Atk.Objects.Object.objectSetParent', and will return it with this method.
-- 
-- If you are only interested on the parent assigned with
-- 'GI.Atk.Objects.Object.objectSetParent', use 'GI.Atk.Objects.Object.objectPeekParent'.
objectGetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Object
    -- ^ __Returns:__ an t'GI.Atk.Objects.Object.Object' representing the accessible
    -- parent of the accessible
objectGetParent accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_parent accessible'
    checkUnexpectedReturnNULL "objectGetParent" result
    result' <- (newObject Object) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetParentMethodInfo
instance (signature ~ (m Object), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetParentMethodInfo a signature where
    overloadedMethod = objectGetParent

instance O.OverloadedMethodInfo ObjectGetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetParent"
        })


#endif

-- method Object::get_role
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Role" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_get_role" atk_object_get_role :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CUInt

-- | Gets the role of the accessible.
objectGetRole ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Atk.Enums.Role
    -- ^ __Returns:__ an t'GI.Atk.Enums.Role' which is the role of the accessible
objectGetRole accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_get_role accessible'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectGetRoleMethodInfo
instance (signature ~ (m Atk.Enums.Role), MonadIO m, IsObject a) => O.OverloadedMethod ObjectGetRoleMethodInfo a signature where
    overloadedMethod = objectGetRole

instance O.OverloadedMethodInfo ObjectGetRoleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectGetRole",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectGetRole"
        })


#endif

-- method Object::initialize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #gpointer which identifies the object for which the AtkObject was created."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_initialize" atk_object_initialize :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | This function is called when implementing subclasses of t'GI.Atk.Objects.Object.Object'.
-- It does initialization required for the new object. It is intended
-- that this function should called only in the ...@/_new()/@ functions used
-- to create an instance of a subclass of t'GI.Atk.Objects.Object.Object'
objectInitialize ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: a t'GI.Atk.Objects.Object.Object'
    -> Ptr ()
    -- ^ /@data@/: a @/gpointer/@ which identifies the object for which the AtkObject was created.
    -> m ()
objectInitialize accessible data_ = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    atk_object_initialize accessible' data_
    touchManagedPtr accessible
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectInitializeMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectInitializeMethodInfo a signature where
    overloadedMethod = objectInitialize

instance O.OverloadedMethodInfo ObjectInitializeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectInitialize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectInitialize"
        })


#endif

-- method Object::notify_state_change
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkState whose state is changed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a gboolean which indicates whether the state is being set on or off"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_notify_state_change" atk_object_notify_state_change :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    Word64 ->                               -- state : TBasicType TUInt64
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()

-- | Emits a state-change signal for the specified state.
-- 
-- Note that as a general rule when the state of an existing object changes,
-- emitting a notification is expected.
objectNotifyStateChange ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> Word64
    -- ^ /@state@/: an @/AtkState/@ whose state is changed
    -> Bool
    -- ^ /@value@/: a gboolean which indicates whether the state is being set on or off
    -> m ()
objectNotifyStateChange accessible state value = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    let value' = (P.fromIntegral . P.fromEnum) value
    atk_object_notify_state_change accessible' state value'
    touchManagedPtr accessible
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectNotifyStateChangeMethodInfo
instance (signature ~ (Word64 -> Bool -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectNotifyStateChangeMethodInfo a signature where
    overloadedMethod = objectNotifyStateChange

instance O.OverloadedMethodInfo ObjectNotifyStateChangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectNotifyStateChange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectNotifyStateChange"
        })


#endif

-- method Object::peek_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_peek_parent" atk_object_peek_parent :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO (Ptr Object)

-- | Gets the accessible parent of the accessible, if it has been
-- manually assigned with atk_object_set_parent. Otherwise, this
-- function returns 'P.Nothing'.
-- 
-- This method is intended as an utility for ATK implementors, and not
-- to be exposed to accessible tools. See 'GI.Atk.Objects.Object.objectGetParent' for
-- further reference.
objectPeekParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Object
    -- ^ __Returns:__ an t'GI.Atk.Objects.Object.Object' representing the accessible
    -- parent of the accessible if assigned
objectPeekParent accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_peek_parent accessible'
    checkUnexpectedReturnNULL "objectPeekParent" result
    result' <- (newObject Object) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectPeekParentMethodInfo
instance (signature ~ (m Object), MonadIO m, IsObject a) => O.OverloadedMethod ObjectPeekParentMethodInfo a signature where
    overloadedMethod = objectPeekParent

instance O.OverloadedMethodInfo ObjectPeekParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectPeekParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectPeekParent"
        })


#endif

-- method Object::ref_accessible_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a gint representing the position of the child, starting from 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_ref_accessible_child" atk_object_ref_accessible_child :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    Int32 ->                                -- i : TBasicType TInt
    IO (Ptr Object)

-- | Gets a reference to the specified accessible child of the object.
-- The accessible children are 0-based so the first accessible child is
-- at index 0, the second at index 1 and so on.
objectRefAccessibleChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> Int32
    -- ^ /@i@/: a gint representing the position of the child, starting from 0
    -> m Object
    -- ^ __Returns:__ an t'GI.Atk.Objects.Object.Object' representing the specified
    -- accessible child of the accessible.
objectRefAccessibleChild accessible i = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_ref_accessible_child accessible' i
    checkUnexpectedReturnNULL "objectRefAccessibleChild" result
    result' <- (wrapObject Object) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectRefAccessibleChildMethodInfo
instance (signature ~ (Int32 -> m Object), MonadIO m, IsObject a) => O.OverloadedMethod ObjectRefAccessibleChildMethodInfo a signature where
    overloadedMethod = objectRefAccessibleChild

instance O.OverloadedMethodInfo ObjectRefAccessibleChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectRefAccessibleChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectRefAccessibleChild"
        })


#endif

-- method Object::ref_relation_set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "RelationSet" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_ref_relation_set" atk_object_ref_relation_set :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO (Ptr Atk.RelationSet.RelationSet)

-- | Gets the t'GI.Atk.Objects.RelationSet.RelationSet' associated with the object.
objectRefRelationSet ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Atk.RelationSet.RelationSet
    -- ^ __Returns:__ an t'GI.Atk.Objects.RelationSet.RelationSet' representing the relation set
    -- of the object.
objectRefRelationSet accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_ref_relation_set accessible'
    checkUnexpectedReturnNULL "objectRefRelationSet" result
    result' <- (wrapObject Atk.RelationSet.RelationSet) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectRefRelationSetMethodInfo
instance (signature ~ (m Atk.RelationSet.RelationSet), MonadIO m, IsObject a) => O.OverloadedMethod ObjectRefRelationSetMethodInfo a signature where
    overloadedMethod = objectRefRelationSet

instance O.OverloadedMethodInfo ObjectRefRelationSetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectRefRelationSet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectRefRelationSet"
        })


#endif

-- method Object::ref_state_set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "StateSet" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_ref_state_set" atk_object_ref_state_set :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    IO (Ptr Atk.StateSet.StateSet)

-- | Gets a reference to the state set of the accessible; the caller must
-- unreference it when it is no longer needed.
objectRefStateSet ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> m Atk.StateSet.StateSet
    -- ^ __Returns:__ a reference to an t'GI.Atk.Objects.StateSet.StateSet' which is the state
    -- set of the accessible
objectRefStateSet accessible = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    result <- atk_object_ref_state_set accessible'
    checkUnexpectedReturnNULL "objectRefStateSet" result
    result' <- (wrapObject Atk.StateSet.StateSet) result
    touchManagedPtr accessible
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectRefStateSetMethodInfo
instance (signature ~ (m Atk.StateSet.StateSet), MonadIO m, IsObject a) => O.OverloadedMethod ObjectRefStateSetMethodInfo a signature where
    overloadedMethod = objectRefStateSet

instance O.OverloadedMethodInfo ObjectRefStateSetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectRefStateSet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectRefStateSet"
        })


#endif

-- method Object::remove_property_change_handler
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a guint which identifies the handler to be removed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_remove_property_change_handler" atk_object_remove_property_change_handler :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    Word32 ->                               -- handler_id : TBasicType TUInt
    IO ()

{-# DEPRECATED objectRemovePropertyChangeHandler ["(Since version 2.12)","See @/atk_object_connect_property_change_handler()/@"] #-}
-- | Removes a property change handler.
objectRemovePropertyChangeHandler ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> Word32
    -- ^ /@handlerId@/: a guint which identifies the handler to be removed.
    -> m ()
objectRemovePropertyChangeHandler accessible handlerId = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    atk_object_remove_property_change_handler accessible' handlerId
    touchManagedPtr accessible
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectRemovePropertyChangeHandlerMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectRemovePropertyChangeHandlerMethodInfo a signature where
    overloadedMethod = objectRemovePropertyChangeHandler

instance O.OverloadedMethodInfo ObjectRemovePropertyChangeHandlerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectRemovePropertyChangeHandler",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectRemovePropertyChangeHandler"
        })


#endif

-- method Object::remove_relationship
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #AtkObject from which an AtkRelation is to be removed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "relationship"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "RelationType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #AtkRelationType of the relation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The #AtkObject which is the target of the relation to be removed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_remove_relationship" atk_object_remove_relationship :: 
    Ptr Object ->                           -- object : TInterface (Name {namespace = "Atk", name = "Object"})
    CUInt ->                                -- relationship : TInterface (Name {namespace = "Atk", name = "RelationType"})
    Ptr Object ->                           -- target : TInterface (Name {namespace = "Atk", name = "Object"})
    IO CInt

-- | Removes a relationship of the specified type with the specified target.
objectRemoveRelationship ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a, IsObject b) =>
    a
    -- ^ /@object@/: The t'GI.Atk.Objects.Object.Object' from which an AtkRelation is to be removed.
    -> Atk.Enums.RelationType
    -- ^ /@relationship@/: The t'GI.Atk.Enums.RelationType' of the relation
    -> b
    -- ^ /@target@/: The t'GI.Atk.Objects.Object.Object' which is the target of the relation to be removed.
    -> m Bool
    -- ^ __Returns:__ TRUE if the relationship is removed.
objectRemoveRelationship object relationship target = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    let relationship' = (fromIntegral . fromEnum) relationship
    target' <- unsafeManagedPtrCastPtr target
    result <- atk_object_remove_relationship object' relationship' target'
    let result' = (/= 0) result
    touchManagedPtr object
    touchManagedPtr target
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectRemoveRelationshipMethodInfo
instance (signature ~ (Atk.Enums.RelationType -> b -> m Bool), MonadIO m, IsObject a, IsObject b) => O.OverloadedMethod ObjectRemoveRelationshipMethodInfo a signature where
    overloadedMethod = objectRemoveRelationship

instance O.OverloadedMethodInfo ObjectRemoveRelationshipMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectRemoveRelationship",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectRemoveRelationship"
        })


#endif

-- method Object::set_accessible_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a character string to be set as the accessible id"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_set_accessible_id" atk_object_set_accessible_id :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    CString ->                              -- id : TBasicType TUTF8
    IO ()

-- | Sets the accessible ID of the accessible.  This is not meant to be presented
-- to the user, but to be an ID which is stable over application development.
-- Typically, this is the gtkbuilder ID. Such an ID will be available for
-- instance to identify a given well-known accessible object for tailored screen
-- reading, or for automatic regression testing.
-- 
-- /Since: 2.34/
objectSetAccessibleId ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> T.Text
    -- ^ /@id@/: a character string to be set as the accessible id
    -> m ()
objectSetAccessibleId accessible id = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    id' <- textToCString id
    atk_object_set_accessible_id accessible' id'
    touchManagedPtr accessible
    freeMem id'
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectSetAccessibleIdMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectSetAccessibleIdMethodInfo a signature where
    overloadedMethod = objectSetAccessibleId

instance O.OverloadedMethodInfo ObjectSetAccessibleIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectSetAccessibleId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectSetAccessibleId"
        })


#endif

-- method Object::set_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a character string to be set as the accessible description"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_set_description" atk_object_set_description :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    CString ->                              -- description : TBasicType TUTF8
    IO ()

-- | Sets the accessible description of the accessible. You can\'t set
-- the description to NULL. This is reserved for the initial value. In
-- this aspect NULL is similar to ATK_ROLE_UNKNOWN. If you want to set
-- the name to a empty value you can use \"\".
objectSetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> T.Text
    -- ^ /@description@/: a character string to be set as the accessible description
    -> m ()
objectSetDescription accessible description = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    description' <- textToCString description
    atk_object_set_description accessible' description'
    touchManagedPtr accessible
    freeMem description'
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectSetDescriptionMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectSetDescriptionMethodInfo a signature where
    overloadedMethod = objectSetDescription

instance O.OverloadedMethodInfo ObjectSetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectSetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectSetDescription"
        })


#endif

-- method Object::set_help_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "help_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a character string to be set as the accessible's help text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_set_help_text" atk_object_set_help_text :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    CString ->                              -- help_text : TBasicType TUTF8
    IO ()

-- | Sets the help text associated with the accessible. This can be used to
-- expose context-sensitive information to help a user understand how to
-- interact with the object. You can\'t set the help text to NULL.
-- This is reserved for the initial value. If you want to set the name to
-- an empty value, you can use \"\".
-- 
-- /Since: 2.52/
objectSetHelpText ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> T.Text
    -- ^ /@helpText@/: a character string to be set as the accessible\'s help text
    -> m ()
objectSetHelpText accessible helpText = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    helpText' <- textToCString helpText
    atk_object_set_help_text accessible' helpText'
    touchManagedPtr accessible
    freeMem helpText'
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectSetHelpTextMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectSetHelpTextMethodInfo a signature where
    overloadedMethod = objectSetHelpText

instance O.OverloadedMethodInfo ObjectSetHelpTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectSetHelpText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectSetHelpText"
        })


#endif

-- method Object::set_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a character string to be set as the accessible name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_set_name" atk_object_set_name :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets the accessible name of the accessible. You can\'t set the name
-- to NULL. This is reserved for the initial value. In this aspect
-- NULL is similar to ATK_ROLE_UNKNOWN. If you want to set the name to
-- a empty value you can use \"\".
objectSetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> T.Text
    -- ^ /@name@/: a character string to be set as the accessible name
    -> m ()
objectSetName accessible name = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    name' <- textToCString name
    atk_object_set_name accessible' name'
    touchManagedPtr accessible
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectSetNameMethodInfo a signature where
    overloadedMethod = objectSetName

instance O.OverloadedMethodInfo ObjectSetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectSetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectSetName"
        })


#endif

-- method Object::set_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "an #AtkObject to be set as the accessible parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_set_parent" atk_object_set_parent :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    Ptr Object ->                           -- parent : TInterface (Name {namespace = "Atk", name = "Object"})
    IO ()

-- | Sets the accessible parent of the accessible. /@parent@/ can be NULL.
objectSetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a, IsObject b) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> b
    -- ^ /@parent@/: an t'GI.Atk.Objects.Object.Object' to be set as the accessible parent
    -> m ()
objectSetParent accessible parent = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    parent' <- unsafeManagedPtrCastPtr parent
    atk_object_set_parent accessible' parent'
    touchManagedPtr accessible
    touchManagedPtr parent
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectSetParentMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsObject a, IsObject b) => O.OverloadedMethod ObjectSetParentMethodInfo a signature where
    overloadedMethod = objectSetParent

instance O.OverloadedMethodInfo ObjectSetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectSetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectSetParent"
        })


#endif

-- method Object::set_role
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "role"
--           , argType = TInterface Name { namespace = "Atk" , name = "Role" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkRole to be set as the role"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_object_set_role" atk_object_set_role :: 
    Ptr Object ->                           -- accessible : TInterface (Name {namespace = "Atk", name = "Object"})
    CUInt ->                                -- role : TInterface (Name {namespace = "Atk", name = "Role"})
    IO ()

-- | Sets the role of the accessible.
objectSetRole ::
    (B.CallStack.HasCallStack, MonadIO m, IsObject a) =>
    a
    -- ^ /@accessible@/: an t'GI.Atk.Objects.Object.Object'
    -> Atk.Enums.Role
    -- ^ /@role@/: an t'GI.Atk.Enums.Role' to be set as the role
    -> m ()
objectSetRole accessible role = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    let role' = (fromIntegral . fromEnum) role
    atk_object_set_role accessible' role'
    touchManagedPtr accessible
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectSetRoleMethodInfo
instance (signature ~ (Atk.Enums.Role -> m ()), MonadIO m, IsObject a) => O.OverloadedMethod ObjectSetRoleMethodInfo a signature where
    overloadedMethod = objectSetRole

instance O.OverloadedMethodInfo ObjectSetRoleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Object.objectSetRole",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Objects-Object.html#v:objectSetRole"
        })


#endif


