/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_correlate_access_code_bb = R"doc(Examine input for specified access code, one bit at a time.

input: stream of bits, 1 bit per input byte (data in LSB) output: stream of bits, 2 bits per output byte (data in LSB, flag in next higher bit)


Each output byte contains two valid bits, the data bit, and the flag bit. The LSB (bit 0) is the data bit, and is the original input data, delayed 64 bits. Bit 1 is the flag bit and is 1 if the corresponding data bit is the first data bit following the access code. Otherwise the flag bit is 0.

Constructor Specific Documentation:

Make a correlate_access_code block.

Args:
    access_code : is represented with 1 byte per bit, e.g., \"010101010111000100\"
    threshold : maximum number of bits that may be wrong)doc";


static const char* __doc_gr_digital_correlate_access_code_bb_correlate_access_code_bb_0 =
    R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_bb_correlate_access_code_bb_1 =
    R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_bb_make = R"doc(Examine input for specified access code, one bit at a time.

input: stream of bits, 1 bit per input byte (data in LSB) output: stream of bits, 2 bits per output byte (data in LSB, flag in next higher bit)


Each output byte contains two valid bits, the data bit, and the flag bit. The LSB (bit 0) is the data bit, and is the original input data, delayed 64 bits. Bit 1 is the flag bit and is 1 if the corresponding data bit is the first data bit following the access code. Otherwise the flag bit is 0.

Constructor Specific Documentation:

Make a correlate_access_code block.

Args:
    access_code : is represented with 1 byte per bit, e.g., \"010101010111000100\"
    threshold : maximum number of bits that may be wrong)doc";


static const char* __doc_gr_digital_correlate_access_code_bb_set_access_code =
    R"doc()doc";
