/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_message_debug = R"doc(Debug block for the message passing system.

The message debug block is used to capture and print or store messages as they are received. Any block that generates a message may connect that message port to one or more of the two message input ports of this debug block. The message ports are:

Constructor Specific Documentation:

Build the message debug block. It takes a single parameter that can be used to disable PDU vector printing and has two message ports: print and store.

Args:
    en_uvec : Enable PDU Vector Printing.
    log_level : The log level of the  port. Defaults to \"info\".)doc";


static const char* __doc_gr_blocks_message_debug_message_debug_0 = R"doc()doc";


static const char* __doc_gr_blocks_message_debug_message_debug_1 = R"doc()doc";


static const char* __doc_gr_blocks_message_debug_make = R"doc(Debug block for the message passing system.

The message debug block is used to capture and print or store messages as they are received. Any block that generates a message may connect that message port to one or more of the two message input ports of this debug block. The message ports are:

Constructor Specific Documentation:

Build the message debug block. It takes a single parameter that can be used to disable PDU vector printing and has two message ports: print and store.

Args:
    en_uvec : Enable PDU Vector Printing.
    log_level : The log level of the  port. Defaults to \"info\".)doc";


static const char* __doc_gr_blocks_message_debug_num_messages = R"doc(Reports the number of messages received by this block.)doc";


static const char* __doc_gr_blocks_message_debug_get_message = R"doc(Get a message (as a PMT) from the message vector at index .

Messages passed to the 'store' port will be stored in a vector. This function retrieves those messages by index. They are index in order of when they were received (all messages are just pushed onto the back of a vector). This is mostly useful in debugging message passing graphs and in QA code.)doc";


static const char* __doc_gr_blocks_message_debug_set_vector_print = R"doc(Enables or disables printing of PDU uniform vector data.)doc";
