/* theme-synesthesia.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from theme-synesthesia.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define PUZZLE_VIEW_gap_factor 0.5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ThemePrivate ThemePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;

#define TYPE_SYNESTHESIA_THEME (synesthesia_theme_get_type ())
#define SYNESTHESIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYNESTHESIA_THEME, SynesthesiaTheme))
#define SYNESTHESIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYNESTHESIA_THEME, SynesthesiaThemeClass))
#define IS_SYNESTHESIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYNESTHESIA_THEME))
#define IS_SYNESTHESIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYNESTHESIA_THEME))
#define SYNESTHESIA_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYNESTHESIA_THEME, SynesthesiaThemeClass))

typedef struct _SynesthesiaTheme SynesthesiaTheme;
typedef struct _SynesthesiaThemeClass SynesthesiaThemeClass;
typedef struct _SynesthesiaThemePrivate SynesthesiaThemePrivate;
enum  {
	SYNESTHESIA_THEME_0_PROPERTY,
	SYNESTHESIA_THEME_NUM_PROPERTIES
};
static GParamSpec* synesthesia_theme_properties[SYNESTHESIA_THEME_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _TilePrivate TilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
};

struct _ThemeClass {
	GObjectClass parent_class;
	void (*configure) (Theme* self, guint size);
	void (*draw_arrow) (Theme* self, cairo_t* context);
	void (*draw_socket) (Theme* self, cairo_t* context);
	void (*draw_highlight) (Theme* self, cairo_t* context, gboolean has_tile);
	void (*draw_paused_tile) (Theme* self, cairo_t* context);
	void (*draw_tile) (Theme* self, cairo_t* context, Tile* tile, gboolean highlight);
	void (*set_animation_level) (Theme* self, guint8 animation_level);
};

struct _SynesthesiaTheme {
	Theme parent_instance;
	SynesthesiaThemePrivate * priv;
};

struct _SynesthesiaThemeClass {
	ThemeClass parent_class;
};

struct _SynesthesiaThemePrivate {
	cairo_pattern_t* text_colors[10];
	cairo_pattern_t* paused_color;
	cairo_pattern_t* tile_color;
	cairo_pattern_t* highlight_color;
	guint size;
	guint8 animation_level;
	gdouble arrow_half_h;
	gdouble neg_arrow_half_h;
	gdouble arrow_w;
	gdouble arrow_x;
	guint tile_depth;
	gdouble size_minus_tile_depth;
	gdouble size_minus_two_tile_depths;
	cairo_pattern_t* socket_pattern;
	cairo_matrix_t matrix;
	cairo_pattern_t* highlight_tile_pattern;
	guint tile_margin;
	gint tile_size;
	gdouble half_size;
	gdouble half_tile_size;
	gdouble font_size;
	gdouble north_number_y;
	gdouble south_number_y;
	gdouble east_number_x;
	gdouble west_number_x;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	guint8 north;
	guint8 west;
	guint8 east;
	guint8 south;
};

struct _TileClass {
	GObjectClass parent_class;
};

static gint SynesthesiaTheme_private_offset;
static gpointer synesthesia_theme_parent_class = NULL;

VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType synesthesia_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynesthesiaTheme, g_object_unref)
VALA_EXTERN void theme_configure (Theme* self,
                      guint size);
VALA_EXTERN void theme_set_animation_level (Theme* self,
                                guint8 animation_level);
VALA_EXTERN void theme_draw_arrow (Theme* self,
                       cairo_t* context);
VALA_EXTERN void theme_draw_socket (Theme* self,
                        cairo_t* context);
VALA_EXTERN void theme_draw_highlight (Theme* self,
                           cairo_t* context,
                           gboolean has_tile);
VALA_EXTERN void theme_draw_paused_tile (Theme* self,
                             cairo_t* context);
VALA_EXTERN void theme_draw_tile (Theme* self,
                      cairo_t* context,
                      Tile* tile,
                      gboolean highlight);
static cairo_pattern_t* synesthesia_theme_make_color_pattern (const gchar* color,
                                                       gboolean transparency);
static gdouble synesthesia_theme_hex_value (gchar c);
static void synesthesia_theme_real_configure (Theme* base,
                                       guint new_size);
static void synesthesia_theme_init_socket_pattern (SynesthesiaTheme* self);
static void synesthesia_theme_real_set_animation_level (Theme* base,
                                                 guint8 new_animation_level);
static void synesthesia_theme_real_draw_arrow (Theme* base,
                                        cairo_t* context);
static void synesthesia_theme_real_draw_socket (Theme* base,
                                         cairo_t* context);
static void synesthesia_theme_real_draw_highlight (Theme* base,
                                            cairo_t* context,
                                            gboolean has_tile);
static void synesthesia_theme_real_draw_paused_tile (Theme* base,
                                              cairo_t* context);
static void synesthesia_theme_draw_tile_background (SynesthesiaTheme* self,
                                             cairo_t* context,
                                             cairo_pattern_t* pattern);
static void synesthesia_theme_real_draw_tile (Theme* base,
                                       cairo_t* context,
                                       Tile* tile,
                                       gboolean highlight);
static void synesthesia_theme_draw_number (cairo_t* context,
                                    cairo_pattern_t* text_color,
                                    gdouble x,
                                    gdouble y,
                                    guint8 number);
VALA_EXTERN SynesthesiaTheme* synesthesia_theme_new (void);
VALA_EXTERN SynesthesiaTheme* synesthesia_theme_construct (GType object_type);
VALA_EXTERN Theme* theme_construct (GType object_type);
static GObject * synesthesia_theme_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void synesthesia_theme_finalize (GObject * obj);
static GType synesthesia_theme_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synesthesia_theme_get_instance_private (SynesthesiaTheme* self)
{
	return G_STRUCT_MEMBER_P (self, SynesthesiaTheme_private_offset);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static cairo_pattern_t*
synesthesia_theme_make_color_pattern (const gchar* color,
                                      gboolean transparency)
{
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	gdouble _tmp0_ = 0.0;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* result;
	g_return_val_if_fail (color != NULL, NULL);
	r = ((synesthesia_theme_hex_value (string_get (color, (glong) 0)) * 16) + synesthesia_theme_hex_value (string_get (color, (glong) 1))) / 255.0;
	g = ((synesthesia_theme_hex_value (string_get (color, (glong) 2)) * 16) + synesthesia_theme_hex_value (string_get (color, (glong) 3))) / 255.0;
	b = ((synesthesia_theme_hex_value (string_get (color, (glong) 4)) * 16) + synesthesia_theme_hex_value (string_get (color, (glong) 5))) / 255.0;
	if (transparency) {
		_tmp0_ = 0.6;
	} else {
		_tmp0_ = 1.0;
	}
	_tmp1_ = cairo_pattern_create_rgba (r, g, b, _tmp0_);
	result = _tmp1_;
	return result;
}

static gdouble
synesthesia_theme_hex_value (gchar c)
{
	gboolean _tmp0_ = FALSE;
	gdouble result;
	if (c >= '0') {
		_tmp0_ = c <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gdouble) (c - '0');
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (c >= 'a') {
			_tmp1_ = c <= 'f';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = (gdouble) ((c - 'a') + 10);
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (c >= 'A') {
				_tmp2_ = c <= 'F';
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = (gdouble) ((c - 'A') + 10);
				return result;
			} else {
				result = (gdouble) 0;
				return result;
			}
		}
	}
}

static void
synesthesia_theme_real_configure (Theme* base,
                                  guint new_size)
{
	SynesthesiaTheme * self;
	gboolean _tmp0_ = FALSE;
	gdouble highlight_radius = 0.0;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	self = (SynesthesiaTheme*) base;
	if (self->priv->size != ((guint) 0)) {
		_tmp0_ = self->priv->size == new_size;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->arrow_w = (new_size * PUZZLE_VIEW_gap_factor) * 0.5;
	self->priv->arrow_x = ((new_size * PUZZLE_VIEW_gap_factor) - self->priv->arrow_w) * 0.5;
	self->priv->arrow_half_h = self->priv->arrow_w / sqrt (3.0);
	self->priv->neg_arrow_half_h = -self->priv->arrow_half_h;
	cairo_matrix_init_identity (&self->priv->matrix);
	cairo_matrix_scale (&self->priv->matrix, 1.0 / new_size, 1.0 / new_size);
	self->priv->tile_depth = MIN ((guint) (new_size * 0.05), (guint) 4);
	self->priv->size_minus_tile_depth = ((gdouble) new_size) - self->priv->tile_depth;
	self->priv->size_minus_two_tile_depths = (gdouble) (new_size - (self->priv->tile_depth * 2));
	synesthesia_theme_init_socket_pattern (self);
	self->priv->half_size = new_size * 0.5;
	highlight_radius = new_size * 0.45;
	_tmp1_ = cairo_pattern_create_radial (self->priv->half_size, self->priv->half_size, 0.0, self->priv->half_size, self->priv->half_size, highlight_radius);
	_cairo_pattern_destroy0 (self->priv->highlight_tile_pattern);
	self->priv->highlight_tile_pattern = _tmp1_;
	_tmp2_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp2_, 0.0, 1.0, 1.0, 1.0, 1.0);
	_tmp3_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp3_, 0.2, 1.0, 1.0, 1.0, 0.8);
	_tmp4_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp4_, 0.3, 1.0, 1.0, 1.0, 0.5);
	_tmp5_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp5_, 0.4, 1.0, 1.0, 1.0, 0.2);
	_tmp6_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp6_, 0.5, 1.0, 1.0, 1.0, 0.1);
	_tmp7_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp7_, 1.0, 1.0, 1.0, 1.0, 0.0);
	self->priv->tile_margin = MIN ((guint) (new_size * 0.05), (guint) 2) - 1;
	self->priv->tile_size = ((gint) new_size) - (((gint) self->priv->tile_margin) * 2);
	self->priv->half_tile_size = self->priv->tile_size * 0.5;
	self->priv->font_size = (new_size * 4.0) / 19.0;
	self->priv->north_number_y = (new_size * 4.0) / 18.0;
	self->priv->south_number_y = (new_size * 14.0) / 18.0;
	self->priv->east_number_x = (new_size * 15.0) / 19.0;
	self->priv->west_number_x = (new_size * 4.0) / 19.0;
	self->priv->size = new_size;
}

static void
synesthesia_theme_real_set_animation_level (Theme* base,
                                            guint8 new_animation_level)
{
	SynesthesiaTheme * self;
	self = (SynesthesiaTheme*) base;
	self->priv->animation_level = new_animation_level;
	synesthesia_theme_init_socket_pattern (self);
}

static void
synesthesia_theme_init_socket_pattern (SynesthesiaTheme* self)
{
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_matrix_t _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cairo_pattern_create_mesh ();
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	self->priv->socket_pattern = _tmp0_;
	_tmp1_ = self->priv->socket_pattern;
	cairo_mesh_pattern_begin_patch (_tmp1_);
	_tmp2_ = self->priv->socket_pattern;
	cairo_mesh_pattern_move_to (_tmp2_, 0.5, 0.0);
	_tmp3_ = self->priv->socket_pattern;
	cairo_mesh_pattern_line_to (_tmp3_, 1.0, 0.5);
	_tmp4_ = self->priv->socket_pattern;
	cairo_mesh_pattern_line_to (_tmp4_, 0.5, 1.0);
	_tmp5_ = self->priv->socket_pattern;
	cairo_mesh_pattern_line_to (_tmp5_, 0.0, 0.5);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_pattern_t* _tmp6_;
		cairo_pattern_t* _tmp7_;
		cairo_pattern_t* _tmp8_;
		cairo_pattern_t* _tmp9_;
		_tmp6_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp6_, (guint) 0, 0.45, 0.45, 0.45, 0.5);
		_tmp7_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp7_, (guint) 1, 0.6, 0.6, 0.6, 0.5);
		_tmp8_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp8_, (guint) 2, 0.7, 0.7, 0.7, 0.5);
		_tmp9_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp9_, (guint) 3, 0.55, 0.55, 0.55, 0.5);
	} else {
		cairo_pattern_t* _tmp10_;
		cairo_pattern_t* _tmp11_;
		cairo_pattern_t* _tmp12_;
		cairo_pattern_t* _tmp13_;
		_tmp10_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp10_, (guint) 0, 0.45, 0.45, 0.45, (0.5 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
		_tmp11_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp11_, (guint) 1, 0.6, 0.6, 0.6, (0.5 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
		_tmp12_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp12_, (guint) 2, 0.7, 0.7, 0.7, (0.5 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
		_tmp13_ = self->priv->socket_pattern;
		cairo_mesh_pattern_set_corner_color_rgba (_tmp13_, (guint) 3, 0.55, 0.55, 0.55, (0.5 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	_tmp14_ = self->priv->socket_pattern;
	cairo_mesh_pattern_end_patch (_tmp14_);
	_tmp15_ = self->priv->socket_pattern;
	_tmp16_ = self->priv->matrix;
	cairo_pattern_set_matrix (_tmp15_, &_tmp16_);
}

static void
synesthesia_theme_real_draw_arrow (Theme* base,
                                   cairo_t* context)
{
	SynesthesiaTheme * self;
	self = (SynesthesiaTheme*) base;
	g_return_if_fail (context != NULL);
	cairo_translate (context, self->priv->arrow_x, 0.0);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_line_to (context, self->priv->arrow_w, self->priv->neg_arrow_half_h);
	cairo_close_path (context);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.5, 0.5, 0.6, 0.4);
	} else {
		cairo_set_source_rgba (context, 0.5, 0.5, 0.6, (0.4 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
}

static void
synesthesia_theme_real_draw_socket (Theme* base,
                                    cairo_t* context)
{
	SynesthesiaTheme * self;
	cairo_pattern_t* _tmp0_;
	self = (SynesthesiaTheme*) base;
	g_return_if_fail (context != NULL);
	cairo_save (context);
	cairo_translate (context, (gdouble) self->priv->tile_margin, (gdouble) self->priv->tile_margin);
	_tmp0_ = self->priv->socket_pattern;
	cairo_set_source (context, _tmp0_);
	cairo_move_to (context, self->priv->half_tile_size, 0.0);
	cairo_line_to (context, (gdouble) self->priv->tile_size, self->priv->half_tile_size);
	cairo_line_to (context, self->priv->half_tile_size, (gdouble) self->priv->tile_size);
	cairo_line_to (context, 0.0, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_fill_preserve (context);
	cairo_set_line_width (context, 1.0);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.4, 0.4, 0.4, 0.3);
	} else {
		cairo_set_source_rgba (context, 0.4, 0.4, 0.4, (0.3 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_stroke (context);
	cairo_restore (context);
}

static void
synesthesia_theme_real_draw_highlight (Theme* base,
                                       cairo_t* context,
                                       gboolean has_tile)
{
	SynesthesiaTheme * self;
	cairo_pattern_t* _tmp0_;
	self = (SynesthesiaTheme*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->highlight_tile_pattern;
	cairo_set_source (context, _tmp0_);
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_fill (context);
}

static void
synesthesia_theme_real_draw_paused_tile (Theme* base,
                                         cairo_t* context)
{
	SynesthesiaTheme * self;
	cairo_pattern_t* _tmp0_;
	self = (SynesthesiaTheme*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->paused_color;
	synesthesia_theme_draw_tile_background (self, context, _tmp0_);
}

static void
synesthesia_theme_real_draw_tile (Theme* base,
                                  cairo_t* context,
                                  Tile* tile,
                                  gboolean highlight)
{
	SynesthesiaTheme * self;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	self = (SynesthesiaTheme*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (tile != NULL);
	if (highlight) {
		cairo_pattern_t* _tmp0_;
		_tmp0_ = self->priv->highlight_color;
		synesthesia_theme_draw_tile_background (self, context, _tmp0_);
	} else {
		cairo_pattern_t* _tmp1_;
		_tmp1_ = self->priv->tile_color;
		synesthesia_theme_draw_tile_background (self, context, _tmp1_);
	}
	cairo_select_font_face (context, "Cantarell", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (context, self->priv->font_size);
	_tmp2_ = self->priv->text_colors[tile->north];
	synesthesia_theme_draw_number (context, _tmp2_, self->priv->half_size, self->priv->north_number_y, tile->north);
	_tmp3_ = self->priv->text_colors[tile->south];
	synesthesia_theme_draw_number (context, _tmp3_, self->priv->half_size, self->priv->south_number_y, tile->south);
	_tmp4_ = self->priv->text_colors[tile->east];
	synesthesia_theme_draw_number (context, _tmp4_, self->priv->east_number_x, self->priv->half_size, tile->east);
	_tmp5_ = self->priv->text_colors[tile->west];
	synesthesia_theme_draw_number (context, _tmp5_, self->priv->west_number_x, self->priv->half_size, tile->west);
}

static void
synesthesia_theme_draw_tile_background (SynesthesiaTheme* self,
                                        cairo_t* context,
                                        cairo_pattern_t* pattern)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (pattern != NULL);
	cairo_save (context);
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_clip (context);
	cairo_translate (context, (gdouble) self->priv->tile_margin, (gdouble) self->priv->tile_margin);
	cairo_set_source (context, pattern);
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->tile_size, (gdouble) self->priv->tile_size);
	cairo_fill_preserve (context);
	cairo_set_line_width (context, 1.0);
	cairo_set_source_rgba (context, 0.5, 0.5, 0.6, 0.4);
	cairo_stroke (context);
	cairo_restore (context);
}

static void
synesthesia_theme_draw_number (cairo_t* context,
                               cairo_pattern_t* text_color,
                               gdouble x,
                               gdouble y,
                               guint8 number)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp1_ = {0};
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (text_color != NULL);
	cairo_set_source (context, text_color);
	_tmp0_ = g_strdup_printf ("%hu", (gushort) number);
	text = _tmp0_;
	cairo_text_extents (context, text, &_tmp1_);
	extents = _tmp1_;
	_tmp2_ = extents;
	_tmp3_ = extents;
	cairo_move_to (context, x - (_tmp2_.width / 2.0), y + (_tmp3_.height / 2.0));
	cairo_show_text (context, text);
	_g_free0 (text);
}

SynesthesiaTheme*
synesthesia_theme_construct (GType object_type)
{
	SynesthesiaTheme * self = NULL;
	self = (SynesthesiaTheme*) theme_construct (object_type);
	return self;
}

SynesthesiaTheme*
synesthesia_theme_new (void)
{
	return synesthesia_theme_construct (TYPE_SYNESTHESIA_THEME);
}

static GObject *
synesthesia_theme_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynesthesiaTheme * self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_pattern_t* _tmp12_;
	parent_class = G_OBJECT_CLASS (synesthesia_theme_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYNESTHESIA_THEME, SynesthesiaTheme);
	_tmp0_ = synesthesia_theme_make_color_pattern ("3d3846", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[0]);
	self->priv->text_colors[0] = _tmp0_;
	_tmp1_ = synesthesia_theme_make_color_pattern ("E01B24", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[1]);
	self->priv->text_colors[1] = _tmp1_;
	_tmp2_ = synesthesia_theme_make_color_pattern ("FF7800", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[2]);
	self->priv->text_colors[2] = _tmp2_;
	_tmp3_ = synesthesia_theme_make_color_pattern ("F8E45C", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[3]);
	self->priv->text_colors[3] = _tmp3_;
	_tmp4_ = synesthesia_theme_make_color_pattern ("57E389", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[4]);
	self->priv->text_colors[4] = _tmp4_;
	_tmp5_ = synesthesia_theme_make_color_pattern ("865E3C", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[5]);
	self->priv->text_colors[5] = _tmp5_;
	_tmp6_ = synesthesia_theme_make_color_pattern ("1CD5D8", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[6]);
	self->priv->text_colors[6] = _tmp6_;
	_tmp7_ = synesthesia_theme_make_color_pattern ("1a5fb4", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[7]);
	self->priv->text_colors[7] = _tmp7_;
	_tmp8_ = synesthesia_theme_make_color_pattern ("9141AC", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[8]);
	self->priv->text_colors[8] = _tmp8_;
	_tmp9_ = synesthesia_theme_make_color_pattern ("f6f5f4", FALSE);
	_cairo_pattern_destroy0 (self->priv->text_colors[9]);
	self->priv->text_colors[9] = _tmp9_;
	_tmp10_ = synesthesia_theme_make_color_pattern ("CCCCCC", FALSE);
	_cairo_pattern_destroy0 (self->priv->paused_color);
	self->priv->paused_color = _tmp10_;
	_tmp11_ = synesthesia_theme_make_color_pattern ("CDCADA", TRUE);
	_cairo_pattern_destroy0 (self->priv->tile_color);
	self->priv->tile_color = _tmp11_;
	_tmp12_ = synesthesia_theme_make_color_pattern ("DACACD", TRUE);
	_cairo_pattern_destroy0 (self->priv->highlight_color);
	self->priv->highlight_color = _tmp12_;
	return obj;
}

static void
synesthesia_theme_class_init (SynesthesiaThemeClass * klass,
                              gpointer klass_data)
{
	synesthesia_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynesthesiaTheme_private_offset);
	((ThemeClass *) klass)->configure = (void (*) (Theme*, guint)) synesthesia_theme_real_configure;
	((ThemeClass *) klass)->set_animation_level = (void (*) (Theme*, guint8)) synesthesia_theme_real_set_animation_level;
	((ThemeClass *) klass)->draw_arrow = (void (*) (Theme*, cairo_t*)) synesthesia_theme_real_draw_arrow;
	((ThemeClass *) klass)->draw_socket = (void (*) (Theme*, cairo_t*)) synesthesia_theme_real_draw_socket;
	((ThemeClass *) klass)->draw_highlight = (void (*) (Theme*, cairo_t*, gboolean)) synesthesia_theme_real_draw_highlight;
	((ThemeClass *) klass)->draw_paused_tile = (void (*) (Theme*, cairo_t*)) synesthesia_theme_real_draw_paused_tile;
	((ThemeClass *) klass)->draw_tile = (void (*) (Theme*, cairo_t*, Tile*, gboolean)) synesthesia_theme_real_draw_tile;
	G_OBJECT_CLASS (klass)->constructor = synesthesia_theme_constructor;
	G_OBJECT_CLASS (klass)->finalize = synesthesia_theme_finalize;
}

static void
synesthesia_theme_instance_init (SynesthesiaTheme * self,
                                 gpointer klass)
{
	self->priv = synesthesia_theme_get_instance_private (self);
	self->priv->size = (guint) 0;
	self->priv->animation_level = (guint8) 0;
}

static void
synesthesia_theme_finalize (GObject * obj)
{
	SynesthesiaTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYNESTHESIA_THEME, SynesthesiaTheme);
	_vala_array_destroy (self->priv->text_colors, 10, (GDestroyNotify) cairo_pattern_destroy);
	_cairo_pattern_destroy0 (self->priv->paused_color);
	_cairo_pattern_destroy0 (self->priv->tile_color);
	_cairo_pattern_destroy0 (self->priv->highlight_color);
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	_cairo_pattern_destroy0 (self->priv->highlight_tile_pattern);
	G_OBJECT_CLASS (synesthesia_theme_parent_class)->finalize (obj);
}

static GType
synesthesia_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynesthesiaThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synesthesia_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynesthesiaTheme), 0, (GInstanceInitFunc) synesthesia_theme_instance_init, NULL };
	GType synesthesia_theme_type_id;
	synesthesia_theme_type_id = g_type_register_static (TYPE_THEME, "SynesthesiaTheme", &g_define_type_info, 0);
	SynesthesiaTheme_private_offset = g_type_add_instance_private (synesthesia_theme_type_id, sizeof (SynesthesiaThemePrivate));
	return synesthesia_theme_type_id;
}

GType
synesthesia_theme_get_type (void)
{
	static volatile gsize synesthesia_theme_type_id__once = 0;
	if (g_once_init_enter (&synesthesia_theme_type_id__once)) {
		GType synesthesia_theme_type_id;
		synesthesia_theme_type_id = synesthesia_theme_get_type_once ();
		g_once_init_leave (&synesthesia_theme_type_id__once, synesthesia_theme_type_id);
	}
	return synesthesia_theme_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

