/* application-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-window.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <libmanette.h>
#include <gio/gio.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"

#define GAMES_APPLICATION_WINDOW_WINDOW_SIZE_UPDATE_DELAY_MILLISECONDS ((guint) 500)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_APPLICATION_WINDOW (games_application_window_get_type ())
#define GAMES_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow))
#define GAMES_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindowClass))
#define GAMES_IS_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_APPLICATION_WINDOW))
#define GAMES_IS_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_APPLICATION_WINDOW))
#define GAMES_APPLICATION_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindowClass))

typedef struct _GamesApplicationWindow GamesApplicationWindow;
typedef struct _GamesApplicationWindowClass GamesApplicationWindowClass;
typedef struct _GamesApplicationWindowPrivate GamesApplicationWindowPrivate;

#define GAMES_TYPE_COLLECTION_VIEW (games_collection_view_get_type ())
#define GAMES_COLLECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION_VIEW, GamesCollectionView))
#define GAMES_COLLECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_COLLECTION_VIEW, GamesCollectionViewClass))
#define GAMES_IS_COLLECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION_VIEW))
#define GAMES_IS_COLLECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_COLLECTION_VIEW))
#define GAMES_COLLECTION_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_COLLECTION_VIEW, GamesCollectionViewClass))

typedef struct _GamesCollectionView GamesCollectionView;
typedef struct _GamesCollectionViewClass GamesCollectionViewClass;

#define GAMES_TYPE_DISPLAY_VIEW (games_display_view_get_type ())
#define GAMES_DISPLAY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DISPLAY_VIEW, GamesDisplayView))
#define GAMES_DISPLAY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DISPLAY_VIEW, GamesDisplayViewClass))
#define GAMES_IS_DISPLAY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DISPLAY_VIEW))
#define GAMES_IS_DISPLAY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DISPLAY_VIEW))
#define GAMES_DISPLAY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DISPLAY_VIEW, GamesDisplayViewClass))

typedef struct _GamesDisplayView GamesDisplayView;
typedef struct _GamesDisplayViewClass GamesDisplayViewClass;

#define GAMES_TYPE_UI_VIEW (games_ui_view_get_type ())
#define GAMES_UI_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_UI_VIEW, GamesUiView))
#define GAMES_IS_UI_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_UI_VIEW))
#define GAMES_UI_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_UI_VIEW, GamesUiViewIface))

typedef struct _GamesUiView GamesUiView;
typedef struct _GamesUiViewIface GamesUiViewIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;

#define GAMES_TYPE_COLLECTION_MODEL (games_collection_model_get_type ())
#define GAMES_COLLECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION_MODEL, GamesCollectionModel))
#define GAMES_COLLECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_COLLECTION_MODEL, GamesCollectionModelClass))
#define GAMES_IS_COLLECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION_MODEL))
#define GAMES_IS_COLLECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_COLLECTION_MODEL))
#define GAMES_COLLECTION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_COLLECTION_MODEL, GamesCollectionModelClass))

typedef struct _GamesCollectionModel GamesCollectionModel;
typedef struct _GamesCollectionModelClass GamesCollectionModelClass;
enum  {
	GAMES_APPLICATION_WINDOW_0_PROPERTY,
	GAMES_APPLICATION_WINDOW_CURRENT_VIEW_PROPERTY,
	GAMES_APPLICATION_WINDOW_IS_FULLSCREEN_PROPERTY,
	GAMES_APPLICATION_WINDOW_LOADING_NOTIFICATION_PROPERTY,
	GAMES_APPLICATION_WINDOW_GAME_MODEL_PROPERTY,
	GAMES_APPLICATION_WINDOW_COLLECTION_MODEL_PROPERTY,
	GAMES_APPLICATION_WINDOW_NUM_PROPERTIES
};
static GParamSpec* games_application_window_properties[GAMES_APPLICATION_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamesApplicationWindowRunGameData GamesApplicationWindowRunGameData;
typedef struct _GamesApplicationWindowQuitGameData GamesApplicationWindowQuitGameData;
#define __vala_GdkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRectangle_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesApplicationWindow {
	HdyApplicationWindow parent_instance;
	GamesApplicationWindowPrivate * priv;
};

struct _GamesApplicationWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _GamesUiViewIface {
	GTypeInterface parent_iface;
	gboolean (*on_button_pressed) (GamesUiView* self, GdkEventButton* event);
	gboolean (*on_key_pressed) (GamesUiView* self, GdkEventKey* event);
	gboolean (*gamepad_button_press_event) (GamesUiView* self, ManetteEvent* event);
	gboolean (*gamepad_button_release_event) (GamesUiView* self, ManetteEvent* event);
	gboolean (*gamepad_absolute_axis_event) (GamesUiView* self, ManetteEvent* event);
	gboolean (*get_is_view_active) (GamesUiView* self);
	void (*set_is_view_active) (GamesUiView* self, gboolean value);
};

struct _GamesApplicationWindowPrivate {
	GtkStack* stack;
	GamesCollectionView* collection_view;
	GamesDisplayView* display_view;
	GamesUiView* _current_view;
	gboolean _is_fullscreen;
	gboolean _loading_notification;
	GSettings* settings;
	glong window_size_update_timeout;
	guint inhibit_cookie;
	GtkApplicationInhibitFlags inhibit_flags;
	GamesGameModel* _game_model;
	GamesCollectionModel* _collection_model;
	gboolean confirm_exit;
};

struct _Block24Data {
	int _ref_count_;
	GamesApplicationWindow* self;
	GtkShortcutsShortcut* shortcut;
};

struct _GamesApplicationWindowRunGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesApplicationWindow* self;
	GamesGame* game;
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	GamesCollectionView* _tmp2_;
	GamesDisplayView* _tmp3_;
	GamesDisplayView* _tmp4_;
};

struct _GamesApplicationWindowQuitGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesApplicationWindow* self;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GamesDisplayView* _tmp2_;
};

static gint GamesApplicationWindow_private_offset;
static gpointer games_application_window_parent_class = NULL;

VALA_EXTERN GType games_application_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_display_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_ui_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesApplicationWindow* games_application_window_new (GamesApplication* application,
                                                      GamesGameModel* game_model,
                                                      GamesCollectionModel* collection_model);
VALA_EXTERN GamesApplicationWindow* games_application_window_construct (GType object_type,
                                                            GamesApplication* application,
                                                            GamesGameModel* game_model,
                                                            GamesCollectionModel* collection_model);
VALA_EXTERN void games_application_window_set_current_view (GamesApplicationWindow* self,
                                                GamesUiView* value);
static void games_application_window_init_help_overlay (GamesApplicationWindow* self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void __lambda63_ (Block24Data* _data24_);
static gchar* games_application_window_get_alt_left_right (GamesApplicationWindow* self);
static void ___lambda63__gtk_widget_direction_changed (GtkWidget* _sender,
                                                GtkTextDirection previous_direction,
                                                gpointer self);
VALA_EXTERN void games_application_window_run_search (GamesApplicationWindow* self,
                                          const gchar* query);
VALA_EXTERN GamesUiView* games_application_window_get_current_view (GamesApplicationWindow* self);
VALA_EXTERN void games_collection_view_run_search (GamesCollectionView* self,
                                       const gchar* query);
VALA_EXTERN void games_application_window_show_error (GamesApplicationWindow* self,
                                          const gchar* error_message);
VALA_EXTERN void games_collection_view_show_error (GamesCollectionView* self,
                                       const gchar* error_message);
static void games_application_window_run_game_data_free (gpointer _data);
VALA_EXTERN void games_application_window_run_game (GamesApplicationWindow* self,
                                        GamesGame* game,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void games_application_window_run_game_finish (GamesApplicationWindow* self,
                                               GAsyncResult* _res_);
static gboolean games_application_window_run_game_co (GamesApplicationWindowRunGameData* _data_);
VALA_EXTERN void games_display_view_run_game (GamesDisplayView* self,
                                  GamesGame* game,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void games_display_view_run_game_finish (GamesDisplayView* self,
                                         GAsyncResult* _res_);
static void games_application_window_run_game_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void games_application_window_inhibit (GamesApplicationWindow* self,
                                       GtkApplicationInhibitFlags flags);
static void games_application_window_quit_game_data_free (gpointer _data);
VALA_EXTERN void games_application_window_quit_game (GamesApplicationWindow* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN gboolean games_application_window_quit_game_finish (GamesApplicationWindow* self,
                                                    GAsyncResult* _res_);
static gboolean games_application_window_quit_game_co (GamesApplicationWindowQuitGameData* _data_);
VALA_EXTERN void games_display_view_quit_game (GamesDisplayView* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gboolean games_display_view_quit_game_finish (GamesDisplayView* self,
                                              GAsyncResult* _res_);
static void games_application_window_quit_game_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void games_application_window_real_size_allocate (GtkWidget* base,
                                                  GtkAllocation* allocation);
static gboolean games_application_window_store_window_size (GamesApplicationWindow* self);
static gboolean _games_application_window_store_window_size_gsource_func (gpointer self);
VALA_EXTERN gboolean games_application_window_on_delete_event (GamesApplicationWindow* self);
static void __lambda64_ (GamesApplicationWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda64__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean _games_application_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                            GdkEventAny* event,
                                                                            gpointer self);
VALA_EXTERN gboolean games_application_window_on_key_pressed (GamesApplicationWindow* self,
                                                  GdkEventKey* event);
static void ___lambda65_ (GamesApplicationWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda65__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN gboolean games_ui_view_on_key_pressed (GamesUiView* self,
                                       GdkEventKey* event);
static gboolean _games_application_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                              GdkEventKey* event,
                                                                              gpointer self);
VALA_EXTERN gboolean games_application_window_on_button_pressed (GamesApplicationWindow* self,
                                                     GdkEventButton* event);
VALA_EXTERN gboolean games_ui_view_on_button_pressed (GamesUiView* self,
                                          GdkEventButton* event);
static gboolean _games_application_window_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                    GdkEventButton* event,
                                                                                    gpointer self);
VALA_EXTERN gboolean games_application_window_on_window_state_event (GamesApplicationWindow* self,
                                                         GdkEventWindowState* event);
VALA_EXTERN void games_application_window_set_is_fullscreen (GamesApplicationWindow* self,
                                                 gboolean value);
VALA_EXTERN void games_display_view_update_pause (GamesDisplayView* self);
static void games_application_window_uninhibit (GamesApplicationWindow* self,
                                         GtkApplicationInhibitFlags flags);
static gboolean _games_application_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                        GdkEventWindowState* event,
                                                                                        gpointer self);
VALA_EXTERN gboolean games_application_window_gamepad_button_press_event (GamesApplicationWindow* self,
                                                              ManetteEvent* event);
VALA_EXTERN gboolean games_ui_view_gamepad_button_press_event (GamesUiView* self,
                                                   ManetteEvent* event);
VALA_EXTERN gboolean games_application_window_gamepad_button_release_event (GamesApplicationWindow* self,
                                                                ManetteEvent* event);
VALA_EXTERN gboolean games_ui_view_gamepad_button_release_event (GamesUiView* self,
                                                     ManetteEvent* event);
VALA_EXTERN gboolean games_application_window_gamepad_absolute_axis_event (GamesApplicationWindow* self,
                                                               ManetteEvent* event);
VALA_EXTERN gboolean games_ui_view_gamepad_absolute_axis_event (GamesUiView* self,
                                                    ManetteEvent* event);
static void games_application_window_on_game_activated (GamesApplicationWindow* self,
                                                 GamesGame* game);
static void _games_application_window_on_game_activated_games_collection_view_game_activated (GamesCollectionView* _sender,
                                                                                       GamesGame* game,
                                                                                       gpointer self);
static void games_application_window_on_display_back (GamesApplicationWindow* self);
static void __lambda66_ (GamesApplicationWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda66__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _games_application_window_on_display_back_games_display_view_back (GamesDisplayView* _sender,
                                                                        gpointer self);
static void games_application_window_on_active_changed (GamesApplicationWindow* self);
static void _games_application_window_on_active_changed_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static GdkRectangle* games_application_window_get_geometry (GamesApplicationWindow* self);
static GdkRectangle* _vala_GdkRectangle_copy (GdkRectangle* self);
static void _vala_GdkRectangle_free (GdkRectangle* self);
VALA_EXTERN void games_ui_view_set_is_view_active (GamesUiView* self,
                                       gboolean value);
VALA_EXTERN gboolean games_application_window_get_is_fullscreen (GamesApplicationWindow* self);
VALA_EXTERN gboolean games_application_window_get_loading_notification (GamesApplicationWindow* self);
VALA_EXTERN void games_application_window_set_loading_notification (GamesApplicationWindow* self,
                                                        gboolean value);
VALA_EXTERN GamesGameModel* games_application_window_get_game_model (GamesApplicationWindow* self);
static void games_application_window_set_game_model (GamesApplicationWindow* self,
                                              GamesGameModel* value);
VALA_EXTERN GamesCollectionModel* games_application_window_get_collection_model (GamesApplicationWindow* self);
static void games_application_window_set_collection_model (GamesApplicationWindow* self,
                                                    GamesCollectionModel* value);
static GObject * games_application_window_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
VALA_EXTERN void games_collection_view_set_game_model (GamesCollectionView* self,
                                           GamesGameModel* value);
VALA_EXTERN void games_collection_view_set_collection_model (GamesCollectionView* self,
                                                 GamesCollectionModel* value);
static void games_application_window_finalize (GObject * obj);
static GType games_application_window_get_type_once (void);
static void _vala_games_application_window_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_games_application_window_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_application_window_get_instance_private (GamesApplicationWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GamesApplicationWindow_private_offset);
}

GamesApplicationWindow*
games_application_window_construct (GType object_type,
                                    GamesApplication* application,
                                    GamesGameModel* game_model,
                                    GamesCollectionModel* collection_model)
{
	GamesApplicationWindow * self = NULL;
	GamesCollectionView* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (game_model != NULL, NULL);
	g_return_val_if_fail (collection_model != NULL, NULL);
	self = (GamesApplicationWindow*) g_object_new (object_type, "application", application, "game-model", game_model, "collection-model", collection_model, NULL);
	_tmp0_ = self->priv->collection_view;
	games_application_window_set_current_view (self, (GamesUiView*) _tmp0_);
	return self;
}

GamesApplicationWindow*
games_application_window_new (GamesApplication* application,
                              GamesGameModel* game_model,
                              GamesCollectionModel* collection_model)
{
	return games_application_window_construct (GAMES_TYPE_APPLICATION_WINDOW, application, game_model, collection_model);
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		GamesApplicationWindow* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->shortcut);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda63_ (Block24Data* _data24_)
{
	GamesApplicationWindow* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data24_->self;
	_tmp0_ = games_application_window_get_alt_left_right (self);
	_tmp1_ = _tmp0_;
	g_object_set (_data24_->shortcut, "accelerator", _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

static void
___lambda63__gtk_widget_direction_changed (GtkWidget* _sender,
                                           GtkTextDirection previous_direction,
                                           gpointer self)
{
	__lambda63_ (self);
}

static void
games_application_window_init_help_overlay (GamesApplicationWindow* self)
{
	Block24Data* _data24_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkShortcutsWindow* shortcuts_window = NULL;
	GObject* _tmp1_;
	GtkShortcutsWindow* _tmp2_;
	GObject* _tmp3_;
	GtkShortcutsShortcut* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Games/ui/help-overlay.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "help_overlay");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_shortcuts_window_get_type ()) ? ((GtkShortcutsWindow*) _tmp1_) : NULL);
	shortcuts_window = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "general_shortcut_alt_left");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_shortcuts_shortcut_get_type ()) ? ((GtkShortcutsShortcut*) _tmp3_) : NULL);
	_data24_->shortcut = _tmp4_;
	g_signal_connect_data ((GtkWidget*) shortcuts_window, "direction-changed", (GCallback) ___lambda63__gtk_widget_direction_changed, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp5_ = games_application_window_get_alt_left_right (self);
	_tmp6_ = _tmp5_;
	g_object_set (_data24_->shortcut, "accelerator", _tmp6_, NULL);
	_g_free0 (_tmp6_);
	gtk_application_window_set_help_overlay ((GtkApplicationWindow*) self, shortcuts_window);
	_g_object_unref0 (shortcuts_window);
	_g_object_unref0 (builder);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static gchar*
games_application_window_get_alt_left_right (GamesApplicationWindow* self)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (gtk_widget_get_direction ((GtkWidget*) self) == GTK_TEXT_DIR_LTR) {
		_tmp0_ = "<alt>Left";
	} else {
		_tmp0_ = "<alt>Right";
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
games_application_window_run_search (GamesApplicationWindow* self,
                                     const gchar* query)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	GamesCollectionView* _tmp2_;
	GamesCollectionView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->collection_view;
	if (_tmp1_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GAMES_TYPE_UI_VIEW, GamesUiView)) {
		return;
	}
	_tmp3_ = self->priv->collection_view;
	games_collection_view_run_search (_tmp3_, query);
}

void
games_application_window_show_error (GamesApplicationWindow* self,
                                     const gchar* error_message)
{
	GamesCollectionView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	_tmp0_ = self->priv->collection_view;
	games_collection_view_show_error (_tmp0_, error_message);
}

static void
games_application_window_run_game_data_free (gpointer _data)
{
	GamesApplicationWindowRunGameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->game);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesApplicationWindowRunGameData, _data_);
}

void
games_application_window_run_game (GamesApplicationWindow* self,
                                   GamesGame* game,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GamesApplicationWindowRunGameData* _data_;
	GamesApplicationWindow* _tmp0_;
	GamesGame* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_data_ = g_slice_new0 (GamesApplicationWindowRunGameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_application_window_run_game_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (game);
	_g_object_unref0 (_data_->game);
	_data_->game = _tmp1_;
	games_application_window_run_game_co (_data_);
}

void
games_application_window_run_game_finish (GamesApplicationWindow* self,
                                          GAsyncResult* _res_)
{
	GamesApplicationWindowRunGameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_application_window_run_game_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GamesApplicationWindowRunGameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_application_window_run_game_co (_data_);
}

static gboolean
games_application_window_run_game_co (GamesApplicationWindowRunGameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = games_application_window_get_current_view (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->self->priv->collection_view;
	if (_data_->_tmp1_ != G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GAMES_TYPE_UI_VIEW, GamesUiView)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->display_view;
	games_application_window_set_current_view (_data_->self, (GamesUiView*) _data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->display_view;
	_data_->_state_ = 1;
	games_display_view_run_game (_data_->_tmp4_, _data_->game, games_application_window_run_game_ready, _data_);
	return FALSE;
	_state_1:
	games_display_view_run_game_finish (_data_->_tmp4_, _data_->_res_);
	games_application_window_inhibit (_data_->self, GTK_APPLICATION_INHIBIT_IDLE | GTK_APPLICATION_INHIBIT_LOGOUT);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_application_window_quit_game_data_free (gpointer _data)
{
	GamesApplicationWindowQuitGameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesApplicationWindowQuitGameData, _data_);
}

void
games_application_window_quit_game (GamesApplicationWindow* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GamesApplicationWindowQuitGameData* _data_;
	GamesApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesApplicationWindowQuitGameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_application_window_quit_game_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_application_window_quit_game_co (_data_);
}

gboolean
games_application_window_quit_game_finish (GamesApplicationWindow* self,
                                           GAsyncResult* _res_)
{
	gboolean result;
	GamesApplicationWindowQuitGameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
games_application_window_quit_game_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GamesApplicationWindowQuitGameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_application_window_quit_game_co (_data_);
}

static gboolean
games_application_window_quit_game_co (GamesApplicationWindowQuitGameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_widget_get_visible ((GtkWidget*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (!_data_->_tmp1_) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->display_view;
	_data_->_state_ = 1;
	games_display_view_quit_game (_data_->_tmp2_, games_application_window_quit_game_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result = games_display_view_quit_game_finish (_data_->_tmp2_, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_games_application_window_store_window_size_gsource_func (gpointer self)
{
	gboolean result;
	result = games_application_window_store_window_size ((GamesApplicationWindow*) self);
	return result;
}

static void
games_application_window_real_size_allocate (GtkWidget* base,
                                             GtkAllocation* allocation)
{
	GamesApplicationWindow * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (GamesApplicationWindow*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (games_application_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), &_tmp0_);
	if (self->priv->window_size_update_timeout == ((glong) -1)) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		g_object_get ((GtkWindow*) self, "is-maximized", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->window_size_update_timeout = (glong) g_timeout_add_full (G_PRIORITY_DEFAULT, GAMES_APPLICATION_WINDOW_WINDOW_SIZE_UPDATE_DELAY_MILLISECONDS, _games_application_window_store_window_size_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
__lambda64_ (GamesApplicationWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (!games_application_window_quit_game_finish (self, res)) {
		return;
	}
	self->priv->confirm_exit = TRUE;
	gtk_window_close ((GtkWindow*) self);
}

static void
___lambda64__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda64_ ((GamesApplicationWindow*) self, source_object, res);
	g_object_unref (self);
}

gboolean
games_application_window_on_delete_event (GamesApplicationWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->confirm_exit) {
		result = TRUE;
		return result;
	}
	games_application_window_quit_game (self, ___lambda64__gasync_ready_callback, g_object_ref (self));
	result = FALSE;
	return result;
}

static gboolean
_games_application_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                   GdkEventAny* event,
                                                                   gpointer self)
{
	gboolean result;
	result = games_application_window_on_delete_event ((GamesApplicationWindow*) self);
	return result;
}

static void
___lambda65_ (GamesApplicationWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (!games_application_window_quit_game_finish (self, res)) {
		return;
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
____lambda65__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda65_ ((GamesApplicationWindow*) self, source_object, res);
	g_object_unref (self);
}

gboolean
games_application_window_on_key_pressed (GamesApplicationWindow* self,
                                         GdkEventKey* event)
{
	GdkModifierType default_modifiers = 0U;
	guint keyval = 0U;
	GdkKeymap* keymap = NULL;
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	GdkKeymap* _tmp3_;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GamesUiView* _tmp7_;
	GamesUiView* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	default_modifiers = gtk_accelerator_get_default_mod_mask ();
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keymap = _tmp2_;
	_tmp3_ = keymap;
	gdk_keymap_translate_keyboard_state (_tmp3_, (guint) event->hardware_keycode, event->state, (gint) event->group, &_tmp4_, NULL, NULL, NULL);
	keyval = _tmp4_;
	if (keyval == GDK_KEY_q) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = keyval == GDK_KEY_Q;
	}
	if (_tmp6_) {
		_tmp5_ = (event->state & default_modifiers) == GDK_CONTROL_MASK;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		games_application_window_quit_game (self, ____lambda65__gasync_ready_callback, g_object_ref (self));
		result = TRUE;
		_g_object_unref0 (keymap);
		return result;
	}
	_tmp7_ = games_application_window_get_current_view (self);
	_tmp8_ = _tmp7_;
	result = games_ui_view_on_key_pressed (_tmp8_, event);
	_g_object_unref0 (keymap);
	return result;
}

static gboolean
_games_application_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                     GdkEventKey* event,
                                                                     gpointer self)
{
	gboolean result;
	result = games_application_window_on_key_pressed ((GamesApplicationWindow*) self, event);
	return result;
}

gboolean
games_application_window_on_button_pressed (GamesApplicationWindow* self,
                                            GdkEventButton* event)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	result = games_ui_view_on_button_pressed (_tmp1_, event);
	return result;
}

static gboolean
_games_application_window_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self)
{
	gboolean result;
	result = games_application_window_on_button_pressed ((GamesApplicationWindow*) self, event);
	return result;
}

gboolean
games_application_window_on_window_state_event (GamesApplicationWindow* self,
                                                GdkEventWindowState* event)
{
	gboolean is_maximized = FALSE;
	GSettings* _tmp0_;
	GamesUiView* _tmp1_;
	GamesUiView* _tmp2_;
	GamesDisplayView* _tmp3_;
	gboolean focused = FALSE;
	gboolean playing = FALSE;
	GamesUiView* _tmp5_;
	GamesUiView* _tmp6_;
	GamesDisplayView* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	is_maximized = (gboolean) (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "window-maximized", is_maximized);
	games_application_window_set_is_fullscreen (self, (gboolean) (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN));
	_tmp1_ = games_application_window_get_current_view (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->display_view;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GAMES_TYPE_UI_VIEW, GamesUiView)) {
		GamesDisplayView* _tmp4_;
		_tmp4_ = self->priv->display_view;
		games_display_view_update_pause (_tmp4_);
	}
	if (!((gboolean) (event->changed_mask & GDK_WINDOW_STATE_FOCUSED))) {
		result = TRUE;
		return result;
	}
	focused = (gboolean) (event->new_window_state & GDK_WINDOW_STATE_FOCUSED);
	_tmp5_ = games_application_window_get_current_view (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->display_view;
	playing = _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GAMES_TYPE_UI_VIEW, GamesUiView);
	if (focused) {
		_tmp8_ = playing;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		games_application_window_inhibit (self, GTK_APPLICATION_INHIBIT_IDLE);
	}
	if (!focused) {
		games_application_window_uninhibit (self, GTK_APPLICATION_INHIBIT_IDLE);
	}
	result = TRUE;
	return result;
}

static gboolean
_games_application_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                               GdkEventWindowState* event,
                                                                               gpointer self)
{
	gboolean result;
	result = games_application_window_on_window_state_event ((GamesApplicationWindow*) self, event);
	return result;
}

gboolean
games_application_window_gamepad_button_press_event (GamesApplicationWindow* self,
                                                     ManetteEvent* event)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	result = games_ui_view_gamepad_button_press_event (_tmp1_, event);
	return result;
}

gboolean
games_application_window_gamepad_button_release_event (GamesApplicationWindow* self,
                                                       ManetteEvent* event)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	GamesCollectionView* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->collection_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GAMES_TYPE_UI_VIEW, GamesUiView)) {
		GamesCollectionView* _tmp3_;
		_tmp3_ = self->priv->collection_view;
		result = games_ui_view_gamepad_button_release_event ((GamesUiView*) _tmp3_, event);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
games_application_window_gamepad_absolute_axis_event (GamesApplicationWindow* self,
                                                      ManetteEvent* event)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	GamesCollectionView* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->collection_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GAMES_TYPE_UI_VIEW, GamesUiView)) {
		GamesCollectionView* _tmp3_;
		_tmp3_ = self->priv->collection_view;
		result = games_ui_view_gamepad_absolute_axis_event ((GamesUiView*) _tmp3_, event);
		return result;
	}
	result = FALSE;
	return result;
}

static void
games_application_window_on_game_activated (GamesApplicationWindow* self,
                                            GamesGame* game)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	games_application_window_run_game (self, game, NULL, NULL);
}

static void
_games_application_window_on_game_activated_games_collection_view_game_activated (GamesCollectionView* _sender,
                                                                                  GamesGame* game,
                                                                                  gpointer self)
{
	games_application_window_on_game_activated ((GamesApplicationWindow*) self, game);
}

static void
__lambda66_ (GamesApplicationWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (games_application_window_quit_game_finish (self, res)) {
		GamesCollectionView* _tmp0_;
		_tmp0_ = self->priv->collection_view;
		games_application_window_set_current_view (self, (GamesUiView*) _tmp0_);
	}
	games_application_window_uninhibit (self, GTK_APPLICATION_INHIBIT_IDLE | GTK_APPLICATION_INHIBIT_LOGOUT);
}

static void
___lambda66__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda66_ ((GamesApplicationWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
games_application_window_on_display_back (GamesApplicationWindow* self)
{
	g_return_if_fail (self != NULL);
	games_application_window_quit_game (self, ___lambda66__gasync_ready_callback, g_object_ref (self));
}

static void
_games_application_window_on_display_back_games_display_view_back (GamesDisplayView* _sender,
                                                                   gpointer self)
{
	games_application_window_on_display_back ((GamesApplicationWindow*) self);
}

static void
games_application_window_on_active_changed (GamesApplicationWindow* self)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	GamesDisplayView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->display_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GAMES_TYPE_UI_VIEW, GamesUiView)) {
		GamesDisplayView* _tmp3_;
		_tmp3_ = self->priv->display_view;
		games_display_view_update_pause (_tmp3_);
	}
}

static void
_games_application_window_on_active_changed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	games_application_window_on_active_changed ((GamesApplicationWindow*) self);
}

static GdkRectangle*
_vala_GdkRectangle_copy (GdkRectangle* self)
{
	return g_boxed_copy (gdk_rectangle_get_type (), self);
}

static gpointer
__vala_GdkRectangle_copy0 (gpointer self)
{
	return self ? _vala_GdkRectangle_copy (self) : NULL;
}

static GdkRectangle*
games_application_window_get_geometry (GamesApplicationWindow* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp3_;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp6_;
	GdkWindow* _tmp7_;
	GdkMonitor* _tmp8_;
	GdkMonitor* _tmp9_;
	GdkMonitor* _tmp10_;
	GdkMonitor* _tmp11_;
	GdkRectangle _tmp12_ = {0};
	GdkRectangle _tmp13_;
	GdkRectangle* _tmp14_;
	GdkRectangle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (display);
		return result;
	}
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	window = _tmp4_;
	_tmp5_ = window;
	if (_tmp5_ == NULL) {
		result = NULL;
		_g_object_unref0 (window);
		_g_object_unref0 (display);
		return result;
	}
	_tmp6_ = display;
	_tmp7_ = window;
	_tmp8_ = gdk_display_get_monitor_at_window (_tmp6_, _tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	monitor = _tmp9_;
	_tmp10_ = monitor;
	if (_tmp10_ == NULL) {
		result = NULL;
		_g_object_unref0 (monitor);
		_g_object_unref0 (window);
		_g_object_unref0 (display);
		return result;
	}
	_tmp11_ = monitor;
	gdk_monitor_get_geometry (_tmp11_, &_tmp12_);
	_tmp13_ = _tmp12_;
	_tmp14_ = __vala_GdkRectangle_copy0 (&_tmp13_);
	result = _tmp14_;
	_g_object_unref0 (monitor);
	_g_object_unref0 (window);
	_g_object_unref0 (display);
	return result;
}

static void
_vala_GdkRectangle_free (GdkRectangle* self)
{
	g_boxed_free (gdk_rectangle_get_type (), self);
}

static gboolean
games_application_window_store_window_size (GamesApplicationWindow* self)
{
	GdkRectangle* geometry = NULL;
	GdkRectangle* _tmp0_;
	GdkRectangle* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkRectangle* _tmp4_;
	GdkRectangle* _tmp5_;
	GSettings* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_application_window_get_geometry (self);
	geometry = _tmp0_;
	_tmp1_ = geometry;
	if (_tmp1_ == NULL) {
		result = FALSE;
		__vala_GdkRectangle_free0 (geometry);
		return result;
	}
	width = 0;
	height = 0;
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = geometry;
	width = MIN (width, (*_tmp4_).width);
	_tmp5_ = geometry;
	height = MIN (height, (*_tmp5_).height);
	_tmp6_ = self->priv->settings;
	g_settings_set (_tmp6_, "window-size", "(ii)", width, height);
	g_source_remove ((guint) self->priv->window_size_update_timeout);
	self->priv->window_size_update_timeout = (glong) -1;
	result = FALSE;
	__vala_GdkRectangle_free0 (geometry);
	return result;
}

static void
games_application_window_inhibit (GamesApplicationWindow* self,
                                  GtkApplicationInhibitFlags flags)
{
	GtkApplicationInhibitFlags new_flags = 0U;
	guint new_cookie = 0U;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	if ((self->priv->inhibit_flags & flags) == flags) {
		return;
	}
	new_flags = self->priv->inhibit_flags | flags;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	new_cookie = gtk_application_inhibit (_tmp1_, (GtkWindow*) self, new_flags, _ ("Playing a game"));
	if (self->priv->inhibit_cookie != ((guint) 0)) {
		GtkApplication* _tmp2_;
		GtkApplication* _tmp3_;
		_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp3_ = _tmp2_;
		gtk_application_uninhibit (_tmp3_, self->priv->inhibit_cookie);
	}
	self->priv->inhibit_cookie = new_cookie;
	self->priv->inhibit_flags = new_flags;
}

static void
games_application_window_uninhibit (GamesApplicationWindow* self,
                                    GtkApplicationInhibitFlags flags)
{
	GtkApplicationInhibitFlags new_flags = 0U;
	guint new_cookie = 0U;
	g_return_if_fail (self != NULL);
	if ((self->priv->inhibit_flags & flags) == 0) {
		return;
	}
	new_flags = self->priv->inhibit_flags & (~flags);
	new_cookie = (guint) 0;
	if ((gboolean) new_flags) {
		GtkApplication* _tmp0_;
		GtkApplication* _tmp1_;
		_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp1_ = _tmp0_;
		new_cookie = gtk_application_inhibit (_tmp1_, (GtkWindow*) self, new_flags, _ ("Playing a game"));
	}
	if (self->priv->inhibit_cookie != ((guint) 0)) {
		GtkApplication* _tmp2_;
		GtkApplication* _tmp3_;
		_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp3_ = _tmp2_;
		gtk_application_uninhibit (_tmp3_, self->priv->inhibit_cookie);
	}
	self->priv->inhibit_cookie = new_cookie;
	self->priv->inhibit_flags = new_flags;
}

GamesUiView*
games_application_window_get_current_view (GamesApplicationWindow* self)
{
	GamesUiView* result;
	GamesUiView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_view;
	result = _tmp0_;
	return result;
}

void
games_application_window_set_current_view (GamesApplicationWindow* self,
                                           GamesUiView* value)
{
	GamesUiView* _tmp0_;
	GamesUiView* _tmp1_;
	GamesUiView* _tmp2_;
	GamesUiView* _tmp3_;
	GamesUiView* _tmp6_;
	GtkStack* _tmp7_;
	GamesUiView* _tmp8_;
	GamesUiView* _tmp9_;
	GamesUiView* _tmp10_;
	GamesUiView* _tmp11_;
	GamesApplication* app = NULL;
	GtkApplication* _tmp14_;
	GtkApplication* _tmp15_;
	GamesApplication* _tmp16_;
	GamesApplication* _tmp17_;
	GamesApplication* _tmp18_;
	GamesUiView* _tmp19_;
	GamesUiView* _tmp20_;
	GamesCollectionView* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_application_window_get_current_view (self);
	_tmp1_ = _tmp0_;
	if (value == _tmp1_) {
		return;
	}
	_tmp2_ = games_application_window_get_current_view (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GamesUiView* _tmp4_;
		GamesUiView* _tmp5_;
		_tmp4_ = games_application_window_get_current_view (self);
		_tmp5_ = _tmp4_;
		games_ui_view_set_is_view_active (_tmp5_, FALSE);
	}
	_tmp6_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_view);
	self->priv->_current_view = _tmp6_;
	_tmp7_ = self->priv->stack;
	_tmp8_ = games_application_window_get_current_view (self);
	_tmp9_ = _tmp8_;
	gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp9_);
	_tmp10_ = games_application_window_get_current_view (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		GamesUiView* _tmp12_;
		GamesUiView* _tmp13_;
		_tmp12_ = games_application_window_get_current_view (self);
		_tmp13_ = _tmp12_;
		games_ui_view_set_is_view_active (_tmp13_, TRUE);
	}
	_tmp14_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (GAMES_IS_APPLICATION (_tmp15_) ? ((GamesApplication*) _tmp15_) : NULL);
	app = _tmp16_;
	_tmp17_ = app;
	_vala_assert (_tmp17_ != NULL, "app != null");
	_tmp18_ = app;
	_tmp19_ = games_application_window_get_current_view (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->collection_view;
	games_application_set_pause_loading (_tmp18_, _tmp20_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GAMES_TYPE_UI_VIEW, GamesUiView));
	_g_object_unref0 (app);
	g_object_notify_by_pspec ((GObject *) self, games_application_window_properties[GAMES_APPLICATION_WINDOW_CURRENT_VIEW_PROPERTY]);
}

gboolean
games_application_window_get_is_fullscreen (GamesApplicationWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_fullscreen;
	return result;
}

void
games_application_window_set_is_fullscreen (GamesApplicationWindow* self,
                                            gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value) {
		GamesUiView* _tmp1_;
		GamesUiView* _tmp2_;
		GamesDisplayView* _tmp3_;
		_tmp1_ = games_application_window_get_current_view (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->display_view;
		_tmp0_ = _tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GAMES_TYPE_UI_VIEW, GamesUiView);
	} else {
		_tmp0_ = FALSE;
	}
	self->priv->_is_fullscreen = _tmp0_;
	if (self->priv->_is_fullscreen) {
		gtk_window_fullscreen ((GtkWindow*) self);
	} else {
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_application_window_properties[GAMES_APPLICATION_WINDOW_IS_FULLSCREEN_PROPERTY]);
}

gboolean
games_application_window_get_loading_notification (GamesApplicationWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loading_notification;
	return result;
}

void
games_application_window_set_loading_notification (GamesApplicationWindow* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = games_application_window_get_loading_notification (self);
	if (old_value != value) {
		self->priv->_loading_notification = value;
		g_object_notify_by_pspec ((GObject *) self, games_application_window_properties[GAMES_APPLICATION_WINDOW_LOADING_NOTIFICATION_PROPERTY]);
	}
}

GamesGameModel*
games_application_window_get_game_model (GamesApplicationWindow* self)
{
	GamesGameModel* result;
	GamesGameModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game_model;
	result = _tmp0_;
	return result;
}

static void
games_application_window_set_game_model (GamesApplicationWindow* self,
                                         GamesGameModel* value)
{
	GamesGameModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_application_window_get_game_model (self);
	if (old_value != value) {
		GamesGameModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_game_model);
		self->priv->_game_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_application_window_properties[GAMES_APPLICATION_WINDOW_GAME_MODEL_PROPERTY]);
	}
}

GamesCollectionModel*
games_application_window_get_collection_model (GamesApplicationWindow* self)
{
	GamesCollectionModel* result;
	GamesCollectionModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection_model;
	result = _tmp0_;
	return result;
}

static void
games_application_window_set_collection_model (GamesApplicationWindow* self,
                                               GamesCollectionModel* value)
{
	GamesCollectionModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_application_window_get_collection_model (self);
	if (old_value != value) {
		GamesCollectionModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_collection_model);
		self->priv->_collection_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_application_window_properties[GAMES_APPLICATION_WINDOW_COLLECTION_MODEL_PROPERTY]);
	}
}

static GObject *
games_application_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesApplicationWindow * self;
	GSettings* _tmp0_;
	GamesCollectionView* _tmp1_;
	GamesGameModel* _tmp2_;
	GamesCollectionView* _tmp3_;
	GamesCollectionModel* _tmp4_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GdkRectangle* geometry = NULL;
	GdkRectangle* _tmp8_;
	GdkRectangle* _tmp9_;
	GSettings* _tmp12_;
	parent_class = G_OBJECT_CLASS (games_application_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow);
	_tmp0_ = g_settings_new ("org.gnome.Games");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->collection_view;
	_tmp2_ = self->priv->_game_model;
	games_collection_view_set_game_model (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->collection_view;
	_tmp4_ = self->priv->_collection_model;
	games_collection_view_set_collection_model (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	g_settings_get (_tmp5_, "window-size", "(ii)", &_tmp6_, &_tmp7_);
	width = _tmp6_;
	height = _tmp7_;
	_tmp8_ = games_application_window_get_geometry (self);
	geometry = _tmp8_;
	_tmp9_ = geometry;
	if (_tmp9_ != NULL) {
		GdkRectangle* _tmp10_;
		GdkRectangle* _tmp11_;
		_tmp10_ = geometry;
		width = MIN (width, (*_tmp10_).width);
		_tmp11_ = geometry;
		height = MIN (height, (*_tmp11_).height);
	}
	gtk_window_resize ((GtkWindow*) self, width, height);
	_tmp12_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp12_, "window-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	self->priv->window_size_update_timeout = (glong) -1;
	self->priv->inhibit_cookie = (guint) 0;
	self->priv->inhibit_flags = 0;
	if (g_strcmp0 (PROFILE, "Devel") == 0) {
		GtkStyleContext* _tmp13_;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp13_, "devel");
	}
	games_application_window_init_help_overlay (self);
	__vala_GdkRectangle_free0 (geometry);
	return obj;
}

static void
games_application_window_class_init (GamesApplicationWindowClass * klass,
                                     gpointer klass_data)
{
	games_application_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesApplicationWindow_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) games_application_window_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_application_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_application_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_application_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_application_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_APPLICATION_WINDOW_CURRENT_VIEW_PROPERTY, games_application_window_properties[GAMES_APPLICATION_WINDOW_CURRENT_VIEW_PROPERTY] = g_param_spec_object ("current-view", "current-view", "current-view", GAMES_TYPE_UI_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_APPLICATION_WINDOW_IS_FULLSCREEN_PROPERTY, games_application_window_properties[GAMES_APPLICATION_WINDOW_IS_FULLSCREEN_PROPERTY] = g_param_spec_boolean ("is-fullscreen", "is-fullscreen", "is-fullscreen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_APPLICATION_WINDOW_LOADING_NOTIFICATION_PROPERTY, games_application_window_properties[GAMES_APPLICATION_WINDOW_LOADING_NOTIFICATION_PROPERTY] = g_param_spec_boolean ("loading-notification", "loading-notification", "loading-notification", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_APPLICATION_WINDOW_GAME_MODEL_PROPERTY, games_application_window_properties[GAMES_APPLICATION_WINDOW_GAME_MODEL_PROPERTY] = g_param_spec_object ("game-model", "game-model", "game-model", GAMES_TYPE_GAME_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_APPLICATION_WINDOW_COLLECTION_MODEL_PROPERTY, games_application_window_properties[GAMES_APPLICATION_WINDOW_COLLECTION_MODEL_PROPERTY] = g_param_spec_object ("collection-model", "collection-model", "collection-model", GAMES_TYPE_COLLECTION_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Games/ui/application-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, GamesApplicationWindow_private_offset + G_STRUCT_OFFSET (GamesApplicationWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "collection_view", FALSE, GamesApplicationWindow_private_offset + G_STRUCT_OFFSET (GamesApplicationWindowPrivate, collection_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "display_view", FALSE, GamesApplicationWindow_private_offset + G_STRUCT_OFFSET (GamesApplicationWindowPrivate, display_view));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_event", G_CALLBACK(_games_application_window_on_delete_event_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_pressed", G_CALLBACK(_games_application_window_on_key_pressed_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_button_pressed", G_CALLBACK(_games_application_window_on_button_pressed_gtk_widget_button_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_games_application_window_on_window_state_event_gtk_widget_window_state_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_game_activated", G_CALLBACK(_games_application_window_on_game_activated_games_collection_view_game_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_display_back", G_CALLBACK(_games_application_window_on_display_back_games_display_view_back));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_active_changed", G_CALLBACK(_games_application_window_on_active_changed_g_object_notify));
}

static void
games_application_window_instance_init (GamesApplicationWindow * self,
                                        gpointer klass)
{
	self->priv = games_application_window_get_instance_private (self);
	g_type_ensure (GAMES_TYPE_COLLECTION_VIEW);
	g_type_ensure (GAMES_TYPE_DISPLAY_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
games_application_window_finalize (GObject * obj)
{
	GamesApplicationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow);
	_g_object_unref0 (self->priv->_current_view);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->_game_model);
	_g_object_unref0 (self->priv->_collection_model);
	G_OBJECT_CLASS (games_application_window_parent_class)->finalize (obj);
}

static GType
games_application_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesApplicationWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_application_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesApplicationWindow), 0, (GInstanceInitFunc) games_application_window_instance_init, NULL };
	GType games_application_window_type_id;
	games_application_window_type_id = g_type_register_static (hdy_application_window_get_type (), "GamesApplicationWindow", &g_define_type_info, 0);
	GamesApplicationWindow_private_offset = g_type_add_instance_private (games_application_window_type_id, sizeof (GamesApplicationWindowPrivate));
	return games_application_window_type_id;
}

GType
games_application_window_get_type (void)
{
	static volatile gsize games_application_window_type_id__once = 0;
	if (g_once_init_enter (&games_application_window_type_id__once)) {
		GType games_application_window_type_id;
		games_application_window_type_id = games_application_window_get_type_once ();
		g_once_init_leave (&games_application_window_type_id__once, games_application_window_type_id);
	}
	return games_application_window_type_id__once;
}

static void
_vala_games_application_window_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GamesApplicationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow);
	switch (property_id) {
		case GAMES_APPLICATION_WINDOW_CURRENT_VIEW_PROPERTY:
		g_value_set_object (value, games_application_window_get_current_view (self));
		break;
		case GAMES_APPLICATION_WINDOW_IS_FULLSCREEN_PROPERTY:
		g_value_set_boolean (value, games_application_window_get_is_fullscreen (self));
		break;
		case GAMES_APPLICATION_WINDOW_LOADING_NOTIFICATION_PROPERTY:
		g_value_set_boolean (value, games_application_window_get_loading_notification (self));
		break;
		case GAMES_APPLICATION_WINDOW_GAME_MODEL_PROPERTY:
		g_value_set_object (value, games_application_window_get_game_model (self));
		break;
		case GAMES_APPLICATION_WINDOW_COLLECTION_MODEL_PROPERTY:
		g_value_set_object (value, games_application_window_get_collection_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_application_window_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GamesApplicationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow);
	switch (property_id) {
		case GAMES_APPLICATION_WINDOW_CURRENT_VIEW_PROPERTY:
		games_application_window_set_current_view (self, g_value_get_object (value));
		break;
		case GAMES_APPLICATION_WINDOW_IS_FULLSCREEN_PROPERTY:
		games_application_window_set_is_fullscreen (self, g_value_get_boolean (value));
		break;
		case GAMES_APPLICATION_WINDOW_LOADING_NOTIFICATION_PROPERTY:
		games_application_window_set_loading_notification (self, g_value_get_boolean (value));
		break;
		case GAMES_APPLICATION_WINDOW_GAME_MODEL_PROPERTY:
		games_application_window_set_game_model (self, g_value_get_object (value));
		break;
		case GAMES_APPLICATION_WINDOW_COLLECTION_MODEL_PROPERTY:
		games_application_window_set_collection_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

