/* turbografx-cd-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from turbografx-cd-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "games-turbografx-cd-plugin.h"

#define GAMES_TURBO_GRAFX_CD_PLUGIN_PHONY_MIME_TYPE "application/x-pc-engine-cd-rom"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE "application/x-cue"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CD_MAGIC_VALUE "PC Engine CD-ROM SYSTEM"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_ID "TurboGrafxCD"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_NAME _ ("TurboGrafx-CD")
#define GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_UID_PREFIX "pc-engine"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN (games_turbo_grafx_cd_plugin_get_type ())
#define GAMES_TURBO_GRAFX_CD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPlugin))
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPluginClass))
#define GAMES_IS_TURBO_GRAFX_CD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN))
#define GAMES_IS_TURBO_GRAFX_CD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN))
#define GAMES_TURBO_GRAFX_CD_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPluginClass))

typedef struct _GamesTurboGrafxCDPlugin GamesTurboGrafxCDPlugin;
typedef struct _GamesTurboGrafxCDPluginClass GamesTurboGrafxCDPluginClass;
typedef struct _GamesTurboGrafxCDPluginPrivate GamesTurboGrafxCDPluginPrivate;
enum  {
	GAMES_TURBO_GRAFX_CD_PLUGIN_0_PROPERTY,
	GAMES_TURBO_GRAFX_CD_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_turbo_grafx_cd_plugin_properties[GAMES_TURBO_GRAFX_CD_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_TURBO_GRAFX_CD_ERROR (games_turbo_grafx_cd_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesTurboGrafxCDPlugin {
	GObject parent_instance;
	GamesTurboGrafxCDPluginPrivate * priv;
};

struct _GamesTurboGrafxCDPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_TURBO_GRAFX_CD_ERROR_INVALID_DISC
} GamesTurboGrafxCDError;
#define GAMES_TURBO_GRAFX_CD_ERROR games_turbo_grafx_cd_error_quark ()

static gpointer games_turbo_grafx_cd_plugin_parent_class = NULL;
static GamesRetroPlatform* games_turbo_grafx_cd_plugin_platform;
static GamesRetroPlatform* games_turbo_grafx_cd_plugin_platform = NULL;
static GamesPluginIface * games_turbo_grafx_cd_plugin_games_plugin_parent_iface = NULL;
static GType games_turbo_grafx_cd_plugin_type_id = 0;

GType games_turbo_grafx_cd_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_turbo_grafx_cd_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_turbo_grafx_cd_plugin_real_get_platforms (GamesPlugin* base,
                                                                gint* result_length1);
static gchar** games_turbo_grafx_cd_plugin_real_get_mime_types (GamesPlugin* base,
                                                         gint* result_length1);
static GamesUriGameFactory** games_turbo_grafx_cd_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                               gint* result_length1);
static GamesGame* games_turbo_grafx_cd_plugin_game_for_uri (GamesUri* uri,
                                                     GError** error);
static GamesGame* _games_turbo_grafx_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                                  gpointer self,
                                                                                                  GError** error);
static GamesRunnerFactory** games_turbo_grafx_cd_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                            gint* result_length1);
static gboolean games_turbo_grafx_cd_plugin_is_valid_disc (GamesUri* uri,
                                                    GError** error);
VALA_EXTERN GQuark games_turbo_grafx_cd_error_quark (void);
VALA_EXTERN GType games_turbo_grafx_cd_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesTurboGrafxCDPlugin* games_turbo_grafx_cd_plugin_new (void);
VALA_EXTERN GamesTurboGrafxCDPlugin* games_turbo_grafx_cd_plugin_construct (GType object_type);
static void games_turbo_grafx_cd_plugin_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_turbo_grafx_cd_plugin_real_get_platforms (GamesPlugin* base,
                                                gint* result_length1)
{
	GamesTurboGrafxCDPlugin * self;
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesTurboGrafxCDPlugin*) base;
	_tmp0_ = games_turbo_grafx_cd_plugin_platform;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gchar**
games_turbo_grafx_cd_plugin_real_get_mime_types (GamesPlugin* base,
                                                 gint* result_length1)
{
	GamesTurboGrafxCDPlugin * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (GamesTurboGrafxCDPlugin*) base;
	_tmp0_ = g_strdup (GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GamesGame*
_games_turbo_grafx_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                       gpointer self,
                                                                                       GError** error)
{
	GamesGame* result;
	result = games_turbo_grafx_cd_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_turbo_grafx_cd_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                         gint* result_length1)
{
	GamesTurboGrafxCDPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesTurboGrafxCDPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_turbo_grafx_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunnerFactory**
games_turbo_grafx_cd_plugin_real_get_runner_factories (GamesPlugin* base,
                                                       gint* result_length1)
{
	GamesTurboGrafxCDPlugin * self;
	GamesRetroRunnerFactory* factory = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroRunnerFactory* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesTurboGrafxCDPlugin*) base;
	_tmp0_ = games_turbo_grafx_cd_plugin_platform;
	_tmp1_ = games_retro_runner_factory_new (_tmp0_);
	factory = _tmp1_;
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static GamesGame*
games_turbo_grafx_cd_plugin_game_for_uri (GamesUri* uri,
                                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GamesUid* uid = NULL;
	GamesUid* _tmp7_;
	GamesFilenameTitle* title = NULL;
	GamesFilenameTitle* _tmp8_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp9_;
	GamesGriloMedia* _tmp10_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp11_;
	GamesGriloMedia* _tmp12_;
	GamesUid* _tmp13_;
	GamesGriloCover* _tmp14_;
	GamesCover** _tmp15_;
	GamesCover** _tmp16_;
	gint _tmp16__length1;
	GamesCompositeCover* _tmp17_;
	GamesCompositeCover* _tmp18_;
	GamesGame* game = NULL;
	GamesUid* _tmp19_;
	GamesFilenameTitle* _tmp20_;
	GamesRetroPlatform* _tmp21_;
	GamesGame* _tmp22_;
	GamesGame* _tmp23_;
	GamesCompositeCover* _tmp24_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_turbo_grafx_cd_plugin_is_valid_disc (uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = games_uri_to_string (uri);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GAMES_TURBO_GRAFX_CD_ERROR, GAMES_TURBO_GRAFX_CD_ERROR_INVALID_DISC, "“%s” isn’t a valid TurboGrafx-CD disc.", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp6_ = games_fingerprint_get_uid (uri, GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_UID_PREFIX, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = games_uid_new (_tmp5_);
	uid = _tmp7_;
	_tmp8_ = games_filename_title_new (uri);
	title = _tmp8_;
	_tmp9_ = title;
	_tmp10_ = games_grilo_media_new ((GamesTitle*) _tmp9_, GAMES_TURBO_GRAFX_CD_PLUGIN_PHONY_MIME_TYPE);
	media = _tmp10_;
	_tmp11_ = games_local_cover_new (uri);
	_tmp12_ = media;
	_tmp13_ = uid;
	_tmp14_ = games_grilo_cover_new (_tmp12_, _tmp13_);
	_tmp15_ = g_new0 (GamesCover*, 2 + 1);
	_tmp15_[0] = (GamesCover*) _tmp11_;
	_tmp15_[1] = (GamesCover*) _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	_tmp17_ = games_composite_cover_new (_tmp16_, 2);
	_tmp18_ = _tmp17_;
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp18_;
	_tmp19_ = uid;
	_tmp20_ = title;
	_tmp21_ = games_turbo_grafx_cd_plugin_platform;
	_tmp22_ = games_game_new (_tmp19_, uri, (GamesTitle*) _tmp20_, (GamesPlatform*) _tmp21_);
	game = _tmp22_;
	_tmp23_ = game;
	_tmp24_ = cover;
	games_game_set_cover (_tmp23_, (GamesCover*) _tmp24_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (_tmp5_);
	return result;
}

static gboolean
games_turbo_grafx_cd_plugin_is_valid_disc (GamesUri* uri,
                                           GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* file_info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* bin_file = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	gchar* path = NULL;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gsize* offsets = NULL;
	const gchar* _tmp31_;
	gint _tmp32_ = 0;
	gsize* _tmp33_;
	gint offsets_length1;
	gint _offsets_size_;
	gsize* _tmp34_;
	gint _tmp34__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return _tmp3_;
	}
	_tmp4_ = file_info;
	_tmp5_ = g_file_info_get_content_type (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	mime_type = _tmp6_;
	_tmp7_ = mime_type;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string (GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GamesCueSheet* cue = NULL;
				GFile* _tmp11_;
				GamesCueSheet* _tmp12_;
				GamesCueSheet* _tmp14_;
				guint _tmp15_;
				guint _tmp16_;
				GamesCueSheetTrackNode* track = NULL;
				GamesCueSheet* _tmp17_;
				GamesCueSheetTrackNode* _tmp18_;
				GamesCueSheetTrackNode* _tmp20_;
				GamesCueSheetTrackMode _tmp21_;
				GamesCueSheetTrackMode _tmp22_;
				GamesCueSheetTrackNode* _tmp23_;
				GamesCueSheetFileNode* _tmp24_;
				GamesCueSheetFileNode* _tmp25_;
				GFile* _tmp26_;
				GFile* _tmp27_;
				GFile* _tmp28_;
				_tmp11_ = file;
				_tmp12_ = games_cue_sheet_new (_tmp11_, &_inner_error0_);
				cue = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp13_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return _tmp13_;
				}
				_tmp14_ = cue;
				_tmp15_ = games_cue_sheet_get_tracks_number (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ < ((guint) 2)) {
					result = FALSE;
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return result;
				}
				_tmp17_ = cue;
				_tmp18_ = games_cue_sheet_get_track (_tmp17_, (guint) 1, &_inner_error0_);
				track = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp19_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return _tmp19_;
				}
				_tmp20_ = track;
				_tmp21_ = games_cue_sheet_track_node_get_track_mode (_tmp20_);
				_tmp22_ = _tmp21_;
				if (!games_cue_sheet_track_mode_is_mode1 (_tmp22_)) {
					result = FALSE;
					_g_object_unref0 (track);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return result;
				}
				_tmp23_ = track;
				_tmp24_ = games_cue_sheet_track_node_get_file (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = games_cue_sheet_file_node_get_file (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp28_;
				_g_object_unref0 (track);
				_g_object_unref0 (cue);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return result;
			}
		}
	}
	_tmp29_ = bin_file;
	_tmp30_ = g_file_get_path (_tmp29_);
	path = _tmp30_;
	_tmp31_ = path;
	_tmp33_ = games_grep_get_offsets (_tmp31_, GAMES_TURBO_GRAFX_CD_PLUGIN_CD_MAGIC_VALUE, &_tmp32_);
	offsets = _tmp33_;
	offsets_length1 = _tmp32_;
	_offsets_size_ = offsets_length1;
	_tmp34_ = offsets;
	_tmp34__length1 = offsets_length1;
	result = _tmp34__length1 > 0;
	offsets = (g_free (offsets), NULL);
	_g_free0 (path);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	return result;
}

GamesTurboGrafxCDPlugin*
games_turbo_grafx_cd_plugin_construct (GType object_type)
{
	GamesTurboGrafxCDPlugin * self = NULL;
	self = (GamesTurboGrafxCDPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesTurboGrafxCDPlugin*
games_turbo_grafx_cd_plugin_new (void)
{
	return games_turbo_grafx_cd_plugin_construct (GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN);
}

static void
games_turbo_grafx_cd_plugin_class_init (GamesTurboGrafxCDPluginClass * klass,
                                        gpointer klass_data)
{
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint mime_types_length1;
	gint _mime_types_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GamesRetroPlatform* _tmp4_;
	games_turbo_grafx_cd_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_turbo_grafx_cd_plugin_finalize;
	_tmp0_ = g_strdup (GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_strdup (GAMES_TURBO_GRAFX_CD_PLUGIN_PHONY_MIME_TYPE);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	mime_types = _tmp2_;
	mime_types_length1 = 2;
	_mime_types_size_ = mime_types_length1;
	_tmp3_ = mime_types;
	_tmp3__length1 = mime_types_length1;
	_tmp4_ = games_retro_platform_new (GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_ID, GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_NAME, _tmp3_, _tmp3__length1, GAMES_TURBO_GRAFX_CD_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_turbo_grafx_cd_plugin_platform);
	games_turbo_grafx_cd_plugin_platform = _tmp4_;
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
}

static void
games_turbo_grafx_cd_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                         gpointer iface_data)
{
	games_turbo_grafx_cd_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_turbo_grafx_cd_plugin_real_get_platforms;
	iface->get_mime_types = (gchar** (*) (GamesPlugin*, gint*)) games_turbo_grafx_cd_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_turbo_grafx_cd_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_turbo_grafx_cd_plugin_real_get_runner_factories;
}

static void
games_turbo_grafx_cd_plugin_instance_init (GamesTurboGrafxCDPlugin * self,
                                           gpointer klass)
{
}

static void
games_turbo_grafx_cd_plugin_finalize (GObject * obj)
{
	GamesTurboGrafxCDPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPlugin);
	G_OBJECT_CLASS (games_turbo_grafx_cd_plugin_parent_class)->finalize (obj);
}

GType
games_turbo_grafx_cd_plugin_get_type (void)
{
	return games_turbo_grafx_cd_plugin_type_id;
}

GType
games_turbo_grafx_cd_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesTurboGrafxCDPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_turbo_grafx_cd_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesTurboGrafxCDPlugin), 0, (GInstanceInitFunc) games_turbo_grafx_cd_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_turbo_grafx_cd_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_turbo_grafx_cd_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesTurboGrafxCDPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_turbo_grafx_cd_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_turbo_grafx_cd_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_turbo_grafx_cd_plugin_register_type (module);
	result = GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

