/* contacts-qr-code-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-qr-code-dialog.vala, do not modify */

/*
 * Copyright (C) 2018 Elias Entrup <elias-git@flump.de>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <folks/folks.h>
#include <glib.h>
#include <gio/gio.h>
#include "contacts.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <qrencode.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_QR_CODE_DIALOG (contacts_qr_code_dialog_get_type ())
#define CONTACTS_QR_CODE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialog))
#define CONTACTS_QR_CODE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialogClass))
#define CONTACTS_IS_QR_CODE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_QR_CODE_DIALOG))
#define CONTACTS_IS_QR_CODE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_QR_CODE_DIALOG))
#define CONTACTS_QR_CODE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialogClass))

typedef struct _ContactsQrCodeDialog ContactsQrCodeDialog;
typedef struct _ContactsQrCodeDialogClass ContactsQrCodeDialogClass;
typedef struct _ContactsQrCodeDialogPrivate ContactsQrCodeDialogPrivate;
enum  {
	CONTACTS_QR_CODE_DIALOG_0_PROPERTY,
	CONTACTS_QR_CODE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* contacts_qr_code_dialog_properties[CONTACTS_QR_CODE_DIALOG_NUM_PROPERTIES];
typedef struct _Block30Data Block30Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _QRcode_free0(var) ((var == NULL) ? NULL : (var = (QRcode_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _ContactsQrCodeDialog {
	AdwDialog parent_instance;
	ContactsQrCodeDialogPrivate * priv;
};

struct _ContactsQrCodeDialogClass {
	AdwDialogClass parent_class;
};

struct _ContactsQrCodeDialogPrivate {
	GtkPicture* qr_image;
	GtkLabel* qr_subtitle;
};

struct _Block30Data {
	int _ref_count_;
	ContactsQrCodeDialog* self;
	GMemoryOutputStream* stringstream;
	ContactsIoVCardExportOperation* op;
};

static gint ContactsQrCodeDialog_private_offset;
static gpointer contacts_qr_code_dialog_parent_class = NULL;

VALA_EXTERN GType contacts_qr_code_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsQrCodeDialog, g_object_unref)
VALA_EXTERN ContactsQrCodeDialog* contacts_qr_code_dialog_new_for_contact (FolksIndividual* individual);
VALA_EXTERN ContactsQrCodeDialog* contacts_qr_code_dialog_construct_for_contact (GType object_type,
                                                                     FolksIndividual* individual);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda43_ (Block30Data* _data30_,
                  GObject* obj,
                  GAsyncResult* res);
static void contacts_qr_code_dialog_create_qr_code (ContactsQrCodeDialog* self,
                                             const gchar* content,
                                             gint size);
static void ___lambda43__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void contacts_qr_code_dialog_fill_pixel (ContactsQrCodeDialog* self,
                                         GByteArray* array,
                                         guint8 val,
                                         gint pixel_size);
VALA_EXTERN ContactsQrCodeDialog* contacts_qr_code_dialog_new (void);
VALA_EXTERN ContactsQrCodeDialog* contacts_qr_code_dialog_construct (GType object_type);
static void contacts_qr_code_dialog_finalize (GObject * obj);
static GType contacts_qr_code_dialog_get_type_once (void);

static inline gpointer
contacts_qr_code_dialog_get_instance_private (ContactsQrCodeDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsQrCodeDialog_private_offset);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		ContactsQrCodeDialog* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->op);
		_g_object_unref0 (_data30_->stringstream);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
__lambda43_ (Block30Data* _data30_,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsQrCodeDialog* self;
	gchar* content = NULL;
	guint8* _tmp4_;
	gint QR_IMAGE_SIZE = 0;
	gint scale = 0;
	GtkPicture* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = _data30_->self;
	g_return_if_fail (res != NULL);
	{
		guint8* chars = NULL;
		guint8* _tmp0_;
		gint chars_length1;
		gint _chars_size_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		contacts_operation_execute_finish ((ContactsOperation*) _data30_->op, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = g_new0 (guint8, 1);
		_tmp0_[0] = (guint8) 0;
		chars = _tmp0_;
		chars_length1 = 1;
		_chars_size_ = chars_length1;
		_tmp1_ = chars;
		_tmp1__length1 = chars_length1;
		g_output_stream_write ((GOutputStream*) _data30_->stringstream, _tmp1_, (gsize) _tmp1__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch0_g_error;
		}
		g_output_stream_close ((GOutputStream*) _data30_->stringstream, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch0_g_error;
		}
		chars = (g_free (chars), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("contacts-qr-code-dialog.vala:36: ERROR: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = g_memory_output_stream_steal_data (_data30_->stringstream);
	content = (gchar*) _tmp4_;
	QR_IMAGE_SIZE = 300;
	_tmp5_ = self->priv->qr_image;
	scale = gtk_widget_get_scale_factor ((GtkWidget*) _tmp5_);
	contacts_qr_code_dialog_create_qr_code (self, content, QR_IMAGE_SIZE * scale);
	_g_free0 (content);
}

static void
___lambda43__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda43_ (self, source_object, res);
	block30_data_unref (self);
}

ContactsQrCodeDialog*
contacts_qr_code_dialog_construct_for_contact (GType object_type,
                                               FolksIndividual* individual)
{
	ContactsQrCodeDialog * self = NULL;
	Block30Data* _data30_;
	gchar* subtitle = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GeeArrayList* individuals = NULL;
	GeeArrayList* _tmp4_;
	GMemoryOutputStream* _tmp5_;
	ContactsIoVCardExportOperation* _tmp6_;
	g_return_val_if_fail (individual != NULL, NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	self = (ContactsQrCodeDialog*) g_object_new (object_type, NULL);
	_data30_->self = g_object_ref (self);
	_tmp0_ = folks_individual_get_display_name (individual);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_markup_printf_escaped (_ ("Scan the QR code to save the contact <b>%s</b>."), _tmp1_);
	subtitle = _tmp2_;
	_tmp3_ = self->priv->qr_subtitle;
	gtk_label_set_markup (_tmp3_, subtitle);
	_tmp4_ = gee_array_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	individuals = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) individuals, individual);
	_tmp5_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
	_data30_->stringstream = _tmp5_;
	_tmp6_ = contacts_io_vcard_export_operation_new ((GeeList*) individuals, (GOutputStream*) _data30_->stringstream);
	_data30_->op = _tmp6_;
	contacts_operation_execute ((ContactsOperation*) _data30_->op, ___lambda43__gasync_ready_callback, block30_data_ref (_data30_));
	_g_object_unref0 (individuals);
	_g_free0 (subtitle);
	block30_data_unref (_data30_);
	_data30_ = NULL;
	return self;
}

ContactsQrCodeDialog*
contacts_qr_code_dialog_new_for_contact (FolksIndividual* individual)
{
	return contacts_qr_code_dialog_construct_for_contact (CONTACTS_TYPE_QR_CODE_DIALOG, individual);
}

static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

static void
contacts_qr_code_dialog_create_qr_code (ContactsQrCodeDialog* self,
                                        const gchar* content,
                                        gint size)
{
	QRcode* _result_ = NULL;
	QRcode* _tmp0_;
	QRcode* _tmp1_;
	gint qr_size = 0;
	QRcode* _tmp2_;
	gint pixel_size = 0;
	gint total_size = 0;
	gint BYTES_PER_R8G8B8 = 0;
	GByteArray* qr_matrix = NULL;
	GByteArray* _tmp3_;
	GBytes* bytes = NULL;
	GByteArray* _tmp15_;
	GByteArray* _tmp16_;
	GBytes* _tmp17_;
	GdkMemoryTexture* paintable = NULL;
	GBytes* _tmp18_;
	GdkMemoryTexture* _tmp19_;
	GtkPicture* _tmp20_;
	GdkMemoryTexture* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	if (g_strcmp0 (content, "") == 0) {
		g_warning ("contacts-qr-code-dialog.vala:48: Failed to create QR code: no content");
		return;
	}
	_tmp0_ = QRcode_encodeString (content, 0, QR_ECLEVEL_M, QR_MODE_8, 1);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ == NULL) {
		g_warning ("contacts-qr-code-dialog.vala:58: Failed to create QR code: libqrencode" \
" error");
		_QRcode_free0 (_result_);
		return;
	}
	_tmp2_ = _result_;
	qr_size = _tmp2_->width;
	pixel_size = (gint) MAX ((gdouble) 1, (gdouble) (size / qr_size));
	total_size = qr_size * pixel_size;
	BYTES_PER_R8G8B8 = 3;
	_tmp3_ = g_byte_array_sized_new ((guint) (((total_size * total_size) * pixel_size) * BYTES_PER_R8G8B8));
	qr_matrix = _tmp3_;
	{
		gint column = 0;
		column = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = column;
					column = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(column < total_size)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = i;
								i = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							if (!(i < pixel_size)) {
								break;
							}
							{
								gint row = 0;
								row = 0;
								{
									gboolean _tmp8_ = FALSE;
									_tmp8_ = TRUE;
									while (TRUE) {
										QRcode* _tmp10_;
										guint8* _tmp11_;
										gint _tmp11__length1;
										guint8 _tmp12_;
										if (!_tmp8_) {
											gint _tmp9_;
											_tmp9_ = row;
											row = _tmp9_ + 1;
										}
										_tmp8_ = FALSE;
										if (!(row < (total_size / pixel_size))) {
											break;
										}
										_tmp10_ = _result_;
										_tmp11_ = _tmp10_->data;
										_tmp11__length1 = -1;
										_tmp12_ = _tmp11_[(qr_size * row) + column];
										if (((gint) (_tmp12_ & 0x01)) > 0) {
											GByteArray* _tmp13_;
											_tmp13_ = qr_matrix;
											contacts_qr_code_dialog_fill_pixel (self, _tmp13_, (guint8) 0x00, pixel_size);
										} else {
											GByteArray* _tmp14_;
											_tmp14_ = qr_matrix;
											contacts_qr_code_dialog_fill_pixel (self, _tmp14_, (guint8) 0xff, pixel_size);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp15_ = qr_matrix;
	_tmp16_ = _g_byte_array_ref0 (_tmp15_);
	_tmp17_ = g_byte_array_free_to_bytes (_tmp16_);
	bytes = _tmp17_;
	_tmp18_ = bytes;
	_tmp19_ = (GdkMemoryTexture*) gdk_memory_texture_new (total_size, total_size, GDK_MEMORY_R8G8B8, _tmp18_, (gsize) (total_size * BYTES_PER_R8G8B8));
	paintable = _tmp19_;
	_tmp20_ = self->priv->qr_image;
	_tmp21_ = paintable;
	gtk_picture_set_paintable (_tmp20_, (GdkPaintable*) _tmp21_);
	_g_object_unref0 (paintable);
	_g_bytes_unref0 (bytes);
	_g_byte_array_unref0 (qr_matrix);
	_QRcode_free0 (_result_);
}

static void
contacts_qr_code_dialog_fill_pixel (ContactsQrCodeDialog* self,
                                    GByteArray* array,
                                    guint8 val,
                                    gint pixel_size)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (array != NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8* _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				guint8* _tmp4_;
				guint8* _tmp5_;
				gint _tmp5__length1;
				guint8* _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((guint) pixel_size))) {
					break;
				}
				_tmp2_ = g_new0 (guint8, 1);
				_tmp2_[0] = val;
				_tmp3_ = _tmp2_;
				_tmp3__length1 = 1;
				g_byte_array_append (array, _tmp3_, (gint) 1);
				_tmp3_ = (g_free (_tmp3_), NULL);
				_tmp4_ = g_new0 (guint8, 1);
				_tmp4_[0] = val;
				_tmp5_ = _tmp4_;
				_tmp5__length1 = 1;
				g_byte_array_append (array, _tmp5_, (gint) 1);
				_tmp5_ = (g_free (_tmp5_), NULL);
				_tmp6_ = g_new0 (guint8, 1);
				_tmp6_[0] = val;
				_tmp7_ = _tmp6_;
				_tmp7__length1 = 1;
				g_byte_array_append (array, _tmp7_, (gint) 1);
				_tmp7_ = (g_free (_tmp7_), NULL);
			}
		}
	}
}

ContactsQrCodeDialog*
contacts_qr_code_dialog_construct (GType object_type)
{
	ContactsQrCodeDialog * self = NULL;
	self = (ContactsQrCodeDialog*) g_object_new (object_type, NULL);
	return self;
}

ContactsQrCodeDialog*
contacts_qr_code_dialog_new (void)
{
	return contacts_qr_code_dialog_construct (CONTACTS_TYPE_QR_CODE_DIALOG);
}

static void
contacts_qr_code_dialog_class_init (ContactsQrCodeDialogClass * klass,
                                    gpointer klass_data)
{
	contacts_qr_code_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsQrCodeDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contacts_qr_code_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-qr-code-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "qr_image", FALSE, ContactsQrCodeDialog_private_offset + G_STRUCT_OFFSET (ContactsQrCodeDialogPrivate, qr_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "qr_subtitle", FALSE, ContactsQrCodeDialog_private_offset + G_STRUCT_OFFSET (ContactsQrCodeDialogPrivate, qr_subtitle));
}

static void
contacts_qr_code_dialog_instance_init (ContactsQrCodeDialog * self,
                                       gpointer klass)
{
	self->priv = contacts_qr_code_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_qr_code_dialog_finalize (GObject * obj)
{
	ContactsQrCodeDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialog);
	G_OBJECT_CLASS (contacts_qr_code_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_qr_code_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsQrCodeDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_qr_code_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsQrCodeDialog), 0, (GInstanceInitFunc) contacts_qr_code_dialog_instance_init, NULL };
	GType contacts_qr_code_dialog_type_id;
	contacts_qr_code_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "ContactsQrCodeDialog", &g_define_type_info, 0);
	ContactsQrCodeDialog_private_offset = g_type_add_instance_private (contacts_qr_code_dialog_type_id, sizeof (ContactsQrCodeDialogPrivate));
	return contacts_qr_code_dialog_type_id;
}

GType
contacts_qr_code_dialog_get_type (void)
{
	static volatile gsize contacts_qr_code_dialog_type_id__once = 0;
	if (g_once_init_enter (&contacts_qr_code_dialog_type_id__once)) {
		GType contacts_qr_code_dialog_type_id;
		contacts_qr_code_dialog_type_id = contacts_qr_code_dialog_get_type_once ();
		g_once_init_leave (&contacts_qr_code_dialog_type_id__once, contacts_qr_code_dialog_type_id);
	}
	return contacts_qr_code_dialog_type_id__once;
}

