/* geocoding.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geocoding.vala, do not modify */

/*
 * Copyright (C) 2013  Evgeny Bobkin <evgen.ibqn@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <geoclue.h>
#include <libgweather/gweather.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include "config.h"
#include <geocode-glib/geocode-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_GEO_TYPE_INFO (clocks_geo_info_get_type ())
#define CLOCKS_GEO_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo))
#define CLOCKS_GEO_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))
#define CLOCKS_GEO_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))

typedef struct _ClocksGeoInfo ClocksGeoInfo;
typedef struct _ClocksGeoInfoClass ClocksGeoInfoClass;
typedef struct _ClocksGeoInfoPrivate ClocksGeoInfoPrivate;
enum  {
	CLOCKS_GEO_INFO_0_PROPERTY,
	CLOCKS_GEO_INFO_GEO_LOCATION_PROPERTY,
	CLOCKS_GEO_INFO_NUM_PROPERTIES
};
static GParamSpec* clocks_geo_info_properties[CLOCKS_GEO_INFO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ClocksGeoInfoSeekData ClocksGeoInfoSeekData;
typedef struct _ClocksGeoInfoOnLocationUpdatedData ClocksGeoInfoOnLocationUpdatedData;
typedef struct _ClocksGeoInfoSeekCountryCodeData ClocksGeoInfoSeekCountryCodeData;
typedef struct _ClocksGeoInfoSearchLocationsData ClocksGeoInfoSearchLocationsData;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
enum  {
	CLOCKS_GEO_INFO_LOCATION_CHANGED_SIGNAL,
	CLOCKS_GEO_INFO_NUM_SIGNALS
};
static guint clocks_geo_info_signals[CLOCKS_GEO_INFO_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ClocksGeoInfo {
	GObject parent_instance;
	ClocksGeoInfoPrivate * priv;
};

struct _ClocksGeoInfoClass {
	GObjectClass parent_class;
};

struct _ClocksGeoInfoPrivate {
	GClueLocation* _geo_location;
	GWeatherLocation* found_location;
	gchar* country_code;
	GClueSimple* simple;
	gdouble minimal_distance;
};

struct _ClocksGeoInfoSeekData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksGeoInfo* self;
	GClueSimple* _tmp0_;
	GClueSimple* _tmp1_;
	GClueSimple* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GClueSimple* _tmp5_;
	GError* _inner_error0_;
};

struct _ClocksGeoInfoOnLocationUpdatedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksGeoInfo* self;
	GClueSimple* _tmp0_;
	GClueLocation* _tmp1_;
	GWeatherLocation* _tmp2_;
	GWeatherLocation* _tmp3_;
	GWeatherLocation* _tmp4_;
	GWeatherLocation* _tmp5_;
};

struct _ClocksGeoInfoSeekCountryCodeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksGeoInfo* self;
	GClueLocation* _tmp0_;
	GeocodeLocation* location;
	GClueLocation* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GClueLocation* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GeocodeLocation* _tmp7_;
	GeocodeReverse* reverse;
	GeocodeReverse* _tmp8_;
	GeocodePlace* place;
	GeocodePlace* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _ClocksGeoInfoSearchLocationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksGeoInfo* self;
	GWeatherLocation* location;
	GClueLocation* _tmp0_;
	const gchar* _tmp1_;
	gchar* loc_country_code;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GWeatherLocation* loc;
	GWeatherLocation* _tmp7_;
	GWeatherLocation* _tmp8_;
	GWeatherLocation* _tmp9_;
	GWeatherLocation* _tmp10_;
	gdouble latitude;
	gdouble longitude;
	gdouble distance;
	GWeatherLocation* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	GClueLocation* _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	GClueLocation* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	GWeatherLocation* _tmp20_;
	GWeatherLocation* _tmp21_;
	GWeatherLocation* _tmp22_;
	GWeatherLocation* _tmp23_;
	GWeatherLocation* _tmp24_;
	GWeatherLocation* _tmp25_;
};

static gint ClocksGeoInfo_private_offset;
static gpointer clocks_geo_info_parent_class = NULL;

VALA_EXTERN GType clocks_geo_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksGeoInfo, g_object_unref)
VALA_EXTERN ClocksGeoInfo* clocks_geo_info_new (void);
VALA_EXTERN ClocksGeoInfo* clocks_geo_info_construct (GType object_type);
static void clocks_geo_info_seek_data_free (gpointer _data);
VALA_EXTERN void clocks_geo_info_seek (ClocksGeoInfo* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN void clocks_geo_info_seek_finish (ClocksGeoInfo* self,
                                  GAsyncResult* _res_);
static gboolean clocks_geo_info_seek_co (ClocksGeoInfoSeekData* _data_);
static void clocks_geo_info_seek_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void __lambda15_ (ClocksGeoInfo* self);
VALA_EXTERN void clocks_geo_info_on_location_updated (ClocksGeoInfo* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void clocks_geo_info_on_location_updated_finish (ClocksGeoInfo* self,
                                                 GAsyncResult* _res_);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void clocks_geo_info_on_location_updated_data_free (gpointer _data);
static gboolean clocks_geo_info_on_location_updated_co (ClocksGeoInfoOnLocationUpdatedData* _data_);
static void clocks_geo_info_set_geo_location (ClocksGeoInfo* self,
                                       GClueLocation* value);
static void clocks_geo_info_seek_country_code (ClocksGeoInfo* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void clocks_geo_info_seek_country_code_finish (ClocksGeoInfo* self,
                                               GAsyncResult* _res_);
static void clocks_geo_info_on_location_updated_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void clocks_geo_info_search_locations (ClocksGeoInfo* self,
                                       GWeatherLocation* location,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void clocks_geo_info_search_locations_finish (ClocksGeoInfo* self,
                                              GAsyncResult* _res_);
static void clocks_geo_info_seek_country_code_data_free (gpointer _data);
static gboolean clocks_geo_info_seek_country_code_co (ClocksGeoInfoSeekCountryCodeData* _data_);
VALA_EXTERN GClueLocation* clocks_geo_info_get_geo_location (ClocksGeoInfo* self);
static void clocks_geo_info_seek_country_code_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static gdouble clocks_geo_info_deg_to_rad (ClocksGeoInfo* self,
                                    gdouble deg);
static gdouble clocks_geo_info_get_distance (ClocksGeoInfo* self,
                                      gdouble latitude1,
                                      gdouble longitude1,
                                      gdouble latitude2,
                                      gdouble longitude2);
static void clocks_geo_info_search_locations_data_free (gpointer _data);
static gboolean clocks_geo_info_search_locations_co (ClocksGeoInfoSearchLocationsData* _data_);
static void clocks_geo_info_search_locations_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN gboolean clocks_geo_info_is_location_similar (ClocksGeoInfo* self,
                                              GWeatherLocation* location);
static void clocks_geo_info_finalize (GObject * obj);
static GType clocks_geo_info_get_type_once (void);
static void _vala_clocks_geo_info_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_clocks_geo_info_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
clocks_geo_info_get_instance_private (ClocksGeoInfo* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksGeoInfo_private_offset);
}

ClocksGeoInfo*
clocks_geo_info_construct (GType object_type)
{
	ClocksGeoInfo * self = NULL;
	self = (ClocksGeoInfo*) g_object_new (object_type, NULL);
	_g_free0 (self->priv->country_code);
	self->priv->country_code = NULL;
	_g_object_unref0 (self->priv->found_location);
	self->priv->found_location = NULL;
	self->priv->minimal_distance = 1000.0;
	return self;
}

ClocksGeoInfo*
clocks_geo_info_new (void)
{
	return clocks_geo_info_construct (CLOCKS_GEO_TYPE_INFO);
}

static void
clocks_geo_info_seek_data_free (gpointer _data)
{
	ClocksGeoInfoSeekData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSeekData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
clocks_geo_info_seek (ClocksGeoInfo* self,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	ClocksGeoInfoSeekData* _data_;
	ClocksGeoInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksGeoInfoSeekData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_geo_info_seek_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_seek_co (_data_);
}

void
clocks_geo_info_seek_finish (ClocksGeoInfo* self,
                             GAsyncResult* _res_)
{
	ClocksGeoInfoSeekData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
clocks_geo_info_seek_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	ClocksGeoInfoSeekData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_seek_co (_data_);
}

static void
__lambda15_ (ClocksGeoInfo* self)
{
	clocks_geo_info_on_location_updated (self, NULL, NULL);
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ ((ClocksGeoInfo*) self);
}

static gboolean
clocks_geo_info_seek_co (ClocksGeoInfoSeekData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		gclue_simple_new (APP_ID, GCLUE_ACCURACY_LEVEL_CITY, NULL, clocks_geo_info_seek_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = gclue_simple_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->simple);
		_data_->self->priv->simple = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("geocoding.vala:42: Failed to connect to GeoClue2 service: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->simple;
	g_signal_connect_object ((GObject*) _data_->_tmp5_, "notify::location", (GCallback) ___lambda15__g_object_notify, _data_->self, 0);
	clocks_geo_info_on_location_updated (_data_->self, NULL, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
clocks_geo_info_on_location_updated_data_free (gpointer _data)
{
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoOnLocationUpdatedData, _data_);
}

void
clocks_geo_info_on_location_updated (ClocksGeoInfo* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	ClocksGeoInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksGeoInfoOnLocationUpdatedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_geo_info_on_location_updated_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_on_location_updated_co (_data_);
}

void
clocks_geo_info_on_location_updated_finish (ClocksGeoInfo* self,
                                            GAsyncResult* _res_)
{
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
clocks_geo_info_on_location_updated_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_on_location_updated_co (_data_);
}

static gboolean
clocks_geo_info_on_location_updated_co (ClocksGeoInfoOnLocationUpdatedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->simple;
	_data_->_tmp1_ = gclue_simple_get_location (_data_->_tmp0_);
	clocks_geo_info_set_geo_location (_data_->self, _data_->_tmp1_);
	_data_->_state_ = 1;
	clocks_geo_info_seek_country_code (_data_->self, clocks_geo_info_on_location_updated_ready, _data_);
	return FALSE;
	_state_1:
	clocks_geo_info_seek_country_code_finish (_data_->self, _data_->_res_);
	_data_->_tmp2_ = gweather_location_get_world ();
	_data_->_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gweather_location_get_type (), GWeatherLocation);
	_data_->_state_ = 2;
	clocks_geo_info_search_locations (_data_->self, _data_->_tmp3_, clocks_geo_info_on_location_updated_ready, _data_);
	return FALSE;
	_state_2:
	clocks_geo_info_search_locations_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->found_location;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->found_location;
		g_signal_emit (_data_->self, clocks_geo_info_signals[CLOCKS_GEO_INFO_LOCATION_CHANGED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gweather_location_get_type (), GWeatherLocation));
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
clocks_geo_info_seek_country_code_data_free (gpointer _data)
{
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSeekCountryCodeData, _data_);
}

static void
clocks_geo_info_seek_country_code (ClocksGeoInfo* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ClocksGeoInfoSeekCountryCodeData* _data_;
	ClocksGeoInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksGeoInfoSeekCountryCodeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_geo_info_seek_country_code_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_seek_country_code_co (_data_);
}

static void
clocks_geo_info_seek_country_code_finish (ClocksGeoInfo* self,
                                          GAsyncResult* _res_)
{
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
clocks_geo_info_seek_country_code_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_seek_country_code_co (_data_);
}

static gboolean
clocks_geo_info_seek_country_code_co (ClocksGeoInfoSeekCountryCodeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_geo_location;
	_vala_return_val_if_fail (_data_->_tmp0_ != NULL, "geo_location != null", FALSE);
	_data_->_tmp1_ = _data_->self->priv->_geo_location;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, gclue_location_get_type (), GClueLocation), "latitude", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->self->priv->_geo_location;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gclue_location_get_type (), GClueLocation), "longitude", &_data_->_tmp5_, NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = geocode_location_new (_data_->_tmp3_, _data_->_tmp6_, (gdouble) GEOCODE_LOCATION_ACCURACY_UNKNOWN);
	_data_->location = _data_->_tmp7_;
	_data_->_tmp8_ = geocode_reverse_new_for_location (_data_->location);
	_data_->reverse = _data_->_tmp8_;
	{
		_data_->_state_ = 1;
		geocode_reverse_resolve_async (_data_->reverse, NULL, clocks_geo_info_seek_country_code_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = geocode_reverse_resolve_finish (_data_->reverse, _data_->_res_, &_data_->_inner_error0_);
		_data_->place = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = geocode_place_get_country_code (_data_->place);
		_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
		_g_free0 (_data_->self->priv->country_code);
		_data_->self->priv->country_code = _data_->_tmp11_;
		_g_object_unref0 (_data_->place);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("geocoding.vala:75: Failed to obtain country code: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->reverse);
		_g_object_unref0 (_data_->location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->reverse);
	_g_object_unref0 (_data_->location);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gdouble
clocks_geo_info_deg_to_rad (ClocksGeoInfo* self,
                            gdouble deg)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = (G_PI / 180.0) * deg;
	return result;
}

static gdouble
clocks_geo_info_get_distance (ClocksGeoInfo* self,
                              gdouble latitude1,
                              gdouble longitude1,
                              gdouble latitude2,
                              gdouble longitude2)
{
	static const gdouble EARTH_RADIUS = 6372.795;
	gdouble lat1 = 0.0;
	gdouble lat2 = 0.0;
	gdouble lon1 = 0.0;
	gdouble lon2 = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	lat1 = clocks_geo_info_deg_to_rad (self, latitude1);
	lat2 = clocks_geo_info_deg_to_rad (self, latitude2);
	lon1 = clocks_geo_info_deg_to_rad (self, longitude1);
	lon2 = clocks_geo_info_deg_to_rad (self, longitude2);
	result = acos (((cos (lat1) * cos (lat2)) * cos (lon1 - lon2)) + (sin (lat1) * sin (lat2))) * EARTH_RADIUS;
	return result;
}

static void
clocks_geo_info_search_locations_data_free (gpointer _data)
{
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->location);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSearchLocationsData, _data_);
}

static void
clocks_geo_info_search_locations (ClocksGeoInfo* self,
                                  GWeatherLocation* location,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ClocksGeoInfoSearchLocationsData* _data_;
	ClocksGeoInfo* _tmp0_;
	GWeatherLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data_ = g_slice_new0 (ClocksGeoInfoSearchLocationsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_geo_info_search_locations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp1_;
	clocks_geo_info_search_locations_co (_data_);
}

static void
clocks_geo_info_search_locations_finish (ClocksGeoInfo* self,
                                         GAsyncResult* _res_)
{
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
clocks_geo_info_search_locations_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_search_locations_co (_data_);
}

static gboolean
clocks_geo_info_search_locations_co (ClocksGeoInfoSearchLocationsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_geo_location;
	_vala_return_val_if_fail (_data_->_tmp0_ != NULL, "geo_location != null", FALSE);
	_data_->_tmp1_ = _data_->self->priv->country_code;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = gweather_location_get_country (_data_->location);
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->loc_country_code = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->loc_country_code;
		if (_data_->_tmp4_ != NULL) {
			_data_->_tmp5_ = _data_->loc_country_code;
			_data_->_tmp6_ = _data_->self->priv->country_code;
			if (g_strcmp0 (_data_->_tmp5_, _data_->_tmp6_) != 0) {
				_g_free0 (_data_->loc_country_code);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->loc_country_code);
	}
	_data_->_tmp7_ = gweather_location_next_child (_data_->location, NULL);
	_data_->loc = _data_->_tmp7_;
	while (TRUE) {
		_data_->_tmp8_ = _data_->loc;
		if (!(_data_->_tmp8_ != NULL)) {
			break;
		}
		_data_->_tmp9_ = _data_->loc;
		if (gweather_location_get_level (_data_->_tmp9_) == GWEATHER_LOCATION_CITY) {
			_data_->_tmp10_ = _data_->loc;
			if (gweather_location_has_coords (_data_->_tmp10_)) {
				_data_->_tmp11_ = _data_->loc;
				_data_->_tmp12_ = 0.0;
				_data_->_tmp13_ = 0.0;
				gweather_location_get_coords (_data_->_tmp11_, &_data_->_tmp12_, &_data_->_tmp13_);
				_data_->latitude = _data_->_tmp12_;
				_data_->longitude = _data_->_tmp13_;
				_data_->_tmp14_ = _data_->self->priv->_geo_location;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, gclue_location_get_type (), GClueLocation), "latitude", &_data_->_tmp15_, NULL);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = _data_->self->priv->_geo_location;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, gclue_location_get_type (), GClueLocation), "longitude", &_data_->_tmp18_, NULL);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->distance = clocks_geo_info_get_distance (_data_->self, _data_->_tmp16_, _data_->_tmp19_, _data_->latitude, _data_->longitude);
				if (_data_->distance < _data_->self->priv->minimal_distance) {
					_data_->_tmp20_ = _data_->loc;
					_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
					_g_object_unref0 (_data_->self->priv->found_location);
					_data_->self->priv->found_location = _data_->_tmp21_;
					_data_->self->priv->minimal_distance = _data_->distance;
				}
			}
		}
		_data_->_tmp22_ = _data_->loc;
		_data_->_state_ = 1;
		clocks_geo_info_search_locations (_data_->self, _data_->_tmp22_, clocks_geo_info_search_locations_ready, _data_);
		return FALSE;
		_state_1:
		clocks_geo_info_search_locations_finish (_data_->self, _data_->_res_);
		_data_->_tmp23_ = _data_->loc;
		_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
		_data_->_tmp25_ = gweather_location_next_child (_data_->location, _data_->_tmp24_);
		_g_object_unref0 (_data_->loc);
		_data_->loc = _data_->_tmp25_;
	}
	_g_object_unref0 (_data_->loc);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_time_zone_ref0 (gpointer self)
{
	return self ? g_time_zone_ref (self) : NULL;
}

gboolean
clocks_geo_info_is_location_similar (ClocksGeoInfo* self,
                                     GWeatherLocation* location)
{
	GWeatherLocation* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = self->priv->found_location;
	if (_tmp0_ != NULL) {
		gchar* country_code = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* found_country_code = NULL;
		GWeatherLocation* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp1_ = gweather_location_get_country (location);
		_tmp2_ = g_strdup (_tmp1_);
		country_code = _tmp2_;
		_tmp3_ = self->priv->found_location;
		_tmp4_ = gweather_location_get_country (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gweather_location_get_type (), GWeatherLocation));
		_tmp5_ = g_strdup (_tmp4_);
		found_country_code = _tmp5_;
		_tmp7_ = country_code;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = country_code;
			_tmp9_ = found_country_code;
			_tmp6_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GTimeZone* timezone = NULL;
			GTimeZone* _tmp10_;
			GTimeZone* _tmp11_;
			GTimeZone* found_timezone = NULL;
			GWeatherLocation* _tmp12_;
			GTimeZone* _tmp13_;
			GTimeZone* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GTimeZone* _tmp16_;
			_tmp10_ = gweather_location_get_timezone (location);
			_tmp11_ = _g_time_zone_ref0 (_tmp10_);
			timezone = _tmp11_;
			_tmp12_ = self->priv->found_location;
			_tmp13_ = gweather_location_get_timezone (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gweather_location_get_type (), GWeatherLocation));
			_tmp14_ = _g_time_zone_ref0 (_tmp13_);
			found_timezone = _tmp14_;
			_tmp16_ = timezone;
			if (_tmp16_ != NULL) {
				GTimeZone* _tmp17_;
				_tmp17_ = found_timezone;
				_tmp15_ = _tmp17_ != NULL;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gchar* tzid = NULL;
				GTimeZone* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* found_tzid = NULL;
				GTimeZone* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp18_ = timezone;
				_tmp19_ = g_time_zone_get_identifier (_tmp18_);
				_tmp20_ = g_strdup (_tmp19_);
				tzid = _tmp20_;
				_tmp21_ = found_timezone;
				_tmp22_ = g_time_zone_get_identifier (_tmp21_);
				_tmp23_ = g_strdup (_tmp22_);
				found_tzid = _tmp23_;
				_tmp24_ = tzid;
				_tmp25_ = found_tzid;
				if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
					result = TRUE;
					_g_free0 (found_tzid);
					_g_free0 (tzid);
					_g_time_zone_unref0 (found_timezone);
					_g_time_zone_unref0 (timezone);
					_g_free0 (found_country_code);
					_g_free0 (country_code);
					return result;
				}
				_g_free0 (found_tzid);
				_g_free0 (tzid);
			}
			_g_time_zone_unref0 (found_timezone);
			_g_time_zone_unref0 (timezone);
		}
		_g_free0 (found_country_code);
		_g_free0 (country_code);
	}
	result = FALSE;
	return result;
}

GClueLocation*
clocks_geo_info_get_geo_location (ClocksGeoInfo* self)
{
	GClueLocation* result;
	GClueLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_geo_location;
	result = _tmp0_;
	return result;
}

static void
clocks_geo_info_set_geo_location (ClocksGeoInfo* self,
                                  GClueLocation* value)
{
	GClueLocation* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_geo_info_get_geo_location (self);
	if (old_value != value) {
		GClueLocation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_geo_location);
		self->priv->_geo_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_geo_info_properties[CLOCKS_GEO_INFO_GEO_LOCATION_PROPERTY]);
	}
}

static void
clocks_geo_info_class_init (ClocksGeoInfoClass * klass,
                            gpointer klass_data)
{
	clocks_geo_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksGeoInfo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_geo_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_geo_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_geo_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_GEO_INFO_GEO_LOCATION_PROPERTY, clocks_geo_info_properties[CLOCKS_GEO_INFO_GEO_LOCATION_PROPERTY] = g_param_spec_object ("geo-location", "geo-location", "geo-location", gclue_location_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	clocks_geo_info_signals[CLOCKS_GEO_INFO_LOCATION_CHANGED_SIGNAL] = g_signal_new ("location-changed", CLOCKS_GEO_TYPE_INFO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gweather_location_get_type ());
}

static void
clocks_geo_info_instance_init (ClocksGeoInfo * self,
                               gpointer klass)
{
	self->priv = clocks_geo_info_get_instance_private (self);
	self->priv->_geo_location = NULL;
}

static void
clocks_geo_info_finalize (GObject * obj)
{
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	_g_object_unref0 (self->priv->_geo_location);
	_g_object_unref0 (self->priv->found_location);
	_g_free0 (self->priv->country_code);
	_g_object_unref0 (self->priv->simple);
	G_OBJECT_CLASS (clocks_geo_info_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_geo_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksGeoInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_geo_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksGeoInfo), 0, (GInstanceInitFunc) clocks_geo_info_instance_init, NULL };
	GType clocks_geo_info_type_id;
	clocks_geo_info_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksGeoInfo", &g_define_type_info, 0);
	ClocksGeoInfo_private_offset = g_type_add_instance_private (clocks_geo_info_type_id, sizeof (ClocksGeoInfoPrivate));
	return clocks_geo_info_type_id;
}

GType
clocks_geo_info_get_type (void)
{
	static gsize clocks_geo_info_type_id__once = 0;
	if (g_once_init_enter (&clocks_geo_info_type_id__once)) {
		GType clocks_geo_info_type_id;
		clocks_geo_info_type_id = clocks_geo_info_get_type_once ();
		g_once_init_leave (&clocks_geo_info_type_id__once, clocks_geo_info_type_id);
	}
	return clocks_geo_info_type_id__once;
}

static void
_vala_clocks_geo_info_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	switch (property_id) {
		case CLOCKS_GEO_INFO_GEO_LOCATION_PROPERTY:
		g_value_set_object (value, clocks_geo_info_get_geo_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_geo_info_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	switch (property_id) {
		case CLOCKS_GEO_INFO_GEO_LOCATION_PROPERTY:
		clocks_geo_info_set_geo_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

