/* calls-phone-number-query.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from calls-phone-number-query.vala, do not modify */

/*
 * Copyright (C) 2019 Purism SPC
 *
 * This file is part of Calls.
 *
 * Calls is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Calls is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Calls.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Bob Ham <bob.ham@puri.sm>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

#include "calls-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks/folks.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CALLS_PHONE_NUMBER_QUERY_0_PROPERTY,
	CALLS_PHONE_NUMBER_QUERY_NUM_PROPERTIES
};
static GParamSpec* calls_phone_number_query_properties[CALLS_PHONE_NUMBER_QUERY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_EPhoneNumber_free0(var) ((var == NULL) ? NULL : (var = (_vala_EPhoneNumber_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CallsPhoneNumberQueryPrivate {
	gchar* _number;
	EPhoneNumber* _ephonenumber;
	gchar* _country_code;
};

static gint CallsPhoneNumberQuery_private_offset;
static gpointer calls_phone_number_query_parent_class = NULL;

static void _vala_EPhoneNumber_free (EPhoneNumber* self);
static guint calls_phone_number_query_real_is_match (FolksQuery* base,
                                              FolksIndividual* individual);
static void calls_phone_number_query_finalize (GObject * obj);
static GType calls_phone_number_query_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
calls_phone_number_query_get_instance_private (CallsPhoneNumberQuery* self)
{
	return G_STRUCT_MEMBER_P (self, CallsPhoneNumberQuery_private_offset);
}

static void
_vala_EPhoneNumber_free (EPhoneNumber* self)
{
	g_boxed_free (e_phone_number_get_type (), self);
}

CallsPhoneNumberQuery*
calls_phone_number_query_construct (GType object_type,
                                    const gchar* number,
                                    const gchar* country_code)
{
	CallsPhoneNumberQuery * self = NULL;
	gchar** match_fields = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint match_fields_length1;
	gint _match_fields_size_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	match_fields = _tmp2_;
	match_fields_length1 = 1;
	_match_fields_size_ = match_fields_length1;
	self = (CallsPhoneNumberQuery*) g_object_new (object_type, "match-fields", match_fields, NULL);
	_tmp3_ = g_strdup (number);
	_g_free0 (self->priv->_number);
	self->priv->_number = _tmp3_;
	_tmp4_ = g_strdup (country_code);
	_g_free0 (self->priv->_country_code);
	self->priv->_country_code = _tmp4_;
	{
		EPhoneNumber* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		EPhoneNumber* _tmp8_;
		EPhoneNumber* _tmp9_;
		_tmp6_ = self->priv->_number;
		_tmp7_ = self->priv->_country_code;
		_tmp8_ = e_phone_number_from_string (_tmp6_, _tmp7_, &_inner_error0_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		__vala_EPhoneNumber_free0 (self->priv->_ephonenumber);
		self->priv->_ephonenumber = _tmp9_;
		__vala_EPhoneNumber_free0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = self->priv->_number;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_debug ("calls-phone-number-query.vala:50: Failed to convert `%s' to a phone nu" \
"mber: %s", _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		match_fields = (_vala_array_free (match_fields, match_fields_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	match_fields = (_vala_array_free (match_fields, match_fields_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

CallsPhoneNumberQuery*
calls_phone_number_query_new (const gchar* number,
                              const gchar* country_code)
{
	return calls_phone_number_query_construct (CALLS_TYPE_PHONE_NUMBER_QUERY, number, country_code);
}

static guint
calls_phone_number_query_real_is_match (FolksQuery* base,
                                        FolksIndividual* individual)
{
	CallsPhoneNumberQuery * self;
	static const guint MATCH_MAX = (guint) 4;
	gboolean use_ephone = FALSE;
	EPhoneNumber* _tmp0_;
	GeeIterator* iter = NULL;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeIterator* _tmp3_;
	guint match = 0U;
	GError* _inner_error0_ = NULL;
	guint result;
	self = (CallsPhoneNumberQuery*) base;
	g_return_val_if_fail (individual != NULL, 0U);
	_tmp0_ = self->priv->_ephonenumber;
	use_ephone = _tmp0_ != NULL;
	_tmp1_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) individual);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
	iter = _tmp3_;
	match = (guint) 0;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		FolksPhoneFieldDetails* details = NULL;
		GeeIterator* _tmp6_;
		gpointer _tmp7_;
		gchar* indiv_number = NULL;
		FolksPhoneFieldDetails* _tmp8_;
		gconstpointer _tmp9_;
		gconstpointer _tmp10_;
		gchar* _tmp11_;
		guint this_match = 0U;
		if (match < MATCH_MAX) {
			GeeIterator* _tmp5_;
			_tmp5_ = iter;
			_tmp4_ = gee_iterator_next (_tmp5_);
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_tmp6_ = iter;
		_tmp7_ = gee_iterator_get (_tmp6_);
		details = (FolksPhoneFieldDetails*) _tmp7_;
		_tmp8_ = details;
		_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup ((const gchar*) _tmp10_);
		indiv_number = _tmp11_;
		this_match = (guint) 0;
		if (use_ephone) {
			EPhoneNumber* indiv_parsed = NULL;
			{
				EPhoneNumber* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				EPhoneNumber* _tmp15_;
				EPhoneNumber* _tmp16_;
				EPhoneNumberMatch _result_ = 0;
				EPhoneNumber* _tmp17_;
				EPhoneNumber* _tmp18_;
				_tmp13_ = indiv_number;
				_tmp14_ = self->priv->_country_code;
				_tmp15_ = e_phone_number_from_string (_tmp13_, _tmp14_, &_inner_error0_);
				_tmp12_ = _tmp15_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp16_ = _tmp12_;
				_tmp12_ = NULL;
				__vala_EPhoneNumber_free0 (indiv_parsed);
				indiv_parsed = _tmp16_;
				_tmp17_ = indiv_parsed;
				_tmp18_ = self->priv->_ephonenumber;
				_result_ = e_phone_number_compare (_tmp17_, _tmp18_);
				switch (_result_) {
					case E_PHONE_NUMBER_MATCH_NONE:
					{
						this_match = (guint) 0;
						break;
					}
					case E_PHONE_NUMBER_MATCH_SHORT:
					{
						this_match = (guint) 0;
						break;
					}
					case E_PHONE_NUMBER_MATCH_NATIONAL:
					{
						this_match = (guint) 1;
						break;
					}
					case E_PHONE_NUMBER_MATCH_EXACT:
					{
						this_match = MATCH_MAX;
						break;
					}
					default:
					{
						this_match = (guint) 0;
						break;
					}
				}
				__vala_EPhoneNumber_free0 (_tmp12_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				GError* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp19_ = indiv_number;
				_tmp20_ = folks_individual_get_display_name (individual);
				_tmp21_ = _tmp20_;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_debug ("Error parsing Folks phone number `%s'" " for Individual `%s': %s", _tmp19_, _tmp21_, _tmp23_);
				_tmp24_ = self->priv->_number;
				_tmp25_ = indiv_number;
				if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
					this_match = MATCH_MAX;
				}
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint _tmp26_ = 0U;
				__vala_EPhoneNumber_free0 (indiv_parsed);
				_g_free0 (indiv_number);
				_g_object_unref0 (details);
				_g_object_unref0 (iter);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp26_;
			}
			__vala_EPhoneNumber_free0 (indiv_parsed);
		} else {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			_tmp27_ = self->priv->_number;
			_tmp28_ = indiv_number;
			if (g_strcmp0 (_tmp27_, _tmp28_) == 0) {
				this_match = MATCH_MAX;
			}
		}
		if (this_match > match) {
			match = this_match;
		}
		_g_free0 (indiv_number);
		_g_object_unref0 (details);
	}
	result = match;
	_g_object_unref0 (iter);
	return result;
}

static void
calls_phone_number_query_class_init (CallsPhoneNumberQueryClass * klass,
                                     gpointer klass_data)
{
	calls_phone_number_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CallsPhoneNumberQuery_private_offset);
	((FolksQueryClass *) klass)->is_match = (guint (*) (FolksQuery*, FolksIndividual*)) calls_phone_number_query_real_is_match;
	G_OBJECT_CLASS (klass)->finalize = calls_phone_number_query_finalize;
}

static void
calls_phone_number_query_instance_init (CallsPhoneNumberQuery * self,
                                        gpointer klass)
{
	self->priv = calls_phone_number_query_get_instance_private (self);
}

static void
calls_phone_number_query_finalize (GObject * obj)
{
	CallsPhoneNumberQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALLS_TYPE_PHONE_NUMBER_QUERY, CallsPhoneNumberQuery);
	_g_free0 (self->priv->_number);
	__vala_EPhoneNumber_free0 (self->priv->_ephonenumber);
	_g_free0 (self->priv->_country_code);
	G_OBJECT_CLASS (calls_phone_number_query_parent_class)->finalize (obj);
}

static GType
calls_phone_number_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CallsPhoneNumberQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calls_phone_number_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CallsPhoneNumberQuery), 0, (GInstanceInitFunc) calls_phone_number_query_instance_init, NULL };
	GType calls_phone_number_query_type_id;
	calls_phone_number_query_type_id = g_type_register_static (FOLKS_TYPE_QUERY, "CallsPhoneNumberQuery", &g_define_type_info, 0);
	CallsPhoneNumberQuery_private_offset = g_type_add_instance_private (calls_phone_number_query_type_id, sizeof (CallsPhoneNumberQueryPrivate));
	return calls_phone_number_query_type_id;
}

GType
calls_phone_number_query_get_type (void)
{
	static volatile gsize calls_phone_number_query_type_id__once = 0;
	if (g_once_init_enter (&calls_phone_number_query_type_id__once)) {
		GType calls_phone_number_query_type_id;
		calls_phone_number_query_type_id = calls_phone_number_query_get_type_once ();
		g_once_init_leave (&calls_phone_number_query_type_id__once, calls_phone_number_query_type_id);
	}
	return calls_phone_number_query_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

