/* util-trillian.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-trillian.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

/**
 * A trillian is a three-state boolean, used when the value is potentially unknown.
 */
gboolean
geary_trillian_to_boolean (GearyTrillian self,
                           gboolean if_unknown)
{
	gboolean result;
	switch (self) {
		case GEARY_TRILLIAN_UNKNOWN:
		{
			result = if_unknown;
			return result;
		}
		case GEARY_TRILLIAN_FALSE:
		{
			result = FALSE;
			return result;
		}
		case GEARY_TRILLIAN_TRUE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

inline GearyTrillian
geary_trillian_from_boolean (gboolean b)
{
	GearyTrillian _tmp0_ = 0;
	GearyTrillian result;
	if (b) {
		_tmp0_ = GEARY_TRILLIAN_TRUE;
	} else {
		_tmp0_ = GEARY_TRILLIAN_FALSE;
	}
	result = _tmp0_;
	return result;
}

inline gint
geary_trillian_to_int (GearyTrillian self)
{
	gint result;
	result = (gint) self;
	return result;
}

GearyTrillian
geary_trillian_from_int (gint i)
{
	GearyTrillian result;
	switch (i) {
		case 0:
		{
			result = GEARY_TRILLIAN_FALSE;
			return result;
		}
		case 1:
		{
			result = GEARY_TRILLIAN_TRUE;
			return result;
		}
		default:
		{
			result = GEARY_TRILLIAN_UNKNOWN;
			return result;
		}
	}
}

inline gboolean
geary_trillian_is_certain (GearyTrillian self)
{
	gboolean result;
	result = self == GEARY_TRILLIAN_TRUE;
	return result;
}

inline gboolean
geary_trillian_is_uncertain (GearyTrillian self)
{
	gboolean result;
	result = self != GEARY_TRILLIAN_TRUE;
	return result;
}

inline gboolean
geary_trillian_is_possible (GearyTrillian self)
{
	gboolean result;
	result = self != GEARY_TRILLIAN_FALSE;
	return result;
}

inline gboolean
geary_trillian_is_impossible (GearyTrillian self)
{
	gboolean result;
	result = self == GEARY_TRILLIAN_FALSE;
	return result;
}

gchar*
geary_trillian_to_string (GearyTrillian self)
{
	gchar* result;
	switch (self) {
		case GEARY_TRILLIAN_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("unknown");
			result = _tmp0_;
			return result;
		}
		case GEARY_TRILLIAN_FALSE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("false");
			result = _tmp1_;
			return result;
		}
		case GEARY_TRILLIAN_TRUE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("true");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_trillian_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_TRILLIAN_UNKNOWN, "GEARY_TRILLIAN_UNKNOWN", "unknown"}, {GEARY_TRILLIAN_FALSE, "GEARY_TRILLIAN_FALSE", "false"}, {GEARY_TRILLIAN_TRUE, "GEARY_TRILLIAN_TRUE", "true"}, {0, NULL, NULL}};
	GType geary_trillian_type_id;
	geary_trillian_type_id = g_enum_register_static ("GearyTrillian", values);
	return geary_trillian_type_id;
}

GType
geary_trillian_get_type (void)
{
	static gsize geary_trillian_type_id__once = 0;
	if (g_once_init_enter (&geary_trillian_type_id__once)) {
		GType geary_trillian_type_id;
		geary_trillian_type_id = geary_trillian_get_type_once ();
		g_once_init_leave (&geary_trillian_type_id__once, geary_trillian_type_id);
	}
	return geary_trillian_type_id__once;
}

