/* nonblocking-counting-semaphore.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nonblocking-counting-semaphore.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_NONBLOCKING_COUNTING_SEMAPHORE_0_PROPERTY,
	GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_PROPERTY,
	GEARY_NONBLOCKING_COUNTING_SEMAPHORE_NUM_PROPERTIES
};
static GParamSpec* geary_nonblocking_counting_semaphore_properties[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyNonblockingCountingSemaphoreWaitAsyncData GearyNonblockingCountingSemaphoreWaitAsyncData;
enum  {
	GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_CHANGED_SIGNAL,
	GEARY_NONBLOCKING_COUNTING_SEMAPHORE_NUM_SIGNALS
};
static guint geary_nonblocking_counting_semaphore_signals[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_NUM_SIGNALS] = {0};

struct _GearyNonblockingCountingSemaphorePrivate {
	gint _count;
};

struct _GearyNonblockingCountingSemaphoreWaitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyNonblockingCountingSemaphore* self;
	GCancellable* cancellable;
	gint _tmp0_;
	GError* _inner_error0_;
};

static gint GearyNonblockingCountingSemaphore_private_offset;
static gpointer geary_nonblocking_counting_semaphore_parent_class = NULL;

static void geary_nonblocking_counting_semaphore_set_count (GearyNonblockingCountingSemaphore* self,
                                                     gint value);
static void geary_nonblocking_counting_semaphore_real_notify (GearyNonblockingLock* base,
                                                       GError** error);
static void geary_nonblocking_counting_semaphore_real_wait_async_data_free (gpointer _data);
static void geary_nonblocking_counting_semaphore_real_wait_async (GearyNonblockingLock* base,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gboolean geary_nonblocking_counting_semaphore_real_wait_async_co (GearyNonblockingCountingSemaphoreWaitAsyncData* _data_);
static void geary_nonblocking_counting_semaphore_wait_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void geary_nonblocking_counting_semaphore_finalize (GObject * obj);
static GType geary_nonblocking_counting_semaphore_get_type_once (void);
static void _vala_geary_nonblocking_counting_semaphore_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_geary_nonblocking_counting_semaphore_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
geary_nonblocking_counting_semaphore_get_instance_private (GearyNonblockingCountingSemaphore* self)
{
	return G_STRUCT_MEMBER_P (self, GearyNonblockingCountingSemaphore_private_offset);
}

gint
geary_nonblocking_counting_semaphore_get_count (GearyNonblockingCountingSemaphore* self)
{
	gint result;
	g_return_val_if_fail (GEARY_NONBLOCKING_IS_COUNTING_SEMAPHORE (self), 0);
	result = self->priv->_count;
	return result;
}

static void
geary_nonblocking_counting_semaphore_set_count (GearyNonblockingCountingSemaphore* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_NONBLOCKING_IS_COUNTING_SEMAPHORE (self));
	old_value = geary_nonblocking_counting_semaphore_get_count (self);
	if (old_value != value) {
		self->priv->_count = value;
		g_object_notify_by_pspec ((GObject *) self, geary_nonblocking_counting_semaphore_properties[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_PROPERTY]);
	}
}

GearyNonblockingCountingSemaphore*
geary_nonblocking_counting_semaphore_construct (GType object_type,
                                                GCancellable* cancellable)
{
	GearyNonblockingCountingSemaphore * self = NULL;
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyNonblockingCountingSemaphore*) geary_nonblocking_lock_construct (object_type, TRUE, TRUE, cancellable);
	return self;
}

GearyNonblockingCountingSemaphore*
geary_nonblocking_counting_semaphore_new (GCancellable* cancellable)
{
	return geary_nonblocking_counting_semaphore_construct (GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, cancellable);
}

/**
     * Called by a task to acquire (and, hence, lock) the semaphore.
     *
     * @return Number of acquired tasks, including the one that made this call.
     */
gint
geary_nonblocking_counting_semaphore_acquire (GearyNonblockingCountingSemaphore* self)
{
	gint _tmp0_;
	gint new_count = 0;
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (GEARY_NONBLOCKING_IS_COUNTING_SEMAPHORE (self), 0);
	_tmp0_ = self->priv->_count;
	geary_nonblocking_counting_semaphore_set_count (self, _tmp0_ + 1);
	_tmp1_ = self->priv->_count;
	new_count = _tmp1_;
	g_signal_emit (self, geary_nonblocking_counting_semaphore_signals[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_CHANGED_SIGNAL], 0, new_count);
	result = new_count;
	return result;
}

/**
     * Called by a task which has previously {@link acquire}d the semaphore.
     *
     * When the number of acquired tasks reaches zero, the semaphore is unlocked and all waiting
     * tasks will resume.
     *
     * @see wait_async
     * @throws NonblockingError.INVALID if called when {@link count} is zero.
     */
static void
geary_nonblocking_counting_semaphore_real_notify (GearyNonblockingLock* base,
                                                  GError** error)
{
	GearyNonblockingCountingSemaphore * self;
	gint _tmp0_;
	gint _tmp2_;
	gint new_count = 0;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, GearyNonblockingCountingSemaphore);
	_tmp0_ = self->priv->_count;
	if (_tmp0_ == 0) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GEARY_NONBLOCKING_ERROR, GEARY_NONBLOCKING_ERROR_INVALID, "notify() on a zeroed CountingSemaphore");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = self->priv->_count;
	geary_nonblocking_counting_semaphore_set_count (self, _tmp2_ - 1);
	_tmp3_ = self->priv->_count;
	new_count = _tmp3_;
	g_signal_emit (self, geary_nonblocking_counting_semaphore_signals[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_CHANGED_SIGNAL], 0, new_count);
	if (new_count == 0) {
		GEARY_NONBLOCKING_LOCK_CLASS (geary_nonblocking_counting_semaphore_parent_class)->notify (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

static void
geary_nonblocking_counting_semaphore_real_wait_async_data_free (gpointer _data)
{
	GearyNonblockingCountingSemaphoreWaitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyNonblockingCountingSemaphoreWaitAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_nonblocking_counting_semaphore_real_wait_async (GearyNonblockingLock* base,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GearyNonblockingCountingSemaphore * self;
	GearyNonblockingCountingSemaphoreWaitAsyncData* _data_;
	GearyNonblockingCountingSemaphore* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, GearyNonblockingCountingSemaphore);
	_data_ = g_slice_new0 (GearyNonblockingCountingSemaphoreWaitAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_nonblocking_counting_semaphore_real_wait_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_nonblocking_counting_semaphore_real_wait_async_co (_data_);
}

static void
geary_nonblocking_counting_semaphore_wait_finish (GearyNonblockingLock* base,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyNonblockingCountingSemaphoreWaitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Wait for all tasks which have {@link acquire}d this semaphore to release it.
     *
     * If no tasks have acquired the semaphore, this call will complete immediately.
     */
static void
geary_nonblocking_counting_semaphore_wait_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GearyNonblockingCountingSemaphoreWaitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_nonblocking_counting_semaphore_real_wait_async_co (_data_);
}

static gboolean
geary_nonblocking_counting_semaphore_real_wait_async_co (GearyNonblockingCountingSemaphoreWaitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_count;
	if (_data_->_tmp0_ != 0) {
		_data_->_state_ = 1;
		GEARY_NONBLOCKING_LOCK_CLASS (geary_nonblocking_counting_semaphore_parent_class)->wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_nonblocking_counting_semaphore_wait_async_ready, _data_);
		return FALSE;
		_state_1:
		GEARY_NONBLOCKING_LOCK_CLASS (geary_nonblocking_counting_semaphore_parent_class)->wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_nonblocking_counting_semaphore_class_init (GearyNonblockingCountingSemaphoreClass * klass,
                                                 gpointer klass_data)
{
	geary_nonblocking_counting_semaphore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyNonblockingCountingSemaphore_private_offset);
	((GearyNonblockingLockClass *) klass)->notify = (void (*) (GearyNonblockingLock*, GError**)) geary_nonblocking_counting_semaphore_real_notify;
	((GearyNonblockingLockClass *) klass)->wait_async = (void (*) (GearyNonblockingLock*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_nonblocking_counting_semaphore_real_wait_async;
	((GearyNonblockingLockClass *) klass)->wait_finish = (void (*) (GearyNonblockingLock*, GAsyncResult*, GError**)) geary_nonblocking_counting_semaphore_wait_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_nonblocking_counting_semaphore_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_nonblocking_counting_semaphore_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_nonblocking_counting_semaphore_finalize;
	/**
	     * The number of tasks which have {@link acquire} the semaphore.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_PROPERTY, geary_nonblocking_counting_semaphore_properties[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_PROPERTY] = g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Indicates that the {@link count} has changed due to either {@link acquire} or
	     * {@link notify} being invoked.
	     */
	geary_nonblocking_counting_semaphore_signals[GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_CHANGED_SIGNAL] = g_signal_new ("count-changed", GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
geary_nonblocking_counting_semaphore_instance_init (GearyNonblockingCountingSemaphore * self,
                                                    gpointer klass)
{
	self->priv = geary_nonblocking_counting_semaphore_get_instance_private (self);
	self->priv->_count = 0;
}

static void
geary_nonblocking_counting_semaphore_finalize (GObject * obj)
{
	GearyNonblockingCountingSemaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, GearyNonblockingCountingSemaphore);
	G_OBJECT_CLASS (geary_nonblocking_counting_semaphore_parent_class)->finalize (obj);
}

/**
 * A counting, asynchronous semaphore.
 *
 * Unlike the other {@link Lock} variants, a task must {@link acquire}
 * before it can {@link notify}. The number of acquired tasks is kept
 * in the {@link count} property. Waiting tasks are released only when
 * the count returns to zero.
 *
 * This class is ''not'' thread safe and should only be used by
 * asynchronous tasks.
 */
 G_GNUC_NO_INLINE static GType
geary_nonblocking_counting_semaphore_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyNonblockingCountingSemaphoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_nonblocking_counting_semaphore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyNonblockingCountingSemaphore), 0, (GInstanceInitFunc) geary_nonblocking_counting_semaphore_instance_init, NULL };
	GType geary_nonblocking_counting_semaphore_type_id;
	geary_nonblocking_counting_semaphore_type_id = g_type_register_static (GEARY_NONBLOCKING_TYPE_LOCK, "GearyNonblockingCountingSemaphore", &g_define_type_info, 0);
	GearyNonblockingCountingSemaphore_private_offset = g_type_add_instance_private (geary_nonblocking_counting_semaphore_type_id, sizeof (GearyNonblockingCountingSemaphorePrivate));
	return geary_nonblocking_counting_semaphore_type_id;
}

GType
geary_nonblocking_counting_semaphore_get_type (void)
{
	static gsize geary_nonblocking_counting_semaphore_type_id__once = 0;
	if (g_once_init_enter (&geary_nonblocking_counting_semaphore_type_id__once)) {
		GType geary_nonblocking_counting_semaphore_type_id;
		geary_nonblocking_counting_semaphore_type_id = geary_nonblocking_counting_semaphore_get_type_once ();
		g_once_init_leave (&geary_nonblocking_counting_semaphore_type_id__once, geary_nonblocking_counting_semaphore_type_id);
	}
	return geary_nonblocking_counting_semaphore_type_id__once;
}

static void
_vala_geary_nonblocking_counting_semaphore_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	GearyNonblockingCountingSemaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, GearyNonblockingCountingSemaphore);
	switch (property_id) {
		case GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_PROPERTY:
		g_value_set_int (value, geary_nonblocking_counting_semaphore_get_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_nonblocking_counting_semaphore_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	GearyNonblockingCountingSemaphore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, GearyNonblockingCountingSemaphore);
	switch (property_id) {
		case GEARY_NONBLOCKING_COUNTING_SEMAPHORE_COUNT_PROPERTY:
		geary_nonblocking_counting_semaphore_set_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

