/* conversation-list-model.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from conversation-list-model.vala, do not modify */

/*
 * Copyright © 2022 John Renner <john@jrenner.net>
 * Copyright © 2022 Cédric Bellegarde <cedric.bellegarde@adishatz.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */
/* The whole goal of this class to wrap the ConversationMonitor with a view that presents a sorted list*/

#include "geary-client-46.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONVERSATION_LIST_MODEL_0_PROPERTY,
	CONVERSATION_LIST_MODEL_MONITOR_PROPERTY,
	CONVERSATION_LIST_MODEL_NUM_PROPERTIES
};
static GParamSpec* conversation_list_model_properties[CONVERSATION_LIST_MODEL_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block81Data Block81Data;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	CONVERSATION_LIST_MODEL_CONVERSATIONS_ADDED_SIGNAL,
	CONVERSATION_LIST_MODEL_CONVERSATIONS_REMOVED_SIGNAL,
	CONVERSATION_LIST_MODEL_CONVERSATIONS_LOADED_SIGNAL,
	CONVERSATION_LIST_MODEL_CONVERSATION_UPDATED_SIGNAL,
	CONVERSATION_LIST_MODEL_NUM_SIGNALS
};
static guint conversation_list_model_signals[CONVERSATION_LIST_MODEL_NUM_SIGNALS] = {0};

struct _ConversationListModelPrivate {
	GearyAppConversationMonitor* _monitor;
	gboolean scanning;
};

struct _Block81Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

static gint ConversationListModel_private_offset;
static gpointer conversation_list_model_parent_class = NULL;
static GListModelInterface * conversation_list_model_g_list_model_parent_iface = NULL;

VALA_EXTERN GearyAppConversationMonitor* conversation_list_model_get_monitor (ConversationListModel* self);
static void conversation_list_model_on_conversations_added (ConversationListModel* self,
                                                     GeeCollection* conversations);
static void _conversation_list_model_on_conversations_added_geary_app_conversation_monitor_conversations_added (GearyAppConversationMonitor* _sender,
                                                                                                         GeeCollection* conversations,
                                                                                                         gpointer self);
static void conversation_list_model_on_conversation_updated (ConversationListModel* self,
                                                      GearyAppConversationMonitor* sender,
                                                      GearyAppConversation* convo,
                                                      GeeCollection* emails);
static void _conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_appended (GearyAppConversationMonitor* _sender,
                                                                                                            GearyAppConversation* conversation,
                                                                                                            GeeCollection* email,
                                                                                                            gpointer self);
static void _conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_trimmed (GearyAppConversationMonitor* _sender,
                                                                                                           GearyAppConversation* conversation,
                                                                                                           GeeCollection* email,
                                                                                                           gpointer self);
static void conversation_list_model_on_conversations_removed (ConversationListModel* self,
                                                       GeeCollection* conversations);
static void _conversation_list_model_on_conversations_removed_geary_app_conversation_monitor_conversations_removed (GearyAppConversationMonitor* _sender,
                                                                                                             GeeCollection* conversations,
                                                                                                             gpointer self);
static void conversation_list_model_on_scan_started (ConversationListModel* self,
                                              GearyAppConversationMonitor* source);
static void _conversation_list_model_on_scan_started_geary_app_conversation_monitor_scan_started (GearyAppConversationMonitor* _sender,
                                                                                           gpointer self);
static void conversation_list_model_on_scan_completed (ConversationListModel* self,
                                                GearyAppConversationMonitor* source);
static void _conversation_list_model_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                               gpointer self);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void conversation_list_model_set_monitor (ConversationListModel* self,
                                          GearyAppConversationMonitor* value);
VALA_EXTERN ConversationListModel* conversation_list_model_new (GearyAppConversationMonitor* monitor);
VALA_EXTERN ConversationListModel* conversation_list_model_construct (GType object_type,
                                                          GearyAppConversationMonitor* monitor);
static gint conversation_list_model_compare (GObject* a,
                                      GObject* b);
static gboolean __lambda24_ (ConversationListModel* self);
static gboolean ___lambda24__gsource_func (gpointer self);
static GObject* conversation_list_model_real_get_item (GListModel* base,
                                                guint position);
static GType conversation_list_model_real_get_item_type (GListModel* base);
static guint conversation_list_model_real_get_n_items (GListModel* base);
static gboolean conversation_list_model_insert_conversation (ConversationListModel* self,
                                                      GearyAppConversation* convo);
static GPtrArray* conversation_list_model_conversations_indexes (ConversationListModel* self,
                                                          GeeCollection* conversations);
static void conversation_list_model_update_added (ConversationListModel* self,
                                           GPtrArray* indexes);
static Block81Data* block81_data_ref (Block81Data* _data81_);
static void block81_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda22_ (guint a,
                  guint b);
static gint ___lambda22__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static guint* _uint_dup (guint* self);
static void conversation_list_model_update_removed (ConversationListModel* self,
                                             GPtrArray* indexes);
static gint __lambda23_ (guint a,
                  guint b);
static gint ___lambda23__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static gint _conversation_list_model_compare_gcompare_func (gconstpointer a,
                                                     gconstpointer b);
static void conversation_list_model_finalize (GObject * obj);
static GType conversation_list_model_get_type_once (void);
static void _vala_conversation_list_model_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_conversation_list_model_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
conversation_list_model_get_instance_private (ConversationListModel* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationListModel_private_offset);
}

static void
_conversation_list_model_on_conversations_added_geary_app_conversation_monitor_conversations_added (GearyAppConversationMonitor* _sender,
                                                                                                    GeeCollection* conversations,
                                                                                                    gpointer self)
{
	conversation_list_model_on_conversations_added ((ConversationListModel*) self, conversations);
}

static void
_conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_appended (GearyAppConversationMonitor* _sender,
                                                                                                       GearyAppConversation* conversation,
                                                                                                       GeeCollection* email,
                                                                                                       gpointer self)
{
	conversation_list_model_on_conversation_updated ((ConversationListModel*) self, _sender, conversation, email);
}

static void
_conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_trimmed (GearyAppConversationMonitor* _sender,
                                                                                                      GearyAppConversation* conversation,
                                                                                                      GeeCollection* email,
                                                                                                      gpointer self)
{
	conversation_list_model_on_conversation_updated ((ConversationListModel*) self, _sender, conversation, email);
}

static void
_conversation_list_model_on_conversations_removed_geary_app_conversation_monitor_conversations_removed (GearyAppConversationMonitor* _sender,
                                                                                                        GeeCollection* conversations,
                                                                                                        gpointer self)
{
	conversation_list_model_on_conversations_removed ((ConversationListModel*) self, conversations);
}

static void
_conversation_list_model_on_scan_started_geary_app_conversation_monitor_scan_started (GearyAppConversationMonitor* _sender,
                                                                                      gpointer self)
{
	conversation_list_model_on_scan_started ((ConversationListModel*) self, _sender);
}

static void
_conversation_list_model_on_scan_completed_geary_app_conversation_monitor_scan_completed (GearyAppConversationMonitor* _sender,
                                                                                          gpointer self)
{
	conversation_list_model_on_scan_completed ((ConversationListModel*) self, _sender);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

GearyAppConversationMonitor*
conversation_list_model_get_monitor (ConversationListModel* self)
{
	GearyAppConversationMonitor* result;
	GearyAppConversationMonitor* _tmp0_;
	g_return_val_if_fail (CONVERSATION_LIST_IS_MODEL (self), NULL);
	_tmp0_ = self->priv->_monitor;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
conversation_list_model_set_monitor (ConversationListModel* self,
                                     GearyAppConversationMonitor* value)
{
	GearyAppConversationMonitor* old_value;
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	old_value = conversation_list_model_get_monitor (self);
	if (old_value != value) {
		GearyAppConversationMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_list_model_properties[CONVERSATION_LIST_MODEL_MONITOR_PROPERTY]);
	}
}

ConversationListModel*
conversation_list_model_construct (GType object_type,
                                   GearyAppConversationMonitor* monitor)
{
	ConversationListModel * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (monitor, GEARY_APP_TYPE_CONVERSATION_MONITOR), NULL);
	self = (ConversationListModel*) g_object_new (object_type, NULL);
	conversation_list_model_set_monitor (self, monitor);
	g_signal_connect_object (monitor, "conversations-added", (GCallback) _conversation_list_model_on_conversations_added_geary_app_conversation_monitor_conversations_added, self, 0);
	g_signal_connect_object (monitor, "conversation-appended", (GCallback) _conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_appended, self, 0);
	g_signal_connect_object (monitor, "conversation-trimmed", (GCallback) _conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_trimmed, self, 0);
	g_signal_connect_object (monitor, "conversations-removed", (GCallback) _conversation_list_model_on_conversations_removed_geary_app_conversation_monitor_conversations_removed, self, 0);
	g_signal_connect_object (monitor, "scan-started", (GCallback) _conversation_list_model_on_scan_started_geary_app_conversation_monitor_scan_started, self, 0);
	g_signal_connect_object (monitor, "scan-completed", (GCallback) _conversation_list_model_on_scan_completed_geary_app_conversation_monitor_scan_completed, self, 0);
	return self;
}

ConversationListModel*
conversation_list_model_new (GearyAppConversationMonitor* monitor)
{
	return conversation_list_model_construct (CONVERSATION_LIST_TYPE_MODEL, monitor);
}

static gint
conversation_list_model_compare (GObject* a,
                                 GObject* b)
{
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, G_TYPE_OBJECT), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (b, G_TYPE_OBJECT), 0);
	result = util_email_compare_conversation_descending (G_TYPE_CHECK_INSTANCE_TYPE (a, GEARY_APP_TYPE_CONVERSATION) ? ((GearyAppConversation*) a) : NULL, G_TYPE_CHECK_INSTANCE_TYPE (b, GEARY_APP_TYPE_CONVERSATION) ? ((GearyAppConversation*) b) : NULL);
	return result;
}

static void
conversation_list_model_on_scan_started (ConversationListModel* self,
                                         GearyAppConversationMonitor* source)
{
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	self->priv->scanning = TRUE;
}

static gboolean
__lambda24_ (ConversationListModel* self)
{
	gboolean result;
	if (!self->priv->scanning) {
		g_signal_emit (self, conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_LOADED_SIGNAL], 0);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda24__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda24_ ((ConversationListModel*) self);
	return result;
}

static void
conversation_list_model_on_scan_completed (ConversationListModel* self,
                                           GearyAppConversationMonitor* source)
{
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	self->priv->scanning = FALSE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda24__gsource_func, g_object_ref (self), g_object_unref);
}

gboolean
conversation_list_model_load_more (ConversationListModel* self,
                                   gint amount)
{
	GearyAppConversationMonitor* _tmp0_;
	GearyAppConversationMonitor* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_MODEL (self), FALSE);
	if (self->priv->scanning) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_monitor;
	_tmp1_ = self->priv->_monitor;
	_tmp2_ = geary_app_conversation_monitor_get_min_window_count (_tmp1_);
	_tmp3_ = _tmp2_;
	geary_app_conversation_monitor_set_min_window_count (_tmp1_, _tmp3_ + amount);
	result = TRUE;
	return result;
}

static GObject*
conversation_list_model_real_get_item (GListModel* base,
                                       guint position)
{
	ConversationListModel * self;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	GObject* _tmp2_;
	GObject* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_LIST_TYPE_MODEL, ConversationListModel);
	_tmp0_ = self->items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GearyAppConversation*) _tmp1_, G_TYPE_OBJECT, GObject));
	result = _tmp2_;
	return result;
}

static GType
conversation_list_model_real_get_item_type (GListModel* base)
{
	ConversationListModel * self;
	GType result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_LIST_TYPE_MODEL, ConversationListModel);
	result = GEARY_APP_TYPE_CONVERSATION;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
conversation_list_model_real_get_n_items (GListModel* base)
{
	ConversationListModel * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_LIST_TYPE_MODEL, ConversationListModel);
	_tmp0_ = self->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static gboolean
conversation_list_model_insert_conversation (ConversationListModel* self,
                                             GearyAppConversation* convo)
{
	GearyEmail* last_email = NULL;
	GearyEmail* _tmp0_;
	GearyEmail* _tmp1_;
	GPtrArray* _tmp2_;
	GearyAppConversation* _tmp3_;
	gboolean result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_MODEL (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (convo, GEARY_APP_TYPE_CONVERSATION), FALSE);
	_tmp0_ = geary_app_conversation_get_latest_recv_email (convo, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL);
	last_email = _tmp0_;
	_tmp1_ = last_email;
	if (_tmp1_ == NULL) {
		g_debug ("conversation-list-model.vala:94: Cannot add conversation: last email i" \
"s null");
		result = FALSE;
		_g_object_unref0 (last_email);
		return result;
	}
	_tmp2_ = self->items;
	_tmp3_ = _g_object_ref0 (convo);
	g_ptr_array_add (_tmp2_, _tmp3_);
	result = TRUE;
	_g_object_unref0 (last_email);
	return result;
}

static GPtrArray*
conversation_list_model_conversations_indexes (ConversationListModel* self,
                                               GeeCollection* conversations)
{
	GPtrArray* indexes = NULL;
	GPtrArray* _tmp0_;
	guint index = 0U;
	GPtrArray* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_MODEL (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	indexes = _tmp0_;
	{
		GeeIterator* _convo_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_convo_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			GearyAppConversation* convo = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GPtrArray* _tmp5_;
			GearyAppConversation* _tmp6_;
			guint _tmp7_ = 0U;
			gboolean _tmp8_;
			_tmp2_ = _convo_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _convo_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			convo = (GearyAppConversation*) _tmp4_;
			_tmp5_ = self->items;
			_tmp6_ = convo;
			_tmp8_ = g_ptr_array_find (_tmp5_, _tmp6_, &_tmp7_);
			index = _tmp7_;
			if (_tmp8_) {
				GPtrArray* _tmp9_;
				_tmp9_ = indexes;
				g_ptr_array_add (_tmp9_, (gpointer) ((guintptr) index));
			}
			_g_object_unref0 (convo);
		}
		_g_object_unref0 (_convo_it);
	}
	result = indexes;
	return result;
}

static Block81Data*
block81_data_ref (Block81Data* _data81_)
{
	g_atomic_int_inc (&_data81_->_ref_count_);
	return _data81_;
}

static void
block81_data_unref (void * _userdata_)
{
	Block81Data* _data81_;
	_data81_ = (Block81Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data81_->_ref_count_)) {
		GPtrArray* self;
		self = _data81_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block81Data, _data81_);
	}
}

static gint
__lambda0_ (Block81Data* _data81_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data81_->self;
	result = _data81_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block81Data* _data81_;
	g_return_if_fail (self != NULL);
	_data81_ = g_slice_new0 (Block81Data);
	_data81_->_ref_count_ = 1;
	_data81_->self = g_ptr_array_ref (self);
	_data81_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data81_);
	block81_data_unref (_data81_);
	_data81_ = NULL;
}

static gint
__lambda22_ (guint a,
             guint b)
{
	gint result;
	result = ((gint) (a > b)) - ((gint) (a < b));
	return result;
}

static gint
___lambda22__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda22_ ((guint) ((guintptr) a), (guint) ((guintptr) b));
	return result;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static void
conversation_list_model_update_added (ConversationListModel* self,
                                      GPtrArray* indexes)
{
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (indexes != NULL);
	vala_g_ptr_array_sort (indexes, ___lambda22__gcompare_func);
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		guint* last_index = NULL;
		guint count = 0U;
		gconstpointer _tmp8_;
		_tmp0_ = vala_g_ptr_array_get_length (indexes);
		_tmp1_ = _tmp0_;
		if (!(_tmp1_ > 0)) {
			break;
		}
		last_index = NULL;
		count = (guint) 0;
		{
			GPtrArray* index_collection = NULL;
			guint index_index = 0U;
			index_collection = indexes;
			for (index_index = 0; index_index < index_collection->len; index_index = index_index + 1) {
				guint index = 0U;
				index = (guint) ((guintptr) g_ptr_array_index (index_collection, index_index));
				{
					gboolean _tmp2_ = FALSE;
					guint* _tmp3_;
					guint _tmp5_;
					guint* _tmp6_;
					guint _tmp7_;
					_tmp3_ = last_index;
					if (_tmp3_ != NULL) {
						guint* _tmp4_;
						_tmp4_ = last_index;
						_tmp2_ = index > ((*_tmp4_) + 1);
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						break;
					}
					_tmp5_ = (guint) ((gint) index);
					_tmp6_ = __uint_dup0 (&_tmp5_);
					_g_free0 (last_index);
					last_index = _tmp6_;
					_tmp7_ = count;
					count = _tmp7_ + 1;
				}
			}
		}
		_tmp8_ = g_ptr_array_index (indexes, (guint) 0);
		g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) ((guintptr) _tmp8_), (guint) 0, count);
		g_ptr_array_remove_range (indexes, (guint) 0, count);
		_g_free0 (last_index);
	}
}

static gint
__lambda23_ (guint a,
             guint b)
{
	gint result;
	result = ((gint) (a < b)) - ((gint) (a > b));
	return result;
}

static gint
___lambda23__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda23_ ((guint) ((guintptr) a), (guint) ((guintptr) b));
	return result;
}

static void
conversation_list_model_update_removed (ConversationListModel* self,
                                        GPtrArray* indexes)
{
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (indexes != NULL);
	vala_g_ptr_array_sort (indexes, ___lambda23__gcompare_func);
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		guint* last_index = NULL;
		guint count = 0U;
		guint* _tmp7_;
		_tmp0_ = vala_g_ptr_array_get_length (indexes);
		_tmp1_ = _tmp0_;
		if (!(_tmp1_ > 0)) {
			break;
		}
		last_index = NULL;
		count = (guint) 0;
		{
			GPtrArray* index_collection = NULL;
			guint index_index = 0U;
			index_collection = indexes;
			for (index_index = 0; index_index < index_collection->len; index_index = index_index + 1) {
				guint index = 0U;
				index = (guint) ((guintptr) g_ptr_array_index (index_collection, index_index));
				{
					gboolean _tmp2_ = FALSE;
					guint* _tmp3_;
					guint* _tmp5_;
					guint _tmp6_;
					_tmp3_ = last_index;
					if (_tmp3_ != NULL) {
						guint* _tmp4_;
						_tmp4_ = last_index;
						_tmp2_ = index < ((*_tmp4_) - 1);
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						break;
					}
					_tmp5_ = __uint_dup0 (&index);
					_g_free0 (last_index);
					last_index = _tmp5_;
					_tmp6_ = count;
					count = _tmp6_ + 1;
				}
			}
		}
		_tmp7_ = last_index;
		g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), *_tmp7_, count, (guint) 0);
		g_ptr_array_remove_range (indexes, (guint) 0, count);
		_g_free0 (last_index);
	}
}

static gint
_conversation_list_model_compare_gcompare_func (gconstpointer a,
                                                gconstpointer b)
{
	gint result;
	result = conversation_list_model_compare ((GObject*) a, (GObject*) b);
	return result;
}

static void
conversation_list_model_on_conversations_added (ConversationListModel* self,
                                                GeeCollection* conversations)
{
	gint _tmp0_;
	gint _tmp1_;
	gint added = 0;
	GPtrArray* _tmp8_;
	GPtrArray* indexes = NULL;
	GPtrArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_collection_get_size (conversations);
	_tmp1_ = _tmp0_;
	g_debug ("conversation-list-model.vala:157: Adding %d conversations.", _tmp1_);
	g_signal_emit (self, conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_ADDED_SIGNAL], 0, TRUE);
	added = 0;
	{
		GeeIterator* _convo_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_convo_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GearyAppConversation* convo = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GearyAppConversation* _tmp6_;
			_tmp3_ = _convo_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _convo_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			convo = (GearyAppConversation*) _tmp5_;
			_tmp6_ = convo;
			if (conversation_list_model_insert_conversation (self, _tmp6_)) {
				gint _tmp7_;
				_tmp7_ = added;
				added = _tmp7_ + 1;
			}
			_g_object_unref0 (convo);
		}
		_g_object_unref0 (_convo_it);
	}
	_tmp8_ = self->items;
	vala_g_ptr_array_sort (_tmp8_, _conversation_list_model_compare_gcompare_func);
	_tmp9_ = conversation_list_model_conversations_indexes (self, conversations);
	indexes = _tmp9_;
	conversation_list_model_update_added (self, indexes);
	g_signal_emit (self, conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_ADDED_SIGNAL], 0, FALSE);
	_tmp10_ = gee_collection_get_size (conversations);
	_tmp11_ = _tmp10_;
	g_debug ("conversation-list-model.vala:174: Added %d/%d conversations.", added, _tmp11_);
	_g_ptr_array_unref0 (indexes);
}

static void
conversation_list_model_on_conversations_removed (ConversationListModel* self,
                                                  GeeCollection* conversations)
{
	GPtrArray* indexes = NULL;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint removed = 0;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_COLLECTION));
	_tmp0_ = conversation_list_model_conversations_indexes (self, conversations);
	indexes = _tmp0_;
	_tmp1_ = gee_collection_get_size (conversations);
	_tmp2_ = _tmp1_;
	g_debug ("conversation-list-model.vala:180: Removing %d conversations.", _tmp2_);
	g_signal_emit (self, conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_REMOVED_SIGNAL], 0, TRUE);
	removed = 0;
	{
		GeeIterator* _convo_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_convo_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GearyAppConversation* convo = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GPtrArray* _tmp7_;
			GearyAppConversation* _tmp8_;
			gint _tmp9_;
			_tmp4_ = _convo_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _convo_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			convo = (GearyAppConversation*) _tmp6_;
			_tmp7_ = self->items;
			_tmp8_ = convo;
			g_ptr_array_remove (_tmp7_, _tmp8_);
			_tmp9_ = removed;
			removed = _tmp9_ + 1;
			_g_object_unref0 (convo);
		}
		_g_object_unref0 (_convo_it);
	}
	_tmp10_ = indexes;
	conversation_list_model_update_removed (self, _tmp10_);
	g_signal_emit (self, conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_REMOVED_SIGNAL], 0, FALSE);
	_tmp11_ = gee_collection_get_size (conversations);
	_tmp12_ = _tmp11_;
	g_debug ("conversation-list-model.vala:194: Removed %ld/%d conversations.", (glong) removed, _tmp12_);
	_g_ptr_array_unref0 (indexes);
}

static void
conversation_list_model_on_conversation_updated (ConversationListModel* self,
                                                 GearyAppConversationMonitor* sender,
                                                 GearyAppConversation* convo,
                                                 GeeCollection* emails)
{
	guint initial_index = 0U;
	GPtrArray* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	GPtrArray* _tmp3_;
	guint final_index = 0U;
	gboolean _tmp4_ = FALSE;
	GPtrArray* _tmp5_;
	guint _tmp6_ = 0U;
	gboolean _tmp7_;
	guint _tmp8_ = 0U;
	guint count = 0U;
	g_return_if_fail (CONVERSATION_LIST_IS_MODEL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sender, GEARY_APP_TYPE_CONVERSATION_MONITOR));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (convo, GEARY_APP_TYPE_CONVERSATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_signal_emit (self, conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATION_UPDATED_SIGNAL], 0, convo);
	_tmp0_ = self->items;
	_tmp2_ = g_ptr_array_find (_tmp0_, convo, &_tmp1_);
	initial_index = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->items;
	vala_g_ptr_array_sort (_tmp3_, _conversation_list_model_compare_gcompare_func);
	_tmp5_ = self->items;
	_tmp7_ = g_ptr_array_find (_tmp5_, convo, &_tmp6_);
	final_index = _tmp6_;
	if (!_tmp7_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = initial_index == final_index;
	}
	if (_tmp4_) {
		return;
	}
	if (initial_index > final_index) {
		_tmp8_ = (initial_index + 1) - final_index;
	} else {
		_tmp8_ = (final_index + 1) - initial_index;
	}
	count = _tmp8_;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), MIN (initial_index, final_index), count, count);
}

static void
conversation_list_model_class_init (ConversationListModelClass * klass,
                                    gpointer klass_data)
{
	conversation_list_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationListModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_list_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_conversation_list_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_list_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_LIST_MODEL_MONITOR_PROPERTY, conversation_list_model_properties[CONVERSATION_LIST_MODEL_MONITOR_PROPERTY] = g_param_spec_object ("monitor", "monitor", "monitor", GEARY_APP_TYPE_CONVERSATION_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_ADDED_SIGNAL] = g_signal_new ("conversations-added", CONVERSATION_LIST_TYPE_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_REMOVED_SIGNAL] = g_signal_new ("conversations-removed", CONVERSATION_LIST_TYPE_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATIONS_LOADED_SIGNAL] = g_signal_new ("conversations-loaded", CONVERSATION_LIST_TYPE_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	conversation_list_model_signals[CONVERSATION_LIST_MODEL_CONVERSATION_UPDATED_SIGNAL] = g_signal_new ("conversation-updated", CONVERSATION_LIST_TYPE_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_APP_TYPE_CONVERSATION);
}

static void
conversation_list_model_g_list_model_interface_init (GListModelInterface * iface,
                                                     gpointer iface_data)
{
	conversation_list_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) conversation_list_model_real_get_item;
	iface->get_item_type = (GType (*) (GListModel*)) conversation_list_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) conversation_list_model_real_get_n_items;
}

static void
conversation_list_model_instance_init (ConversationListModel * self,
                                       gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = conversation_list_model_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->items = _tmp0_;
	self->priv->scanning = FALSE;
}

static void
conversation_list_model_finalize (GObject * obj)
{
	ConversationListModel * self;
	GearyAppConversationMonitor* _tmp0_;
	guint _tmp1_;
	GearyAppConversationMonitor* _tmp2_;
	guint _tmp3_;
	GearyAppConversationMonitor* _tmp4_;
	guint _tmp5_;
	GearyAppConversationMonitor* _tmp6_;
	guint _tmp7_;
	GearyAppConversationMonitor* _tmp8_;
	guint _tmp9_;
	GearyAppConversationMonitor* _tmp10_;
	guint _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_LIST_TYPE_MODEL, ConversationListModel);
	_tmp0_ = self->priv->_monitor;
	g_signal_parse_name ("conversations-added", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _conversation_list_model_on_conversations_added_geary_app_conversation_monitor_conversations_added, self);
	_tmp2_ = self->priv->_monitor;
	g_signal_parse_name ("conversation-appended", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_appended, self);
	_tmp4_ = self->priv->_monitor;
	g_signal_parse_name ("conversation-trimmed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _conversation_list_model_on_conversation_updated_geary_app_conversation_monitor_conversation_trimmed, self);
	_tmp6_ = self->priv->_monitor;
	g_signal_parse_name ("conversations-removed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _conversation_list_model_on_conversations_removed_geary_app_conversation_monitor_conversations_removed, self);
	_tmp8_ = self->priv->_monitor;
	g_signal_parse_name ("scan-started", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _conversation_list_model_on_scan_started_geary_app_conversation_monitor_scan_started, self);
	_tmp10_ = self->priv->_monitor;
	g_signal_parse_name ("scan-completed", GEARY_APP_TYPE_CONVERSATION_MONITOR, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _conversation_list_model_on_scan_completed_geary_app_conversation_monitor_scan_completed, self);
	_g_ptr_array_unref0 (self->items);
	_g_object_unref0 (self->priv->_monitor);
	G_OBJECT_CLASS (conversation_list_model_parent_class)->finalize (obj);
}

static GType
conversation_list_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListModel), 0, (GInstanceInitFunc) conversation_list_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) conversation_list_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_list_model_type_id;
	conversation_list_model_type_id = g_type_register_static (G_TYPE_OBJECT, "ConversationListModel", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_list_model_type_id, g_list_model_get_type (), &g_list_model_info);
	ConversationListModel_private_offset = g_type_add_instance_private (conversation_list_model_type_id, sizeof (ConversationListModelPrivate));
	return conversation_list_model_type_id;
}

GType
conversation_list_model_get_type (void)
{
	static volatile gsize conversation_list_model_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_model_type_id__once)) {
		GType conversation_list_model_type_id;
		conversation_list_model_type_id = conversation_list_model_get_type_once ();
		g_once_init_leave (&conversation_list_model_type_id__once, conversation_list_model_type_id);
	}
	return conversation_list_model_type_id__once;
}

static void
_vala_conversation_list_model_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ConversationListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_LIST_TYPE_MODEL, ConversationListModel);
	switch (property_id) {
		case CONVERSATION_LIST_MODEL_MONITOR_PROPERTY:
		g_value_set_object (value, conversation_list_model_get_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_conversation_list_model_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ConversationListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_LIST_TYPE_MODEL, ConversationListModel);
	switch (property_id) {
		case CONVERSATION_LIST_MODEL_MONITOR_PROPERTY:
		conversation_list_model_set_monitor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

