/* (c) 2001-2003 by Marcin Wiacek */

#include <string.h>

#include <gammu-info.h>

#include "gsmnet.h"
#include "../misc/coding/coding.h"

const GSM_CodeName GSM_Countries[] = {

	{"202", "Greece"},
	{"204", "Netherlands"},
	{"206", "Belgium"},
	{"208", "France"},
	{"212", "Monaco"},
	{"213", "Andorra"},
	{"214", "Spain"},
	{"216", "Hungary"},
	{"218", "Bosnia and Herzegovina"},
	{"219", "Croatia"},
	{"220", "Serbia"},
	{"221", "Kosovo"},
	{"222", "Italy"},
	{"225", "Vatican"},
	{"226", "Romania"},
	{"228", "Switzerland"},
	{"230", "Czech Republic"},
	{"231", "Slovakia"},
	{"232", "Austria"},
	{"234", "Guernsey"},
	{"234", "Isle of Man"},
	{"234", "Jersey"},
	{"234", "United Kingdom"},
	{"235", "United Kingdom"},
	{"238", "Denmark"},
	{"240", "Sweden"},
	{"242", "Norway"},
	{"244", "Finland"},
	{"246", "Lithuania"},
	{"247", "Latvia"},
	{"248", "Estonia"},
	{"250", "Russian Federation"},
	{"255", "Ukraine"},
	{"257", "Belarus"},
	{"259", "Moldova"},
	{"260", "Poland"},
	{"262", "Germany"},
	{"266", "Gibraltar"},
	{"268", "Portugal"},
	{"270", "Luxembourg"},
	{"272", "Ireland"},
	{"274", "Iceland"},
	{"276", "Albania"},
	{"278", "Malta"},
	{"280", "Cyprus"},
	{"282", "Georgia"},
	{"283", "Armenia"},
	{"284", "Bulgaria"},
	{"286", "Turkey"},
	{"288", "Faroe Islands"},
	{"289", "Abkhazia"},
	{"290", "Greenland"},
	{"292", "San Marino"},
	{"293", "Slovenia"},
	{"294", "North Macedonia"},
	{"295", "Liechtenstein"},
	{"297", "Montenegro"},
	{"302", "Canada"},
	{"308", "Saint Pierre and Miquelon"},
	{"310", "Guam"},
	{"310", "Northern Mariana Islands"},
	{"310", "United States of America"},
	{"311", "United States of America"},
	{"312", "United States of America"},
	{"313", "United States of America"},
	{"314", "United States of America"},
	{"315", "United States of America"},
	{"316", "United States of America"},
	{"330", "Puerto Rico"},
	{"332", "United States Virgin Islands"},
	{"334", "Mexico"},
	{"338", "Jamaica"},
	{"340", "French Antilles"},
	{"340", "Guadeloupe"},
	{"340", "Martinique"},
	{"340", "Saint Martin"},
	{"342", "Barbados"},
	{"344", "Antigua and Barbuda"},
	{"346", "Cayman Islands"},
	{"348", "British Virgin Islands"},
	{"350", "Bermuda"},
	{"352", "Grenada"},
	{"354", "Montserrat"},
	{"356", "Saint Kitts and Nevis"},
	{"358", "Saint Lucia"},
	{"360", "Saint Vincent and the Grenadines"},
	{"362", "Curacao"},
	{"362", "Sint Eustatius and Saba Bonaire"},
	{"362", "Sint Maarten"},
	{"363", "Aruba"},
	{"364", "Bahamas"},
	{"365", "Anguilla"},
	{"366", "Dominica"},
	{"368", "Cuba"},
	{"370", "Dominican Republic"},
	{"372", "Haiti"},
	{"374", "Trinidad and Tobago"},
	{"376", "Turks and Caicos Islands"},
	{"400", "Azerbaijan"},
	{"401", "Kazakhstan"},
	{"402", "Bhutan"},
	{"404", "India"},
	{"405", "India"},
	{"410", "Pakistan"},
	{"412", "Afghanistan"},
	{"413", "Sri Lanka"},
	{"414", "Myanmar"},
	{"415", "Lebanon"},
	{"416", "Jordan"},
	{"417", "Syria"},
	{"418", "Iraq"},
	{"419", "Kuwait"},
	{"420", "Saudi Arabia"},
	{"421", "Yemen"},
	{"422", "Oman"},
	{"424", "United Arab Emirates"},
	{"425", "Israel"},
	{"425", "Palestine"},
	{"426", "Bahrain"},
	{"427", "Qatar"},
	{"428", "Mongolia"},
	{"429", "Nepal"},
	{"430", "United Arab Emirates"},
	{"431", "United Arab Emirates"},
	{"432", "Iran"},
	{"434", "Uzbekistan"},
	{"436", "Tajikistan"},
	{"437", "Kyrgyzstan"},
	{"438", "Turkmenistan"},
	{"440", "Japan"},
	{"441", "Japan"},
	{"450", "South Korea"},
	{"452", "Vietnam"},
	{"454", "Hong Kong"},
	{"455", "Macau"},
	{"456", "Cambodia"},
	{"457", "Laos"},
	{"460", "China"},
	{"466", "Taiwan"},
	{"467", "North Korea"},
	{"470", "Bangladesh"},
	{"472", "Maldives"},
	{"502", "Malaysia"},
	{"505", "Australia"},
	{"505", "Norfolk Island"},
	{"510", "Indonesia"},
	{"514", "East Timor"},
	{"515", "Philippines"},
	{"520", "Thailand"},
	{"525", "Singapore"},
	{"528", "Brunei"},
	{"530", "New Zealand"},
	{"536", "Nauru"},
	{"537", "Papua New Guinea"},
	{"539", "Tonga"},
	{"540", "Solomon Islands"},
	{"541", "Vanuatu"},
	{"542", "Fiji"},
	{"543", "Wallis and Futuna"},
	{"544", "American Samoa"},
	{"545", "Kiribati"},
	{"546", "New Caledonia"},
	{"547", "French Polynesia"},
	{"548", "Cook Islands"},
	{"549", "Samoa"},
	{"550", "Federated States of Micronesia"},
	{"551", "Marshall Islands"},
	{"552", "Palau"},
	{"553", "Tuvalu"},
	{"554", "Tokelau"},
	{"555", "Niue"},
	{"602", "Egypt"},
	{"603", "Algeria"},
	{"604", "Morocco"},
	{"605", "Tunisia"},
	{"606", "Libya"},
	{"607", "Gambia"},
	{"608", "Senegal"},
	{"609", "Mauritania"},
	{"610", "Mali"},
	{"611", "Guinea"},
	{"612", "Ivory Coast"},
	{"613", "Burkina Faso"},
	{"614", "Niger"},
	{"615", "Togo"},
	{"616", "Benin"},
	{"617", "Mauritius"},
	{"618", "Liberia"},
	{"619", "Sierra Leone"},
	{"620", "Ghana"},
	{"621", "Nigeria"},
	{"622", "Chad"},
	{"623", "Central African Republic"},
	{"624", "Cameroon"},
	{"625", "Cape Verde"},
	{"626", "Sao Tome and Principe"},
	{"627", "Equatorial Guinea"},
	{"628", "Gabon"},
	{"629", "Congo"},
	{"630", "Democratic Republic of the Congo"},
	{"631", "Angola"},
	{"632", "Guinea-Bissau"},
	{"633", "Seychelles"},
	{"634", "Sudan"},
	{"635", "Rwanda"},
	{"636", "Ethiopia"},
	{"637", "Somalia"},
	{"638", "Djibouti"},
	{"639", "Kenya"},
	{"640", "Tanzania"},
	{"641", "Uganda"},
	{"642", "Burundi"},
	{"643", "Mozambique"},
	{"645", "Zambia"},
	{"646", "Madagascar"},
	{"647", "French Indian Ocean Territories"},
	{"648", "Zimbabwe"},
	{"649", "Namibia"},
	{"650", "Malawi"},
	{"651", "Lesotho"},
	{"652", "Botswana"},
	{"653", "Swaziland"},
	{"654", "Comoros"},
	{"655", "South Africa"},
	{"657", "Eritrea"},
	{"658", "Ascension and Tristan da Cunha Saint Helena"},
	{"659", "South Sudan"},
	{"702", "Belize"},
	{"704", "Guatemala"},
	{"706", "El Salvador"},
	{"708", "Honduras"},
	{"710", "Nicaragua"},
	{"712", "Costa Rica"},
	{"714", "Panama"},
	{"716", "Peru"},
	{"722", "Argentina"},
	{"724", "Brazil"},
	{"730", "Chile"},
	{"732", "Colombia"},
	{"734", "Venezuela"},
	{"736", "Bolivia"},
	{"738", "Guyana"},
	{"740", "Ecuador"},
	{"742", "French Guiana"},
	{"744", "Paraguay"},
	{"746", "Suriname"},
	{"748", "Uruguay"},
	{"750", "Falkland Islands"},
	{"901", "International operators"},
	{"902", "International operators"},
	{"991", "International operators"},
	{"995", "British Indian Ocean Territory"},
	{"995", "International operators"},

	{"999", "Dummy"},

	{"", ""},
};

const GSM_CodeName GSM_Networks[] = {

	{"001 01", "TEST"},
	{"202 00", "Inter Telecom"},
	{"202 01", "Cosmote"},
	{"202 02", "Cosmote"},
	{"202 03", "OTE"},
	{"202 04", "OSE"},
	{"202 05", "Vodafone"},
	{"202 06", "Vodafone Greece"},
	{"202 07", "AMD Telecom"},
	{"202 08", "RC"},
	{"202 09", "NOVA"},
	{"202 10", "NOVA"},
	{"202 11", "interConnect"},
	{"202 12", "Yuboto"},
	{"202 13", "Compatel Limited"},
	{"202 14", "Vodafone Greece"},
	{"202 15", "BWS"},
	{"202 16", "interConnect"},
	{"202 17", "NOVA"},
	{"202 21", "Cell Mobile"},
	{"204 00", "Intovoice B.V."},
	{"204 01", "RadioAccess Network Services"},
	{"204 02", "Odido"},
	{"204 03", "Enreach"},
	{"204 04", "Vodafone"},
	{"204 05", "Elephant Talk Communications Premium Rate Services"},
	{"204 06", "Private Mobility Nederland B.V."},
	{"204 07", "Teleena"},
	{"204 08", "KPN"},
	{"204 09", "Lycamobile"},
	{"204 10", "KPN"},
	{"204 11", "Greenet Netwerk B.V"},
	{"204 12", "Telfort"},
	{"204 13", "Unica Installatietechniek B.V."},
	{"204 14", "Venus & Mercury Telecom"},
	{"204 15", "Ziggo"},
	{"204 16", "Odido"},
	{"204 17", "Lebara Ltd"},
	{"204 18", "Ziggo"},
	{"204 19", "Mixe Communication Solutions B.V."},
	{"204 20", "Odido"},
	{"204 21", "ProRail B.V."},
	{"204 22", "Ministerie van Defensie"},
	{"204 23", "KORE Wireless Nederland B.V."},
	{"204 24", "PM Factory B.V."},
	{"204 25", "CapX B.V."},
	{"204 26", "SpeakUp B.V."},
	{"204 27", "L-mobi"},
	{"204 28", "Lancelot B.V."},
	{"204 29", "Tismi B.V."},
	{"204 30", "ASpider Solutions Nederland B.V."},
	{"204 32", "Cubic Telecom Limited"},
	{"204 33", "Truphone B.V."},
	{"204 60", "Nextgen Mobile Ltd"},
	{"204 61", "Alcadis B.V."},
	{"204 62", "RGTN"},
	{"204 63", "Messagebird BV"},
	{"204 64", "Zetacom B.V."},
	{"204 65", "AGMS Netherlands B.V."},
	{"204 66", "Utility Connect B.V."},
	{"204 67", "Koning en Hartman B.V."},
	{"204 68", "Roamware (Netherlands) B.V."},
	{"204 69", "KPN Mobile The Netherlands B.V."},
	{"204 91", "Enexis Netbeheer B.V."},
	{"206 00", "Proximus"},
	{"206 01", "Proximus"},
	{"206 02", "Infrabel"},
	{"206 03", "Citymesh Connect"},
	{"206 04", "MWingz"},
	{"206 05", "Telenet"},
	{"206 06", "Lycamobile"},
	{"206 07", "Vectone Mobile"},
	{"206 08", "VOO"},
	{"206 09", "Proximus SA"},
	{"206 10", "Orange Belgium"},
	{"206 11", "L-mobi"},
	{"206 12", "DIGI Belgium"},
	{"206 13", "CWave"},
	{"206 14", "ALLOcloud"},
	{"206 15", "Elephant Talk Communications Schweiz GmbH"},
	{"206 16", "NextGen Mobile Ltd."},
	{"206 20", "Base"},
	{"206 22", "Febo.mobi"},
	{"206 23", "Dust Mobile"},
	{"206 25", "Citymesh Air"},
	{"206 28", "BICS"},
	{"206 29", "TISMI"},
	{"206 30", "Proximus SA"},
	{"206 33", "Ericsson NV"},
	{"206 34", "ONOFFAPP OU"},
	{"206 40", "JOIN"},
	{"206 42", "Mediafon Carrier Services UAB"},
	{"206 48", "Network Research Belgium"},
	{"206 50", "IP Nexia"},
	{"206 70", "iSea"},
	{"206 71", "test"},
	{"206 72", "test"},
	{"206 73", "test"},
	{"206 74", "test"},
	{"206 75", "SGRS Cyber Command"},
	{"206 99", "e-BO Enterprises"},
	{"208 01", "Orange"},
	{"208 02", "Orange"},
	{"208 03", "Onoff Telecom"},
	{"208 04", "Nexera"},
	{"208 05", "Globalstar Europe"},
	{"208 06", "Globalstar Europe"},
	{"208 07", "Globalstar Europe"},
	{"208 08", "SFR"},
	{"208 09", "SFR"},
	{"208 10", "SFR"},
	{"208 11", "SFR"},
	{"208 12", "1Global Operations France"},
	{"208 13", "SFR"},
	{"208 14", "SNCF Reseau"},
	{"208 15", "Free"},
	{"208 16", "Free"},
	{"208 17", "LEGOS"},
	{"208 18", "Voxbone"},
	{"208 19", "Haute-Garonne numerique"},
	{"208 20", "Bouygues"},
	{"208 21", "Bouygues"},
	{"208 22", "Transatel Mobile"},
	{"208 23", "Syndicat mixte ouvert Charente Numerique"},
	{"208 24", "Sierra Wireless"},
	{"208 25", "LycaMobile"},
	{"208 26", "NRJ Mobile"},
	{"208 27", "Coriolis Telecom"},
	{"208 28", "AIF"},
	{"208 29", "Cubic telecom France"},
	{"208 30", "Syma Mobile"},
	{"208 31", "Vectone Mobile"},
	{"208 32", "Orange"},
	{"208 33", "Fibre64"},
	{"208 34", "Cellhire France"},
	{"208 35", "Free"},
	{"208 36", "Free"},
	{"208 37", "IP Directions"},
	{"208 38", "Lebara France Ltd"},
	{"208 39", "Netwo"},
	{"208 500", "EDF"},
/*
 *	Following are too long for the current structure, pending for ABI change
 *
	{"208 50144", "TotalEnergies Global Information Technology services"},
	{"208 50164", "TotalEnergies Global Information Technology services"},
	{"208 50168", "Butachimie"},
	{"208 50169", "Eiffage Energie Systemes"},
	{"208 50176", "Grand port fluvio-maritime de l'axe Seine"},
	{"208 50177", "Societe des Grands Projets"},
	{"208 50192", "Societe des Grands Projets"},
	{"208 50193", "Societe des Grands Projets"},
	{"208 50194", "Societe des Grands Projets"},
	{"208 50244", "EDF"},
	{"208 50268", "Constellium Neuf-Brisach"},
	{"208 50277", "Celeste"},
	{"208 50357", "ArcelorMittal France"},
	{"208 50359", "ArcelorMittal France"},
	{"208 50387", "Axione"},
	{"208 50430", "Centre a l'energie atomique et aux energies alternatives"},
	{"208 50484", "Centre a l'energie atomique et aux energies alternatives"},
	{"208 50531", "Alsatis"},
	{"208 50549", "Thales SIX GTS France"},
	{"208 50591", "Societe des Grands Projets"},
	{"208 50631", "Airbus"},
	{"208 50644", "Airbus"},
	{"208 50692", "Axione"},
	{"208 50778", "GTS France"},
	{"208 50876", "Hanseatic Global Terminals Le Havre"},
	{"208 50877", "Euro Disney Associes SAS"},
	{"208 50935", "SNCF"},
	{"208 50967", "SNCF"},
	{"208 50975", "SNCF"},
	{"208 51075", "RATP"},
	{"208 51094", "RATP"},
*/
	{"208 670", "P1 Security"},
	{"208 700", "Weaccess group"},
	{"208 701", "GIP Vendee numerique"},
	{"208 702", "17-Numerique"},
	{"208 703", "Nivertel"},
	{"208 704", "Axione Limousin"},
	{"208 705", "Hautes-Pyrenees Numerique"},
	{"208 706", "Tours Metropole Numerique"},
	{"208 707", "Sartel THD"},
	{"208 708", "Melis@ territoires ruraux"},
	{"208 709", "Quimper communaute telecom"},
	{"208 710", "Losange"},
	{"208 711", "Nomotech"},
	{"208 712", "Syndicat Audois d'energies et du Numerique"},
	{"208 713", "SD NUM SAS"},
	{"208 714", "Departement de l'Isere"},
	{"208 86", "SEM@FOR77"},
	{"208 87", "Airbus defence and space SAS"},
	{"208 88", "Bouygues"},
	{"208 89", "Hub One"},
	{"208 90", "Images & Reseaux"},
	{"208 91", "Orange S.A."},
	{"208 92", "Com4Innov"},
	{"208 93", "Thales Communications & Security SAS"},
	{"208 94", "Halys"},
	{"208 95", "Orange S.A."},
	{"208 96", "Region Bourgogne-Franche-Comte"},
	{"208 97", "Thales Communications & Security SAS"},
	{"208 98", "Societe Air France"},
	{"212 10", "Monaco Telecom"},
	{"213 03", "Som, Mobiland"},
	{"214 01", "Vodafone"},
	{"214 02", "Cube Movil"},
	{"214 03", "Orange"},
	{"214 04", "Yoigo"},
	{"214 05", "Movistar"},
	{"214 06", "Vodafone"},
	{"214 07", "Movistar"},
	{"214 08", "Euskaltel"},
	{"214 09", "Orange"},
	{"214 10", "ZINNIA TELECOMUNICACIONES, S.L.U."},
	{"214 11", "TELECOM CASTILLA-LA MANCHA, S.A."},
	{"214 12", "VENUS MOVIL, S.L. UNIPERSONAL"},
	{"214 13", "FOOTBALLERISTA MOBILE SPAIN, S.A."},
	{"214 14", "AVATEL MOVIL, S.L.U."},
	{"214 15", "PROCONO, S.A."},
	{"214 16", "TeleCable"},
	{"214 17", "Mobil R"},
	{"214 18", "ONO"},
	{"214 19", "Simyo"},
	{"214 20", "Fonyou"},
	{"214 21", "Jazztel"},
	{"214 22", "DIGI mobil"},
	{"214 23", "Xfera Moviles S.A.U."},
	{"214 24", "VODAFONE ESPANA, S.A.U."},
	{"214 25", "Xfera Moviles S.A.U."},
	{"214 26", "Lleida Networks Serveis Telematics, SL"},
	{"214 27", "Truphone"},
	{"214 28", "Murcia4G"},
	{"214 29", "Xfera Moviles S.A.U."},
	{"214 30", "Compatel Limited"},
	{"214 31", "Red Digital De Telecomunicaciones de las Islas Baleares, S.L."},
	{"214 32", "Tuenti"},
	{"214 33", "Xfera Moviles, S.A.U."},
	{"214 34", "Aire Networks del Mediterraneo, S.L.U."},
	{"214 35", "INGENIUM OUTSOURCING SERVICES, S.L."},
	{"214 36", "ALAI OPERADOR DE TELECOMUNICACIONES, S.L"},
	{"214 37", "Vodafone Spain"},
	{"214 38", "Telefonica Moviles Espana, S.A.U."},
	{"214 51", "ADIF"},
	{"214 700", "Iberdrola"},
	{"214 701", "Endesa"},
	{"214 702", "Universidad de Malaga"},
	{"214 703", "ENDESA GENERACION, S.A."},
	{"214 704", "Amper Sistemas, S.A.U."},
	{"214 705", "Administrador de Infraestructuras Ferroviarias"},
	{"214 706", "Gobierno Vasco"},
	/* Shortened to fit, use full name after ABI change */
	{"214 707", "Centro de Sistemas y Tecnologias de la Informacion"},
	{"214 709", "CTTI"},
	{"216 01", "Yettel Hungary"},
	{"216 02", "HM EI Zrt."},
	{"216 03", "one"},
	{"216 04", "Pro-M PrCo. Ltd."},
	{"216 20", "Yettel Hungary"},
	{"216 25", "Yettel Hungary"},
	{"216 30", "Telekom"},
	{"216 70", "one"},
	{"216 71", "one"},
	{"216 99", "MAV GSM-R"},
	{"218 03", "HT-ERONET"},
	{"218 05", "m:tel"},
	{"218 90", "BH Mobile"},
	{"219 01", "HT HR"},
	{"219 02", "Telemach"},
	{"219 03", "ALTAVOX d.o.o."},
	{"219 04", "NTH Mobile d.o.o."},
	{"219 10", "A1 HR"},
	{"219 12", "TELE FOCUS d.o.o."},
	{"219 13", "FENICE TELEKOM GRUPA d.o.o."},
	{"219 15", "BSG Estonia OU"},
	{"219 19", "YATECO"},
	{"219 20", "T-Mobile HR"},
	{"219 22", "Mobile One"},
	{"219 28", "Lancelot B.V."},
	{"219 30", "INNOVACOM OU"},
	{"219 55", "DIGICOM d.o.o."},
	{"219 99", "Markoja d.o.o."},
	{"220 01", "Yettel"},
	{"220 02", "One"},
	{"220 03", "mt:s"},
	{"220 04", "T-Mobile CG"},
	{"220 05", "A1 SRB"},
	{"220 07", "Orion"},
	{"220 09", "Vectone Mobile"},
	{"220 11", "Globaltel"},
	{"220 12", "STmobile"},
	{"220 14", "Ringtel Mobile d.o.o."},
	{"220 20", "A1 SRB"},
	{"220 21", "Infrastruktura zeleznice Srbije a.d."},
	{"221 01", "Vala"},
	{"221 02", "IPKO"},
	{"221 06", "Z Mobile"},
	{"221 07", "D3 Mobile"},
	{"222 01", "TIM"},
	{"222 02", "Elsacom"},
	{"222 04", "Intermatica"},
	{"222 05", "Telespazio"},
	{"222 06", "Vodafone"},
	{"222 07", "Kena Mobile"},
	{"222 08", "Fastweb"},
	{"222 10", "Vodafone"},
	{"222 30", "RFI"},
	{"222 33", "PosteMobile"},
	{"222 34", "BT Mobile/BT Enia"},
	{"222 35", "Lycamobile"},
	{"222 36", "Digi Mobil"},
	{"222 37", "Wind Tre"},
	{"222 38", "Linkem"},
	{"222 39", "SMS Italia"},
	{"222 41", "GO Internet"},
	{"222 43", "TIM"},
	{"222 47", "Fastweb"},
	{"222 48", "TIM"},
	{"222 49", "Vianova"},
	{"222 50", "Iliad"},
	{"222 53", "CoopVoce"},
	{"222 54", "Plintron"},
	{"222 56", "spusu"},
	{"222 77", "IPSE 2000"},
	{"222 88", "Wind Tre"},
	{"222 98", "Blu"},
	{"222 99", "Wind Tre"},
	{"226 01", "Vodafone"},
	{"226 02", "Clicknet Mobile"},
	{"226 03", "Telekom"},
	{"226 04", "Cosmote/Zapp"},
	{"226 05", "Digi.Mobil"},
	{"226 06", "Telekom"},
	{"226 10", "Orange"},
	{"226 11", "Enigma-System"},
	{"226 15", "Idilis"},
	{"226 16", "Lycamobile"},
	{"226 19", "CFR"},
	{"228 01", "Swisscom"},
	{"228 02", "Sunrise"},
	{"228 03", "Salt"},
	{"228 05", "Comfone AG"},
	{"228 06", "SBB-CFF-FFS"},
	{"228 07", "IN&Phone"},
	{"228 08", "Tele4u"},
	{"228 09", "Comfone AG"},
	{"228 10", "Stadt Polizei Zurich"},
	{"228 11", "Swisscom Broadcast AG"},
	{"228 12", "Sunrise"},
	{"228 13", "SBB-CFF-FFS"},
	{"228 50", "3G Mobile AG"},
	{"228 51", "relario AG"},
	{"228 52", "Barablu"},
	{"228 53", "upc cablecom"},
	{"228 54", "Lycamobile"},
	{"228 55", "Komodos SA"},
	{"228 56", "SMSRelay AG"},
	{"228 57", "Mitto AG"},
	{"228 58", "beeone"},
	{"228 59", "Vectone"},
	{"228 60", "Sunrise"},
	{"228 61", "Compatel Ltd."},
	{"228 62", "Telecom26 AG"},
	{"228 63", "FTS"},
	{"228 64", "Nth AG"},
	{"228 65", "Nexphone AG"},
	{"228 66", "Inovia Services SA"},
	{"228 67", "Datatrade Managed AG"},
	{"228 68", "Intellico AG"},
	{"228 69", "MTEL Schweiz GmbH"},
	{"228 70", "Tismi BV"},
	{"228 71", "spusu"},
	{"228 72", "SolNet"},
	{"228 73", "iWay"},
	{"228 74", "net+"},
	{"228 75", "Telecom Liechtenstein AG"},
	{"228 80", "Phonegroup SA"},
	{"228 98", "Etablissement Cantonal d'Assurance"},
	{"228 99", "Swisscom Broadcast AG"},
	{"230 01", "T-Mobile"},
	{"230 02", "O2"},
	{"230 03", "Vodafone"},
	{"230 04", "Nordic Telecom"},
	{"230 05", "PODA a.s."},
	{"230 06", "Nordic Telecom 5G a.s."},
	{"230 07", "T-Mobile"},
	{"230 08", "Compatel s.r.o."},
	{"230 09", "Unimobile"},
	{"230 10", "DataCell s.r.o."},
	{"230 11", "incrate s.r.o."},
	{"230 22", "O2"},
	{"230 53", "Skoda Auto a.s."},
	{"230 98", "Sprava zeleznicni dopravni cesty, s.o."},
	{"230 99", "Vodafone"},
	{"231 01", "Orange"},
	{"231 02", "Telekom"},
	{"231 03", "4ka"},
	{"231 04", "Telekom"},
	{"231 05", "Orange"},
	{"231 06", "O2"},
	{"231 07", "Orange"},
	{"231 08", "Unimobile"},
	{"231 09", "DSI DATA, a.s."},
	{"231 10", "HMZ RADIOKOMUNIKACIE, spol. s r.o."},
	{"231 50", "Telekom"},
	{"231 51", "CETIN Networks, s. r. o."},
	{"231 99", "ZSR"},
	{"232 01", "A1.net"},
	{"232 02", "A1 Telekom Austria"},
	{"232 03", "Magenta"},
	{"232 04", "Magenta"},
	{"232 05", "3"},
	{"232 06", "Orange AT"},
	{"232 07", "Hofer Telekom"},
	{"232 08", "Lycamobile"},
	{"232 09", "Tele2Mobil"},
	{"232 10", "3"},
	{"232 11", "bob"},
	{"232 12", "yesss!"},
	{"232 13", "Magenta"},
	{"232 14", "Hutchison Drei Austria"},
	{"232 15", "Vectone Mobile"},
	{"232 16", "Hutchison Drei Austria"},
	{"232 17", "spusu"},
	{"232 18", "I-new"},
	{"232 19", "Hutchison Drei Austria"},
	{"232 20", "m:tel"},
	{"232 21", "Salzburg AG fur Energie, Verkehr und Telekommunikation"},
	{"232 22", "Plintron Austria Limited"},
	{"232 23", "Magenta"},
	{"232 24", "Smartel Services GmbH"},
	{"232 25", "Holding Graz Kommunale Dienstleistungen GmbH"},
	{"232 26", "LIWEST Kabelmedien GmbH"},
	{"232 27", "TISMI B.V."},
	{"232 28", "MASS Response Service GmbH"},
	{"232 29", "aicall telekommunikation"},
	{"232 30", "Holding Graz Kommunale Dienstleistungen GmbH"},
	{"232 91", "GSM-R A"},
	{"232 92", "ArgoNET"},
	{"234 00", "BT"},
	{"234 01", "Vectone Mobile"},
	{"234 02", "O2 (UK)"},
	{"234 03", "Airtel-Vodafone"},
	{"234 03", "Airtel-Vodafone"},
	{"234 03", "Airtel-Vodafone"},
	{"234 04", "Wave Mobile Ltd"},
	{"234 05", "Spitfire Network Services Limited"},
	{"234 06", "Internet Computer Bureau Limited"},
	{"234 07", "Vodafone UK"},
	{"234 08", "BT OnePhone"},
	{"234 09", "Tismi BV"},
	{"234 10", "O2 (UK)"},
	{"234 11", "O2 (UK)"},
	{"234 12", "Railtrack"},
	{"234 13", "Railtrack"},
	{"234 14", "HSL Messaging Limited"},
	{"234 15", "Vodafone UK"},
	{"234 16", "Talk Talk"},
	{"234 17", "FleXtel Limited"},
	{"234 18", "Cloud 9 Mobile"},
	{"234 18", "Cloud9"},
	{"234 19", "PMN"},
	{"234 20", "3"},
	{"234 21", "LogicStar Ltd"},
	{"234 22", "Telesign Mobile Limited"},
	{"234 23", "Icron Network Limited"},
	{"234 24", "Greenfone"},
	{"234 25", "Truphone"},
	{"234 26", "Lycamobile"},
	{"234 27", "Teleena"},
	{"234 28", "Marathon Telecom Limited"},
	{"234 28", "Marathon Telecom Limited"},
	{"234 29", "aql"},
	{"234 30", "EE"},
	{"234 31", "EE"},
	{"234 32", "EE"},
	{"234 33", "EE"},
	{"234 34", "EE"},
	{"234 35", "JSC Ingenium (UK) Limited"},
	{"234 36", "Sure Mobile"},
	{"234 36", "Sure Mobile"},
	{"234 37", "Synectiv Ltd"},
	{"234 38", "Virgin Mobile"},
	{"234 39", "Gamma Telecom Holdings Ltd."},
	{"234 40", "spusu"},
	{"234 50", "JT"},
	{"234 50", "JT"},
	{"234 50", "JT"},
	{"234 51", "Relish"},
	{"234 52", "Shyam Telecom UK Ltd"},
	{"234 53", "Tango Extend"},
	{"234 54", "iD Mobile"},
	{"234 55", "Sure Mobile"},
	{"234 55", "Sure Mobile"},
	{"234 55", "Sure Mobile"},
	{"234 56", "National Cyber Security Centre"},
	{"234 57", "Sky"},
	{"234 58", "Pronto GSM"},
	{"234 58", "Pronto GSM"},
	{"234 59", "Limitless Mobile Ltd"},
	{"234 70", "AMSUK Ltd."},
	{"234 71", "Home Office"},
	{"234 72", "Hanhaa Mobile"},
	{"234 73", "Bluewave Communications Ltd"},
	{"234 73", "Bluewave Communications Ltd."},
	{"234 74", "Circles MVNE International B.V."},
	{"234 75", "MASS Response Service GmbH"},
	{"234 76", "BT"},
	{"234 77", "Vodafone UK"},
	{"234 78", "Airwave"},
	{"234 79", "UKTL"},
	{"234 81", "National Grid Telecoms Limited"},
	{"234 82", "GeoNetworks"},
	{"234 83", "UKTL"},
	{"234 84", "National Grid Telecoms Limited"},
	{"234 86", "EE Limited"},
	{"234 87", "Lebara"},
	{"234 88", "telet"},
	{"235 01", "EE"},
	{"235 02", "EE"},
	{"235 03", "Relish"},
	{"235 04", "University of Strathclyde"},
	{"235 06", "University of Strathclyde"},
	{"235 07", "University of Strathclyde"},
	{"235 08", "Spitfire Network Services Limited"},
	{"235 77", "BT"},
	{"235 88", "telet"},
	{"235 91", "Vodafone UK"},
	{"235 92", "Vodafone UK"},
	{"235 94", "Hutchison 3G UK Ltd"},
	{"235 95", "Network Rail Infrastructure Limited"},
	{"238 01", "TDC"},
	{"238 02", "Telenor"},
	{"238 03", "Syniverse Technologies"},
	{"238 04", "Nexcon.io ApS"},
	{"238 05", "TetraNet"},
	{"238 06", "3"},
	{"238 07", "Vectone Mobile"},
	{"238 08", "Voxbone"},
	{"238 09", "SINE"},
	{"238 10", "TDC"},
	{"238 11", "SINE"},
	{"238 12", "Lycamobile"},
	{"238 13", "Compatel Limited"},
	{"238 14", "Monty UK Global Limited"},
	{"238 15", "Net 1"},
	{"238 16", "Tismi B.V."},
	{"238 17", "Gotanet AB"},
	{"238 18", "Cubic Telecom"},
	{"238 19", "YATECO OU"},
	{"238 20", "Telia"},
	{"238 23", "GSM-R DK"},
	{"238 25", "Viahub"},
	{"238 28", "LINK Mobile A/S"},
	{"238 30", "Interactive digital media GmbH"},
	{"238 40", "Ericsson Danmark A/S"},
	{"238 42", "Wavely"},
	{"238 43", "MobiWeb Limited"},
	{"238 66", "TT-Netvaerket P/S"},
	{"238 73", "Onomondo"},
	{"238 77", "Telenor"},
	{"238 88", "Cobira ApS"},
	{"238 95", "Dansk Beredskabskommunikation A/S"},
	{"238 96", "Telia"},
	{"240 01", "Telia"},
	{"240 02", "3"},
	{"240 03", "Net 1"},
	{"240 04", "SWEDEN"},
	{"240 05", "Sweden 3G"},
	{"240 06", "Telenor"},
	{"240 07", "Tele2"},
	{"240 08", "Telenor"},
	{"240 09", "Com4"},
	{"240 10", "Spring Mobil"},
	{"240 11", "GlobalCell"},
	{"240 12", "Lycamobile"},
	{"240 13", "Bredband2 Allmanna IT AB"},
	{"240 14", "Tele2 Sverige AB"},
	{"240 15", "Sierra Wireless Sweden AB"},
	{"240 16", "42 Telecom AB"},
	{"240 17", "Gotanet"},
	{"240 18", "Generic Mobile Systems Sweden AB"},
	{"240 19", "Vectone Mobile"},
	{"240 20", "Sierra Wireless Sweden AB"},
	{"240 21", "MobiSir"},
	{"240 22", "Mediafon Carrier Services UAB"},
	{"240 23", "Infobip Limited (UK)"},
	{"240 24", "Sweden 2G"},
	{"240 25", "Monty UK Global Ltd"},
	{"240 26", "Twilio Sweden AB"},
	{"240 27", "GlobeTouch AB"},
	{"240 28", "LINK Mobile A/S"},
	{"240 29", "Mercury International Carrier Services AB"},
	{"240 30", "Teracom AB"},
	{"240 31", "RebTel Network AB"},
	{"240 32", "Compatel Limited"},
	{"240 33", "Mobile Arts AB"},
	{"240 34", "Trafikverket centralfunktion IT"},
	{"240 35", "42 Telecom LTD"},
	{"240 36", "interactive digital media GmbH"},
	{"240 37", "Sinch Sweden AB"},
	{"240 38", "Voxbone"},
	{"240 39", "Primlight AB"},
	{"240 40", "Netmore Group AB"},
	{"240 41", "Telenor Sverige AB"},
	{"240 42", "Telenor IoT"},
	{"240 43", "MobiWeb Ltd."},
	{"240 44", "Telenabler AB"},
	{"240 45", "Spirius AB"},
	{"240 46", "Viahub"},
	{"240 47", "Viatel Sweden AB"},
	{"240 48", "Tismi BV"},
	{"240 49", "Telia Sverige AB"},
	{"240 50", "eRate Sverige AB"},
	{"240 51", "YATECO OU"},
	{"240 58", "Telia Sverige AB"},
	{"240 59", "Rakel G2"},
	{"240 60", "Vastra Gotalandsregionen"},
	{"240 61", "MessageBird B.V."},
	{"240 63", "FTS"},
	{"240 900", "Vastra Gotalandsregionen"},
	{"242 01", "Telenor"},
	{"242 02", "Telia"},
	{"242 03", "Televerket AS"},
	{"242 04", "Tele2"},
	{"242 05", "OneCall / MyCall"},
	{"242 06", "ice"},
	{"242 07", "Phonero"},
	{"242 08", "Telia"},
	{"242 09", "Com4"},
	{"242 10", "Nasjonal kommunikasjonsmyndighet"},
	{"242 11", "SystemNet"},
	{"242 12", "Telenor"},
	{"242 13", "IXT AS"},
	{"242 14", "ice"},
	{"242 15", "eRate Norway AS"},
	{"242 16", "Iristel Norway AS"},
	{"242 17", "Telenor"},
	{"242 20", "Jernbaneverket AS"},
	{"242 21", "Jernbaneverket AS"},
	{"242 22", "Lyse Tele AS"},
	{"242 23", "Lycamobile"},
	{"242 24", "Mobile Norway AS"},
	{"242 25", "CYFOR"},
	{"242 70", "test networks"},
	{"242 71", "private networks"},
	{"242 72", "private networks"},
	{"242 73", "private networks"},
	{"242 74", "private networks"},
	{"242 75", "private networks"},
	{"242 90", "Nokia Solutions and Networks Norge AS"},
	{"242 99", "TampNet AS"},
	{"244 03", "DNA"},
	{"244 04", "DNA"},
	{"244 05", "Elisa"},
	{"244 06", "Elisa"},
	{"244 07", "Nokia"},
	{"244 08", "Nokia"},
	{"244 09", "Nokia Solutions and Networks Oy"},
	{"244 10", "Traficom"},
	{"244 11", "Traficom"},
	{"244 12", "DNA"},
	{"244 13", "DNA"},
	{"244 14", "Alcom"},
	{"244 15", "Telit Wireless Solutions GmbH"},
	{"244 16", "Digita Oy"},
	{"244 17", "Liikennevirasto"},
	{"244 19", "Nettia Oy"},
	{"244 20", "Elisa Oyj"},
	{"244 21", "Elisa- Saunalahti"},
	{"244 22", "EXFO Oy"},
	{"244 23", "EXFO Oy"},
	{"244 24", "Nord Connect UAB"},
	{"244 25", "Fortum Power and Heat Oy"},
	{"244 26", "Teollisuuden Voima Oyj"},
	{"244 27", "Teknologian tutkimuskeskus VTT Oy"},
	{"244 28", "Teknologian tutkimuskeskus VTT Oy"},
	{"244 29", "Teknologian tutkimuskeskus VTT Oy"},
	{"244 30", "Teknologian tutkimuskeskus VTT Oy"},
	{"244 31", "Teknologian tutkimuskeskus VTT Oy"},
	{"244 32", "Voxbone"},
	{"244 33", "VIRVE"},
	{"244 34", "Bittium Wireless"},
	{"244 35", "Edzcom Oy"},
	{"244 36", "Telia / DNA"},
	{"244 37", "Tismi"},
	{"244 38", "Nokia Solutions and Networks Oy"},
	{"244 39", "Nokia Solutions and Networks Oy"},
	{"244 40", "Nokia Solutions and Networks Oy"},
	{"244 41", "Nokia Solutions and Networks Oy"},
	{"244 42", "SMS Provider Corp."},
	{"244 43", "Telavox AB / Telavox Oy"},
	{"244 44", "Turun ammattikorkeakoulu Oy"},
	{"244 45", "Suomen Turvallisuusverkko Oy"},
	{"244 46", "Suomen Turvallisuusverkko Oy"},
	{"244 47", "Suomen Turvallisuusverkko Oy"},
	{"244 50", "Aalto-korkeakoulusaatio sr"},
	{"244 51", "Aalto-korkeakoulusaatio sr"},
	{"244 52", "Aalto-korkeakoulusaatio sr"},
	{"244 53", "Aalto-korkeakoulusaatio sr"},
	{"244 54", "Aalto-korkeakoulusaatio sr"},
	{"244 55", "Aalto-korkeakoulusaatio sr"},
	{"244 56", "Aalto-korkeakoulusaatio sr"},
	{"244 57", "Aalto-korkeakoulusaatio sr"},
	{"244 58", "Aalto-korkeakoulusaatio sr"},
	{"244 59", "Aalto-korkeakoulusaatio sr"},
	{"244 91", "Telia"},
	{"244 92", "Sonera"},
	{"244 93", "Telia Finland Oyj"},
	{"244 95", "Sateilyturvakeskus"},
	{"244 99", "Oy L M Ericsson Ab"},
	{"246 01", "Telia"},
	{"246 02", "BITE"},
	{"246 03", "Tele2"},
	/* Shortened to fit, use full name after ABI change */
	{"246 04", "Informatikos ir rysiu LR vidaus reikalu ministerija"},
	{"246 05", "LTG Infra"},
	{"246 06", "Mediafon"},
	{"246 07", "Compatel Ltd."},
	{"246 08", "UAB Bite Lietuva"},
	{"246 09", "Interactive Digital Media GmbH"},
	{"246 11", "DATASIM OU"},
	{"246 12", "Nord connect OU"},
	{"246 13", "Travel Communication SIA"},
	{"246 14", "Tismi BV"},
	{"246 15", "Esim telecom, UAB"},
	{"246 16", "Annecto Telecom Limited"},
	{"247 01", "LMT"},
	{"247 02", "Tele2"},
	{"247 03", "TRIATEL"},
	{"247 04", "Beta Telecom"},
	{"247 05", "Bite"},
	{"247 06", "Bite"},
	{"247 07", "SIA \"MEGATEL\""},
	{"247 08", "VMT"},
	{"247 09", "Xomobile"},
	{"247 10", "LMT"},
	{"247 11", "LMT"},
	{"248 01", "Telia"},
	{"248 02", "Elisa"},
	{"248 03", "Tele2"},
	{"248 04", "Top Connect"},
	{"248 05", "CSC Telecom"},
	{"248 06", "Progroup Holding"},
	{"248 07", "Kou"},
	{"248 08", "VIVEX"},
	{"248 09", "Bravo Telecom"},
	{"248 10", "Intergo Telecom OU"},
	{"248 11", "UAB Raystorm Eesti filiaal"},
	{"248 12", "Ntel Solutions OU"},
	{"248 13", "Telia Eesti AS"},
	{"248 14", "Estonian Crafts OU"},
	{"248 15", "BSG Estonia OU"},
	{"248 16", "dzinga"},
	{"248 17", "Baltergo OU"},
	{"248 18", "Cloud Communications OU"},
	{"248 19", "OkTelecom OU"},
	{"248 20", "DOTT Telecom OU"},
	{"248 21", "Trinavo LLC"},
	{"248 22", "M2MConnect OU"},
	{"248 24", "Novametro OU"},
	{"248 25", "Eurofed OU"},
	{"248 26", "IT-Decision Telecom OU"},
	{"248 28", "Nord Connect OU"},
	{"248 29", "SkyTel OU"},
	{"248 30", "Mediafon Carrier Services OU"},
	{"248 31", "YATECO OU"},
	{"248 32", "Narayana OU"},
	{"248 33", "JAZZ MOBILE"},
	{"248 34", "Nettora Systems OU"},
	{"248 35", "Teliqon Communications OU"},
	{"248 36", "GlobalCell EU"},
	{"248 37", "Revaltex Group OU"},
	{"248 71", "Siseministeerium (Ministry of Interior)"},
	{"250 01", "MTS"},
	{"250 02", "MegaFon"},
	{"250 03", "NCC"},
	{"250 04", "Sibchallenge"},
	{"250 05", "ETK"},
	{"250 06", "Skylink"},
	{"250 07", "SMARTS"},
	{"250 08", "Vainah Telecom"},
	{"250 09", "Skylink"},
	{"250 10", "DTC"},
	{"250 11", "Yota"},
	{"250 12", "Akos"},
	{"250 12", "Baykalwestcom"},
	{"250 13", "KUGSM"},
	{"250 14", "MegaFon"},
	{"250 15", "SMARTS"},
	{"250 16", "Miatel"},
	{"250 17", "Utel"},
	{"250 18", "12.ru"},
	{"250 19", "Alfa-Mobile"},
	{"250 20", "t2"},
	{"250 21", "GlobalTel"},
	{"250 22", "Vainakh Telecom"},
	{"250 23", "Thuraya"},
	{"250 26", "VTB Mobile"},
	{"250 27", "Letai"},
	{"250 28", "Beeline"},
	{"250 29", "Iridium"},
	{"250 32", "Win Mobile"},
	{"250 33", "Sevmobile"},
	{"250 34", "Krymtelekom"},
	{"250 35", "MOTIV"},
	{"250 37", "MCN Mobile"},
	{"250 38", "Tambov GSM"},
	{"250 39", "Rostelecom"},
	{"250 40", "VTC Mobile"},
	{"250 44", "Stavtelesot / North Caucasian GSM"},
	{"250 45", "Gazprombank Mobile"},
	{"250 50", "SberMobile"},
	{"250 54", "Miranda-Media"},
	{"250 57", "Matrix Mobile"},
	{"250 59", "WireFire"},
	{"250 60", "Volna mobile"},
	{"250 61", "Intertelecom"},
	{"250 62", "T-Mobile"},
	{"250 811", "Votek Mobile"},
	{"250 91", "Sonic Duo"},
	{"250 92", "Primtelefon"},
	{"250 93", "Telecom XXI"},
	{"250 96", "+7Telecom"},
	{"250 97", "Phoenix"},
	{"250 98", "MKS (ex. Lugacom)"},
	{"250 99", "Beeline"},
	{"255 00", "IDC"},
	{"255 01", "Vodafone"},
	{"255 02", "Kyivstar"},
	{"255 03", "Kyivstar"},
	{"255 04", "Intertelecom"},
	{"255 05", "Kyivstar"},
	{"255 06", "lifecell"},
	{"255 07", "3Mob; Lycamobile"},
	{"255 08", "JSC Ukrtelecom"},
	{"255 09", "PRJSC \"Farlep-Invest\""},
	{"255 10", "Atlantis Telecom LLC"},
	{"255 11", "T.R. Communications LLC"},
	{"255 21", "PEOPLEnet"},
	{"255 23", "CDMA Ukraine"},
	{"255 25", "NEWTONE"},
	{"255 701", "Ukrainian Special Systems"},
	{"255 702", "Limited Liability Company \"J&W\""},
	{"255 707", "Kyivstar"},
	{"255 99", "Phoenix; MKS (ex. Lugacom)"},
	{"257 01", "A1"},
	{"257 02", "MTS"},
	{"257 03", "DIALLOG"},
	{"257 04", "life:)"},
	{"257 05", "byfly"},
	{"257 06", "beCloud"},
	{"259 01", "Orange"},
	{"259 02", "Moldcell"},
	{"259 03", "Moldtelecom"},
	{"259 04", "Eventis"},
	{"259 05", "Moldtelecom"},
	{"259 15", "IDC"},
	{"259 99", "Moldtelecom"},
	{"260 01", "Plus"},
	{"260 02", "T-Mobile"},
	{"260 03", "Orange"},
	{"260 04", "Plus"},
	{"260 05", "Orange"},
	{"260 06", "Play"},
	{"260 07", "Netia"},
	{"260 08", "EXATEL S.A."},
	{"260 09", "Lycamobile"},
	{"260 10", "T-Mobile"},
	{"260 11", "Plus"},
	{"260 12", "Cyfrowy Polsat"},
	{"260 13", "Move Telecom S.A."},
	{"260 14", "Telco Leaders Ltd"},
	{"260 15", "Plus"},
	{"260 16", "Plus"},
	{"260 17", "Plus"},
	{"260 18", "AMD Telecom"},
	{"260 19", "SIA NetBalt"},
	{"260 20", "TISMI B.V."},
	{"260 21", "private networks"},
	{"260 22", "Twilio Ireland Limited"},
	{"260 23", "PGE Systemy S.A."},
	{"260 24", "IT Partners Telco Sp. z o.o."},
	{"260 25", "thulium Sp. z o.o."},
	{"260 26", "T-Mobile"},
	{"260 27", "SIA Ntel Solutions"},
	{"260 28", "CrossMobile Sp. z o.o."},
	{"260 29", "SMSWIZARD POLSKA Sp. z o.o."},
	{"260 30", "T-Mobile"},
	{"260 31", "T-Mobile"},
	{"260 32", "Compatel Limited"},
	{"260 33", "1Global Operations"},
	{"260 34", "NetWorkS!"},
	{"260 35", "PKP Polskie Linie Kolejowe S.A."},
	{"260 36", "YATECO OU"},
	{"260 37", "Lancelot B.V."},
	{"260 38", "Premium Routing GmbH"},
	{"260 39", "Voxbone"},
	{"260 40", "Orange"},
	{"260 41", "EZ PHONE MOBILE Sp. z o.o."},
	{"260 42", "T-Mobile"},
	{"260 43", "Smart Idea International Sp. z o.o."},
	{"260 44", "Orange"},
	{"260 45", "Virgin Mobile"},
	{"260 46", "Orange"},
	{"260 47", "SMShighway Limited"},
	{"260 48", "AGILE TELECOM S.P.A."},
	{"260 49", "Bird B.V."},
	{"260 50", "eSIM Go Limited"},
	{"260 51", "B2B Network UAB"},
	{"260 72", "Polkomtel Sp. z o.o."},
	{"260 73", "Polkomtel Sp. z o.o."},
	{"260 76", "Polkomtel Sp. z o.o."},
	{"260 77", "P4 Sp. z o.o."},
	{"260 78", "P4 Sp. z o.o."},
	{"260 79", "P4 Sp. z o.o."},
	{"260 90", "Polska Spolka Gazownictwa Sp. z o.o."},
	{"260 97", "Politechnika Lodzka Uczelniane Centrum Informatyczne"},
	{"260 98", "Play"},
	{"262 01", "Telekom"},
	{"262 02", "Vodafone"},
	{"262 03", "O2"},
	{"262 04", "Vodafone"},
	{"262 05", "O2"},
	{"262 06", "Telekom"},
	{"262 07", "O2"},
	{"262 08", "O2"},
	{"262 09", "Vodafone"},
	{"262 10", "DB Netz AG"},
	{"262 11", "O2"},
	{"262 12", "Simquadrat"},
	{"262 13", "BAAINBw"},
	{"262 14", "Lebara Limited"},
	{"262 15", "Airdata"},
	{"262 16", "Telogic Germany GmbH"},
	{"262 17", "O2"},
	{"262 18", "NetCologne"},
	{"262 19", "450connect"},
	{"262 20", "Enreach"},
	{"262 21", "spusu"},
	{"262 22", "sipgate Wireless GmbH"},
	{"262 23", "1&1"},
	{"262 24", "TelcoVillage GmbH"},
	{"262 25", "MTEL"},
	{"262 26", "Simsalasim Germany GmbH"},
	{"262 33", "simquadrat"},
	{"262 41", "First Telecom GmbH"},
	{"262 42", "CCC Event"},
	{"262 43", "Lycamobile"},
	{"262 60", "DB Telematik"},
	{"262 70", "BDBOS"},
	{"262 71", "GSMK"},
	{"262 72", "Ericsson GmbH"},
	{"262 73", "Nokia"},
	{"262 74", "Ericsson GmbH"},
	{"262 75", "Core Network Dynamics GmbH"},
	{"262 76", "BDBOS"},
	{"262 77", "O2"},
	{"262 78", "Telekom"},
	{"262 79", "ng4T GmbH"},
	{"262 868", "BDBOS"},
	{"262 869", "TKUV-Netzanbindungen"},
	{"262 92", "Nash Technologies"},
	{"262 98", "private networks"},
	{"266 01", "GibTel"},
	{"266 03", "Gibfibrespeed"},
	{"266 04", "MCOM"},
	{"266 06", "CTS Mobile"},
	{"266 09", "Shine"},
	{"268 01", "Vodafone"},
	{"268 02", "DIGI PT"},
	{"268 03", "NOS"},
	{"268 04", "LycaMobile"},
	{"268 05", "Oniway - Inforcomunicacoes, S.A."},
	{"268 06", "MEO"},
	{"268 07", "Holafly Portugal, S.A."},
	{"268 08", "MEO"},
	{"268 11", "Compatel, Limited"},
	{"268 12", "Infraestruturas de Portugal, S.A."},
	{"268 13", "G9Telecom, S.A."},
	{"268 21", "Zapp"},
	{"268 80", "E-Redes - Distribuicao de Eletricidade, S.A."},
	{"268 91", "Vodafone"},
	{"268 92", "Vodafone"},
	{"268 93", "NOS"},
	{"270 01", "POST"},
	{"270 02", "MTX Connect S.a r.l."},
	{"270 05", "Luxembourg Online S.A."},
	{"270 07", "Bouygues"},
	{"270 07", "Bouygues Telecom S.A."},
	{"270 10", "Blue Communications"},
	{"270 71", "CFL"},
	{"270 77", "Proximus Luxembourg S.A."},
	{"270 77", "Tango"},
	{"270 78", "Interactive digital media GmbH"},
	{"270 79", "Mitto AG"},
	{"270 80", "Syniverse Technologies S.a r.l."},
	{"270 81", "E-Lux Mobile Telecommunication S.A."},
	{"270 99", "Orange"},
	{"270 99", "Orange Communications Luxembourg S.A."},
	{"272 01", "Vodafone"},
	{"272 02", "3"},
	{"272 03", "Eir"},
	{"272 04", "Access Telecom"},
	{"272 05", "3"},
	{"272 07", "Eir"},
	{"272 08", "Eir"},
	{"272 09", "Clever Communications Ltd."},
	{"272 11", "Tesco Mobile"},
	{"272 13", "Lycamobile"},
	{"272 15", "Virgin Mobile"},
	{"272 16", "iD Mobile"},
	{"272 17", "3"},
	{"272 18", "Cubic Telecom Limited"},
	{"272 21", "Net Feasa Limited"},
	{"272 25", "Sky Mobile"},
	{"272 26", "Vodafone"},
	{"272 27", "TP Ireland Operations Limited"},
	{"272 42", "Imagine"},
	{"272 68", "Office of the Government Chief Information Officer"},
	{"274 01", "Siminn"},
	{"274 02", "Syn"},
	{"274 03", "Syn"},
	{"274 04", "Viking"},
	{"274 05", "Hallo Frjals fjarskipti hf."},
	{"274 06", "Null niu ehf"},
	{"274 07", "IceCell"},
	{"274 08", "On-waves"},
	{"274 11", "Nova"},
	{"274 12", "Tal"},
	{"274 16", "Tismi BV"},
	{"274 22", "Landhelgisgaeslan (Icelandic Coast Guard)"},
	{"274 31", "Siminn"},
	{"274 91", "Neydarlinan"},
	{"276 01", "ONE"},
	{"276 02", "Vodafone"},
	{"276 03", "ALBtelecom"},
	{"276 04", "Plus Communication"},
	{"278 01", "Epic"},
	{"278 11", "YOM Ltd."},
	{"278 21", "GO"},
	{"278 30", "GO"},
	{"278 77", "Melita"},
	{"280 01", "Cytamobile-Vodafone"},
	{"280 02", "Cytamobile-Vodafone"},
	{"280 10", "Epic"},
	{"280 20", "PrimeTel"},
	{"280 22", "lemontel"},
	{"280 23", "Vectone Mobile"},
	{"282 01", "Geocell"},
	{"282 02", "Magti"},
	{"282 03", "MagtiFix"},
	{"282 04", "Cellfie"},
	{"282 05", "S1"},
	{"282 06", "JSC Compatel"},
	{"282 07", "GlobalCell"},
	{"282 08", "Silk LTE"},
	{"282 09", "Gmobile"},
	{"282 10", "Premium Net International SRL"},
	{"282 11", "Mobilive"},
	{"282 12", "Telecom1 Ltd"},
	{"282 13", "Asanet Ltd"},
	{"282 14", "DataCell"},
	{"282 15", "Servicebox Ltd"},
	{"282 16", "Unicell Mobile Ltd"},
	{"282 17", "TMTECH Ltd"},
	{"282 18", "Lagi Ltd."},
	{"282 22", "Myphone"},
	{"282 66", "Icecell Telecom LLC"},
	{"283 01", "Team"},
	{"283 04", "Karabakh Telecom"},
	{"283 05", "Viva Armenia"},
	{"283 10", "Ucom"},
	{"284 01", "A1 BG"},
	{"284 03", "Vivacom"},
	{"284 05", "Yettel"},
	{"284 07", "NKZhI"},
	{"284 09", "COMPATEL LIMITED"},
	{"284 11", "Bulsatcom"},
	{"284 13", "Ti.kom"},
	{"286 01", "Turkcell"},
	{"286 02", "Vodafone"},
	{"286 03", "Turk Telekom"},
	{"286 04", "Aycell"},
	{"288 01", "Foroya Tele"},
	{"288 02", "Nema"},
	{"288 03", "TOSA"},
	{"288 10", "Foroya Tele"},
	{"289 67", "Aquafon"},
	{"289 88", "A-Mobile"},
	{"290 01", "tusass"},
	{"290 02", "Nanoq Media"},
	{"290 03", "Tuullik mobile data"},
	{"292 01", "PRIMA"},
	{"293 10", "SZ - Infrastruktura, d.o.o."},
	{"293 11", "BeeIN d.o.o."},
	{"293 20", "COMPATEL Ltd"},
	{"293 21", "NOVATEL d.o.o."},
	{"293 22", "Mobile One Ltd."},
	{"293 40", "A1 SI"},
	{"293 41", "Mobitel"},
	{"293 64", "T-2"},
	{"293 70", "Telemach"},
	{"293 86", "ELEKTRO GORENJSKA, d.d"},
	{"294 01", "Telekom.mk"},
	{"294 02", "one"},
	{"294 03", "A1 MK"},
	{"294 04", "Lycamobile"},
	{"294 10", "WTI Macedonia"},
	{"294 11", "MOBIK TELEKOMUNIKACII DOOEL Skopje"},
	{"294 12", "MTEL DOOEL Skopje"},
	{"295 01", "Swisscom"},
	{"295 02", "7acht"},
	{"295 05", "FL1"},
	{"295 06", "Cubic Telecom"},
	{"295 07", "First Mobile AG"},
	{"295 09", "EMnify GmbH"},
	{"295 10", "Soracom LI Ltd."},
	{"295 11", "iBASIS Communications AG"},
	{"295 77", "Alpmobil"},
	{"297 01", "One"},
	{"297 02", "telekom.me"},
	{"297 03", "m:tel"},
	{"302 060", "Karrier One Inc."},
	{"302 100", "dotmobile"},
	{"302 130", "Xplore"},
	{"302 131", "Xplore"},
	{"302 140", "Fibernetics"},
	{"302 150", "Cogeco Connexion Inc."},
	{"302 151", "Cogeco Connexion Inc."},
	{"302 152", "Cogeco Connexion Inc."},
	{"302 160", "Sugar Mobile Inc."},
	{"302 220", "Telus Mobility, Koodo Mobile, Public Mobile"},
	{"302 221", "Telus"},
	{"302 222", "Telus"},
	{"302 230", "ISP Telecom"},
	{"302 250", "Bell Mobility"},
	{"302 270", "EastLink"},
	{"302 290", "Airtel Wireless"},
	{"302 300", "ECOTEL"},
	{"302 301", "ECOTEL"},
	{"302 310", "ECOTEL"},
	{"302 320", "Rogers Wireless"},
	{"302 330", "OpenMobile Inc."},
	{"302 340", "Execulink"},
	{"302 350", "Naskapi Imuun Inc."},
	{"302 351", "MPVWifi Inc."},
	{"302 352", "Lyttonnet"},
	{"302 353", "SpeedFI Inc."},
	{"302 354", "Every-Day Computers Inc."},
	{"302 360", "MiKe"},
	{"302 361", "Telus"},
	{"302 370", "Fido"},
	{"302 380", "Keewaytinook Mobile"},
	{"302 390", "DMTS"},
	{"302 420", "Telus"},
	{"302 480", "Qiniq"},
	{"302 490", "Freedom Mobile"},
	{"302 491", "Freedom Mobile"},
	{"302 500", "Videotron"},
	{"302 510", "Videotron"},
	{"302 520", "Rogers (Videotron MOCN)"},
	{"302 530", "Keewaytinook Mobile"},
	{"302 540", "Rovvr Communications Inc."},
	{"302 550", "Star Solutions International Inc."},
	{"302 560", "Lynx Mobility"},
	{"302 570", "Ligado Networks Corp."},
	{"302 590", "Quadro Mobility"},
	{"302 600", "Iristel"},
	{"302 610", "Bell Mobility"},
	{"302 620", "ICE Wireless"},
	{"302 630", "Aliant Mobility"},
	{"302 640", "Bell"},
	{"302 650", "TBaytel"},
	{"302 652", "BC Tel Mobility (Telus)"},
	{"302 653", "Telus"},
	{"302 655", "MTS"},
	{"302 656", "TBay"},
	{"302 657", "Telus"},
	{"302 660", "MTS"},
	{"302 670", "CityTel Mobility"},
	{"302 680", "SaskTel"},
	{"302 681", "SaskTel"},
	{"302 690", "Bell"},
	{"302 701", "MB Tel Mobility"},
	{"302 702", "MT&T Mobility (Aliant)"},
	{"302 703", "New Tel Mobility (Aliant)"},
	{"302 710", "Globalstar"},
	{"302 720", "Rogers Wireless"},
	{"302 721", "Rogers Wireless"},
	{"302 722", "Rogers Wireless"},
	{"302 723", "Rogers Wireless"},
	{"302 724", "Rogers Wireless"},
	{"302 725", "Rogers Wireless"},
	{"302 730", "TerreStar Solutions"},
	{"302 731", "TerreStar Solutions"},
	{"302 740", "Rogers Wireless"},
	{"302 741", "Rogers Wireless"},
	{"302 750", "SaskTel"},
	{"302 760", "Public Mobile"},
	{"302 770", "TNW Wireless"},
	{"302 780", "SaskTel"},
	{"302 781", "SaskTel"},
	{"302 790", "NetSet Communications"},
	{"302 820", "Rogers Wireless"},
	{"302 821", "Rogers Wireless"},
	{"302 848", "Vocom International Telecommunications, Inc"},
	{"302 860", "Telus"},
	{"302 880", "Bell / Telus / SaskTel"},
	{"302 910", "Halton Regional Police Service"},
	{"302 911", "Halton Regional Police Service"},
	{"302 920", "Rogers Wireless"},
	{"302 940", "Wightman Mobility"},
	{"302 970", "Canadian Pacific Kansas City Railway"},
	{"302 971", "Canadian National Railway"},
	{"302 972", "Hydro-Quebec"},
	{"302 975", "BC Hydro"},
	{"302 990", "Ericsson Canada"},
	{"302 991", "Halton Regional Police Service"},
	{"302 992", "AltaLink Management Ltd"},
	{"302 996", "BC Hydro"},
	{"302 997", "Powertech Labs"},
	{"302 998", "Institut de Recherche d'Hydro-Quebec"},
	{"308 01", "SPM Telecom"},
	{"308 02", "GLOBALTEL"},
	{"308 03", "SPM Telecom"},
	{"308 04", "GLOBALTEL"},
	{"310 004", "Verizon"},
	{"310 005", "Verizon"},
	{"310 006", "Verizon"},
	{"310 010", "Verizon"},
	{"310 012", "Verizon"},
	{"310 013", "Verizon"},
	{"310 014", ""},
	{"310 015", "Southern LINC"},
	{"310 016", "AT&T"},
	{"310 017", "ProxTel"},
	{"310 017", "ProxTel"},
	{"310 020", "Union Wireless"},
	{"310 030", "mobi"},
	{"310 032", "IT&E Wireless"},
	{"310 032", "IT&E Wireless"},
	{"310 033", "Guam Telephone Authority"},
	{"310 033", "Guam Telephone Authority"},
	{"310 034", "Airpeak"},
	{"310 035", "ETEX Wireless"},
	{"310 040", "Mobi"},
	{"310 050", "GCI"},
	{"310 053", "Virgin Mobile"},
	{"310 054", "Alltel US"},
	{"310 060", "Karrier One"},
	{"310 066", "UScellular"},
	{"310 070", "AT&T"},
	{"310 080", "AT&T"},
	{"310 090", "AT&T"},
	{"310 100", "Plateau Wireless"},
	{"310 110", "IT&E Wireless"},
	{"310 110", "IT&E Wireless"},
	{"310 120", "T-Mobile"},
	{"310 120", "T-Mobile"},
	{"310 130", "Carolina West Wireless"},
	{"310 140", "GTA Wireless"},
	{"310 140", "GTA Wireless"},
	{"310 150", "AT&T"},
	{"310 160", "T-Mobile"},
	{"310 170", "AT&T"},
	{"310 180", "West Central"},
	{"310 190", "GCI"},
	{"310 200", "T-Mobile"},
	{"310 210", "T-Mobile"},
	{"310 220", "T-Mobile"},
	{"310 230", "T-Mobile"},
	{"310 240", "T-Mobile"},
	{"310 250", "T-Mobile"},
	{"310 260", "T-Mobile"},
	{"310 260", "T-Mobile"},
	{"310 260", "T-Mobile"},
	{"310 270", "T-Mobile"},
	{"310 280", "AT&T"},
	{"310 280", "AT&T"},
	{"310 290", "nep"},
	{"310 300", "Big Sky Mobile"},
	{"310 310", "T-Mobile"},
	{"310 311", "Farmers Wireless"},
	{"310 320", "Cellular One"},
	{"310 330", "Wireless Partners, LLC"},
	{"310 340", "Limitless Mobile"},
	{"310 350", "Verizon"},
	{"310 360", "Pioneer Cellular"},
	{"310 370", "Docomo"},
	{"310 370", "Docomo"},
	{"310 370", "Docomo"},
	{"310 380", "AT&T"},
	{"310 390", "Cellular One of East Texas"},
	{"310 400", "IT&E Wireless"},
	{"310 400", "IT&E Wireless"},
	{"310 410", "AT&T"},
	{"310 420", "World Mobile"},
	{"310 430", "GCI"},
	{"310 440", "Numerex"},
	{"310 450", "Viaero"},
	{"310 460", "Eseye LLC"},
	{"310 470", "Docomo"},
	{"310 470", "NTT DoCoMo Pacific"},
	{"310 480", "IT&E Wireless"},
	{"310 480", "IT&E Wireless"},
	{"310 490", "T-Mobile"},
	{"310 500", "Alltel"},
	{"310 510", "Cellcom"},
	{"310 520", "TNS"},
	{"310 530", "T-Mobile"},
	{"310 540", "Phoenix"},
	{"310 550", "Syniverse Technologies"},
	{"310 560", "AT&T"},
	{"310 570", "Broadpoint, LLC"},
	{"310 580", "Inland Cellular Telephone Company"},
	{"310 59", "Cellular One"},
	{"310 590", "Verizon Wireless"},
	{"310 591", "Verizon Wireless"},
	{"310 592", "Verizon Wireless"},
	{"310 593", "Verizon Wireless"},
	{"310 594", "Verizon Wireless"},
	{"310 595", "Verizon Wireless"},
	{"310 596", "Verizon Wireless"},
	{"310 597", "Verizon Wireless"},
	{"310 598", "Verizon Wireless"},
	{"310 599", "Verizon Wireless"},
	{"310 600", "Cellcom"},
	{"310 610", "Mavenir Systems Inc"},
	{"310 620", "Cellcom"},
	{"310 630", "Choice Wireless"},
	{"310 640", "Numerex"},
	{"310 650", "Jasper"},
	{"310 660", "T-Mobile"},
	{"310 670", "AT&T"},
	{"310 680", "AT&T"},
	{"310 690", "Limitless Mobile"},
	{"310 700", "Bigfoot Cellular"},
	{"310 710", "ASTAC"},
	{"310 720", "Syniverse Technologies"},
	{"310 730", "UScellular"},
	{"310 740", "Viaero"},
	{"310 750", "Appalachian Wireless"},
	{"310 760", "Lynch 3G Communications Corporation"},
	{"310 770", "T-Mobile"},
	{"310 780", "Dispatch Direct"},
	{"310 790", "BLAZE"},
	{"310 800", "T-Mobile"},
	{"310 810", "Pacific Lightwave Inc."},
	{"310 820", "Verizon Wireless"},
	{"310 830", "T-Mobile"},
	{"310 840", "telna Mobile"},
	{"310 850", "Aeris"},
	{"310 860", "Five Star Wireless"},
	{"310 870", "PACE"},
	{"310 880", "DTC Wireless"},
	{"310 890", "Verizon Wireless"},
	{"310 891", "Verizon Wireless"},
	{"310 892", "Verizon Wireless"},
	{"310 893", "Verizon Wireless"},
	{"310 894", "Verizon Wireless"},
	{"310 895", "Verizon Wireless"},
	{"310 896", "Verizon Wireless"},
	{"310 897", "Verizon Wireless"},
	{"310 898", "Verizon Wireless"},
	{"310 899", "Verizon Wireless"},
	{"310 900", "Mid-Rivers Wireless"},
	{"310 910", "Verizon Wireless"},
	{"310 920", "James Valley Wireless, LLC"},
	{"310 930", "Copper Valley Wireless"},
	{"310 940", "Tyntec Inc."},
	{"310 950", "AT&T"},
	{"310 960", "STRATA"},
	{"310 970", "Globalstar"},
	{"310 980", "Peoples Telephone"},
	{"310 990", "Evolve Broadband"},
	{"311 010", "Chariton Valley"},
	{"311 012", "Verizon"},
	{"311 020", "Chariton Valley"},
	{"311 030", "Indigo Wireless"},
	{"311 040", "Choice Wireless"},
	{"311 050", "Thumb Cellular LP"},
	{"311 060", "Space Data Corporation"},
	{"311 070", "AT&T"},
	{"311 080", "Pine Cellular"},
	{"311 090", "AT&T"},
	{"311 100", "Nex-Tech Wireless"},
	{"311 110", "Verizon"},
	{"311 120", "IT&E Wireless"},
	{"311 120", "IT&E Wireless"},
	{"311 130", "Black & Veatch"},
	{"311 140", "Bravado Wireless"},
	{"311 150", "Wilkes Cellular"},
	{"311 160", "Lightsquared L.P."},
	{"311 170", "Tampnet"},
	{"311 180", "AT&T"},
	{"311 190", "AT&T"},
	{"311 200", "Dish Wireless"},
	{"311 210", "Telnyx LLC"},
	{"311 220", "UScellular"},
	{"311 225", "UScellular"},
	{"311 228", "UScellular"},
	{"311 229", "UScellular"},
	{"311 230", "C Spire"},
	{"311 240", "Cordova Wireless"},
	{"311 250", "IT&E Wireless"},
	{"311 250", "IT&E Wireless"},
	{"311 260", "T-Mobile"},
	{"311 270", "Verizon"},
	{"311 271", "Verizon"},
	{"311 272", "Verizon"},
	{"311 273", "Verizon"},
	{"311 274", "Verizon"},
	{"311 275", "Verizon"},
	{"311 276", "Verizon"},
	{"311 277", "Verizon"},
	{"311 278", "Verizon"},
	{"311 279", "Verizon"},
	{"311 280", "Verizon"},
	{"311 281", "Verizon"},
	{"311 282", "Verizon"},
	{"311 283", "Verizon"},
	{"311 284", "Verizon"},
	{"311 285", "Verizon"},
	{"311 286", "Verizon"},
	{"311 287", "Verizon"},
	{"311 288", "Verizon"},
	{"311 289", "Verizon"},
	{"311 290", "BLAZE"},
	{"311 300", "Nexus Communications, Inc."},
	{"311 310", "NMobile"},
	{"311 320", "Choice Wireless"},
	{"311 330", "Bug Tussel Wireless"},
	{"311 340", "Illinois Valley Cellular"},
	{"311 350", "Nemont"},
	{"311 360", "Stelera Wireless"},
	{"311 370", "GCI Wireless"},
	{"311 380", "New Dimension Wireless Ltd."},
	{"311 390", "Verizon"},
	{"311 400", ""},
	{"311 410", "Chat Mobility"},
	{"311 420", "NorthwestCell"},
	{"311 430", "Chat Mobility"},
	{"311 440", "Verizon Wireless"},
	{"311 450", "PTCI"},
	{"311 460", "Electric Imp Inc."},
	{"311 470", "Viya"},
	{"311 470", "Viya"},
	{"311 480", "Verizon"},
	{"311 481", "Verizon"},
	{"311 482", "Verizon"},
	{"311 483", "Verizon"},
	{"311 484", "Verizon"},
	{"311 485", "Verizon"},
	{"311 486", "Verizon"},
	{"311 487", "Verizon"},
	{"311 488", "Verizon"},
	{"311 489", "Verizon"},
	{"311 490", "T-Mobile"},
	{"311 500", "mobi"},
	{"311 510", "Ligado Networks"},
	{"311 520", "Lightsquared L.P."},
	{"311 530", "WorldCell Solutions LLC"},
	{"311 540", "Coeur Rochester, Inc"},
	{"311 550", "Choice Wireless"},
	{"311 560", "OTZ Cellular"},
	{"311 570", "Mediacom"},
	{"311 580", "UScellular"},
	{"311 588", "UScellular"},
	{"311 589", "UScellular"},
	{"311 590", "Verizon"},
	{"311 600", "Limitless Mobile"},
	{"311 610", "SRT Communications"},
	{"311 620", "TerreStar Networks, Inc."},
	{"311 630", "C Spire"},
	{"311 640", "Rock Wireless"},
	{"311 650", "United Wireless"},
	{"311 660", "Metro"},
	{"311 670", "Pine Belt Wireless"},
	{"311 680", "GreenFly LLC"},
	{"311 690", "TeleBEEPER of New Mexico"},
	{"311 700", "Midwest Network Solutions Hub LLC"},
	{"311 710", "Northeast Wireless Networks LLC"},
	{"311 720", "MainePCS LLC"},
	{"311 730", "Proximiti Mobility Inc."},
	{"311 740", "Telalaska Cellular"},
	{"311 750", "ClearTalk"},
	{"311 760", "Edigen Inc."},
	{"311 770", "Altiostar Networks, Inc."},
	{"311 780", "ASTCA"},
	{"311 790", "Coleman County Telephone Cooperative, Inc."},
	{"311 800", "Verizon Wireless"},
	{"311 810", "Verizon Wireless"},
	{"311 820", "Ribbon Communications"},
	{"311 830", "Thumb Cellular LP"},
	{"311 840", "Cellcom"},
	{"311 850", "Cellcom"},
	{"311 860", "STRATA"},
	{"311 870", "T-Mobile"},
	{"311 880", "T-Mobile"},
	{"311 882", "T-Mobile"},
	{"311 890", "{{usurped|1=Globecomm Network Services Corporation }}"},
	{"311 900", "GigSky"},
	{"311 910", "MobileNation"},
	{"311 920", "Chariton Valley"},
	{"311 930", "Cox Communications"},
	{"311 940", "T-Mobile"},
	{"311 950", "ETC"},
	{"311 960", "Lycamobile"},
	{"311 970", "Big River Broadband"},
	{"311 980", "LigTel Communications"},
	{"311 990", "VTel Wireless"},
	{"312 020", "Infrastructure Networks, LLC"},
	{"312 030", "Bravado Wireless"},
	{"312 040", "Custer Telephone Co-op (CTCI)"},
	{"312 050", "Fuego Wireless"},
	{"312 060", "CoverageCo"},
	{"312 070", "Adams Networks Inc"},
	{"312 080", "SyncSouth"},
	{"312 090", "AT&T"},
	{"312 100", "ClearSky Technologies, Inc."},
	{"312 110", "Texas Energy Network LLC"},
	{"312 120", "Appalachian Wireless"},
	{"312 130", "Appalachian Wireless"},
	{"312 140", "Revol Wireless"},
	{"312 150", "NorthwestCell"},
	{"312 160", "Chat Mobility"},
	{"312 170", "Chat Mobility"},
	{"312 180", "Limitless Mobile LLC"},
	{"312 190", "T-Mobile"},
	{"312 200", "Voyager Mobility LLC"},
	{"312 210", "Aspenta International, Inc."},
	{"312 220", "Chariton Valley"},
	{"312 230", "SRT Communications"},
	{"312 240", "Sprint"},
	{"312 250", "T-Mobile"},
	{"312 260", "WorldCell Solutions LLC"},
	{"312 270", "Pioneer Cellular"},
	{"312 280", "Pioneer Cellular"},
	{"312 290", "STRATA"},
	{"312 300", "telna Mobile"},
	{"312 310", "Clear Stream Communications, LLC"},
	{"312 320", "RTC Communications LLC"},
	{"312 330", "Nemont"},
	{"312 340", "MTA"},
	{"312 350", "Triangle Communication System Inc."},
	{"312 360", "Wes-Tex Telecommunications, Ltd."},
	{"312 370", "Choice Wireless"},
	{"312 380", "Copper Valley Wireless"},
	{"312 390", "FTC Wireless"},
	{"312 400", "Mid-Rivers Wireless"},
	{"312 410", "Eltopia Communications, LLC"},
	{"312 420", "Nex-Tech Wireless"},
	{"312 430", "Silver Star Communications"},
	{"312 440", "Kajeet, Inc."},
	{"312 450", "Cable & Communications Corporation"},
	{"312 460", "Ketchikan Public Utilities (KPU)"},
	{"312 470", "Carolina West Wireless"},
	{"312 480", "Nemont"},
	{"312 490", "TrustComm, Inc."},
	{"312 500", "AB Spectrum LLC"},
	{"312 510", "WUE Inc."},
	{"312 520", "ANIN"},
	{"312 530", "T-Mobile"},
	{"312 540", "Broadband In Hand LLC"},
	{"312 550", "Great Plains Communications, Inc."},
	{"312 560", "NHLT Inc."},
	{"312 570", "Impact"},
	{"312 580", "Google LLC"},
	{"312 590", "NMU"},
	{"312 600", "Nemont"},
	{"312 610", "ShawnTech Communications"},
	{"312 620", "Airlinq Inc."},
	{"312 630", "NetGenuity, Inc."},
	{"312 640", "Nemont"},
	{"312 650", "Brightlink"},
	{"312 660", "nTelos"},
	{"312 670", "FirstNet"},
	{"312 680", "AT&T"},
	{"312 690", "Tecore Global Services, LLC"},
	{"312 700", "Wireless Partners, LLC"},
	{"312 710", "Great North Woods Wireless LLC"},
	{"312 720", "Southern LINC"},
	{"312 730", "Triangle Communication System Inc."},
	{"312 740", "Locus Telecommunications"},
	{"312 750", "Artemis Networks LLC"},
	{"312 760", "ASTAC"},
	{"312 770", "Verizon"},
	{"312 780", "Redzone Wireless"},
	{"312 790", "Gila Electronics"},
	{"312 800", "Cirrus Core Networks"},
	{"312 810", "BBCP"},
	{"312 820", "Santel Communications Cooperative, Inc."},
	{"312 830", "Kings County Office of Education"},
	{"312 840", "South Georgia Regional Information Technology Authority"},
	{"312 850", "Onvoy Spectrum, LLC"},
	{"312 860", "ClearTalk"},
	{"312 870", "GigSky Mobile, LLC"},
	{"312 880", "Albemarle County Public Schools"},
	{"312 890", "Circle Gx"},
	{"312 900", "ClearTalk"},
	{"312 910", "Appalachian Wireless"},
	{"312 920", "Northeast Wireless Networks LLC"},
	{"312 930", "HNI"},
	{"312 940", "Webformix"},
	{"312 950", "Custer Telephone Co-op (CTCI)"},
	{"312 960", "M&A Technology, Inc."},
	{"312 970", "IOSAZ Intellectual Property LLC"},
	{"312 980", "Mark Twain Communications Company"},
	{"312 990", "Premier Broadband"},
	{"313 010", "Bravado Wireless"},
	{"313 020", "CTC Wireless"},
	{"313 030", "AT&T Mobility"},
	{"313 040", "NNTC Wireless"},
	{"313 050", "Breakaway Wireless"},
	{"313 060", "Country Wireless"},
	{"313 061", "Country Wireless"},
	{"313 070", "Midwest Network Solutions Hub LLC"},
	{"313 080", "Speedwavz LLP"},
	{"313 090", "Vivint Wireless, Inc."},
	{"313 100", "FirstNet"},
	{"313 110", "FirstNet"},
	{"313 120", "FirstNet"},
	{"313 130", "FirstNet"},
	{"313 140", "FirstNet"},
	{"313 150", "FirstNet"},
	{"313 160", "FirstNet"},
	{"313 170", "FirstNet"},
	{"313 180", "FirstNet"},
	{"313 190", "FirstNet"},
	{"313 200", "Mercury Network Corporation"},
	{"313 210", "AT&T"},
	{"313 220", "Custer Telephone Co-op (CTCI)"},
	{"313 230", "Velocity Communications Inc."},
	{"313 240", "Peak Internet"},
	{"313 250", "Imperial County Office of Education"},
	{"313 260", "Expeto Wireless Inc."},
	{"313 270", "Blackstar Management"},
	{"313 280", "King Street Wireless, LP"},
	{"313 290", "Gulf Coast Broadband LLC"},
	{"313 300", "Southern California Edison"},
	{"313 310", "CAL.NET, Inc."},
	{"313 320", "Paladin Wireless"},
	{"313 330", "CenturyTel Broadband Services LLC"},
	{"313 340", "Dish"},
	{"313 350", "Dish"},
	{"313 360", "Dish"},
	{"313 370", "Red Truck Wireless, LLC"},
	{"313 380", "OptimERA Inc."},
	{"313 390", "Altice USA Wireless, Inc."},
	{"313 400", "Texoma Communications, LLC"},
	{"313 410", "Anterix"},
	{"313 420", "Hudson Valley Wireless"},
	{"313 440", "Arvig Enterprises, Inc."},
	{"313 450", "Spectrum Wireless Holdings, LLC"},
	{"313 460", "mobi"},
	{"313 470", "San Diego Gas & Electric Company"},
	{"313 480", "Ready Wireless, LLC"},
	{"313 490", "Puloli, Inc."},
	{"313 500", "Shelcomm, Inc."},
	{"313 510", "Claro"},
	{"313 510", "Puerto Rico Telecom Company"},
	{"313 520", "Florida Broadband, Inc."},
	{"313 540", "Nokia Innovations US LLC"},
	{"313 550", "Mile High Networks LLC"},
	{"313 560", "Boldyn Networks US"},
	{"313 570", "Pioneer Cellular"},
	{"313 580", "Telecall Telecommunications Corp."},
	{"313 590", "Southern LINC"},
	{"313 600", "ST Engineering {{Proper name|iDirect}}"},
	{"313 610", "Point Broadband Fiber Holding, LLC"},
	{"313 620", "OmniProphis Corporation"},
	{"313 630", "LICT  Corporation"},
	{"313 640", "Geoverse LLC"},
	{"313 650", "Chevron USA, Inc."},
	{"313 660", "Hudson Valley Wireless"},
	{"313 670", "Hudson Valley Wireless"},
	{"313 680", "Hudson Valley Wireless"},
	{"313 690", "Shenandoah Cable Television, LLC"},
	{"313 700", "Ameren Services Company"},
	{"313 710", "Extent Systems"},
	{"313 720", "1st Point Communications, LLC"},
	{"313 730", "TruAccess Networks"},
	{"313 740", "RTO Wireless, LLC"},
	{"313 750", "ZipLink"},
	{"313 760", "Hologram, Inc."},
	{"313 770", "Tango Extend"},
	{"313 780", "Windstream Holdings"},
	{"313 790", "Liberty"},
	{"313 790", "Liberty"},
	{"313 790", "Liberty"},
	{"313 800", "Wireless Technologies of Nebraska"},
	{"313 810", "Watch Communications"},
	{"313 820", "Inland Cellular Telephone Company"},
	{"313 830", "360 Communications"},
	{"313 840", "CellBlox Acquisitions"},
	{"313 850", "Softcom Internet Communications, Inc"},
	{"313 860", "Nextlink"},
	{"313 870", "ElektraFi LLC"},
	{"313 880", "Shuttle Wireless"},
	{"313 890", "TCOE"},
	{"313 900", "Tribal Networks"},
	{"313 910", "San Diego Gas & Electric"},
	{"313 920", "JCI"},
	{"313 930", "Rock Wireless"},
	{"313 940", "Motorola Solutions"},
	{"313 950", "Cheyenne and Arapaho Development Group"},
	{"313 960", "Townes 5G, LLC"},
	{"313 970", "Tychron"},
	{"313 980", "Next Generation Application LLC"},
	{"313 990", "Ericsson US"},
	{"314 020", "Spectrum Wireless Holdings, LLC"},
	{"314 030", "Baicells Technologies North America Inc."},
	{"314 060", "Texas A&M University"},
	{"314 070", "Texas A&M University"},
	{"314 080", "Texas A&M University"},
	{"314 090", "Southern LINC"},
	{"314 200", "XF Wireless Investments, LLC"},
	{"314 210", "Telecom Resource Center"},
	{"314 220", "Securus Technologies"},
	{"314 230", "Trace-Tek LLC"},
	{"314 240", "XF Wireless Investments, LLC"},
	{"314 260", "AT&T Mobility"},
	{"314 270", "AT&T Mobility"},
	{"314 280", "Pollen Mobile LLC"},
	{"314 290", "Wave"},
	{"314 300", "Southern California Edison"},
	{"314 310", "Terranet"},
	{"314 320", "Agri-Valley Communications, Inc"},
	{"314 330", "Nova Labs Inc"},
	{"314 340", "e/marconi"},
	{"314 350", "Evergy"},
	{"314 360", "Oceus Networks, LLC"},
	{"314 370", "ITEC"},
	{"314 380", "CCR"},
	{"314 390", "AT&T Mobility"},
	{"314 400", "C Spire"},
	{"314 410", "Peeringhub Inc"},
	{"314 420", "Cox Communications"},
	{"314 430", "Highway9 Networks, Inc"},
	{"314 440", "Tecore Global Services, LLC"},
	{"314 450", "NUWAVE Communications, Inc."},
	{"314 460", "Texas A&M University"},
	{"314 470", "MetTel"},
	{"314 480", "Xcel Energy Services Inc."},
	{"314 490", "UETN"},
	{"314 500", "Aetheros Inc."},
	{"314 510", "SI Wireless LLC"},
	{"314 520", "OG+E"},
	{"314 530", "Agile Networks"},
	{"314 540", "RGTN"},
	{"314 550", "REALLY"},
	{"314 560", "Cape"},
	{"314 570", "Newmont Corporation"},
	{"314 580", "Lower Colorado River Authority"},
	{"314 590", "Lynk Global, Inc."},
	{"314 600", "XNET Inc."},
	{"314 610", "IMSI.AI"},
	{"314 620", "Memphis Light, Gas and Water"},
	{"314 630", "Cape"},
	{"314 640", "Cape"},
	{"314 650", "Cape"},
	{"314 660", "Cape"},
	{"314 670", "Wi-DAS LLC"},
	{"314 680", "Xfinity"},
	{"314 690", "Agri-Valley Communications, Inc."},
	{"314 700", "Tampa Electric Company"},
	{"314 710", "Tribal Ready, PBC"},
	{"314 720", "OXIO, Inc."},
	{"314 730", "TextNow, Inc."},
	{"314 740", "Ringer Mobile, LLC"},
	{"314 750", "SDF, Inc."},
	{"314 760", "BATS Wireless"},
	{"314 770", "Westbold LLC"},
	{"314 780", "Saint Regis Mohawk Tribe"},
	{"314 790", "Neuner Mobile Technologies LLC"},
	{"314 800", "Boost Network"},
	{"314 810", "ORCID"},
	{"314 820", "Sequoia Wireless LLC"},
	{"314 830", "Talkie Communications"},
	{"314 840", "MLGW"},
	{"314 850", "SpaceX"},
	{"314 860", "Exelon"},
	{"314 870", "Exelon"},
	{"314 880", "Oncor License Holdings Company, LLC"},
	{"314 890", "Central Council of the Tlingit & Haida Indian Tribes of Alaska"},
	{"314 900", "Inland Cellular Telephone Company"},
	{"316 011", "Southern LINC"},
	{"316 700", "Mile High Networks LLC"},
	{"330 000", "Open Mobile"},
	{"330 110", "Claro Puerto Rico"},
	{"330 120", "Open Mobile"},
	{"334 001", "Comunicaciones Digitales Del Norte, S.A. de C.V."},
	{"334 010", "AT&T"},
	{"334 020", "Telcel"},
	{"334 030", "Movistar"},
	{"334 040", "Unefon"},
	{"334 050", "AT&T / Unefon"},
	{"334 060", "Servicios de Acceso Inalambrico, S.A. de C.V."},
	{"334 066", "Telefonos de Mexico, S.A.B. de C.V."},
	{"334 070", "Unefon"},
	{"334 080", "Unefon"},
	{"334 090", "AT&T"},
	{"334 100", "Financiera para el Bienestar"},
	{"334 110", "Maxcom Telecomunicaciones, S.A.B. de C.V."},
	{"334 120", "Quickly Phone, S.A. de C.V."},
	{"334 130", "ALESTRA SERVICIOS MOVILES, S.A. DE C.V."},
	{"334 140", "Red Compartida"},
	{"334 150", "Ultranet"},
	{"334 160", "Television Internacional, S.A. de C.V."},
	{"334 170", "OXIO Mobile, S.A. de C.V."},
	{"334 180", "FreedomPop"},
	{"334 190", "Viasat"},
	{"334 200", "Virgin Mobile"},
	{"334 210", "YO Mobile"},
	{"334 220", "Megamovil"},
	{"334 230", "VINOC, S.A.P.I. de C.V."},
	{"334 240", "PEGASO PCS, S.A. DE C.V. (Movistar)"},
	{"338 020", "FLOW"},
	{"338 040", "Caricel"},
	{"338 05", "Digicel"},
	{"338 05", "Digicel"},
	{"338 05", "Digicel"},
	{"338 05", "Digicel"},
	{"338 050", "Digicel"},
	{"338 050", "Digicel"},
	{"338 070", "Claro"},
	{"338 080", "Rock Mobile Limited"},
	{"338 110", "FLOW"},
	{"338 180", "FLOW"},
	{"340 01", "Orange"},
	{"340 02", "SFR Caraibe"},
	{"340 03", "FLOW"},
	{"340 04", "Free"},
	{"340 05", "Free"},
	{"340 08", "Dauphin"},
	{"340 09", "Free"},
	{"340 10", "SRIR"},
	{"340 11", "Guyane Telephone Mobile"},
	{"340 12", "Martinique Telephone Mobile"},
	{"340 20", "Digicel"},
	{"342 600", "FLOW"},
	{"342 646", "KW Telecommunications Inc."},
	{"342 750", "Digicel"},
	{"342 800", "Ozone"},
	{"342 820", "Neptune Communications Inc."},
	{"344 030", "inet"},
	{"344 050", "Digicel"},
	{"344 920", "FLOW"},
	{"344 930", "AT&T Wireless"},
	{"346 001", "Logic"},
	{"346 007", "Paradise Mobile Limited"},
	{"346 050", "Digicel"},
	{"346 140", "FLOW"},
	{"348 170", "FLOW"},
	{"348 370", "BVI Cable TV Ltd"},
	{"348 570", "CCT Boatphone"},
	{"348 770", "Digicel"},
	{"350 00", "One"},
	{"350 007", "Paradise Mobile"},
	{"350 01", "Digicel Bermuda"},
	{"350 02", "Mobility"},
	{"350 05", "Telecom Networks"},
	{"350 11", "Deltronics"},
	{"350 15", "FKB Net Ltd."},
	{"352 021", "Spice Mobile"},
	{"352 030", "Digicel"},
	{"352 110", "FLOW"},
	{"354 860", "FLOW"},
	{"356 050", "Digicel"},
	{"356 070", "FLOW"},
	{"356 110", "FLOW"},
	{"358 110", "FLOW"},
	{"360 050", "Digicel"},
	{"360 100", "Cingular Wireless"},
	{"360 110", "FLOW"},
	{"362 31", "Eutel N.V."},
	{"362 33", "WICC N.V."},
	{"362 51", "Telcell"},
	{"362 54", "ECC"},
	{"362 59", "FLOW"},
	{"362 60", "FLOW"},
	{"362 63", "CSC N.V."},
	{"362 68", "Digicel"},
	{"362 69", "Digicel"},
	{"362 74", "PCS N.V."},
	{"362 76", "Digicel"},
	{"362 78", "Kla Mobile"},
	{"362 91", "FLOW"},
	{"362 94", "Bayos"},
	{"362 95", "MIO"},
	{"363 01", "SETAR"},
	{"363 02", "Digicel"},
	{"364 39", "BTC"},
	{"364 49", "Aliv"},
	{"365 010", "Digicel"},
	{"365 840", "FLOW"},
	{"366 020", "Digicel"},
	{"366 110", "FLOW"},
	{"368 01", "CUBACEL"},
	{"370 01", "Altice"},
	{"370 02", "Claro"},
	{"370 03", "Altice"},
	{"370 04", "Viva"},
	{"370 05", "Wind"},
	{"372 01", "Voila"},
	{"372 02", "Digicel"},
	{"372 03", "Natcom"},
	{"374 01", "bmobile"},
	{"374 12", "bmobile"},
	{"374 120", "bmobile"},
	{"374 129", "bmobile"},
	{"374 13", "Digicel"},
	{"374 130", "Digicel"},
	{"374 140", "Laqtel"},
	{"374 20", "bmobile"},
	{"376 350", "FLOW"},
	{"376 351", "Digicel"},
	{"376 352", "FLOW"},
	{"376 360", "Digicel"},
	{"400 01", "Azercell"},
	{"400 02", "Bakcell"},
	{"400 03", "FONEX"},
	{"400 04", "Nar Mobile"},
	{"400 05", "Special State Protection Service of the Republic of Azerbaijan"},
	{"400 06", "Naxtel"},
	{"401 01", "Beeline"},
	{"401 02", "Kcell"},
	{"401 04", "Beeline"},
	{"401 07", "Altel"},
	{"401 08", "Kazakhtelecom"},
	{"401 10", "Freedom Telecom Operations LLP"},
	{"401 77", "Tele2.kz"},
	{"402 11", "B-Mobile"},
	{"402 17", "B-Mobile"},
	{"402 77", "TashiCell"},
	{"404 01", "Vi India"},
	{"404 02", "AirTel"},
	{"404 03", "AirTel"},
	{"404 04", "Vi India"},
	{"404 05", "Vi India"},
	{"404 07", "Vi India"},
	{"404 09", "Reliance"},
	{"404 10", "AirTel"},
	{"404 11", "Vi India"},
	{"404 12", "Vi India"},
	{"404 13", "Vi India"},
	{"404 14", "Vi India"},
	{"404 15", "Vi India"},
	{"404 16", "Airtel"},
	{"404 17", "AIRCEL"},
	{"404 18", "Reliance"},
	{"404 19", "Vi India"},
	{"404 20", "Vi India"},
	{"404 21", "Loop Mobile"},
	{"404 22", "Vi India"},
	{"404 23", "Reliance"},
	{"404 24", "Vi India"},
	{"404 25", "AIRCEL"},
	{"404 27", "Vi India"},
	{"404 28", "AIRCEL"},
	{"404 29", "AIRCEL"},
	{"404 30", "Vi India"},
	{"404 31", "AirTel"},
	{"404 33", "AIRCEL"},
	{"404 34", "BSNL Mobile"},
	{"404 35", "Aircel"},
	{"404 36", "Reliance"},
	{"404 37", "Aircel"},
	{"404 38", "BSNL Mobile"},
	{"404 40", "AirTel"},
	{"404 41", "Aircel"},
	{"404 42", "Aircel"},
	{"404 43", "Vi India"},
	{"404 44", "Vi India"},
	{"404 45", "Airtel"},
	{"404 46", "Vi India"},
	{"404 48", "Dishnet Wireless"},
	{"404 49", "Airtel"},
	{"404 50", "Reliance"},
	{"404 51", "BSNL Mobile"},
	{"404 52", "Reliance"},
	{"404 53", "BSNL Mobile"},
	{"404 54", "BSNL Mobile"},
	{"404 55", "BSNL Mobile"},
	{"404 56", "Vi India"},
	{"404 57", "BSNL Mobile"},
	{"404 58", "BSNL Mobile"},
	{"404 59", "BSNL Mobile"},
	{"404 60", "Vi India"},
	{"404 62", "BSNL Mobile"},
	{"404 64", "BSNL Mobile"},
	{"404 66", "BSNL Mobile"},
	{"404 67", "Reliance"},
	{"404 68", "MTNL"},
	{"404 69", "MTNL"},
	{"404 70", "AirTel"},
	{"404 71", "BSNL Mobile"},
	{"404 72", "BSNL Mobile"},
	{"404 73", "BSNL Mobile"},
	{"404 74", "BSNL Mobile"},
	{"404 75", "BSNL Mobile"},
	{"404 76", "BSNL Mobile"},
	{"404 77", "BSNL Mobile"},
	{"404 78", "Vi India"},
	{"404 79", "BSNL Mobile"},
	{"404 80", "BSNL Mobile"},
	{"404 81", "BSNL Mobile"},
	{"404 82", "Idea"},
	{"404 83", "Reliance"},
	{"404 84", "Vi India"},
	{"404 85", "Reliance"},
	{"404 86", "Vi India"},
	{"404 87", "Idea"},
	{"404 88", "Vi India"},
	{"404 89", "Idea"},
	{"404 90", "AirTel (Maharashtra)"},
	{"404 91", "AIRCEL"},
	{"404 92", "AirTel (Mumbai)"},
	{"404 93", "AirTel (Madhya Pradesh)"},
	{"404 94", "AirTel (Tamil Nadu)"},
	{"404 95", "AirTel (Kerala)"},
	{"404 96", "AirTel (Haryana)"},
	{"404 97", "AirTel (UP-West)"},
	{"404 98", "AirTel (Gujarat)"},
	{"405 024", "HFCL INFOT (Ping Mobile Brand)"},
	{"405 025", "TATA DOCOMO"},
	{"405 026", "TATA DOCOMO"},
	{"405 027", "TATA DOCOMO"},
	{"405 028", "TATA DOCOMO"},
	{"405 029", "TATA DOCOMO"},
	{"405 03", "Reliance"},
	{"405 030", "TATA DOCOMO"},
	{"405 031", "TATA DOCOMO"},
	{"405 032", "TATA DOCOMO"},
	{"405 033", "TATA DOCOMO"},
	{"405 034", "TATA DOCOMO"},
	{"405 035", "TATA DOCOMO"},
	{"405 036", "TATA DOCOMO"},
	{"405 037", "TATA DOCOMO"},
	{"405 038", "TATA DOCOMO"},
	{"405 039", "TATA DOCOMO"},
	{"405 04", "Reliance"},
	{"405 041", "TATA DOCOMO"},
	{"405 042", "TATA DOCOMO"},
	{"405 043", "TATA DOCOMO"},
	{"405 044", "TATA DOCOMO"},
	{"405 045", "TATA DOCOMO"},
	{"405 046", "TATA DOCOMO"},
	{"405 047", "TATA DOCOMO"},
	{"405 048", "INDIAN RAILWAYS GSM-R"},
	{"405 05", "Reliance"},
	{"405 06", "Reliance"},
	{"405 07", "Reliance"},
	{"405 08", "Reliance"},
	{"405 09", "Reliance"},
	{"405 10", "Reliance"},
	{"405 11", "Reliance"},
	{"405 12", "Reliance"},
	{"405 13", "Reliance"},
	{"405 14", "Reliance"},
	{"405 15", "Reliance"},
	{"405 17", "Reliance"},
	{"405 18", "Reliance"},
	{"405 19", "Reliance"},
	{"405 20", "Reliance"},
	{"405 21", "Reliance"},
	{"405 22", "Reliance"},
	{"405 23", "Reliance"},
	{"405 51", "AirTel (West Bengal)"},
	{"405 52", "AirTel (Bihar)"},
	{"405 53", "AirTel (Orissa)"},
	{"405 54", "AirTel (UP East)"},
	{"405 55", "Airtel (Jammu & Kasmir)"},
	{"405 56", "AirTel (Assam)"},
	{"405 66", "Vi India"},
	{"405 67", "Vi India"},
	{"405 70", "Idea"},
	{"405 750", "Vi India"},
	{"405 751", "Vi India"},
	{"405 752", "Vi India"},
	{"405 753", "Vi India"},
	{"405 754", "Vi India"},
	{"405 755", "Vi India"},
	{"405 756", "Vi India"},
	{"405 799", "Vi India"},
	{"405 800", "AIRCEL"},
	{"405 801", "AIRCEL"},
	{"405 802", "AIRCEL"},
	{"405 803", "AIRCEL"},
	{"405 804", "AIRCEL"},
	{"405 805", "AIRCEL"},
	{"405 806", "AIRCEL"},
	{"405 807", "AIRCEL"},
	{"405 808", "AIRCEL"},
	{"405 809", "AIRCEL"},
	{"405 81", "AIRCELL"},
	{"405 810", "AIRCEL"},
	{"405 811", "AIRCEL"},
	{"405 812", "AIRCEL"},
	{"405 813", "Uninor"},
	{"405 814", "Uninor"},
	{"405 815", "Uninor"},
	{"405 816", "Uninor"},
	{"405 817", "Uninor"},
	{"405 818", "Uninor"},
	{"405 819", "Uninor"},
	{"405 82", "AIRCELL"},
	{"405 820", "Uninor"},
	{"405 821", "Uninor"},
	{"405 822", "Uninor"},
	{"405 824", "Videocon Telecom"},
	{"405 825", "Videocon Telecom"},
	{"405 826", "Videocon Telecom"},
	{"405 827", "Videocon Telecom"},
	{"405 828", "Videocon Telecom"},
	{"405 829", "Videocon Telecom"},
	{"405 83", "AIRCELL"},
	{"405 831", "Videocon Telecom"},
	{"405 832", "Videocon Telecom"},
	{"405 833", "Videocon Telecom"},
	{"405 834", "Videocon Telecom"},
	{"405 835", "Videocon Telecom"},
	{"405 836", "Videocon Telecom"},
	{"405 837", "Videocon Telecom"},
	{"405 838", "Videocon Telecom"},
	{"405 839", "Videocon Telecom"},
	{"405 840", "Jio Bengal"},
	{"405 841", "Videocon Telecom"},
	{"405 842", "Videocon Telecom"},
	{"405 843", "Videocon Telecom"},
	{"405 844", "Uninor"},
	{"405 845", "Idea"},
	{"405 846", "Idea"},
	{"405 847", "Vi India"},
	{"405 848", "Idea"},
	{"405 849", "Idea"},
	{"405 850", "Idea"},
	{"405 851", "Vi India"},
	{"405 852", "Idea"},
	{"405 853", "Idea"},
	{"405 854", "Jio Andhra Pradesh"},
	{"405 855", "Jio Assam"},
	{"405 856", "Jio Bihar"},
	{"405 857", "Jio Gujarat"},
	{"405 858", "Jio Haryana"},
	{"405 859", "Jio Pradesh"},
	{"405 860", "Jio Mumbai"},
	{"405 861", "Jio Karnataka"},
	{"405 862", "Jio Kerala"},
	{"405 863", "Jio Madhya Pradesh"},
	{"405 864", "Jio Maharashtra"},
	{"405 865", "Jio North East"},
	{"405 866", "Jio Orissa"},
	{"405 867", "Jio Punjab"},
	{"405 868", "Jio Rajasthan"},
	{"405 869", "Jio Tamil Nadu"},
	{"405 870", "Jio Uttar Pradesh (West)"},
	{"405 871", "Jio Uttar Pradesh (East)"},
	{"405 872", "Jio Delhi"},
	{"405 873", "Jio Kolkata"},
	{"405 874", "Jio Mumbai"},
	{"405 875", "Uninor"},
	{"405 876", "Uninor"},
	{"405 877", "Uninor"},
	{"405 878", "Uninor"},
	{"405 879", "Uninor"},
	{"405 880", "Uninor"},
	{"405 881", "S Tel"},
	{"405 882", "S Tel"},
	{"405 883", "S Tel"},
	{"405 884", "S Tel"},
	{"405 885", "S Tel"},
	{"405 886", "S Tel"},
	{"405 887", "SISTEMA SHYAM"},
	{"405 888", "SISTEMA SHYAM"},
	{"405 889", "SISTEMA SHYAM"},
	{"405 890", "SISTEMA SHYAM"},
	{"405 891", "SISTEMA SHYAM"},
	{"405 892", "SISTEMA SHYAM"},
	{"405 893", "SISTEMA SHYAM"},
	{"405 894", "SISTEMA SHYAM"},
	{"405 895", "SISTEMA SHYAM"},
	{"405 896", "SISTEMA SHYAM"},
	{"405 897", "SISTEMA SHYAM"},
	{"405 898", "SISTEMA SHYAM"},
	{"405 899", "SISTEMA SHYAM"},
	{"405 900", "SISTEMA SHYAM"},
	{"405 901", "SISTEMA SHYAM"},
	{"405 902", "SISTEMA SHYAM"},
	{"405 903", "SISTEMA SHYAM"},
	{"405 904", "SISTEMA SHYAM"},
	{"405 905", "SISTEMA SHYAM"},
	{"405 906", "SISTEMA SHYAM"},
	{"405 907", "SISTEMA SHYAM"},
	{"405 908", "Vi India"},
	{"405 909", "Vi India"},
	{"405 910", "Vi India"},
	{"405 911", "Vi India"},
	{"405 912", "Etisalat DB (cheers)"},
	{"405 913", "Etisalat DB (cheers)"},
	{"405 914", "Etisalat DB (cheers)"},
	{"405 915", "Etisalat DB (cheers)"},
	{"405 916", "Etisalat DB (cheers)"},
	{"405 917", "Etisalat DB (cheers)"},
	{"405 918", "Etisalat DB (cheers)"},
	{"405 919", "Etisalat DB (cheers)"},
	{"405 920", "Etisalat DB (cheers)"},
	{"405 921", "Etisalat DB (cheers)"},
	{"405 922", "Etisalat DB (cheers)"},
	{"405 923", "Etisalat DB (cheers)"},
	{"405 924", "Etisalat DB (cheers)"},
	{"405 925", "Uninor"},
	{"405 926", "Uninor"},
	{"405 927", "Uninor"},
	{"405 928", "Uninor"},
	{"405 929", "Uninor"},
	{"405 930", "Etisalat DB (cheers)"},
	{"405 931", "Etisalat DB (cheers)"},
	{"405 932", "VIDEOCON (HFCL)-GSM"},
	{"410 01", "Jazz"},
	{"410 02", "3G EVO / CharJi 4G"},
	{"410 03", "Ufone"},
	{"410 04", "Zong"},
	{"410 05", "SCO Mobile"},
	{"410 06", "Telenor"},
	{"410 07", "Jazz"},
	{"410 08", "SCO Mobile"},
	{"412 01", "AWCC"},
	{"412 20", "Roshan"},
	{"412 40", "ATOMA"},
	{"412 50", "Etisalat"},
	{"412 55", "WASEL"},
	{"412 80", "Salaam"},
	{"412 88", "Salaam"},
	{"413 01", "SLTMobitel"},
	{"413 02", "Dialog"},
	{"413 03", "Hutch"},
	{"413 04", "Lanka Bell"},
	{"413 05", "Airtel"},
	{"413 08", "Hutch"},
	{"413 09", "Hutch"},
	{"413 11", "Dialog"},
	{"413 12", "SLTMobitel"},
	{"414 00", "MPT"},
	{"414 01", "MPT"},
	{"414 02", "MPT"},
	{"414 03", "CDMA800"},
	{"414 04", "MPT"},
	{"414 05", "Ooredoo"},
	{"414 06", "ATOM"},
	{"414 09", "Mytel"},
	{"414 20", "ACS"},
	{"414 21", "ACS"},
	{"414 22", "Fortune Telecom Co., Ltd"},
	{"414 23", "Global Technology Co., Ltd"},
	{"415 01", "Alfa"},
	{"415 03", "Touch"},
	{"415 05", "Ogero Mobile"},
	{"415 36", "Libancell"},
	{"415 37", "Libancell"},
	{"415 38", "Libancell"},
	{"415 39", "Libancell"},
	{"416 01", "zain JO"},
	{"416 02", "XPress Telecom"},
	{"416 03", "Umniah"},
	{"416 77", "Orange"},
	{"417 01", "Syriatel"},
	{"417 02", "MTN"},
	{"417 03", "Wafa Telecom"},
	{"417 09", "Syrian Telecom"},
	{"417 50", "Rcell"},
	{"418 00", "Asia Cell"},
	{"418 05", "Asia Cell"},
	{"418 08", "SanaTel"},
	{"418 20", "Zain"},
	{"418 30", "Zain"},
	{"418 40", "Korek"},
	{"418 45", "Mobitel"},
	{"418 62", "Itisaluna"},
	{"418 66", "Fastlink"},
	{"418 92", "Omnnea"},
	{"419 02", "zain KW"},
	{"419 03", "Ooredoo"},
	{"419 04", "STC"},
	{"420 01", "Al Jawal (STC )"},
	{"420 03", "Mobily"},
	{"420 04", "Zain SA"},
	{"420 05", "Virgin Mobile"},
	{"420 06", "Lebara Mobile"},
	{"420 09", "Salam"},
	{"420 10", "Future Networks Communications"},
	{"420 21", "RGSM"},
	{"421 01", "SabaFon"},
	{"421 02", "YOU"},
	{"421 03", "Yemen Mobile"},
	{"421 04", "Y"},
	{"421 10", "Yemen-4G"},
	{"421 11", "Yemen Mobile"},
	{"422 02", "Omantel"},
	{"422 03", "Ooredoo"},
	{"422 04", "Omantel"},
	{"422 06", "Vodafone"},
	{"424 02", "Etisalat"},
	{"424 03", "du"},
	{"425 01", "Partner"},
	{"425 02", "Cellcom"},
	{"425 03", "Pelephone"},
	{"425 04", "Voye Global Connectivity Ltd."},
	{"425 05", "Jawwal"},
	{"425 05", "Jawwal"},
	{"425 06", "Ooredoo"},
	{"425 06", "Wataniya Mobile"},
	{"425 07", "Hot Mobile"},
	{"425 08", "Cellcom"},
	{"425 09", "We4G"},
	{"425 10", "Voicenter Ltd."},
	{"425 11", "Merkaziya Ltd"},
	{"425 12", "Free Telecom"},
	{"425 13", "Ituran Cellular Communications"},
	{"425 14", "Pelephone"},
	{"425 15", "Cellcom"},
	{"425 16", "Rami Levy"},
	{"425 17", "Sipme"},
	{"425 18", "Cellact Communications"},
	{"425 19", "019 Mobile"},
	{"425 20", "Bezeq"},
	{"425 21", "Xphone 018 Ltd."},
	{"425 22", "Maskyoo Telephonia Ltd."},
	{"425 23", "Beezz Communication Solutions Ltd."},
	{"425 24", "012 Mobile"},
	{"425 25", "IMOD"},
	{"425 26", "Annatel"},
	{"425 27", "Paycall Ltd"},
	{"425 28", "PHI Networks"},
	{"425 29", "C.M.G Networks"},
	{"426 01", "Batelco"},
	{"426 02", "zain BH"},
	{"426 03", "Civil Aviation Authority"},
	{"426 04", "stc"},
	{"426 05", "Batelco"},
	{"426 06", "stc"},
	{"426 07", "TAIF"},
	{"427 01", "Ooredoo"},
	{"427 02", "Vodafone"},
	{"427 05", "Ministry of Interior"},
	{"427 06", "Ministry of Interior"},
	{"428 33", "ONDO"},
	{"428 88", "Unitel"},
	{"428 91", "Skytel"},
	{"428 98", "G-Mobile"},
	{"428 99", "Mobicom"},
	{"429 01", "Namaste / NT Mobile / Sky Phone"},
	{"429 02", "Ncell"},
	{"429 03", "UTL"},
	{"429 04", "SmartCell"},
	{"432 01", "Kish Cell Pars"},
	{"432 02", "ApTel, AzarTel"},
	{"432 03", "Parsian Hamrah Lotus"},
	{"432 04", "TOSE E FANAVARI ERTEBATAT NOVIN HAMRAH"},
	{"432 05", "Smart Comm"},
	{"432 06", "Arian-Tel"},
	{"432 07", "Hooshmand Amin Mobile"},
	{"432 08", "Shatel Mobile"},
	{"432 09", "HiWEB"},
	{"432 10", "Samantel"},
	{"432 11", "IR-TCI (Hamrah-e-Avval)"},
	{"432 12", "Avacell (HiWEB)"},
	{"432 13", "HiWEB"},
	{"432 14", "TKC/KFZO"},
	{"432 19", "Espadan"},
	{"432 20", "RighTel"},
	{"432 32", "Taliya"},
	{"432 35", "MTN Irancell"},
	{"432 44", "Mobinnet"},
	{"432 45", "Zi-Tel"},
	{"432 46", "HiWEB"},
	{"432 49", "Gostaresh Ertebatat Mabna"},
	{"432 50", "Shatel Mobile"},
	{"432 51", "Pishgaman Tose'e Ertebatat"},
	{"432 52", "Asiatech"},
	{"432 70", "MTCE"},
	{"432 71", "KOOHE NOOR"},
	{"432 90", "Iraphone"},
	{"432 93", "Farzanegan Pars"},
	{"432 93", "Iraphone"},
	{"432 99", "TCI"},
	{"434 01", "Buztel"},
	{"434 02", "Uzmacom"},
	{"434 03", "UzMobile"},
	{"434 04", "Beeline"},
	{"434 05", "Ucell"},
	{"434 06", "Perfectum Mobile"},
	{"434 07", "Mobiuz"},
	{"434 08", "UzMobile"},
	{"434 09", "EVO"},
	{"434 10", "HUMANS"},
	{"436 01", "Tcell"},
	{"436 02", "Tcell"},
	{"436 03", "MegaFon"},
	{"436 04", "Babilon-M"},
	{"436 05", "ZET-Mobile"},
	{"436 10", "Babilon-T"},
	{"436 12", "Tcell"},
	{"437 01", "Beeline"},
	{"437 03", "NurTelecom LLC"},
	{"437 04", "Alfa Telecom CJSC"},
	{"437 05", "MegaCom"},
	{"437 06", "Kyrgyztelecom OJSC"},
	{"437 09", "O!"},
	{"437 10", "Saima Telecom"},
	{"437 11", "iTel"},
	{"438 01", "MTS"},
	{"438 02", "TM-Cell"},
	{"438 03", "AGTS CDMA"},
	{"440 00", "Y!Mobile"},
	{"440 01", "KDDI Corporation"},
	{"440 02", "Hanshin Cable Engineering Co., Ltd."},
	{"440 03", "IIJmio"},
	{"440 04", "Japan Radio Company, Ltd."},
	{"440 05", "Wireless City Planning Inc."},
	{"440 06", "SAKURA Internet Inc."},
	{"440 07", "closip, Inc."},
	{"440 08", "Panasonic Connect Co., Ltd."},
	{"440 09", "Misora Connect Inc."},
	{"440 10", "NTT docomo"},
	{"440 11", "Rakuten Mobile"},
	{"440 12", "Cable media waiwai Co., Ltd."},
	{"440 13", "NTT Communications Corporation"},
	{"440 14", "Grape One Co., Ltd."},
	{"440 15", "BB Backbone Corp."},
	{"440 16", "Nokia Innovations Japan G.K."},
	{"440 17", "Osaka Gas Business Create Co., Ltd."},
	{"440 18", "Kintetsu Cable Network Co., Ltd."},
	{"440 19", "NEC Networks & System Integration Corporation"},
	{"440 20", "SoftBank"},
	{"440 21", "SoftBank"},
	{"440 22", "JTOWER Inc."},
	{"440 23", "Fujitsu Ltd."},
	{"440 24", "Japan Communications Inc."},
	{"440 25", "SoftBank"},
	{"440 26", "NTT docomo"},
	{"440 50", "au"},
	{"440 51", "au"},
	{"440 52", "au"},
	{"440 53", "au"},
	{"440 54", "au"},
	{"440 55", "au"},
	{"440 70", "au"},
	{"440 71", "au"},
	{"440 72", "au"},
	{"440 73", "au"},
	{"440 74", "au"},
	{"440 75", "au"},
	{"440 76", "au"},
	{"440 78", "au"},
	{"440 91", "NTT docomo"},
	{"440 92", "KDDI Corporation"},
	{"440 93", "SoftBank"},
	{"440 94", "Rakuten Mobile"},
	{"441 01", "SoftBank"},
	{"441 10", "UQ WiMAX"},
	{"441 200", "Soracom Inc."},
	{"441 201", "Aurens Co., Ltd."},
	{"441 202", "Sony Wireless Communications Inc."},
	{"441 203", "Gujo City"},
	{"441 204", "Wicom Inc."},
	{"441 205", "Katch Network Inc."},
	{"441 206", "Mitsubishi Electric Corp."},
	{"441 207", "Mitsui Knowledge Industry Co., Ltd."},
	{"441 208", "Chudenko Corp."},
	{"441 209", "Cable Television Toyama Inc."},
	{"441 210", "NTT East Corp."},
	{"441 211", "Starcat Cable Network Co., Ltd."},
	{"441 212", "I-TEC Solutions Co., Ltd."},
	{"441 213", "Hokkaido Telecommunication Network Co., Inc."},
	{"441 214", "Vroove Inc."},
	{"441 215", "KYOCERA Mirai Envision Co., Ltd."},
	{"441 216", "Eureka Wireless K.K."},
	{"441 91", "Tokyo Organising Committee of the Olympic and Paralympic Games"},
	{"450 01", "Globalstar Asia Pacific"},
	{"450 02", "KT"},
	{"450 03", "Power 017"},
	{"450 04", "KT"},
	{"450 05", "SKTelecom"},
	{"450 06", "LG U+"},
	{"450 07", "KT"},
	{"450 08", "olleh"},
	{"450 11", "Tplus"},
	{"450 12", "SKTelecom"},
	{"452 01", "MobiFone"},
	{"452 02", "Vinaphone"},
	{"452 03", "S-Fone"},
	{"452 04", "Viettel Mobile"},
	{"452 05", "Vietnamobile"},
	{"452 06", "EVNTelecom"},
	{"452 07", "Gmobile"},
	{"452 08", "I-Telecom"},
	{"452 09", "Wintel"},
	{"454 00", "1O1O / One2Free / New World Mobility / SUNMobile"},
	{"454 01", "CITIC Telecom 1616"},
	{"454 02", "CSL Limited"},
	{"454 03", "3"},
	{"454 04", "3 (2G)"},
	{"454 05", "3 (CDMA)"},
	{"454 06", "SmarTone"},
	{"454 07", "China Unicom"},
	{"454 08", "Truphone"},
	{"454 09", "China Motion Telecom"},
	{"454 10", "New World Mobility"},
	{"454 11", "China-Hong Kong Telecom"},
	{"454 12", "CMCC HK"},
	{"454 13", "CMCC HK"},
	{"454 14", "Hutchison Telecom"},
	{"454 15", "SmarTone"},
	{"454 16", "PCCW Mobile (2G)"},
	{"454 17", "SmarTone"},
	{"454 18", "CSL Limited"},
	{"454 19", "PCCW Mobile (3G)"},
	{"454 20", "PCCW Mobile (4G)"},
	{"454 21", "VNET Group Limited"},
	{"454 22", "HuiYinBi Telecom (Hong Kong) Limited"},
	{"454 23", "Lycamobile"},
	{"454 24", "Multibyte Info Technology Ltd"},
	{"454 25", "Hong Kong Government"},
	{"454 26", "Hong Kong Government"},
	{"454 29", "PCCW Mobile (CDMA)"},
	{"454 290", "Hong Kong Government"},
	{"454 30", "CMCC HK"},
	{"454 31", "CTExcel"},
	{"454 32", "Hong Kong Broadband Network Ltd"},
	{"454 35", "Webbing Hong Kong Ltd"},
	{"454 36", "Easco Telecommunications Limited"},
	{"454 380", "Hong Kong Government"},
	{"454 382", "South China Telecommunications (H.K.) Limited"},
	{"454 383", "China Mobile Hong Kong Company Limited"},
	{"454 390", "Hong Kong Government"},
	{"455 00", "SmarTone"},
	{"455 01", "CTM"},
	{"455 02", "China Telecom"},
	{"455 03", "HT Macau / 3 Macau"},
	{"455 04", "CTM"},
	{"455 05", "3 Macau"},
	{"455 06", "SmarTone"},
	{"455 07", "China Telecom"},
	{"456 01", "Cellcard"},
	{"456 02", "Smart"},
	{"456 03", "qb"},
	{"456 04", "qb"},
	{"456 05", "Smart"},
	{"456 06", "Smart"},
	{"456 08", "Metfone"},
	{"456 09", "Metfone"},
	{"456 11", "SEATEL"},
	{"456 18", "Cellcard"},
	{"457 01", "LaoTel"},
	{"457 02", "ETL"},
	{"457 03", "Unitel"},
	{"457 07", "Best"},
	{"457 08", "TPLUS"},
	{"460 00", "China Mobile"},
	{"460 01", "China Unicom"},
	{"460 02", "China Mobile"},
	{"460 03", "China Telecom"},
	{"460 04", "China Mobile"},
	{"460 05", "China Telecom"},
	{"460 06", "China Unicom"},
	{"460 07", "China Mobile"},
	{"460 08", "China Mobile"},
	{"460 09", "China Unicom"},
	{"460 11", "China Telecom"},
	{"460 15", "China Broadnet"},
	{"460 20", "China Tietong"},
	{"466 01", "FarEasTone"},
	{"466 02", "FarEasTone"},
	{"466 03", "FarEasTone"},
	{"466 05", "Gt"},
	{"466 06", "FarEasTone"},
	{"466 07", "FarEasTone"},
	{"466 09", "VMAX"},
	{"466 10", "G1"},
	{"466 11", "Chunghwa LDM"},
	{"466 12", "Asia Pacific Telecom"},
	{"466 56", "FITEL"},
	{"466 68", "Tatung InfoComm"},
	{"466 88", "FarEasTone"},
	{"466 89", "T Star"},
	{"466 90", "T Star"},
	{"466 92", "Chunghwa"},
	{"466 93", "Taiwan Mobile"},
	{"466 97", "Taiwan Mobile"},
	{"466 99", "Taiwan Mobile"},
	{"467 05", "Koryolink"},
	{"467 06", "Kangsong NET"},
	{"467 193", "SunNet"},
	{"470 01", "Grameenphone"},
	{"470 02", "Robi"},
	{"470 03", "Banglalink"},
	{"470 04", "TeleTalk"},
	{"470 05", "Citycell"},
	{"470 07", "Airtel"},
	{"470 09", "ollo"},
	{"470 10", "Banglalion"},
	{"472 01", "Dhiraagu"},
	{"472 02", "Ooredoo"},
	{"311 780", "ASTCA"},
	{"502 01", "ATUR 450"},
	{"502 10", "Celcom, DiGi, Maxis, Tune Talk, U Mobile, Unifi, XOX, Yes"},
	{"502 11", "TM Homeline"},
	{"502 12", "Maxis"},
	{"502 13", "CelcomDigi"},
	{"502 14", "Telekom Malaysia Berhad for PSTN SMS"},
	{"502 150", "Tune Talk"},
	{"502 151", "SalamFone"},
	{"502 152", "Yes"},
	{"502 153", "unifi"},
	{"502 154", "Tron"},
	{"502 155", "Clixster"},
	{"502 156", "Altel"},
	{"502 157", "Telin"},
	{"502 16", "DiGi"},
	{"502 17", "Maxis"},
	{"502 18", "U Mobile"},
	{"502 19", "Celcom"},
	{"502 20", "Electcoms"},
	{"505 01", "Telstra"},
	{"505 02", "Optus"},
	{"505 03", "Vodafone"},
	{"505 04", "Department of Defence"},
	{"505 05", "Ozitel"},
	{"505 06", "3"},
	{"505 07", "TPG Telecom"},
	{"505 08", "One.Tel"},
	{"505 09", "Airnet"},
	{"505 10", "Norfolk Island"},
	{"505 10", "Norfolk Telecom"},
	{"505 11", "Telstra"},
	{"505 12", "3"},
	{"505 13", "RailCorp"},
	{"505 14", "AAPT"},
	{"505 15", "3GIS"},
	{"505 16", "VicTrack"},
	{"505 17", "Optus"},
	{"505 18", "Pactel"},
	{"505 19", "Lycamobile"},
	{"505 20", "Ausgrid Corporation"},
	{"505 21", "Queensland Rail"},
	{"505 22", "iiNet"},
	{"505 23", "Vocus"},
	{"505 24", "Advanced Communications Technologies"},
	{"505 25", "Pilbara Iron"},
	{"505 26", "Sinch Australia"},
	{"505 27", "Ergon Energy Telecommunications"},
	{"505 28", "RCOM International"},
	{"505 30", "Compatel"},
	{"505 31", "BHP"},
	{"505 32", "Thales Australia"},
	{"505 33", "Sinch Australia"},
	{"505 34", "Santos"},
	{"505 35", "Bird.com"},
	{"505 36", "Optus"},
	{"505 37", "Yancoal"},
	{"505 38", "Truphone"},
	{"505 39", "Telstra"},
	{"505 40", "CITIC Pacific Mining"},
	{"505 41", "Aqura Technologies"},
	{"505 42", "GEMCO"},
	{"505 43", "Arrow Energy"},
	{"505 44", "Roy Hill"},
	{"505 45", "Clermont Coal Operations"},
	{"505 46", "AngloGold Ashanti Australia Ltd"},
	{"505 47", "Woodside Energy"},
	{"505 48", "Titan ICT"},
	{"505 49", "Field Solutions Group"},
	{"505 50", "Pivotel Group"},
	{"505 51", "Fortescue"},
	{"505 52", "OptiTel Australia"},
	{"505 53", "Shell Australia"},
	{"505 54", "Nokia"},
	{"505 55", "New South Wales Government Telecommunications Authority"},
	{"505 56", "Nokia"},
	{"505 57", "CiFi"},
	{"505 58", "Wi-Sky"},
	{"505 59", "Starlink"},
	{"505 60", "Starlink"},
	{"505 61", "CommTel NS"},
	{"505 62", "NBN"},
	{"505 63", "MarchNet"},
	{"505 68", "NBN"},
	{"505 71", "Telstra"},
	{"505 72", "Telstra"},
	{"505 88", "Pivotel Group"},
	{"505 90", "Alphawest"},
	{"505 99", "Telstra"},
	{"510 00", "PSN"},
	{"510 01", "Indosat"},
	{"510 03", "StarOne"},
	{"510 07", "TelkomFlexi"},
	{"510 08", "AXIS"},
	{"510 09", "Smartfren"},
	{"510 10", "Telkomsel"},
	{"510 11", "XL"},
	{"510 20", "TelkomMobile"},
	{"510 21", "Indosat"},
	{"510 27", "Net1"},
	{"510 28", "Fren/Hepi"},
	{"510 78", "hinet"},
	{"510 88", "Bolt!"},
	{"510 89", "3"},
	{"510 99", "Esia"},
	{"514 01", "Telkomcel"},
	{"514 02", "TT"},
	{"514 03", "Telemor"},
	{"515 01", "Islacom"},
	{"515 02", "Globe"},
	{"515 03", "SMART"},
	{"515 05", "Sun Cellular"},
	{"515 11", "PLDT via ACeS Philippines"},
	{"515 18", "Cure"},
	{"515 24", "ABS-CBN Mobile"},
	{"515 66", "DITO"},
	{"515 88", "Next Mobile Inc."},
	{"520 00", "TrueMove H / my by NT"},
	{"520 01", "AIS"},
	{"520 02", "NT Mobile"},
	{"520 03", "AIS"},
	{"520 04", "TrueMove H"},
	{"520 05", "dtac"},
	{"520 09", "Royal Thai Police"},
	{"520 15", "AIS-T / NT Mobile"},
	{"520 17", "NT Mobile"},
	{"520 18", "dtac"},
	{"520 20", "ACeS"},
	{"520 23", "AIS GSM 1800"},
	{"520 25", "WE PCT"},
	{"520 47", "dtac-T, True-T"},
	{"520 99", "TrueMove"},
	{"525 01", "SingTel"},
	{"525 02", "SingTel-G18"},
	{"525 03", "M1"},
	{"525 04", "Grid"},
	{"525 05", "StarHub"},
	{"525 06", "StarHub"},
	{"525 07", "StarHub"},
	{"525 08", "StarHub"},
	{"525 09", "Circles.Life"},
	{"525 10", "SIMBA"},
	{"525 11", "M1"},
	{"525 12", "Grid"},
	{"525 200", "5G Test Bed"},
	{"525 201", "5G EP Twin Networks"},
	{"525 202", "5G EP Twin Networks"},
	{"525 203", "5G EP Twin Networks"},
	{"525 204", "5G EP Twin Networks"},
	{"525 205", "5G EP Test Bed"},
	{"528 01", "TelBru"},
	{"528 02", "PCSB"},
	{"528 03", "UNN"},
	{"528 11", "DST"},
	{"530 00", "Spark"},
	{"530 01", "One NZ"},
	{"530 02", "Spark"},
	{"530 03", "Woosh"},
	{"530 04", "One NZ"},
	{"530 05", "Spark"},
	{"530 06", "FX Networks"},
	{"530 07", "Dense Air New Zealand"},
	{"530 11", "Interim Maori Spectrum Commission"},
	{"530 12", "BAINZ"},
	{"530 13", "One NZ"},
	{"530 14", "2degrees"},
	{"530 15", "Spark"},
	{"530 24", "2degrees"},
	{"536 02", "Digicel"},
	{"536 03", "Nauru Telikom Corporation"},
	{"537 01", "bmobile"},
	{"537 02", "citifon"},
	{"537 03", "Digicel"},
	{"537 04", "Digitec Communication Ltd."},
	{"539 01", "U-Call"},
	{"539 43", "Shoreline Communication"},
	{"539 88", "Digicel"},
	{"540 01", "BREEZE"},
	{"540 02", "BeMobile"},
	{"541 00", "AIL"},
	{"541 01", "SMILE"},
	{"541 05", "Digicel"},
	{"541 07", "WanTok"},
	{"542 01", "Vodafone"},
	{"542 02", "Digicel"},
	{"542 03", "TFL"},
	{"543 01", "Manuia"},
	{"544 11", "Bluesky"},
	{"545 01", "Kiribati - ATH"},
	{"545 02", "OceanLink"},
	{"545 09", "Kiribati - Frigate Net"},
	{"546 01", "Mobilis"},
	{"547 05", "Ora"},
	{"547 10", "Mara Telecom"},
	{"547 15", "Vodafone"},
	{"547 20", "Vini"},
	{"548 01", "Vodafone"},
	{"548 02", "VakaNET Ltd."},
	{"549 00", "Digicel"},
	{"549 01", "Digicel"},
	{"549 27", "Vodafone"},
	{"550 01", "FSMTC"},
	{"550 02", "iBoom!"},
	{"551 01", "Marshall Islands National Telecommunications Authority (MINTA)"},
	{"552 01", "PNCC"},
	{"552 02", "PT Waves"},
	{"552 80", "Palau Mobile"},
	{"552 99", "PMCI"},
	{"553 01", "TTC"},
	{"554 01", "Teletok"},
	{"555 01", "Telecom Niue"},
	{"602 01", "Orange"},
	{"602 02", "Vodafone"},
	{"602 03", "e&"},
	{"602 04", "WE"},
	{"603 01", "Mobilis"},
	{"603 02", "Djezzy"},
	{"603 03", "Ooredoo"},
	{"603 07", "AT"},
	{"603 09", "AT"},
	{"603 21", "ANESRIF"},
	{"604 00", "Orange Morocco"},
	{"604 01", "IAM"},
	{"604 02", "INWI"},
	{"604 04", "Al Houria Telecom"},
	{"604 05", "INWI"},
	{"604 06", "IAM"},
	{"604 99", "Al Houria Telecom"},
	{"605 01", "Orange"},
	{"605 02", "Tunicell"},
	{"605 03", "Ooredoo"},
	{"606 00", "Libyana"},
	{"606 01", "Madar"},
	{"606 02", "Al-Jeel Phone"},
	{"606 03", "Libya Phone"},
	{"606 06", "Hatef Libya"},
	{"607 01", "Gamcel"},
	{"607 02", "Africell"},
	{"607 03", "Comium"},
	{"607 04", "QCell"},
	{"607 05", "Gamtel-Ecowan"},
	{"607 06", "NETPAGE"},
	{"608 01", "Orange"},
	{"608 02", "Free"},
	{"608 03", "Expresso"},
	{"608 04", "CSU-SA"},
	{"609 01", "Mattel"},
	{"609 02", "Chinguitel"},
	{"609 10", "Moov"},
	{"610 01", "Malitel"},
	{"610 02", "Orange"},
	{"610 03", "Telecel"},
	{"611 01", "Orange"},
	{"611 02", "Guinee Telecom"},
	{"611 03", "Intercel"},
	{"611 04", "MTN"},
	{"611 05", "Cellcom"},
	{"612 01", "Cora de Comstar"},
	{"612 02", "Moov"},
	{"612 03", "Orange"},
	{"612 04", "KoZ"},
	{"612 05", "MTN"},
	{"612 06", "GreenN"},
	{"612 07", "cafe"},
	{"612 18", "YooMee"},
	{"613 01", "Moov"},
	{"613 02", "Orange"},
	{"613 03", "Telecel Faso"},
	{"614 01", "SahelCom"},
	{"614 02", "Airtel"},
	{"614 03", "Moov"},
	{"614 04", "Orange"},
	{"615 01", "Togo Cell"},
	{"615 03", "Moov"},
	{"616 01", "Benin Telecoms Mobile"},
	{"616 02", "Moov"},
	{"616 03", "MTN"},
	{"616 04", "BBCOM"},
	{"616 05", "Glo"},
	{"616 07", "Celtiis"},
	{"617 01", "my.t"},
	{"617 02", "MOKOZE / AZU"},
	{"617 03", "CHILI"},
	{"617 10", "Emtel"},
	{"618 01", "Lonestar Cell MTN"},
	{"618 02", "Libercell"},
	{"618 04", "Novafone"},
	{"618 07", "Orange LBR"},
	{"618 20", "LIBTELCO"},
	{"619 01", "Orange"},
	{"619 02", "Africell"},
	{"619 03", "Africell"},
	{"619 04", "Comium"},
	{"619 05", "Africell"},
	{"619 06", "SierraTel"},
	{"619 07", "Qcell Sierra Leone"},
	{"619 09", "Smart Mobile"},
	{"619 25", "Mobitel"},
	{"619 40", "Datatel (SL) Ltd."},
	{"619 50", "Datatel (SL) Ltd."},
	{"620 01", "MTN"},
	{"620 02", "Vodafone"},
	{"620 03", "AT Ghana"},
	{"620 04", "Expresso"},
	{"620 05", "National Security"},
	{"620 06", "AT Ghana"},
	{"620 07", "Globacom"},
	{"620 08", "Surfline"},
	{"620 09", "NITA"},
	{"620 10", "Blu"},
	{"620 11", "Netafrique Dot Com Ltd"},
	{"620 12", "BTL"},
	{"620 13", "Goldkey"},
	{"620 14", "busy"},
	{"620 15", "Lebara"},
	{"620 16", "Telesol"},
	{"620 17", "iBurst Africa"},
	{"621 00", "Capcom"},
	{"621 20", "Airtel"},
	{"621 22", "InterC"},
	{"621 24", "Spectranet"},
	{"621 25", "Visafone"},
	{"621 26", "Swift"},
	{"621 27", "Smile"},
	{"621 28", "MCom (Mafab)"},
	{"621 30", "MTN"},
	{"621 40", "Ntel"},
	{"621 50", "Glo"},
	{"621 60", "9mobile"},
	{"622 01", "Airtel"},
	{"622 02", "Tawali"},
	{"622 03", "Tigo"},
	{"622 07", "Salam"},
	{"623 01", "Moov"},
	{"623 02", "TC"},
	{"623 03", "Orange"},
	{"623 04", "Azur"},
	{"624 01", "MTN Cameroon"},
	{"624 02", "Orange"},
	{"624 03", "Camtel"},
	{"624 04", "Nexttel"},
	{"625 01", "CVMOVEL"},
	{"625 02", "T+"},
	{"626 01", "CSTmovel"},
	{"626 02", "Unitel STP"},
	{"627 01", "Orange GQ"},
	{"627 03", "Muni"},
	{"628 01", "Libertis"},
	{"628 02", "Moov"},
	{"628 03", "Airtel"},
	{"628 04", "Azur"},
	{"628 05", "RAG"},
	{"629 01", "Airtel"},
	{"629 07", "Airtel"},
	{"629 10", "Libertis Telecom"},
	{"630 01", "Vodacom"},
	{"630 02", "Airtel"},
	{"630 05", "Supercell"},
	{"630 86", "Orange RDC"},
	{"630 88", "YTT"},
	{"630 89", "Orange RDC"},
	{"630 90", "Africell"},
	{"631 02", "UNITEL"},
	{"631 04", "MOVICEL"},
	{"631 05", "Africell"},
	{"632 01", "Guinetel"},
	{"632 02", "MTN Areeba"},
	{"632 03", "Orange"},
	{"632 07", "Guinetel"},
	{"633 01", "Cable & Wireless"},
	{"633 02", "Mediatech"},
	{"633 05", "Intelvision Ltd"},
	{"633 10", "Airtel"},
	{"634 01", "Zain SD"},
	{"634 02", "MTN"},
	{"634 03", "MTN"},
	{"634 05", "canar"},
	{"634 07", "Sudani One"},
	{"634 09", "khartoum INC"},
	{"635 10", "MTN Rwanda"},
	{"635 11", "Liquid Telecom"},
	{"635 12", "Liquid Telecom"},
	{"635 13", "Airtel"},
	{"635 14", "Airtel"},
	{"635 17", "KTRN"},
	{"636 01", "MTN"},
	{"636 02", "Safari"},
	{"637 01", "Telesom"},
	{"637 04", "Somafone"},
	{"637 10", "Nationlink"},
	{"637 20", "SOMNET"},
	{"637 30", "Golis"},
	{"637 50", "Hormuud"},
	{"637 57", "UNITEL"},
	{"637 60", "Nationlink"},
	{"637 67", "Horntel Group"},
	{"637 70", "Onkod Telecom Ltd."},
	{"637 71", "Somtel"},
	{"637 82", "Telcom"},
	{"638 01", "Evatis"},
	{"639 01", "Safaricom IoT"},
	{"639 02", "Safaricom"},
	{"639 03", "Airtel"},
	{"639 04", "Mobile Pay Kenya Limited"},
	{"639 05", "Airtel"},
	{"639 06", "Finserve Africa Limited"},
	{"639 07", "Telkom"},
	{"639 08", "Wetribe Ltd"},
	{"639 09", "Homeland Media Group Limited"},
	{"639 10", "Faiba 4G"},
	{"639 11", "Jambo Telcoms Limited"},
	{"639 12", "Infura Limited"},
	{"639 13", "Hidiga Investments Ltd"},
	{"639 14", "NRG Media Limited"},
	{"640 01", "Shared Network Tanzania Limited"},
	{"640 02", "tiGO"},
	{"640 03", "Zantel"},
	{"640 04", "Vodacom"},
	{"640 05", "Airtel"},
	{"640 06", "WIA Company Limited"},
	{"640 07", "TTCL Mobile"},
	{"640 08", "Smart"},
	{"640 09", "Halotel"},
	{"640 11", "Smile"},
	{"640 12", "MyCell Limited"},
	{"640 13", "Cootel"},
	{"640 14", "MO Mobile Holding Limited"},
	{"641 01", "Airtel"},
	{"641 04", "Tangerine Uganda Limited"},
	{"641 06", "Vodafone"},
	{"641 08", "Talkio Mobile Limited"},
	{"641 10", "MTN"},
	{"641 11", "Uganda Telecom"},
	{"641 14", "Africell"},
	{"641 16", "SimbaNET Uganda Limited"},
	{"641 18", "Smart"},
	{"641 20", "Hamilton Telecom Limited"},
	{"641 22", "Airtel"},
	{"641 26", "Lycamobile"},
	{"641 30", "Anupam Global Soft Uganda Limited"},
	{"641 33", "Smile"},
	{"641 40", "Civil Aviation Authority (CAA)"},
	{"641 44", "K2"},
	{"641 66", "i-Tel"},
	{"642 01", "econet Leo"},
	{"642 02", "Tempo"},
	{"642 03", "Onatel"},
	{"642 07", "Smart Mobile"},
	{"642 08", "Lumitel"},
	{"642 82", "econet Leo"},
	{"643 01", "tmCel"},
	{"643 03", "Movitel"},
	{"643 04", "Vodacom"},
	{"645 01", "Airtel"},
	{"645 02", "MTN"},
	{"645 03", "ZAMTEL"},
	{"645 04", "Zedmobile"},
	{"645 07", "Liquid Telecom Zambia Limited"},
	{"646 01", "Airtel"},
	{"646 02", "Orange"},
	{"646 03", "Sacel"},
	{"646 04", "Telma"},
	{"646 05", "BIP / blueline"},
	{"647 00", "Orange"},
	{"647 01", "Maore Mobile"},
	{"647 02", "Only"},
	{"647 03", "Free"},
	{"647 04", "Zeop"},
	{"647 10", "SFR Reunion"},
	{"648 01", "Net*One"},
	{"648 03", "Telecel"},
	{"648 04", "Econet"},
	{"649 01", "MTC"},
	{"649 02", "switch"},
	{"649 03", "TN Mobile"},
	{"649 04", "Paratus Telecommunications (Pty)"},
	{"649 05", "Click Cloud Hosting Services CC"},
	{"649 06", "MTN Namibia"},
	{"649 07", "Loc Eight Mobile (Pty) Ltd"},
	{"650 01", "TNM"},
	{"650 02", "Access"},
	{"650 03", "MTL"},
	{"650 10", "Airtel"},
	{"651 01", "Vodacom"},
	{"651 02", "Econet Telecom"},
	{"651 10", "Vodacom"},
	{"652 01", "Mascom"},
	{"652 02", "Orange"},
	{"652 04", "BTC Mobile"},
	{"652 06", "Paratus Telecommunications (Pty) Ltd"},
	{"653 01", "SPTC"},
	{"653 02", "Eswatini Mobile Limited"},
	{"653 10", "MTN Eswatini"},
	{"654 01", "HURI"},
	{"654 02", "TELCO SA"},
	{"655 01", "Vodacom"},
	{"655 02", "Telkom"},
	{"655 03", "Telkom"},
	{"655 04", "Sasol (Pty) Ltd."},
	{"655 05", "Telkom SA Ltd"},
	{"655 06", "Sentech (Pty) Ltd"},
	{"655 07", "Cell C"},
	{"655 08", "Cell C"},
	{"655 09", "Cell C"},
	{"655 10", "MTN"},
	{"655 11", "MTN"},
	{"655 12", "MTN"},
	{"655 13", "Neotel"},
	{"655 14", "Neotel"},
	{"655 16", "Phoenix System Integration (Pty) Ltd"},
	{"655 17", "Sishen Iron Ore Company (Ltd) Pty"},
	{"655 18", "MTN"},
	{"655 19", "rain"},
	{"655 21", "Cape Town Metropolitan Council"},
	{"655 24", "SMSPortal (Pty) Ltd."},
	{"655 25", "Wirels Connect"},
	{"655 27", "A to Z Vaal Industrial Supplies Pty Ltd"},
	{"655 28", "Hymax Talking Solutions (Pty) Ltd"},
	{"655 30", "Bokamoso Consortium"},
	{"655 31", "Karabo Telecoms (Pty) Ltd."},
	{"655 32", "Ilizwi Telecommunications"},
	{"655 33", "Thinta Thinta Telecommunications Pty Ltd"},
	{"655 34", "Bokone Telecoms Pty Ltd"},
	{"655 35", "Kingdom Communications Pty Ltd"},
	{"655 36", "Amatole Telecommunications Pty Ltd"},
	{"655 38", "rain"},
	{"655 41", "South African Police Service"},
	{"655 46", "SMS Cellular Services (Pty) Ltd"},
	{"655 50", "Ericsson South Africa (Pty) Ltd"},
	{"655 51", "Integrat (Pty) Ltd"},
	{"655 53", "Lycamobile"},
	{"655 65", "Vodacom Pty Ltd"},
	{"655 73", "rain"},
	{"655 74", "rain"},
	{"655 75", "ACSA"},
	{"655 76", "Comsol Networks (Pty) Ltd"},
	{"655 77", "Umoja Connect"},
	{"657 01", "Eritel"},
	{"658 01", "Sure"},
	{"659 02", "MTN"},
	{"659 03", "Gemtel"},
	{"659 04", "Vivacell"},
	{"659 05", "DIGITEL"},
	{"659 06", "Zain"},
	{"659 07", "Sudani"},
	{"340 01", "Orange"},
	{"340 02", "SFR Caraibe"},
	{"340 11", "Guyane Telephone Mobile"},
	{"340 20", "Digicel"},
	{"702 67", "DigiCell"},
	{"702 68", "INTELCO"},
	{"702 69", "SMART"},
	{"702 99", "SMART"},
	{"704 01", "Claro"},
	{"704 02", "Tigo"},
	{"704 03", "Claro"},
	{"704 04", "digicel"},
	{"704 05", "RED/INTELFON"},
	{"706 01", "Claro"},
	{"706 02", "Digicel"},
	{"706 03", "Tigo"},
	{"706 04", "Movistar"},
	{"706 05", "RED"},
	{"708 001", "Claro"},
	{"708 002", "Tigo"},
	{"708 030", "Hondutel"},
	{"708 040", "Digicel"},
	{"710 21", "Claro"},
	{"710 300", "Tigo"},
	{"710 73", "Claro"},
	{"712 01", "Kolbi ICE"},
	{"712 02", "Kolbi ICE"},
	{"712 03", "Claro"},
	{"712 04", "Liberty"},
	{"712 20", "RACSA"},
	{"714 01", "+Movil"},
	{"714 02", "Tigo"},
	{"714 020", "Tigo"},
	{"714 03", "Claro"},
	{"714 04", "Digicel"},
	{"714 05", "Cable & Wireless"},
	{"716 06", "Movistar"},
	{"716 07", "Entel"},
	{"716 10", "Claro"},
	{"716 15", "Bitel"},
	{"716 17", "Entel"},
	{"722 01", "Tuenti"},
	{"722 010", "Movistar & Tuenti"},
	{"722 020", "Nextel"},
	{"722 034", "Personal"},
	{"722 040", "Globalstar"},
	{"722 07", "Movistar"},
	{"722 070", "Movistar"},
	{"722 210", "IMOWI"},
	{"722 310", "Claro"},
	{"722 320", "Claro"},
	{"722 330", "Claro"},
	{"722 340", "Personal"},
	{"722 341", "Personal"},
	{"722 350", "PORT-HABLE"},
	{"724 00", "Nextel"},
	{"724 01", "SISTEER DO BRASIL TELECOMUNICACOES"},
	{"724 02", "TIM"},
	{"724 03", "TIM"},
	{"724 04", "TIM"},
	{"724 05", "Claro"},
	{"724 06", "Vivo"},
	{"724 10", "Vivo"},
	{"724 11", "Vivo"},
	{"724 12", "Claro"},
	{"724 13", "NLT"},
	{"724 15", "Sercomtel"},
	{"724 16", "Brasil Telecom GSM"},
	{"724 17", "Surf Telecom"},
	{"724 18", "datora"},
	{"724 21", "LIGUE"},
	{"724 23", "Vivo"},
	{"724 24", "Amazonia Celular"},
	{"724 28", "No name"},
	{"724 29", "Unifique"},
	{"724 30", "Oi"},
	{"724 31", "Oi"},
	{"724 32", "Algar Telecom"},
	{"724 33", "Algar Telecom"},
	{"724 34", "Algar Telecom"},
	{"724 35", "Telcom Telecomunicacoes"},
	{"724 36", "Options Telecomunicacoes"},
	{"724 37", "aeiou"},
	{"724 38", "Claro"},
	{"724 39", "Nextel"},
	{"724 40", "Telecall"},
	{"724 54", "Conecta"},
	{"724 99", "Local"},
	{"730 01", "Entel"},
	{"730 02", "Movistar"},
	{"730 03", "Claro"},
	{"730 04", "WOM"},
	{"730 05", "Multikom S.A."},
	{"730 06", "Telsur"},
	{"730 07", "Movistar"},
	{"730 08", "VTR Movil"},
	{"730 09", "WOM"},
	{"730 10", "Entel"},
	{"730 11", "Celupago S.A."},
	{"730 12", "Colo-Colo Movil<br />Wanderers Movil"},
	{"730 13", "Virgin Mobile"},
	{"730 14", "Netline Telefonica Movil Ltda"},
	{"730 15", "Cibeles Telecom S.A."},
	{"730 16", "Nomade Telecomunicaciones S.A."},
	{"730 17", "COMPATEL Chile Limitada"},
	{"730 18", "Empresas Bunker S.A."},
	{"730 19", "movil Falabella"},
	{"730 20", "Inversiones Santa Fe Limitada"},
	{"730 21", "Entel"},
	{"730 22", "Cellplus SpA"},
	{"730 23", "Claro"},
	{"730 24", "Claro"},
	{"730 26", "Entel"},
	{"730 27", "Cibeles Telecom S.A."},
	{"730 29", "Entel"},
	{"730 99", "Will"},
	{"732 001", "Movistar"},
	{"732 002", "Edatel"},
	{"732 003", "LLEIDA S.A.S."},
	{"732 004", "COMPATEL COLOMBIA SAS"},
	{"732 020", "Tigo"},
	{"732 099", "EMCALI"},
	{"732 100", "Claro"},
	{"732 101", "Claro"},
	{"732 102", "Bellsouth Colombia"},
	{"732 103", "Tigo"},
	{"732 111", "Tigo"},
	{"732 123", "Movistar"},
	{"732 124", "Movistar"},
	{"732 130", "AVANTEL"},
	{"732 142", "Une EPM Telecomunicaciones S.A. E.S.P."},
	{"732 154", "Virgin Mobile"},
	{"732 157", "Movil Exito"},
	{"732 165", "Colombia Movil S.A. ESP"},
	{"732 176", "DirecTV Colombia Ltda"},
	{"732 187", "eTb"},
	{"732 199", "SUMA Movil SAS"},
	{"732 208", "UFF Movil SAS"},
	{"732 210", "Hablame Colombia SAS ESP"},
	{"732 220", "Libre Tecnologias SAS"},
	{"732 230", "Setroc Mobile Group SAS"},
	{"732 240", "Logistica Flash Colombia SAS"},
	{"732 250", "Plintron Colombia SAS"},
	{"732 360", "WOM"},
	{"732 363", "Partners Telecom Colombia SAS"},
	{"732 666", "Claro"},
	{"734 01", "Digitel"},
	{"734 02", "Digitel"},
	{"734 03", "DirecTV"},
	{"734 04", "Movistar"},
	{"734 06", "Movilnet"},
	{"734 08", "PATRIACELL C.A."},
	{"736 01", "Viva"},
	{"736 02", "Entel"},
	{"736 03", "Tigo"},
	{"738 00", "E-Networks"},
	{"738 002", "GT&T Cellink Plus"},
	{"738 003", "Quark Communications Inc."},
	{"738 01", "Digicel"},
	{"738 040", "E-Networks"},
	{"738 05", "eGovernment Unit, Ministry of the Presidency"},
	{"740 00", "Movistar"},
	{"740 01", "Claro"},
	{"740 02", "CNT Mobile"},
	{"740 03", "Tuenti"},
	{"742 04", "Free"},
	{"744 01", "VOX"},
	{"744 02", "Claro"},
	{"744 03", "Compania Privada de Comunicaciones S.A."},
	{"744 04", "Tigo"},
	{"744 05", "Personal"},
	{"744 06", "Copaco"},
	{"746 02", "Telesur"},
	{"746 03", "Digicel"},
	{"746 04", "Digicel"},
	{"746 05", "Telesur"},
	{"748 00", "Antel"},
	{"748 01", "Antel"},
	{"748 03", "Antel"},
	{"748 07", "Movistar"},
	{"748 10", "Claro"},
	{"748 15", "ENALUR S.A."},
	{"750 001", "Sure"},
	{"001 001", "TEST"},
	{"001 01", "TEST"},
	{"901 01", "Webbing"},
	{"901 02", "GlobalmatiX AG"},
	{"901 03", "Iridium"},
	{"901 04", "BBIX Singapore Pte. Ltd."},
	{"901 05", "Thuraya RMSS Network"},
	{"901 06", "Thuraya Satellite Telecommunications Company"},
	{"901 07", "NTT Ltd."},
	{"901 08", "SpaceX"},
	{"901 09", "China Telecommunications Corporation"},
	{"901 10", "Omnispace LLC"},
	{"901 11", "Inmarsat"},
	{"901 12", "Telenor"},
	{"901 13", "GSM.AQ"},
	{"901 14", "AeroMobile"},
	{"901 15", "OnAir"},
	{"901 16", "Cisco Jasper"},
	{"901 17", "Navitas"},
	{"901 18", "WMS"},
	{"901 19", "Epic Maritime"},
	{"901 20", "Intermatica"},
	{"901 21", "Wins Limited"},
	{"901 22", "MediaLincc Ltd"},
	{"901 23", "Bloxtel Inc."},
	{"901 24", "iNum"},
	{"901 25", "Datora Mobile Telecomunicacoes SA"},
	{"901 26", "TIM@sea"},
	{"901 27", "OnMarine"},
	{"901 28", "Vodafone"},
	{"901 29", "Telenor"},
	{"901 30", "OQ Technology"},
	{"901 31", "Orange"},
	{"901 32", "Sky High"},
	{"901 33", "Smart Communications"},
	{"901 34", "tyntec GmbH"},
	{"901 35", "Globecomm Network Services"},
	{"901 36", "Azerfon"},
	{"901 37", "Transatel"},
	{"901 38", "Multiregional TransitTelecom (MTT)"},
	{"901 39", "MTX Connect Ltd"},
	{"901 40", "1NCE "},
	{"901 41", "One Network B.V."},
	{"901 42", "IMC Island Ehf"},
	{"901 43", "EMnify GmbH"},
	{"901 44", "AT&T Inc."},
	{"901 45", "Advanced Wireless Network Company Limited"},
	{"901 46", "Telecom26 AG"},
	{"901 47", "SFR"},
	{"901 48", "Com4"},
	{"901 49", "Zain"},
	{"901 50", "EchoStar Mobile"},
	{"901 51", "VisionNG"},
	{"901 52", "Manx Telecom Trading Ltd."},
	{"901 53", "European Aviation Network"},
	{"901 54", "Teleena Holding B.V."},
	{"901 55", "Beezz Communication Solutions Ltd."},
	{"901 56", "ETSI"},
	{"901 57", "SAP"},
	{"901 58", "BICS"},
	{"901 59", "Bird B.V."},
	{"901 60", "OneWeb"},
	{"901 61", "MTN Management Services"},
	{"901 62", "KORE Wireless"},
	{"901 63", "Beamlink, Inc."},
	{"901 64", "Syniverse Technologies, LLC"},
	{"901 65", "Plintron Global Technology Solutions Pty Ltd"},
	{"901 66", "Limitless Mobile LLC"},
	{"901 67", "1NCE GmbH"},
	{"901 68", "Maersk Line A/S"},
	{"901 69", "Legos"},
	{"901 70", "Clementvale Baltic OU"},
	{"901 71", "Tampnet AS"},
	{"901 72", "Tele2 Sverige Aktiebolag"},
	{"901 73", "Cubic Telecom Limited"},
	{"901 74", "Etisalat"},
	{"901 75", "Giesecke+Devrient"},
	{"901 76", "A1 Telekom Austria AG"},
	{"901 77", "Bouygues Telecom"},
	{"901 78", "Telecom Italia Sparkle S.p.A."},
	{"901 79", "Nokia Corporation"},
	{"901 80", "Flo Live Limited"},
	{"901 81", "Airnity SAS"},
	{"901 82", "Eseye Limited"},
	{"901 83", "iBasis Netherlands BV"},
	{"901 84", "Telefonica Moviles Espana, S.A. Unipersonal"},
	{"901 85", "Telefonica Germany GmbH & Co. OHG"},
	{"901 86", "BJT Partners SAS"},
	{"901 87", "Cisco Systems, Inc."},
	{"901 88", "Bondio Limited"},
	{"901 89", "DIDWW Ireland Limited"},
	{"901 90", "Truphone Limited"},
	{"901 91", "World Mobile Group Limited"},
	{"901 92", "Phonegroup SA"},
	{"901 93", "SkyFive AG"},
	{"901 94", "Intelsat US LLC"},
	{"901 95", "HMD Global Oy"},
	{"901 96", "KORE Wireless"},
	{"901 97", "Satelio IoT Services S.L."},
	{"901 98", "Skylo"},
	{"901 99", "Athalos Global Services BV"},
	{"902 01", "MulteFire Alliance"},
	{"991 01", "World's Global Telecom"},
	{"991 02", "5G Croco"},
	{"991 03", "Halys SAS"},
	{"991 04", "E-Space Inc."},
	{"995 01", "FonePlus"},
	{"999 99", "GammuTel"},
	{"999 999", "Internal use"},

	{"", ""},
};

const unsigned char *GSM_GetNetworkName(const char *NetworkCode)
{
	int i = 0;
	static char retval[200];
	char NetworkCodeFull[8];
	const char *pos;

	EncodeUnicode(retval, "unknown", 7);

	/* Too long string */
	if (strlen(NetworkCode) > 7 || strlen(NetworkCode) < 5) {
		return retval;
	}
	pos = strchr(NetworkCode, ' ');
	if (pos == NULL) {
		pos = NetworkCode + 3;
	} else {
		pos += 1;
	}

	sprintf(NetworkCodeFull, "%c%c%c %s", NetworkCode[0], NetworkCode[1], NetworkCode[2], pos);

	for (i = 0; GSM_Networks[i].Code[0] != 0; i++) {
		if (strcmp(GSM_Networks[i].Code, NetworkCodeFull) == 0) {
			EncodeUnicode(retval, GSM_Networks[i].Name, strlen(GSM_Networks[i].Name));
			break;
		}
	}

	return retval;
}

const unsigned char *GSM_GetCountryName(const char *CountryCode)
{
	int		i = 0;
	static char	retval[200];

	EncodeUnicode(retval,"unknown",7);
	for (i = 0; GSM_Countries[i].Code[0] != 0; i++) {
		if (!strncmp(GSM_Countries[i].Code, CountryCode, 3)) {
			EncodeUnicode(retval, GSM_Countries[i].Name, strlen(GSM_Countries[i].Name));
			break;
		}
	}
	return retval;
}

void NOKIA_EncodeNetworkCode(unsigned char* buffer, const char* input)
{
	EncodeBCD(buffer, input, 6, FALSE);
	buffer[1] = buffer[1] | 0xf0;
}

void NOKIA_DecodeNetworkCode(const unsigned char* buffer, char* output)
{
	DecodeBCD(output, buffer, 3);
	output[6] = output[5];
	output[5] = output[4];
	output[4] = output[3];
	output[3] = ' ';
}

/* How should editor hadle tabs in this file? Add editor commands here.
 * vim: noexpandtab sw=8 ts=8 sts=8:
 */
