/* WindowOverview.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowOverview.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann
 * Copyright 2012 Rico Tzschichholz
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <meta/workspace.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include <meta/keybindings.h>
#include <mtk/mtk.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <meta/prefs.h>

#define GALA_WINDOW_OVERVIEW_BORDER 10
#define GALA_WINDOW_OVERVIEW_TOP_GAP 30
#define GALA_WINDOW_OVERVIEW_BOTTOM_GAP 100
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_OVERVIEW (gala_window_overview_get_type ())
#define GALA_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview))
#define GALA_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))
#define GALA_IS_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_IS_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_WINDOW_OVERVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))

typedef struct _GalaWindowOverview GalaWindowOverview;
typedef struct _GalaWindowOverviewClass GalaWindowOverviewClass;
typedef struct _GalaWindowOverviewPrivate GalaWindowOverviewPrivate;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
enum  {
	GALA_WINDOW_OVERVIEW_0_PROPERTY,
	GALA_WINDOW_OVERVIEW_ACTOR_PROPERTY,
	GALA_WINDOW_OVERVIEW_WM_PROPERTY,
	GALA_WINDOW_OVERVIEW_NUM_PROPERTIES
};
static GParamSpec* gala_window_overview_properties[GALA_WINDOW_OVERVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WINDOW_LIST_MODEL (gala_window_list_model_get_type ())
#define GALA_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel))
#define GALA_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))
#define GALA_IS_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_IS_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_WINDOW_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))

typedef struct _GalaWindowListModel GalaWindowListModel;
typedef struct _GalaWindowListModelClass GalaWindowListModelClass;
typedef enum  {
	GALA_WINDOW_LIST_MODEL_SORT_MODE_NONE,
	GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING
} GalaWindowListModelSortMode;

#define GALA_WINDOW_LIST_MODEL_TYPE_SORT_MODE (gala_window_list_model_sort_mode_get_type ())
typedef struct _Block58Data Block58Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaWindowOverview {
	GalaActorTarget parent_instance;
	GalaWindowOverviewPrivate * priv;
};

struct _GalaWindowOverviewClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWindowOverviewPrivate {
	GalaWindowManager* _wm;
	GalaGestureController* gesture_controller;
	GalaModalProxy* modal_proxy;
	GList* workspaces;
	GalaWindowCloneContainer* window_clone_container;
	guint64* window_ids;
	gint window_ids_length1;
	gint _window_ids_size_;
};

struct _Block58Data {
	int _ref_count_;
	GalaWindowOverview* self;
	MetaWindow* window;
};

static gint GalaWindowOverview_private_offset;
static gpointer gala_window_overview_parent_class = NULL;
static GalaRootTargetIface * gala_window_overview_gala_root_target_parent_iface = NULL;
static GalaActivatableComponentIface * gala_window_overview_gala_activatable_component_parent_iface = NULL;

VALA_EXTERN GType gala_window_overview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowOverview, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GalaWindowOverview* gala_window_overview_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowOverview* gala_window_overview_construct (GType object_type,
                                                    GalaWindowManager* wm);
static gboolean gala_window_overview_real_key_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static gboolean gala_window_overview_real_button_release_event (ClutterActor* base,
                                                         ClutterEvent* event);
static gboolean gala_window_overview_real_is_opened (GalaActivatableComponent* base);
static void gala_window_overview_real_open (GalaActivatableComponent* base,
                                     GHashTable* hints);
VALA_EXTERN GalaWindowManager* gala_window_overview_get_wm (GalaWindowOverview* self);
static guint64* _variant_get2 (GVariant* value,
                        gint* result_length1);
static guint64* _vala_array_dup6 (guint64* self,
                           gssize length);
VALA_EXTERN gboolean gala_notification_stack_is_notification (MetaWindow* window);
static gboolean _vala_uint64_array_contains (guint64 * stack,
                                      gssize stack_length,
                                      const guint64 needle);
static gboolean gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                                 MetaKeyBinding* binding);
static gboolean _gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                         gpointer self);
static gboolean gala_window_overview_window_filter_func (GalaWindowOverview* self,
                                                  GObject* obj);
static gboolean _gala_window_overview_window_filter_func_gtk_custom_filter_func (GObject* item,
                                                                          gpointer self);
VALA_EXTERN GType gala_window_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListModel, g_object_unref)
VALA_EXTERN GType gala_window_list_model_sort_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaWindowListModel* gala_window_list_model_new (MetaDisplay* display,
                                                 GalaWindowListModelSortMode sort_mode,
                                                 gboolean normal_filter,
                                                 gint monitor_filter,
                                                 MetaWorkspace* workspace_filter,
                                                 GtkFilter* custom_filter);
VALA_EXTERN GalaWindowListModel* gala_window_list_model_construct (GType object_type,
                                                       MetaDisplay* display,
                                                       GalaWindowListModelSortMode sort_mode,
                                                       gboolean normal_filter,
                                                       gint monitor_filter,
                                                       MetaWorkspace* workspace_filter,
                                                       GtkFilter* custom_filter);
static void gala_window_overview_on_items_changed (GalaWindowOverview* self,
                                            GListModel* model,
                                            guint pos,
                                            guint removed,
                                            guint added);
static void _gala_window_overview_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                        guint position,
                                                                        guint removed,
                                                                        guint added,
                                                                        gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaWindowListModel* windows,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaWindowListModel* windows,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                          MetaWindow* window);
static void _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                       MetaWindow* window,
                                                                                       gpointer self);
static void _____lambda115_ (GalaWindowOverview* self);
static void ______lambda115__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                   gpointer self);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static gboolean ___lambda114_ (Block58Data* _data58_);
static gboolean ____lambda114__gsource_func (gpointer self);
static void gala_window_overview_real_close (GalaActivatableComponent* base,
                                      GHashTable* hints);
static gboolean __lambda113_ (GalaWindowOverview* self);
static void gala_window_overview_cleanup (GalaWindowOverview* self);
static gboolean ___lambda113__gsource_func (gpointer self);
static void gala_window_overview_set_wm (GalaWindowOverview* self,
                                  GalaWindowManager* value);
static GObject * gala_window_overview_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void gala_window_overview_finalize (GObject * obj);
static GType gala_window_overview_get_type_once (void);
static void _vala_gala_window_overview_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_overview_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_window_overview_get_instance_private (GalaWindowOverview* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowOverview_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaWindowOverview*
gala_window_overview_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowOverview * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowOverview*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowOverview*
gala_window_overview_new (GalaWindowManager* wm)
{
	return gala_window_overview_construct (GALA_TYPE_WINDOW_OVERVIEW, wm);
}

static gboolean
gala_window_overview_real_key_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowOverview * self;
	GalaWindowCloneContainer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gala_activatable_component_is_opened ((GalaActivatableComponent*) self)) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->window_clone_container;
	g_signal_emit_by_name ((ClutterActor*) _tmp0_, "key-press-event", event, &_tmp1_);
	result = _tmp1_;
	return result;
}

static gboolean
gala_window_overview_real_button_release_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaWindowOverview * self;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

/**
     * {@inheritDoc}
     */
static gboolean
gala_window_overview_real_is_opened (GalaActivatableComponent* base)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint64*
_variant_get2 (GVariant* value,
               gint* result_length1)
{
	guint64* _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (guint64, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
	g_variant_iter_init (&_tmp1_, value);
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
		if (_tmp0__size == _tmp0__length) {
			_tmp0__size = 2 * _tmp0__size;
			_tmp0_ = g_renew (guint64, _tmp0_, _tmp0__size + 1);
		}
		_tmp0_[_tmp0__length++] = g_variant_get_uint64 (_tmp2_);
		g_variant_unref (_tmp2_);
	}
	*result_length1 = _tmp0__length1;
	return _tmp0_;
}

static guint64*
_vala_array_dup6 (guint64* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint64));
	}
	return NULL;
}

static gboolean
_vala_uint64_array_contains (guint64 * stack,
                             gssize stack_length,
                             const guint64 needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static gboolean
_gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                gpointer self)
{
	gboolean result;
	result = gala_window_overview_keybinding_filter ((GalaWindowOverview*) self, binding);
	return result;
}

static gboolean
_gala_window_overview_window_filter_func_gtk_custom_filter_func (GObject* item,
                                                                 gpointer self)
{
	gboolean result;
	result = gala_window_overview_window_filter_func ((GalaWindowOverview*) self, item);
	return result;
}

static void
_gala_window_overview_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                   guint position,
                                                                   guint removed,
                                                                   guint added,
                                                                   gpointer self)
{
	gala_window_overview_on_items_changed ((GalaWindowOverview*) self, _sender, position, removed, added);
}

static void
_gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                  MetaWindow* window,
                                                                                  gpointer self)
{
	gala_window_overview_thumb_selected ((GalaWindowOverview*) self, window);
}

static void
_____lambda115_ (GalaWindowOverview* self)
{
	gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
}

static void
______lambda115__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                              gpointer self)
{
	_____lambda115_ ((GalaWindowOverview*) self);
}

static void
gala_window_overview_real_open (GalaActivatableComponent* base,
                                GHashTable* hints)
{
	GalaWindowOverview * self;
	MetaWorkspaceManager* manager = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	GList* _tmp4_;
	guint64* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint __tmp7__size_ = 0;
	gboolean _tmp8_ = FALSE;
	guint64* _tmp11_;
	gint _tmp11__length1;
	GList* windows = NULL;
	GList* _tmp12_;
	GList* _tmp47_;
	GalaWindowManager* _tmp48_;
	GalaModalProxy* _tmp49_;
	GalaModalProxy* _tmp50_;
	GalaModalProxy* _tmp51_;
	GalaGestureAction* _tmp52_;
	GalaGestureAction* _tmp53_;
	gint _tmp53__length1;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp54_;
	MetaDisplay* _tmp55_;
	GList* _tmp77_;
	GalaGestureController* _tmp81_;
	self = (GalaWindowOverview*) base;
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	self->priv->workspaces = NULL;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_workspaces (_tmp3_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp4_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* workspace = NULL;
			workspace = (MetaWorkspace*) workspace_it->data;
			{
				MetaWorkspace* _tmp5_;
				MetaWorkspace* _tmp6_;
				_tmp5_ = workspace;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				self->priv->workspaces = g_list_append (self->priv->workspaces, _tmp6_);
			}
		}
	}
	if (hints != NULL) {
		_tmp8_ = g_hash_table_contains (hints, "windows");
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gconstpointer _tmp9_;
		guint64* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp9_ = g_hash_table_lookup (hints, "windows");
		_tmp10_ = _variant_get2 ((GVariant*) _tmp9_, &_tmp10__length1);
		_tmp7_ = (g_free (_tmp7_), NULL);
		_tmp7_ = _tmp10_;
		_tmp7__length1 = _tmp10__length1;
		__tmp7__size_ = _tmp7__length1;
	} else {
		_tmp7_ = (g_free (_tmp7_), NULL);
		_tmp7_ = NULL;
		_tmp7__length1 = 0;
		__tmp7__size_ = _tmp7__length1;
	}
	_tmp11_ = (_tmp7_ != NULL) ? _vala_array_dup6 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp11__length1 = _tmp7__length1;
	self->priv->window_ids = (g_free (self->priv->window_ids), NULL);
	self->priv->window_ids = _tmp11_;
	self->priv->window_ids_length1 = _tmp11__length1;
	self->priv->_window_ids_size_ = self->priv->window_ids_length1;
	windows = NULL;
	_tmp12_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp12_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp13_;
			MetaWorkspace* workspace = NULL;
			_tmp13_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp13_;
			{
				MetaWorkspace* _tmp14_;
				GList* _tmp15_;
				_tmp14_ = workspace;
				_tmp15_ = meta_workspace_list_windows (_tmp14_);
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp15_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							gboolean _tmp16_ = FALSE;
							MetaWindow* _tmp17_;
							MetaWindowType _tmp18_;
							MetaWindowType _tmp19_;
							gboolean _tmp21_ = FALSE;
							gboolean _tmp22_ = FALSE;
							gboolean _tmp23_ = FALSE;
							MetaWindow* _tmp24_;
							MetaWindowType _tmp25_;
							MetaWindowType _tmp26_;
							gboolean _tmp38_ = FALSE;
							MetaWindow* _tmp39_;
							gboolean _tmp40_;
							gboolean _tmp41_;
							MetaWindow* _tmp45_;
							MetaWindow* _tmp46_;
							_tmp17_ = window;
							_tmp18_ = meta_window_get_window_type (_tmp17_);
							_tmp19_ = _tmp18_;
							if (_tmp19_ == META_WINDOW_DOCK) {
								_tmp16_ = TRUE;
							} else {
								MetaWindow* _tmp20_;
								_tmp20_ = window;
								_tmp16_ = gala_notification_stack_is_notification (_tmp20_);
							}
							if (_tmp16_) {
								continue;
							}
							_tmp24_ = window;
							_tmp25_ = meta_window_get_window_type (_tmp24_);
							_tmp26_ = _tmp25_;
							if (_tmp26_ != META_WINDOW_NORMAL) {
								MetaWindow* _tmp27_;
								MetaWindowType _tmp28_;
								MetaWindowType _tmp29_;
								_tmp27_ = window;
								_tmp28_ = meta_window_get_window_type (_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp23_ = _tmp29_ != META_WINDOW_DIALOG;
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								_tmp22_ = TRUE;
							} else {
								MetaWindow* _tmp30_;
								_tmp30_ = window;
								_tmp22_ = meta_window_is_attached_dialog (_tmp30_);
							}
							if (_tmp22_) {
								_tmp21_ = TRUE;
							} else {
								gboolean _tmp31_ = FALSE;
								guint64* _tmp32_;
								gint _tmp32__length1;
								_tmp32_ = self->priv->window_ids;
								_tmp32__length1 = self->priv->window_ids_length1;
								if (_tmp32_ != NULL) {
									MetaWindow* _tmp33_;
									guint64* _tmp34_;
									gint _tmp34__length1;
									_tmp33_ = window;
									_tmp34_ = self->priv->window_ids;
									_tmp34__length1 = self->priv->window_ids_length1;
									_tmp31_ = !_vala_uint64_array_contains (_tmp34_, _tmp34__length1, meta_window_get_id (_tmp33_));
								} else {
									_tmp31_ = FALSE;
								}
								_tmp21_ = _tmp31_;
							}
							if (_tmp21_) {
								MetaWindowActor* actor = NULL;
								MetaWindow* _tmp35_;
								GObject* _tmp36_;
								MetaWindowActor* _tmp37_;
								_tmp35_ = window;
								_tmp36_ = meta_window_get_compositor_private (_tmp35_);
								actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, meta_window_actor_get_type (), MetaWindowActor);
								_tmp37_ = actor;
								clutter_actor_hide ((ClutterActor*) _tmp37_);
								continue;
							}
							_tmp39_ = window;
							g_object_get (_tmp39_, "on-all-workspaces", &_tmp40_, NULL);
							_tmp41_ = _tmp40_;
							if (_tmp41_) {
								MetaWindow* _tmp42_;
								MetaWorkspace* _tmp43_;
								MetaWorkspace* _tmp44_;
								_tmp42_ = window;
								_tmp43_ = meta_window_get_workspace (_tmp42_);
								_tmp44_ = workspace;
								_tmp38_ = _tmp43_ != _tmp44_;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								continue;
							}
							_tmp45_ = window;
							_tmp46_ = _g_object_ref0 (_tmp45_);
							windows = g_list_append (windows, _tmp46_);
						}
					}
					(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
				}
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp47_ = windows;
	if (vala_g_list_is_empty (_tmp47_)) {
		(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
		_tmp7_ = (g_free (_tmp7_), NULL);
		return;
	}
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp48_ = self->priv->_wm;
	_tmp49_ = gala_window_manager_push_modal (_tmp48_, (ClutterActor*) self, TRUE);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp49_;
	_tmp50_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp50_, _gala_window_overview_keybinding_filter_gala_keybinding_filter, self);
	_tmp51_ = self->priv->modal_proxy;
	_tmp52_ = g_new0 (GalaGestureAction, 1);
	_tmp52_[0] = GALA_GESTURE_ACTION_ZOOM;
	_tmp53_ = _tmp52_;
	_tmp53__length1 = 1;
	gala_modal_proxy_allow_actions (_tmp51_, _tmp53_, (gint) 1);
	_tmp53_ = (g_free (_tmp53_), NULL);
	_tmp54_ = self->priv->_wm;
	_tmp55_ = meta_plugin_get_display ((MetaPlugin*) _tmp54_);
	display = _tmp55_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp56_ = FALSE;
			_tmp56_ = TRUE;
			while (TRUE) {
				MetaDisplay* _tmp58_;
				MtkRectangle geometry = {0};
				MetaDisplay* _tmp59_;
				MtkRectangle _tmp60_ = {0};
				gfloat scale = 0.0F;
				MetaDisplay* _tmp61_;
				GtkCustomFilter* custom_filter = NULL;
				GtkCustomFilter* _tmp62_;
				GalaWindowListModel* model = NULL;
				MetaDisplay* _tmp63_;
				GtkCustomFilter* _tmp64_;
				GalaWindowListModel* _tmp65_;
				GalaWindowListModel* _tmp66_;
				GalaWindowManager* _tmp67_;
				GalaWindowListModel* _tmp68_;
				MtkRectangle _tmp69_;
				MtkRectangle _tmp70_;
				MtkRectangle _tmp71_;
				MtkRectangle _tmp72_;
				GalaWindowCloneContainer* _tmp73_ = NULL;
				GalaWindowCloneContainer* _tmp74_;
				GalaWindowCloneContainer* _tmp75_;
				GalaWindowCloneContainer* _tmp76_;
				if (!_tmp56_) {
					gint _tmp57_;
					_tmp57_ = i;
					i = _tmp57_ + 1;
				}
				_tmp56_ = FALSE;
				_tmp58_ = display;
				if (!(i < meta_display_get_n_monitors (_tmp58_))) {
					break;
				}
				_tmp59_ = display;
				meta_display_get_monitor_geometry (_tmp59_, i, &_tmp60_);
				geometry = _tmp60_;
				_tmp61_ = display;
				scale = meta_display_get_monitor_scale (_tmp61_, i);
				_tmp62_ = gtk_custom_filter_new (_gala_window_overview_window_filter_func_gtk_custom_filter_func, g_object_ref (self), g_object_unref);
				custom_filter = _tmp62_;
				_tmp63_ = display;
				_tmp64_ = custom_filter;
				_tmp65_ = gala_window_list_model_new (_tmp63_, GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING, TRUE, i, NULL, (GtkFilter*) _tmp64_);
				model = _tmp65_;
				_tmp66_ = model;
				g_signal_connect_object ((GListModel*) _tmp66_, "items-changed", (GCallback) _gala_window_overview_on_items_changed_g_list_model_items_changed, self, 0);
				_tmp67_ = self->priv->_wm;
				_tmp68_ = model;
				_tmp69_ = geometry;
				_tmp70_ = geometry;
				_tmp71_ = geometry;
				_tmp72_ = geometry;
				_tmp73_ = gala_window_clone_container_new (_tmp67_, _tmp68_, scale, TRUE);
				gala_window_clone_container_set_padding_top (_tmp73_, GALA_WINDOW_OVERVIEW_TOP_GAP);
				gala_window_clone_container_set_padding_left (_tmp73_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_right (_tmp73_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_bottom (_tmp73_, GALA_WINDOW_OVERVIEW_BOTTOM_GAP);
				clutter_actor_set_width ((ClutterActor*) _tmp73_, (gfloat) _tmp69_.width);
				clutter_actor_set_height ((ClutterActor*) _tmp73_, (gfloat) _tmp70_.height);
				clutter_actor_set_x ((ClutterActor*) _tmp73_, (gfloat) _tmp71_.x);
				clutter_actor_set_y ((ClutterActor*) _tmp73_, (gfloat) _tmp72_.y);
				g_object_ref_sink (_tmp73_);
				_g_object_unref0 (self->priv->window_clone_container);
				self->priv->window_clone_container = _tmp73_;
				_tmp74_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp74_, "window-selected", (GCallback) _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected, self, 0);
				_tmp75_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp75_, "requested-close", (GCallback) ______lambda115__gala_window_clone_container_requested_close, self, 0);
				_tmp76_ = self->priv->window_clone_container;
				clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp76_);
				_g_object_unref0 (model);
				_g_object_unref0 (custom_filter);
			}
		}
	}
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	_tmp77_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp77_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindowActor* actor = NULL;
				MetaWindow* _tmp78_;
				GObject* _tmp79_;
				MetaWindowActor* _tmp80_;
				_tmp78_ = window;
				_tmp79_ = meta_window_get_compositor_private (_tmp78_);
				actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, meta_window_actor_get_type (), MetaWindowActor);
				_tmp80_ = actor;
				clutter_actor_hide ((ClutterActor*) _tmp80_);
			}
		}
	}
	_tmp81_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp81_, (gdouble) 1);
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
}

static gboolean
gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                        MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp1_ = meta_key_binding_get_name (binding);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("expose-all-windows")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gala_window_overview_window_filter_func (GalaWindowOverview* self,
                                         GObject* obj)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint64* _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (obj != NULL, FALSE);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (obj, meta_window_get_type ()), "obj is Meta.Window", FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, meta_window_get_type (), MetaWindow));
	window = _tmp0_;
	_tmp2_ = self->priv->window_ids;
	_tmp2__length1 = self->priv->window_ids_length1;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		MetaWindow* _tmp3_;
		guint64* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = window;
		_tmp4_ = self->priv->window_ids;
		_tmp4__length1 = self->priv->window_ids_length1;
		_tmp1_ = _vala_uint64_array_contains (_tmp4_, _tmp4__length1, meta_window_get_id (_tmp3_));
	}
	result = _tmp1_;
	_g_object_unref0 (window);
	return result;
}

static void
gala_window_overview_on_items_changed (GalaWindowOverview* self,
                                       GListModel* model,
                                       guint pos,
                                       guint removed,
                                       guint added)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	if (gala_activatable_component_is_opened ((GalaActivatableComponent*) self)) {
		_tmp1_ = removed > added;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = g_list_model_get_n_items (model) == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
}

static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		GalaWindowOverview* self;
		self = _data58_->self;
		_g_object_unref0 (_data58_->window);
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static gboolean
___lambda114_ (Block58Data* _data58_)
{
	GalaWindowOverview* self;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gboolean result;
	self = _data58_->self;
	_tmp0_ = meta_window_get_workspace (_data58_->window);
	_tmp1_ = meta_window_get_display (_data58_->window);
	meta_workspace_activate_with_focus (_tmp0_, _data58_->window, meta_display_get_current_time (_tmp1_));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda114__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda114_ (self);
	return result;
}

static void
gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                     MetaWindow* window)
{
	Block58Data* _data58_;
	MetaWindow* _tmp0_;
	MetaWorkspace* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_data58_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data58_->window);
	_data58_->window = _tmp0_;
	_tmp1_ = meta_window_get_workspace (_data58_->window);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	if (_tmp1_ == _tmp5_) {
		MetaDisplay* _tmp6_;
		_tmp6_ = meta_window_get_display (_data58_->window);
		meta_window_activate (_data58_->window, meta_display_get_current_time (_tmp6_));
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	} else {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION, ____lambda114__gsource_func, block58_data_ref (_data58_), block58_data_unref);
	}
	block58_data_unref (_data58_);
	_data58_ = NULL;
}

/**
     * {@inheritDoc}
     */
static gboolean
__lambda113_ (GalaWindowOverview* self)
{
	gboolean result;
	gala_window_overview_cleanup (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda113__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda113_ ((GalaWindowOverview*) self);
	return result;
}

static void
gala_window_overview_real_close (GalaActivatableComponent* base,
                                 GHashTable* hints)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GalaGestureController* _tmp2_;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	clutter_threads_add_timeout ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION, ___lambda113__gsource_func, self);
	_tmp2_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp2_, (gdouble) 0);
}

static void
gala_window_overview_cleanup (GalaWindowOverview* self)
{
	GalaWindowManager* _tmp0_;
	GalaModalProxy* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = self->priv->modal_proxy;
	gala_window_manager_pop_modal (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	_tmp6_ = meta_workspace_list_windows (_tmp5_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp6_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp7_;
				_tmp7_ = window;
				if (meta_window_showing_on_its_workspace (_tmp7_)) {
					MetaWindow* _tmp8_;
					GObject* _tmp9_;
					_tmp8_ = window;
					_tmp9_ = meta_window_get_compositor_private (_tmp8_);
					clutter_actor_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, clutter_actor_get_type (), ClutterActor));
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	clutter_actor_destroy_all_children ((ClutterActor*) self);
}

static ClutterActor*
gala_window_overview_real_get_actor (GalaRootTarget* base)
{
	ClutterActor* result;
	GalaWindowOverview* self;
	self = (GalaWindowOverview*) base;
	result = (ClutterActor*) self;
	return result;
}

GalaWindowManager*
gala_window_overview_get_wm (GalaWindowOverview* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_overview_set_wm (GalaWindowOverview* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_overview_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY]);
	}
}

static GObject *
gala_window_overview_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowOverview * self;
	GalaWindowManager* _tmp0_;
	GalaGestureController* _tmp1_ = NULL;
	GalaGestureController* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_window_overview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, _tmp0_, GALA_GESTURE_CONTROLLER_GROUP_NONE);
	gala_gesture_controller_set_enabled (_tmp1_, FALSE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp1_;
	_tmp2_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp2_);
	return obj;
}

static void
gala_window_overview_class_init (GalaWindowOverviewClass * klass,
                                 gpointer klass_data)
{
	gala_window_overview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowOverview_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_overview_real_key_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_overview_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_overview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_overview_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_overview_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_overview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_OVERVIEW_ACTOR_PROPERTY, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_OVERVIEW_WM_PROPERTY, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_overview_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_window_overview_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_actor = gala_window_overview_real_get_actor;
}

static void
gala_window_overview_gala_activatable_component_interface_init (GalaActivatableComponentIface * iface,
                                                                gpointer iface_data)
{
	gala_window_overview_gala_activatable_component_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_opened = (gboolean (*) (GalaActivatableComponent*)) gala_window_overview_real_is_opened;
	iface->open = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_open;
	iface->close = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_close;
}

static void
gala_window_overview_instance_init (GalaWindowOverview * self,
                                    gpointer klass)
{
	self->priv = gala_window_overview_get_instance_private (self);
	self->priv->window_ids = NULL;
	self->priv->window_ids_length1 = 0;
	self->priv->_window_ids_size_ = self->priv->window_ids_length1;
}

static void
gala_window_overview_finalize (GObject * obj)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->modal_proxy);
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	_g_object_unref0 (self->priv->window_clone_container);
	self->priv->window_ids = (g_free (self->priv->window_ids), NULL);
	G_OBJECT_CLASS (gala_window_overview_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_window_overview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowOverviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_overview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowOverview), 0, (GInstanceInitFunc) gala_window_overview_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_window_overview_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gala_activatable_component_info = { (GInterfaceInitFunc) gala_window_overview_gala_activatable_component_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_overview_type_id;
	gala_window_overview_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWindowOverview", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_overview_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	g_type_add_interface_static (gala_window_overview_type_id, GALA_TYPE_ACTIVATABLE_COMPONENT, &gala_activatable_component_info);
	GalaWindowOverview_private_offset = g_type_add_instance_private (gala_window_overview_type_id, sizeof (GalaWindowOverviewPrivate));
	return gala_window_overview_type_id;
}

GType
gala_window_overview_get_type (void)
{
	static gsize gala_window_overview_type_id__once = 0;
	if (g_once_init_enter (&gala_window_overview_type_id__once)) {
		GType gala_window_overview_type_id;
		gala_window_overview_type_id = gala_window_overview_get_type_once ();
		g_once_init_leave (&gala_window_overview_type_id__once, gala_window_overview_type_id);
	}
	return gala_window_overview_type_id__once;
}

static void
_vala_gala_window_overview_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_ACTOR_PROPERTY:
		g_value_set_object (value, gala_root_target_get_actor ((GalaRootTarget*) self));
		break;
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		g_value_set_object (value, gala_window_overview_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_overview_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		gala_window_overview_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

