
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in AttachEnginePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Attacher;

/// Type structure of AttachEnginePy
PyTypeObject AttachEnginePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Attacher.AttachEngine",     /*tp_name*/
    sizeof(AttachEnginePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "AttachEngine abstract class - the functionality of AttachableObject, but outside of DocumentObject",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Attacher::AttachEnginePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Attacher::AttachEnginePy::GetterSetter,                     /*tp_getset */
    &Base::BaseClassPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Attacher::AttachEnginePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of AttachEnginePy
PyMethodDef AttachEnginePy::Methods[] = {
    {"getModeInfo",
        reinterpret_cast<PyCFunction>( staticCallback_getModeInfo ),
        METH_VARARGS,
        "getModeInfo(mode): returns supported reference combinations, user-friendly name, and so on."
    },
    {"getRefTypeOfShape",
        reinterpret_cast<PyCFunction>( staticCallback_getRefTypeOfShape ),
        METH_VARARGS,
        "getRefTypeOfShape(shape): returns shape type as interpreted by AttachEngine. Returns a string."
    },
    {"isFittingRefType",
        reinterpret_cast<PyCFunction>( staticCallback_isFittingRefType ),
        METH_VARARGS,
        "isFittingRefType(type_shape, type_needed): tests if shape type, specified by type_shape (string), fits a type required by attachment mode type_needed (string). e.g. 'Circle' fits a requirement of 'Edge', and 'Curve' doesn't fit if a 'Circle' is required."
    },
    {"downgradeRefType",
        reinterpret_cast<PyCFunction>( staticCallback_downgradeRefType ),
        METH_VARARGS,
        "downgradeRefType(type): returns next more general type. E.g. downgradeType('Circle') yields 'Curve'."
    },
    {"getRefTypeInfo",
        reinterpret_cast<PyCFunction>( staticCallback_getRefTypeInfo ),
        METH_VARARGS,
        "getRefTypeInfo(type): returns information (dict) on shape type. Keys:'UserFriendlyName', 'TypeIndex', 'Rank'. Rank is the number of times reftype can be downgraded, before it becomes 'Any'."
    },
    {"copy",
        reinterpret_cast<PyCFunction>( staticCallback_copy ),
        METH_VARARGS,
        "copy(): returns a new instance of AttachEngine."
    },
    {"calculateAttachedPlacement",
        reinterpret_cast<PyCFunction>( staticCallback_calculateAttachedPlacement ),
        METH_VARARGS,
        "calculateAttachedPlacement(orig_placement): returns result of attachment, based\n"
        "on current Mode, References, etc. AttachmentOffset is included.\n"
        "\n"
        "original_placement is the previous placement of the object being attached. It\n"
        "is used to preserve orientation for Translate attachment mode. For other modes,\n"
        "it is ignored.\n"
        "\n"
        "Returns the new placement. If not attached, returns None. If attachment fails,\n"
        "an exception is raised."
    },
    {"suggestModes",
        reinterpret_cast<PyCFunction>( staticCallback_suggestModes ),
        METH_VARARGS,
        "suggestModes(): runs mode suggestion routine and returns a dictionary with\n"
        "results and supplementary information.\n"
        "\n"
        "Keys:\n"
        "'allApplicableModes': list of modes that can accept current references. Note\n"
        "that it is only a check by types, and does not guarantee the modes will\n"
        "actually work.\n"
        "\n"
        "'bestFitMode': mode that fits current references best. Note that the mode may\n"
        "not be valid for the set of references; check for if 'message' is 'OK'.\n"
        "\n"
        "'error': error message for when 'message' is 'UnexpectedError' or\n"
        "'LinkBroken'.\n"
        "\n"
        "'message': general result of suggestion. 'IncompatibleGeometry', 'NoModesFit':\n"
        "no modes accept current set of references; 'OK': some modes do accept current\n"
        "set of references (though it's not guarantted the modes will work - surrestor\n"
        "only checks for correct types); 'UnexpectedError': should never happen.\n"
        "\n"
        "'nextRefTypeHint': what more can be added to references to reach other modes\n"
        "('reachableModes' provide more extended information on this)\n"
        "\n"
        "'reachableModes': a dict, where key is mode, and value is a list of sequences\n"
        "of references that can be added to fit that mode.\n"
        "\n"
        "'references_Types': a list of types of geometry linked by references (that's\n"
        "the input information for suggestor, actually)."
    },
    {"readParametersFromFeature",
        reinterpret_cast<PyCFunction>( staticCallback_readParametersFromFeature ),
        METH_VARARGS,
        "readParametersFromFeature(document_object): sets AttachEngine parameters (References, Mode, etc.) by reading out properties of AttachableObject-derived feature."
    },
    {"writeParametersToFeature",
        reinterpret_cast<PyCFunction>( staticCallback_writeParametersToFeature ),
        METH_VARARGS,
        "writeParametersToFeature(document_object): updates properties of\n"
        "AttachableObject-derived feature with current AttachEngine parameters\n"
        "(References, Mode, etc.).\n"
        "\n"
        "Warning: if a feature linked by AttachEngine.References was deleted, this method\n"
        "will crash FreeCAD."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of AttachEnginePy
PyGetSetDef AttachEnginePy::GetterSetter[] = {
    {"AttacherType",
        (getter) staticCallback_getAttacherType,
        (setter) staticCallback_setAttacherType,
        "Type of engine: 3d, plane, line, or point.",
        nullptr
    },
    {"Mode",
        (getter) staticCallback_getMode,
        (setter) staticCallback_setMode,
        "Current attachment mode.",
        nullptr
    },
    {"References",
        (getter) staticCallback_getReferences,
        (setter) staticCallback_setReferences,
        "Current attachment mode.",
        nullptr
    },
    {"AttachmentOffset",
        (getter) staticCallback_getAttachmentOffset,
        (setter) staticCallback_setAttachmentOffset,
        "Current attachment mode.",
        nullptr
    },
    {"Reverse",
        (getter) staticCallback_getReverse,
        (setter) staticCallback_setReverse,
        "If True, Z axis of attached placement is flipped. X axis is flipped in addition (CS has to remain right-handed).",
        nullptr
    },
    {"Parameter",
        (getter) staticCallback_getParameter,
        (setter) staticCallback_setParameter,
        "Value of parameter for some curve attachment modes. Range of 0..1 spans the length of the edge (parameter value can be outside of the range for curves that allow extrapolation.",
        nullptr
    },
    {"CompleteModeList",
        (getter) staticCallback_getCompleteModeList,
        (setter) staticCallback_setCompleteModeList,
        "List of all attachment modes of all AttachEngines. This is the list of modes in MapMode enum properties of AttachableObjects.",
        nullptr
    },
    {"ImplementedModes",
        (getter) staticCallback_getImplementedModes,
        (setter) staticCallback_setImplementedModes,
        "List of all attachment modes of all AttachEngines. This is the list of modes in MapMode enum properties of AttachableObjects.",
        nullptr
    },
    {"CompleteRefTypeList",
        (getter) staticCallback_getCompleteRefTypeList,
        (setter) staticCallback_setCompleteRefTypeList,
        "List of all reference shape types recognized by AttachEngine.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// getModeInfo() callback and implementer
// PyObject*  AttachEnginePy::getModeInfo(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getModeInfo (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getModeInfo' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->getModeInfo(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getRefTypeOfShape() callback and implementer
// PyObject*  AttachEnginePy::getRefTypeOfShape(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getRefTypeOfShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getRefTypeOfShape' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->getRefTypeOfShape(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isFittingRefType() callback and implementer
// PyObject*  AttachEnginePy::isFittingRefType(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_isFittingRefType (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isFittingRefType' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->isFittingRefType(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// downgradeRefType() callback and implementer
// PyObject*  AttachEnginePy::downgradeRefType(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_downgradeRefType (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'downgradeRefType' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->downgradeRefType(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getRefTypeInfo() callback and implementer
// PyObject*  AttachEnginePy::getRefTypeInfo(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getRefTypeInfo (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getRefTypeInfo' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->getRefTypeInfo(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// copy() callback and implementer
// PyObject*  AttachEnginePy::copy(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_copy (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'copy' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->copy(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// calculateAttachedPlacement() callback and implementer
// PyObject*  AttachEnginePy::calculateAttachedPlacement(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_calculateAttachedPlacement (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'calculateAttachedPlacement' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->calculateAttachedPlacement(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// suggestModes() callback and implementer
// PyObject*  AttachEnginePy::suggestModes(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_suggestModes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'suggestModes' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->suggestModes(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// readParametersFromFeature() callback and implementer
// PyObject*  AttachEnginePy::readParametersFromFeature(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_readParametersFromFeature (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'readParametersFromFeature' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->readParametersFromFeature(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// writeParametersToFeature() callback and implementer
// PyObject*  AttachEnginePy::writeParametersToFeature(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_writeParametersToFeature (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'writeParametersToFeature' of 'Attacher.AttachEngine' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<AttachEnginePy*>(self)->writeParametersToFeature(args);
        if (ret != nullptr)
            static_cast<AttachEnginePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// AttacherType() callback and implementer
// PyObject*  AttachEnginePy::AttacherType(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getAttacherType (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getAttacherType());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AttacherType' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setAttacherType (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AttacherType' of object 'AttachEngine' is read-only");
    return -1;
}

// Mode() callback and implementer
// PyObject*  AttachEnginePy::Mode(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getMode (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getMode());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Mode' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setMode (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<AttachEnginePy*>(self)->setMode(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Mode' of object 'AttachEngine'");
        return -1;
    }
}

// References() callback and implementer
// PyObject*  AttachEnginePy::References(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getReferences (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getReferences());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'References' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setReferences (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<AttachEnginePy*>(self)->setReferences(Py::Object(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'References' of object 'AttachEngine'");
        return -1;
    }
}

// AttachmentOffset() callback and implementer
// PyObject*  AttachEnginePy::AttachmentOffset(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getAttachmentOffset (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getAttachmentOffset());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AttachmentOffset' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setAttachmentOffset (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<AttachEnginePy*>(self)->setAttachmentOffset(Py::Object(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'AttachmentOffset' of object 'AttachEngine'");
        return -1;
    }
}

// Reverse() callback and implementer
// PyObject*  AttachEnginePy::Reverse(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getReverse (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getReverse());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Reverse' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setReverse (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<AttachEnginePy*>(self)->setReverse(Py::Boolean(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Reverse' of object 'AttachEngine'");
        return -1;
    }
}

// Parameter() callback and implementer
// PyObject*  AttachEnginePy::Parameter(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Parameter' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setParameter (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<AttachEnginePy*>(self)->setParameter(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Parameter' of object 'AttachEngine'");
        return -1;
    }
}

// CompleteModeList() callback and implementer
// PyObject*  AttachEnginePy::CompleteModeList(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getCompleteModeList (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getCompleteModeList());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CompleteModeList' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setCompleteModeList (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CompleteModeList' of object 'AttachEngine' is read-only");
    return -1;
}

// ImplementedModes() callback and implementer
// PyObject*  AttachEnginePy::ImplementedModes(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getImplementedModes (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getImplementedModes());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ImplementedModes' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setImplementedModes (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ImplementedModes' of object 'AttachEngine' is read-only");
    return -1;
}

// CompleteRefTypeList() callback and implementer
// PyObject*  AttachEnginePy::CompleteRefTypeList(PyObject *args){};
// has to be implemented in AttachEnginePyImp.cpp
PyObject * AttachEnginePy::staticCallback_getCompleteRefTypeList (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<AttachEnginePy*>(self)->getCompleteRefTypeList());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CompleteRefTypeList' of object 'AttachEngine'");
        return nullptr;
    }
}

int AttachEnginePy::staticCallback_setCompleteRefTypeList (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CompleteRefTypeList' of object 'AttachEngine' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
AttachEnginePy::AttachEnginePy(AttachEngine *pcObject, PyTypeObject *T)
    : BaseClassPy(static_cast<BaseClassPy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
AttachEnginePy::~AttachEnginePy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    AttachEnginePy::PointerType ptr = static_cast<AttachEnginePy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// AttachEnginePy representation
//--------------------------------------------------------------------------
PyObject *AttachEnginePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// AttachEnginePy Attributes
//--------------------------------------------------------------------------
PyObject *AttachEnginePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return BaseClassPy::_getattr(attr);
}

int AttachEnginePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return BaseClassPy::_setattr(attr, value);
}

AttachEngine *AttachEnginePy::getAttachEnginePtr() const
{
    return static_cast<AttachEngine *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in AttachEnginePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *AttachEnginePy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of AttachEnginePy and the Twin object
    return new AttachEnginePy(new AttachEngine);
}

// constructor method
int AttachEnginePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string AttachEnginePy::representation() const
{
    return {"<AttachEngine object>"};
}

PyObject* AttachEnginePy::getModeInfo(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::getRefTypeOfShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::isFittingRefType(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::downgradeRefType(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::getRefTypeInfo(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::copy(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::calculateAttachedPlacement(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::suggestModes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::readParametersFromFeature(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* AttachEnginePy::writeParametersToFeature(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::String AttachEnginePy::getAttacherType() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String AttachEnginePy::getMode() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  AttachEnginePy::setMode(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object AttachEnginePy::getReferences() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

void  AttachEnginePy::setReferences(Py::Object arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object AttachEnginePy::getAttachmentOffset() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

void  AttachEnginePy::setAttachmentOffset(Py::Object arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean AttachEnginePy::getReverse() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

void  AttachEnginePy::setReverse(Py::Boolean arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float AttachEnginePy::getParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  AttachEnginePy::setParameter(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List AttachEnginePy::getCompleteModeList() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List AttachEnginePy::getImplementedModes() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List AttachEnginePy::getCompleteRefTypeList() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *AttachEnginePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int AttachEnginePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



