
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "passwordentry_wrapper.h"

// Argument includes
#include <passwordmanager.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PasswordEntry_Type = nullptr;
static PyTypeObject *Sbk_PasswordEntry_TypeF(void)
{
    return _Sbk_PasswordEntry_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PasswordEntry_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PasswordEntry >()))
        return -1;

    ::PasswordEntry *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "PasswordEntry", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: PasswordEntry::PasswordEntry()
    // 1: PasswordEntry::PasswordEntry(PasswordEntry)
    if (numArgs == 0) {
        overloadId = 0; // PasswordEntry()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PasswordEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // PasswordEntry()
        {

            // PasswordEntry()
            cptr = new ::PasswordEntry();
            break;
        }
        case 1: // PasswordEntry(const PasswordEntry &PasswordEntry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::PasswordEntry cppArg0_local;
            ::PasswordEntry *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // PasswordEntry(PasswordEntry)
                cptr = new ::PasswordEntry(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PasswordEntry >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_PasswordEntryFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::PasswordEntry *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordEntry__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_PasswordEntry_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PasswordEntry_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_PasswordEntryFunc_isValid), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_PasswordEntry__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_PasswordEntry_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
                // operator<(const PasswordEntry &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::PasswordEntry cppArg0_local;
                ::PasswordEntry *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf < (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                return Shiboken::returnFromRichCompare(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
                // operator==(const PasswordEntry &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::PasswordEntry cppArg0_local;
                ::PasswordEntry *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

static PyObject *Sbk_PasswordEntry_get_id(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppSelf->id);
}
static int Sbk_PasswordEntry_set_id(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("id");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("id", "QVariant");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->id;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_host(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->host);
}
static int Sbk_PasswordEntry_set_host(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("host");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("host", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->host;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_username(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->username);
}
static int Sbk_PasswordEntry_set_username(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("username");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("username", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->username;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_password(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->password);
}
static int Sbk_PasswordEntry_set_password(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("password");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("password", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->password;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_data(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->data), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->data), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_PasswordEntry_set_data(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("data");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("data", "QByteArray");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->data;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_updated(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->updated;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_PasswordEntry_set_updated(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("updated");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("updated", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->updated;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->updated = cppOut_local;

    return 0;
}

// Getters and Setters for PasswordEntry
static PyGetSetDef Sbk_PasswordEntry_getsetlist[] = {
    {"id", Sbk_PasswordEntry_get_id, Sbk_PasswordEntry_set_id, "QVariant", nullptr},
    {"host", Sbk_PasswordEntry_get_host, Sbk_PasswordEntry_set_host, "QString", nullptr},
    {"username", Sbk_PasswordEntry_get_username, Sbk_PasswordEntry_set_username, "QString", nullptr},
    {"password", Sbk_PasswordEntry_get_password, Sbk_PasswordEntry_set_password, "QString", nullptr},
    {"data", Sbk_PasswordEntry_get_data, Sbk_PasswordEntry_set_data, "PySide6.QtCore.QByteArray", nullptr},
    {"updated", Sbk_PasswordEntry_get_updated, Sbk_PasswordEntry_set_updated, "int", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_PasswordEntry_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PasswordEntry_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PasswordEntry_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PasswordEntry_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PasswordEntry_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_PasswordEntry_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PasswordEntry_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_PasswordEntry_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PasswordEntry_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PasswordEntry_spec = {
    "1:PyFalkon.PasswordEntry",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PasswordEntry_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PasswordEntry_PythonToCpp_PasswordEntry_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PasswordEntry_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PasswordEntry_PythonToCpp_PasswordEntry_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PasswordEntry_TypeF()))
        return PasswordEntry_PythonToCpp_PasswordEntry_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PasswordEntry_PTR_CppToPython_PasswordEntry(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_PasswordEntry_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_PasswordEntry_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *PasswordEntry_COPY_CppToPython_PasswordEntry(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::PasswordEntry *>(cppIn);
    return Shiboken::Object::newObject(Sbk_PasswordEntry_TypeF(), new ::PasswordEntry(*source), true, true);
}

// Python to C++ copy conversion.
static void PasswordEntry_PythonToCpp_PasswordEntry_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::PasswordEntry *>(cppOut) = *reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PasswordEntry_PythonToCpp_PasswordEntry_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_PasswordEntry_TypeF()))
        return PasswordEntry_PythonToCpp_PasswordEntry_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PasswordEntry_SignatureStrings[] = {
    "1:PyFalkon.PasswordEntry(self)",
    "0:PyFalkon.PasswordEntry(self,PasswordEntry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordEntry.isValid(self)->bool",
    "PyFalkon.PasswordEntry.__copy__(self)->typing._Self",
    "PyFalkon.PasswordEntry.__lt__(self,other:PyFalkon.PasswordEntry)->bool",
    "PyFalkon.PasswordEntry.__eq__(self,other:PyFalkon.PasswordEntry)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t PasswordEntry_SignatureByteSize = 112;
static constexpr uint8_t PasswordEntry_SignatureBytes[112] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x48, 0x2c,
    0x2e, 0x2e, 0xcf, 0x2f, 0x4a, 0x71, 0xcd, 0x2b, 0x29, 0xaa, 0xd4, 0x28, 0x4e, 0xcd, 0x49, 0xd3,
    0xe4, 0x32, 0xc0, 0x27, 0xad, 0x83, 0x22, 0x84, 0x43, 0xa5, 0x26, 0x17, 0x76, 0x71, 0xbd, 0xcc,
    0xe2, 0xb0, 0xc4, 0x9c, 0xcc, 0x14, 0x88, 0x45, 0xba, 0x76, 0x49, 0xf9, 0xf9, 0x39, 0xb8, 0x94,
    0xc6, 0xc7, 0x27, 0xe7, 0x17, 0x54, 0xc6, 0xc7, 0xc3, 0xd4, 0x96, 0x54, 0x16, 0x64, 0xe6, 0xa5,
    0xeb, 0xc5, 0x07, 0x03, 0xb9, 0xb8, 0xf5, 0xe4, 0x94, 0x40, 0x75, 0xe8, 0xe4, 0x97, 0x64, 0xa4,
    0x16, 0xe1, 0x72, 0x1f, 0x21, 0xab, 0x53, 0x0b, 0x49, 0x31, 0x06, 0x00, 0x4f, 0xf7, 0x7d, 0x09
};
#endif

PyTypeObject *init_PasswordEntry(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX].type;

    Shiboken::AutoDecRef Sbk_PasswordEntry_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_PasswordEntry_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PasswordEntry",
        "PasswordEntry",
        &Sbk_PasswordEntry_spec,
        &Shiboken::callCppDestructor< ::PasswordEntry >,
        Sbk_PasswordEntry_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_PasswordEntry_Type; // references _Sbk_PasswordEntry_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PasswordEntry_SignatureStrings);
#else
    InitSignatureBytes(pyType, PasswordEntry_SignatureBytes, PasswordEntry_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PasswordEntry_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PasswordEntry_PythonToCpp_PasswordEntry_PTR,
        is_PasswordEntry_PythonToCpp_PasswordEntry_PTR_Convertible,
        PasswordEntry_PTR_CppToPython_PasswordEntry,
        PasswordEntry_COPY_CppToPython_PasswordEntry);

    Shiboken::Conversions::registerConverterName(converter, "PasswordEntry");
    Shiboken::Conversions::registerConverterName(converter, "PasswordEntry*");
    Shiboken::Conversions::registerConverterName(converter, "PasswordEntry&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordEntry).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PasswordEntry_PythonToCpp_PasswordEntry_COPY,
        is_PasswordEntry_PythonToCpp_PasswordEntry_COPY_Convertible);

    qRegisterMetaType< ::PasswordEntry >("PasswordEntry");

    return pyType;
}
