// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkF3DBitonicSortFunctions.h"

const char *vtkF3DBitonicSortFunctions =
"ivec2 disperse(uint h)\n"
"{\n"
"  uint t = gl_GlobalInvocationID.x;\n"
"  uint q = (t / h) * 2 * h;\n"
"\n"
"  uint x = q + t % h;\n"
"  uint y = q + t % h + h;\n"
"\n"
"  return ivec2(x, y);\n"
"}\n"
"\n"
"ivec2 flip(uint h)\n"
"{\n"
"  uint t = gl_GlobalInvocationID.x;\n"
"  uint q = (t / h) * 2 * h;\n"
"\n"
"  uint x = q + t % h;\n"
"  uint y = q + 2 * h - (t % h) - 1;\n"
"\n"
"  return ivec2(x, y);\n"
"}\n"
"\n"
"void swap_key(inout KeyType key1, inout KeyType key2)\n"
"{\n"
"  KeyType tmp = key1;\n"
"  key1 = key2;\n"
"  key2 = tmp;\n"
"}\n"
"\n"
"void swap_value(inout ValueType value1, inout ValueType value2)\n"
"{\n"
"  ValueType tmp = value1;\n"
"  value1 = value2;\n"
"  value2 = tmp;\n"
"}\n"
"\n"
"void compare_and_swap(ivec2 idx)\n"
"{\n"
"  if (key[idx.x] > key[idx.y] && idx.y < count)\n"
"  {\n"
"    swap_key(key[idx.x], key[idx.y]);\n"
"    swap_value(value[idx.x], value[idx.y]);\n"
"  }\n"
"}\n"
"";
