/* interactive-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from interactive-view.vala, do not modify */

/* This file is part of Elastic. License: GPL-3.0+.*/

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ELASTIC_TYPE_TRANSFORM_BIN (elastic_transform_bin_get_type ())
#define ELASTIC_TRANSFORM_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBin))
#define ELASTIC_TRANSFORM_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBinClass))
#define ELASTIC_IS_TRANSFORM_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_TRANSFORM_BIN))
#define ELASTIC_IS_TRANSFORM_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_TRANSFORM_BIN))
#define ELASTIC_TRANSFORM_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBinClass))

typedef struct _ElasticTransformBin ElasticTransformBin;
typedef struct _ElasticTransformBinClass ElasticTransformBinClass;
typedef struct _ElasticTransformBinPrivate ElasticTransformBinPrivate;

#define ELASTIC_TYPE_INTERACTIVE_VIEW (elastic_interactive_view_get_type ())
#define ELASTIC_INTERACTIVE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveView))
#define ELASTIC_INTERACTIVE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveViewClass))
#define ELASTIC_IS_INTERACTIVE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_INTERACTIVE_VIEW))
#define ELASTIC_IS_INTERACTIVE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_INTERACTIVE_VIEW))
#define ELASTIC_INTERACTIVE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveViewClass))

typedef struct _ElasticInteractiveView ElasticInteractiveView;
typedef struct _ElasticInteractiveViewClass ElasticInteractiveViewClass;
typedef struct _ElasticInteractiveViewPrivate ElasticInteractiveViewPrivate;

#define ELASTIC_TYPE_SPRING_PARAMS (elastic_spring_params_get_type ())
#define ELASTIC_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams))
#define ELASTIC_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))
#define ELASTIC_IS_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_IS_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_SPRING_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))

typedef struct _ElasticSpringParams ElasticSpringParams;
typedef struct _ElasticSpringParamsClass ElasticSpringParamsClass;
enum  {
	ELASTIC_INTERACTIVE_VIEW_0_PROPERTY,
	ELASTIC_INTERACTIVE_VIEW_SPRING_PROPERTY,
	ELASTIC_INTERACTIVE_VIEW_NUM_PROPERTIES
};
static GParamSpec* elastic_interactive_view_properties[ELASTIC_INTERACTIVE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))

struct _ElasticTransformBin {
	AdwBin parent_instance;
	ElasticTransformBinPrivate * priv;
};

struct _ElasticTransformBinClass {
	AdwBinClass parent_class;
};

struct _ElasticInteractiveView {
	ElasticTransformBin parent_instance;
	ElasticInteractiveViewPrivate * priv;
};

struct _ElasticInteractiveViewClass {
	ElasticTransformBinClass parent_class;
};

struct _ElasticInteractiveViewPrivate {
	ElasticSpringParams* _spring;
	GtkGesture* drag_gesture;
	GtkGesture* swipe_gesture;
	AdwSpringAnimation* animation_x;
	AdwSpringAnimation* animation_y;
	gdouble start_x;
	gdouble start_y;
	gdouble last_x;
	gdouble last_y;
};

static gint ElasticInteractiveView_private_offset;
static gpointer elastic_interactive_view_parent_class = NULL;

VALA_EXTERN GType elastic_transform_bin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticTransformBin, g_object_unref)
VALA_EXTERN GType elastic_interactive_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticInteractiveView, g_object_unref)
VALA_EXTERN GType elastic_spring_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticSpringParams, g_object_unref)
static void elastic_interactive_view_drag_begin_cb (ElasticInteractiveView* self,
                                             gdouble start_x,
                                             gdouble start_y);
static void elastic_interactive_view_set_translation (ElasticInteractiveView* self,
                                               gdouble x,
                                               gdouble y);
static void _elastic_interactive_view_drag_begin_cb_gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                                                          gdouble start_x,
                                                                          gdouble start_y,
                                                                          gpointer self);
static void elastic_interactive_view_drag_update_cb (ElasticInteractiveView* self,
                                              gdouble offset_x,
                                              gdouble offset_y);
static void _elastic_interactive_view_drag_update_cb_gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                                            gdouble offset_x,
                                                                            gdouble offset_y,
                                                                            gpointer self);
static void elastic_interactive_view_drag_cancel_cb (ElasticInteractiveView* self);
static void elastic_interactive_view_animate (ElasticInteractiveView* self,
                                       gdouble velocity_x,
                                       gdouble velocity_y);
static void _elastic_interactive_view_drag_cancel_cb_gtk_gesture_cancel (GtkGesture* _sender,
                                                                  GdkEventSequence* sequence,
                                                                  gpointer self);
VALA_EXTERN ElasticSpringParams* elastic_interactive_view_get_spring (ElasticInteractiveView* self);
VALA_EXTERN void elastic_spring_params_apply (ElasticSpringParams* self,
                                  AdwSpringAnimation* animation);
static void _elastic_interactive_view_animate_gtk_gesture_swipe_swipe (GtkGestureSwipe* _sender,
                                                                gdouble velocity_x,
                                                                gdouble velocity_y,
                                                                gpointer self);
VALA_EXTERN void elastic_transform_bin_set_transform (ElasticTransformBin* self,
                                          GskTransform* value);
static void elastic_interactive_view_reset_animation (ElasticInteractiveView* self);
static gboolean elastic_interactive_view_is_child_out_of_bounds (ElasticInteractiveView* self);
static void elastic_interactive_view_real_snapshot (GtkWidget* base,
                                             GtkSnapshot* snapshot);
static void elastic_interactive_view_real_unmap (GtkWidget* base);
VALA_EXTERN void elastic_interactive_view_snapshot_toplevel (ElasticInteractiveView* self,
                                                 GtkWidget* toplevel,
                                                 GtkSnapshot* snapshot);
VALA_EXTERN ElasticInteractiveView* elastic_interactive_view_new (void);
VALA_EXTERN ElasticInteractiveView* elastic_interactive_view_construct (GType object_type);
VALA_EXTERN ElasticTransformBin* elastic_transform_bin_new (void);
VALA_EXTERN ElasticTransformBin* elastic_transform_bin_construct (GType object_type);
VALA_EXTERN void elastic_interactive_view_set_spring (ElasticInteractiveView* self,
                                          ElasticSpringParams* value);
static void _elastic_interactive_view_reset_animation_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                                              gpointer self);
static GObject * elastic_interactive_view_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _elastic_interactive_view___lambda8_ (ElasticInteractiveView* self,
                                           gdouble value);
static void __elastic_interactive_view___lambda8__adw_animation_target_func (gdouble value,
                                                                      gpointer self);
static void _elastic_interactive_view___lambda9_ (ElasticInteractiveView* self,
                                           gdouble value);
static void __elastic_interactive_view___lambda9__adw_animation_target_func (gdouble value,
                                                                      gpointer self);
static void elastic_interactive_view_finalize (GObject * obj);
static GType elastic_interactive_view_get_type_once (void);
static void _vala_elastic_interactive_view_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_elastic_interactive_view_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
elastic_interactive_view_get_instance_private (ElasticInteractiveView* self)
{
	return G_STRUCT_MEMBER_P (self, ElasticInteractiveView_private_offset);
}

static void
elastic_interactive_view_drag_begin_cb (ElasticInteractiveView* self,
                                        gdouble start_x,
                                        gdouble start_y)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkGesture* _tmp4_;
	AdwSpringAnimation* _tmp5_;
	AdwSpringAnimation* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GdkCursor* _tmp9_;
	GdkCursor* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_pick ((GtkWidget*) self, start_x, start_y, GTK_PICK_DEFAULT);
	_tmp1_ = adw_bin_get_child ((AdwBin*) self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		GtkGesture* _tmp3_;
		_tmp3_ = self->priv->drag_gesture;
		gtk_gesture_set_state (_tmp3_, GTK_EVENT_SEQUENCE_DENIED);
		return;
	}
	_tmp4_ = self->priv->drag_gesture;
	gtk_gesture_set_state (_tmp4_, GTK_EVENT_SEQUENCE_CLAIMED);
	self->priv->start_x = self->priv->last_x;
	self->priv->start_y = self->priv->last_y;
	_tmp5_ = self->priv->animation_x;
	adw_animation_reset ((AdwAnimation*) _tmp5_);
	_tmp6_ = self->priv->animation_y;
	adw_animation_reset ((AdwAnimation*) _tmp6_);
	elastic_interactive_view_set_translation (self, self->priv->start_x, self->priv->start_y);
	_tmp7_ = adw_bin_get_child ((AdwBin*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gdk_cursor_new_from_name ("grabbing", NULL);
	_tmp10_ = _tmp9_;
	gtk_widget_set_cursor (_tmp8_, _tmp10_);
	_g_object_unref0 (_tmp10_);
}

static void
_elastic_interactive_view_drag_begin_cb_gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                                                     gdouble start_x,
                                                                     gdouble start_y,
                                                                     gpointer self)
{
	elastic_interactive_view_drag_begin_cb ((ElasticInteractiveView*) self, start_x, start_y);
}

static void
elastic_interactive_view_drag_update_cb (ElasticInteractiveView* self,
                                         gdouble offset_x,
                                         gdouble offset_y)
{
	g_return_if_fail (self != NULL);
	elastic_interactive_view_set_translation (self, offset_x + self->priv->start_x, offset_y + self->priv->start_y);
}

static void
_elastic_interactive_view_drag_update_cb_gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                                       gdouble offset_x,
                                                                       gdouble offset_y,
                                                                       gpointer self)
{
	elastic_interactive_view_drag_update_cb ((ElasticInteractiveView*) self, offset_x, offset_y);
}

static void
elastic_interactive_view_drag_cancel_cb (ElasticInteractiveView* self)
{
	g_return_if_fail (self != NULL);
	elastic_interactive_view_animate (self, (gdouble) 0, (gdouble) 0);
}

static void
_elastic_interactive_view_drag_cancel_cb_gtk_gesture_cancel (GtkGesture* _sender,
                                                             GdkEventSequence* sequence,
                                                             gpointer self)
{
	elastic_interactive_view_drag_cancel_cb ((ElasticInteractiveView*) self);
}

static void
elastic_interactive_view_animate (ElasticInteractiveView* self,
                                  gdouble velocity_x,
                                  gdouble velocity_y)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	ElasticSpringParams* _tmp4_;
	ElasticSpringParams* _tmp5_;
	AdwSpringAnimation* _tmp6_;
	ElasticSpringParams* _tmp7_;
	ElasticSpringParams* _tmp8_;
	AdwSpringAnimation* _tmp9_;
	AdwSpringAnimation* _tmp10_;
	AdwSpringAnimation* _tmp11_;
	AdwSpringAnimation* _tmp12_;
	AdwSpringAnimation* _tmp13_;
	AdwSpringAnimation* _tmp14_;
	AdwSpringAnimation* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = adw_bin_get_child ((AdwBin*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_cursor_new_from_name ("grab", NULL);
	_tmp3_ = _tmp2_;
	gtk_widget_set_cursor (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = elastic_interactive_view_get_spring (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->animation_x;
	elastic_spring_params_apply (_tmp5_, _tmp6_);
	_tmp7_ = elastic_interactive_view_get_spring (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->animation_y;
	elastic_spring_params_apply (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->animation_x;
	adw_spring_animation_set_value_from (_tmp10_, self->priv->last_x);
	_tmp11_ = self->priv->animation_y;
	adw_spring_animation_set_value_from (_tmp11_, self->priv->last_y);
	_tmp12_ = self->priv->animation_x;
	adw_spring_animation_set_initial_velocity (_tmp12_, velocity_x);
	_tmp13_ = self->priv->animation_y;
	adw_spring_animation_set_initial_velocity (_tmp13_, velocity_y);
	_tmp14_ = self->priv->animation_x;
	adw_animation_play ((AdwAnimation*) _tmp14_);
	_tmp15_ = self->priv->animation_y;
	adw_animation_play ((AdwAnimation*) _tmp15_);
}

static void
_elastic_interactive_view_animate_gtk_gesture_swipe_swipe (GtkGestureSwipe* _sender,
                                                           gdouble velocity_x,
                                                           gdouble velocity_y,
                                                           gpointer self)
{
	elastic_interactive_view_animate ((ElasticInteractiveView*) self, velocity_x, velocity_y);
}

static void
elastic_interactive_view_set_translation (ElasticInteractiveView* self,
                                          gdouble x,
                                          gdouble y)
{
	GskTransform* _tmp0_;
	graphene_point_t _tmp1_ = {0};
	GskTransform* _tmp2_;
	GskTransform* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->last_x = x;
	self->priv->last_y = y;
	_tmp0_ = gsk_transform_new ();
	_tmp1_.x = (gfloat) x;
	_tmp1_.y = (gfloat) y;
	_tmp2_ = gsk_transform_translate (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	elastic_transform_bin_set_transform ((ElasticTransformBin*) self, _tmp3_);
	_gsk_transform_unref0 (_tmp3_);
}

static void
elastic_interactive_view_reset_animation (ElasticInteractiveView* self)
{
	AdwSpringAnimation* _tmp0_;
	AdwSpringAnimation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animation_x;
	adw_animation_reset ((AdwAnimation*) _tmp0_);
	_tmp1_ = self->priv->animation_y;
	adw_animation_reset ((AdwAnimation*) _tmp1_);
	elastic_interactive_view_set_translation (self, (gdouble) 0, (gdouble) 0);
}

static gboolean
elastic_interactive_view_is_child_out_of_bounds (ElasticInteractiveView* self)
{
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble child_width = 0.0;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gdouble child_height = 0.0;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	width = (gdouble) gtk_widget_get_width ((GtkWidget*) self);
	height = (gdouble) gtk_widget_get_height ((GtkWidget*) self);
	_tmp0_ = adw_bin_get_child ((AdwBin*) self);
	_tmp1_ = _tmp0_;
	child_width = (gdouble) gtk_widget_get_width (_tmp1_);
	_tmp2_ = adw_bin_get_child ((AdwBin*) self);
	_tmp3_ = _tmp2_;
	child_height = (gdouble) gtk_widget_get_height (_tmp3_);
	if (self->priv->last_x < ((width - child_width) / -2)) {
		result = TRUE;
		return result;
	}
	if (self->priv->last_x > ((width - child_width) / 2)) {
		result = TRUE;
		return result;
	}
	if (self->priv->last_y < ((height - child_height) / -2)) {
		result = TRUE;
		return result;
	}
	if (self->priv->last_y > ((height - child_height) / 2)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
elastic_interactive_view_real_snapshot (GtkWidget* base,
                                        GtkSnapshot* snapshot)
{
	ElasticInteractiveView * self;
	self = (ElasticInteractiveView*) base;
	g_return_if_fail (snapshot != NULL);
	if (!elastic_interactive_view_is_child_out_of_bounds (self)) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		_tmp0_ = adw_bin_get_child ((AdwBin*) self);
		_tmp1_ = _tmp0_;
		gtk_widget_snapshot_child ((GtkWidget*) self, _tmp1_, snapshot);
	}
}

static void
elastic_interactive_view_real_unmap (GtkWidget* base)
{
	ElasticInteractiveView * self;
	self = (ElasticInteractiveView*) base;
	GTK_WIDGET_CLASS (elastic_interactive_view_parent_class)->unmap ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBin));
	elastic_interactive_view_reset_animation (self);
}

void
elastic_interactive_view_snapshot_toplevel (ElasticInteractiveView* self,
                                            GtkWidget* toplevel,
                                            GtkSnapshot* snapshot)
{
	graphene_matrix_t matrix = {0};
	graphene_matrix_t _tmp0_ = {0};
	gboolean _tmp1_;
	graphene_matrix_t _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toplevel != NULL);
	g_return_if_fail (snapshot != NULL);
	if (!elastic_interactive_view_is_child_out_of_bounds (self)) {
		return;
	}
	_tmp1_ = gtk_widget_compute_transform ((GtkWidget*) self, toplevel, &_tmp0_);
	matrix = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	gtk_snapshot_save (snapshot);
	_tmp2_ = matrix;
	gtk_snapshot_transform_matrix (snapshot, &_tmp2_);
	_tmp3_ = adw_bin_get_child ((AdwBin*) self);
	_tmp4_ = _tmp3_;
	gtk_widget_snapshot_child ((GtkWidget*) self, _tmp4_, snapshot);
	gtk_snapshot_restore (snapshot);
}

ElasticInteractiveView*
elastic_interactive_view_construct (GType object_type)
{
	ElasticInteractiveView * self = NULL;
	self = (ElasticInteractiveView*) elastic_transform_bin_construct (object_type);
	return self;
}

ElasticInteractiveView*
elastic_interactive_view_new (void)
{
	return elastic_interactive_view_construct (ELASTIC_TYPE_INTERACTIVE_VIEW);
}

ElasticSpringParams*
elastic_interactive_view_get_spring (ElasticInteractiveView* self)
{
	ElasticSpringParams* result;
	ElasticSpringParams* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spring;
	result = _tmp0_;
	return result;
}

static void
_elastic_interactive_view_reset_animation_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                                         gpointer self)
{
	elastic_interactive_view_reset_animation ((ElasticInteractiveView*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
elastic_interactive_view_set_spring (ElasticInteractiveView* self,
                                     ElasticSpringParams* value)
{
	ElasticSpringParams* _tmp0_;
	ElasticSpringParams* _tmp1_;
	ElasticSpringParams* _tmp2_;
	ElasticSpringParams* _tmp3_;
	ElasticSpringParams* _tmp7_;
	ElasticSpringParams* _tmp8_;
	ElasticSpringParams* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_interactive_view_get_spring (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_interactive_view_get_spring (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ElasticSpringParams* _tmp4_;
		ElasticSpringParams* _tmp5_;
		guint _tmp6_;
		_tmp4_ = elastic_interactive_view_get_spring (self);
		_tmp5_ = _tmp4_;
		g_signal_parse_name ("changed", ELASTIC_TYPE_SPRING_PARAMS, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _elastic_interactive_view_reset_animation_elastic_spring_params_changed, self);
	}
	_tmp7_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_spring);
	self->priv->_spring = _tmp7_;
	_tmp8_ = elastic_interactive_view_get_spring (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ElasticSpringParams* _tmp10_;
		ElasticSpringParams* _tmp11_;
		_tmp10_ = elastic_interactive_view_get_spring (self);
		_tmp11_ = _tmp10_;
		g_signal_connect_object (_tmp11_, "changed", (GCallback) _elastic_interactive_view_reset_animation_elastic_spring_params_changed, self, 0);
	}
	elastic_interactive_view_reset_animation (self);
	g_object_notify_by_pspec ((GObject *) self, elastic_interactive_view_properties[ELASTIC_INTERACTIVE_VIEW_SPRING_PROPERTY]);
}

static void
_elastic_interactive_view___lambda8_ (ElasticInteractiveView* self,
                                      gdouble value)
{
	AdwSpringAnimation* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	_tmp0_ = self->priv->animation_x;
	_tmp1_ = adw_animation_get_value ((AdwAnimation*) _tmp0_);
	_tmp2_ = _tmp1_;
	elastic_interactive_view_set_translation (self, _tmp2_, self->priv->last_y);
}

static void
__elastic_interactive_view___lambda8__adw_animation_target_func (gdouble value,
                                                                 gpointer self)
{
	_elastic_interactive_view___lambda8_ ((ElasticInteractiveView*) self, value);
}

static void
_elastic_interactive_view___lambda9_ (ElasticInteractiveView* self,
                                      gdouble value)
{
	AdwSpringAnimation* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	_tmp0_ = self->priv->animation_y;
	_tmp1_ = adw_animation_get_value ((AdwAnimation*) _tmp0_);
	_tmp2_ = _tmp1_;
	elastic_interactive_view_set_translation (self, self->priv->last_y, _tmp2_);
}

static void
__elastic_interactive_view___lambda9__adw_animation_target_func (gdouble value,
                                                                 gpointer self)
{
	_elastic_interactive_view___lambda9_ ((ElasticInteractiveView*) self, value);
}

static GObject *
elastic_interactive_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ElasticInteractiveView * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	GtkGesture* _tmp4_;
	GtkGesture* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	AdwSpringParams* _tmp8_;
	AdwCallbackAnimationTarget* _tmp9_;
	AdwSpringAnimation* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	AdwSpringParams* _tmp13_;
	AdwCallbackAnimationTarget* _tmp14_;
	AdwSpringAnimation* _tmp15_;
	AdwSpringAnimation* _tmp16_;
	AdwSpringAnimation* _tmp17_;
	parent_class = G_OBJECT_CLASS (elastic_interactive_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveView);
	_tmp0_ = adw_bin_get_child ((AdwBin*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_cursor_new_from_name ("grab", NULL);
	_tmp3_ = _tmp2_;
	gtk_widget_set_cursor (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->swipe_gesture;
	_tmp5_ = self->priv->drag_gesture;
	gtk_gesture_group (_tmp4_, _tmp5_);
	_tmp6_ = adw_bin_get_child ((AdwBin*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = adw_spring_params_new_full ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp9_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (__elastic_interactive_view___lambda8__adw_animation_target_func, g_object_ref (self), g_object_unref);
	_tmp10_ = (AdwSpringAnimation*) adw_spring_animation_new (_tmp7_, (gdouble) 0, (gdouble) 0, _tmp8_, (AdwAnimationTarget*) _tmp9_);
	_g_object_unref0 (self->priv->animation_x);
	self->priv->animation_x = _tmp10_;
	_tmp11_ = adw_bin_get_child ((AdwBin*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = adw_spring_params_new_full ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp14_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (__elastic_interactive_view___lambda9__adw_animation_target_func, g_object_ref (self), g_object_unref);
	_tmp15_ = (AdwSpringAnimation*) adw_spring_animation_new (_tmp12_, (gdouble) 0, (gdouble) 0, _tmp13_, (AdwAnimationTarget*) _tmp14_);
	_g_object_unref0 (self->priv->animation_y);
	self->priv->animation_y = _tmp15_;
	_tmp16_ = self->priv->animation_x;
	adw_animation_set_follow_enable_animations_setting ((AdwAnimation*) _tmp16_, FALSE);
	_tmp17_ = self->priv->animation_y;
	adw_animation_set_follow_enable_animations_setting ((AdwAnimation*) _tmp17_, FALSE);
	return obj;
}

static void
elastic_interactive_view_class_init (ElasticInteractiveViewClass * klass,
                                     gpointer klass_data)
{
	elastic_interactive_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ElasticInteractiveView_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) elastic_interactive_view_real_snapshot;
	((GtkWidgetClass *) klass)->unmap = (void (*) (GtkWidget*)) elastic_interactive_view_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = _vala_elastic_interactive_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_elastic_interactive_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = elastic_interactive_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = elastic_interactive_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_INTERACTIVE_VIEW_SPRING_PROPERTY, elastic_interactive_view_properties[ELASTIC_INTERACTIVE_VIEW_SPRING_PROPERTY] = g_param_spec_object ("spring", "spring", "spring", ELASTIC_TYPE_SPRING_PARAMS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/app/drey/Elastic/interactive-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "drag_gesture", FALSE, ElasticInteractiveView_private_offset + G_STRUCT_OFFSET (ElasticInteractiveViewPrivate, drag_gesture));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "swipe_gesture", FALSE, ElasticInteractiveView_private_offset + G_STRUCT_OFFSET (ElasticInteractiveViewPrivate, swipe_gesture));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "drag_begin_cb", G_CALLBACK(_elastic_interactive_view_drag_begin_cb_gtk_gesture_drag_drag_begin));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "drag_update_cb", G_CALLBACK(_elastic_interactive_view_drag_update_cb_gtk_gesture_drag_drag_update));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "drag_cancel_cb", G_CALLBACK(_elastic_interactive_view_drag_cancel_cb_gtk_gesture_cancel));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "animate", G_CALLBACK(_elastic_interactive_view_animate_gtk_gesture_swipe_swipe));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "interactive-view");
}

static void
elastic_interactive_view_instance_init (ElasticInteractiveView * self,
                                        gpointer klass)
{
	self->priv = elastic_interactive_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
elastic_interactive_view_finalize (GObject * obj)
{
	ElasticInteractiveView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveView);
	_g_object_unref0 (self->priv->_spring);
	_g_object_unref0 (self->priv->animation_x);
	_g_object_unref0 (self->priv->animation_y);
	G_OBJECT_CLASS (elastic_interactive_view_parent_class)->finalize (obj);
}

static GType
elastic_interactive_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ElasticInteractiveViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) elastic_interactive_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ElasticInteractiveView), 0, (GInstanceInitFunc) elastic_interactive_view_instance_init, NULL };
	GType elastic_interactive_view_type_id;
	elastic_interactive_view_type_id = g_type_register_static (ELASTIC_TYPE_TRANSFORM_BIN, "ElasticInteractiveView", &g_define_type_info, 0);
	ElasticInteractiveView_private_offset = g_type_add_instance_private (elastic_interactive_view_type_id, sizeof (ElasticInteractiveViewPrivate));
	return elastic_interactive_view_type_id;
}

GType
elastic_interactive_view_get_type (void)
{
	static volatile gsize elastic_interactive_view_type_id__once = 0;
	if (g_once_init_enter (&elastic_interactive_view_type_id__once)) {
		GType elastic_interactive_view_type_id;
		elastic_interactive_view_type_id = elastic_interactive_view_get_type_once ();
		g_once_init_leave (&elastic_interactive_view_type_id__once, elastic_interactive_view_type_id);
	}
	return elastic_interactive_view_type_id__once;
}

static void
_vala_elastic_interactive_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ElasticInteractiveView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveView);
	switch (property_id) {
		case ELASTIC_INTERACTIVE_VIEW_SPRING_PROPERTY:
		g_value_set_object (value, elastic_interactive_view_get_spring (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_elastic_interactive_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ElasticInteractiveView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_INTERACTIVE_VIEW, ElasticInteractiveView);
	switch (property_id) {
		case ELASTIC_INTERACTIVE_VIEW_SPRING_PROPERTY:
		elastic_interactive_view_set_spring (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

