// Code generated by smithy-go-codegen DO NOT EDIT.

package iam

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iam/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about a specific delegation request.
//
// If a delegation request has no owner or owner account, GetDelegationRequest for
// that delegation request can be called by any account. If the owner account is
// assigned but there is no owner id, only identities within that owner account can
// call GetDelegationRequest for the delegation request. Once the delegation
// request is fully owned, the owner of the request gets a default permission to
// get that delegation request. For more details, see [Managing Permissions for Delegation Requests].
//
// [Managing Permissions for Delegation Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies-temporary-delegation.html#temporary-delegation-managing-permissions
func (c *Client) GetDelegationRequest(ctx context.Context, params *GetDelegationRequestInput, optFns ...func(*Options)) (*GetDelegationRequestOutput, error) {
	if params == nil {
		params = &GetDelegationRequestInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDelegationRequest", params, optFns, c.addOperationGetDelegationRequestMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDelegationRequestOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDelegationRequestInput struct {

	// The unique identifier of the delegation request to retrieve.
	//
	// This member is required.
	DelegationRequestId *string

	// Specifies whether to perform a permission check for the delegation request.
	//
	// If set to true, the GetDelegationRequest API call will start a permission check
	// process. This process calculates whether the caller has sufficient permissions
	// to cover the asks from this delegation request.
	//
	// Setting this parameter to true does not guarantee an answer in the response.
	// See the PermissionCheckStatus and the PermissionCheckResult response attributes
	// for further details.
	DelegationPermissionCheck bool

	noSmithyDocumentSerde
}

type GetDelegationRequestOutput struct {

	// The delegation request object containing all details about the request.
	DelegationRequest *types.DelegationRequest

	// The result of the permission check, indicating whether the caller has
	// sufficient permissions to cover the requested permissions. This is an
	// approximate result.
	//
	//   - ALLOWED : The caller has sufficient permissions cover all the requested
	//   permissions.
	//
	//   - DENIED : The caller does not have sufficient permissions to cover all the
	//   requested permissions.
	//
	//   - UNSURE : It is not possible to determine whether the caller has all the
	//   permissions needed. This output is most likely for cases when the caller has
	//   permissions with conditions.
	PermissionCheckResult types.PermissionCheckResultType

	// The status of the permission check for the delegation request.
	//
	// This value indicates the status of the process to check whether the caller has
	// sufficient permissions to cover the requested actions in the delegation request.
	// Since this is an asynchronous process, there are three potential values:
	//
	//   - IN_PROGRESS : The permission check process has started.
	//
	//   - COMPLETED : The permission check process has completed. The
	//   PermissionCheckResult will include the result.
	//
	//   - FAILED : The permission check process has failed.
	PermissionCheckStatus types.PermissionCheckStatusType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDelegationRequestMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetDelegationRequest{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetDelegationRequest{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDelegationRequest"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDelegationRequestValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDelegationRequest(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDelegationRequest(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDelegationRequest",
	}
}
